/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.api.ExRsGoodsService;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.EditSkuDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsPntreeDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSkuOneDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSkuOneReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSpecDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ext.skshu.supbase.RsGoodsBaseService;
import com.yqbsoft.laser.service.ext.skshu.util.GoodsParamCheckUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExRsGoodsServiceImpl
extends RsGoodsBaseService
implements ExRsGoodsService {
    @Override
    public String sendSaveExGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (rsResourceGoodsDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkGoodsParam(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.msg");
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.msg", msg);
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeName())) {
            msg = this.checkPntree(rsResourceGoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.checkPntree.msg");
                return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.checkPntree.msg", msg);
            }
            this.makeGoodsSpec(rsResourceGoodsDomain);
        }
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) && StringUtils.isNotBlank((String)(msg = this.checkBrand(rsResourceGoodsDomain)))) {
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.checkBrand.msg", msg);
        }
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeName())) && StringUtils.isNotBlank((String)(msg = this.checkClassTree(rsResourceGoodsDomain)))) {
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.checkClassTree.msg", msg);
        }
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeShopcode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeShopname())) && StringUtils.isNotBlank((String)(msg = this.checkClassTreeShop(rsResourceGoodsDomain)))) {
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.checkClassTreeShop.msg", msg);
        }
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
        if (goodsDomain == null) {
            if (rsResourceGoodsDomain.getGoodsNum() == null) {
                rsResourceGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (rsResourceGoodsDomain.getPricesetNprice() == null) {
                rsResourceGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            rsResourceGoodsDomain.getRsSkuDomainList().stream().forEach(sku -> {
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)sku, (Object)rsResourceGoodsDomain);
                }
                catch (Exception e) {
                    this.logger.debug("busdata.RsGoodsBaseService.sendSaveExGoods", (Throwable)e);
                }
            });
            String goodsCode = this.saveEsResourceGoodsDomain(rsResourceGoodsDomain);
            return this.makeSuccessReturn(goodsCode);
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)goodsDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods", (Throwable)e);
        }
        goodsDomain.setIsDel(true);
        this.updateEsResourceGoodsDomain(goodsDomain);
        this.saveOrUpdateSkuList(rsResourceGoodsDomain, goodsDomain, null);
        return "success";
    }

    private void saveOrUpdateSkuList(RsResourceGoodsDomain rsResourceGoodsDomain, RsResourceGoodsReDomain goodsDomain, RsSkuDomain skuDomain) {
        this.logger.info("saveOrUpdateSkuList.rsResourceGoodsDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
        this.logger.info("saveOrUpdateSkuList.goodsDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goodsDomain));
        Map<String, RsSkuReDomain> rsSkuReDomainMap = goodsDomain.getSkuList().stream().collect(Collectors.toMap(RsSkuDomain::getSkuEocode, s -> s, (k1, k2) -> k1));
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        if (skuDomain == null) {
            RsSkuDomain rsSkuDomain = new RsSkuDomain();
            rsResourceGoodsDomain.getRsSkuDomainList().stream().forEach(sku -> {
                if (rsSkuReDomainMap.containsKey(sku.getSkuEocode())) {
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, rsSkuReDomainMap.get(sku.getSkuEocode()));
                        BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)sku);
                        editSkuDomain.setSkuEdit(false);
                    }
                    catch (Exception e) {
                        this.logger.error("busdata.RsGoodsBaseService.saveOrUpdateSkuList", (Throwable)e);
                    }
                    this.updateRsSkuDomain(editSkuDomain);
                } else {
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)rsResourceGoodsDomain);
                        BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, rsSkuReDomainMap.get(sku.getSkuEocode()));
                    }
                    catch (Exception e) {
                        this.logger.error("busdata.RsGoodsBaseService.saveOrUpdateSkuList", (Throwable)e);
                    }
                    this.logger.info("saveOrUpdateSkuList.saveRsSkuDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsSkuDomain));
                    this.saveRsSkuDomain(rsSkuDomain);
                }
            });
        } else if (rsSkuReDomainMap.containsKey(skuDomain.getSkuEocode())) {
            try {
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)rsSkuReDomainMap.get(skuDomain.getSkuEocode()));
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)skuDomain);
                editSkuDomain.setSkuEdit(false);
            }
            catch (Exception e) {
                this.logger.error("busdata.RsGoodsBaseService.saveOrUpdateSkuList", (Throwable)e);
            }
            this.updateRsSkuDomain(editSkuDomain);
        } else {
            this.saveRsSkuDomain(skuDomain);
        }
    }

    private void makeGoodsSpec(RsResourceGoodsDomain rsResourceGoodsDomain) {
        List<RsSpecGroupDomain> list = this.getRsSpecGroupByPntreeCode(rsResourceGoodsDomain.getPntreeCode(), rsResourceGoodsDomain.getTenantCode());
        if (ListUtil.isEmpty(list)) {
            String specGroupCode = this.saveRsSpecGroup("\u9ed8\u8ba4", rsResourceGoodsDomain.getTenantCode());
            rsResourceGoodsDomain.getRsSpecValueDomainList().stream().forEach(s -> {
                String specCode = this.saveRsSpec(specGroupCode, s.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                s.setSpecCode(specCode);
                s.setSpecGroupCode(specGroupCode);
                s.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            });
        } else {
            list.stream().forEach(g -> rsResourceGoodsDomain.getRsSpecValueDomainList().stream().forEach(s -> {
                QueryResult<RsSpecDomain> rsSpecDomainQueryResult = this.querySpecPageSpecGroupCode(g.getSpecGroupCode(), s.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                if (rsSpecDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecDomainQueryResult.getList())) {
                    String specCode = this.saveRsSpec(g.getSpecGroupCode(), s.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                    s.setSpecCode(specCode);
                } else {
                    s.setSpecCode(((RsSpecDomain)rsSpecDomainQueryResult.getList().get(0)).getSpecCode());
                }
                s.setSpecGroupCode(g.getSpecGroupCode());
                s.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            }));
        }
    }

    private void makeSkuSpec(RsSkuDomain rsSkuDomain) {
        List<RsSpecGroupDomain> list = this.getRsSpecGroupByPntreeCode(rsSkuDomain.getPntreeCode(), rsSkuDomain.getTenantCode());
        list.stream().forEach(g -> rsSkuDomain.getSpecList().stream().forEach(s -> {
            QueryResult<RsSpecDomain> rsSpecDomainQueryResult = this.querySpecPageSpecGroupCode(g.getSpecGroupCode(), s.getSpecName(), rsSkuDomain.getTenantCode());
            if (rsSpecDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecDomainQueryResult.getList())) {
                String specCode = this.saveRsSpec(g.getSpecGroupCode(), s.getSpecName(), rsSkuDomain.getTenantCode());
                s.setSpecCode(specCode);
            } else {
                s.setSpecCode(((RsSpecDomain)rsSpecDomainQueryResult.getList().get(0)).getSpecCode());
            }
            s.setSpecGroupCode(g.getSpecGroupCode());
            s.setTenantCode(rsSkuDomain.getTenantCode());
        }));
    }

    private String checkPntree(RsResourceGoodsDomain rsResourceGoodsDomain) {
        RsPntreeDomain rsPntreeDomain = this.getRsPntreeByCodeOrName(rsResourceGoodsDomain.getPntreeCode(), rsResourceGoodsDomain.getPntreeName(), rsResourceGoodsDomain.getTenantCode());
        if (rsPntreeDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.checkPntree", (Object)("\u5546\u54c1\u54c1\u7c7b\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getPntreeCode() + "---" + rsResourceGoodsDomain.getPntreeName()));
            return "\u5546\u54c1\u54c1\u7c7b\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setPntreeCode(rsPntreeDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(rsPntreeDomain.getPntreeName());
        return "";
    }

    private String checkBrand(RsResourceGoodsDomain rsResourceGoodsDomain) {
        RsBrandDomain rsBrandDomain = null;
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode())) {
            rsBrandDomain = this.getBrandByEocode(rsResourceGoodsDomain.getBrandCode(), rsResourceGoodsDomain.getTenantCode());
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) {
            rsBrandDomain = this.getBrandByName(rsResourceGoodsDomain.getBrandName(), rsResourceGoodsDomain.getTenantCode());
        }
        if (rsBrandDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.checkBrand", (Object)("\u54c1\u724c\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getBrandCode() + "---" + rsResourceGoodsDomain.getBrandName()));
            return "\u54c1\u724c\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setBrandCode(rsBrandDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(rsBrandDomain.getBrandName());
        return "";
    }

    private String checkClassTree(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("classtreeCode", rsResourceGoodsDomain.getClasstreeCode());
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("classtreeName", rsResourceGoodsDomain.getClasstreeName());
        }
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        QueryResult<RsClasstreeDomain> queryResult = this.queryRsClasstreePage(map);
        if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.logger.error("busdata.RsGoodsBaseService.checkClassTree", (Object)("\u540e\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getClasstreeCode() + "---" + rsResourceGoodsDomain.getClasstreeName()));
            return "\u540e\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setClasstreeCode(((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeName());
        return "";
    }

    private String checkClassTreeShop(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("goodsClassCode", rsResourceGoodsDomain.getClasstreeShopcode());
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("goodsClassName", rsResourceGoodsDomain.getClasstreeShopname());
        }
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        QueryResult<RsGoodsClassDomain> queryResult = this.queryRsGoodsClassPage(map);
        if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.logger.error("busdata.RsGoodsBaseService.checkClassTreeShop", (Object)("\u524d\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getClasstreeShopcode() + "---" + rsResourceGoodsDomain.getClasstreeShopname()));
            return "\u524d\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setClasstreeShopcode(((RsGoodsClassDomain)queryResult.getList().get(0)).getGoodsClassCode());
        rsResourceGoodsDomain.setClasstreeShopname(((RsGoodsClassDomain)queryResult.getList().get(0)).getGoodsClassName());
        return "";
    }

    private RsResourceGoodsReDomain checkResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("goodsClass", rsResourceGoodsDomain.getGoodsClass());
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsNo())) {
            paramsMap.put("goodsNo", rsResourceGoodsDomain.getGoodsNo());
        } else if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsEocode())) {
            paramsMap.put("goodsEocode", rsResourceGoodsDomain.getGoodsEocode());
        }
        paramsMap.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        paramsMap.put("children", "true");
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsDomainQueryResult = this.queryRsResourceGoodsPage(paramsMap);
        if (rsResourceGoodsDomainQueryResult == null || ListUtil.isEmpty((Collection)rsResourceGoodsDomainQueryResult.getList())) {
            return null;
        }
        return (RsResourceGoodsReDomain)rsResourceGoodsDomainQueryResult.getList().get(0);
    }

    @Override
    public String sendSaveExSku(RsSkuDomain rsSkuDomain) {
        if (rsSkuDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExSku.rsSkuDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkSkuParam(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.msg");
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.msg", msg);
        }
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoodsBySku(rsSkuDomain);
        if (goodsDomain == null) {
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExSku.msg", "\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u4fdd\u5b58sku\u4fe1\u606f");
        }
        RsSkuDomain skuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)skuDomain, (Object)goodsDomain);
            BeanUtils.copyAllPropertysNotNull((Object)skuDomain, (Object)rsSkuDomain);
        }
        catch (Exception e) {
            this.logger.debug("busdata.RsGoodsBaseService.receiveSaveResourceGoods", (Throwable)e);
        }
        this.makeSkuSpec(skuDomain);
        skuDomain.setGoodsNum(rsSkuDomain.getGoodsNum() == null ? BigDecimal.ZERO : rsSkuDomain.getGoodsNum());
        skuDomain.setPricesetNprice(rsSkuDomain.getPricesetNprice() == null ? BigDecimal.ZERO : rsSkuDomain.getPricesetNprice());
        this.saveOrUpdateSkuList(null, goodsDomain, skuDomain);
        return "success";
    }

    private RsResourceGoodsReDomain checkResourceGoodsBySku(RsSkuDomain rsSkuDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("goodsClass", rsSkuDomain.getGoodsClass());
        paramsMap.put("goodsEocode", rsSkuDomain.getGoodsEocode());
        paramsMap.put("tenantCode", rsSkuDomain.getTenantCode());
        paramsMap.put("children", "true");
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsDomainQueryResult = this.queryRsResourceGoodsPage(paramsMap);
        if (rsResourceGoodsDomainQueryResult == null || ListUtil.isEmpty((Collection)rsResourceGoodsDomainQueryResult.getList())) {
            return null;
        }
        return (RsResourceGoodsReDomain)rsResourceGoodsDomainQueryResult.getList().get(0);
    }

    @Override
    public String sendSaveExClass(Map<String, Object> resStream) {
        RsClasstreeDomain classtreeDomain;
        this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.rsBrandDomainisnull");
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsClasstreeDomain rsClasstreeDomain = (RsClasstreeDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), RsClasstreeDomain.class);
        String msg = GoodsParamCheckUtils.checkClasstreeParam(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.msg");
            return this.makeErrorReturn(rsClasstreeDomain.getClasstreeEocode(), msg);
        }
        if (!"-1".equals(rsClasstreeDomain.getClasstreeParentcode())) {
            classtreeDomain = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeParentcode(), rsClasstreeDomain.getTenantCode());
            if (classtreeDomain == null) {
                return this.makeErrorReturn(rsClasstreeDomain.getClasstreeEocode(), "\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            }
            rsClasstreeDomain.setClasstreeParentcode(classtreeDomain.getClasstreeCode());
        }
        classtreeDomain = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeEocode(), rsClasstreeDomain.getTenantCode());
        try {
            if (classtreeDomain == null) {
                String code = this.saveRsClasstree(rsClasstreeDomain);
                if (StringUtils.isNotBlank((String)code)) {
                    return this.makeSuccessReturn(rsClasstreeDomain.getClasstreeEocode());
                }
                this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.rsClasstreeDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
                return this.makeErrorReturn(rsClasstreeDomain.getClasstreeEocode(), "\u6570\u636e" + rsClasstreeDomain.getClasstreeEocode() + "\u62a5\u5b58\u5f02\u5e38");
            }
            this.updateRsClasstree(rsClasstreeDomain);
            return this.makeSuccessReturn(classtreeDomain.getClasstreeEocode());
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.e", (Throwable)e);
            return this.makeErrorReturn(classtreeDomain.getClasstreeEocode(), e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.e1", (Throwable)e);
            return this.makeErrorReturn(classtreeDomain.getClasstreeEocode(), e.getMessage());
        }
    }

    @Override
    public String sendSaveExGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        RsGoodsClassDomain goodsClassDomain;
        if (rsGoodsClassDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoodsClass.rsGoodsClassDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkClasstreeShopParam(rsGoodsClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoodsClass.msg");
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExClass.msg", msg);
        }
        if (!"-1".equals(rsGoodsClassDomain.getGoodsClassParentcode())) {
            goodsClassDomain = this.getRsGoodsClassByCode(rsGoodsClassDomain.getGoodsClassParentcode(), rsGoodsClassDomain.getTenantCode());
            if (goodsClassDomain == null) {
                return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExClass.msg", "\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            }
            goodsClassDomain.setGoodsClassParentcode(goodsClassDomain.getGoodsClassCode());
        }
        if ((goodsClassDomain = this.getRsGoodsClassByCode(rsGoodsClassDomain.getGoodsClassEocode(), rsGoodsClassDomain.getTenantCode())) == null) {
            String code = this.saveRsGoodsClass(rsGoodsClassDomain);
            return this.makeSuccessReturn(code);
        }
        return this.makeSuccessReturn(goodsClassDomain.getGoodsClassCode());
    }

    @Override
    public String sendSaveExBrand(Map<String, Object> resStream) {
        this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.rsBrandDomainisnull");
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsBrandDomain rsBrandDomain = (RsBrandDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), RsBrandDomain.class);
        String msg = GoodsParamCheckUtils.checkBrandParam(rsBrandDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.msg");
            return this.makeErrorReturn(rsBrandDomain.getBrandEocode(), msg);
        }
        try {
            RsBrandDomain brandDomain = this.getBrandByEocode(rsBrandDomain.getBrandEocode(), rsBrandDomain.getTenantCode());
            if (brandDomain == null) {
                String code = this.saveRsBrand(rsBrandDomain);
                if (StringUtils.isNotBlank((String)code)) {
                    return this.makeSuccessReturn(rsBrandDomain.getBrandEocode());
                }
                rsBrandDomain.setBrandId(brandDomain.getBrandId());
                this.updateBrand(rsBrandDomain);
                this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.rsBrandDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain));
                return this.makeErrorReturn(rsBrandDomain.getBrandEocode(), "\u6570\u636e" + rsBrandDomain.getBrandEocode() + "\u4fee\u6539\u5f02\u5e38");
            }
            return this.makeSuccessReturn(brandDomain.getBrandCode());
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.e", (Throwable)e);
            return this.makeErrorReturn(rsBrandDomain.getBrandEocode(), e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.e1", (Throwable)e);
            return this.makeErrorReturn(rsBrandDomain.getBrandEocode(), e.getMessage());
        }
    }

    @Override
    public String sendDeleteExBrand(String brandEocode, String tenantCode) {
        this.logger.error("busdata.RsGoodsBaseService.sendDeleteExBrand.map", (Object)JsonUtil.buildNormalBinder().toJson((Object)brandEocode));
        if (StringUtils.isEmpty((String)brandEocode) || StringUtils.isBlank((String)tenantCode)) {
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsBrandDomain rsBrandDomain = this.getBrandByEocode(brandEocode, tenantCode);
        if (null == rsBrandDomain) {
            this.logger.error("busdata.RsGoodsBaseService.sendDeleteExBrand.msg" + brandEocode);
            return this.makeErrorReturn(brandEocode, "\u54c1\u724c\u4e0d\u5b58\u5728");
        }
        try {
            this.sendDeleteBrand(rsBrandDomain.getBrandId());
            return this.makeSuccessReturn(brandEocode);
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.sendDeleteExBrand.e", (Throwable)e);
            return this.makeErrorReturn(brandEocode, e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendDeleteExBrand.e1", (Throwable)e);
            return this.makeErrorReturn(brandEocode, e.getMessage());
        }
    }

    @Override
    public String sendSaveOrUpdateSkuOne(Map<String, Object> resStream, String tenantCode) {
        this.logger.error("busdata.RsGoodsBaseService.sendSaveOrUpdateSkuOne.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream) || StringUtils.isBlank((String)tenantCode)) {
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSkuOneDomain rsSkuOneDomain = (RsSkuOneDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), RsSkuOneDomain.class);
        String msg = this.checkMap(rsSkuOneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveOrUpdateSkuOne.msg");
            return this.makeErrorReturn(rsSkuOneDomain.getSkuOneCode(), msg);
        }
        try {
            this.saveOrUpdateSkuOneAndSkuOneList(rsSkuOneDomain);
            return this.makeSuccessReturn(rsSkuOneDomain.getSkuOneCode());
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveOrUpdateSkuOne.e", (Throwable)e);
            return this.makeErrorReturn(rsSkuOneDomain.getSkuOneCode(), e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveOrUpdateSkuOne.e1", (Throwable)e);
            return this.makeErrorReturn(rsSkuOneDomain.getSkuOneCode(), e.getMessage());
        }
    }

    @Override
    public String sendDeleteSkuOne(String skuOneCode, String tenantCode) {
        this.logger.error("busdata.RsGoodsBaseService.senddeleteSkuOne.map", (Object)JsonUtil.buildNormalBinder().toJson((Object)skuOneCode));
        if (StringUtils.isEmpty((String)skuOneCode) || StringUtils.isBlank((String)tenantCode)) {
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSkuOneReDomain skuOneByCode = this.getSkuOneByCode(skuOneCode, tenantCode);
        if (null == skuOneByCode) {
            this.logger.error("busdata.RsGoodsBaseService.senddeleteSkuOne.msg" + skuOneCode);
            return this.makeErrorReturn(skuOneCode, "\u7bb1\u5305\u6570\u4e0d\u5b58\u5728");
        }
        try {
            this.deleteSkuOne(skuOneByCode.getSkuOneId());
            return this.makeSuccessReturn(skuOneCode);
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.senddeleteSkuOne.e", (Throwable)e);
            return this.makeErrorReturn(skuOneCode, e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.senddeleteSkuOne.e1", (Throwable)e);
            return this.makeErrorReturn(skuOneCode, e.getMessage());
        }
    }

    private String checkMap(RsSkuOneDomain rsSkuOneDomain) {
        if (null == rsSkuOneDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuOneDomain.getSkuNo())) {
            msg = msg + "skuNo\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)rsSkuOneDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == rsSkuOneDomain.getSkuOneNum()) {
            msg = msg + "skuOneNum \u4e3a\u7a7a! ";
        }
        if (null == rsSkuOneDomain.getSkuOneCode()) {
            msg = msg + "skuOneCode \u4e3a\u7a7a! ";
        }
        return msg;
    }
}

