/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.api.ExRsGoodsService;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.EditSkuDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsPntreeDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSkuOneDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSkuOneReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSpecDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSpecOption;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsSpecValueDomain;
import com.yqbsoft.laser.service.ext.skshu.supbase.RsGoodsBaseService;
import com.yqbsoft.laser.service.ext.skshu.util.GoodsParamCheckUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExRsGoodsServiceImpl
extends RsGoodsBaseService
implements ExRsGoodsService {
    private static final String PNTREE_NAME = "\u4e09\u68f5\u6811\u9ed8\u8ba4";

    @Override
    public String sendSaveExGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (rsResourceGoodsDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkGoodsParam(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.msg");
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.msg", msg);
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeName())) {
            msg = this.checkPntree(rsResourceGoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.checkPntree.msg");
                return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.checkPntree.msg", msg);
            }
            this.makeGoodsSpec(rsResourceGoodsDomain);
        }
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) && StringUtils.isNotBlank((String)(msg = this.checkBrand(rsResourceGoodsDomain)))) {
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.checkBrand.msg", msg);
        }
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeName())) && StringUtils.isNotBlank((String)(msg = this.checkClassTree(rsResourceGoodsDomain)))) {
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.checkClassTree.msg", msg);
        }
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeShopcode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeShopname())) && StringUtils.isNotBlank((String)(msg = this.checkClassTreeShop(rsResourceGoodsDomain)))) {
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.checkClassTreeShop.msg", msg);
        }
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain);
        if (goodsDomain == null) {
            if (rsResourceGoodsDomain.getGoodsNum() == null) {
                rsResourceGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (rsResourceGoodsDomain.getPricesetNprice() == null) {
                rsResourceGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            rsResourceGoodsDomain.getRsSkuDomainList().stream().forEach(sku -> {
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)sku, (Object)rsResourceGoodsDomain);
                }
                catch (Exception e) {
                    this.logger.debug("busdata.RsGoodsBaseService.sendSaveExGoods", (Throwable)e);
                }
            });
            String goodsCode = this.saveEsResourceGoodsDomain(rsResourceGoodsDomain);
            return this.makeSuccessReturn(goodsCode);
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)goodsDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods", (Throwable)e);
        }
        goodsDomain.setIsDel(true);
        this.updateEsResourceGoodsDomain(goodsDomain);
        this.saveOrUpdateSkuList(rsResourceGoodsDomain, goodsDomain, null);
        return "success";
    }

    @Override
    public String sendSaveExGoodsSpu(Map<String, Object> resStream) {
        RsResourceGoodsReDomain goodsDomain;
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), RsResourceGoodsDomain.class);
        if (rsResourceGoodsDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.rsResourceGoodsDomain");
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setPntreeName(PNTREE_NAME);
        String msg = GoodsParamCheckUtils.checkGoodsParam(rsResourceGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.msg" + msg);
            return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u53c2\u6570\u5f02\u5e38");
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getPntreeName())) {
            msg = this.checkPntree(rsResourceGoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.checkPntree.msg");
                return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u5546\u54c1\u54c1\u7c7b\u672a\u7ef4\u62a4\u5168");
            }
            try {
                this.makeSpec(rsResourceGoodsDomain);
            }
            catch (Exception e) {
                return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u6570\u636e\u9519\u8bef");
            }
        }
        if ((StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) && StringUtils.isNotBlank((String)(msg = this.checkBrand(rsResourceGoodsDomain)))) {
            return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u54c1\u724c\u672a\u7ef4\u62a4\u5168");
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode()) || StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeName())) {
            msg = this.checkClassTree(rsResourceGoodsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                return this.makeErrorReturn(rsResourceGoodsDomain.getSkuNo(), "\u540e\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168");
            }
            if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getOneClassifyCode()) && StringUtils.isNotBlank((String)rsResourceGoodsDomain.getTwoClassifyCode())) {
                String m = rsResourceGoodsDomain.getGoodsProperty1() + "/" + rsResourceGoodsDomain.getOneClassify() + "/" + rsResourceGoodsDomain.getTwoClassify();
                rsResourceGoodsDomain.setClasstreeName(m);
            }
        }
        if ((goodsDomain = this.checkResourceGoods(rsResourceGoodsDomain)) == null) {
            if (rsResourceGoodsDomain.getGoodsNum() == null) {
                rsResourceGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (rsResourceGoodsDomain.getPricesetNprice() == null) {
                rsResourceGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            RsSkuDomain rsSkuDomain = new RsSkuDomain();
            this.makeSkuDomain(rsResourceGoodsDomain, rsSkuDomain);
            ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
            rsSkuDomainList.add(rsSkuDomain);
            rsResourceGoodsDomain.setRsSkuDomainList(rsSkuDomainList);
            this.saveEsResourceGoodsDomain(rsResourceGoodsDomain);
            return this.makeSuccessReturn(rsResourceGoodsDomain.getSkuNo());
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)goodsDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods", (Throwable)e);
        }
        goodsDomain.setIsDel(true);
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        this.makeSkuDomain(rsResourceGoodsDomain, rsSkuDomain);
        this.saveOrUpdateSkuList(rsResourceGoodsDomain, goodsDomain, rsSkuDomain);
        return this.makeSuccessReturn(rsResourceGoodsDomain.getSkuNo());
    }

    private void makeSkuDomain(RsResourceGoodsDomain rsResourceGoodsDomain, RsSkuDomain rsSkuDomain) {
        if (null == rsResourceGoodsDomain || null == rsSkuDomain) {
            this.logger.debug("busdata.RsGoodsBaseService.makeSkuDomain", (Object)"isnull");
            return;
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)rsResourceGoodsDomain);
        }
        catch (Exception e) {
            this.logger.debug("busdata.RsGoodsBaseService.makeSkuDomain", (Throwable)e);
            return;
        }
        rsSkuDomain.setSkuName(rsResourceGoodsDomain.getSkuName());
        rsSkuDomain.setTenantCode(rsResourceGoodsDomain.getTenantCode());
        rsSkuDomain.setGoodsNum(new BigDecimal("999"));
        rsSkuDomain.setGoodsSupplynum(new BigDecimal("999"));
        rsSkuDomain.setGoodsNo(rsResourceGoodsDomain.getGoodsNo());
        rsSkuDomain.setPricesetNprice(rsResourceGoodsDomain.getPricesetNprice());
        rsSkuDomain.setSkuNo(rsResourceGoodsDomain.getSkuNo());
        rsSkuDomain.setSkuEocode(rsResourceGoodsDomain.getSkuNo());
    }

    private void saveOrUpdateSkuList(RsResourceGoodsDomain rsResourceGoodsDomain, RsResourceGoodsReDomain goodsDomain, RsSkuDomain skuDomain) {
        this.logger.info("saveOrUpdateSkuList.rsResourceGoodsDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsDomain));
        this.logger.info("saveOrUpdateSkuList.goodsDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goodsDomain));
        Map<String, RsSkuReDomain> rsSkuReDomainMap = goodsDomain.getSkuList().stream().collect(Collectors.toMap(RsSkuDomain::getSkuEocode, s -> s, (k1, k2) -> k1));
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        if (skuDomain == null) {
            RsSkuDomain rsSkuDomain = new RsSkuDomain();
            rsResourceGoodsDomain.getRsSkuDomainList().stream().forEach(sku -> {
                if (rsSkuReDomainMap.containsKey(sku.getSkuEocode())) {
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, rsSkuReDomainMap.get(sku.getSkuEocode()));
                        BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)sku);
                        editSkuDomain.setSkuEdit(false);
                    }
                    catch (Exception e) {
                        this.logger.error("busdata.RsGoodsBaseService.saveOrUpdateSkuList", (Throwable)e);
                    }
                    this.updateRsSkuDomain(editSkuDomain);
                } else {
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)rsResourceGoodsDomain);
                        BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, rsSkuReDomainMap.get(sku.getSkuEocode()));
                    }
                    catch (Exception e) {
                        this.logger.error("busdata.RsGoodsBaseService.saveOrUpdateSkuList", (Throwable)e);
                    }
                    this.logger.info("saveOrUpdateSkuList.saveRsSkuDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsSkuDomain));
                    ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
                    rsSkuDomainList.add(rsSkuDomain);
                    goodsDomain.getRsSkuDomainList().addAll(rsSkuDomainList);
                    this.updateEsResourceGoodsDomain(goodsDomain);
                }
            });
        } else if (rsSkuReDomainMap.containsKey(skuDomain.getSkuEocode())) {
            try {
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)rsSkuReDomainMap.get(skuDomain.getSkuEocode()));
                BeanUtils.copyAllPropertysNotNull((Object)editSkuDomain, (Object)skuDomain);
                editSkuDomain.setSkuEdit(false);
            }
            catch (Exception e) {
                this.logger.error("busdata.RsGoodsBaseService.saveOrUpdateSkuList", (Throwable)e);
            }
            this.updateRsSkuDomain(editSkuDomain);
        } else {
            ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
            rsSkuDomainList.add(skuDomain);
            goodsDomain.getRsSkuDomainList().addAll(rsSkuDomainList);
            if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
                if (ListUtil.isNotEmpty(goodsDomain.getRsSpecValueDomainList())) {
                    goodsDomain.getRsSpecValueDomainList().addAll(rsResourceGoodsDomain.getRsSpecValueDomainList());
                } else {
                    goodsDomain.setRsSpecValueDomainList(rsResourceGoodsDomain.getRsSpecValueDomainList());
                }
            }
            this.updateEsResourceGoodsDomain(goodsDomain);
        }
    }

    private void makeGoodsSpec(RsResourceGoodsDomain rsResourceGoodsDomain) {
        List<RsSpecGroupDomain> list = this.getRsSpecGroupByPntreeCode(rsResourceGoodsDomain.getPntreeCode(), rsResourceGoodsDomain.getTenantCode());
        if (ListUtil.isEmpty(list)) {
            String specGroupCode = this.saveRsSpecGroup("\u9ed8\u8ba4", rsResourceGoodsDomain.getTenantCode());
            rsResourceGoodsDomain.getRsSpecValueDomainList().stream().forEach(s -> {
                String specCode = this.saveRsSpec(specGroupCode, s.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                s.setSpecCode(specCode);
                s.setSpecGroupCode(specGroupCode);
                s.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            });
        } else {
            list.stream().forEach(g -> rsResourceGoodsDomain.getRsSpecValueDomainList().stream().forEach(s -> {
                QueryResult<RsSpecDomain> rsSpecDomainQueryResult = this.querySpecPageSpecGroupCode(g.getSpecGroupCode(), s.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                if (rsSpecDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecDomainQueryResult.getList())) {
                    String specCode = this.saveRsSpec(g.getSpecGroupCode(), s.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                    s.setSpecCode(specCode);
                } else {
                    s.setSpecCode(((RsSpecDomain)rsSpecDomainQueryResult.getList().get(0)).getSpecCode());
                }
                s.setSpecGroupCode(g.getSpecGroupCode());
                s.setTenantCode(rsResourceGoodsDomain.getTenantCode());
            }));
        }
    }

    private void makeSpec(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (null == rsResourceGoodsDomain) {
            return;
        }
        String tenantCode = rsResourceGoodsDomain.getTenantCode();
        HashMap<String, String> specGroupMap = new HashMap<String, String>();
        HashMap<String, String> specGroupMapStr = new HashMap<String, String>();
        specGroupMapStr.put("pntreeCode", rsResourceGoodsDomain.getPntreeCode());
        specGroupMapStr.put("tenantCode", tenantCode);
        specGroupMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(specGroupMapStr));
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        QueryResult supQueryResult = this.sendReSupObject("rs.spec.querySpecGroupPage", specGroupMap, RsSpecGroupDomain.class);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            HashMap<String, String> mapStr = new HashMap<String, String>();
            RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
            rsSpecGroupDomain.setPntreeCode(rsResourceGoodsDomain.getPntreeCode());
            rsSpecGroupDomain.setSpecGroupName(rsResourceGoodsDomain.getPntreeName());
            rsSpecGroupDomain.setTenantCode(tenantCode);
            mapStr.put("rsSpecGroupDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecGroupDomain));
            String specGroupCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", mapStr);
            if (StringUtils.isBlank((String)specGroupCode)) {
                this.logger.error("busdata.RsGoodsBaseService.makeSpec.checkGoods.saveSpecGroup", (Object)("\u89c4\u683c\u7ec4\u6dfb\u52a0\u5931\u8d25\uff01\uff01\uff01rsSpecGroupDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain)));
                return;
            }
            this.makeRsSpecDomain(rsResourceGoodsDomain, specGroupCode);
        } else {
            RsSpecGroupDomain rsSpecGroup = (RsSpecGroupDomain)supQueryResult.getList().get(0);
            rsSpecValueDomain.setSpecGroupCode(rsSpecGroup.getSpecGroupCode());
            this.makeRsSpecDomain(rsResourceGoodsDomain, rsSpecGroup.getSpecGroupCode());
        }
    }

    public void checkrsSpecOption(RsResourceGoodsDomain rsResourceGoodsDomain, String specGroupCode, String specCode, String specOptionName, String tenantCode) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        HashMap<String, String> specOpMap = new HashMap<String, String>();
        map2.put("specCode", specCode);
        map2.put("specOptionName", specOptionName);
        map2.put("tenantCode", tenantCode);
        specOpMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map2));
        ArrayList<RsSpecValueDomain> rsSpecValuenList = new ArrayList<RsSpecValueDomain>();
        RsSpecValueDomain rsSpecValue = new RsSpecValueDomain();
        List specOpList = this.getQueryResutl("rs.spec.querySpecOptionPage", specOpMap, RsSpecOption.class).getList();
        RsSpecOptionDomain rsSpecOptionDomain = new RsSpecOptionDomain();
        if (ListUtil.isEmpty((Collection)specOpList)) {
            rsSpecOptionDomain.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomain.setSpecCode(specCode);
            rsSpecOptionDomain.setSpecOptionName(specOptionName);
            rsSpecOptionDomain.setTenantCode(tenantCode);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("rsSpecOptionDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)rsSpecOptionDomain));
            try {
                String specOptionCode = this.internalInvoke("rs.spec.saveSpecOption", map);
                if (StringUtils.isBlank((String)specOptionCode)) {
                    this.logger.error("busdata.RsGoodsBaseService.checkrsSpecOption.specOptionCode", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)));
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("busdata.RsGoodsBaseService.checkrsSpecOption.\u65b0\u589e\u89c4\u683c\u5c5e\u6027\u503c\u5931\u8d25", (Object)(",\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)), (Throwable)e);
            }
        } else {
            try {
                BeanUtils.copyAllPropertys((Object)rsSpecOptionDomain, specOpList.get(0));
            }
            catch (Exception e) {
                this.logger.error("busdata.RsGoodsBaseService.checkrsSpecOption.\u65b0\u589e\u89c4\u683c\u5c5e\u6027\u503c\u5931\u8d251", (Object)(",\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)), (Throwable)e);
            }
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecValue, (Object)rsSpecOptionDomain);
            rsSpecValue.setSpecValueValue(specOptionName);
            rsSpecValue.setSpecValueType("0");
            rsSpecValue.setTenantCode(tenantCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("busdata.RsGoodsBaseService.checkrsSpecOption.\u65b0\u589e\u89c4\u683c\u5c5e\u6027\u503c\u5931\u8d252", (Object)(",\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain)), (Throwable)e);
        }
        rsSpecValuenList.add(rsSpecValue);
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecValueDomainList())) {
            rsResourceGoodsDomain.getRsSpecValueDomainList().addAll(rsSpecValuenList);
        } else {
            rsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValuenList);
        }
    }

    public void makeRsSpecDomain(RsResourceGoodsDomain rsResourceGoodsDomain, String specGroupCode) {
        if (null == rsResourceGoodsDomain || StringUtils.isEmpty((String)specGroupCode)) {
            this.logger.error("busdata.RsGoodsBaseService.makeRsSpecDomain", (Object)"isnull");
            return;
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsDomain.getRsSpecDomainList())) {
            for (RsSpecDomain rsSpecDomain : rsResourceGoodsDomain.getRsSpecDomainList()) {
                rsSpecDomain.setSpecGroupCode(specGroupCode);
                QueryResult<RsSpecDomain> rsSpecDomainQueryResult = this.querySpecPageSpecGroupCode(rsSpecDomain.getSpecGroupCode(), rsSpecDomain.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                if (rsSpecDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecDomainQueryResult.getList())) {
                    String specCode = this.saveRsSpec(rsSpecDomain.getSpecGroupCode(), rsSpecDomain.getSpecName(), rsResourceGoodsDomain.getTenantCode());
                    if (StringUtils.isBlank((String)specCode)) {
                        this.logger.error("busdata.RsGoodsBaseService.makeRsSpecDomain.checkGoods.saveSpec", (Object)("specCode:" + specCode + ",\u8bf7\u6c42\u53c2\u6570rsSpecDomain:" + JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain)));
                        return;
                    }
                    if (!ListUtil.isNotEmpty(rsSpecDomain.getSpecOptionList())) continue;
                    for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecDomain.getSpecOptionList()) {
                        this.checkrsSpecOption(rsResourceGoodsDomain, rsSpecDomain.getSpecGroupCode(), specCode, rsSpecOptionDomain.getSpecOptionName(), rsResourceGoodsDomain.getTenantCode());
                    }
                    continue;
                }
                if (!ListUtil.isNotEmpty(rsSpecDomain.getSpecOptionList())) continue;
                for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecDomain.getSpecOptionList()) {
                    this.checkrsSpecOption(rsResourceGoodsDomain, rsSpecDomain.getSpecGroupCode(), rsSpecDomain.getSpecCode(), rsSpecOptionDomain.getSpecOptionName(), rsResourceGoodsDomain.getTenantCode());
                }
            }
        }
    }

    private void makeSkuSpec(RsSkuDomain rsSkuDomain) {
        List<RsSpecGroupDomain> list = this.getRsSpecGroupByPntreeCode(rsSkuDomain.getPntreeCode(), rsSkuDomain.getTenantCode());
        list.stream().forEach(g -> rsSkuDomain.getSpecList().stream().forEach(s -> {
            QueryResult<RsSpecDomain> rsSpecDomainQueryResult = this.querySpecPageSpecGroupCode(g.getSpecGroupCode(), s.getSpecName(), rsSkuDomain.getTenantCode());
            if (rsSpecDomainQueryResult == null || ListUtil.isEmpty((Collection)rsSpecDomainQueryResult.getList())) {
                String specCode = this.saveRsSpec(g.getSpecGroupCode(), s.getSpecName(), rsSkuDomain.getTenantCode());
                s.setSpecCode(specCode);
            } else {
                s.setSpecCode(((RsSpecDomain)rsSpecDomainQueryResult.getList().get(0)).getSpecCode());
            }
            s.setSpecGroupCode(g.getSpecGroupCode());
            s.setTenantCode(rsSkuDomain.getTenantCode());
        }));
    }

    private String checkPntree(RsResourceGoodsDomain rsResourceGoodsDomain) {
        RsPntreeDomain rsPntreeDomain = this.getRsPntreeByCodeOrName(rsResourceGoodsDomain.getPntreeCode(), rsResourceGoodsDomain.getPntreeName(), rsResourceGoodsDomain.getTenantCode());
        if (rsPntreeDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.checkPntree", (Object)("\u5546\u54c1\u54c1\u7c7b\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getPntreeCode() + "---" + rsResourceGoodsDomain.getPntreeName()));
            return "\u5546\u54c1\u54c1\u7c7b\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setPntreeCode(rsPntreeDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(rsPntreeDomain.getPntreeName());
        return "";
    }

    private String checkBrand(RsResourceGoodsDomain rsResourceGoodsDomain) {
        RsBrandDomain rsBrandDomain = null;
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandCode())) {
            rsBrandDomain = this.getBrandByEocode(rsResourceGoodsDomain.getBrandCode(), rsResourceGoodsDomain.getTenantCode());
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getBrandName())) {
            rsBrandDomain = this.getBrandByName(rsResourceGoodsDomain.getBrandName(), rsResourceGoodsDomain.getTenantCode());
        }
        if (rsBrandDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.checkBrand", (Object)("\u54c1\u724c\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getBrandCode() + "---" + rsResourceGoodsDomain.getBrandName()));
            return "\u54c1\u724c\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setBrandCode(rsBrandDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(rsBrandDomain.getBrandName());
        return "";
    }

    private String checkClassTree(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("classtreeCode", rsResourceGoodsDomain.getClasstreeCode());
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("classtreeName", rsResourceGoodsDomain.getClasstreeName());
        }
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        QueryResult<RsClasstreeDomain> queryResult = this.queryRsClasstreePage(map);
        if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.logger.error("busdata.RsGoodsBaseService.checkClassTree", (Object)("\u540e\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getClasstreeCode() + "---" + rsResourceGoodsDomain.getClasstreeName()));
            return "\u540e\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setClasstreeCode(((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(((RsClasstreeDomain)queryResult.getList().get(0)).getClasstreeName());
        return "";
    }

    private String checkClassTreeShop(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("goodsClassCode", rsResourceGoodsDomain.getClasstreeShopcode());
        }
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getClasstreeCode())) {
            map.put("goodsClassName", rsResourceGoodsDomain.getClasstreeShopname());
        }
        map.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        QueryResult<RsGoodsClassDomain> queryResult = this.queryRsGoodsClassPage(map);
        if (queryResult == null || !ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.logger.error("busdata.RsGoodsBaseService.checkClassTreeShop", (Object)("\u524d\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168==" + rsResourceGoodsDomain.getClasstreeShopcode() + "---" + rsResourceGoodsDomain.getClasstreeShopname()));
            return "\u524d\u53f0\u5206\u7c7b\u672a\u7ef4\u62a4\u5168\uff01";
        }
        rsResourceGoodsDomain.setClasstreeShopcode(((RsGoodsClassDomain)queryResult.getList().get(0)).getGoodsClassCode());
        rsResourceGoodsDomain.setClasstreeShopname(((RsGoodsClassDomain)queryResult.getList().get(0)).getGoodsClassName());
        return "";
    }

    private RsResourceGoodsReDomain checkResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("goodsClass", rsResourceGoodsDomain.getGoodsClass());
        if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsNo())) {
            paramsMap.put("goodsNo", rsResourceGoodsDomain.getGoodsNo());
        } else if (StringUtils.isNotBlank((String)rsResourceGoodsDomain.getGoodsEocode())) {
            paramsMap.put("goodsEocode", rsResourceGoodsDomain.getGoodsEocode());
        }
        paramsMap.put("tenantCode", rsResourceGoodsDomain.getTenantCode());
        paramsMap.put("children", "true");
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsDomainQueryResult = this.queryRsResourceGoodsPage(paramsMap);
        if (rsResourceGoodsDomainQueryResult == null || ListUtil.isEmpty((Collection)rsResourceGoodsDomainQueryResult.getList())) {
            return null;
        }
        return (RsResourceGoodsReDomain)rsResourceGoodsDomainQueryResult.getList().get(0);
    }

    @Override
    public String sendSaveExSku(RsSkuDomain rsSkuDomain) {
        if (rsSkuDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExSku.rsSkuDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkSkuParam(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoods.msg");
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExGoods.msg", msg);
        }
        RsResourceGoodsReDomain goodsDomain = this.checkResourceGoodsBySku(rsSkuDomain);
        if (goodsDomain == null) {
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExSku.msg", "\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u4fdd\u5b58sku\u4fe1\u606f");
        }
        RsSkuDomain skuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)skuDomain, (Object)goodsDomain);
            BeanUtils.copyAllPropertysNotNull((Object)skuDomain, (Object)rsSkuDomain);
        }
        catch (Exception e) {
            this.logger.debug("busdata.RsGoodsBaseService.receiveSaveResourceGoods", (Throwable)e);
        }
        this.makeSkuSpec(skuDomain);
        skuDomain.setGoodsNum(rsSkuDomain.getGoodsNum() == null ? BigDecimal.ZERO : rsSkuDomain.getGoodsNum());
        skuDomain.setPricesetNprice(rsSkuDomain.getPricesetNprice() == null ? BigDecimal.ZERO : rsSkuDomain.getPricesetNprice());
        this.saveOrUpdateSkuList(null, goodsDomain, skuDomain);
        return "success";
    }

    private RsResourceGoodsReDomain checkResourceGoodsBySku(RsSkuDomain rsSkuDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("goodsClass", rsSkuDomain.getGoodsClass());
        paramsMap.put("goodsEocode", rsSkuDomain.getGoodsEocode());
        paramsMap.put("tenantCode", rsSkuDomain.getTenantCode());
        paramsMap.put("children", "true");
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsDomainQueryResult = this.queryRsResourceGoodsPage(paramsMap);
        if (rsResourceGoodsDomainQueryResult == null || ListUtil.isEmpty((Collection)rsResourceGoodsDomainQueryResult.getList())) {
            return null;
        }
        return (RsResourceGoodsReDomain)rsResourceGoodsDomainQueryResult.getList().get(0);
    }

    @Override
    public String sendSaveExClass(Map<String, Object> resStream) {
        RsClasstreeDomain classtreeDomain;
        this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.rsBrandDomainisnull");
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsClasstreeDomain rsClasstreeDomain = (RsClasstreeDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), RsClasstreeDomain.class);
        String msg = GoodsParamCheckUtils.checkClasstreeParam(rsClasstreeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.msg");
            return this.makeErrorReturn(rsClasstreeDomain.getClasstreeEocode(), msg);
        }
        if (!"-1".equals(rsClasstreeDomain.getClasstreeParentcode())) {
            classtreeDomain = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeParentcode(), rsClasstreeDomain.getTenantCode());
            if (classtreeDomain == null) {
                return this.makeErrorReturn(rsClasstreeDomain.getClasstreeEocode(), "\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            }
            rsClasstreeDomain.setClasstreeParentcode(classtreeDomain.getClasstreeCode());
        }
        classtreeDomain = this.getRsClasstreeByCode(rsClasstreeDomain.getClasstreeEocode(), rsClasstreeDomain.getTenantCode());
        try {
            if (classtreeDomain == null) {
                String code = this.saveRsClasstree(rsClasstreeDomain);
                if (StringUtils.isNotBlank((String)code)) {
                    return this.makeSuccessReturn(rsClasstreeDomain.getClasstreeEocode());
                }
                this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.rsClasstreeDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
                return this.makeErrorReturn(rsClasstreeDomain.getClasstreeEocode(), "\u6570\u636e" + rsClasstreeDomain.getClasstreeEocode() + "\u62a5\u5b58\u5f02\u5e38");
            }
            this.updateRsClasstree(rsClasstreeDomain);
            return this.makeSuccessReturn(classtreeDomain.getClasstreeEocode());
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExClass.e", (Throwable)e);
            return this.makeErrorReturn(classtreeDomain.getClasstreeEocode(), e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.e1", (Throwable)e);
            return this.makeErrorReturn(classtreeDomain.getClasstreeEocode(), e.getMessage());
        }
    }

    @Override
    public String sendSaveExGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        RsGoodsClassDomain goodsClassDomain;
        if (rsGoodsClassDomain == null) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoodsClass.rsGoodsClassDomain");
            return "error";
        }
        String msg = GoodsParamCheckUtils.checkClasstreeShopParam(rsGoodsClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExGoodsClass.msg");
            return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExClass.msg", msg);
        }
        if (!"-1".equals(rsGoodsClassDomain.getGoodsClassParentcode())) {
            goodsClassDomain = this.getRsGoodsClassByCode(rsGoodsClassDomain.getGoodsClassParentcode(), rsGoodsClassDomain.getTenantCode());
            if (goodsClassDomain == null) {
                return this.makeErrorReturn("busdata.RsGoodsBaseService.sendSaveExClass.msg", "\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            }
            goodsClassDomain.setGoodsClassParentcode(goodsClassDomain.getGoodsClassCode());
        }
        if ((goodsClassDomain = this.getRsGoodsClassByCode(rsGoodsClassDomain.getGoodsClassEocode(), rsGoodsClassDomain.getTenantCode())) == null) {
            String code = this.saveRsGoodsClass(rsGoodsClassDomain);
            return this.makeSuccessReturn(code);
        }
        return this.makeSuccessReturn(goodsClassDomain.getGoodsClassCode());
    }

    @Override
    public String sendSaveExBrand(Map<String, Object> resStream) {
        this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.rsBrandDomainisnull");
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsBrandDomain rsBrandDomain = (RsBrandDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), RsBrandDomain.class);
        String msg = GoodsParamCheckUtils.checkBrandParam(rsBrandDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.msg");
            return this.makeErrorReturn(rsBrandDomain.getBrandEocode(), msg);
        }
        try {
            RsBrandDomain brandDomain = this.getBrandByEocode(rsBrandDomain.getBrandEocode(), rsBrandDomain.getTenantCode());
            if (brandDomain == null) {
                String code = this.saveRsBrand(rsBrandDomain);
                if (StringUtils.isNotBlank((String)code)) {
                    return this.makeSuccessReturn(rsBrandDomain.getBrandEocode());
                }
                rsBrandDomain.setBrandId(brandDomain.getBrandId());
                this.updateBrand(rsBrandDomain);
                this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.rsBrandDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsBrandDomain));
                return this.makeErrorReturn(rsBrandDomain.getBrandEocode(), "\u6570\u636e" + rsBrandDomain.getBrandEocode() + "\u4fee\u6539\u5f02\u5e38");
            }
            return this.makeSuccessReturn(brandDomain.getBrandCode());
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.e", (Throwable)e);
            return this.makeErrorReturn(rsBrandDomain.getBrandEocode(), e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveExBrand.e1", (Throwable)e);
            return this.makeErrorReturn(rsBrandDomain.getBrandEocode(), e.getMessage());
        }
    }

    @Override
    public String sendDeleteExBrand(String brandEocode, String tenantCode) {
        this.logger.error("busdata.RsGoodsBaseService.sendDeleteExBrand.map", (Object)JsonUtil.buildNormalBinder().toJson((Object)brandEocode));
        if (StringUtils.isEmpty((String)brandEocode) || StringUtils.isBlank((String)tenantCode)) {
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSkuOneReDomain skuOneByCode = this.getSkuOneByCode(brandEocode, tenantCode);
        if (null == skuOneByCode) {
            this.logger.error("busdata.RsGoodsBaseService.sendDeleteExBrand.msg" + brandEocode);
            return this.makeErrorReturn(brandEocode, "\u54c1\u724c\u4e0d\u5b58\u5728");
        }
        try {
            this.sendDeleteBrand(skuOneByCode.getSkuOneId());
            return this.makeSuccessReturn(brandEocode);
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.sendDeleteExBrand.e", (Throwable)e);
            return this.makeErrorReturn(brandEocode, e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendDeleteExBrand.e1", (Throwable)e);
            return this.makeErrorReturn(brandEocode, e.getMessage());
        }
    }

    @Override
    public String sendSaveOrUpdateSkuOne(Map<String, Object> resStream, String tenantCode) {
        this.logger.error("busdata.RsGoodsBaseService.sendSaveOrUpdateSkuOne.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream) || StringUtils.isBlank((String)tenantCode)) {
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSkuOneDomain rsSkuOneDomain = (RsSkuOneDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), RsSkuOneDomain.class);
        String msg = this.checkMap(rsSkuOneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveOrUpdateSkuOne.msg");
            return this.makeErrorReturn(rsSkuOneDomain.getSkuOneCode(), msg);
        }
        try {
            this.saveOrUpdateSkuOneAndSkuOneList(rsSkuOneDomain);
            return this.makeSuccessReturn(rsSkuOneDomain.getSkuOneCode());
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveOrUpdateSkuOne.e", (Throwable)e);
            return this.makeErrorReturn(rsSkuOneDomain.getSkuOneCode(), e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.sendSaveOrUpdateSkuOne.e1", (Throwable)e);
            return this.makeErrorReturn(rsSkuOneDomain.getSkuOneCode(), e.getMessage());
        }
    }

    @Override
    public String sendDeleteSkuOne(String skuOneCode, String tenantCode) {
        this.logger.error("busdata.RsGoodsBaseService.senddeleteSkuOne.map", (Object)JsonUtil.buildNormalBinder().toJson((Object)skuOneCode));
        if (StringUtils.isEmpty((String)skuOneCode) || StringUtils.isBlank((String)tenantCode)) {
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSkuOneReDomain skuOneByCode = this.getSkuOneByCode(skuOneCode, tenantCode);
        if (null == skuOneByCode) {
            this.logger.error("busdata.RsGoodsBaseService.senddeleteSkuOne.msg" + skuOneCode);
            return this.makeErrorReturn(skuOneCode, "\u7bb1\u5305\u6570\u4e0d\u5b58\u5728");
        }
        try {
            this.deleteSkuOne(skuOneByCode.getSkuOneId());
            return this.makeSuccessReturn(skuOneCode);
        }
        catch (ApiException e) {
            this.logger.error("busdata.RsGoodsBaseService.senddeleteSkuOne.e", (Throwable)e);
            return this.makeErrorReturn(skuOneCode, e.getErrMsg());
        }
        catch (Exception e) {
            this.logger.error("busdata.RsGoodsBaseService.senddeleteSkuOne.e1", (Throwable)e);
            return this.makeErrorReturn(skuOneCode, e.getMessage());
        }
    }

    private String checkMap(RsSkuOneDomain rsSkuOneDomain) {
        if (null == rsSkuOneDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuOneDomain.getSkuNo())) {
            msg = msg + "skuNo\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)rsSkuOneDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == rsSkuOneDomain.getSkuOneNum()) {
            msg = msg + "skuOneNum \u4e3a\u7a7a! ";
        }
        if (null == rsSkuOneDomain.getSkuOneCode()) {
            msg = msg + "skuOneCode \u4e3a\u7a7a! ";
        }
        return msg;
    }

    public static void main(String[] args) {
        String msg;
        RsResourceGoodsDomain rsResourceGoodsDomain1 = new RsResourceGoodsDomain();
        rsResourceGoodsDomain1.setGoodsName("\u7259\u818f");
        rsResourceGoodsDomain1.setGoodsId(112415);
        rsResourceGoodsDomain1.setGoodsEocode("123123123");
        rsResourceGoodsDomain1.setGoodsCode("123123123");
        rsResourceGoodsDomain1.setTenantCode("1264574587");
        rsResourceGoodsDomain1.setGoodsClass("1\u7c7b");
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        rsSkuDomain.setSkuEocode("1231");
        rsSkuDomain.setPricesetNprice(new BigDecimal(0));
        rsSkuDomain.setSkuName("11111");
        rsSkuDomainList.add(rsSkuDomain);
        rsResourceGoodsDomain1.setRsSkuDomainList(rsSkuDomainList);
        ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
        RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
        rsSpecValueDomain.setSpecCode("18a84d596d854306b95d449c28b9a873");
        rsSpecValueDomain.setSpecValueValue("111");
        rsSpecValueDomain.setSpecName("111");
        RsSpecValueDomain rsSpecValueDomain2 = new RsSpecValueDomain();
        rsSpecValueDomain2.setSpecCode("18a84d596d854306b95d449c28b9a873");
        rsSpecValueDomain2.setSpecValueValue("111");
        rsSpecValueDomain2.setSpecName("222");
        rsSpecValueDomainList.add(rsSpecValueDomain);
        rsSpecValueDomainList.add(rsSpecValueDomain2);
        rsResourceGoodsDomain1.setRsSpecValueDomainList(rsSpecValueDomainList);
        rsResourceGoodsDomain1.setGoodsOrigin("6");
        rsResourceGoodsDomain1.setPntreeName("\u7b2c\u4e8c\u79cd\u7c7b\u578b");
        rsResourceGoodsDomain1.setPntreeCode("000000098");
        rsResourceGoodsDomain1.setTenantCode("606480622092365916");
        rsResourceGoodsDomain1.setMemberCode("123132132");
        rsResourceGoodsDomain1.setClasstreeName("\u5546\u54c1\u5206\u7c7b\u4ee3\u7801");
        rsResourceGoodsDomain1.setPartsnameName("\u54c1\u540d");
        rsResourceGoodsDomain1.setSpuCode("123131");
        rsResourceGoodsDomain1.setGoodsSpec("123131");
        String resStream = JSONObject.toJSONString((Object)rsResourceGoodsDomain1);
        System.out.println(resStream);
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(resStream, RsResourceGoodsDomain.class);
        if (rsResourceGoodsDomain == null) {
            // empty if block
        }
        if (StringUtils.isNotBlank((String)(msg = GoodsParamCheckUtils.checkGoodsParam(rsResourceGoodsDomain)))) {
            // empty if block
        }
    }
}

