/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksSourceAreacodeMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceAreacodeDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceAreacodeReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksSourceAreacode;
import com.yqbsoft.laser.service.ext.skshu.service.SksSourceAreacodeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksSourceAreacodeServiceImpl
extends BaseServiceImpl
implements SksSourceAreacodeService {
    private static final String SYS_CODE = "busdata.SksSourceAreacodeServiceImpl";
    private SksSourceAreacodeMapper sksSourceAreacodeMapper;

    public void setSksSourceAreacodeMapper(SksSourceAreacodeMapper sksSourceAreacodeMapper) {
        this.sksSourceAreacodeMapper = sksSourceAreacodeMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksSourceAreacodeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceAreacodeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSourceAreacode(SksSourceAreacodeDomain sksSourceAreacodeDomain) {
        if (null == sksSourceAreacodeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksSourceAreacodeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSourceAreacodeDefault(SksSourceAreacode sksSourceAreacode) {
        if (null == sksSourceAreacode) {
            return;
        }
        if (null == sksSourceAreacode.getDataState()) {
            sksSourceAreacode.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksSourceAreacode.getGmtCreate()) {
            sksSourceAreacode.setGmtCreate(date);
        }
        sksSourceAreacode.setGmtModified(date);
        if (StringUtils.isBlank((String)sksSourceAreacode.getAreaCode())) {
            sksSourceAreacode.setAreaCode(this.getNo(null, "SksSourceAreacode", "sksSourceAreacode", sksSourceAreacode.getTenantCode()));
        }
    }

    private int getSourceAreacodeMaxCode() {
        int code = 0;
        try {
            return this.sksSourceAreacodeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceAreacodeServiceImpl.getSourceAreacodeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSourceAreacodeUpdataDefault(SksSourceAreacode sksSourceAreacode) {
        if (null == sksSourceAreacode) {
            return;
        }
        sksSourceAreacode.setGmtModified(this.getSysDate());
    }

    private void saveSourceAreacodeModel(SksSourceAreacode sksSourceAreacode) throws ApiException {
        if (null == sksSourceAreacode) {
            return;
        }
        try {
            this.sksSourceAreacodeMapper.insert(sksSourceAreacode);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.saveSourceAreacodeModel.ex", (Throwable)e);
        }
    }

    private void saveSourceAreacodeBatchModel(List<SksSourceAreacode> sksSourceAreacodeList) throws ApiException {
        if (null == sksSourceAreacodeList || sksSourceAreacodeList.isEmpty()) {
            return;
        }
        try {
            this.sksSourceAreacodeMapper.insertBatch(sksSourceAreacodeList);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.saveSourceAreacodeBatchModel.ex", (Throwable)e);
        }
    }

    private SksSourceAreacode getSourceAreacodeModelById(String id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksSourceAreacodeMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceAreacodeServiceImpl.getSourceAreacodeModelById", (Throwable)e);
            return null;
        }
    }

    private SksSourceAreacode getSourceAreacodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSourceAreacodeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceAreacodeServiceImpl.getSourceAreacodeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSourceAreacodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceAreacodeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.delSourceAreacodeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.delSourceAreacodeModelByCode.num");
        }
    }

    private void deleteSourceAreacodeModel(String id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceAreacodeMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.deleteSourceAreacodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.deleteSourceAreacodeModel.num");
        }
    }

    private void updateSourceAreacodeModel(SksSourceAreacode sksSourceAreacode) throws ApiException {
        if (null == sksSourceAreacode) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceAreacodeMapper.updateByPrimaryKey(sksSourceAreacode);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.updateSourceAreacodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.updateSourceAreacodeModel.num");
        }
    }

    private void updateStateSourceAreacodeModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceAreacodeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.updateStateSourceAreacodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.updateStateSourceAreacodeModel.null");
        }
    }

    private void updateStateSourceAreacodeModelByCode(String tenantCode, String areaCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)areaCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("areaCode", areaCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceAreacodeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.updateStateSourceAreacodeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.updateStateSourceAreacodeModelByCode.null");
        }
    }

    private SksSourceAreacode makeSourceAreacode(SksSourceAreacodeDomain sksSourceAreacodeDomain, SksSourceAreacode sksSourceAreacode) {
        if (null == sksSourceAreacodeDomain) {
            return null;
        }
        if (null == sksSourceAreacode) {
            sksSourceAreacode = new SksSourceAreacode();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceAreacode, (Object)sksSourceAreacodeDomain);
            return sksSourceAreacode;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceAreacodeServiceImpl.makeSourceAreacode", (Throwable)e);
            return null;
        }
    }

    private SksSourceAreacodeReDomain makeSksSourceAreacodeReDomain(SksSourceAreacode sksSourceAreacode) {
        if (null == sksSourceAreacode) {
            return null;
        }
        SksSourceAreacodeReDomain sksSourceAreacodeReDomain = new SksSourceAreacodeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceAreacodeReDomain, (Object)sksSourceAreacode);
            return sksSourceAreacodeReDomain;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceAreacodeServiceImpl.makeSksSourceAreacodeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksSourceAreacode> querySourceAreacodeModelPage(Map<String, Object> parammap) {
        try {
            return this.sksSourceAreacodeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceAreacodeServiceImpl.querySourceAreacodeModel", (Throwable)e);
            return null;
        }
    }

    private int countSourceAreacode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksSourceAreacodeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceAreacodeServiceImpl.countSourceAreacode", (Throwable)e);
        }
        return i;
    }

    private SksSourceAreacode createSksSourceAreacode(SksSourceAreacodeDomain sksSourceAreacodeDomain) {
        String msg = this.checkSourceAreacode(sksSourceAreacodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.saveSourceAreacode.checkSourceAreacode", msg);
        }
        SksSourceAreacode sksSourceAreacode = this.makeSourceAreacode(sksSourceAreacodeDomain, null);
        this.setSourceAreacodeDefault(sksSourceAreacode);
        return sksSourceAreacode;
    }

    @Override
    public String saveSourceAreacode(SksSourceAreacodeDomain sksSourceAreacodeDomain) throws ApiException {
        SksSourceAreacode sksSourceAreacode = this.createSksSourceAreacode(sksSourceAreacodeDomain);
        this.saveSourceAreacodeModel(sksSourceAreacode);
        return sksSourceAreacode.getAreaCode();
    }

    @Override
    public String saveSourceAreacodeBatch(List<SksSourceAreacodeDomain> sksSourceAreacodeDomainList) throws ApiException {
        if (null == sksSourceAreacodeDomainList || sksSourceAreacodeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksSourceAreacode> sksSourceAreacodeList = new ArrayList<SksSourceAreacode>();
        String code = "";
        for (SksSourceAreacodeDomain sksSourceAreacodeDomain : sksSourceAreacodeDomainList) {
            SksSourceAreacode sksSourceAreacode = this.createSksSourceAreacode(sksSourceAreacodeDomain);
            code = sksSourceAreacode.getAreaCode();
            sksSourceAreacodeList.add(sksSourceAreacode);
        }
        this.saveSourceAreacodeBatchModel(sksSourceAreacodeList);
        return code;
    }

    @Override
    public void updateSourceAreacodeState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateSourceAreacodeModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceAreacodeStateByCode(String tenantCode, String areaCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)areaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSourceAreacodeModelByCode(tenantCode, areaCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceAreacode(SksSourceAreacodeDomain sksSourceAreacodeDomain) throws ApiException {
        String msg = this.checkSourceAreacode(sksSourceAreacodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.updateSourceAreacode.checkSourceAreacode", msg);
        }
        SksSourceAreacode oldSksSourceAreacode = this.getSourceAreacodeModelById(sksSourceAreacodeDomain.getId());
        if (null == oldSksSourceAreacode) {
            throw new ApiException("busdata.SksSourceAreacodeServiceImpl.updateSourceAreacode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksSourceAreacode sksSourceAreacode = this.makeSourceAreacode(sksSourceAreacodeDomain, oldSksSourceAreacode);
        this.setSourceAreacodeUpdataDefault(sksSourceAreacode);
        this.updateSourceAreacodeModel(sksSourceAreacode);
    }

    @Override
    public SksSourceAreacode getSourceAreacode(String id) {
        if (null == id) {
            return null;
        }
        return this.getSourceAreacodeModelById(id);
    }

    @Override
    public void deleteSourceAreacode(String id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteSourceAreacodeModel(id);
    }

    @Override
    public QueryResult<SksSourceAreacode> querySourceAreacodePage(Map<String, Object> map) {
        List<SksSourceAreacode> sksSourceAreacodeList = this.querySourceAreacodeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSourceAreacode(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksSourceAreacodeList);
        return queryResult;
    }

    @Override
    public SksSourceAreacode getSourceAreacodeByCode(String tenantCode, String areaCode) throws ApiException {
        if (StringUtils.isBlank((String)areaCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("areaCode", areaCode);
        return this.getSourceAreacodeModelByCode(map);
    }

    @Override
    public void deleteSourceAreacodeByCode(String tenantCode, String areaCode) throws ApiException {
        if (StringUtils.isBlank((String)areaCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("areaCode", areaCode);
        this.delSourceAreacodeModelByCode(map);
    }
}

