/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksSourceCategoryMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceCategoryDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceCategoryReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksSourceCategory;
import com.yqbsoft.laser.service.ext.skshu.service.SksSourceCategoryService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksSourceCategoryServiceImpl
extends BaseServiceImpl
implements SksSourceCategoryService {
    private static final String SYS_CODE = "busdata.SksSourceCategoryServiceImpl";
    private SksSourceCategoryMapper sksSourceCategoryMapper;

    public void setSksSourceCategoryMapper(SksSourceCategoryMapper sksSourceCategoryMapper) {
        this.sksSourceCategoryMapper = sksSourceCategoryMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksSourceCategoryMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceCategoryServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain) {
        if (null == sksSourceCategoryDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksSourceCategoryDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSourceCategoryDefault(SksSourceCategory sksSourceCategory) {
        if (null == sksSourceCategory) {
            return;
        }
        if (null == sksSourceCategory.getDataState()) {
            sksSourceCategory.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksSourceCategory.getGmtCreate()) {
            sksSourceCategory.setGmtCreate(date);
        }
        sksSourceCategory.setGmtModified(date);
        if (StringUtils.isBlank((String)sksSourceCategory.getCategoryCode())) {
            sksSourceCategory.setCategoryCode(this.getNo(null, "SksSourceCategory", "sksSourceCategory", sksSourceCategory.getTenantCode()));
        }
    }

    private int getSourceCategoryMaxCode() {
        int code = 0;
        try {
            return this.sksSourceCategoryMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceCategoryServiceImpl.getSourceCategoryMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSourceCategoryUpdataDefault(SksSourceCategory sksSourceCategory) {
        if (null == sksSourceCategory) {
            return;
        }
        sksSourceCategory.setGmtModified(this.getSysDate());
    }

    private void saveSourceCategoryModel(SksSourceCategory sksSourceCategory) throws ApiException {
        if (null == sksSourceCategory) {
            return;
        }
        try {
            this.sksSourceCategoryMapper.insert(sksSourceCategory);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.saveSourceCategoryModel.ex", (Throwable)e);
        }
    }

    private void saveSourceCategoryBatchModel(List<SksSourceCategory> sksSourceCategoryList) throws ApiException {
        if (null == sksSourceCategoryList || sksSourceCategoryList.isEmpty()) {
            return;
        }
        try {
            this.sksSourceCategoryMapper.insertBatch(sksSourceCategoryList);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.saveSourceCategoryBatchModel.ex", (Throwable)e);
        }
    }

    private SksSourceCategory getSourceCategoryModelById(String id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksSourceCategoryMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceCategoryServiceImpl.getSourceCategoryModelById", (Throwable)e);
            return null;
        }
    }

    private SksSourceCategory getSourceCategoryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSourceCategoryMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceCategoryServiceImpl.getSourceCategoryModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSourceCategoryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.delSourceCategoryModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.delSourceCategoryModelByCode.num");
        }
    }

    private void deleteSourceCategoryModel(String id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.deleteSourceCategoryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.deleteSourceCategoryModel.num");
        }
    }

    private void updateSourceCategoryModel(SksSourceCategory sksSourceCategory) throws ApiException {
        if (null == sksSourceCategory) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.updateByPrimaryKey(sksSourceCategory);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.updateSourceCategoryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.updateSourceCategoryModel.num");
        }
    }

    private void updateStateSourceCategoryModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.updateStateSourceCategoryModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.updateStateSourceCategoryModel.null");
        }
    }

    private void updateStateSourceCategoryModelByCode(String tenantCode, String categoryCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)categoryCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("categoryCode", categoryCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.updateStateSourceCategoryModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.updateStateSourceCategoryModelByCode.null");
        }
    }

    private SksSourceCategory makeSourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain, SksSourceCategory sksSourceCategory) {
        if (null == sksSourceCategoryDomain) {
            return null;
        }
        if (null == sksSourceCategory) {
            sksSourceCategory = new SksSourceCategory();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceCategory, (Object)sksSourceCategoryDomain);
            return sksSourceCategory;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceCategoryServiceImpl.makeSourceCategory", (Throwable)e);
            return null;
        }
    }

    private SksSourceCategoryReDomain makeSksSourceCategoryReDomain(SksSourceCategory sksSourceCategory) {
        if (null == sksSourceCategory) {
            return null;
        }
        SksSourceCategoryReDomain sksSourceCategoryReDomain = new SksSourceCategoryReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceCategoryReDomain, (Object)sksSourceCategory);
            return sksSourceCategoryReDomain;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceCategoryServiceImpl.makeSksSourceCategoryReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksSourceCategory> querySourceCategoryModelPage(Map<String, Object> parammap) {
        try {
            return this.sksSourceCategoryMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceCategoryServiceImpl.querySourceCategoryModel", (Throwable)e);
            return null;
        }
    }

    private int countSourceCategory(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksSourceCategoryMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceCategoryServiceImpl.countSourceCategory", (Throwable)e);
        }
        return i;
    }

    private SksSourceCategory createSksSourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain) {
        String msg = this.checkSourceCategory(sksSourceCategoryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.saveSourceCategory.checkSourceCategory", msg);
        }
        SksSourceCategory sksSourceCategory = this.makeSourceCategory(sksSourceCategoryDomain, null);
        this.setSourceCategoryDefault(sksSourceCategory);
        return sksSourceCategory;
    }

    @Override
    public String saveSourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain) throws ApiException {
        SksSourceCategory sksSourceCategory = this.createSksSourceCategory(sksSourceCategoryDomain);
        this.saveSourceCategoryModel(sksSourceCategory);
        return sksSourceCategory.getCategoryCode();
    }

    @Override
    public String saveSourceCategoryBatch(List<SksSourceCategoryDomain> sksSourceCategoryDomainList) throws ApiException {
        if (null == sksSourceCategoryDomainList || sksSourceCategoryDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksSourceCategory> sksSourceCategoryList = new ArrayList<SksSourceCategory>();
        String code = "";
        for (SksSourceCategoryDomain sksSourceCategoryDomain : sksSourceCategoryDomainList) {
            SksSourceCategory sksSourceCategory = this.createSksSourceCategory(sksSourceCategoryDomain);
            code = sksSourceCategory.getCategoryCode();
            sksSourceCategoryList.add(sksSourceCategory);
        }
        this.saveSourceCategoryBatchModel(sksSourceCategoryList);
        return code;
    }

    @Override
    public void updateSourceCategoryState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateSourceCategoryModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceCategoryStateByCode(String tenantCode, String categoryCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)categoryCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSourceCategoryModelByCode(tenantCode, categoryCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceCategory(SksSourceCategoryDomain sksSourceCategoryDomain) throws ApiException {
        String msg = this.checkSourceCategory(sksSourceCategoryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.updateSourceCategory.checkSourceCategory", msg);
        }
        SksSourceCategory oldSksSourceCategory = this.getSourceCategoryModelById(sksSourceCategoryDomain.getId());
        if (null == oldSksSourceCategory) {
            throw new ApiException("busdata.SksSourceCategoryServiceImpl.updateSourceCategory.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksSourceCategory sksSourceCategory = this.makeSourceCategory(sksSourceCategoryDomain, oldSksSourceCategory);
        this.setSourceCategoryUpdataDefault(sksSourceCategory);
        this.updateSourceCategoryModel(sksSourceCategory);
    }

    @Override
    public SksSourceCategory getSourceCategory(String id) {
        if (null == id) {
            return null;
        }
        return this.getSourceCategoryModelById(id);
    }

    @Override
    public void deleteSourceCategory(String id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteSourceCategoryModel(id);
    }

    @Override
    public QueryResult<SksSourceCategory> querySourceCategoryPage(Map<String, Object> map) {
        List<SksSourceCategory> sksSourceCategoryList = this.querySourceCategoryModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSourceCategory(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksSourceCategoryList);
        return queryResult;
    }

    @Override
    public SksSourceCategory getSourceCategoryByCode(String tenantCode, String categoryCode) throws ApiException {
        if (StringUtils.isBlank((String)categoryCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("categoryCode", categoryCode);
        return this.getSourceCategoryModelByCode(map);
    }

    @Override
    public void deleteSourceCategoryByCode(String tenantCode, String categoryCode) throws ApiException {
        if (StringUtils.isBlank((String)categoryCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("categoryCode", categoryCode);
        this.delSourceCategoryModelByCode(map);
    }
}

