/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksSourceOrgunitMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceOrgunitDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceOrgunitReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksSourceOrgunit;
import com.yqbsoft.laser.service.ext.skshu.service.SksSourceOrgunitService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksSourceOrgunitServiceImpl
extends BaseServiceImpl
implements SksSourceOrgunitService {
    private static final String SYS_CODE = "busdata.SksSourceOrgunitServiceImpl";
    private SksSourceOrgunitMapper sksSourceOrgunitMapper;

    public void setSksSourceOrgunitMapper(SksSourceOrgunitMapper sksSourceOrgunitMapper) {
        this.sksSourceOrgunitMapper = sksSourceOrgunitMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksSourceOrgunitMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceOrgunitServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSourceOrgunit(SksSourceOrgunitDomain sksSourceOrgunitDomain) {
        if (null == sksSourceOrgunitDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksSourceOrgunitDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSourceOrgunitDefault(SksSourceOrgunit sksSourceOrgunit) {
        if (null == sksSourceOrgunit) {
            return;
        }
        if (null == sksSourceOrgunit.getDataState()) {
            sksSourceOrgunit.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksSourceOrgunit.getGmtCreate()) {
            sksSourceOrgunit.setGmtCreate(date);
        }
        sksSourceOrgunit.setGmtModified(date);
        if (StringUtils.isBlank((String)sksSourceOrgunit.getOrgunitCode())) {
            sksSourceOrgunit.setOrgunitCode(this.getNo(null, "SksSourceOrgunit", "sksSourceOrgunit", sksSourceOrgunit.getTenantCode()));
        }
    }

    private int getSourceOrgunitMaxCode() {
        int code = 0;
        try {
            return this.sksSourceOrgunitMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceOrgunitServiceImpl.getSourceOrgunitMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSourceOrgunitUpdataDefault(SksSourceOrgunit sksSourceOrgunit) {
        if (null == sksSourceOrgunit) {
            return;
        }
        sksSourceOrgunit.setGmtModified(this.getSysDate());
    }

    private void saveSourceOrgunitModel(SksSourceOrgunit sksSourceOrgunit) throws ApiException {
        if (null == sksSourceOrgunit) {
            return;
        }
        try {
            this.sksSourceOrgunitMapper.insert(sksSourceOrgunit);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.saveSourceOrgunitModel.ex", (Throwable)e);
        }
    }

    private void saveSourceOrgunitBatchModel(List<SksSourceOrgunit> sksSourceOrgunitList) throws ApiException {
        if (null == sksSourceOrgunitList || sksSourceOrgunitList.isEmpty()) {
            return;
        }
        try {
            this.sksSourceOrgunitMapper.insertBatch(sksSourceOrgunitList);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.saveSourceOrgunitBatchModel.ex", (Throwable)e);
        }
    }

    private SksSourceOrgunit getSourceOrgunitModelById(String id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksSourceOrgunitMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceOrgunitServiceImpl.getSourceOrgunitModelById", (Throwable)e);
            return null;
        }
    }

    private SksSourceOrgunit getSourceOrgunitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSourceOrgunitMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceOrgunitServiceImpl.getSourceOrgunitModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSourceOrgunitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceOrgunitMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.delSourceOrgunitModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.delSourceOrgunitModelByCode.num");
        }
    }

    private void deleteSourceOrgunitModel(String id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceOrgunitMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.deleteSourceOrgunitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.deleteSourceOrgunitModel.num");
        }
    }

    private void updateSourceOrgunitModel(SksSourceOrgunit sksSourceOrgunit) throws ApiException {
        if (null == sksSourceOrgunit) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceOrgunitMapper.updateByPrimaryKey(sksSourceOrgunit);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.updateSourceOrgunitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.updateSourceOrgunitModel.num");
        }
    }

    private void updateStateSourceOrgunitModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceOrgunitMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.updateStateSourceOrgunitModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.updateStateSourceOrgunitModel.null");
        }
    }

    private void updateStateSourceOrgunitModelByCode(String tenantCode, String orgunitCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)orgunitCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orgunitCode", orgunitCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceOrgunitMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.updateStateSourceOrgunitModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.updateStateSourceOrgunitModelByCode.null");
        }
    }

    private SksSourceOrgunit makeSourceOrgunit(SksSourceOrgunitDomain sksSourceOrgunitDomain, SksSourceOrgunit sksSourceOrgunit) {
        if (null == sksSourceOrgunitDomain) {
            return null;
        }
        if (null == sksSourceOrgunit) {
            sksSourceOrgunit = new SksSourceOrgunit();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceOrgunit, (Object)sksSourceOrgunitDomain);
            return sksSourceOrgunit;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceOrgunitServiceImpl.makeSourceOrgunit", (Throwable)e);
            return null;
        }
    }

    private SksSourceOrgunitReDomain makeSksSourceOrgunitReDomain(SksSourceOrgunit sksSourceOrgunit) {
        if (null == sksSourceOrgunit) {
            return null;
        }
        SksSourceOrgunitReDomain sksSourceOrgunitReDomain = new SksSourceOrgunitReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceOrgunitReDomain, (Object)sksSourceOrgunit);
            return sksSourceOrgunitReDomain;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceOrgunitServiceImpl.makeSksSourceOrgunitReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksSourceOrgunit> querySourceOrgunitModelPage(Map<String, Object> parammap) {
        try {
            return this.sksSourceOrgunitMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceOrgunitServiceImpl.querySourceOrgunitModel", (Throwable)e);
            return null;
        }
    }

    private int countSourceOrgunit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksSourceOrgunitMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceOrgunitServiceImpl.countSourceOrgunit", (Throwable)e);
        }
        return i;
    }

    private SksSourceOrgunit createSksSourceOrgunit(SksSourceOrgunitDomain sksSourceOrgunitDomain) {
        String msg = this.checkSourceOrgunit(sksSourceOrgunitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.saveSourceOrgunit.checkSourceOrgunit", msg);
        }
        SksSourceOrgunit sksSourceOrgunit = this.makeSourceOrgunit(sksSourceOrgunitDomain, null);
        this.setSourceOrgunitDefault(sksSourceOrgunit);
        return sksSourceOrgunit;
    }

    @Override
    public String saveSourceOrgunit(SksSourceOrgunitDomain sksSourceOrgunitDomain) throws ApiException {
        SksSourceOrgunit sksSourceOrgunit = this.createSksSourceOrgunit(sksSourceOrgunitDomain);
        this.saveSourceOrgunitModel(sksSourceOrgunit);
        return sksSourceOrgunit.getOrgunitCode();
    }

    @Override
    public String saveSourceOrgunitBatch(List<SksSourceOrgunitDomain> sksSourceOrgunitDomainList) throws ApiException {
        if (null == sksSourceOrgunitDomainList || sksSourceOrgunitDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksSourceOrgunit> sksSourceOrgunitList = new ArrayList<SksSourceOrgunit>();
        String code = "";
        for (SksSourceOrgunitDomain sksSourceOrgunitDomain : sksSourceOrgunitDomainList) {
            SksSourceOrgunit sksSourceOrgunit = this.createSksSourceOrgunit(sksSourceOrgunitDomain);
            code = sksSourceOrgunit.getOrgunitCode();
            sksSourceOrgunitList.add(sksSourceOrgunit);
        }
        this.saveSourceOrgunitBatchModel(sksSourceOrgunitList);
        return code;
    }

    @Override
    public void updateSourceOrgunitState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateSourceOrgunitModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceOrgunitStateByCode(String tenantCode, String orgunitCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)orgunitCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSourceOrgunitModelByCode(tenantCode, orgunitCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceOrgunit(SksSourceOrgunitDomain sksSourceOrgunitDomain) throws ApiException {
        String msg = this.checkSourceOrgunit(sksSourceOrgunitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.updateSourceOrgunit.checkSourceOrgunit", msg);
        }
        SksSourceOrgunit oldSksSourceOrgunit = this.getSourceOrgunitModelById(sksSourceOrgunitDomain.getId());
        if (null == oldSksSourceOrgunit) {
            throw new ApiException("busdata.SksSourceOrgunitServiceImpl.updateSourceOrgunit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksSourceOrgunit sksSourceOrgunit = this.makeSourceOrgunit(sksSourceOrgunitDomain, oldSksSourceOrgunit);
        this.setSourceOrgunitUpdataDefault(sksSourceOrgunit);
        this.updateSourceOrgunitModel(sksSourceOrgunit);
    }

    @Override
    public SksSourceOrgunit getSourceOrgunit(String id) {
        if (null == id) {
            return null;
        }
        return this.getSourceOrgunitModelById(id);
    }

    @Override
    public void deleteSourceOrgunit(String id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteSourceOrgunitModel(id);
    }

    @Override
    public QueryResult<SksSourceOrgunit> querySourceOrgunitPage(Map<String, Object> map) {
        List<SksSourceOrgunit> sksSourceOrgunitList = this.querySourceOrgunitModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSourceOrgunit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksSourceOrgunitList);
        return queryResult;
    }

    @Override
    public SksSourceOrgunit getSourceOrgunitByCode(String tenantCode, String orgunitCode) throws ApiException {
        if (StringUtils.isBlank((String)orgunitCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orgunitCode", orgunitCode);
        return this.getSourceOrgunitModelByCode(map);
    }

    @Override
    public void deleteSourceOrgunitByCode(String tenantCode, String orgunitCode) throws ApiException {
        if (StringUtils.isBlank((String)orgunitCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orgunitCode", orgunitCode);
        this.delSourceOrgunitModelByCode(map);
    }
}

