/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksSourceProdMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceProdDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceProdReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksSourceProd;
import com.yqbsoft.laser.service.ext.skshu.service.SksSourceProdService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksSourceProdServiceImpl
extends BaseServiceImpl
implements SksSourceProdService {
    private static final String SYS_CODE = "busdata.SksSourceProdServiceImpl";
    private SksSourceProdMapper sksSourceProdMapper;

    public void setSksSourceProdMapper(SksSourceProdMapper sksSourceProdMapper) {
        this.sksSourceProdMapper = sksSourceProdMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksSourceProdMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceProdServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSourceProd(SksSourceProdDomain sksSourceProdDomain) {
        if (null == sksSourceProdDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksSourceProdDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSourceProdDefault(SksSourceProd sksSourceProd) {
        if (null == sksSourceProd) {
            return;
        }
        if (null == sksSourceProd.getDataState()) {
            sksSourceProd.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksSourceProd.getGmtCreate()) {
            sksSourceProd.setGmtCreate(date);
        }
        sksSourceProd.setGmtModified(date);
        if (StringUtils.isBlank((String)sksSourceProd.getProdCode())) {
            sksSourceProd.setProdCode(this.getNo(null, "SksSourceProd", "sksSourceProd", sksSourceProd.getTenantCode()));
        }
    }

    private int getSourceProdMaxCode() {
        int code = 0;
        try {
            return this.sksSourceProdMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceProdServiceImpl.getSourceProdMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSourceProdUpdataDefault(SksSourceProd sksSourceProd) {
        if (null == sksSourceProd) {
            return;
        }
        sksSourceProd.setGmtModified(this.getSysDate());
    }

    private void saveSourceProdModel(SksSourceProd sksSourceProd) throws ApiException {
        if (null == sksSourceProd) {
            return;
        }
        try {
            this.sksSourceProdMapper.insert(sksSourceProd);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.saveSourceProdModel.ex", (Throwable)e);
        }
    }

    private void saveSourceProdBatchModel(List<SksSourceProd> sksSourceProdList) throws ApiException {
        if (null == sksSourceProdList || sksSourceProdList.isEmpty()) {
            return;
        }
        try {
            this.sksSourceProdMapper.insertBatch(sksSourceProdList);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.saveSourceProdBatchModel.ex", (Throwable)e);
        }
    }

    private SksSourceProd getSourceProdModelById(String id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksSourceProdMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceProdServiceImpl.getSourceProdModelById", (Throwable)e);
            return null;
        }
    }

    private SksSourceProd getSourceProdModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSourceProdMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceProdServiceImpl.getSourceProdModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSourceProdModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceProdMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.delSourceProdModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.delSourceProdModelByCode.num");
        }
    }

    private void deleteSourceProdModel(String id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceProdMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.deleteSourceProdModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.deleteSourceProdModel.num");
        }
    }

    private void updateSourceProdModel(SksSourceProd sksSourceProd) throws ApiException {
        if (null == sksSourceProd) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceProdMapper.updateByPrimaryKey(sksSourceProd);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.updateSourceProdModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.updateSourceProdModel.num");
        }
    }

    private void updateStateSourceProdModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceProdMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.updateStateSourceProdModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.updateStateSourceProdModel.null");
        }
    }

    private void updateStateSourceProdModelByCode(String tenantCode, String prodCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)prodCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("prodCode", prodCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceProdMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.updateStateSourceProdModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.updateStateSourceProdModelByCode.null");
        }
    }

    private SksSourceProd makeSourceProd(SksSourceProdDomain sksSourceProdDomain, SksSourceProd sksSourceProd) {
        if (null == sksSourceProdDomain) {
            return null;
        }
        if (null == sksSourceProd) {
            sksSourceProd = new SksSourceProd();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceProd, (Object)sksSourceProdDomain);
            return sksSourceProd;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceProdServiceImpl.makeSourceProd", (Throwable)e);
            return null;
        }
    }

    private SksSourceProdReDomain makeSksSourceProdReDomain(SksSourceProd sksSourceProd) {
        if (null == sksSourceProd) {
            return null;
        }
        SksSourceProdReDomain sksSourceProdReDomain = new SksSourceProdReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceProdReDomain, (Object)sksSourceProd);
            return sksSourceProdReDomain;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceProdServiceImpl.makeSksSourceProdReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksSourceProd> querySourceProdModelPage(Map<String, Object> parammap) {
        try {
            return this.sksSourceProdMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceProdServiceImpl.querySourceProdModel", (Throwable)e);
            return null;
        }
    }

    private int countSourceProd(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksSourceProdMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceProdServiceImpl.countSourceProd", (Throwable)e);
        }
        return i;
    }

    private SksSourceProd createSksSourceProd(SksSourceProdDomain sksSourceProdDomain) {
        String msg = this.checkSourceProd(sksSourceProdDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.saveSourceProd.checkSourceProd", msg);
        }
        SksSourceProd sksSourceProd = this.makeSourceProd(sksSourceProdDomain, null);
        this.setSourceProdDefault(sksSourceProd);
        return sksSourceProd;
    }

    @Override
    public String saveSourceProd(SksSourceProdDomain sksSourceProdDomain) throws ApiException {
        SksSourceProd sksSourceProd = this.createSksSourceProd(sksSourceProdDomain);
        this.saveSourceProdModel(sksSourceProd);
        return sksSourceProd.getProdCode();
    }

    @Override
    public String saveSourceProdBatch(List<SksSourceProdDomain> sksSourceProdDomainList) throws ApiException {
        if (null == sksSourceProdDomainList || sksSourceProdDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksSourceProd> sksSourceProdList = new ArrayList<SksSourceProd>();
        String code = "";
        for (SksSourceProdDomain sksSourceProdDomain : sksSourceProdDomainList) {
            SksSourceProd sksSourceProd = this.createSksSourceProd(sksSourceProdDomain);
            code = sksSourceProd.getProdCode();
            sksSourceProdList.add(sksSourceProd);
        }
        this.saveSourceProdBatchModel(sksSourceProdList);
        return code;
    }

    @Override
    public void updateSourceProdState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateSourceProdModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceProdStateByCode(String tenantCode, String prodCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)prodCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSourceProdModelByCode(tenantCode, prodCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceProd(SksSourceProdDomain sksSourceProdDomain) throws ApiException {
        String msg = this.checkSourceProd(sksSourceProdDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.updateSourceProd.checkSourceProd", msg);
        }
        SksSourceProd oldSksSourceProd = this.getSourceProdModelById(sksSourceProdDomain.getId());
        if (null == oldSksSourceProd) {
            throw new ApiException("busdata.SksSourceProdServiceImpl.updateSourceProd.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksSourceProd sksSourceProd = this.makeSourceProd(sksSourceProdDomain, oldSksSourceProd);
        this.setSourceProdUpdataDefault(sksSourceProd);
        this.updateSourceProdModel(sksSourceProd);
    }

    @Override
    public SksSourceProd getSourceProd(String id) {
        if (null == id) {
            return null;
        }
        return this.getSourceProdModelById(id);
    }

    @Override
    public void deleteSourceProd(String id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteSourceProdModel(id);
    }

    @Override
    public QueryResult<SksSourceProd> querySourceProdPage(Map<String, Object> map) {
        List<SksSourceProd> sksSourceProdList = this.querySourceProdModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSourceProd(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksSourceProdList);
        return queryResult;
    }

    @Override
    public SksSourceProd getSourceProdByCode(String tenantCode, String prodCode) throws ApiException {
        if (StringUtils.isBlank((String)prodCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("prodCode", prodCode);
        return this.getSourceProdModelByCode(map);
    }

    @Override
    public void deleteSourceProdByCode(String tenantCode, String prodCode) throws ApiException {
        if (StringUtils.isBlank((String)prodCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("prodCode", prodCode);
        this.delSourceProdModelByCode(map);
    }
}

