/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksSourceSelectitemMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceSelectitemDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSourceSelectitemReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksSourceSelectitem;
import com.yqbsoft.laser.service.ext.skshu.service.SksSourceSelectitemService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksSourceSelectitemServiceImpl
extends BaseServiceImpl
implements SksSourceSelectitemService {
    private static final String SYS_CODE = "busdata.SksSourceSelectitemServiceImpl";
    private SksSourceSelectitemMapper sksSourceSelectitemMapper;

    public void setSksSourceSelectitemMapper(SksSourceSelectitemMapper sksSourceSelectitemMapper) {
        this.sksSourceSelectitemMapper = sksSourceSelectitemMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksSourceSelectitemMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceSelectitemServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSourceSelectitem(SksSourceSelectitemDomain sksSourceSelectitemDomain) {
        if (null == sksSourceSelectitemDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksSourceSelectitemDomain.getSelectitemcode())) {
            msg = msg + "SelectitemCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)sksSourceSelectitemDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSourceSelectitemDefault(SksSourceSelectitem sksSourceSelectitem) {
        if (null == sksSourceSelectitem) {
            return;
        }
        if (null == sksSourceSelectitem.getDataState()) {
            sksSourceSelectitem.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksSourceSelectitem.getGmtCreate()) {
            sksSourceSelectitem.setGmtCreate(date);
        }
        sksSourceSelectitem.setGmtModified(date);
        if (StringUtils.isBlank((String)sksSourceSelectitem.getSelectitemCode())) {
            sksSourceSelectitem.setSelectitemCode(this.getNo(null, "SksSourceSelectitem", "sksSourceSelectitem", sksSourceSelectitem.getTenantCode()));
        }
    }

    private int getSourceSelectitemMaxCode() {
        int code = 0;
        try {
            return this.sksSourceSelectitemMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceSelectitemServiceImpl.getSourceSelectitemMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSourceSelectitemUpdataDefault(SksSourceSelectitem sksSourceSelectitem) {
        if (null == sksSourceSelectitem) {
            return;
        }
        sksSourceSelectitem.setGmtModified(this.getSysDate());
    }

    private void saveSourceSelectitemModel(SksSourceSelectitem sksSourceSelectitem) throws ApiException {
        if (null == sksSourceSelectitem) {
            return;
        }
        try {
            this.sksSourceSelectitemMapper.insert(sksSourceSelectitem);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.saveSourceSelectitemModel.ex", (Throwable)e);
        }
    }

    private void saveSourceSelectitemBatchModel(List<SksSourceSelectitem> sksSourceSelectitemList) throws ApiException {
        if (null == sksSourceSelectitemList || sksSourceSelectitemList.isEmpty()) {
            return;
        }
        try {
            this.sksSourceSelectitemMapper.insertBatch(sksSourceSelectitemList);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.saveSourceSelectitemBatchModel.ex", (Throwable)e);
        }
    }

    private SksSourceSelectitem getSourceSelectitemModelById(String id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksSourceSelectitemMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceSelectitemServiceImpl.getSourceSelectitemModelById", (Throwable)e);
            return null;
        }
    }

    private SksSourceSelectitem getSourceSelectitemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSourceSelectitemMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceSelectitemServiceImpl.getSourceSelectitemModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSourceSelectitemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceSelectitemMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.delSourceSelectitemModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.delSourceSelectitemModelByCode.num");
        }
    }

    private void deleteSourceSelectitemModel(String id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceSelectitemMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.deleteSourceSelectitemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.deleteSourceSelectitemModel.num");
        }
    }

    private void updateSourceSelectitemModel(SksSourceSelectitem sksSourceSelectitem) throws ApiException {
        if (null == sksSourceSelectitem) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSourceSelectitemMapper.updateByPrimaryKey(sksSourceSelectitem);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.updateSourceSelectitemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.updateSourceSelectitemModel.num");
        }
    }

    private void updateStateSourceSelectitemModel(String id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceSelectitemMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.updateStateSourceSelectitemModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.updateStateSourceSelectitemModel.null");
        }
    }

    private void updateStateSourceSelectitemModelByCode(String tenantCode, String selectitemCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)selectitemCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("selectitemCode", selectitemCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSourceSelectitemMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.updateStateSourceSelectitemModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.updateStateSourceSelectitemModelByCode.null");
        }
    }

    private SksSourceSelectitem makeSourceSelectitem(SksSourceSelectitemDomain sksSourceSelectitemDomain, SksSourceSelectitem sksSourceSelectitem) {
        if (null == sksSourceSelectitemDomain) {
            return null;
        }
        if (null == sksSourceSelectitem) {
            sksSourceSelectitem = new SksSourceSelectitem();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceSelectitem, (Object)sksSourceSelectitemDomain);
            return sksSourceSelectitem;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceSelectitemServiceImpl.makeSourceSelectitem", (Throwable)e);
            return null;
        }
    }

    private SksSourceSelectitemReDomain makeSksSourceSelectitemReDomain(SksSourceSelectitem sksSourceSelectitem) {
        if (null == sksSourceSelectitem) {
            return null;
        }
        SksSourceSelectitemReDomain sksSourceSelectitemReDomain = new SksSourceSelectitemReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksSourceSelectitemReDomain, (Object)sksSourceSelectitem);
            return sksSourceSelectitemReDomain;
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceSelectitemServiceImpl.makeSksSourceSelectitemReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksSourceSelectitem> querySourceSelectitemModelPage(Map<String, Object> parammap) {
        try {
            return this.sksSourceSelectitemMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceSelectitemServiceImpl.querySourceSelectitemModel", (Throwable)e);
            return null;
        }
    }

    private int countSourceSelectitem(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksSourceSelectitemMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("busdata.SksSourceSelectitemServiceImpl.countSourceSelectitem", (Throwable)e);
        }
        return i;
    }

    private SksSourceSelectitem createSksSourceSelectitem(SksSourceSelectitemDomain sksSourceSelectitemDomain) {
        String msg = this.checkSourceSelectitem(sksSourceSelectitemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.saveSourceSelectitem.checkSourceSelectitem", msg);
        }
        SksSourceSelectitem sksSourceSelectitem = this.makeSourceSelectitem(sksSourceSelectitemDomain, null);
        this.setSourceSelectitemDefault(sksSourceSelectitem);
        return sksSourceSelectitem;
    }

    @Override
    public String saveSourceSelectitem(SksSourceSelectitemDomain sksSourceSelectitemDomain) throws ApiException {
        SksSourceSelectitem sksSourceSelectitem = this.createSksSourceSelectitem(sksSourceSelectitemDomain);
        this.saveSourceSelectitemModel(sksSourceSelectitem);
        return sksSourceSelectitem.getSelectitemCode();
    }

    @Override
    public String saveSourceSelectitemBatch(List<SksSourceSelectitemDomain> sksSourceSelectitemDomainList) throws ApiException {
        if (null == sksSourceSelectitemDomainList || sksSourceSelectitemDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksSourceSelectitem> sksSourceSelectitemList = new ArrayList<SksSourceSelectitem>();
        String code = "";
        for (SksSourceSelectitemDomain sksSourceSelectitemDomain : sksSourceSelectitemDomainList) {
            SksSourceSelectitem sksSourceSelectitem = this.createSksSourceSelectitem(sksSourceSelectitemDomain);
            code = sksSourceSelectitem.getSelectitemCode();
            sksSourceSelectitemList.add(sksSourceSelectitem);
        }
        this.saveSourceSelectitemBatchModel(sksSourceSelectitemList);
        return code;
    }

    @Override
    public void updateSourceSelectitemState(String id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateSourceSelectitemModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceSelectitemStateByCode(String tenantCode, String selectitemCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)selectitemCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSourceSelectitemModelByCode(tenantCode, selectitemCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSourceSelectitem(SksSourceSelectitemDomain sksSourceSelectitemDomain) throws ApiException {
        String msg = this.checkSourceSelectitem(sksSourceSelectitemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.updateSourceSelectitem.checkSourceSelectitem", msg);
        }
        SksSourceSelectitem oldSksSourceSelectitem = this.getSourceSelectitemModelById(sksSourceSelectitemDomain.getId());
        if (null == oldSksSourceSelectitem) {
            throw new ApiException("busdata.SksSourceSelectitemServiceImpl.updateSourceSelectitem.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksSourceSelectitem sksSourceSelectitem = this.makeSourceSelectitem(sksSourceSelectitemDomain, oldSksSourceSelectitem);
        this.setSourceSelectitemUpdataDefault(sksSourceSelectitem);
        this.updateSourceSelectitemModel(sksSourceSelectitem);
    }

    @Override
    public SksSourceSelectitem getSourceSelectitem(String id) {
        if (null == id) {
            return null;
        }
        return this.getSourceSelectitemModelById(id);
    }

    @Override
    public void deleteSourceSelectitem(String id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteSourceSelectitemModel(id);
    }

    @Override
    public QueryResult<SksSourceSelectitem> querySourceSelectitemPage(Map<String, Object> map) {
        List<SksSourceSelectitem> sksSourceSelectitemList = this.querySourceSelectitemModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSourceSelectitem(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksSourceSelectitemList);
        return queryResult;
    }

    @Override
    public SksSourceSelectitem getSourceSelectitemByCode(String tenantCode, String selectitemCode) throws ApiException {
        if (StringUtils.isBlank((String)selectitemCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("selectitemCode", selectitemCode);
        return this.getSourceSelectitemModelByCode(map);
    }

    @Override
    public void deleteSourceSelectitemByCode(String tenantCode, String selectitemCode) throws ApiException {
        if (StringUtils.isBlank((String)selectitemCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("selectitemCode", selectitemCode);
        this.delSourceSelectitemModelByCode(map);
    }
}

