/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractSettlDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.skshu.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcEsbContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcRefundRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcSapContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.sg.SgSendgoodsRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.EsbContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.OcContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.OcRefundResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.SapContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.sg.SgSendgoodsResponse;
import com.yqbsoft.laser.service.ext.skshu.service.BusOrderService;
import com.yqbsoft.laser.service.ext.skshu.supbase.OrderBaseService;
import com.yqbsoft.laser.service.ext.skshu.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "busdata.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        OcContractRequest ocContractRequest = new OcContractRequest();
        ocContractRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)ocContractRequest, (Object)ocContractDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.e", (Throwable)e);
            return "error";
        }
        OcContractResponse ocContractResponse = this.restTempfacade.execute(ocContractRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse", (Object)ocContractResponse.getMsg());
            return ocContractResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        OcRefundRequest ocRefundRequest = new OcRefundRequest();
        ocRefundRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundRequest, (Object)ocRefundDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.e", (Object)e);
            return "error";
        }
        OcRefundResponse ocRefundResponse = this.restTempfacade.execute(ocRefundRequest);
        if (null == ocRefundResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse");
            return "error";
        }
        if (!ocRefundResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse", (Object)ocRefundResponse.getMsg());
            return ocRefundResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        SgSendgoodsRequest sgSendgoodsRequest = new SgSendgoodsRequest();
        sgSendgoodsRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsRequest, (Object)sgSendgoodsDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        SgSendgoodsResponse sgSendgoodsResponse = this.restTempfacade.execute(sgSendgoodsRequest);
        if (null == sgSendgoodsResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse");
            return "error";
        }
        if (!sgSendgoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse", (Object)sgSendgoodsResponse.getMsg());
            return sgSendgoodsResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        sgSendgoodsLogRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = this.restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundToEsb(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.ocRefundDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocRefundDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String POSEX = this.getUrl(ocRefundDomain.getTenantCode(), "EsbPOSEX", "EsbPOSEX");
        String KUNNR = this.getUrl(ocRefundDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String MANE1 = this.getUrl(ocRefundDomain.getTenantCode(), "EsbMANE1", "EsbMANE1");
        String LGORT = this.getUrl(ocRefundDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getUrl(ocRefundDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", goods.getRefundGoodsCode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG02");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOrderUrl", "EsbOrderUrl");
        String EsbWarehouseCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        String EsbSourcePlatformCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbSourcePlatformCode", "EsbSourcePlatformCode");
        String EsbLogisticsCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbLogisticsCode", "EsbLogisticsCode");
        String EsbShopNick = this.getUrl(ocContractDomain.getTenantCode(), "EsbShopNick", "EsbShopNick");
        String EsbSenderInfo = this.getUrl(ocContractDomain.getTenantCode(), "EsbSenderInfo", "EsbSenderInfo");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = (Map)JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        String[] split = ocContractDomain.getGoodsReceiptArrdess().split(",");
        if (split.length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainEndToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOderCancelUrl", "EsbOderCancelUrl");
        String EsbWarehouseCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("warehouseCode", EsbWarehouseCode);
        request.put("ownerCode", EsbOwnerCode);
        request.put("orderCode", ocContractDomain.getContractBillcode());
        request.put("orderType", "XSDD");
        request.put("cancelType", "out");
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyMMdd");
        return df.format(new Date());
    }

    @Override
    public String sendContractDomainConfirmToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String POSEX = this.getUrl(ocContractDomain.getTenantCode(), "EsbPOSEX", "EsbPOSEX");
        String KUNNR = this.getUrl(ocContractDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String MANE1 = this.getUrl(ocContractDomain.getTenantCode(), "EsbMANE1", "EsbMANE1");
        String LGORT = this.getUrl(ocContractDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getUrl(ocContractDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", goods.getContractGoodsCode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void main1(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/SAP/ZR_SEND_ORDER_TO_SAP_C/1.0.0";
        String POSEX = "1";
        String KUNNR = "105911";
        String MANE1 = "\u7f8e\u5c45\u5e97";
        String LGORT = "9100";
        String WERKS = "1101";
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setGoodsReceiptArrdess("\u9655\u897f,\u5b9d\u9e21\u5e02,\u9648\u4ed3\u533a,\u78fb\u6eaa\u9547,\u6d4b\u8bd5");
        ocContractDomain.setGoodsReceiptMem("\u6d4b\u8bd5\u7528\u6237");
        ocContractDomain.setGoodsReceiptPhone("15515425755");
        ocContractDomain.setContractBillcode("DS2022081515040000003");
        ArrayList<OcContractGoodsDomain> goodsDomains = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setSkuNo("1100012026");
        ocContractGoodsDomain.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain);
        OcContractGoodsDomain ocContractGoodsDomain2 = new OcContractGoodsDomain();
        ocContractGoodsDomain2.setSkuNo("1100020379");
        ocContractGoodsDomain2.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain2.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain2.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain2);
        ocContractDomain.setGoodsList(goodsDomains);
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        System.out.println(JsonUtil.buildNormalBinder().toJson(map));
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        SapContractResponse execute = invoicefacade.execute(ocEsbContractRequest);
        if (null == execute) {
            System.out.println("null");
        }
        if (!execute.getSuccess().booleanValue()) {
            System.out.println("error");
        }
        System.out.println(execute.getDataObj());
    }

    @Override
    public String sendSaveBusOrderQianjinding(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "getUserAcc");
        LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
        map.put("userAccInfo", map1);
        map1.put("syb", "8a8ad0a038d53d3a0138d58b16cf006b");
        map1.put("customer", "8a8ad0c35ac02ca8015ada27cd287642");
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".getUserAccInfo.isnull" + url, map, (Throwable)e);
            return "error";
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo.returnResultsMap", (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return "success";
        }
        logger.error(this.SYS_CODE + ".getUserAccInfo.code", (Object)data);
        return "error";
    }

    @Override
    public String sendSaveBusOrderPayment(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getOcContractSettlList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "orderPay");
        LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractDomain.getOcContractSettlList()) {
            if (!"VD".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
            mapStr.put("order_id", ocContractSettlDomain.getContractBillcode());
            mapStr.put("usecash", ocContractSettlDomain.getContractSettlGmoney());
            mapStr.put("userebate", ocContractSettlDomain.getContractSettlPmoney());
            mapStr.put("usecredit", ocContractSettlDomain.getContractSettlRmoney());
            mapStr.put("humresid", ocContractSettlDomain.getContractSettlOpno1());
        }
        map.put("orderPayInfo", mapStr);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl" + url, map);
            return "error";
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.returnResultsMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.returnResultsMap", (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            if (MapUtil.isNotEmpty((Map)dataMap) && "0".equals(dataMap.get("code"))) {
                return "success";
            }
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.dataMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.dataMap", (Object)data);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.code" + url, map);
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.code", (Object)data);
        return "error";
    }

    @Override
    public String sendCreateBusOrder(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendCreateBusOrderPayment.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getOcContractSettlList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "createOrder");
        LinkedHashMap<String, Object> createOrderInfo = new LinkedHashMap<String, Object>();
        createOrderInfo.put("is_qjd_pay", null);
        createOrderInfo.put("order_id", null);
        createOrderInfo.put("customerid", null);
        createOrderInfo.put("receiveridno", null);
        createOrderInfo.put("receivertel", null);
        createOrderInfo.put("address", null);
        createOrderInfo.put("lastdatetime", null);
        createOrderInfo.put("deliveryaddress", null);
        createOrderInfo.put("despatchmode", null);
        createOrderInfo.put("despatchmodedesc", null);
        createOrderInfo.put("extraprice1", null);
        createOrderInfo.put("ordertotal", null);
        createOrderInfo.put("ordertype", null);
        createOrderInfo.put("ordertypedesc", null);
        createOrderInfo.put("wlzc", null);
        createOrderInfo.put("CREATEDATETIME", null);
        createOrderInfo.put("dayusettleaccount", null);
        createOrderInfo.put("wbsid", null);
        createOrderInfo.put("useunload", null);
        createOrderInfo.put("unloadprice", null);
        createOrderInfo.put("addhtmsg", null);
        createOrderInfo.put("extraprice2", null);
        createOrderInfo.put("ismjj", null);
        createOrderInfo.put("wweight", null);
        createOrderInfo.put("oweight", null);
        createOrderInfo.put("otherweight", null);
        createOrderInfo.put("totalweight", null);
        createOrderInfo.put("nwtotal", null);
        createOrderInfo.put("nozptwtotlaw", null);
        createOrderInfo.put("hjsl", null);
        createOrderInfo.put("remark", null);
        createOrderInfo.put("productamount", null);
        createOrderInfo.put("discountstotal", null);
        createOrderInfo.put("orderadd", null);
        createOrderInfo.put("amountpayable", null);
        createOrderInfo.put("saledeptid", null);
        createOrderInfo.put("receiver", null);
        createOrderInfo.put("saledeptname", null);
        createOrderInfo.put("customername", null);
        createOrderInfo.put("sapcustomercode", null);
        createOrderInfo.put("address_id", null);
        createOrderInfo.put("customerno", null);
        createOrderInfo.put("sold", null);
        createOrderInfo.put("areausers", null);
        createOrderInfo.put("province", null);
        createOrderInfo.put("city", null);
        createOrderInfo.put("citytype", null);
        createOrderInfo.put("project", null);
        createOrderInfo.put("contractid", null);
        createOrderInfo.put("profitcenter", null);
        createOrderInfo.put("salesarea", null);
        createOrderInfo.put("saledisname", null);
        createOrderInfo.put("saledis", null);
        createOrderInfo.put("orgname", null);
        createOrderInfo.put("profitname", null);
        createOrderInfo.put("saleorg", null);
        createOrderInfo.put("productgroup", null);
        createOrderInfo.put("productname", null);
        createOrderInfo.put("zterm", null);
        createOrderInfo.put("deliverycompany", null);
        createOrderInfo.put("ifvirtual", null);
        createOrderInfo.put("guaranteedstock", null);
        createOrderInfo.put("dsfjc", null);
        createOrderInfo.put("cxjdw", null);
        createOrderInfo.put("elequality", null);
        createOrderInfo.put("randomstring", null);
        createOrderInfo.put("timestamp", null);
        createOrderInfo.put("humresid", null);
        map.put("orderMainData", createOrderInfo);
        ArrayList orderSubData = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("order_id", null);
            linkedHashMap.put("xcpzl", null);
            linkedHashMap.put("xcpxlei", null);
            linkedHashMap.put("xcpdl", null);
            linkedHashMap.put("xcpxl", null);
            linkedHashMap.put("orgunit", null);
            linkedHashMap.put("discountrate", null);
            linkedHashMap.put("cxproductid", null);
            linkedHashMap.put("nwtotal", null);
            linkedHashMap.put("bomtype", null);
            linkedHashMap.put("gwtotal", null);
            linkedHashMap.put("iszptw", null);
            linkedHashMap.put("bomgroupid", null);
            linkedHashMap.put("productlevel", null);
            linkedHashMap.put("islow", null);
            linkedHashMap.put("stockcode", null);
            linkedHashMap.put("discountamount", null);
            linkedHashMap.put("itemdescribe", null);
            linkedHashMap.put("appclass", null);
            linkedHashMap.put("nw", null);
            linkedHashMap.put("quantity", null);
            linkedHashMap.put("cancelcount", null);
            linkedHashMap.put("colorid", null);
            linkedHashMap.put("productclass", null);
            linkedHashMap.put("pack", null);
            linkedHashMap.put("price", null);
            linkedHashMap.put("subtotal", null);
            linkedHashMap.put("productname", null);
            linkedHashMap.put("settleaccount", null);
            linkedHashMap.put("remark", null);
            linkedHashMap.put("pch", null);
            linkedHashMap.put("iszp", null);
            linkedHashMap.put("speciality", null);
            linkedHashMap.put("minquantity", null);
            linkedHashMap.put("currency", null);
            linkedHashMap.put("brand", null);
            linkedHashMap.put("gw", null);
            linkedHashMap.put("colorname", null);
            linkedHashMap.put("productid", null);
            linkedHashMap.put("discountprice", null);
            linkedHashMap.put("itemnumber", null);
            linkedHashMap.put("settleprice", null);
            linkedHashMap.put("unit", null);
            linkedHashMap.put("dayusettleaccount", null);
            linkedHashMap.put("unloadprice", null);
            linkedHashMap.put("bomdescalias", null);
            orderSubData.add(linkedHashMap);
        }
        ArrayList orderDescData = new ArrayList();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractDomain.getOcContractSettlList()) {
            LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
            mapStr.put("promotionid", null);
            mapStr.put("promotionrule", null);
            mapStr.put("promotiondesc", null);
            orderDescData.add(mapStr);
        }
        ArrayList arrayList = new ArrayList();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractDomain.getOcContractSettlList()) {
            LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
            mapStr.put("promotionid", null);
            mapStr.put("promotiondesc", null);
            mapStr.put("promotiongoods", null);
            mapStr.put("promotiongift", null);
            mapStr.put("promotionnumrate", null);
            mapStr.put("promotionprice", null);
            mapStr.put("order_id", null);
            arrayList.add(mapStr);
        }
        map.put("orderSubData", orderSubData);
        map.put("orderDescData", orderDescData);
        map.put("sign", null);
        map.put("orderPromotionData", arrayList);
        Object var9_15 = null;
        try {
            String string = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl" + url, map);
            return "error";
        }
        return "success";
    }
}

