/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.domain.ct.CtCustrelReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractSettlDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.skshu.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcEsbContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcRefundRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcSapContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.sg.SgSendgoodsRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.EsbContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.OcContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.OcRefundResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.SapContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.sg.SgSendgoodsResponse;
import com.yqbsoft.laser.service.ext.skshu.service.BusOrderService;
import com.yqbsoft.laser.service.ext.skshu.supbase.OrderBaseService;
import com.yqbsoft.laser.service.ext.skshu.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "busdata.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        OcContractRequest ocContractRequest = new OcContractRequest();
        ocContractRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)ocContractRequest, (Object)ocContractDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.e", (Throwable)e);
            return "error";
        }
        OcContractResponse ocContractResponse = this.restTempfacade.execute(ocContractRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse", (Object)ocContractResponse.getMsg());
            return ocContractResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        OcRefundRequest ocRefundRequest = new OcRefundRequest();
        ocRefundRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundRequest, (Object)ocRefundDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.e", (Object)e);
            return "error";
        }
        OcRefundResponse ocRefundResponse = this.restTempfacade.execute(ocRefundRequest);
        if (null == ocRefundResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse");
            return "error";
        }
        if (!ocRefundResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse", (Object)ocRefundResponse.getMsg());
            return ocRefundResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        SgSendgoodsRequest sgSendgoodsRequest = new SgSendgoodsRequest();
        sgSendgoodsRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsRequest, (Object)sgSendgoodsDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        SgSendgoodsResponse sgSendgoodsResponse = this.restTempfacade.execute(sgSendgoodsRequest);
        if (null == sgSendgoodsResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse");
            return "error";
        }
        if (!sgSendgoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse", (Object)sgSendgoodsResponse.getMsg());
            return sgSendgoodsResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        sgSendgoodsLogRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = this.restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundToEsb(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.ocRefundDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocRefundDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String POSEX = this.getUrl(ocRefundDomain.getTenantCode(), "EsbPOSEX", "EsbPOSEX");
        String KUNNR = this.getUrl(ocRefundDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String MANE1 = this.getUrl(ocRefundDomain.getTenantCode(), "EsbMANE1", "EsbMANE1");
        String LGORT = this.getUrl(ocRefundDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getUrl(ocRefundDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", goods.getRefundGoodsCode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG02");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOrderUrl", "EsbOrderUrl");
        String EsbWarehouseCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        String EsbSourcePlatformCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbSourcePlatformCode", "EsbSourcePlatformCode");
        String EsbLogisticsCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbLogisticsCode", "EsbLogisticsCode");
        String EsbShopNick = this.getUrl(ocContractDomain.getTenantCode(), "EsbShopNick", "EsbShopNick");
        String EsbSenderInfo = this.getUrl(ocContractDomain.getTenantCode(), "EsbSenderInfo", "EsbSenderInfo");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = (Map)JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        String[] split = ocContractDomain.getGoodsReceiptArrdess().split(",");
        if (split.length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainEndToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOderCancelUrl", "EsbOderCancelUrl");
        String EsbWarehouseCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("warehouseCode", EsbWarehouseCode);
        request.put("ownerCode", EsbOwnerCode);
        request.put("orderCode", ocContractDomain.getContractBillcode());
        request.put("orderType", "XSDD");
        request.put("cancelType", "out");
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyMMdd");
        return df.format(new Date());
    }

    @Override
    public String sendContractDomainConfirmToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String POSEX = this.getUrl(ocContractDomain.getTenantCode(), "EsbPOSEX", "EsbPOSEX");
        String KUNNR = this.getUrl(ocContractDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String MANE1 = this.getUrl(ocContractDomain.getTenantCode(), "EsbMANE1", "EsbMANE1");
        String LGORT = this.getUrl(ocContractDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getUrl(ocContractDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", goods.getContractGoodsCode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void main1(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/SAP/ZR_SEND_ORDER_TO_SAP_C/1.0.0";
        String POSEX = "1";
        String KUNNR = "105911";
        String MANE1 = "\u7f8e\u5c45\u5e97";
        String LGORT = "9100";
        String WERKS = "1101";
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setGoodsReceiptArrdess("\u9655\u897f,\u5b9d\u9e21\u5e02,\u9648\u4ed3\u533a,\u78fb\u6eaa\u9547,\u6d4b\u8bd5");
        ocContractDomain.setGoodsReceiptMem("\u6d4b\u8bd5\u7528\u6237");
        ocContractDomain.setGoodsReceiptPhone("15515425755");
        ocContractDomain.setContractBillcode("DS2022081515040000003");
        ArrayList<OcContractGoodsDomain> goodsDomains = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setSkuNo("1100012026");
        ocContractGoodsDomain.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain);
        OcContractGoodsDomain ocContractGoodsDomain2 = new OcContractGoodsDomain();
        ocContractGoodsDomain2.setSkuNo("1100020379");
        ocContractGoodsDomain2.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain2.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain2.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain2);
        ocContractDomain.setGoodsList(goodsDomains);
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        System.out.println(JsonUtil.buildNormalBinder().toJson(map));
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        SapContractResponse execute = invoicefacade.execute(ocEsbContractRequest);
        if (null == execute) {
            System.out.println("null");
        }
        if (!execute.getSuccess().booleanValue()) {
            System.out.println("error");
        }
        System.out.println(execute.getDataObj());
    }

    @Override
    public String sendSaveBusOrderQianjinding(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        return null;
    }

    @Override
    public String sendSaveBusOrderPayment(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("code", "-1");
        returnMap.put("message", "\u652f\u4ed8\u5931\u8d25");
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getOcContractSettlList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)"isnull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "orderPay");
        LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
        mapStr.put("order_id", ocContractDomain.getContractBillcode());
        for (OcContractSettlDomain ocContractSettlDomain : ocContractDomain.getOcContractSettlList()) {
            if ("VD".equals(ocContractSettlDomain.getContractSettlBlance())) {
                mapStr.put("usecash", ocContractSettlDomain.getContractSettlGmoney());
            }
            if ("FL".equals(ocContractSettlDomain.getContractSettlBlance())) {
                mapStr.put("userebate", ocContractSettlDomain.getContractSettlPmoney());
            }
            if (!"CRP".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
            mapStr.put("usecredit", ocContractSettlDomain.getContractSettlRmoney());
        }
        mapStr.put("humresid", ocContractDomain.getUserCode());
        map.put("orderPayInfo", mapStr);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl" + url, map);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.returnResultsMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.returnResultsMap", (Object)data);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            if (MapUtil.isNotEmpty((Map)dataMap)) {
                return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
            }
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.dataMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.dataMap", (Object)data);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.code" + url, map);
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.code", (Object)data);
        return JsonUtil.buildNormalBinder().toJson(returnMap);
    }

    @Override
    public String sendCreateBusOrder(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendCreateBusOrderPayment.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getOcContractSettlList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        UmUserinfoReDomain userinfoByUserinfoCode = this.getUserinfoByUserinfoCode(ocContractDomain.getMemberBcode(), ocContractDomain.getTenantCode());
        if (null == userinfoByUserinfoCode) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.userinfoByUserinfoCode", (Object)"isnull");
            return "error";
        }
        CtCustrelReDomain ctCustrelReDomain = null;
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("tenantCode", ocContractDomain.getTenantCode());
        newMap.put("userinfoOpcode", ocContractDomain.getMemberBcode());
        newMap.put("departCode", ocContractDomain.getDepartCode());
        QueryResult<CtCustrelReDomain> ctCustrelReDomainQueryResult = this.queryCustrelPage(newMap);
        if (ListUtil.isEmpty((Collection)ctCustrelReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ctCustrelReDomainQueryResult", newMap);
            return "error";
        }
        ctCustrelReDomain = (CtCustrelReDomain)ctCustrelReDomainQueryResult.getList().get(0);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("tenantCode", ocContractDomain.getTenantCode());
        map2.put("addressCode", ocContractDomain.getAreaCode());
        QueryResult<UmAddressReDomain> umAddressReDomainQueryResult = this.queryAddressPage(map2);
        if (ListUtil.isNotEmpty((Collection)umAddressReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.queryAddressPage" + ((Object)map2).toString());
            return "error";
        }
        UmAddressReDomain umAddressReDomain = (UmAddressReDomain)umAddressReDomainQueryResult.getList().get(0);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "createOrder");
        LinkedHashMap<String, Object> createOrderInfo = new LinkedHashMap<String, Object>();
        createOrderInfo.put("is_qjd_pay", ocContractDomain.getContractBlance());
        createOrderInfo.put("order_id", ocContractDomain.getContractBillcode());
        createOrderInfo.put("customerid", ocContractDomain.getMemberBname());
        createOrderInfo.put("receiveridno", ocContractDomain.getGoodsSupplierCode());
        createOrderInfo.put("receivertel", ocContractDomain.getGoodsReceiptPhone());
        createOrderInfo.put("address", ocContractDomain.getAreaCode());
        createOrderInfo.put("lastdatetime", ocContractDomain.getGmtModified());
        createOrderInfo.put("deliveryaddress", ocContractDomain.getGoodsReceiptArrdess());
        createOrderInfo.put("despatchmode", ocContractDomain.getContractPumode());
        createOrderInfo.put("despatchmodedesc", null);
        createOrderInfo.put("extraprice1", "0.000");
        createOrderInfo.put("ordertotal", ocContractDomain.getDataBmoney());
        createOrderInfo.put("ordertype", "ZBSO");
        createOrderInfo.put("ordertypedesc", "\u6807\u51c6\u8ba2\u5355");
        createOrderInfo.put("wlzc", null);
        createOrderInfo.put("CREATEDATETIME", ocContractDomain.getGmtCreate());
        createOrderInfo.put("dayusettleaccount", null);
        createOrderInfo.put("wbsid", null);
        createOrderInfo.put("useunload", "false");
        createOrderInfo.put("unloadprice", "0.000");
        createOrderInfo.put("addhtmsg", null);
        createOrderInfo.put("extraprice2", null);
        createOrderInfo.put("ismjj", null);
        BigDecimal wweight = BigDecimal.ZERO;
        BigDecimal oweight = BigDecimal.ZERO;
        createOrderInfo.put("wweight", wweight);
        createOrderInfo.put("oweight", oweight);
        BigDecimal otherweight = BigDecimal.ZERO;
        BigDecimal totalweight = BigDecimal.ZERO;
        createOrderInfo.put("otherweight", otherweight);
        createOrderInfo.put("totalweight", totalweight);
        BigDecimal nwtotal = BigDecimal.ZERO;
        createOrderInfo.put("nwtotal", nwtotal);
        BigDecimal nozptwtotlaw = BigDecimal.ZERO;
        createOrderInfo.put("nozptwtotlaw", nozptwtotlaw);
        createOrderInfo.put("hjsl", ocContractDomain.getGoodsSupplierName());
        createOrderInfo.put("remark", ocContractDomain.getContractRemark());
        createOrderInfo.put("productamount", ocContractDomain.getContractInmoney());
        createOrderInfo.put("discountstotal", ocContractDomain.getGoodsPmoney());
        createOrderInfo.put("orderadd", "0");
        createOrderInfo.put("amountpayable", ocContractDomain.getDataBmoney());
        createOrderInfo.put("saledeptid", ctCustrelReDomain.getUserinfoOpcode2());
        createOrderInfo.put("receiver", ocContractDomain.getGoodsReceiptMem());
        createOrderInfo.put("saledeptname", ctCustrelReDomain.getDepartName());
        createOrderInfo.put("customername", ctCustrelReDomain.getUserinfoOpcode1());
        createOrderInfo.put("sapcustomercode", userinfoByUserinfoCode.getUserinfoCertNo());
        createOrderInfo.put("address_id", ocContractDomain.getAreaCode());
        createOrderInfo.put("customerno", umAddressReDomain.getRoadCode());
        createOrderInfo.put("sold", ocContractDomain.getEmployeeCode());
        createOrderInfo.put("areausers", ctCustrelReDomain.getCustrelCert1Url());
        createOrderInfo.put("province", umAddressReDomain.getProvinceCode());
        createOrderInfo.put("city", umAddressReDomain.getCityCode());
        createOrderInfo.put("citytype", umAddressReDomain.getCityName());
        createOrderInfo.put("project", ocContractDomain.getMemberGname());
        createOrderInfo.put("contractid", ocContractDomain.getMemberGcode());
        createOrderInfo.put("profitcenter", ocContractDomain.getCompanyShortname());
        createOrderInfo.put("salesarea", null);
        createOrderInfo.put("saledisname", null);
        createOrderInfo.put("saledis", null);
        createOrderInfo.put("orgname", null);
        createOrderInfo.put("profitname", null);
        createOrderInfo.put("saleorg", null);
        createOrderInfo.put("productgroup", null);
        createOrderInfo.put("productname", null);
        createOrderInfo.put("zterm", null);
        createOrderInfo.put("deliverycompany", null);
        createOrderInfo.put("ifvirtual", null);
        createOrderInfo.put("guaranteedstock", null);
        createOrderInfo.put("dsfjc", ocContractDomain.getMschannelCode());
        createOrderInfo.put("cxjdw", null);
        createOrderInfo.put("elequality", ocContractDomain.getMschannelName());
        createOrderInfo.put("randomstring", null);
        createOrderInfo.put("timestamp", null);
        createOrderInfo.put("humresid", null);
        map.put("orderMainData", createOrderInfo);
        ArrayList orderSubData = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
            map1.put("order_id", ocContractGoodsDomain.getContractBillcode());
            map1.put("xcpzl", null);
            map1.put("xcpxlei", null);
            map1.put("xcpdl", null);
            map1.put("xcpxl", null);
            map1.put("orgunit", null);
            map1.put("discountrate", null);
            map1.put("cxproductid", null);
            map1.put("nwtotal", null);
            map1.put("bomtype", null);
            map1.put("gwtotal", null);
            map1.put("iszptw", null);
            map1.put("bomgroupid", null);
            map1.put("productlevel", null);
            map1.put("islow", null);
            map1.put("stockcode", null);
            map1.put("discountamount", null);
            map1.put("itemdescribe", null);
            map1.put("appclass", null);
            map1.put("nw", null);
            map1.put("quantity", null);
            map1.put("cancelcount", null);
            map1.put("colorid", null);
            map1.put("productclass", null);
            map1.put("pack", null);
            map1.put("price", null);
            map1.put("subtotal", null);
            map1.put("productname", null);
            map1.put("settleaccount", null);
            map1.put("remark", null);
            map1.put("pch", null);
            map1.put("iszp", null);
            map1.put("speciality", null);
            map1.put("minquantity", null);
            map1.put("currency", null);
            map1.put("brand", null);
            map1.put("gw", null);
            map1.put("colorname", null);
            map1.put("productid", null);
            map1.put("discountprice", null);
            map1.put("itemnumber", null);
            map1.put("settleprice", null);
            map1.put("unit", null);
            map1.put("dayusettleaccount", null);
            map1.put("unloadprice", null);
            map1.put("bomdescalias", null);
            orderSubData.add(map1);
        }
        ArrayList orderDescData = new ArrayList();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractDomain.getOcContractSettlList()) {
            LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
            mapStr.put("promotionid", null);
            mapStr.put("promotionrule", null);
            mapStr.put("promotiondesc", null);
            orderDescData.add(mapStr);
        }
        ArrayList arrayList = new ArrayList();
        map.put("orderSubData", orderSubData);
        map.put("orderDescData", orderDescData);
        map.put("sign", null);
        map.put("orderPromotionData", arrayList);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl" + url, map);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendQueryBusOrderAccount(Map<String, Object> map2) {
        logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.map", (Object)JsonUtil.buildNormalBinder().toJson(map2));
        if (MapUtil.isEmpty(map2)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map2.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "initPay");
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("initPayInfo", map1);
        map1.put("sdfid", map2.get("sdfid"));
        map1.put("syb", map2.get("syb"));
        map1.put("contractid", map2.get("contractid"));
        map1.put("apa", map2.get("apa"));
        map1.put("order_id", map2.get("order_id"));
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.returnResultsMap", (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.code", (Object)data);
        return null;
    }

    @Override
    public String sendQueryBusOrderDepartmentAccount(Map<String, Object> map2) {
        logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.map", (Object)JsonUtil.buildNormalBinder().toJson(map2));
        if (MapUtil.isEmpty(map2)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map2.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "getUserAcc");
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("userAccInfo", map1);
        map1.put("syb", map2.get("syb"));
        map1.put("customer", map2.get("customer"));
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.returnResultsMap", (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.code", (Object)data);
        return null;
    }

    public QueryResult<CtCustrelReDomain> queryCustrelPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "ct.custrel.queryCustrelPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, CtCustrelReDomain.class);
    }

    public UmUserinfoReDomain getUserinfoByUserinfoCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    public QueryResult<UmAddressReDomain> queryAddressPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.address.queryAddressPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmAddressReDomain.class);
    }
}

