/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.domain.ct.CtCustrelReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractSettlDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.skshu.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcEsbContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcRefundRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcSapContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.sg.SgSendgoodsRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.EsbContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.OcContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.OcRefundResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.SapContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.sg.SgSendgoodsResponse;
import com.yqbsoft.laser.service.ext.skshu.model.SksRespriceColorprice;
import com.yqbsoft.laser.service.ext.skshu.service.BusOrderService;
import com.yqbsoft.laser.service.ext.skshu.service.SksRespriceColorpriceService;
import com.yqbsoft.laser.service.ext.skshu.supbase.OrderBaseService;
import com.yqbsoft.laser.service.ext.skshu.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.ext.skshu.util.SignUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "busdata.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";
    @Autowired
    RestTempfacade restTempfacade;
    @Autowired
    SksRespriceColorpriceService sksRespriceColorpriceService;

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        OcContractRequest ocContractRequest = new OcContractRequest();
        ocContractRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)ocContractRequest, (Object)ocContractDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.e", (Throwable)e);
            return "error";
        }
        OcContractResponse ocContractResponse = this.restTempfacade.execute(ocContractRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse", (Object)ocContractResponse.getMsg());
            return ocContractResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        OcRefundRequest ocRefundRequest = new OcRefundRequest();
        ocRefundRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundRequest, (Object)ocRefundDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.e", (Object)e);
            return "error";
        }
        OcRefundResponse ocRefundResponse = this.restTempfacade.execute(ocRefundRequest);
        if (null == ocRefundResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse");
            return "error";
        }
        if (!ocRefundResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse", (Object)ocRefundResponse.getMsg());
            return ocRefundResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        SgSendgoodsRequest sgSendgoodsRequest = new SgSendgoodsRequest();
        sgSendgoodsRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsRequest, (Object)sgSendgoodsDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        SgSendgoodsResponse sgSendgoodsResponse = this.restTempfacade.execute(sgSendgoodsRequest);
        if (null == sgSendgoodsResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse");
            return "error";
        }
        if (!sgSendgoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse", (Object)sgSendgoodsResponse.getMsg());
            return sgSendgoodsResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        sgSendgoodsLogRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = this.restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundToEsb(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.ocRefundDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocRefundDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String POSEX = this.getUrl(ocRefundDomain.getTenantCode(), "EsbPOSEX", "EsbPOSEX");
        String KUNNR = this.getUrl(ocRefundDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String MANE1 = this.getUrl(ocRefundDomain.getTenantCode(), "EsbMANE1", "EsbMANE1");
        String LGORT = this.getUrl(ocRefundDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getUrl(ocRefundDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", goods.getRefundGoodsCode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG02");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOrderUrl", "EsbOrderUrl");
        String EsbWarehouseCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        String EsbSourcePlatformCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbSourcePlatformCode", "EsbSourcePlatformCode");
        String EsbLogisticsCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbLogisticsCode", "EsbLogisticsCode");
        String EsbShopNick = this.getUrl(ocContractDomain.getTenantCode(), "EsbShopNick", "EsbShopNick");
        String EsbSenderInfo = this.getUrl(ocContractDomain.getTenantCode(), "EsbSenderInfo", "EsbSenderInfo");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = (Map)JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        String[] split = ocContractDomain.getGoodsReceiptArrdess().split(",");
        if (split.length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainEndToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOderCancelUrl", "EsbOderCancelUrl");
        String EsbWarehouseCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("warehouseCode", EsbWarehouseCode);
        request.put("ownerCode", EsbOwnerCode);
        request.put("orderCode", ocContractDomain.getContractBillcode());
        request.put("orderType", "XSDD");
        request.put("cancelType", "out");
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyMMdd");
        return df.format(new Date());
    }

    @Override
    public String sendContractDomainConfirmToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String POSEX = this.getUrl(ocContractDomain.getTenantCode(), "EsbPOSEX", "EsbPOSEX");
        String KUNNR = this.getUrl(ocContractDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String MANE1 = this.getUrl(ocContractDomain.getTenantCode(), "EsbMANE1", "EsbMANE1");
        String LGORT = this.getUrl(ocContractDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getUrl(ocContractDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", goods.getContractGoodsCode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void main1(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/SAP/ZR_SEND_ORDER_TO_SAP_C/1.0.0";
        String POSEX = "1";
        String KUNNR = "105911";
        String MANE1 = "\u7f8e\u5c45\u5e97";
        String LGORT = "9100";
        String WERKS = "1101";
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setGoodsReceiptArrdess("\u9655\u897f,\u5b9d\u9e21\u5e02,\u9648\u4ed3\u533a,\u78fb\u6eaa\u9547,\u6d4b\u8bd5");
        ocContractDomain.setGoodsReceiptMem("\u6d4b\u8bd5\u7528\u6237");
        ocContractDomain.setGoodsReceiptPhone("15515425755");
        ocContractDomain.setContractBillcode("DS2022081515040000003");
        ArrayList<OcContractGoodsDomain> goodsDomains = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setSkuNo("1100012026");
        ocContractGoodsDomain.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain);
        OcContractGoodsDomain ocContractGoodsDomain2 = new OcContractGoodsDomain();
        ocContractGoodsDomain2.setSkuNo("1100020379");
        ocContractGoodsDomain2.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain2.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain2.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain2);
        ocContractDomain.setGoodsList(goodsDomains);
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        System.out.println(JsonUtil.buildNormalBinder().toJson(map));
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        SapContractResponse execute = invoicefacade.execute(ocEsbContractRequest);
        if (null == execute) {
            System.out.println("null");
        }
        if (!execute.getSuccess().booleanValue()) {
            System.out.println("error");
        }
        System.out.println(execute.getDataObj());
    }

    @Override
    public String sendSaveBusOrderQianjinding(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        return null;
    }

    @Override
    public String sendSaveBusOrderPayment(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("code", "-1");
        returnMap.put("message", "\u652f\u4ed8\u5931\u8d25");
        if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getOcContractSettlList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)"isnull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "orderPay");
        LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
        mapStr.put("order_id", ocContractDomain.getContractBillcode());
        for (OcContractSettlDomain ocContractSettlDomain : ocContractDomain.getOcContractSettlList()) {
            if ("VD".equals(ocContractSettlDomain.getContractSettlBlance())) {
                mapStr.put("usecash", ocContractSettlDomain.getContractSettlGmoney());
            }
            if ("FL".equals(ocContractSettlDomain.getContractSettlBlance())) {
                mapStr.put("userebate", ocContractSettlDomain.getContractSettlPmoney());
            }
            if (!"CRP".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
            mapStr.put("usecredit", ocContractSettlDomain.getContractSettlRmoney());
        }
        mapStr.put("humresid", ocContractDomain.getUserCode());
        map.put("orderPayInfo", mapStr);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl" + url, map);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.returnResultsMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.returnResultsMap", (Object)data);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            if (MapUtil.isNotEmpty((Map)dataMap)) {
                return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
            }
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.dataMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.dataMap", (Object)data);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.code" + url, map);
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.code", (Object)data);
        return JsonUtil.buildNormalBinder().toJson(returnMap);
    }

    @Override
    public String sendCreateBusOrder(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendCreateBusOrderPayment.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        UmUserinfoReDomain userinfoByUserinfoCode = this.getUserinfoByUserinfoCode(ocContractDomain.getMemberBcode(), ocContractDomain.getTenantCode());
        if (null == userinfoByUserinfoCode) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.userinfoByUserinfoCode", (Object)"isnull");
            return "error";
        }
        CtCustrelReDomain ctCustrelReDomain = null;
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("tenantCode", ocContractDomain.getTenantCode());
        newMap.put("userinfoOpcode", ocContractDomain.getMemberBcode());
        newMap.put("departCode", ocContractDomain.getDepartCode());
        QueryResult<CtCustrelReDomain> ctCustrelReDomainQueryResult = this.queryCustrelPage(newMap);
        if (ListUtil.isEmpty((Collection)ctCustrelReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ctCustrelReDomainQueryResult", newMap);
            return "error";
        }
        ctCustrelReDomain = (CtCustrelReDomain)ctCustrelReDomainQueryResult.getList().get(0);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("tenantCode", ocContractDomain.getTenantCode());
        map2.put("addressCode", ocContractDomain.getAreaCode());
        QueryResult<UmAddressReDomain> umAddressReDomainQueryResult = this.queryAddressPage(map2);
        if (ListUtil.isNotEmpty((Collection)umAddressReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.queryAddressPage" + ((Object)map2).toString());
            return "error";
        }
        UmAddressReDomain umAddressReDomain = (UmAddressReDomain)umAddressReDomainQueryResult.getList().get(0);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "createOrder");
        LinkedHashMap<String, Object> createOrderInfo = new LinkedHashMap<String, Object>();
        createOrderInfo.put("is_qjd_pay", ocContractDomain.getContractBlance());
        createOrderInfo.put("order_id", ocContractDomain.getContractBillcode());
        createOrderInfo.put("customerid", ocContractDomain.getMemberBname());
        createOrderInfo.put("receiveridno", ocContractDomain.getGoodsSupplierCode());
        createOrderInfo.put("receivertel", ocContractDomain.getGoodsReceiptPhone());
        createOrderInfo.put("address", ocContractDomain.getAreaCode());
        createOrderInfo.put("lastdatetime", ocContractDomain.getGmtModified());
        createOrderInfo.put("deliveryaddress", ocContractDomain.getGoodsReceiptArrdess());
        createOrderInfo.put("despatchmode", ocContractDomain.getContractPumode());
        createOrderInfo.put("despatchmodedesc", null);
        if (StringUtils.isNotBlank((String)ocContractDomain.getContractPumode())) {
            createOrderInfo.put("despatchmodedesc", BusOrderServiceImpl.getMessage(ocContractDomain.getContractPumode()));
        }
        createOrderInfo.put("extraprice1", "0.000");
        createOrderInfo.put("ordertotal", ocContractDomain.getDataBmoney());
        createOrderInfo.put("ordertype", "ZBSO");
        createOrderInfo.put("ordertypedesc", "\u6807\u51c6\u8ba2\u5355");
        createOrderInfo.put("wlzc", null);
        createOrderInfo.put("CREATEDATETIME", ocContractDomain.getGmtCreate());
        createOrderInfo.put("dayusettleaccount", null);
        createOrderInfo.put("wbsid", null);
        createOrderInfo.put("useunload", "false");
        createOrderInfo.put("unloadprice", "0.000");
        createOrderInfo.put("addhtmsg", null);
        createOrderInfo.put("extraprice2", null);
        createOrderInfo.put("ismjj", null);
        BigDecimal wweight = BigDecimal.ZERO;
        BigDecimal oweight = BigDecimal.ZERO;
        createOrderInfo.put("wweight", wweight);
        createOrderInfo.put("oweight", oweight);
        BigDecimal otherweight = BigDecimal.ZERO;
        BigDecimal totalweight = BigDecimal.ZERO;
        createOrderInfo.put("otherweight", otherweight);
        createOrderInfo.put("totalweight", totalweight);
        BigDecimal nwtotal = BigDecimal.ZERO;
        createOrderInfo.put("nwtotal", nwtotal);
        BigDecimal nozptwtotlaw = BigDecimal.ZERO;
        createOrderInfo.put("nozptwtotlaw", nozptwtotlaw);
        createOrderInfo.put("hjsl", ocContractDomain.getGoodsSupplierName());
        createOrderInfo.put("remark", ocContractDomain.getContractRemark());
        createOrderInfo.put("productamount", ocContractDomain.getContractInmoney());
        createOrderInfo.put("discountstotal", ocContractDomain.getGoodsPmoney());
        createOrderInfo.put("orderadd", "0");
        createOrderInfo.put("amountpayable", ocContractDomain.getDataBmoney());
        createOrderInfo.put("saledeptid", ctCustrelReDomain.getUserinfoOpcode2());
        createOrderInfo.put("receiver", ocContractDomain.getGoodsReceiptMem());
        createOrderInfo.put("saledeptname", ctCustrelReDomain.getDepartName());
        createOrderInfo.put("customername", ctCustrelReDomain.getUserinfoOpcode1());
        createOrderInfo.put("sapcustomercode", userinfoByUserinfoCode.getUserinfoCertNo());
        createOrderInfo.put("address_id", ocContractDomain.getAreaCode());
        createOrderInfo.put("customerno", umAddressReDomain.getRoadCode());
        createOrderInfo.put("sold", ocContractDomain.getEmployeeCode());
        createOrderInfo.put("areausers", ctCustrelReDomain.getCustrelCert1Url());
        createOrderInfo.put("province", umAddressReDomain.getProvinceCode());
        createOrderInfo.put("city", umAddressReDomain.getCityCode());
        createOrderInfo.put("citytype", umAddressReDomain.getCityName());
        createOrderInfo.put("project", ocContractDomain.getMemberGname());
        createOrderInfo.put("contractid", ocContractDomain.getMemberGcode());
        createOrderInfo.put("profitcenter", ocContractDomain.getCompanyShortname());
        createOrderInfo.put("salesarea", ocContractDomain.getCompanyShortname());
        createOrderInfo.put("saledisname", ctCustrelReDomain.getUserinfoDischannelname());
        createOrderInfo.put("saledis", ctCustrelReDomain.getUserinfoDischannelcode());
        createOrderInfo.put("orgname", ctCustrelReDomain.getCustrelCert1No());
        createOrderInfo.put("profitname", ocContractDomain.getCompanyShortname());
        createOrderInfo.put("saleorg", ctCustrelReDomain.getCustrelCert1No());
        createOrderInfo.put("productgroup", ctCustrelReDomain.getCustrelFax());
        createOrderInfo.put("productname", ctCustrelReDomain.getCustrelTaun());
        createOrderInfo.put("zterm", ctCustrelReDomain.getUserinfoSort());
        createOrderInfo.put("deliverycompany", "1700");
        createOrderInfo.put("ifvirtual", false);
        if ("1".equals(ocContractDomain.getContractProperty())) {
            createOrderInfo.put("ifvirtual", true);
        }
        createOrderInfo.put("guaranteedstock", false);
        if ("1".equals(ocContractDomain.getContractPmode())) {
            createOrderInfo.put("guaranteedstock", true);
        }
        createOrderInfo.put("dsfjc", ocContractDomain.getMschannelCode());
        createOrderInfo.put("cxjdw", null);
        createOrderInfo.put("elequality", false);
        if ("1".equals(ocContractDomain.getMschannelName())) {
            createOrderInfo.put("elequality", true);
        }
        createOrderInfo.put("randomstring", "QByg");
        createOrderInfo.put("timestamp", ocContractDomain.getGmtCreate());
        createOrderInfo.put("humresid", null);
        map.put("orderMainData", createOrderInfo);
        ArrayList orderSubData = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            this.makeOcContractGoodsDomain(ocContractGoodsDomain);
            LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
            map1.put("order_id", ocContractGoodsDomain.getContractBillcode());
            map1.put("xcpzl", ocContractGoodsDomain.getClasstreeShopname());
            map1.put("xcpxlei", ocContractGoodsDomain.getClasstreeCode());
            map1.put("xcpdl", ocContractGoodsDomain.getClasstreeShopcode());
            map1.put("xcpxl", null);
            map1.put("orgunit", ocContractGoodsDomain.getMschannelName());
            if (null == ocContractGoodsDomain.getPricesetNprice()) {
                ocContractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsPrice()) {
                ocContractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
            }
            map1.put("discountrate", ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsPrice()).divide(ocContractGoodsDomain.getPricesetNprice()));
            map1.put("cxproductid", ocContractGoodsDomain.getSkuBarcode());
            if (null == ocContractGoodsDomain.getGoodsWeight()) {
                ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsOneweight()) {
                ocContractGoodsDomain.setGoodsOneweight(BigDecimal.ZERO);
            }
            map1.put("nwtotal", ocContractGoodsDomain.getGoodsWeight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            map1.put("bomtype", ocContractGoodsDomain.getMschannelCode());
            map1.put("gwtotal", ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            if ("8a8ad0a03a691636013a692c7aac0071".equals(ocContractGoodsDomain.getMschannelCode())) {
                map1.put("iszptw", "1");
            } else {
                nozptwtotlaw = nozptwtotlaw.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
                map1.put("iszptw", "0");
            }
            map1.put("bomgroupid", ocContractGoodsDomain.getGinfoCode());
            map1.put("productlevel", ocContractGoodsDomain.getChannelCode());
            map1.put("islow", "0");
            if ("8a8acee27f87ca4f017f969a9a9969a2".equals(ocContractGoodsDomain.getPricesetCurrency())) {
                map1.put("islow", "1");
            }
            map1.put("stockcode", ocContractGoodsDomain.getGoodsNo());
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
                ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            Map map3 = this.makeMap(ocContractGoodsDomain.getGoodsRemark());
            map1.put("discountamount", ocContractGoodsDomain.getContractGoodsInmoney().subtract(ocContractGoodsDomain.getContractGoodsMoney()));
            map1.put("itemdescribe", ocContractGoodsDomain.getGoodsName());
            map1.put("appclass", map3.get("middletype"));
            map1.put("nw", ocContractGoodsDomain.getGoodsWeight());
            map1.put("quantity", ocContractGoodsDomain.getGoodsCamount());
            map1.put("cancelcount", ocContractGoodsDomain.getGoodsCamount());
            map1.put("colorid", this.getSksRespriceColorprice(ocContractGoodsDomain.getSkuShowno(), ocContractGoodsDomain.getTenantCode()));
            map1.put("productclass", map3.get("groupname"));
            map1.put("pack", ocContractGoodsDomain.getSkuName());
            map1.put("price", ocContractGoodsDomain.getPricesetNprice());
            map1.put("subtotal", ocContractGoodsDomain.getContractGoodsInmoney());
            map1.put("productname", null);
            map1.put("settleaccount", ocContractGoodsDomain.getContractGoodsMoney());
            map1.put("remark", null);
            map1.put("pch", ocContractGoodsDomain.getGoodsContract());
            map1.put("iszp", "1");
            if ("1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                map1.put("iszp", "0");
            }
            map1.put("speciality", null);
            if ("s".equals(ocContractGoodsDomain.getGoodsSpec3())) {
                wweight = wweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
                map1.put("speciality", "\u6c34\u6027");
            }
            if ("y".equals(ocContractGoodsDomain.getGoodsSpec3())) {
                map1.put("speciality", "\u6cb9\u6027");
                oweight = oweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            if (StringUtils.isEmpty((String)ocContractGoodsDomain.getGoodsSpec3()) || !"y".equals(ocContractGoodsDomain.getGoodsSpec3()) || !"s".equals(ocContractGoodsDomain.getGoodsSpec3())) {
                otherweight = otherweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            totalweight = totalweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            nwtotal = nwtotal.add(ocContractGoodsDomain.getGoodsWeight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            map1.put("minquantity", "0");
            map1.put("currency", "CNY");
            map1.put("brand", ocContractGoodsDomain.getBrandName());
            map1.put("gw", ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            map1.put("colorname", ocContractGoodsDomain.getSkuShowno());
            map1.put("productid", ocContractGoodsDomain.getGoodsShowno());
            map1.put("discountprice", ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsPrice()));
            map1.put("itemnumber", ocContractGoodsDomain.getSkuNo());
            map1.put("settleprice", ocContractGoodsDomain.getContractGoodsPrice());
            map1.put("unit", ocContractGoodsDomain.getGoodsSpec4());
            map1.put("dayusettleaccount", "0.000");
            map1.put("unloadprice", "0.000");
            map1.put("bomdescalias", null);
            orderSubData.add(map1);
        }
        ArrayList orderDescData = new ArrayList();
        if (ListUtil.isNotEmpty(ocContractDomain.getOcContractSettlList())) {
            for (OcContractSettlDomain ocContractSettlDomain : ocContractDomain.getOcContractSettlList()) {
                if (!"XM".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
                LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
                mapStr.put("promotionid", null);
                mapStr.put("promotionrule", null);
                mapStr.put("promotiondesc", null);
                orderDescData.add(mapStr);
            }
        }
        ArrayList arrayList = new ArrayList();
        map.put("orderSubData", orderSubData);
        map.put("orderDescData", orderDescData);
        try {
            map.put("sign", SignUtil.getSign(createOrderInfo));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.sign", (Object)JsonUtil.buildNormalBinder().toJson(createOrderInfo));
            return "error";
        }
        map.put("orderPromotionData", arrayList);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.url" + url, map);
            return "error";
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.returnResultsMap", (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            return "success";
        }
        logger.error(this.SYS_CODE + ".sendCreateBusOrder.code", (Object)data);
        return "error";
    }

    @Override
    public String sendQueryBusOrderAccount(Map<String, Object> map2) {
        logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.map", (Object)JsonUtil.buildNormalBinder().toJson(map2));
        if (MapUtil.isEmpty(map2)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map2.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "initPay");
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("initPayInfo", map1);
        map1.put("sdfid", map2.get("sdfid"));
        map1.put("syb", map2.get("syb"));
        map1.put("contractid", map2.get("contractid"));
        map1.put("apa", map2.get("apa"));
        map1.put("order_id", map2.get("order_id"));
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.returnResultsMap", (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.code", (Object)data);
        return null;
    }

    @Override
    public String sendQueryCustInfoAction(Map<String, Object> map) {
        logger.error(this.SYS_CODE + ".sendQueryCustInfoAction.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryCustInfoAction.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryCustInfoAction.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryCustInfoAction\uff0curl", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap map1 = new LinkedHashMap();
        map.put("syntype", map.get("syntype"));
        map.put("userid", map.get("userid"));
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map1));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.returnResultsMap", (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.code", (Object)data);
        return null;
    }

    @Override
    public String sendQueryBusOrderDepartmentAccount(Map<String, Object> map2) {
        logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.map", (Object)JsonUtil.buildNormalBinder().toJson(map2));
        if (MapUtil.isEmpty(map2)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map2.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "getUserAcc");
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("userAccInfo", map1);
        map1.put("syb", map2.get("syb"));
        map1.put("customer", map2.get("customer"));
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map1));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.isnull" + url, map1, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.returnResultsMap", (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.code", (Object)data);
        return null;
    }

    public QueryResult<CtCustrelReDomain> queryCustrelPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "ct.custrel.queryCustrelPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, CtCustrelReDomain.class);
    }

    public UmUserinfoReDomain getUserinfoByUserinfoCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    public QueryResult<UmAddressReDomain> queryAddressPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.address.queryAddressPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmAddressReDomain.class);
    }

    public void makeOcContractGoodsDomain(OcContractGoodsDomain ocContractGoodsDomain) {
        RsClasstreeDomain rsClasstreeByCode;
        if (null == ocContractGoodsDomain) {
            logger.error(this.SYS_CODE + ".makeOcContractGoodsDomain.null");
            return;
        }
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getClasstreeShopcode()) && null != (rsClasstreeByCode = this.getRsClasstreeByCode(ocContractGoodsDomain.getClasstreeShopcode(), ocContractGoodsDomain.getTenantCode()))) {
            ocContractGoodsDomain.setClasstreeShopcode(rsClasstreeByCode.getClasstreeEocode());
        }
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getClasstreeShopname()) && null != (rsClasstreeByCode = this.getRsClasstreeByCode(ocContractGoodsDomain.getClasstreeShopname(), ocContractGoodsDomain.getTenantCode()))) {
            ocContractGoodsDomain.setClasstreeShopname(rsClasstreeByCode.getClasstreeEocode());
        }
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getClasstreeCode()) && null != (rsClasstreeByCode = this.getRsClasstreeByCode(ocContractGoodsDomain.getClasstreeCode(), ocContractGoodsDomain.getTenantCode()))) {
            ocContractGoodsDomain.setClasstreeCode(rsClasstreeByCode.getClasstreeEocode());
        }
    }

    public Map makeMap(String goodsRemark) {
        HashMap map = new HashMap();
        if (StringUtils.isEmpty((String)goodsRemark)) {
            logger.error(this.SYS_CODE + ".makeMap.null");
            return map;
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(goodsRemark, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            logger.error(this.SYS_CODE + ".makeMap.jsonToMap");
            return map;
        }
        return jsonToMap;
    }

    public static String getMessage(String code) {
        switch (code) {
            case "002": {
                return "\u5ba2\u6237\u59d4\u6258\u81ea\u63d0\uff0c\u8fd0\u8d39\u81ea\u4ed8";
            }
            case "009": {
                return "\u9001\u8d27\u4e0a\u95e8";
            }
            case "026": {
                return "\u5927\u79b9\uff1a\u8fd0\u8d39\u5404\u4ed8\u4e00\u534a";
            }
            case "027": {
                return "\u5927\u79b9\uff1a\u4ee3\u5ba2\u6237\u57ab\u4ed8\u8fd0\u8d39";
            }
        }
        return "";
    }

    public RsClasstreeDomain getRsClasstreeByCode(String classtreeCode, String tenantCode) {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getRsClasstreeByCode.null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("classtreeCode", classtreeCode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        return (RsClasstreeDomain)this.getForObject("rs.rsClasstree.getClasstreeByCode", RsClasstreeDomain.class, paramMap);
    }

    public String getSksRespriceColorprice(String colorno, String tenantCode) {
        if (StringUtils.isBlank((String)colorno) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getSksRespriceColorprice.null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("colorno", colorno);
        map.put("tenantCode", tenantCode);
        QueryResult<SksRespriceColorprice> sksRespriceColorpriceQueryResult = this.sksRespriceColorpriceService.queryrespricecolorpricePage(map);
        if (ListUtil.isNotEmpty((Collection)sksRespriceColorpriceQueryResult.getList())) {
            return ((SksRespriceColorprice)sksRespriceColorpriceQueryResult.getList().get(0)).getRequestid();
        }
        logger.error(this.SYS_CODE + ".getSksRespriceColorprice.map", map);
        return null;
    }
}

