/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.ext.skshu.domain.inv.Content;
import com.yqbsoft.laser.service.ext.skshu.domain.inv.InvInvlist;
import com.yqbsoft.laser.service.ext.skshu.domain.inv.InvInvlistGoods;
import com.yqbsoft.laser.service.ext.skshu.domain.inv.InvUserinv;
import com.yqbsoft.laser.service.ext.skshu.domain.inv.InvoiceDetail;
import com.yqbsoft.laser.service.ext.skshu.domain.inv.Order;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.skshu.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.request.inv.EsbInvoiceRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.response.inv.EsbInvoiceResponse;
import com.yqbsoft.laser.service.ext.skshu.service.BusInvoiceService;
import com.yqbsoft.laser.service.ext.skshu.supbase.InvoiceBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class BusInvoiceServiceImpl
extends InvoiceBaseService
implements BusInvoiceService {
    private String SYS_CODE = "busdata.BusEsbServiceImpl";
    private static final String NuonuoTaxnum = "NuonuoTaxnum";
    private static final String NuonuoAppKey = "NuonuoAppKey";
    private static final String NuonuoAppSecret = "NuonuoAppSecret";
    private static final String EsbKey = "EsbKey";
    private static final String EsbSecret = "EsbSecret";
    private static final String NuonuoUrl = "NuonuoUrl";
    private static final String NuonuoClerk = "NuonuoClerk";
    private static final String NuonuoSalerTel = "NuonuoSalerTel";
    private static final String NuonuoSalerAddress = "NuonuoSalerAddress";
    private static final String NuonuoTaxRate = "NuonuoTaxRate";
    private static final String NuonuoPushMode = "NuonuoPushMode";
    private static final String strDateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final SupperLogUtil logger = new SupperLogUtil(BusInvoiceServiceImpl.class);
    @Autowired
    Esbfacade esbfacade;

    @Override
    public String sendInvoice(InvInvlist invInvlist) {
        logger.error(this.SYS_CODE + ".sendInvoice.invInvlist", (Object)JsonUtil.buildNormalBinder().toJson((Object)invInvlist));
        if (null == invInvlist) {
            logger.error(this.SYS_CODE + ".sendInvoice.invInvlist.null");
            return null;
        }
        List<InvInvlistGoods> invInvlistGoodsList = this.queryInvlistGoodsPage(invInvlist.getTenantCode(), invInvlist.getInvlistCode());
        if (ListUtil.isEmpty(invInvlistGoodsList)) {
            logger.error(this.SYS_CODE + ".sendInvoice.invInvlistGoodsList.null", (Object)(invInvlist.getTenantCode() + "=======" + invInvlist.getInvlistCode()));
            return null;
        }
        logger.error(this.SYS_CODE + ".sendInvoice.invInvlistGoodsList", (Object)JsonUtil.buildNormalBinder().toJson(invInvlistGoodsList));
        String taxnum = this.getUrl(invInvlist.getTenantCode(), NuonuoTaxnum, NuonuoTaxnum);
        String appKey = this.getUrl(invInvlist.getTenantCode(), NuonuoAppKey, NuonuoAppKey);
        String appSecret = this.getUrl(invInvlist.getTenantCode(), NuonuoAppSecret, NuonuoAppSecret);
        String esbKey = this.getUrl(invInvlist.getTenantCode(), EsbKey, EsbKey);
        String esbSecret = this.getUrl(invInvlist.getTenantCode(), EsbSecret, EsbSecret);
        String url = this.getUrl(invInvlist.getTenantCode(), NuonuoUrl, NuonuoUrl);
        String clerk = this.getUrl(invInvlist.getTenantCode(), NuonuoClerk, NuonuoClerk);
        String salerTel = this.getUrl(invInvlist.getTenantCode(), NuonuoSalerTel, NuonuoSalerTel);
        String salerAddress = this.getUrl(invInvlist.getTenantCode(), NuonuoSalerAddress, NuonuoSalerAddress);
        String taxRate = this.getUrl(invInvlist.getTenantCode(), NuonuoTaxRate, NuonuoTaxRate);
        String pushMode = this.getUrl(invInvlist.getTenantCode(), NuonuoPushMode, NuonuoPushMode);
        BigDecimal add = new BigDecimal(1).add(new BigDecimal(taxRate));
        InvUserinv invUserinv = this.getUserinvByCode(invInvlist.getTenantCode(), invInvlist.getUserinvCode());
        logger.error(this.SYS_CODE + ".sendInvoice.invUserinv", (Object)JsonUtil.buildNormalBinder().toJson((Object)invUserinv));
        Content content = new Content();
        Order order = new Order();
        order.setBuyerName(invUserinv.getUserinvMember());
        order.setBuyerTaxNum(invUserinv.getUserinvNo());
        if (StringUtils.isNotBlank((String)invUserinv.getUserinvBankname()) && StringUtils.isNotBlank((String)invUserinv.getUserinvBankno())) {
            order.setBuyerAccount(invUserinv.getUserinvBankname() + invUserinv.getUserinvBankno());
        }
        String buyerAddress = "";
        if (StringUtils.isNotBlank((String)invUserinv.getProvinceName())) {
            buyerAddress = buyerAddress + invUserinv.getProvinceName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getCityName())) {
            buyerAddress = buyerAddress + invUserinv.getCityName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getAreaName())) {
            buyerAddress = buyerAddress + invUserinv.getAreaName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getRoadName())) {
            buyerAddress = buyerAddress + invUserinv.getRoadName();
        }
        if (StringUtils.isNotBlank((String)invUserinv.getUserinvUadd())) {
            buyerAddress = buyerAddress + invUserinv.getUserinvUadd();
        }
        order.setBuyerAddress(buyerAddress);
        order.setBuyerTel(invUserinv.getUserinvPhone());
        order.setSalerTaxNum(taxnum);
        order.setSalerTel(salerTel);
        order.setSalerAddress(salerAddress);
        order.setOrderNo(invInvlist.getInvlistOpcode());
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
        order.setInvoiceDate(sdf.format(date));
        order.setClerk(clerk);
        order.setBuyerPhone(invUserinv.getUserinvUphone());
        order.setEmail(invUserinv.getUserinvUeamil());
        order.setInvoiceType("1");
        order.setTerminalNumber("");
        if (StringUtils.isNotBlank((String)pushMode) && (pushMode.equals("1") || pushMode.equals("2")) && StringUtils.isNotBlank((String)order.getBuyerPhone())) {
            order.setPushMode(pushMode);
        }
        if (StringUtils.isNotBlank((String)pushMode) && (pushMode.equals("0") || pushMode.equals("2")) && StringUtils.isNotBlank((String)order.getEmail())) {
            order.setPushMode(pushMode);
        }
        ArrayList<InvoiceDetail> invoiceDetail = new ArrayList<InvoiceDetail>();
        for (InvInvlistGoods invInvlistGoods : invInvlistGoodsList) {
            InvoiceDetail invoiceDetail1 = new InvoiceDetail();
            invoiceDetail1.setGoodsName(invInvlistGoods.getGoodsName());
            BigDecimal taxExcludedAmount = invInvlistGoods.getContractGoodsMoney().divide(add, 2, 4);
            invoiceDetail1.setPrice(String.valueOf(taxExcludedAmount.divide(invInvlistGoods.getGoodsNum(), 2, 4)));
            invoiceDetail1.setNum(String.valueOf(invInvlistGoods.getGoodsNum()));
            invoiceDetail1.setTaxRate(taxRate);
            invoiceDetail1.setWithTaxFlag("1");
            invoiceDetail.add(invoiceDetail1);
        }
        OcContractReDomain orderByCode = this.getOrderByCode(invInvlist.getInvlistOpcode(), invInvlist.getTenantCode());
        if (null != orderByCode && null != orderByCode.getGoodsLogmoney() && orderByCode.getGoodsLogmoney().compareTo(BigDecimal.ZERO) > 0) {
            InvoiceDetail invoiceDetail1 = new InvoiceDetail();
            invoiceDetail1.setGoodsName("\u4ef7\u5916\u8d39\u7528");
            BigDecimal taxExcludedAmount = orderByCode.getGoodsLogmoney().divide(add, 2, 4);
            invoiceDetail1.setPrice(String.valueOf(taxExcludedAmount));
            invoiceDetail1.setNum("1");
            invoiceDetail1.setTaxRate(taxRate);
            invoiceDetail1.setWithTaxFlag("1");
            invoiceDetail.add(invoiceDetail1);
        }
        order.setInvoiceDetail(invoiceDetail);
        content.setOrder(order);
        String contentJson = JsonUtil.buildNormalBinder().toJson((Object)content);
        logger.error(this.SYS_CODE + ".sendInvoice.content:", (Object)contentJson);
        EsbInvoiceRequest ocInvoiceRequest = new EsbInvoiceRequest();
        ocInvoiceRequest.setAppKey(appKey);
        ocInvoiceRequest.setClientsecret(esbSecret);
        ocInvoiceRequest.setClientid(esbKey);
        ocInvoiceRequest.setHost(url);
        ocInvoiceRequest.setAppSecret(appSecret);
        ocInvoiceRequest.setTaxnum(taxnum);
        ocInvoiceRequest.setContentJson(contentJson);
        EsbInvoiceResponse ocContractResponse = this.esbfacade.execute(ocInvoiceRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse", (Object)ocContractResponse.getMsg());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("invlistDatastr", ocContractResponse.getDataObj());
            this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 4, 0, map);
            return ocContractResponse.getMsg();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invlistDatastr", ocContractResponse.getDataObj());
        this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 1, 0, map);
        return "success";
    }
}

