/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.skshu.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.request.um.UmUserinfoRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.response.um.UmUserinfoResponse;
import com.yqbsoft.laser.service.ext.skshu.service.BusUserService;
import com.yqbsoft.laser.service.ext.skshu.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.ext.skshu.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusUserServiceImpl
extends UserinfoBaseService
implements BusUserService {
    private String SYS_CODE = "SKS.BusUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusUserServiceImpl.class);
    private String ddcode = "user";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusUserinfo(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser, String optype) {
        if (null == umUserinfo) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        UmUserinfoRequest umUserinfoRequest = new UmUserinfoRequest();
        umUserinfoRequest.init(this.getDdMap(tenantCode, this.ddcode, "SKS"));
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoRequest, (Object)umUserinfo);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.e", (Throwable)e);
            return "error";
        }
        UmUserinfoResponse umUserinfoResponse = this.restTempfacade.execute(umUserinfoRequest);
        if (null == umUserinfoResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse");
            return "error";
        }
        if (!umUserinfoResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse", (Object)umUserinfoResponse.getMsg());
            return umUserinfoResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusUserLogin(String loginName, String password, String tenantCode) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("code", "-1");
        if (null == loginName || null == password) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            returnMap.put("message", "\u7528\u6237\u540d\u5bc6\u7801\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        String url = this.getUrl(tenantCode, "getUserLogin", "getUserLogin");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserLogin.getUserLogin\uff0curl", (Object)"\u5730\u5740\u4e3a\u7a7a");
            returnMap.put("message", "\u5730\u5740\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("loginName", loginName);
        map.put("password", password);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserLogin.url" + url, map);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        if (StringUtils.isBlank((String)data)) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserLogin.sendPost", (Object)data);
            returnMap.put("message", "\u8fd4\u56de\u6570\u636e\u4e3anull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, String.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            logger.error(this.SYS_CODE + "sendSaveBusUserLogin.sendPost1", (Object)data);
            returnMap.put("message", "\u8fd4\u56de\u6570\u636e\u4e3anull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        String code = (String)jsonToMap.get("code");
        String msg = (String)jsonToMap.get("msg");
        String datastr = (String)jsonToMap.get("data");
        if (StringUtils.isNotBlank((String)code) && code.equals("200") && StringUtils.isNotBlank((String)datastr) && datastr.equals("LICENSE_IS_OK")) {
            returnMap.put("code", "200");
            returnMap.put("message", msg);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        if (StringUtils.isNotBlank((String)code) && !code.equals("200")) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserLogin.url=" + url + ",response=" + data);
            returnMap.put("message", msg);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        return JsonUtil.buildNormalBinder().toJson(returnMap);
    }

    @Override
    public String getUserAccInfo(String tenantCode, String faccountType, String JsonStr) throws ApiException {
        if (StringUtils.isEmpty((String)tenantCode) || StringUtils.isEmpty((String)JsonStr)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo.isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "getUserAcc");
        LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
        map.put("userAccInfo", map1);
        map1.put("syb", "8a8ad0a038d53d3a0138d58b16cf006b");
        map1.put("customer", "8a8ad0c35ac02ca8015ada27cd287642");
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".getUserAccInfo.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo.returnResultsMap", (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".getUserAccInfo.code", (Object)data);
        return null;
    }
}

