/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksPriceMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksPriceDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksPriceReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksPrice;
import com.yqbsoft.laser.service.ext.skshu.service.SksPriceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksPriceServiceImpl
extends BaseServiceImpl
implements SksPriceService {
    private static final String SYS_CODE = "SKS.SksPriceServiceImpl";
    private SksPriceMapper sksPriceMapper;

    public void setSksPriceMapper(SksPriceMapper sksPriceMapper) {
        this.sksPriceMapper = sksPriceMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksPriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksPriceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkprice(SksPriceDomain sksPriceDomain) {
        if (null == sksPriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksPriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setpriceDefault(SksPrice sksPrice) {
        if (null == sksPrice) {
            return;
        }
        if (null == sksPrice.getDataState()) {
            sksPrice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksPrice.getGmtCreate()) {
            sksPrice.setGmtCreate(date);
        }
        sksPrice.setGmtModified(date);
        if (StringUtils.isBlank((String)sksPrice.getRequestid())) {
            sksPrice.setRequestid(this.getNo(null, "SksPrice", "sksPrice", sksPrice.getTenantCode()));
        }
    }

    private int getpriceMaxCode() {
        int code = 0;
        try {
            return this.sksPriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksPriceServiceImpl.getpriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setpriceUpdataDefault(SksPrice sksPrice) {
        if (null == sksPrice) {
            return;
        }
        sksPrice.setGmtModified(this.getSysDate());
    }

    private void savepriceModel(SksPrice sksPrice) throws ApiException {
        if (null == sksPrice) {
            return;
        }
        try {
            this.sksPriceMapper.insert(sksPrice);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksPriceServiceImpl.savepriceModel.ex", (Throwable)e);
        }
    }

    private void savepriceBatchModel(List<SksPrice> sksPriceList) throws ApiException {
        if (null == sksPriceList || sksPriceList.isEmpty()) {
            return;
        }
        try {
            this.sksPriceMapper.insertBatch(sksPriceList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksPriceServiceImpl.savepriceBatchModel.ex", (Throwable)e);
        }
    }

    private SksPrice getpriceModelById(Integer id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksPriceMapper.selectByPrimaryKey(String.valueOf(id));
        }
        catch (Exception e) {
            this.logger.error("SKS.SksPriceServiceImpl.getpriceModelById", (Throwable)e);
            return null;
        }
    }

    private SksPrice getpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksPriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksPriceServiceImpl.getpriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksPriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksPriceServiceImpl.delpriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksPriceServiceImpl.delpriceModelByCode.num");
        }
    }

    private void deletepriceModel(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksPriceMapper.deleteByPrimaryKey(String.valueOf(id));
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksPriceServiceImpl.deletepriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksPriceServiceImpl.deletepriceModel.num");
        }
    }

    private void updatepriceModel(SksPrice sksPrice) throws ApiException {
        if (null == sksPrice) {
            return;
        }
        int i = 0;
        try {
            i = this.sksPriceMapper.updateByPrimaryKey(sksPrice);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksPriceServiceImpl.updatepriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksPriceServiceImpl.updatepriceModel.num");
        }
    }

    private void updateStatepriceModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksPriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksPriceServiceImpl.updateStatepriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksPriceServiceImpl.updateStatepriceModel.null");
        }
    }

    private void updateStatepriceModelByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksPriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksPriceServiceImpl.updateStatepriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksPriceServiceImpl.updateStatepriceModelByCode.null");
        }
    }

    private SksPrice makeprice(SksPriceDomain sksPriceDomain, SksPrice sksPrice) {
        if (null == sksPriceDomain) {
            return null;
        }
        if (null == sksPrice) {
            sksPrice = new SksPrice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksPrice, (Object)sksPriceDomain);
            return sksPrice;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksPriceServiceImpl.makeprice", (Throwable)e);
            return null;
        }
    }

    private SksPriceReDomain makeSksPriceReDomain(SksPrice sksPrice) {
        if (null == sksPrice) {
            return null;
        }
        SksPriceReDomain sksPriceReDomain = new SksPriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksPriceReDomain, (Object)sksPrice);
            return sksPriceReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksPriceServiceImpl.makeSksPriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksPrice> querypriceModelPage(Map<String, Object> parammap) {
        try {
            return this.sksPriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksPriceServiceImpl.querypriceModel", (Throwable)e);
            return null;
        }
    }

    private int countprice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksPriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksPriceServiceImpl.countprice", (Throwable)e);
        }
        return i;
    }

    private SksPrice createSksPrice(SksPriceDomain sksPriceDomain) {
        String msg = this.checkprice(sksPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksPriceServiceImpl.saveprice.checkprice", msg);
        }
        SksPrice sksPrice = this.makeprice(sksPriceDomain, null);
        this.setpriceDefault(sksPrice);
        return sksPrice;
    }

    @Override
    public String saveprice(SksPriceDomain sksPriceDomain) throws ApiException {
        SksPrice sksPrice = this.createSksPrice(sksPriceDomain);
        this.savepriceModel(sksPrice);
        return sksPrice.getRequestid();
    }

    @Override
    public String savepriceBatch(List<SksPriceDomain> sksPriceDomainList) throws ApiException {
        if (null == sksPriceDomainList || sksPriceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksPrice> sksPriceList = new ArrayList<SksPrice>();
        String code = "";
        for (SksPriceDomain sksPriceDomain : sksPriceDomainList) {
            SksPrice sksPrice = this.createSksPrice(sksPriceDomain);
            code = sksPrice.getRequestid();
            sksPriceList.add(sksPrice);
        }
        this.savepriceBatchModel(sksPriceList);
        return code;
    }

    @Override
    public void updatepriceState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStatepriceModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updatepriceStateByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatepriceModelByCode(tenantCode, requestid, dataState, oldDataState, map);
    }

    @Override
    public void updateprice(SksPriceDomain sksPriceDomain) throws ApiException {
        String msg = this.checkprice(sksPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksPriceServiceImpl.updateprice.checkprice", msg);
        }
        SksPrice oldSksPrice = this.getpriceModelById(Integer.valueOf(sksPriceDomain.getId()));
        if (null == oldSksPrice) {
            throw new ApiException("SKS.SksPriceServiceImpl.updateprice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksPrice sksPrice = this.makeprice(sksPriceDomain, oldSksPrice);
        this.setpriceUpdataDefault(sksPrice);
        this.updatepriceModel(sksPrice);
    }

    @Override
    public SksPrice getprice(Integer id) {
        if (null == id) {
            return null;
        }
        return this.getpriceModelById(id);
    }

    @Override
    public void deleteprice(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deletepriceModel(id);
    }

    @Override
    public QueryResult<SksPrice> querypricePage(Map<String, Object> map) {
        List<SksPrice> sksPriceList = this.querypriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countprice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksPriceList);
        return queryResult;
    }

    @Override
    public SksPrice getpriceByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getpriceModelByCode(map);
    }

    @Override
    public void deletepriceByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delpriceModelByCode(map);
    }

    public String checkMap(SksPriceDomain sksPriceDomain) {
        if (null == sksPriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksPriceDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }
}

