/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksProjectPriceMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksProjectPriceDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksProjectPriceReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksProjectPrice;
import com.yqbsoft.laser.service.ext.skshu.service.SksProjectPriceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksProjectPriceServiceImpl
extends BaseServiceImpl
implements SksProjectPriceService {
    private static final String SYS_CODE = "SKS.SksProjectPriceServiceImpl";
    private SksProjectPriceMapper sksProjectPriceMapper;

    public void setSksProjectPriceMapper(SksProjectPriceMapper sksProjectPriceMapper) {
        this.sksProjectPriceMapper = sksProjectPriceMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksProjectPriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksProjectPriceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProjectPrice(SksProjectPriceDomain sksProjectPriceDomain) {
        if (null == sksProjectPriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksProjectPriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProjectPriceDefault(SksProjectPrice sksProjectPrice) {
        if (null == sksProjectPrice) {
            return;
        }
        if (null == sksProjectPrice.getDataState()) {
            sksProjectPrice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksProjectPrice.getGmtCreate()) {
            sksProjectPrice.setGmtCreate(date);
        }
        sksProjectPrice.setGmtModified(date);
        if (StringUtils.isBlank((String)sksProjectPrice.getRequestid())) {
            sksProjectPrice.setRequestid(this.getNo(null, "SksProjectPrice", "sksProjectPrice", sksProjectPrice.getTenantCode()));
        }
    }

    private int getProjectPriceMaxCode() {
        int code = 0;
        try {
            return this.sksProjectPriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksProjectPriceServiceImpl.getProjectPriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectPriceUpdataDefault(SksProjectPrice sksProjectPrice) {
        if (null == sksProjectPrice) {
            return;
        }
        sksProjectPrice.setGmtModified(this.getSysDate());
    }

    private void saveProjectPriceModel(SksProjectPrice sksProjectPrice) throws ApiException {
        if (null == sksProjectPrice) {
            return;
        }
        try {
            this.sksProjectPriceMapper.insert(sksProjectPrice);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.saveProjectPriceModel.ex", (Throwable)e);
        }
    }

    private void saveProjectPriceBatchModel(List<SksProjectPrice> sksProjectPriceList) throws ApiException {
        if (null == sksProjectPriceList || sksProjectPriceList.isEmpty()) {
            return;
        }
        try {
            this.sksProjectPriceMapper.insertBatch(sksProjectPriceList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.saveProjectPriceBatchModel.ex", (Throwable)e);
        }
    }

    private SksProjectPrice getProjectPriceModelById(Integer id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksProjectPriceMapper.selectByPrimaryKey(id.toString());
        }
        catch (Exception e) {
            this.logger.error("SKS.SksProjectPriceServiceImpl.getProjectPriceModelById", (Throwable)e);
            return null;
        }
    }

    private SksProjectPrice getProjectPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksProjectPriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksProjectPriceServiceImpl.getProjectPriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProjectPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksProjectPriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.delProjectPriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.delProjectPriceModelByCode.num");
        }
    }

    private void deleteProjectPriceModel(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksProjectPriceMapper.deleteByPrimaryKey(id.toString());
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.deleteProjectPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.deleteProjectPriceModel.num");
        }
    }

    private void updateProjectPriceModel(SksProjectPrice sksProjectPrice) throws ApiException {
        if (null == sksProjectPrice) {
            return;
        }
        int i = 0;
        try {
            i = this.sksProjectPriceMapper.updateByPrimaryKey(sksProjectPrice);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.updateProjectPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.updateProjectPriceModel.num");
        }
    }

    private void updateStateProjectPriceModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksProjectPriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.updateStateProjectPriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.updateStateProjectPriceModel.null");
        }
    }

    private void updateStateProjectPriceModelByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksProjectPriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.updateStateProjectPriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.updateStateProjectPriceModelByCode.null");
        }
    }

    private SksProjectPrice makeProjectPrice(SksProjectPriceDomain sksProjectPriceDomain, SksProjectPrice sksProjectPrice) {
        if (null == sksProjectPriceDomain) {
            return null;
        }
        if (null == sksProjectPrice) {
            sksProjectPrice = new SksProjectPrice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksProjectPrice, (Object)sksProjectPriceDomain);
            return sksProjectPrice;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksProjectPriceServiceImpl.makeProjectPrice", (Throwable)e);
            return null;
        }
    }

    private SksProjectPriceReDomain makeSksProjectPriceReDomain(SksProjectPrice sksProjectPrice) {
        if (null == sksProjectPrice) {
            return null;
        }
        SksProjectPriceReDomain sksProjectPriceReDomain = new SksProjectPriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksProjectPriceReDomain, (Object)sksProjectPrice);
            return sksProjectPriceReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksProjectPriceServiceImpl.makeSksProjectPriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksProjectPrice> queryProjectPriceModelPage(Map<String, Object> parammap) {
        try {
            return this.sksProjectPriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksProjectPriceServiceImpl.queryProjectPriceModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectPrice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksProjectPriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksProjectPriceServiceImpl.countProjectPrice", (Throwable)e);
        }
        return i;
    }

    private SksProjectPrice createSksProjectPrice(SksProjectPriceDomain sksProjectPriceDomain) {
        String msg = this.checkProjectPrice(sksProjectPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.saveProjectPrice.checkProjectPrice", msg);
        }
        SksProjectPrice sksProjectPrice = this.makeProjectPrice(sksProjectPriceDomain, null);
        this.setProjectPriceDefault(sksProjectPrice);
        return sksProjectPrice;
    }

    @Override
    public String saveProjectPrice(SksProjectPriceDomain sksProjectPriceDomain) throws ApiException {
        SksProjectPrice sksProjectPrice = this.createSksProjectPrice(sksProjectPriceDomain);
        this.saveProjectPriceModel(sksProjectPrice);
        return sksProjectPrice.getRequestid();
    }

    @Override
    public String saveProjectPriceBatch(List<SksProjectPriceDomain> sksProjectPriceDomainList) throws ApiException {
        if (null == sksProjectPriceDomainList || sksProjectPriceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksProjectPrice> sksProjectPriceList = new ArrayList<SksProjectPrice>();
        String code = "";
        for (SksProjectPriceDomain sksProjectPriceDomain : sksProjectPriceDomainList) {
            SksProjectPrice sksProjectPrice = this.createSksProjectPrice(sksProjectPriceDomain);
            code = sksProjectPrice.getRequestid();
            sksProjectPriceList.add(sksProjectPrice);
        }
        this.saveProjectPriceBatchModel(sksProjectPriceList);
        return code;
    }

    @Override
    public void updateProjectPriceState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateProjectPriceModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateProjectPriceStateByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateProjectPriceModelByCode(tenantCode, requestid, dataState, oldDataState, map);
    }

    @Override
    public void updateProjectPrice(SksProjectPriceDomain sksProjectPriceDomain) throws ApiException {
        String msg = this.checkProjectPrice(sksProjectPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.updateProjectPrice.checkProjectPrice", msg);
        }
        SksProjectPrice oldSksProjectPrice = this.getProjectPriceModelById(Integer.parseInt(sksProjectPriceDomain.getId()));
        if (null == oldSksProjectPrice) {
            throw new ApiException("SKS.SksProjectPriceServiceImpl.updateProjectPrice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksProjectPrice sksProjectPrice = this.makeProjectPrice(sksProjectPriceDomain, oldSksProjectPrice);
        this.setProjectPriceUpdataDefault(sksProjectPrice);
        this.updateProjectPriceModel(sksProjectPrice);
    }

    @Override
    public SksProjectPrice getProjectPrice(Integer id) {
        if (null == id) {
            return null;
        }
        return this.getProjectPriceModelById(id);
    }

    @Override
    public void deleteProjectPrice(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteProjectPriceModel(id);
    }

    @Override
    public QueryResult<SksProjectPrice> queryProjectPricePage(Map<String, Object> map) {
        List<SksProjectPrice> sksProjectPriceList = this.queryProjectPriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectPrice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksProjectPriceList);
        return queryResult;
    }

    @Override
    public SksProjectPrice getProjectPriceByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getProjectPriceModelByCode(map);
    }

    @Override
    public void deleteProjectPriceByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delProjectPriceModelByCode(map);
    }

    protected String checkMap(SksProjectPriceDomain sksProjectPriceDomain) {
        if (null == sksProjectPriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksProjectPriceDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    protected void saveOrUpdateProjectPrice(SksProjectPriceDomain SksProjectPriceDomain2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestid", SksProjectPriceDomain2.getRequestid());
        SksProjectPrice selectitem = this.sksProjectPriceMapper.getByCode(map);
        if (selectitem == null) {
            this.saveProjectPrice(SksProjectPriceDomain2);
        } else {
            SksProjectPriceDomain2.setId(selectitem.getId());
            this.updateProjectPrice(SksProjectPriceDomain2);
        }
    }

    public SksProjectPrice getSksProjectPriceByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getProjectPriceModelByCode(map);
    }
}

