/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksOrderMarkupMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksOrderMarkupDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksOrderMarkupReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksOrderMarkup;
import com.yqbsoft.laser.service.ext.skshu.service.SksOrderMarkupService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksOrderMarkupServiceImpl
extends BaseServiceImpl
implements SksOrderMarkupService {
    private static final String SYS_CODE = "SKS.SksOrderMarkupServiceImpl";
    private SksOrderMarkupMapper sksOrderMarkupMapper;

    public void setSksOrderMarkupMapper(SksOrderMarkupMapper sksOrderMarkupMapper) {
        this.sksOrderMarkupMapper = sksOrderMarkupMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksOrderMarkupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksOrderMarkupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrderMarkup(SksOrderMarkupDomain sksOrderMarkupDomain) {
        if (null == sksOrderMarkupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksOrderMarkupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOrderMarkupDefault(SksOrderMarkup sksOrderMarkup) {
        if (null == sksOrderMarkup) {
            return;
        }
        if (null == sksOrderMarkup.getDataState()) {
            sksOrderMarkup.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksOrderMarkup.getGmtCreate()) {
            sksOrderMarkup.setGmtCreate(date);
        }
        sksOrderMarkup.setGmtModified(date);
        if (StringUtils.isBlank((String)sksOrderMarkup.getRequestid())) {
            sksOrderMarkup.setRequestid(this.getNo(null, "SksOrderMarkup", "sksOrderMarkup", sksOrderMarkup.getTenantCode()));
        }
    }

    private int getOrderMarkupMaxCode() {
        int code = 0;
        try {
            return this.sksOrderMarkupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksOrderMarkupServiceImpl.getOrderMarkupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrderMarkupUpdataDefault(SksOrderMarkup sksOrderMarkup) {
        if (null == sksOrderMarkup) {
            return;
        }
        sksOrderMarkup.setGmtModified(this.getSysDate());
    }

    private void saveOrderMarkupModel(SksOrderMarkup sksOrderMarkup) throws ApiException {
        if (null == sksOrderMarkup) {
            return;
        }
        try {
            this.sksOrderMarkupMapper.insert(sksOrderMarkup);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.saveOrderMarkupModel.ex", (Throwable)e);
        }
    }

    private void saveOrderMarkupBatchModel(List<SksOrderMarkup> sksOrderMarkupList) throws ApiException {
        if (null == sksOrderMarkupList || sksOrderMarkupList.isEmpty()) {
            return;
        }
        try {
            this.sksOrderMarkupMapper.insertBatch(sksOrderMarkupList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.saveOrderMarkupBatchModel.ex", (Throwable)e);
        }
    }

    private SksOrderMarkup getOrderMarkupModelById(Integer orderMarkupId) {
        if (null == orderMarkupId) {
            return null;
        }
        try {
            return this.sksOrderMarkupMapper.selectByPrimaryKey(orderMarkupId);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksOrderMarkupServiceImpl.getOrderMarkupModelById", (Throwable)e);
            return null;
        }
    }

    private SksOrderMarkup getOrderMarkupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksOrderMarkupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksOrderMarkupServiceImpl.getOrderMarkupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOrderMarkupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksOrderMarkupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.delOrderMarkupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.delOrderMarkupModelByCode.num");
        }
    }

    private void deleteOrderMarkupModel(Integer orderMarkupId) throws ApiException {
        if (null == orderMarkupId) {
            return;
        }
        int i = 0;
        try {
            i = this.sksOrderMarkupMapper.deleteByPrimaryKey(orderMarkupId);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.deleteOrderMarkupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.deleteOrderMarkupModel.num");
        }
    }

    private void updateOrderMarkupModel(SksOrderMarkup sksOrderMarkup) throws ApiException {
        if (null == sksOrderMarkup) {
            return;
        }
        int i = 0;
        try {
            i = this.sksOrderMarkupMapper.updateByPrimaryKey(sksOrderMarkup);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.updateOrderMarkupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.updateOrderMarkupModel.num");
        }
    }

    private void updateStateOrderMarkupModel(Integer orderMarkupId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == orderMarkupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderMarkupId", orderMarkupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksOrderMarkupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.updateStateOrderMarkupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.updateStateOrderMarkupModel.null");
        }
    }

    private void updateStateOrderMarkupModelByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksOrderMarkupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.updateStateOrderMarkupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.updateStateOrderMarkupModelByCode.null");
        }
    }

    private SksOrderMarkup makeOrderMarkup(SksOrderMarkupDomain sksOrderMarkupDomain, SksOrderMarkup sksOrderMarkup) {
        if (null == sksOrderMarkupDomain) {
            return null;
        }
        if (null == sksOrderMarkup) {
            sksOrderMarkup = new SksOrderMarkup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksOrderMarkup, (Object)sksOrderMarkupDomain);
            return sksOrderMarkup;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksOrderMarkupServiceImpl.makeOrderMarkup", (Throwable)e);
            return null;
        }
    }

    private SksOrderMarkupReDomain makeSksOrderMarkupReDomain(SksOrderMarkup sksOrderMarkup) {
        if (null == sksOrderMarkup) {
            return null;
        }
        SksOrderMarkupReDomain sksOrderMarkupReDomain = new SksOrderMarkupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksOrderMarkupReDomain, (Object)sksOrderMarkup);
            return sksOrderMarkupReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksOrderMarkupServiceImpl.makeSksOrderMarkupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksOrderMarkup> queryOrderMarkupModelPage(Map<String, Object> parammap) {
        try {
            return this.sksOrderMarkupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksOrderMarkupServiceImpl.queryOrderMarkupModel", (Throwable)e);
            return null;
        }
    }

    private int countOrderMarkup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksOrderMarkupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksOrderMarkupServiceImpl.countOrderMarkup", (Throwable)e);
        }
        return i;
    }

    private SksOrderMarkup createSksOrderMarkup(SksOrderMarkupDomain sksOrderMarkupDomain) {
        String msg = this.checkOrderMarkup(sksOrderMarkupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.saveOrderMarkup.checkOrderMarkup", msg);
        }
        SksOrderMarkup sksOrderMarkup = this.makeOrderMarkup(sksOrderMarkupDomain, null);
        this.setOrderMarkupDefault(sksOrderMarkup);
        return sksOrderMarkup;
    }

    @Override
    public String saveOrderMarkup(SksOrderMarkupDomain sksOrderMarkupDomain) throws ApiException {
        SksOrderMarkup sksOrderMarkup = this.createSksOrderMarkup(sksOrderMarkupDomain);
        this.saveOrderMarkupModel(sksOrderMarkup);
        return sksOrderMarkup.getRequestid();
    }

    @Override
    public String saveOrderMarkupBatch(List<SksOrderMarkupDomain> sksOrderMarkupDomainList) throws ApiException {
        if (null == sksOrderMarkupDomainList || sksOrderMarkupDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksOrderMarkup> sksOrderMarkupList = new ArrayList<SksOrderMarkup>();
        String code = "";
        for (SksOrderMarkupDomain sksOrderMarkupDomain : sksOrderMarkupDomainList) {
            SksOrderMarkup sksOrderMarkup = this.createSksOrderMarkup(sksOrderMarkupDomain);
            code = sksOrderMarkup.getRequestid();
            sksOrderMarkupList.add(sksOrderMarkup);
        }
        this.saveOrderMarkupBatchModel(sksOrderMarkupList);
        return code;
    }

    @Override
    public void updateOrderMarkupState(Integer orderMarkupId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == orderMarkupId) {
            return;
        }
        this.updateStateOrderMarkupModel(orderMarkupId, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderMarkupStateByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOrderMarkupModelByCode(tenantCode, requestid, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderMarkup(SksOrderMarkupDomain sksOrderMarkupDomain) throws ApiException {
        String msg = this.checkOrderMarkup(sksOrderMarkupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.updateOrderMarkup.checkOrderMarkup", msg);
        }
        SksOrderMarkup oldSksOrderMarkup = this.getOrderMarkupModelById(sksOrderMarkupDomain.getId());
        if (null == oldSksOrderMarkup) {
            throw new ApiException("SKS.SksOrderMarkupServiceImpl.updateOrderMarkup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksOrderMarkup sksOrderMarkup = this.makeOrderMarkup(sksOrderMarkupDomain, oldSksOrderMarkup);
        this.setOrderMarkupUpdataDefault(sksOrderMarkup);
        this.updateOrderMarkupModel(sksOrderMarkup);
    }

    @Override
    public SksOrderMarkup getOrderMarkup(Integer orderMarkupId) {
        if (null == orderMarkupId) {
            return null;
        }
        return this.getOrderMarkupModelById(orderMarkupId);
    }

    @Override
    public void deleteOrderMarkup(Integer orderMarkupId) throws ApiException {
        if (null == orderMarkupId) {
            return;
        }
        this.deleteOrderMarkupModel(orderMarkupId);
    }

    @Override
    public QueryResult<SksOrderMarkup> queryOrderMarkupPage(Map<String, Object> map) {
        List<SksOrderMarkup> sksOrderMarkupList = this.queryOrderMarkupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderMarkup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksOrderMarkupList);
        return queryResult;
    }

    @Override
    public SksOrderMarkup getOrderMarkupByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getOrderMarkupModelByCode(map);
    }

    @Override
    public void deleteOrderMarkupByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delOrderMarkupModelByCode(map);
    }
}

