/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksCategoryMarkupMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksCategoryMarkupDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksCategoryMarkupReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksCategoryMarkup;
import com.yqbsoft.laser.service.ext.skshu.service.SksCategoryMarkupService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksCategoryMarkupServiceImpl
extends BaseServiceImpl
implements SksCategoryMarkupService {
    private static final String SYS_CODE = "SKS.SksCategoryMarkupServiceImpl";
    private SksCategoryMarkupMapper sksCategoryMarkupMapper;

    public void setSksCategoryMarkupMapper(SksCategoryMarkupMapper sksCategoryMarkupMapper) {
        this.sksCategoryMarkupMapper = sksCategoryMarkupMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksCategoryMarkupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksCategoryMarkupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCategoryMarkup(SksCategoryMarkupDomain sksCategoryMarkupDomain) {
        if (null == sksCategoryMarkupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksCategoryMarkupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCategoryMarkupDefault(SksCategoryMarkup sksCategoryMarkup) {
        if (null == sksCategoryMarkup) {
            return;
        }
        if (null == sksCategoryMarkup.getDataState()) {
            sksCategoryMarkup.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksCategoryMarkup.getGmtCreate()) {
            sksCategoryMarkup.setGmtCreate(date);
        }
        sksCategoryMarkup.setGmtModified(date);
        if (StringUtils.isBlank((String)sksCategoryMarkup.getRequestid())) {
            sksCategoryMarkup.setRequestid(this.getNo(null, "SksCategoryMarkup", "sksCategoryMarkup", sksCategoryMarkup.getTenantCode()));
        }
    }

    private int getCategoryMarkupMaxCode() {
        int code = 0;
        try {
            return this.sksCategoryMarkupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksCategoryMarkupServiceImpl.getCategoryMarkupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCategoryMarkupUpdataDefault(SksCategoryMarkup sksCategoryMarkup) {
        if (null == sksCategoryMarkup) {
            return;
        }
        sksCategoryMarkup.setGmtModified(this.getSysDate());
    }

    private void saveCategoryMarkupModel(SksCategoryMarkup sksCategoryMarkup) throws ApiException {
        if (null == sksCategoryMarkup) {
            return;
        }
        try {
            this.sksCategoryMarkupMapper.insert(sksCategoryMarkup);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.saveCategoryMarkupModel.ex", (Throwable)e);
        }
    }

    private void saveCategoryMarkupBatchModel(List<SksCategoryMarkup> sksCategoryMarkupList) throws ApiException {
        if (null == sksCategoryMarkupList || sksCategoryMarkupList.isEmpty()) {
            return;
        }
        try {
            this.sksCategoryMarkupMapper.insertBatch(sksCategoryMarkupList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.saveCategoryMarkupBatchModel.ex", (Throwable)e);
        }
    }

    private SksCategoryMarkup getCategoryMarkupModelById(Integer id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksCategoryMarkupMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksCategoryMarkupServiceImpl.getCategoryMarkupModelById", (Throwable)e);
            return null;
        }
    }

    private SksCategoryMarkup getCategoryMarkupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksCategoryMarkupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksCategoryMarkupServiceImpl.getCategoryMarkupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCategoryMarkupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksCategoryMarkupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.delCategoryMarkupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.delCategoryMarkupModelByCode.num");
        }
    }

    private void deleteCategoryMarkupModel(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksCategoryMarkupMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.deleteCategoryMarkupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.deleteCategoryMarkupModel.num");
        }
    }

    private void updateCategoryMarkupModel(SksCategoryMarkup sksCategoryMarkup) throws ApiException {
        if (null == sksCategoryMarkup) {
            return;
        }
        int i = 0;
        try {
            i = this.sksCategoryMarkupMapper.updateByPrimaryKey(sksCategoryMarkup);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.updateCategoryMarkupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.updateCategoryMarkupModel.num");
        }
    }

    private void updateStateCategoryMarkupModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksCategoryMarkupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.updateStateCategoryMarkupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.updateStateCategoryMarkupModel.null");
        }
    }

    private void updateStateCategoryMarkupModelByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksCategoryMarkupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.updateStateCategoryMarkupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.updateStateCategoryMarkupModelByCode.null");
        }
    }

    private SksCategoryMarkup makeCategoryMarkup(SksCategoryMarkupDomain sksCategoryMarkupDomain, SksCategoryMarkup sksCategoryMarkup) {
        if (null == sksCategoryMarkupDomain) {
            return null;
        }
        if (null == sksCategoryMarkup) {
            sksCategoryMarkup = new SksCategoryMarkup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksCategoryMarkup, (Object)sksCategoryMarkupDomain);
            return sksCategoryMarkup;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksCategoryMarkupServiceImpl.makeCategoryMarkup", (Throwable)e);
            return null;
        }
    }

    private SksCategoryMarkupReDomain makeSksCategoryMarkupReDomain(SksCategoryMarkup sksCategoryMarkup) {
        if (null == sksCategoryMarkup) {
            return null;
        }
        SksCategoryMarkupReDomain sksCategoryMarkupReDomain = new SksCategoryMarkupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksCategoryMarkupReDomain, (Object)sksCategoryMarkup);
            return sksCategoryMarkupReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksCategoryMarkupServiceImpl.makeSksCategoryMarkupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksCategoryMarkup> queryCategoryMarkupModelPage(Map<String, Object> parammap) {
        try {
            return this.sksCategoryMarkupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksCategoryMarkupServiceImpl.queryCategoryMarkupModel", (Throwable)e);
            return null;
        }
    }

    private int countCategoryMarkup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksCategoryMarkupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksCategoryMarkupServiceImpl.countCategoryMarkup", (Throwable)e);
        }
        return i;
    }

    private SksCategoryMarkup createSksCategoryMarkup(SksCategoryMarkupDomain sksCategoryMarkupDomain) {
        String msg = this.checkCategoryMarkup(sksCategoryMarkupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.saveCategoryMarkup.checkCategoryMarkup", msg);
        }
        SksCategoryMarkup sksCategoryMarkup = this.makeCategoryMarkup(sksCategoryMarkupDomain, null);
        this.setCategoryMarkupDefault(sksCategoryMarkup);
        return sksCategoryMarkup;
    }

    @Override
    public String saveCategoryMarkup(SksCategoryMarkupDomain sksCategoryMarkupDomain) throws ApiException {
        SksCategoryMarkup sksCategoryMarkup = this.createSksCategoryMarkup(sksCategoryMarkupDomain);
        this.saveCategoryMarkupModel(sksCategoryMarkup);
        return sksCategoryMarkup.getRequestid();
    }

    @Override
    public String saveCategoryMarkupBatch(List<SksCategoryMarkupDomain> sksCategoryMarkupDomainList) throws ApiException {
        if (null == sksCategoryMarkupDomainList || sksCategoryMarkupDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksCategoryMarkup> sksCategoryMarkupList = new ArrayList<SksCategoryMarkup>();
        String code = "";
        for (SksCategoryMarkupDomain sksCategoryMarkupDomain : sksCategoryMarkupDomainList) {
            SksCategoryMarkup sksCategoryMarkup = this.createSksCategoryMarkup(sksCategoryMarkupDomain);
            code = sksCategoryMarkup.getRequestid();
            sksCategoryMarkupList.add(sksCategoryMarkup);
        }
        this.saveCategoryMarkupBatchModel(sksCategoryMarkupList);
        return code;
    }

    @Override
    public void updateCategoryMarkupState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateCategoryMarkupModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateCategoryMarkupStateByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCategoryMarkupModelByCode(tenantCode, requestid, dataState, oldDataState, map);
    }

    @Override
    public void updateCategoryMarkup(SksCategoryMarkupDomain sksCategoryMarkupDomain) throws ApiException {
        String msg = this.checkCategoryMarkup(sksCategoryMarkupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.updateCategoryMarkup.checkCategoryMarkup", msg);
        }
        SksCategoryMarkup oldSksCategoryMarkup = this.getCategoryMarkupModelById(sksCategoryMarkupDomain.getId());
        if (null == oldSksCategoryMarkup) {
            throw new ApiException("SKS.SksCategoryMarkupServiceImpl.updateCategoryMarkup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksCategoryMarkup sksCategoryMarkup = this.makeCategoryMarkup(sksCategoryMarkupDomain, oldSksCategoryMarkup);
        this.setCategoryMarkupUpdataDefault(sksCategoryMarkup);
        this.updateCategoryMarkupModel(sksCategoryMarkup);
    }

    @Override
    public SksCategoryMarkup getCategoryMarkup(Integer id) {
        if (null == id) {
            return null;
        }
        return this.getCategoryMarkupModelById(id);
    }

    @Override
    public void deleteCategoryMarkup(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteCategoryMarkupModel(id);
    }

    @Override
    public QueryResult<SksCategoryMarkup> queryCategoryMarkupPage(Map<String, Object> map) {
        List<SksCategoryMarkup> sksCategoryMarkupList = this.queryCategoryMarkupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCategoryMarkup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksCategoryMarkupList);
        return queryResult;
    }

    @Override
    public SksCategoryMarkup getCategoryMarkupByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getCategoryMarkupModelByCode(map);
    }

    @Override
    public void deleteCategoryMarkupByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delCategoryMarkupModelByCode(map);
    }
}

