/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksMatMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksMatDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksMatReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksMat;
import com.yqbsoft.laser.service.ext.skshu.service.SksMatService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksMatServiceImpl
extends BaseServiceImpl
implements SksMatService {
    private static final String SYS_CODE = "SKS.SksMatServiceImpl";
    private SksMatMapper sksMatMapper;

    public void setSksMatMapper(SksMatMapper sksMatMapper) {
        this.sksMatMapper = sksMatMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksMatMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksMatServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkmat(SksMatDomain sksMatDomain) {
        if (null == sksMatDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksMatDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setmatDefault(SksMat sksMat) {
        if (null == sksMat) {
            return;
        }
        if (null == sksMat.getDataState()) {
            sksMat.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksMat.getGmtCreate()) {
            sksMat.setGmtCreate(date);
        }
        sksMat.setGmtModified(date);
        if (StringUtils.isBlank((String)sksMat.getRequestid())) {
            sksMat.setRequestid(this.getNo(null, "SksMat", "sksMat", sksMat.getTenantCode()));
        }
    }

    private int getmatMaxCode() {
        int code = 0;
        try {
            return this.sksMatMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksMatServiceImpl.getmatMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setmatUpdataDefault(SksMat sksMat) {
        if (null == sksMat) {
            return;
        }
        sksMat.setGmtModified(this.getSysDate());
    }

    private void savematModel(SksMat sksMat) throws ApiException {
        if (null == sksMat) {
            return;
        }
        try {
            this.sksMatMapper.insert(sksMat);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksMatServiceImpl.savematModel.ex", (Throwable)e);
        }
    }

    private void savematBatchModel(List<SksMat> sksMatList) throws ApiException {
        if (null == sksMatList || sksMatList.isEmpty()) {
            return;
        }
        try {
            this.sksMatMapper.insertBatch(sksMatList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksMatServiceImpl.savematBatchModel.ex", (Throwable)e);
        }
    }

    private SksMat getmatModelById(Integer id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksMatMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksMatServiceImpl.getmatModelById", (Throwable)e);
            return null;
        }
    }

    private SksMat getmatModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksMatMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksMatServiceImpl.getmatModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delmatModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksMatMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksMatServiceImpl.delmatModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksMatServiceImpl.delmatModelByCode.num");
        }
    }

    private void deletematModel(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksMatMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksMatServiceImpl.deletematModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksMatServiceImpl.deletematModel.num");
        }
    }

    private void updatematModel(SksMat sksMat) throws ApiException {
        if (null == sksMat) {
            return;
        }
        int i = 0;
        try {
            i = this.sksMatMapper.updateByPrimaryKey(sksMat);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksMatServiceImpl.updatematModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksMatServiceImpl.updatematModel.num");
        }
    }

    private void updateStatematModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksMatMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksMatServiceImpl.updateStatematModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksMatServiceImpl.updateStatematModel.null");
        }
    }

    private void updateStatematModelByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksMatMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksMatServiceImpl.updateStatematModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksMatServiceImpl.updateStatematModelByCode.null");
        }
    }

    private SksMat makemat(SksMatDomain sksMatDomain, SksMat sksMat) {
        if (null == sksMatDomain) {
            return null;
        }
        if (null == sksMat) {
            sksMat = new SksMat();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksMat, (Object)sksMatDomain);
            return sksMat;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksMatServiceImpl.makemat", (Throwable)e);
            return null;
        }
    }

    private SksMatReDomain makeSksMatReDomain(SksMat sksMat) {
        if (null == sksMat) {
            return null;
        }
        SksMatReDomain sksMatReDomain = new SksMatReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksMatReDomain, (Object)sksMat);
            return sksMatReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksMatServiceImpl.makeSksMatReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksMat> querymatModelPage(Map<String, Object> parammap) {
        try {
            return this.sksMatMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksMatServiceImpl.querymatModel", (Throwable)e);
            return null;
        }
    }

    private int countmat(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksMatMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksMatServiceImpl.countmat", (Throwable)e);
        }
        return i;
    }

    private SksMat createSksMat(SksMatDomain sksMatDomain) {
        String msg = this.checkmat(sksMatDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksMatServiceImpl.savemat.checkmat", msg);
        }
        SksMat sksMat = this.makemat(sksMatDomain, null);
        this.setmatDefault(sksMat);
        return sksMat;
    }

    @Override
    public String savemat(SksMatDomain sksMatDomain) throws ApiException {
        SksMat sksMat = this.createSksMat(sksMatDomain);
        this.savematModel(sksMat);
        return sksMat.getRequestid();
    }

    @Override
    public String savematBatch(List<SksMatDomain> sksMatDomainList) throws ApiException {
        if (null == sksMatDomainList || sksMatDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksMat> sksMatList = new ArrayList<SksMat>();
        String code = "";
        for (SksMatDomain sksMatDomain : sksMatDomainList) {
            SksMat sksMat = this.createSksMat(sksMatDomain);
            code = sksMat.getRequestid();
            sksMatList.add(sksMat);
        }
        this.savematBatchModel(sksMatList);
        return code;
    }

    @Override
    public void updatematState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStatematModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updatematStateByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatematModelByCode(tenantCode, requestid, dataState, oldDataState, map);
    }

    @Override
    public void updatemat(SksMatDomain sksMatDomain) throws ApiException {
        String msg = this.checkmat(sksMatDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksMatServiceImpl.updatemat.checkmat", msg);
        }
        SksMat oldSksMat = this.getmatModelById(sksMatDomain.getId());
        if (null == oldSksMat) {
            throw new ApiException("SKS.SksMatServiceImpl.updatemat.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksMat sksMat = this.makemat(sksMatDomain, oldSksMat);
        this.setmatUpdataDefault(sksMat);
        this.updatematModel(sksMat);
    }

    @Override
    public SksMat getmat(Integer id) {
        if (null == id) {
            return null;
        }
        return this.getmatModelById(id);
    }

    @Override
    public void deletemat(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deletematModel(id);
    }

    @Override
    public QueryResult<SksMat> querymatPage(Map<String, Object> map) {
        List<SksMat> sksMatList = this.querymatModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countmat(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksMatList);
        return queryResult;
    }

    @Override
    public SksMat getmatByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getmatModelByCode(map);
    }

    @Override
    public void deletematByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delmatModelByCode(map);
    }

    protected String checkMap(SksMatDomain sksMatDomain) {
        if (null == sksMatDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksMatDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sksMatDomain.getRequestid())) {
            msg = msg + "requestid\u4e3a\u7a7a! ";
        }
        return msg;
    }

    public void saveOrUpdateMatOne(SksMatDomain sksMatDomain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestid", sksMatDomain.getRequestid());
        SksMat selectitem = this.sksMatMapper.getByCode(map);
        if (selectitem == null) {
            this.savemat(sksMatDomain);
        } else {
            sksMatDomain.setId(selectitem.getId());
            this.updatemat(sksMatDomain);
        }
    }
}

