/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.api.ExOrderService;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcPackageDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.skshu.supbase.OrderBaseService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class ExOrderServiceImpl
extends OrderBaseService
implements ExOrderService {
    private String SYS_CODE = "SKS.ExOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExOrderServiceImpl.class);

    @Override
    public String sendSaveExOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        try {
            this.makeOcContractDomain(ocContractDomain);
            String contractBillcode = this.saveOrder(ocContractDomain);
            if (StringUtils.isBlank((String)contractBillcode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.contractBillcode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(contractBillcode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendContractState(String contractNbillcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type)) {
            logger.error(this.SYS_CODE + ".sendContractState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendContractState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String contractBillcode = null;
        String msg = this.checkQueryContract(contractNbillcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        QueryResult<OcContractReDomain> qlist = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,channelCode", new Object[]{contractNbillcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        contractBillcode = ((OcContractReDomain)qlist.getList().get(0)).getContractBillcode();
        try {
            if (type.equals("AN")) {
                this.orderNext(contractBillcode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.orderBack(contractBillcode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendRefundState(String refundNcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type) || MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendRefundState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = null;
        String msg = this.checkQueryRefund(refundNcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendRefundState.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", msg);
        }
        QueryResult<OcRefundReDomain> qlist = this.queryRefundPage(this.getQueryMapParam("refundNcode,tenantCode,channelCode", new Object[]{refundNcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", "refundNcode[" + refundNcode + "]\u4e0d\u5b58\u5728! ");
        }
        refundCode = ((OcRefundReDomain)qlist.getList().get(0)).getRefundCode();
        try {
            if (type.equals("AN")) {
                this.refundNext(refundCode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.refundBack(refundCode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.msg", msg);
        }
        try {
            msg = this.makeOcRefundDomain(ocRefundDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", (Object)msg);
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", msg);
            }
            String refundCode = this.saveRefund(ocRefundDomain);
            if (StringUtils.isBlank((String)refundCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExRefund.refundCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.refundCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(refundCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExSendgoods(SgSendgoodsDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sgSendgoodsDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.sgSendgoodsDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoods(sgSendgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.msg", msg);
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        sgSendgoodsDomain.setMemberCode(this.getTeananMemberCode(tenantCode));
        sgSendgoodsDomain.setMemberName("\u5e73\u53f0");
        try {
            String sendgoodsCode = this.saveSendgoods(sgSendgoodsDomain);
            if (StringUtils.isBlank((String)sendgoodsCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(sendgoodsCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExSendgoodsLog(SgSendgoodsLogDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoodsLog(sgSendgoodsLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        try {
            String sendgoodsLogCode = this.saveSendgoodsLog(sgSendgoodsLogDomain);
            if (StringUtils.isBlank((String)sendgoodsLogCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.sendgoodsLogCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.sendgoodsLogCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(sendgoodsLogCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendQueryExOcContract(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.map");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExOcContract.map", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExOcContract.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("childFlag")))) {
            map.put("childFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsProFlag")))) {
            map.put("goodsProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("sendGoodsFlag")))) {
            map.put("sendGoodsFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("packFlag")))) {
            map.put("packFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("settleFlag")))) {
            map.put("settleFlag", "true");
        }
        return this.makeSuccessReturn(this.queryOrderReDomainPage(map));
    }

    @Override
    public String sendQueryExRefund(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExRefund.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractProFlag")))) {
            map.put("ocContractProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractGoodsFlag")))) {
            map.put("ocContractGoodsFlag", "true");
        }
        return this.makeSuccessReturn(this.queryRefundReDoaminPage(map));
    }

    @Override
    public String sendQueryExSgSendgoods(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExSgSendgoods.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsFlag")))) {
            map.put("goodsFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsProFlag")))) {
            map.put("goodsProFlag", "true");
        }
        return this.makeSuccessReturn(this.querySgSendgoodsPage(map));
    }

    private String checkQueryMap(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.map");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)((String)map.get("tenantCode")))) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == map.get("startRow")) {
            msg = msg + "startRow\u4e3a\u7a7a! ";
        }
        if (null == map.get("rows")) {
            msg = msg + "rows\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkContract(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractDomain.getContractType())) {
            msg = msg + "contractType\u4e3a\u7a7a! ";
        }
        if (ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            msg = msg + "goodsList\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == ocContractDomain.getGoodsNum() || ocContractDomain.getGoodsNum().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "goodsNum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        return msg;
    }

    private String checkQueryContract(String contractNbillcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)contractNbillcode)) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkQueryRefund(String refundNcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)refundNcode)) {
            msg = msg + "refundNcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkSendgoods(SgSendgoodsDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkSendgoodsLog(SgSendgoodsLogDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsLogDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sgSendgoodsLogDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkRefund(OcRefundDomain ocRefundDomain) {
        QueryResult<OcRefundReDomain> qlist;
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode()) && StringUtils.isBlank((String)ocRefundDomain.getContractNbillcode())) {
            msg = msg + "contractBillcode\u548ccontractNbillcode\u90fd\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            msg = msg + "refundType\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)ocRefundDomain.getRefundOcode()) && null != (qlist = this.queryRefundPage(this.getQueryMapParam("refundOcode,tenantCode", new Object[]{ocRefundDomain.getRefundOcode(), ocRefundDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "refundOcode[" + ocRefundDomain.getRefundOcode() + "]\u91cd\u590d! ";
        }
        if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "refundMoney\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            msg = msg + "ocRefundGoodsDomainList\u4e3a\u7a7a! ";
        } else {
            int i = 0;
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                ++i;
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + i + "\u884cskuNo\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getContractGoodsGtype())) {
                    msg = msg + "\u7b2c" + i + "\u884ccontractGoodsGtype\u4e3a\u7a7a! ";
                }
                if (null != ocRefundGoodsDomain.getRefundGoodsAmt() && ocRefundGoodsDomain.getRefundGoodsAmt().compareTo(BigDecimal.ZERO) > 0) continue;
                msg = msg + "\u7b2c" + i + "\u884crefundGoodsAmt\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
            }
        }
        return msg;
    }

    private String makeOcRefundDomain(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            return "\u5546\u54c1\u4e3a\u7a7a";
        }
        String msg = "";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ocRefundDomain.getTenantCode());
        paramMap.put("childFlag", "true");
        if (StringUtils.isNotBlank((String)ocRefundDomain.getContractBillcode())) {
            paramMap.put("contractBillcode", ocRefundDomain.getContractBillcode());
        } else {
            paramMap.put("contractNbillcode", ocRefundDomain.getContractNbillcode());
        }
        QueryResult<OcContractReDomain> qlist = this.queryOrderReDomainPage(paramMap);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            logger.error(this.SYS_CODE + ".makeOcRefundDomain.qlist", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
            return "\u8ba2\u5355\u4e3a\u7a7a! " + paramMap.toString();
        }
        BigDecimal refundMoney = ocRefundDomain.getRefundMoney();
        OcContractReDomain ocContractReDomain = (OcContractReDomain)qlist.getList().get(0);
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".makeOcRefundDomain.copy", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()), (Throwable)e);
            return "\u5f02\u5e38! " + paramMap.toString();
        }
        List<OcContractGoodsDomain> goodsList = ocContractReDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            logger.error(this.SYS_CODE + ".makeOcRefundDomain.goodsList", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
            return "\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a! " + paramMap.toString();
        }
        HashMap<String, OcContractGoodsDomain> contractgoodsMap = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            contractgoodsMap.put(ocContractGoodsDomain.getContractGoodsGtype() + "-" + ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
        }
        BigDecimal reMoney = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)contractgoodsMap.get(ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo());
            if (null == ocContractGoodsDomain) {
                logger.error(this.SYS_CODE + ".makeOcRefundDomain.ocContractGoodsDomain", (Object)(ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo()));
                return "\u8ba2\u5355\u5546\u54c1\u5f02\u5e38! " + ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo();
            }
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            reMoney = reMoney.add(ocRefundGoodsDomain.getRefundGoodsAmt());
        }
        ocRefundDomain.setRefundMoney(reMoney);
        if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(reMoney) != 0) {
            msg = msg + "\u660e\u7ec6\u91d1\u989d\u4e0e\u6c47\u603b\u91d1\u989d";
        }
        return msg;
    }

    private String checkOcContractGoodsDomain(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getSkuNo()) && StringUtils.isBlank((String)ocContractGoodsDomain.getSkuCode())) {
            msg = msg + "skuNo\u548cskuCode\u90fd\u4e3a\u7a7a! ";
        }
        return msg;
    }

    @Override
    public String sendQueryExpress(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExpress.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExpress.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExpress.msg", msg);
        }
        return this.makeSuccessReturn(this.queryExpressPage(map));
    }

    @Override
    public String sendSaveBusOrderToEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        String contractBillcode = (String)resStream.get("sendgoodsCode");
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isNotBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.sendgoodsCode");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.sendgoodsCode", "\u53c2\u6570\u5f02\u5e38");
        }
        OcContractReDomain orderByCode = this.getOrderByCode(contractBillcode, tenantCode);
        if (null == orderByCode) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.sendgoodsCode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (2 != orderByCode.getDataState()) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.dataState", "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
        }
        String code = this.orderNext((String)resStream.get("contractBillcode"), tenantCode, resStream);
        return this.makeSuccessReturn(code);
    }

    @Override
    public String sendRefundStateForEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        String contractBillcode = (String)resStream.get("contractBillcode");
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isNotBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.contractBillcode");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.sendgoodsLogCode", "\u53c2\u6570\u5f02\u5e38");
        }
        OcContractReDomain orderByCode = this.getOrderByCode(contractBillcode, tenantCode);
        if (null == orderByCode) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (2 != orderByCode.getDataState()) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.dataState", "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
        }
        String code = this.orderNext((String)resStream.get("contractBillcode"), tenantCode, resStream);
        return this.makeSuccessReturn(code);
    }

    @Override
    public String sendContractByState(String contractBillcode, String tenantCode, String dataState, String approvalOpinion) {
        logger.error(this.SYS_CODE + ".sendContractByState.contractBillcode" + contractBillcode, (Object)(tenantCode + ",dataState:" + dataState + ",approvalOpinion:" + approvalOpinion));
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)dataState)) {
            logger.error(this.SYS_CODE + ".sendContractByState.contractBillcode", (Object)"is null");
            return this.makeErrorReturn(contractBillcode, "\u53c2\u6570\u5f02\u5e38");
        }
        String key = contractBillcode + "=" + dataState;
        String verificationCount = SupDisUtil.getRemot((String)key);
        if (StringUtils.isNotBlank((String)verificationCount)) {
            return this.makeErrorReturn(contractBillcode, "1\u79d2\u540c\u4e00\u8f6c\u6001\u591a\u6b21\u8bf7\u6c42");
        }
        SupDisUtil.set((String)key, (String)key, (int)1);
        OcContractReDomain orderByCode = this.getOrderByCode(contractBillcode, tenantCode);
        if (null == orderByCode) {
            logger.error(this.SYS_CODE + ".sendContractByState.contractBillcode", (Object)contractBillcode);
            return this.makeErrorReturn(contractBillcode, "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if ("QJD00".equals(orderByCode.getContractType())) {
            if ("0".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str1" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                this.updateContractStateNew(orderByCode);
            }
            if ("2".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str21" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (1 == orderByCode.getDataState()) {
                    Date nowdate = new Date();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String paytime = this.getUrl(tenantCode, "contractPaydate", "contractPaydate");
                    if (StringUtils.isNotBlank((String)paytime)) {
                        Date paydate = DateUtils.addMinutes((Date)nowdate, (int)Integer.parseInt(paytime));
                        map.put("contractPaydate", paydate);
                    }
                    logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str21" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)(tenantCode + "paytime" + paytime + map));
                    this.orderNext(contractBillcode, tenantCode, map);
                }
            }
            if ("1".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str3" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (10 == orderByCode.getDataState()) {
                    this.orderBack(contractBillcode, tenantCode, null);
                }
            }
            if ("5".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str4" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (10 == orderByCode.getDataState()) {
                    this.orderNext(contractBillcode, tenantCode, null);
                }
            }
            if ("3".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str5" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (orderByCode.getDataState() == 2) {
                    this.orderNext(contractBillcode, tenantCode, null);
                }
            }
            if ("11".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str61" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (2 == orderByCode.getDataState()) {
                    this.orderBack(contractBillcode, tenantCode, null);
                }
            }
            if ("12".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str61" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (1 == orderByCode.getDataState() && "8a8ace589467911101946c9c47da528c".equals(orderByCode.getContractTypepro())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("dataStateStr", "12");
                    this.orderNext(contractBillcode, tenantCode, map);
                }
            }
        } else {
            if ("0".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str6" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                this.updateContractStateNew(orderByCode);
            }
            if ("2".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str7" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (1 == orderByCode.getDataState()) {
                    Date nowdate = new Date();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String paytime = this.getUrl(tenantCode, "contractPaydate", "contractPaydate");
                    if (StringUtils.isNotBlank((String)paytime)) {
                        Date paydate = DateUtils.addMinutes((Date)nowdate, (int)Integer.parseInt(paytime));
                        map.put("contractPaydate", paydate);
                    }
                    logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str71" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)(tenantCode + "paytime" + paytime + map));
                    this.orderNext(contractBillcode, tenantCode, map);
                }
            }
            if ("5".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str8" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (2 == orderByCode.getDataState()) {
                    this.orderNext(contractBillcode, tenantCode, null);
                }
            }
            if ("12".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str12" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (1 == orderByCode.getDataState() && "8a8ace589467911101946c9c47da528c".equals(orderByCode.getContractTypepro())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("dataStateStr", "12");
                    this.orderNext(contractBillcode, tenantCode, map);
                }
            }
            if ("11".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str9" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                if (2 == orderByCode.getDataState()) {
                    this.orderBack(contractBillcode, tenantCode, null);
                }
            }
            if ("-1".equals(dataState)) {
                logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode.str10" + contractBillcode + "dataState" + orderByCode.getDataState(), (Object)tenantCode);
                this.updateContractStateNew(orderByCode);
            }
        }
        if (StringUtils.isNotBlank((String)approvalOpinion)) {
            logger.info(this.SYS_CODE + ".sendContractByCancelState.approvalOpinion==" + approvalOpinion);
            this.updateContract(orderByCode.getContractBillcode(), orderByCode.getTenantCode(), orderByCode.getContractEcflag(), approvalOpinion);
        }
        return this.makeSuccessReturn(contractBillcode);
    }

    @Override
    public String sendContractByCancelState(String contractBillcode, String tenantCode, String dataState) {
        logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode" + contractBillcode, (Object)tenantCode);
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode", (Object)"is null");
            return this.makeErrorReturn(contractBillcode, "\u53c2\u6570\u5f02\u5e38");
        }
        OcContractReDomain orderByCode = this.getOrderByCode(contractBillcode, tenantCode);
        if (null == orderByCode) {
            logger.error(this.SYS_CODE + ".sendContractByCancelState.contractBillcode", (Object)contractBillcode);
            return this.makeErrorReturn(contractBillcode, "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String code = this.orderBack(contractBillcode, tenantCode, null);
        return this.makeSuccessReturn(code);
    }

    @Override
    public String sendSaveOrder(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveOrder", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream) || StringUtils.isBlank((String)tenantCode)) {
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), OcContractDomain.class);
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveOrder.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcContractReDomain orderByCode = this.getOrderByCode(ocContractDomain.getContractBillcode(), tenantCode);
        if (null != orderByCode) {
            logger.error(this.SYS_CODE + ".sendSaveOrder.contractBillcode", (Object)ocContractDomain.getContractBillcode());
            return this.makeErrorReturn(ocContractDomain.getContractBillcode(), "\u8ba2\u5355\u53f7\u5b58\u5728");
        }
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveOrder.msg", msg);
        }
        try {
            QueryResult<UmUserinfoReDomain> qlist = this.queryUserinfoPage(this.getQueryMapParam("userinfoOcode,tenantCode", new Object[]{ocContractDomain.getMemberBcode(), ocContractDomain.getTenantCode()}));
            if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
                logger.error(this.SYS_CODE + ".sendSaveOrder.getList");
                return this.makeErrorReturn(ocContractDomain.getContractBillcode(), "\u6dfb\u52a0\u5931\u8d25" + ocContractDomain.getMemberBcode() + "\u7528\u6237\u4e0d\u5b58\u5728");
            }
            ocContractDomain.setMemberBcode(((UmUserinfoReDomain)qlist.getList().get(0)).getUserinfoCode());
            this.makeOcContractDomain(ocContractDomain);
            ocContractDomain.setDataState(3);
            String contractBillcode = this.saveOrder(ocContractDomain);
            if (StringUtils.isBlank((String)contractBillcode)) {
                logger.error(this.SYS_CODE + ".sendSaveOrder.contractBillcode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveOrder.contractBillcode", "\u4fdd\u5b58\u5f02\u5e38" + ocContractDomain.getContractBillcode());
            }
            return this.makeSuccessReturn(ocContractDomain.getContractBillcode());
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveOrder.e", e.getErrMsg() + "contractBillcode" + ocContractDomain.getContractBillcode());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveOrder.e1", e.getMessage() + "contractBillcode" + ocContractDomain.getContractBillcode());
        }
    }

    private void makeOcContractDomain(OcContractDomain ocContractDomain) {
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                ocContractDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
                ocContractDomain.setMemberName(ocContractGoodsDomain.getMemberName());
            }
            ocContractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getContractGoodsGtype()) && "0".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                ocContractDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
                ocContractDomain.setMemberName(ocContractGoodsDomain.getMemberName());
            }
            if (null == ocContractGoodsDomain.getGoodsNum()) {
                ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
                ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsPefinmoney()) {
                ocContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            if (null != ocContractGoodsDomain.getGoodsWeight()) continue;
            ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        OcPackageDomain ocPackageDomain = this.createpackgeByGoods(ocContractDomain);
        ocPackageDomain.setContractGoodsList(ocContractDomain.getGoodsList());
        ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
        packageList.add(ocPackageDomain);
        ocContractDomain.setPackageList(packageList);
    }

    private OcPackageDomain createpackgeByGoods(OcContractDomain ocContractDomain) {
        if (ocContractDomain == null) {
            return null;
        }
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)ocContractDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == ocPackageDomain.getGoodsNum()) {
            ocPackageDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == ocPackageDomain.getGoodsWeight()) {
            ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == ocPackageDomain.getGoodsMoney()) {
            ocPackageDomain.setGoodsMoney(BigDecimal.ZERO);
        }
        if (null == ocPackageDomain.getGoodsPmoney()) {
            ocPackageDomain.setGoodsPmoney(BigDecimal.ZERO);
        }
        if (null == ocPackageDomain.getGoodsMoney()) {
            ocPackageDomain.setGoodsMoney(BigDecimal.ZERO);
        }
        if (null == ocPackageDomain.getPricesetRefrice()) {
            ocPackageDomain.setPricesetRefrice(BigDecimal.ZERO);
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            ocPackageDomain.setGoodsNum(ocPackageDomain.getGoodsNum().add(ocContractGoodsDomain.getGoodsNum()));
            ocPackageDomain.setGoodsWeight(ocPackageDomain.getGoodsWeight().add(ocContractGoodsDomain.getGoodsWeight()));
            ocPackageDomain.setGoodsInmoney(ocPackageDomain.getGoodsMoney().add(ocContractGoodsDomain.getContractGoodsInmoney()));
            ocPackageDomain.setGoodsMoney(ocPackageDomain.getGoodsMoney().add(ocContractGoodsDomain.getContractGoodsInmoney()));
            ocPackageDomain.setGoodsPmoney(ocPackageDomain.getGoodsPmoney().add(ocContractGoodsDomain.getContractGoodsMoney()));
            ocPackageDomain.setPricesetRefrice(ocPackageDomain.getPricesetRefrice().add(ocContractGoodsDomain.getContractGoodsPefinmoney()));
        }
        return ocPackageDomain;
    }
}

