/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksFactoryPriceMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksFactoryPriceDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksFactoryPriceReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksFactoryPrice;
import com.yqbsoft.laser.service.ext.skshu.service.SksFactoryPriceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksFactoryPriceServiceImpl
extends BaseServiceImpl
implements SksFactoryPriceService {
    private static final String SYS_CODE = "SKS.SksFactoryPriceServiceImpl";
    private SksFactoryPriceMapper sksFactoryPriceMapper;

    public void setSksFactoryPriceMapper(SksFactoryPriceMapper sksFactoryPriceMapper) {
        this.sksFactoryPriceMapper = sksFactoryPriceMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksFactoryPriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksFactoryPriceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checksourceFactoryPrice(SksFactoryPriceDomain sksFactoryPriceDomain) {
        if (null == sksFactoryPriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksFactoryPriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setsourceFactoryPriceDefault(SksFactoryPrice sksFactoryPrice) {
        if (null == sksFactoryPrice) {
            return;
        }
        if (null == sksFactoryPrice.getDataState()) {
            sksFactoryPrice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksFactoryPrice.getGmtCreate()) {
            sksFactoryPrice.setGmtCreate(date);
        }
        sksFactoryPrice.setGmtModified(date);
    }

    private int getsourceFactoryPriceMaxCode() {
        int code = 0;
        try {
            return this.sksFactoryPriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksFactoryPriceServiceImpl.getsourceFactoryPriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setsourceFactoryPriceUpdataDefault(SksFactoryPrice sksFactoryPrice) {
        if (null == sksFactoryPrice) {
            return;
        }
        sksFactoryPrice.setGmtModified(this.getSysDate());
    }

    private void savesourceFactoryPriceModel(SksFactoryPrice sksFactoryPrice) throws ApiException {
        if (null == sksFactoryPrice) {
            return;
        }
        try {
            this.sksFactoryPriceMapper.insert(sksFactoryPrice);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.savesourceFactoryPriceModel.ex", (Throwable)e);
        }
    }

    private void savesourceFactoryPriceBatchModel(List<SksFactoryPrice> sksFactoryPriceList) throws ApiException {
        if (null == sksFactoryPriceList || sksFactoryPriceList.isEmpty()) {
            return;
        }
        try {
            this.sksFactoryPriceMapper.insertBatch(sksFactoryPriceList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.savesourceFactoryPriceBatchModel.ex", (Throwable)e);
        }
    }

    private SksFactoryPrice getsourceFactoryPriceModelById(String requestid) {
        if (null == requestid) {
            return null;
        }
        try {
            return this.sksFactoryPriceMapper.selectByPrimaryKey(requestid);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksFactoryPriceServiceImpl.getsourceFactoryPriceModelById", (Throwable)e);
            return null;
        }
    }

    private SksFactoryPrice getsourceFactoryPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksFactoryPriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksFactoryPriceServiceImpl.getsourceFactoryPriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delsourceFactoryPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksFactoryPriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.delsourceFactoryPriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.delsourceFactoryPriceModelByCode.num");
        }
    }

    private void deletesourceFactoryPriceModel(String requestid) throws ApiException {
        if (null == requestid) {
            return;
        }
        int i = 0;
        try {
            i = this.sksFactoryPriceMapper.deleteByPrimaryKey(requestid);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.deletesourceFactoryPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.deletesourceFactoryPriceModel.num");
        }
    }

    private void updatesourceFactoryPriceModel(SksFactoryPrice sksFactoryPrice) throws ApiException {
        if (null == sksFactoryPrice) {
            return;
        }
        int i = 0;
        try {
            i = this.sksFactoryPriceMapper.updateByPrimaryKey(sksFactoryPrice);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.updatesourceFactoryPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.updatesourceFactoryPriceModel.num");
        }
    }

    private void updateStatesourceFactoryPriceModel(Integer sourceFactoryPriceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sourceFactoryPriceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceFactoryPriceId", sourceFactoryPriceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksFactoryPriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.updateStatesourceFactoryPriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.updateStatesourceFactoryPriceModel.null");
        }
    }

    private void updateStatesourceFactoryPriceModelByCode(String tenantCode, String sourceFactoryPriceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sourceFactoryPriceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sourceFactoryPriceCode", sourceFactoryPriceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksFactoryPriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.updateStatesourceFactoryPriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.updateStatesourceFactoryPriceModelByCode.null");
        }
    }

    private SksFactoryPrice makesourceFactoryPrice(SksFactoryPriceDomain sksFactoryPriceDomain, SksFactoryPrice sksFactoryPrice) {
        if (null == sksFactoryPriceDomain) {
            return null;
        }
        if (null == sksFactoryPrice) {
            sksFactoryPrice = new SksFactoryPrice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksFactoryPrice, (Object)sksFactoryPriceDomain);
            return sksFactoryPrice;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksFactoryPriceServiceImpl.makesourceFactoryPrice", (Throwable)e);
            return null;
        }
    }

    private SksFactoryPriceReDomain makeSksFactoryPriceReDomain(SksFactoryPrice sksFactoryPrice) {
        if (null == sksFactoryPrice) {
            return null;
        }
        SksFactoryPriceReDomain sksFactoryPriceReDomain = new SksFactoryPriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksFactoryPriceReDomain, (Object)sksFactoryPrice);
            return sksFactoryPriceReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksFactoryPriceServiceImpl.makeSksFactoryPriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksFactoryPrice> querysourceFactoryPriceModelPage(Map<String, Object> parammap) {
        try {
            return this.sksFactoryPriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksFactoryPriceServiceImpl.querysourceFactoryPriceModel", (Throwable)e);
            return null;
        }
    }

    private int countsourceFactoryPrice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksFactoryPriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksFactoryPriceServiceImpl.countsourceFactoryPrice", (Throwable)e);
        }
        return i;
    }

    private SksFactoryPrice createSksFactoryPrice(SksFactoryPriceDomain sksFactoryPriceDomain) {
        String msg = this.checksourceFactoryPrice(sksFactoryPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.savesourceFactoryPrice.checksourceFactoryPrice", msg);
        }
        SksFactoryPrice sksFactoryPrice = this.makesourceFactoryPrice(sksFactoryPriceDomain, null);
        this.setsourceFactoryPriceDefault(sksFactoryPrice);
        return sksFactoryPrice;
    }

    @Override
    public String savesourceFactoryPrice(SksFactoryPriceDomain sksFactoryPriceDomain) throws ApiException {
        SksFactoryPrice sksFactoryPrice = this.createSksFactoryPrice(sksFactoryPriceDomain);
        this.savesourceFactoryPriceModel(sksFactoryPrice);
        return sksFactoryPrice.getRequestid();
    }

    @Override
    public String savesourceFactoryPriceBatch(List<SksFactoryPriceDomain> sksFactoryPriceDomainList) throws ApiException {
        if (null == sksFactoryPriceDomainList || sksFactoryPriceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksFactoryPrice> sksFactoryPriceList = new ArrayList<SksFactoryPrice>();
        String code = "";
        for (SksFactoryPriceDomain sksFactoryPriceDomain : sksFactoryPriceDomainList) {
            SksFactoryPrice sksFactoryPrice = this.createSksFactoryPrice(sksFactoryPriceDomain);
            sksFactoryPriceList.add(sksFactoryPrice);
        }
        this.savesourceFactoryPriceBatchModel(sksFactoryPriceList);
        return code;
    }

    @Override
    public void updatesourceFactoryPriceState(Integer sourceFactoryPriceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == sourceFactoryPriceId) {
            return;
        }
        this.updateStatesourceFactoryPriceModel(sourceFactoryPriceId, dataState, oldDataState, map);
    }

    @Override
    public void updatesourceFactoryPriceStateByCode(String tenantCode, String sourceFactoryPriceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)sourceFactoryPriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatesourceFactoryPriceModelByCode(tenantCode, sourceFactoryPriceCode, dataState, oldDataState, map);
    }

    @Override
    public void updatesourceFactoryPrice(SksFactoryPriceDomain sksFactoryPriceDomain) throws ApiException {
        String msg = this.checksourceFactoryPrice(sksFactoryPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.updatesourceFactoryPrice.checksourceFactoryPrice", msg);
        }
        SksFactoryPrice oldSksFactoryPrice = this.getsourceFactoryPriceModelById(sksFactoryPriceDomain.getRequestid());
        if (null == oldSksFactoryPrice) {
            throw new ApiException("SKS.SksFactoryPriceServiceImpl.updatesourceFactoryPrice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksFactoryPrice sksFactoryPrice = this.makesourceFactoryPrice(sksFactoryPriceDomain, oldSksFactoryPrice);
        this.setsourceFactoryPriceUpdataDefault(sksFactoryPrice);
        this.updatesourceFactoryPriceModel(sksFactoryPrice);
    }

    @Override
    public QueryResult<SksFactoryPrice> querysourceFactoryPricePage(Map<String, Object> map) {
        List<SksFactoryPrice> sksFactoryPriceList = this.querysourceFactoryPriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countsourceFactoryPrice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksFactoryPriceList);
        return queryResult;
    }

    @Override
    public SksFactoryPrice getsourceFactoryPriceByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getsourceFactoryPriceModelByCode(map);
    }

    @Override
    public void deletesourceFactoryPriceByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delsourceFactoryPriceModelByCode(map);
    }
}

