/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksSkuSalesMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSkuSalesDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSkuSalesReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksSkuSales;
import com.yqbsoft.laser.service.ext.skshu.service.SksSkuSalesService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksSkuSalesServiceImpl
extends BaseServiceImpl
implements SksSkuSalesService {
    private static final String SYS_CODE = "SKS.SksSkuSalesServiceImpl";
    private SksSkuSalesMapper sksSkuSalesMapper;

    public void setSksSkuSalesMapper(SksSkuSalesMapper sksSkuSalesMapper) {
        this.sksSkuSalesMapper = sksSkuSalesMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksSkuSalesMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSkuSalesServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSkuSales(SksSkuSalesDomain sksSkuSalesDomain) {
        if (null == sksSkuSalesDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksSkuSalesDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuSalesDefault(SksSkuSales sksSkuSales) {
        if (null == sksSkuSales) {
            return;
        }
        if (null == sksSkuSales.getDataState()) {
            sksSkuSales.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksSkuSales.getGmtCreate()) {
            sksSkuSales.setGmtCreate(date);
        }
        sksSkuSales.setGmtModified(date);
        if (StringUtils.isBlank((String)sksSkuSales.getSkuSalesCode())) {
            sksSkuSales.setSkuSalesCode(this.getNo(null, "SksSkuSales", "sksSkuSales", sksSkuSales.getTenantCode()));
        }
    }

    private int getSkuSalesMaxCode() {
        int code = 0;
        try {
            return this.sksSkuSalesMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSkuSalesServiceImpl.getSkuSalesMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuSalesUpdataDefault(SksSkuSales sksSkuSales) {
        if (null == sksSkuSales) {
            return;
        }
        sksSkuSales.setGmtModified(this.getSysDate());
    }

    private void saveSkuSalesModel(SksSkuSales sksSkuSales) throws ApiException {
        if (null == sksSkuSales) {
            return;
        }
        try {
            this.sksSkuSalesMapper.insert(sksSkuSales);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.saveSkuSalesModel.ex", (Throwable)e);
        }
    }

    private void saveSkuSalesBatchModel(List<SksSkuSales> sksSkuSalesList) throws ApiException {
        if (null == sksSkuSalesList || sksSkuSalesList.isEmpty()) {
            return;
        }
        try {
            this.sksSkuSalesMapper.insertBatch(sksSkuSalesList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.saveSkuSalesBatchModel.ex", (Throwable)e);
        }
    }

    private SksSkuSales getSkuSalesModelById(Integer skuSalesId) {
        if (null == skuSalesId) {
            return null;
        }
        try {
            return this.sksSkuSalesMapper.selectByPrimaryKey(skuSalesId);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSkuSalesServiceImpl.getSkuSalesModelById", (Throwable)e);
            return null;
        }
    }

    private SksSkuSales getSkuSalesModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSkuSalesMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSkuSalesServiceImpl.getSkuSalesModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSkuSalesModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSkuSalesMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.delSkuSalesModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.delSkuSalesModelByCode.num");
        }
    }

    private void deleteSkuSalesModel(Integer skuSalesId) throws ApiException {
        if (null == skuSalesId) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSkuSalesMapper.deleteByPrimaryKey(skuSalesId);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.deleteSkuSalesModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.deleteSkuSalesModel.num");
        }
    }

    private void updateSkuSalesModel(SksSkuSales sksSkuSales) throws ApiException {
        if (null == sksSkuSales) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSkuSalesMapper.updateByPrimaryKeySelective(sksSkuSales);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.updateSkuSalesModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.updateSkuSalesModel.num");
        }
    }

    private void updateStateSkuSalesModel(Integer skuSalesId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == skuSalesId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuSalesId", skuSalesId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSkuSalesMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.updateStateSkuSalesModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.updateStateSkuSalesModel.null");
        }
    }

    private void updateStateSkuSalesModelByCode(String tenantCode, String skuSalesCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)skuSalesCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuSalesCode", skuSalesCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSkuSalesMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.updateStateSkuSalesModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.updateStateSkuSalesModelByCode.null");
        }
    }

    private SksSkuSales makeSkuSales(SksSkuSalesDomain sksSkuSalesDomain, SksSkuSales sksSkuSales) {
        if (null == sksSkuSalesDomain) {
            return null;
        }
        if (null == sksSkuSales) {
            sksSkuSales = new SksSkuSales();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksSkuSales, (Object)sksSkuSalesDomain);
            return sksSkuSales;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSkuSalesServiceImpl.makeSkuSales", (Throwable)e);
            return null;
        }
    }

    private SksSkuSalesReDomain makeSksSkuSalesReDomain(SksSkuSales sksSkuSales) {
        if (null == sksSkuSales) {
            return null;
        }
        SksSkuSalesReDomain sksSkuSalesReDomain = new SksSkuSalesReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksSkuSalesReDomain, (Object)sksSkuSales);
            return sksSkuSalesReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSkuSalesServiceImpl.makeSksSkuSalesReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksSkuSales> querySkuSalesModelPage(Map<String, Object> parammap) {
        try {
            return this.sksSkuSalesMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSkuSalesServiceImpl.querySkuSalesModel", (Throwable)e);
            return null;
        }
    }

    private int countSkuSales(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksSkuSalesMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSkuSalesServiceImpl.countSkuSales", (Throwable)e);
        }
        return i;
    }

    private SksSkuSales createSksSkuSales(SksSkuSalesDomain sksSkuSalesDomain) {
        String msg = this.checkSkuSales(sksSkuSalesDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.saveSkuSales.checkSkuSales", msg);
        }
        SksSkuSales sksSkuSales = this.makeSkuSales(sksSkuSalesDomain, null);
        this.setSkuSalesDefault(sksSkuSales);
        return sksSkuSales;
    }

    @Override
    public String saveSkuSales(SksSkuSalesDomain sksSkuSalesDomain) throws ApiException {
        SksSkuSales sksSkuSales = this.createSksSkuSales(sksSkuSalesDomain);
        this.saveSkuSalesModel(sksSkuSales);
        return sksSkuSales.getSkuSalesCode();
    }

    @Override
    public String saveSkuSalesBatch(List<SksSkuSalesDomain> sksSkuSalesDomainList) throws ApiException {
        if (null == sksSkuSalesDomainList || sksSkuSalesDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksSkuSales> sksSkuSalesList = new ArrayList<SksSkuSales>();
        String code = "";
        for (SksSkuSalesDomain sksSkuSalesDomain : sksSkuSalesDomainList) {
            SksSkuSales sksSkuSales = this.createSksSkuSales(sksSkuSalesDomain);
            code = sksSkuSales.getSkuSalesCode();
            sksSkuSalesList.add(sksSkuSales);
        }
        this.saveSkuSalesBatchModel(sksSkuSalesList);
        return code;
    }

    @Override
    public void updateSkuSalesState(Integer skuSalesId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == skuSalesId) {
            return;
        }
        this.updateStateSkuSalesModel(skuSalesId, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuSalesStateByCode(String tenantCode, String skuSalesCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)skuSalesCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSkuSalesModelByCode(tenantCode, skuSalesCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuSales(SksSkuSalesDomain sksSkuSalesDomain) throws ApiException {
        String msg = this.checkSkuSales(sksSkuSalesDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.updateSkuSales.checkSkuSales", msg);
        }
        SksSkuSales oldSksSkuSales = this.getSkuSalesModelById(sksSkuSalesDomain.getSkuSalesId());
        if (null == oldSksSkuSales) {
            throw new ApiException("SKS.SksSkuSalesServiceImpl.updateSkuSales.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksSkuSales sksSkuSales = this.makeSkuSales(sksSkuSalesDomain, oldSksSkuSales);
        this.setSkuSalesUpdataDefault(sksSkuSales);
        this.updateSkuSalesModel(sksSkuSales);
    }

    @Override
    public SksSkuSales getSkuSales(Integer skuSalesId) {
        if (null == skuSalesId) {
            return null;
        }
        return this.getSkuSalesModelById(skuSalesId);
    }

    @Override
    public void deleteSkuSales(Integer skuSalesId) throws ApiException {
        if (null == skuSalesId) {
            return;
        }
        this.deleteSkuSalesModel(skuSalesId);
    }

    @Override
    public QueryResult<SksSkuSales> querySkuSalesPage(Map<String, Object> map) {
        List<SksSkuSales> sksSkuSalesList = this.querySkuSalesModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSkuSales(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksSkuSalesList);
        return queryResult;
    }

    @Override
    public SksSkuSales getSkuSalesByCode(String tenantCode, String skuSalesCode) throws ApiException {
        if (StringUtils.isBlank((String)skuSalesCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuSalesCode", skuSalesCode);
        return this.getSkuSalesModelByCode(map);
    }

    @Override
    public void deleteSkuSalesByCode(String tenantCode, String skuSalesCode) throws ApiException {
        if (StringUtils.isBlank((String)skuSalesCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuSalesCode", skuSalesCode);
        this.delSkuSalesModelByCode(map);
    }
}

