/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksSgConfigMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSgConfigDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksSgConfigReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksSgConfig;
import com.yqbsoft.laser.service.ext.skshu.service.SksSgConfigService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksSgConfigServiceImpl
extends BaseServiceImpl
implements SksSgConfigService {
    private static final String SYS_CODE = "SKS.SksSgConfigServiceImpl";
    private SksSgConfigMapper sksSgConfigMapper;

    public void setSksSgConfigMapper(SksSgConfigMapper sksSgConfigMapper) {
        this.sksSgConfigMapper = sksSgConfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksSgConfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checksgConfig(SksSgConfigDomain sksSgConfigDomain) {
        if (null == sksSgConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksSgConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setsgConfigDefault(SksSgConfig sksSgConfig) {
        if (null == sksSgConfig) {
            return;
        }
        if (null == sksSgConfig.getDataState()) {
            sksSgConfig.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksSgConfig.getGmtCreate()) {
            sksSgConfig.setGmtCreate(date);
        }
        sksSgConfig.setGmtModified(date);
        if (StringUtils.isBlank((String)sksSgConfig.getRequestid())) {
            sksSgConfig.setRequestid(this.getNo(null, "SksSgConfig", "sksSgConfig", sksSgConfig.getTenantCode()));
        }
    }

    private int getsgConfigMaxCode() {
        int code = 0;
        try {
            return this.sksSgConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.getsgConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setsgConfigUpdataDefault(SksSgConfig sksSgConfig) {
        if (null == sksSgConfig) {
            return;
        }
        sksSgConfig.setGmtModified(this.getSysDate());
    }

    private void savesgConfigModel(SksSgConfig sksSgConfig) throws ApiException {
        if (null == sksSgConfig) {
            return;
        }
        try {
            this.sksSgConfigMapper.insert(sksSgConfig);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.savesgConfigModel.ex", (Throwable)e);
        }
    }

    private void savesgConfigBatchModel(List<SksSgConfig> sksSgConfigList) throws ApiException {
        if (null == sksSgConfigList || sksSgConfigList.isEmpty()) {
            return;
        }
        try {
            this.sksSgConfigMapper.insertBatch(sksSgConfigList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.savesgConfigBatchModel.ex", (Throwable)e);
        }
    }

    private SksSgConfig getsgConfigModelById(String id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksSgConfigMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.getsgConfigModelById", (Throwable)e);
            return null;
        }
    }

    private SksSgConfig getsgConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSgConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.getsgConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private SksSgConfig getBySkuCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSgConfigMapper.getBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.getsgConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private SksSgConfig getByCpxlCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSgConfigMapper.getByCpxlCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.getsgConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private SksSgConfig getByCpzlCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksSgConfigMapper.getByCpzlCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.getsgConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delsgConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSgConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.delsgConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.delsgConfigModelByCode.num");
        }
    }

    private void deletesgConfigModel(String requestid) throws ApiException {
        if (null == requestid) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSgConfigMapper.deleteByPrimaryKey(requestid);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.deletesgConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.deletesgConfigModel.num");
        }
    }

    private void updatesgConfigModel(SksSgConfig sksSgConfig) throws ApiException {
        if (null == sksSgConfig) {
            return;
        }
        int i = 0;
        try {
            i = this.sksSgConfigMapper.updateByPrimaryKey(sksSgConfig);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.updatesgConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.updatesgConfigModel.num");
        }
    }

    private void updateStatesgConfigModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSgConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.updateStatesgConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.updateStatesgConfigModel.null");
        }
    }

    private void updateStatesgConfigModelByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksSgConfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.updateStatesgConfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.updateStatesgConfigModelByCode.null");
        }
    }

    private SksSgConfig makesgConfig(SksSgConfigDomain sksSgConfigDomain, SksSgConfig sksSgConfig) {
        if (null == sksSgConfigDomain) {
            return null;
        }
        if (null == sksSgConfig) {
            sksSgConfig = new SksSgConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksSgConfig, (Object)sksSgConfigDomain);
            return sksSgConfig;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.makesgConfig", (Throwable)e);
            return null;
        }
    }

    private SksSgConfigReDomain makeSksSgConfigReDomain(SksSgConfig sksSgConfig) {
        if (null == sksSgConfig) {
            return null;
        }
        SksSgConfigReDomain sksSgConfigReDomain = new SksSgConfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksSgConfigReDomain, (Object)sksSgConfig);
            return sksSgConfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.makeSksSgConfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksSgConfig> querysgConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.sksSgConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.querysgConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countsgConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksSgConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksSgConfigServiceImpl.countsgConfig", (Throwable)e);
        }
        return i;
    }

    private SksSgConfig createSksSgConfig(SksSgConfigDomain sksSgConfigDomain) {
        String msg = this.checksgConfig(sksSgConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.savesgConfig.checksgConfig", msg);
        }
        SksSgConfig sksSgConfig = this.makesgConfig(sksSgConfigDomain, null);
        this.setsgConfigDefault(sksSgConfig);
        return sksSgConfig;
    }

    @Override
    public String savesgConfig(SksSgConfigDomain sksSgConfigDomain) throws ApiException {
        SksSgConfig sksSgConfig = this.createSksSgConfig(sksSgConfigDomain);
        this.savesgConfigModel(sksSgConfig);
        return sksSgConfig.getRequestid();
    }

    @Override
    public String savesgConfigBatch(List<SksSgConfigDomain> sksSgConfigDomainList) throws ApiException {
        if (null == sksSgConfigDomainList || sksSgConfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksSgConfig> sksSgConfigList = new ArrayList<SksSgConfig>();
        String code = "";
        for (SksSgConfigDomain sksSgConfigDomain : sksSgConfigDomainList) {
            SksSgConfig sksSgConfig = this.createSksSgConfig(sksSgConfigDomain);
            code = sksSgConfig.getRequestid();
            sksSgConfigList.add(sksSgConfig);
        }
        this.savesgConfigBatchModel(sksSgConfigList);
        return code;
    }

    @Override
    public void updatesgConfigState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStatesgConfigModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updatesgConfigStateByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatesgConfigModelByCode(tenantCode, requestid, dataState, oldDataState, map);
    }

    @Override
    public void updatesgConfig(SksSgConfigDomain sksSgConfigDomain) throws ApiException {
        String msg = this.checksgConfig(sksSgConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.updatesgConfig.checksgConfig", msg);
        }
        SksSgConfig oldSksSgConfig = this.getsgConfigModelById(sksSgConfigDomain.getRequestid());
        if (null == oldSksSgConfig) {
            throw new ApiException("SKS.SksSgConfigServiceImpl.updatesgConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksSgConfig sksSgConfig = this.makesgConfig(sksSgConfigDomain, oldSksSgConfig);
        this.setsgConfigUpdataDefault(sksSgConfig);
        this.updatesgConfigModel(sksSgConfig);
    }

    @Override
    public SksSgConfig getConfigByPriority(String bomId, String cpxlCode, String cpzlCode, String tenantCode) {
        HashMap<String, Object> skuMap = new HashMap<String, Object>();
        skuMap.put("bomid", bomId);
        skuMap.put("tenantCode", tenantCode);
        SksSgConfig config = this.getBySkuCode(skuMap);
        if (config != null) {
            return config;
        }
        HashMap<String, Object> cpxlMap = new HashMap<String, Object>();
        cpxlMap.put("cpxlcode", cpxlCode);
        cpxlMap.put("tenantCode", tenantCode);
        config = this.getByCpxlCode(cpxlMap);
        if (config != null) {
            return config;
        }
        HashMap<String, Object> cpzlMap = new HashMap<String, Object>();
        cpzlMap.put("cpzlcode", cpzlCode);
        cpzlMap.put("tenantCode", tenantCode);
        config = this.getByCpzlCode(cpzlMap);
        if (config != null) {
            return config;
        }
        return null;
    }

    @Override
    public void deletesgConfig(String requestid) throws ApiException {
        if (null == requestid) {
            return;
        }
        this.deletesgConfigModel(requestid);
    }

    @Override
    public QueryResult<SksSgConfig> querysgConfigPage(Map<String, Object> map) {
        List<SksSgConfig> sksSgConfigList = this.querysgConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countsgConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksSgConfigList);
        return queryResult;
    }

    @Override
    public SksSgConfig getsgConfigByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getsgConfigModelByCode(map);
    }

    @Override
    public void deletesgConfigByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delsgConfigModelByCode(map);
    }
}

