/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.google.common.collect.Maps;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.domain.ct.CtCustrelReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.inv.WorkPushMessage;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcContractSettlDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmUser;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.ext.skshu.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.skshu.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcEsbContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcRefundRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.oc.OcSapContractRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.request.sg.SgSendgoodsRequest;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.EsbContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.OcContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.OcRefundResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.oc.SapContractResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.skshu.facade.response.sg.SgSendgoodsResponse;
import com.yqbsoft.laser.service.ext.skshu.model.OcContractPmGoods;
import com.yqbsoft.laser.service.ext.skshu.model.PayCommit;
import com.yqbsoft.laser.service.ext.skshu.model.SksRespriceColorprice;
import com.yqbsoft.laser.service.ext.skshu.service.BusOrderService;
import com.yqbsoft.laser.service.ext.skshu.service.SksRespriceColorpriceService;
import com.yqbsoft.laser.service.ext.skshu.supbase.OrderBaseService;
import com.yqbsoft.laser.service.ext.skshu.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.ext.skshu.util.SignUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "SKS.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";
    @Autowired
    RestTempfacade restTempfacade;
    @Autowired
    SksRespriceColorpriceService sksRespriceColorpriceService;
    private static final String AUTHORIZE_URL = "http://10.10.69.33:10600/papi/openapi/oauth2/authorize";
    private static final String TOKEN_URL = "http://10.10.69.33:10600/papi/openapi/oauth2/access_token";
    private static final String CORP_ID = "d79a4e53f7fe3d2d91add8bef7fa3436";
    private static final String APP_KEY = "8ec59db9d4d5d64e771e75a0031e06a3";
    private static final String APP_SECRET = "32f74a05f2ca40b00d8721cced201f76";

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        OcContractRequest ocContractRequest = new OcContractRequest();
        ocContractRequest.init(this.getDdMap(tenantCode, this.ddcode, "SKS"));
        try {
            BeanUtils.copyAllPropertys((Object)ocContractRequest, (Object)ocContractDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.e", (Throwable)e);
            return "error";
        }
        OcContractResponse ocContractResponse = this.restTempfacade.execute(ocContractRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse", (Object)ocContractResponse.getMsg());
            return ocContractResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        OcRefundRequest ocRefundRequest = new OcRefundRequest();
        ocRefundRequest.init(this.getDdMap(tenantCode, this.ddcode, "SKS"));
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundRequest, (Object)ocRefundDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.e", (Object)e);
            return "error";
        }
        OcRefundResponse ocRefundResponse = this.restTempfacade.execute(ocRefundRequest);
        if (null == ocRefundResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse");
            return "error";
        }
        if (!ocRefundResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse", (Object)ocRefundResponse.getMsg());
            return ocRefundResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        SgSendgoodsRequest sgSendgoodsRequest = new SgSendgoodsRequest();
        sgSendgoodsRequest.init(this.getDdMap(tenantCode, this.ddcode, "SKS"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsRequest, (Object)sgSendgoodsDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        SgSendgoodsResponse sgSendgoodsResponse = this.restTempfacade.execute(sgSendgoodsRequest);
        if (null == sgSendgoodsResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse");
            return "error";
        }
        if (!sgSendgoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse", (Object)sgSendgoodsResponse.getMsg());
            return sgSendgoodsResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        sgSendgoodsLogRequest.init(this.getDdMap(tenantCode, this.ddcode, "SKS"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = this.restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundToEsb(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.ocRefundDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocRefundDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String POSEX = this.getUrl(ocRefundDomain.getTenantCode(), "EsbPOSEX", "EsbPOSEX");
        String KUNNR = this.getUrl(ocRefundDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String MANE1 = this.getUrl(ocRefundDomain.getTenantCode(), "EsbMANE1", "EsbMANE1");
        String LGORT = this.getUrl(ocRefundDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getUrl(ocRefundDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", goods.getRefundGoodsCode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG02");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOrderUrl", "EsbOrderUrl");
        String EsbWarehouseCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        String EsbSourcePlatformCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbSourcePlatformCode", "EsbSourcePlatformCode");
        String EsbLogisticsCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbLogisticsCode", "EsbLogisticsCode");
        String EsbShopNick = this.getUrl(ocContractDomain.getTenantCode(), "EsbShopNick", "EsbShopNick");
        String EsbSenderInfo = this.getUrl(ocContractDomain.getTenantCode(), "EsbSenderInfo", "EsbSenderInfo");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = (Map)JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        String[] split = ocContractDomain.getGoodsReceiptArrdess().split(",");
        if (split.length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainEndToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOderCancelUrl", "EsbOderCancelUrl");
        String EsbWarehouseCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getUrl(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("warehouseCode", EsbWarehouseCode);
        request.put("ownerCode", EsbOwnerCode);
        request.put("orderCode", ocContractDomain.getContractBillcode());
        request.put("orderType", "XSDD");
        request.put("cancelType", "out");
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyMMdd");
        return df.format(new Date());
    }

    @Override
    public String sendContractDomainConfirmToEsb(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsToEsb.sgSendgoodsDomain");
            return "error";
        }
        String esbKey = this.getUrl(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getUrl(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getUrl(ocContractDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String POSEX = this.getUrl(ocContractDomain.getTenantCode(), "EsbPOSEX", "EsbPOSEX");
        String KUNNR = this.getUrl(ocContractDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String MANE1 = this.getUrl(ocContractDomain.getTenantCode(), "EsbMANE1", "EsbMANE1");
        String LGORT = this.getUrl(ocContractDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getUrl(ocContractDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", goods.getContractGoodsCode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void main1(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/SAP/ZR_SEND_ORDER_TO_SAP_C/1.0.0";
        String POSEX = "1";
        String KUNNR = "105911";
        String MANE1 = "\u7f8e\u5c45\u5e97";
        String LGORT = "9100";
        String WERKS = "1101";
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setGoodsReceiptArrdess("\u9655\u897f,\u5b9d\u9e21\u5e02,\u9648\u4ed3\u533a,\u78fb\u6eaa\u9547,\u6d4b\u8bd5");
        ocContractDomain.setGoodsReceiptMem("\u6d4b\u8bd5\u7528\u6237");
        ocContractDomain.setGoodsReceiptPhone("15515425755");
        ocContractDomain.setContractBillcode("DS2022081515040000003");
        ArrayList<OcContractGoodsDomain> goodsDomains = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setSkuNo("1100012026");
        ocContractGoodsDomain.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain);
        OcContractGoodsDomain ocContractGoodsDomain2 = new OcContractGoodsDomain();
        ocContractGoodsDomain2.setSkuNo("1100020379");
        ocContractGoodsDomain2.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain2.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain2.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain2);
        ocContractDomain.setGoodsList(goodsDomains);
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("MANE1", MANE1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        System.out.println(JsonUtil.buildNormalBinder().toJson(map));
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        SapContractResponse execute = invoicefacade.execute(ocEsbContractRequest);
        if (null == execute) {
            System.out.println("null");
        }
        if (!execute.getSuccess().booleanValue()) {
            System.out.println("error");
        }
        System.out.println(execute.getDataObj());
    }

    @Override
    public String sendSaveBusOrderQianjinding(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("status", "-1");
        returnMap.put("message", "\u652f\u4ed8\u5931\u8d25");
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.ocContractDomain", (Object)"isnull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".getUserAccInfo\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "qianjinding");
        LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
        mapStr.put("synType", "order");
        mapStr.put("userCode", ocContractDomain.getUserName());
        mapStr.put("productCode", ocContractDomain.getFchannelCode());
        mapStr.put("merchantBizCode", ocContractDomain.getCompanyCode().substring(0, 2) + "00");
        mapStr.put("qjdOrderCode", "");
        mapStr.put("orderCode", ocContractDomain.getContractBillcode());
        mapStr.put("totalAmount", ocContractDomain.getDataBmoney());
        mapStr.put("ip", null);
        map.put("qianjindingInfo", mapStr);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjindingurl" + url, map);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjindingurl" + url, map);
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.returnResultsMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.returnResultsMap", (Object)data);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            if (MapUtil.isNotEmpty((Map)dataMap)) {
                List list = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(dataMap.get("datas")), Map.class);
                if (ListUtil.isNotEmpty((Collection)list)) {
                    return JsonUtil.buildNormalBinder().toJson(list.get(0));
                }
                logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.dataMap.list" + url, map);
                logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.dataMap.list", (Object)data);
                return JsonUtil.buildNormalBinder().toJson(returnMap);
            }
            logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.dataMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.dataMap", (Object)data);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.code" + url, map);
        logger.error(this.SYS_CODE + ".sendSaveBusOrderQianjinding.code", (Object)data);
        return JsonUtil.buildNormalBinder().toJson(returnMap);
    }

    @Override
    public String sendSaveBusOrderPayment(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("code", "-1");
        returnMap.put("message", "\u652f\u4ed8\u5931\u8d25");
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)"isnull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        if (StringUtils.isBlank((String)ocContractDomain.getFaccountName())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain.getFaccountName", (Object)"isnull");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "orderPay");
        LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
        mapStr.put("order_id", ocContractDomain.getContractBillcode());
        List payCommitList = (List)JsonUtil.buildNormalBinder().getJsonToList(ocContractDomain.getFaccountName(), PayCommit.class);
        if (ListUtil.isEmpty((Collection)payCommitList)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment\uff0cpayCommitList", (Object)"payCommitList");
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        for (PayCommit payCommit : payCommitList) {
            if ("VD".equals(payCommit.getFchannelCode())) {
                mapStr.put("usecash", payCommit.getOrderAmount());
            }
            if ("FL".equals(payCommit.getFchannelCode())) {
                mapStr.put("userebate", payCommit.getOrderAmount());
            }
            if (!"CRP".equals(payCommit.getFchannelCode())) continue;
            mapStr.put("usecredit", payCommit.getOrderAmount());
        }
        mapStr.put("humresid", ocContractDomain.getUserCode());
        if ("029".equals(ocContractDomain.getAppmanageIcode())) {
            mapStr.put("paysource", "8a8ace588ba277c2018ba3a6a1af11fa");
        }
        if ("027".equals(ocContractDomain.getAppmanageIcode())) {
            mapStr.put("paysource", "8a8ace588ba277c2018ba3a6a1af11fc");
        }
        if ("024".equals(ocContractDomain.getAppmanageIcode())) {
            mapStr.put("paysource", "8a8ace588ba277c2018ba3a6a1af11fb");
        }
        if ("028".equals(ocContractDomain.getAppmanageIcode())) {
            mapStr.put("paysource", "8a8ace588ba277c2018ba3a6a1af11fd");
        }
        map.put("orderPayInfo", mapStr);
        Long startTime = System.currentTimeMillis();
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl" + url, map);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.data" + data + "startTimestartTime" + (System.currentTimeMillis() - startTime), map);
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.returnResultsMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.returnResultsMap", (Object)data);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            if (MapUtil.isNotEmpty((Map)dataMap)) {
                return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
            }
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.dataMap" + url, map);
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.dataMap", (Object)data);
            return JsonUtil.buildNormalBinder().toJson(returnMap);
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPaymenturl.code" + url, map);
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.code", (Object)data);
        return JsonUtil.buildNormalBinder().toJson(returnMap);
    }

    public static String getAccessToken() {
        System.out.println("\u5f00\u59cb\u6267\u884c\u83b7\u53d6 accessToken \u6d41\u7a0b...");
        String code = BusOrderServiceImpl.getAuthorizationCode();
        if (code == null || code.isEmpty()) {
            System.out.println("\u83b7\u53d6\u6388\u6743\u7801 code \u5931\u8d25\uff0c\u65e0\u6cd5\u7ee7\u7eed\u83b7\u53d6 accessToken\u3002");
            return null;
        }
        String accessToken = BusOrderServiceImpl.exchangeCodeForAccessToken(code);
        if (accessToken != null) {
            System.out.println("\u2705 \u6210\u529f\u83b7\u53d6 accessToken\uff0c\u957f\u5ea6\u4e3a: " + accessToken.length());
        } else {
            System.out.println("\u274c \u901a\u8fc7\u6388\u6743\u7801 code \u6362\u53d6 accessToken \u5931\u8d25\u3002");
        }
        return accessToken;
    }

    private static String getAuthorizationCode() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("corpid", CORP_ID);
        params.put("response_type", "code");
        params.put("state", "");
        try {
            String response = OKHttpClientUtil.sendPost(AUTHORIZE_URL, JsonUtil.buildNormalBinder().toJson(params));
            System.out.println("\u8c03\u7528 authorize \u63a5\u53e3\u54cd\u5e94: " + response);
            if (response == null || response.isEmpty()) {
                System.out.println("\u8c03\u7528 authorize \u63a5\u53e3\u8fd4\u56de\u7a7a\u54cd\u5e94\u3002");
                return null;
            }
            Map respMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, Object.class);
            Object errcodeObj = respMap.get("errcode");
            if (errcodeObj == null) {
                System.out.println("\u54cd\u5e94\u4e2d\u7f3a\u5c11 'errcode' \u5b57\u6bb5");
                return null;
            }
            String errcode = errcodeObj.toString();
            if (!"0".equals(errcode)) {
                String errmsg = respMap.getOrDefault("errmsg", "unknown");
                System.out.println("\u274c \u63a5\u53e3\u8c03\u7528\u5931\u8d25: errcode=" + errcode + ", errmsg=" + errmsg);
                return null;
            }
            return (String)respMap.get("code");
        }
        catch (Exception e) {
            System.out.println("\u8c03\u7528 authorize \u63a5\u53e3\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static String exchangeCodeForAccessToken(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", APP_KEY);
        params.put("app_secret", APP_SECRET);
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        try {
            String response = OKHttpClientUtil.sendPost(TOKEN_URL, JsonUtil.buildNormalBinder().toJson(params));
            System.out.println("\u8c03\u7528 access_token \u63a5\u53e3\u54cd\u5e94: " + response);
            if (response == null || response.isEmpty()) {
                System.out.println("\u8c03\u7528 access_token \u63a5\u53e3\u8fd4\u56de\u7a7a\u54cd\u5e94\u3002");
                return null;
            }
            Map respMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, Object.class);
            Object errcodeObj = respMap.get("errcode");
            if (errcodeObj == null) {
                System.out.println("\u54cd\u5e94\u4e2d\u7f3a\u5c11 'errcode' \u5b57\u6bb5");
                return null;
            }
            String errcode = errcodeObj.toString();
            if (!"0".equals(errcode)) {
                String errmsg = respMap.getOrDefault("errmsg", "unknown");
                System.out.println("\u274c \u63a5\u53e3\u8c03\u7528\u5931\u8d25: errcode=" + errcode + ", errmsg=" + errmsg);
                return null;
            }
            return (String)respMap.get("accessToken");
        }
        catch (Exception e) {
            System.out.println("\u8c03\u7528 access_token \u63a5\u53e3\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String syncInternationalOrdersToOA(OcContractReDomain ocContractDomain) {
        String accessToken = BusOrderServiceImpl.getAccessToken();
        if (accessToken != null) {
            logger.info("\u4e3b\u6d41\u7a0b\uff1a\u6210\u529f\u83b7\u53d6 accessToken = " + accessToken);
        } else {
            logger.info("\u4e3b\u6d41\u7a0b\uff1a\u83b7\u53d6 accessToken \u5931\u8d25\u3002");
        }
        return null;
    }

    public static void main(String[] args) {
        String accessToken = BusOrderServiceImpl.getAccessToken();
        if (accessToken != null) {
            System.out.println("\u4e3b\u6d41\u7a0b\uff1a\u6210\u529f\u83b7\u53d6 accessToken = " + accessToken);
        } else {
            System.out.println("\u4e3b\u6d41\u7a0b\uff1a\u83b7\u53d6 accessToken \u5931\u8d25\u3002");
        }
    }

    @Override
    public String sendCreateBusOrder(OcContractReDomain ocContractDomain) {
        BigDecimal goodsAssistweight;
        OcContractPmGoods ocContractPmGoods1;
        List ocContractPmGoodsList;
        List ocContractPmGoods;
        HashMap contractMap;
        Object sum;
        logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ocContractDomain", (Object)"isnull");
            return "error";
        }
        if (ocContractDomain.getContractShow() == 1) {
            String busOrder = this.createBusOrder(ocContractDomain);
            return busOrder;
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        UmUserinfoReDomain userinfoByUserinfoCode = this.getUserinfoByUserinfoCode(ocContractDomain.getMemberBcode(), ocContractDomain.getTenantCode());
        if (null == userinfoByUserinfoCode) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.userinfoByUserinfoCode", (Object)"isnull");
            return "error";
        }
        CtCustrelReDomain ctCustrelReDomain = null;
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("tenantCode", ocContractDomain.getTenantCode());
        newMap.put("userinfoOpcode", ocContractDomain.getMemberBcode());
        newMap.put("userinfoOpcode2", ocContractDomain.getDepartCode());
        newMap.put("custrelFeestatus", "1");
        QueryResult<CtCustrelReDomain> ctCustrelReDomainQueryResult = this.queryCustrelPage(newMap);
        if (ListUtil.isEmpty((Collection)ctCustrelReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ctCustrelReDomainQueryResult", newMap);
            return "error";
        }
        ctCustrelReDomain = (CtCustrelReDomain)ctCustrelReDomainQueryResult.getList().get(0);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("tenantCode", ocContractDomain.getTenantCode());
        map2.put("addressCode", ocContractDomain.getAreaCode());
        QueryResult<UmAddressReDomain> umAddressReDomainQueryResult = this.queryAddressPage(map2);
        if (ListUtil.isEmpty((Collection)umAddressReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.queryAddressPage" + ((Object)map2).toString());
            return "error";
        }
        UmAddressReDomain umAddressReDomain = (UmAddressReDomain)umAddressReDomainQueryResult.getList().get(0);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> orderMainData = new LinkedHashMap<String, Object>();
        map.put("action", "createOrder");
        map.put("createOrderInfo", orderMainData);
        LinkedHashMap<String, Object> createOrderInfo = new LinkedHashMap<String, Object>();
        if ("SKS".equals(ocContractDomain.getContractBlance())) {
            createOrderInfo.put("is_qjd_pay", "8a8acee26eafd905016eafdcd81c0005");
        }
        if ("PF".equals(ocContractDomain.getContractBlance())) {
            createOrderInfo.put("is_qjd_pay", "8a8acee27332ef49017337c524dd6689");
        }
        if ("QJD".equals(ocContractDomain.getContractBlance())) {
            createOrderInfo.put("is_qjd_pay", "8a8acee26eafd905016eafdcd81c0004");
        }
        createOrderInfo.put("order_id", ocContractDomain.getContractBillcode());
        createOrderInfo.put("customerid", ocContractDomain.getMemberBname());
        createOrderInfo.put("receiveridno", ocContractDomain.getGoodsSupplierCode());
        createOrderInfo.put("receivertel", ocContractDomain.getGoodsReceiptPhone());
        createOrderInfo.put("address", ocContractDomain.getAreaCode());
        createOrderInfo.put("lastdatetime", ocContractDomain.getGmtModified());
        if (StringUtils.isNotBlank((String)ocContractDomain.getGoodsReceiptArrdess())) {
            String str = ocContractDomain.getGoodsReceiptArrdess();
            String str1 = str.substring(0, str.indexOf("\u00b7"));
            String str2 = str.substring(str1.length() + 1, str.length());
            createOrderInfo.put("deliveryaddress", str2);
        }
        createOrderInfo.put("despatchmode", ocContractDomain.getContractPumode());
        createOrderInfo.put("despatchmodedesc", null);
        if (StringUtils.isNotBlank((String)ocContractDomain.getContractPumode())) {
            createOrderInfo.put("despatchmodedesc", BusOrderServiceImpl.getMessage(ocContractDomain.getContractPumode()));
        }
        createOrderInfo.put("extraprice1", "0.000");
        createOrderInfo.put("ordertotal", ocContractDomain.getDataBmoney());
        createOrderInfo.put("ordertype", "ZBSO");
        createOrderInfo.put("ordertypedesc", "\u6807\u51c6\u8ba2\u5355");
        createOrderInfo.put("wlzc", null);
        createOrderInfo.put("CREATEDATETIME", ocContractDomain.getGmtCreate());
        createOrderInfo.put("dayusettleaccount", "0.000");
        createOrderInfo.put("wbsid", ocContractDomain.getPricesetCurrency1());
        createOrderInfo.put("useunload", "false");
        createOrderInfo.put("unloadprice", "0.000");
        createOrderInfo.put("addhtmsg", ocContractDomain.getContractEcurl());
        createOrderInfo.put("extraprice2", ocContractDomain.getGoodsAssistweight());
        createOrderInfo.put("ismjj", ocContractDomain.getDdTypeCurrency());
        BigDecimal wweight = BigDecimal.ZERO;
        BigDecimal oweight = BigDecimal.ZERO;
        BigDecimal otherweight = BigDecimal.ZERO;
        BigDecimal totalweight = BigDecimal.ZERO;
        BigDecimal nwtotal = BigDecimal.ZERO;
        BigDecimal nozptwtotlaw = BigDecimal.ZERO;
        BigDecimal ytbnwtotal = BigDecimal.ZERO;
        BigDecimal dayusettleaccount = BigDecimal.ZERO;
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        ArrayList<String> skujfcNoList = new ArrayList<String>();
        UmUser UmUser2 = null;
        if ("8a8ace589467911101946c9c47da528c".equals(ocContractDomain.getContractTypepro())) {
            HashMap userMap = new HashMap();
            userMap.put("tenantCode", ocContractDomain.getTenantCode());
            userMap.put("userPcode", ocContractDomain.getEmployeeCode());
            QueryResult<UmUser> umUserQueryResult = this.queryUserPage(userMap);
            if (ListUtil.isEmpty((Collection)umUserQueryResult.getList())) {
                logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.umUserQueryResult", (Object)userMap);
                return "error";
            }
            UmUser2 = (UmUser)umUserQueryResult.getList().get(0);
            if (StringUtils.isBlank((String)ctCustrelReDomain.getUserinfoChannelcode())) {
                logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.getUserinfoChannelcode");
                return "error";
            }
            HashMap<String, Object> newMapStr = new HashMap<String, Object>();
            newMapStr.put("tenantCode", ocContractDomain.getTenantCode());
            newMapStr.put("custrelUicode", ctCustrelReDomain.getUserinfoChannelcode());
            QueryResult<CtCustrelReDomain> ctCustrelReDomainQueryResult1 = this.queryCustrelPage(newMapStr);
            if (ListUtil.isEmpty((Collection)ctCustrelReDomainQueryResult1.getList())) {
                logger.error(this.SYS_CODE + ".sendSaveBusOrderPayment.ctCustrelReDomainQueryResult1", newMapStr);
                return "error";
            }
            ctCustrelReDomain = (CtCustrelReDomain)ctCustrelReDomainQueryResult1.getList().get(0);
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (null == ocContractGoodsDomain.getPricesetNprice1()) {
                ocContractGoodsDomain.setPricesetNprice1(BigDecimal.ZERO);
            }
            dayusettleaccount = dayusettleaccount.add(ocContractGoodsDomain.getPricesetNprice1().multiply(ocContractGoodsDomain.getGoodsCamount()));
            if (null != ocContractGoodsDomain.getGoodsWeight() && ocContractGoodsDomain.getGoodsWeight().compareTo(BigDecimal.ZERO) > 0) {
                ocContractGoodsDomain.setGoodsWeight(ocContractGoodsDomain.getGoodsWeight().divide(new BigDecimal("1000")));
            }
            if (null != ocContractGoodsDomain.getGoodsOneweight() && ocContractGoodsDomain.getGoodsOneweight().compareTo(BigDecimal.ZERO) > 0) {
                ocContractGoodsDomain.setGoodsOneweight(ocContractGoodsDomain.getGoodsOneweight().divide(new BigDecimal("1000")));
            }
            if ("1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                ocContractGoodsDomain.setContractGoodsPrice(ocContractGoodsDomain.getPricesetNprice());
                skujfcNoList.add(ocContractGoodsDomain.getSkuNo());
            }
            if ("8a8ad0a039e82acc0139fc4d34a61172".equals(ocContractGoodsDomain.getGoodsSpec3())) {
                wweight = wweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            if ("8a8ad0a039e82acc0139fc4d34a61173".equals(ocContractGoodsDomain.getGoodsSpec3())) {
                oweight = oweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            if (!"8a8ad0a039e82acc0139fc4d34a61173".equals(ocContractGoodsDomain.getGoodsSpec3()) && !"8a8ad0a039e82acc0139fc4d34a61172".equals(ocContractGoodsDomain.getGoodsSpec3())) {
                otherweight = otherweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            totalweight = totalweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            nwtotal = nwtotal.add(ocContractGoodsDomain.getGoodsWeight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            if ("8a8ad0a03a691636013a692c7aac0071".equals(ocContractGoodsDomain.getMschannelCode())) {
                nozptwtotlaw = nozptwtotlaw.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            if (!StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsPro()) || !"3".equals(ocContractGoodsDomain.getGoodsPro())) continue;
            ytbnwtotal = ytbnwtotal.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
        }
        createOrderInfo.put("dayusettleaccount", dayusettleaccount);
        createOrderInfo.put("wweight", wweight);
        createOrderInfo.put("oweight", oweight);
        createOrderInfo.put("otherweight", otherweight);
        createOrderInfo.put("totalweight", totalweight);
        createOrderInfo.put("nwtotal", nwtotal);
        createOrderInfo.put("nozptwtotlaw", nozptwtotlaw);
        createOrderInfo.put("ytbnwtotal", ytbnwtotal);
        createOrderInfo.put("bchcode", ocContractDomain.getContractNbbillcode());
        createOrderInfo.put("ismgdct", ocContractDomain.getDataStatestr());
        createOrderInfo.put("sigaddamt", ocContractDomain.getContractPaymoney());
        createOrderInfo.put("gccpjjcs", ocContractDomain.getContractInvoice());
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        if (null != ocContractDomain.getGoodsLogmoney()) {
            goodsLogmoney = ocContractDomain.getGoodsLogmoney();
        }
        BigDecimal goodsPmoney = BigDecimal.ZERO;
        if (null != ocContractDomain.getGoodsPmoney()) {
            goodsPmoney = BigDecimal.ZERO;
        }
        createOrderInfo.put("hjsl", ocContractDomain.getGoodsSupplierName());
        createOrderInfo.put("remark", ocContractDomain.getContractRemark());
        createOrderInfo.put("productamount", ocContractDomain.getContractInmoney());
        createOrderInfo.put("discountstotal", goodsPmoney.add(goodsLogmoney));
        createOrderInfo.put("orderadd", BigDecimal.ZERO.add(goodsLogmoney));
        createOrderInfo.put("amountpayable", ocContractDomain.getDataBmoney());
        createOrderInfo.put("saledeptid", ctCustrelReDomain.getUserinfoOpcode2());
        createOrderInfo.put("receiver", ocContractDomain.getGoodsReceiptMem());
        createOrderInfo.put("saledeptname", ctCustrelReDomain.getDepartName());
        createOrderInfo.put("customername", userinfoByUserinfoCode.getUserinfoOcode());
        createOrderInfo.put("sapcustomercode", userinfoByUserinfoCode.getUserinfoCertNo());
        if (!ocContractDomain.getMemberBcode().equals(ocContractDomain.getEmployeeCode())) {
            createOrderInfo.put("sapcustomercode", ocContractDomain.getMemberMcode());
        }
        if ("8a8ace589467911101946c9c47da528c".equals(ocContractDomain.getContractTypepro())) {
            createOrderInfo.put("sapcustomercode", UmUser2.getUserName());
        }
        createOrderInfo.put("address_id", ocContractDomain.getAreaCode());
        createOrderInfo.put("customerno", umAddressReDomain.getRoadCode());
        createOrderInfo.put("sold", ocContractDomain.getEmployeeCode());
        createOrderInfo.put("areausers", ocContractDomain.getEmployeeName());
        createOrderInfo.put("province", umAddressReDomain.getProvinceCode());
        createOrderInfo.put("city", umAddressReDomain.getAreaCode());
        createOrderInfo.put("citytype", umAddressReDomain.getCityCode());
        createOrderInfo.put("project", ocContractDomain.getMemberGname());
        createOrderInfo.put("contractid", ocContractDomain.getMemberGcode());
        createOrderInfo.put("profitcenter", ocContractDomain.getCompanyShortname());
        createOrderInfo.put("salesarea", ocContractDomain.getCompanyShortname());
        createOrderInfo.put("saledisname", ctCustrelReDomain.getUserinfoDischannelname());
        createOrderInfo.put("saledis", ctCustrelReDomain.getUserinfoDischannelcode());
        createOrderInfo.put("orgname", ctCustrelReDomain.getQualityQtypeName());
        createOrderInfo.put("profitname", ocContractDomain.getMemberCcode());
        createOrderInfo.put("saleorg", ocContractDomain.getCompanyCode());
        createOrderInfo.put("productgroup", ctCustrelReDomain.getCustrelFax());
        createOrderInfo.put("productname", ctCustrelReDomain.getCustrelTaun());
        createOrderInfo.put("zterm", ctCustrelReDomain.getUserinfoSort());
        createOrderInfo.put("deliverycompany", "1700");
        createOrderInfo.put("ifvirtual", false);
        if ("1".equals(ocContractDomain.getContractProperty())) {
            createOrderInfo.put("ifvirtual", true);
        }
        createOrderInfo.put("guaranteedstock", false);
        if ("1".equals(ocContractDomain.getContractPmode())) {
            createOrderInfo.put("guaranteedstock", true);
        }
        createOrderInfo.put("dsfjc", ocContractDomain.getMschannelCode());
        createOrderInfo.put("cxjdw", null);
        createOrderInfo.put("elequality", false);
        if ("1".equals(ocContractDomain.getMschannelName())) {
            createOrderInfo.put("elequality", true);
        }
        createOrderInfo.put("randomstring", (int)(Math.random() * 9000.0 + 1000.0));
        createOrderInfo.put("timestamp", ocContractDomain.getGmtCreate().getTime());
        createOrderInfo.put("humresid", userinfoByUserinfoCode.getMemberMcode());
        createOrderInfo.put("isnewbh", "8a8ad0a03d4809f1013d4d96e5fb0a30");
        if ("029".equals(ocContractDomain.getAppmanageIcode())) {
            createOrderInfo.put("createsource", "8a8ace588ba277c2018ba3a6a1af11fa");
        }
        if ("027".equals(ocContractDomain.getAppmanageIcode())) {
            createOrderInfo.put("createsource", "8a8ace588ba277c2018ba3a6a1af11fc");
        }
        if ("024".equals(ocContractDomain.getAppmanageIcode())) {
            createOrderInfo.put("createsource", "8a8ace588ba277c2018ba3a6a1af11fb");
        }
        if ("028".equals(ocContractDomain.getAppmanageIcode())) {
            createOrderInfo.put("createsource", "8a8ace588ba277c2018ba3a6a1af11fd");
        }
        if (StringUtils.isNotBlank((String)ocContractDomain.getChannelName())) {
            String string1 = ocContractDomain.getChannelName().replace("\u300a", "<");
            createOrderInfo.put("notpromotiondesc", string1.replace("\u300b", ">"));
        } else {
            createOrderInfo.put("notpromotiondesc", ocContractDomain.getChannelName());
        }
        createOrderInfo.put("comaddmsg", ocContractDomain.getContractObillcode());
        createOrderInfo.put("isytbdd", "0");
        if (null != ocContractDomain.getContractValidate()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String formattedDate = sdf.format(ocContractDomain.getContractValidate());
            createOrderInfo.put("expecttime", formattedDate);
        } else {
            createOrderInfo.put("expecttime", null);
        }
        if ("002".equals(ocContractDomain.getContractNbillcode())) {
            createOrderInfo.put("isytbdd", "1");
        }
        if ("8a8ace589467911101946c9c47da528c".equals(ocContractDomain.getContractTypepro())) {
            createOrderInfo.put("isfxorder", "8a8ace589467911101946c9c47da528c");
            if (null != ocContractDomain.getRefundFlag()) {
                if (Integer.valueOf(1).equals(ocContractDomain.getRefundFlag())) {
                    createOrderInfo.put("iscustomersend", "8a8ad0a03d4809f1013d4d96e5fb0a30");
                }
                if (Integer.valueOf(0).equals(ocContractDomain.getRefundFlag())) {
                    createOrderInfo.put("iscustomersend", "8a8ad0a03d4809f1013d4d96e5fb0a31");
                }
            }
        } else {
            createOrderInfo.put("isfxorder", "8a8ace589467911101946c9c47da528b");
        }
        orderMainData.put("orderMainData", createOrderInfo);
        ArrayList orderSubData = new ArrayList();
        ArrayList orderDescData = new ArrayList();
        HashMap<String, RsClasstreeDomain> rsClasstreeMap = new HashMap<String, RsClasstreeDomain>();
        HashMap<String, OcContractGoodsDomain> contractGoodsDomainMap = new HashMap<String, OcContractGoodsDomain>();
        ArrayList ocContractPmGoodsDomainList = new ArrayList();
        HashMap<String, Object> mapStrs = new HashMap<String, Object>();
        mapStrs.put("tenantCode", ocContractDomain.getTenantCode());
        mapStrs.put("contractBillcode", ocContractDomain.getContractBillcode());
        QueryResult<OcContractPmGoods> ocContractPmGoodsQueryResult = this.queryContractPmGoodsPage(mapStrs);
        if (ListUtil.isNotEmpty((Collection)ocContractPmGoodsQueryResult.getList())) {
            ocContractPmGoodsDomainList.addAll(ocContractPmGoodsQueryResult.getList());
        }
        HashMap<String, String> wuliaoMap = new HashMap<String, String>();
        if (ListUtil.isNotEmpty(ocContractPmGoodsDomainList)) {
            for (OcContractPmGoods ocContractPmGoodsDomain : ocContractPmGoodsDomainList) {
                if (!"0007".equals(ocContractPmGoodsDomain.getGoodsType())) continue;
                wuliaoMap.put(ocContractPmGoodsDomain.getSkuNo(), ocContractPmGoodsDomain.getSkuNo());
            }
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            String[] skuCode1;
            String skuCode;
            String atn;
            String colorname;
            LinkedHashMap<String, String> mapStr;
            List strings;
            String[] split;
            if (!"1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                contractGoodsDomainMap.put(ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
            }
            this.makeOcContractGoodsDomain(ocContractGoodsDomain, rsClasstreeMap);
            LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
            map1.put("order_id", ocContractGoodsDomain.getContractBillcode());
            map1.put("xcpzl", ocContractGoodsDomain.getClasstreeShopname());
            map1.put("xcpxlei", ocContractGoodsDomain.getClasstreeCode());
            map1.put("xcpdl", ocContractGoodsDomain.getClasstreeShopcode());
            map1.put("xcpxl", null);
            map1.put("suppno", ocContractGoodsDomain.getGoodsProperty4());
            map1.put("orgunit", ocContractGoodsDomain.getMschannelName());
            if (null == ocContractGoodsDomain.getPricesetNprice()) {
                ocContractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsPrice()) {
                ocContractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain.getPricesetNprice().compareTo(BigDecimal.ZERO) == 0) {
                map1.put("discountrate", "0");
            } else {
                map1.put("discountrate", ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsPrice()).divide(ocContractGoodsDomain.getPricesetNprice(), RoundingMode.HALF_UP));
            }
            map1.put("cxproductid", ocContractGoodsDomain.getSkuBarcode());
            if (null == ocContractGoodsDomain.getGoodsWeight()) {
                ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsOneweight()) {
                ocContractGoodsDomain.setGoodsOneweight(BigDecimal.ZERO);
            }
            map1.put("nwtotal", ocContractGoodsDomain.getGoodsWeight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            map1.put("bomtype", ocContractGoodsDomain.getMschannelCode());
            map1.put("gwtotal", ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            if ("8a8ad0a03a691636013a692c7aac0071".equals(ocContractGoodsDomain.getMschannelCode())) {
                map1.put("iszptw", "1");
            } else {
                map1.put("iszptw", "0");
            }
            map1.put("bomgroupid", ocContractGoodsDomain.getGinfoCode());
            map1.put("productlevel", ocContractGoodsDomain.getGoodsSpec5());
            map1.put("islow", "0");
            if ("8a8acee27f87ca4f017f969a9a9969a2".equals(ocContractGoodsDomain.getPricesetCurrency())) {
                map1.put("islow", "1");
            }
            map1.put("stockcode", ocContractGoodsDomain.getGoodsNo());
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
                ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            Map map3 = this.makeMap(ocContractGoodsDomain.getGoodsRemark());
            map1.put("discountamount", ocContractGoodsDomain.getContractGoodsInmoney().subtract(ocContractGoodsDomain.getContractGoodsMoney()).negate().toPlainString());
            if ("1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                map1.put("discountamount", "0");
            }
            map1.put("itemdescribe", ocContractGoodsDomain.getGoodsName());
            map1.put("appclass", ocContractGoodsDomain.getChannelName());
            map1.put("nw", ocContractGoodsDomain.getGoodsWeight());
            map1.put("quantity", ocContractGoodsDomain.getGoodsCamount());
            map1.put("cancelcount", ocContractGoodsDomain.getGoodsCamount());
            Object sksRespriceColorprice = null;
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuName()) && null != (split = ocContractGoodsDomain.getSkuName().split("\\+")) && split.length >= 2) {
                sksRespriceColorprice = ocContractGoodsDomain.getSkuName().substring(ocContractGoodsDomain.getSkuName().indexOf("+") + 1);
            }
            if (StringUtils.isBlank(sksRespriceColorprice)) {
                sksRespriceColorprice = this.getSksRespriceColorprice(ocContractGoodsDomain.getSkuShowno(), ocContractGoodsDomain.getTenantCode());
            }
            map1.put("colorid", ocContractGoodsDomain.getSkuShowno());
            map1.put("productclass", map3.get("GROUPNAME"));
            String skuName = ocContractGoodsDomain.getSkuName();
            String[] skuName1 = skuName.split("\\+");
            map1.put("pack", skuName1[0]);
            map1.put("price", ocContractGoodsDomain.getPricesetNprice());
            map1.put("subtotal", ocContractGoodsDomain.getContractGoodsInmoney().toPlainString());
            String[] split2 = ocContractGoodsDomain.getGoodsName().split("\\+");
            map1.put("productname", null);
            if (split2.length > 2) {
                map1.put("productname", split2[1]);
            } else if (split2.length > 1 && split2.length < 3) {
                map1.put("productname", split2[0]);
            }
            map1.put("settleaccount", ocContractGoodsDomain.getContractGoodsMoney());
            map1.put("remark", null);
            if ("1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                map1.put("remark", "\u8d60\u54c1");
                map1.put("settleaccount", ocContractGoodsDomain.getPricesetNprice().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            if (wuliaoMap.containsKey(ocContractGoodsDomain.getSkuNo())) {
                map1.put("remark", "\u7269\u6599\u4fc3\u9500-\u7269\u6599");
            }
            map1.put("pch", ocContractGoodsDomain.getGoodsContract());
            map1.put("iszp", "0");
            if ("1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                map1.put("iszp", "1");
            }
            map1.put("speciality", ocContractGoodsDomain.getGoodsSpec3());
            map1.put("minquantity", "0");
            map1.put("currency", "CNY");
            map1.put("brand", ocContractGoodsDomain.getBrandName());
            map1.put("gw", ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            map1.put("colorname", sksRespriceColorprice);
            map1.put("productid", ocContractGoodsDomain.getSkuEocode());
            map1.put("discountprice", ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsPrice()).negate().toPlainString());
            map1.put("itemnumber", ocContractGoodsDomain.getSkuNo());
            map1.put("settleprice", ocContractGoodsDomain.getContractGoodsPrice());
            map1.put("unit", ocContractGoodsDomain.getGoodsSpec4());
            map1.put("dayusettleaccount", ocContractGoodsDomain.getPricesetNprice1());
            map1.put("unloadprice", "0.000");
            map1.put("bomdescalias", null);
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsOrigin()) && ocContractGoodsDomain.getGoodsOrigin().contains("11")) {
                map1.put("bomdescalias", ocContractGoodsDomain.getGoodsMaterial());
            }
            map1.put("exfactoryprice", ocContractGoodsDomain.getContractGoodsRemoney());
            map1.put("zbcbhd", null);
            map1.put("zjjys", null);
            map1.put("zbwhd", null);
            map1.put("zbwcz", null);
            map1.put("zmbhd", null);
            map1.put("zmbcm", null);
            map1.put("zsmxg", null);
            map1.put("bt", null);
            if ("2".equals(ocContractGoodsDomain.getContractGoodsGtype()) && StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuOldcode()) && ListUtil.isNotEmpty((Collection)(strings = (List)JsonUtil.buildNormalBinder().getJsonToList(ocContractGoodsDomain.getSkuOldcode(), String.class)))) {
                map1.put("tpmianprod", strings.get(0));
                map1.put("remark", (String)strings.get(0) + "\u914d\u5957\u6258\u76d8");
            }
            if ("3".equals(ocContractGoodsDomain.getGoodsPro())) {
                String skuCode2 = ocContractGoodsDomain.getSkuCode();
                String[] skuCode12 = skuCode2.split("_");
                if (null != skuCode12 && skuCode12.length == 4) {
                    map1.put("colorname", skuCode12[3]);
                }
                map1.put("itemnumber", ocContractGoodsDomain.getSkuNo().split("_")[0]);
                String mainStr = ocContractGoodsDomain.getSkuNo();
                String[] str = mainStr.split("_");
                String str1 = str[1];
                String subStr1 = "YTB";
                boolean result = ocContractGoodsDomain.getGoodsNo().contains(subStr1);
                if (result) {
                    char boardw = str1.charAt(0);
                    char panelw = str1.charAt(1);
                    char layersw = str1.charAt(4);
                    char layerdensityw = str1.charAt(8);
                    char a1 = str1.charAt(2);
                    char b = str1.charAt(3);
                    char c = str1.charAt(5);
                    char d = str1.charAt(6);
                    char f = str1.charAt(7);
                    map1.put("zbcbhd", null);
                    map1.put("zjjys", null);
                    map1.put("zbwmd", Character.valueOf(layerdensityw));
                    map1.put("zbwhd", String.valueOf(c) + String.valueOf(d) + String.valueOf(f));
                    map1.put("zbwcz", Character.valueOf(layersw));
                    map1.put("zmbhd", String.valueOf(a1) + String.valueOf(b));
                    map1.put("zmbcm", Character.valueOf(panelw));
                    map1.put("zsmxg", Character.valueOf(boardw));
                    map1.put("bt", null);
                }
                String subStr2 = "DB";
                boolean result1 = ocContractGoodsDomain.getGoodsNo().contains(subStr2);
                if (result1) {
                    char boardw = str1.charAt(0);
                    char panelw = str1.charAt(1);
                    char layersw = str1.charAt(4);
                    char a1 = str1.charAt(2);
                    char b = str1.charAt(3);
                    map1.put("zbcbhd", null);
                    map1.put("zjjys", null);
                    map1.put("zbwmd", null);
                    map1.put("zbwhd", null);
                    map1.put("zbwcz", null);
                    map1.put("zmbhd", String.valueOf(a1) + String.valueOf(b));
                    map1.put("zmbcm", Character.valueOf(panelw));
                    map1.put("zsmxg", Character.valueOf(boardw));
                    map1.put("bt", Character.valueOf(layersw));
                }
            }
            orderSubData.add(map1);
            if ("10".equals(ocContractGoodsDomain.getGoodsOrigin())) {
                mapStr = new LinkedHashMap<String, String>();
                if ("3".equals(ocContractGoodsDomain.getGoodsPro())) {
                    colorname = null;
                    atn = null;
                    skuCode = ocContractGoodsDomain.getSkuCode();
                    skuCode1 = skuCode.split("_");
                    if (null != skuCode1 && skuCode1.length == 4) {
                        colorname = skuCode1[3];
                        atn = skuCode1[2];
                    }
                    mapStr.put("promotionid", "");
                    mapStr.put("promotiontag", "\u5de5\u7a0b\u7279\u4ef7");
                    mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo().split("_")[0] + "(" + ocContractGoodsDomain.getGoodsName() + "_" + atn + "_" + colorname + ")\u4eab\u53d7\u5de5\u7a0b\u7279\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143");
                    BigDecimal sum2 = ocContractGoodsDomain.getContractGoodsPrice().subtract(ocContractGoodsDomain.getPricesetNprice()).multiply(ocContractGoodsDomain.getGoodsCamount()).setScale(2, 4);
                    mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractGoodsDomain.getGoodsCamount() + "\u4ef6\u4ea7\u54c1,\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + sum2 + "\u5143");
                    orderDescData.add(mapStr);
                } else {
                    mapStr.put("promotionid", "");
                    mapStr.put("promotiontag", "\u5de5\u7a0b\u7279\u4ef7");
                    mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo() + "(" + ocContractGoodsDomain.getGoodsName() + ")\u4eab\u53d7\u5de5\u7a0b\u7279\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143");
                    BigDecimal sum3 = ocContractGoodsDomain.getContractGoodsPrice().subtract(ocContractGoodsDomain.getPricesetNprice()).multiply(ocContractGoodsDomain.getGoodsCamount()).setScale(2, 4);
                    mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractGoodsDomain.getGoodsCamount() + "\u4ef6\u4ea7\u54c1,\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + sum3 + "\u5143");
                    orderDescData.add(mapStr);
                }
            }
            if (!StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsOrigin()) || !ocContractGoodsDomain.getGoodsOrigin().contains("11")) continue;
            mapStr = new LinkedHashMap();
            if ("3".equals(ocContractGoodsDomain.getGoodsPro())) {
                colorname = null;
                atn = null;
                skuCode = ocContractGoodsDomain.getSkuCode();
                skuCode1 = skuCode.split("_");
                if (null != skuCode1 && skuCode1.length == 4) {
                    colorname = skuCode1[3];
                    atn = skuCode1[2];
                }
                mapStr.put("promotionid", "");
                mapStr.put("promotiontag", "\u5408\u540c\u4ef7\u7279\u4ef7");
                mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo().split("_")[0] + "(" + ocContractGoodsDomain.getGoodsName() + "_" + atn + "_" + colorname + ")\u4eab\u53d7\u5927\u79b9\u5408\u540c\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143");
                String str = null;
                if (null != ocContractGoodsDomain.getPricesetInsideprice() && ocContractGoodsDomain.getPricesetInsideprice().compareTo(BigDecimal.ZERO) > 0) {
                    str = "(\u4eab\u53d7\u9879\u76ee\u7279\u4ef7" + ocContractGoodsDomain.getPricesetInsideprice() + "\u5143)";
                    mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo().split("_")[0] + "(" + ocContractGoodsDomain.getGoodsName() + "_" + atn + "_" + colorname + ")\u4eab\u53d7\u5927\u79b9\u5408\u540c\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143" + str);
                }
                BigDecimal sum4 = ocContractGoodsDomain.getContractGoodsPrice().subtract(ocContractGoodsDomain.getPricesetNprice()).multiply(ocContractGoodsDomain.getGoodsCamount()).setScale(2, 4);
                mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractGoodsDomain.getGoodsCamount() + "\u4ef6\u4ea7\u54c1,\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + sum4 + "\u5143");
                orderDescData.add(mapStr);
                continue;
            }
            mapStr.put("promotionid", "");
            mapStr.put("promotiontag", "\u5408\u540c\u4ef7\u7279\u4ef7");
            mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo() + "(" + ocContractGoodsDomain.getGoodsName() + ")\u4eab\u53d7\u5927\u79b9\u5408\u540c\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143");
            String str = null;
            if (null != ocContractGoodsDomain.getPricesetInsideprice() && ocContractGoodsDomain.getPricesetInsideprice().compareTo(BigDecimal.ZERO) > 0) {
                str = "(\u4eab\u53d7\u9879\u76ee\u7279\u4ef7" + ocContractGoodsDomain.getPricesetInsideprice() + "\u5143)";
                mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo() + "(" + ocContractGoodsDomain.getGoodsName() + ")\u4eab\u53d7\u5927\u79b9\u5408\u540c\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143" + str);
            }
            sum = ocContractGoodsDomain.getContractGoodsPrice().subtract(ocContractGoodsDomain.getPricesetNprice()).multiply(ocContractGoodsDomain.getGoodsCamount()).setScale(2, 4);
            mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractGoodsDomain.getGoodsCamount() + "\u4ef6\u4ea7\u54c1,\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + sum + "\u5143");
            orderDescData.add(mapStr);
        }
        ConcurrentHashMap ddListMap = new ConcurrentHashMap();
        ConcurrentHashMap ddListMapStr = new ConcurrentHashMap();
        ArrayList<HashMap> orderPromotionData = new ArrayList<HashMap>();
        if (ListUtil.isNotEmpty(ocContractPmGoodsDomainList)) {
            for (OcContractPmGoods ocContractPmGoodsDomain : ocContractPmGoodsDomainList) {
                List<OcContractPmGoods> mlist;
                LinkedHashMap<String, String> mapStr;
                if ("0006".equals(ocContractPmGoodsDomain.getGoodsType())) {
                    mapStr = new LinkedHashMap<String, String>();
                    mapStr.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    mapStr.put("promotiontag", ocContractPmGoodsDomain.getGoodsClass());
                    mapStr.put("promotionrule", ocContractPmGoodsDomain.getContractSettlOpno() + ocContractPmGoodsDomain.getGoodsClass() + ":" + ocContractPmGoodsDomain.getContractSettlOpemo());
                    mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractPmGoodsDomain.getGoodsCamount() + "\u4ef6" + ocContractPmGoodsDomain.getSkuNo() + "(" + ocContractPmGoodsDomain.getGoodsShowname() + ")\uff0c\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + ocContractPmGoodsDomain.getContractPmgoodsPmoney() + "\u5143");
                    orderDescData.add(mapStr);
                    HashMap contractMap2 = Maps.newHashMap();
                    contractMap2.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    contractMap2.put("promotiondesc", ocContractPmGoodsDomain.getGoodsClass());
                    contractMap2.put("promotiongoods", ocContractPmGoodsDomain.getSkuNo());
                    contractMap2.put("promotiongift", "");
                    contractMap2.put("promotionnumrate", ocContractPmGoodsDomain.getContractPmgoodsRepmoney());
                    contractMap2.put("promotionprice", ocContractPmGoodsDomain.getContractPmgoodsPmoney());
                    contractMap2.put("order_id", ocContractDomain.getContractBillcode());
                    orderPromotionData.add(contractMap2);
                }
                if ("0001".equals(ocContractPmGoodsDomain.getGoodsType())) {
                    mapStr = new LinkedHashMap();
                    mapStr.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    mapStr.put("promotiontag", ocContractPmGoodsDomain.getGoodsClass());
                    mapStr.put("promotionrule", ocContractPmGoodsDomain.getContractSettlOpno() + ocContractPmGoodsDomain.getGoodsClass() + ":" + ocContractPmGoodsDomain.getContractSettlOpemo());
                    List stringList = (List)JsonUtil.buildNormalBinder().getJsonToList(ocContractPmGoodsDomain.getGoodsNo(), String.class);
                    String join = String.join((CharSequence)",", stringList);
                    String string = this.makeCreateOcOrder(contractGoodsDomainMap, stringList);
                    sum = ocContractPmGoodsDomain.getGoodsCamount() + "\u4ef6" + ocContractPmGoodsDomain.getSkuNo() + "(" + ocContractPmGoodsDomain.getGoodsShowname() + ")";
                    mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + string + "\uff0c\u8d60\u9001" + (String)sum);
                    orderDescData.add(mapStr);
                    HashMap contractMap3 = Maps.newHashMap();
                    contractMap3.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    contractMap3.put("promotiondesc", ocContractPmGoodsDomain.getGoodsClass());
                    contractMap3.put("promotiongoods", join);
                    contractMap3.put("promotiongift", ocContractPmGoodsDomain.getSkuNo());
                    contractMap3.put("promotionnumrate", ocContractPmGoodsDomain.getGoodsCamount());
                    contractMap3.put("promotionprice", "");
                    contractMap3.put("order_id", ocContractDomain.getContractBillcode());
                    orderPromotionData.add(contractMap3);
                }
                if ("0007".equals(ocContractPmGoodsDomain.getGoodsType())) {
                    mlist = (ArrayList<OcContractPmGoods>)ddListMapStr.get(ocContractPmGoodsDomain.getContractSettlOpno());
                    if (null == mlist) {
                        mlist = new ArrayList<OcContractPmGoods>();
                        ddListMapStr.put(ocContractPmGoodsDomain.getContractSettlOpno(), mlist);
                    }
                    mlist.add(ocContractPmGoodsDomain);
                    List stringList = (List)JsonUtil.buildNormalBinder().getJsonToList(ocContractPmGoodsDomain.getGoodsNo(), String.class);
                    String join = String.join((CharSequence)",", stringList);
                    contractMap = Maps.newHashMap();
                    contractMap.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    contractMap.put("promotiondesc", ocContractPmGoodsDomain.getGoodsClass());
                    contractMap.put("promotiongoods", join);
                    contractMap.put("promotiongift", ocContractPmGoodsDomain.getSkuNo());
                    contractMap.put("promotionnumrate", null);
                    contractMap.put("promotionprice", ocContractPmGoodsDomain.getContractPmgoodsPmoney());
                    contractMap.put("order_id", ocContractDomain.getContractBillcode());
                    orderPromotionData.add(contractMap);
                }
                if ("zx0002".equals(ocContractPmGoodsDomain.getGoodsType())) {
                    mlist = (List)ddListMap.get(ocContractPmGoodsDomain.getContractSettlOpno());
                    if (null == mlist) {
                        mlist = new ArrayList();
                        ddListMap.put(ocContractPmGoodsDomain.getContractSettlOpno(), mlist);
                    }
                    mlist.add(ocContractPmGoodsDomain);
                }
                if (!"gz0002".equals(ocContractPmGoodsDomain.getGoodsType())) continue;
                mlist = (List)ddListMap.get(ocContractPmGoodsDomain.getContractSettlOpno());
                if (null == mlist) {
                    mlist = new ArrayList();
                    ddListMap.put(ocContractPmGoodsDomain.getContractSettlOpno(), mlist);
                }
                mlist.add(ocContractPmGoodsDomain);
            }
        }
        if (MapUtil.isNotEmpty(ddListMap)) {
            for (String string : ddListMap.keySet()) {
                ocContractPmGoods = (List)ddListMap.get(string);
                if (!ListUtil.isNotEmpty((Collection)ocContractPmGoods)) continue;
                ocContractPmGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)ocContractPmGoods), OcContractPmGoods.class);
                ocContractPmGoods1 = (OcContractPmGoods)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(ocContractPmGoods.get(0)), OcContractPmGoods.class);
                LinkedHashMap<String, String> mapStr = new LinkedHashMap<String, String>();
                mapStr.put("promotionid", ocContractPmGoods1.getContractSettlOpno());
                mapStr.put("promotiontag", "\u817b\u5b50\u8fd0\u8d39\u653f\u7b56");
                mapStr.put("promotionrule", "\u3010" + ocContractPmGoods1.getContractSettlOpno() + "\u817b\u5b50\u8fd0\u8d39\u653f\u7b56(" + ocContractPmGoods1.getGoodsClass() + ")\u3011:\u8d2d\u4e70\u817b\u5b50\u5428\u4f4d\u6ee1\u8db3\u574e\u7ea7" + ocContractPmGoods1.getContractSettlOpemo() + "\u5428,\u4eab\u53d7\u8fd0\u8d39\u653f\u7b56");
                String str = "";
                int size = ocContractPmGoodsList.size();
                for (int a = 0; a < size; ++a) {
                    OcContractPmGoods ocContractPmGoodsDomain = (OcContractPmGoods)ocContractPmGoodsList.get(a);
                    String b = "";
                    b = a == size - 1 ? ocContractPmGoodsDomain.getContractGoodsSendnum().divide(new BigDecimal("1000"), 2, 1) + "\u5428" + ocContractPmGoodsDomain.getSkuNo() + "(" + ocContractPmGoodsDomain.getGoodsShowname() + ")\u4eab\u53d7\u653f\u7b56\u5355\u4ef7" + ocContractPmGoodsDomain.getContractGoodsSendweight() + "\u5143" : ocContractPmGoodsDomain.getContractGoodsSendnum().divide(new BigDecimal("1000"), 2, 1) + "\u5428" + ocContractPmGoodsDomain.getSkuNo() + "(" + ocContractPmGoodsDomain.getGoodsShowname() + ")\u4eab\u53d7\u653f\u7b56\u5355\u4ef7" + ocContractPmGoodsDomain.getContractGoodsSendweight() + "\u5143\u3001";
                    str = str + b;
                }
                mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + str);
                orderDescData.add(mapStr);
            }
        }
        if (MapUtil.isNotEmpty(ddListMapStr)) {
            for (String string : ddListMapStr.keySet()) {
                ocContractPmGoods = (List)ddListMapStr.get(string);
                if (!ListUtil.isNotEmpty((Collection)ocContractPmGoods)) continue;
                ocContractPmGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)ocContractPmGoods), OcContractPmGoods.class);
                ocContractPmGoods1 = (OcContractPmGoods)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(ocContractPmGoods.get(0)), OcContractPmGoods.class);
                Object contractPmgoodsPmoney = BigDecimal.ZERO;
                int size = ocContractPmGoodsList.size();
                for (int a = 0; a < size; ++a) {
                    OcContractPmGoods ocContractPmGoodsDomain = (OcContractPmGoods)ocContractPmGoodsList.get(a);
                    if (null == ocContractPmGoodsDomain.getContractPmgoodsPmoney()) continue;
                    contractPmgoodsPmoney = ((BigDecimal)contractPmgoodsPmoney).add(ocContractPmGoodsDomain.getContractPmgoodsPmoney());
                }
                LinkedHashMap<String, String> mapStr = new LinkedHashMap<String, String>();
                mapStr.put("promotionid", ocContractPmGoods1.getContractSettlOpno());
                mapStr.put("promotiontag", ocContractPmGoods1.getGoodsClass());
                mapStr.put("promotionrule", ocContractPmGoods1.getContractSettlOpno() + ocContractPmGoods1.getGoodsClass());
                mapStr.put("promotiondesc", "\u8d2d\u4e70\u4ea7\u54c1\u8fbe\u5230\u4e00\u5b9a\u91d1\u989d\u514d\u8d39\u8d60\u9001\u4ea7\u54c1" + contractPmgoodsPmoney + "\u5143");
                orderDescData.add(mapStr);
            }
        }
        BigDecimal bigDecimal = goodsAssistweight = ocContractDomain.getGoodsAssistweight() == null ? BigDecimal.ZERO : ocContractDomain.getGoodsAssistweight();
        if (goodsAssistweight.compareTo(BigDecimal.ZERO) > 0) {
            List<OcContractSettlDomain> ocContractSettlList;
            BigDecimal contractPrice;
            List skuNoList = goodsList.stream().map(OcContractGoodsDomain::getSkuNo).distinct().collect(Collectors.toList());
            String join = org.apache.commons.lang3.StringUtils.join(skuNoList, (String)",");
            BigDecimal bigDecimal2 = contractPrice = ocContractDomain.getContractPriceMarkup() == null ? BigDecimal.ZERO : ocContractDomain.getContractPriceMarkup();
            if (goodsAssistweight.compareTo(BigDecimal.ZERO) > 0) {
                contractMap = Maps.newHashMap();
                contractMap.put("promotionid", "contract");
                contractMap.put("promotiondesc", "\u5408\u540c\u52a0\u4ef7");
                contractMap.put("promotiongoods", join);
                contractMap.put("promotiongift", "");
                contractMap.put("promotionnumrate", "");
                contractMap.put("promotionprice", goodsAssistweight);
                contractMap.put("order_id", ocContractDomain.getContractBillcode());
                orderPromotionData.add(contractMap);
            }
            if (ListUtil.isNotEmpty(ocContractSettlList = ocContractDomain.getOcContractSettlList())) {
                for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
                    if ("jfc".equals(ocContractSettlDomain.getContractSettlBlance())) {
                        String join1 = String.join((CharSequence)",", skujfcNoList);
                        HashMap baseAndAuxiliaryMaterialsMap = Maps.newHashMap();
                        baseAndAuxiliaryMaterialsMap.put("promotionid", "jfc");
                        baseAndAuxiliaryMaterialsMap.put("promotiondesc", ocContractSettlDomain.getContractSettlOpemo());
                        baseAndAuxiliaryMaterialsMap.put("promotiongoods", join1);
                        baseAndAuxiliaryMaterialsMap.put("promotiongift", "");
                        baseAndAuxiliaryMaterialsMap.put("promotionnumrate", "");
                        baseAndAuxiliaryMaterialsMap.put("promotionprice", ocContractSettlDomain.getContractSettlGmoney());
                        baseAndAuxiliaryMaterialsMap.put("order_id", ocContractDomain.getContractBillcode());
                        orderPromotionData.add(baseAndAuxiliaryMaterialsMap);
                    }
                    if (!"dzp".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
                    HashMap lowValueMap = Maps.newHashMap();
                    lowValueMap.put("promotionid", "dzp");
                    lowValueMap.put("promotiondesc", "\u4f4e\u503c\u54c1\u52a0\u4ef7");
                    lowValueMap.put("promotiongoods", ocContractSettlDomain.getContractSettlOpno());
                    lowValueMap.put("promotiongift", "");
                    lowValueMap.put("promotionnumrate", "");
                    lowValueMap.put("promotionprice", ocContractSettlDomain.getContractSettlGmoney());
                    lowValueMap.put("order_id", ocContractDomain.getContractBillcode());
                    orderPromotionData.add(lowValueMap);
                }
            }
        }
        orderMainData.put("orderSubData", orderSubData);
        orderMainData.put("orderDescData", orderDescData);
        try {
            orderMainData.put("sign", SignUtil.getSign(createOrderInfo));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.sign", (Object)JsonUtil.buildNormalBinder().toJson(createOrderInfo));
            return "error";
        }
        orderMainData.put("orderPromotionData", orderPromotionData);
        Long startTime = System.currentTimeMillis();
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendCreateBusOrder.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(map), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("data");
        if (null != code) {
            Map returnResultsCodeMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(code), String.class, Object.class);
            if (MapUtil.isEmpty((Map)returnResultsCodeMap)) {
                return "error";
            }
            Object code1 = returnResultsCodeMap.get("code");
            if (null != code1 && code1.equals("0")) {
                return "success";
            }
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendCreateBusOrder.code" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
        return "error";
    }

    @Override
    public String createBusOrder(OcContractReDomain ocContractDomain) {
        BigDecimal goodsAssistweight;
        OcContractPmGoods ocContractPmGoods1;
        List ocContractPmGoodsList;
        List ocContractPmGoods;
        HashMap contractMap;
        Object sum;
        logger.error(this.SYS_CODE + ".createBusOrder.ocContractDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".createBusOrder.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String contractBillcode = ocContractDomain.getContractBillcode();
        ocContractDomain.setContractBillcode(ocContractDomain.getContractObillcode());
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAccGB", "getUserAccGB");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".createBusOrder\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        UmUserinfoReDomain userinfoByUserinfoCode = this.getUserinfoByUserinfoCode(ocContractDomain.getMemberBcode(), ocContractDomain.getTenantCode());
        if (null == userinfoByUserinfoCode) {
            logger.error(this.SYS_CODE + ".createBusOrder.userinfoByUserinfoCode", (Object)"isnull");
            return "error";
        }
        CtCustrelReDomain ctCustrelReDomain = null;
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("tenantCode", ocContractDomain.getTenantCode());
        newMap.put("userinfoOpcode", ocContractDomain.getMemberBcode());
        newMap.put("userinfoOpcode2", ocContractDomain.getDepartCode());
        newMap.put("custrelFeestatus", "1");
        QueryResult<CtCustrelReDomain> ctCustrelReDomainQueryResult = this.queryCustrelPage(newMap);
        if (ListUtil.isEmpty((Collection)ctCustrelReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".createBusOrder.ctCustrelReDomainQueryResult", newMap);
            return "error";
        }
        ctCustrelReDomain = (CtCustrelReDomain)ctCustrelReDomainQueryResult.getList().get(0);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("tenantCode", ocContractDomain.getTenantCode());
        map2.put("addressCode", ocContractDomain.getAreaCode());
        QueryResult<UmAddressReDomain> umAddressReDomainQueryResult = this.queryAddressPage(map2);
        if (ListUtil.isEmpty((Collection)umAddressReDomainQueryResult.getList())) {
            logger.error(this.SYS_CODE + ".createBusOrder.queryAddressPage" + ((Object)map2).toString());
            return "error";
        }
        UmAddressReDomain umAddressReDomain = (UmAddressReDomain)umAddressReDomainQueryResult.getList().get(0);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> orderMainData = new LinkedHashMap<String, Object>();
        map.put("action", "createOrder");
        map.put("createOrderInfo", orderMainData);
        LinkedHashMap<String, Object> createOrderInfo = new LinkedHashMap<String, Object>();
        if ("SKS".equals(ocContractDomain.getContractBlance())) {
            createOrderInfo.put("is_qjd_pay", "8a8acee26eafd905016eafdcd81c0005");
        }
        if ("PF".equals(ocContractDomain.getContractBlance())) {
            createOrderInfo.put("is_qjd_pay", "8a8acee27332ef49017337c524dd6689");
        }
        if ("QJD".equals(ocContractDomain.getContractBlance())) {
            createOrderInfo.put("is_qjd_pay", "8a8acee26eafd905016eafdcd81c0004");
        }
        createOrderInfo.put("order_id", ocContractDomain.getContractBillcode());
        createOrderInfo.put("customerid", ocContractDomain.getMemberBname());
        createOrderInfo.put("receiveridno", ocContractDomain.getGoodsSupplierCode());
        createOrderInfo.put("receivertel", ocContractDomain.getGoodsReceiptPhone());
        createOrderInfo.put("address", ocContractDomain.getAreaCode());
        createOrderInfo.put("lastdatetime", ocContractDomain.getGmtModified());
        if (StringUtils.isNotBlank((String)ocContractDomain.getGoodsReceiptArrdess())) {
            String str = ocContractDomain.getGoodsReceiptArrdess();
            String str1 = str.substring(0, str.indexOf("\u00b7"));
            String str2 = str.substring(str1.length() + 1, str.length());
            createOrderInfo.put("deliveryaddress", str2);
        }
        createOrderInfo.put("despatchmode", ocContractDomain.getContractPumode());
        createOrderInfo.put("despatchmodedesc", null);
        if (StringUtils.isNotBlank((String)ocContractDomain.getContractPumode())) {
            createOrderInfo.put("despatchmodedesc", BusOrderServiceImpl.getMessage(ocContractDomain.getContractPumode()));
        }
        createOrderInfo.put("extraprice1", "0.000");
        createOrderInfo.put("ordertotal", ocContractDomain.getDataBmoney());
        createOrderInfo.put("ordertype", "ZBSO");
        createOrderInfo.put("ordertypedesc", "\u6807\u51c6\u8ba2\u5355");
        createOrderInfo.put("wlzc", null);
        createOrderInfo.put("CREATEDATETIME", ocContractDomain.getGmtCreate());
        createOrderInfo.put("dayusettleaccount", "0.000");
        createOrderInfo.put("wbsid", ocContractDomain.getPricesetCurrency1());
        createOrderInfo.put("useunload", "false");
        createOrderInfo.put("unloadprice", "0.000");
        createOrderInfo.put("addhtmsg", ocContractDomain.getContractEcurl());
        createOrderInfo.put("extraprice2", ocContractDomain.getGoodsAssistweight());
        createOrderInfo.put("ismjj", ocContractDomain.getDdTypeCurrency());
        BigDecimal wweight = BigDecimal.ZERO;
        BigDecimal oweight = BigDecimal.ZERO;
        BigDecimal otherweight = BigDecimal.ZERO;
        BigDecimal totalweight = BigDecimal.ZERO;
        BigDecimal nwtotal = BigDecimal.ZERO;
        BigDecimal nozptwtotlaw = BigDecimal.ZERO;
        BigDecimal ytbnwtotal = BigDecimal.ZERO;
        BigDecimal dayusettleaccount = BigDecimal.ZERO;
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        ArrayList<String> skujfcNoList = new ArrayList<String>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (null == ocContractGoodsDomain.getPricesetNprice1()) {
                ocContractGoodsDomain.setPricesetNprice1(BigDecimal.ZERO);
            }
            dayusettleaccount = dayusettleaccount.add(ocContractGoodsDomain.getPricesetNprice1().multiply(ocContractGoodsDomain.getGoodsCamount()));
            if (null != ocContractGoodsDomain.getGoodsWeight() && ocContractGoodsDomain.getGoodsWeight().compareTo(BigDecimal.ZERO) > 0) {
                ocContractGoodsDomain.setGoodsWeight(ocContractGoodsDomain.getGoodsWeight().divide(new BigDecimal("1000")));
            }
            if (null != ocContractGoodsDomain.getGoodsOneweight() && ocContractGoodsDomain.getGoodsOneweight().compareTo(BigDecimal.ZERO) > 0) {
                ocContractGoodsDomain.setGoodsOneweight(ocContractGoodsDomain.getGoodsOneweight().divide(new BigDecimal("1000")));
            }
            if ("1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                ocContractGoodsDomain.setContractGoodsPrice(ocContractGoodsDomain.getPricesetNprice());
                skujfcNoList.add(ocContractGoodsDomain.getSkuNo());
            }
            if ("8a8ad0a039e82acc0139fc4d34a61172".equals(ocContractGoodsDomain.getGoodsSpec3())) {
                wweight = wweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            if ("8a8ad0a039e82acc0139fc4d34a61173".equals(ocContractGoodsDomain.getGoodsSpec3())) {
                oweight = oweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            if (!"8a8ad0a039e82acc0139fc4d34a61173".equals(ocContractGoodsDomain.getGoodsSpec3()) && !"8a8ad0a039e82acc0139fc4d34a61172".equals(ocContractGoodsDomain.getGoodsSpec3())) {
                otherweight = otherweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            totalweight = totalweight.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            nwtotal = nwtotal.add(ocContractGoodsDomain.getGoodsWeight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            if ("8a8ad0a03a691636013a692c7aac0071".equals(ocContractGoodsDomain.getMschannelCode())) {
                nozptwtotlaw = nozptwtotlaw.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            if (!StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsPro()) || !"3".equals(ocContractGoodsDomain.getGoodsPro())) continue;
            ytbnwtotal = ytbnwtotal.add(ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
        }
        createOrderInfo.put("dayusettleaccount", dayusettleaccount);
        createOrderInfo.put("wweight", wweight);
        createOrderInfo.put("oweight", oweight);
        createOrderInfo.put("otherweight", otherweight);
        createOrderInfo.put("totalweight", totalweight);
        createOrderInfo.put("nwtotal", nwtotal);
        createOrderInfo.put("nozptwtotlaw", nozptwtotlaw);
        createOrderInfo.put("ytbnwtotal", ytbnwtotal);
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        if (null != ocContractDomain.getGoodsLogmoney()) {
            goodsLogmoney = ocContractDomain.getGoodsLogmoney();
        }
        BigDecimal goodsPmoney = BigDecimal.ZERO;
        if (null != ocContractDomain.getGoodsPmoney()) {
            goodsPmoney = BigDecimal.ZERO;
        }
        createOrderInfo.put("hjsl", ocContractDomain.getGoodsSupplierName());
        createOrderInfo.put("remark", ocContractDomain.getContractRemark());
        createOrderInfo.put("productamount", ocContractDomain.getContractInmoney());
        createOrderInfo.put("discountstotal", goodsPmoney.add(goodsLogmoney));
        createOrderInfo.put("orderadd", BigDecimal.ZERO.add(goodsLogmoney));
        createOrderInfo.put("amountpayable", ocContractDomain.getDataBmoney());
        createOrderInfo.put("saledeptid", ctCustrelReDomain.getUserinfoOpcode2());
        createOrderInfo.put("receiver", ocContractDomain.getGoodsReceiptMem());
        createOrderInfo.put("saledeptname", ctCustrelReDomain.getDepartName());
        createOrderInfo.put("customername", userinfoByUserinfoCode.getUserinfoOcode());
        createOrderInfo.put("sapcustomercode", userinfoByUserinfoCode.getUserinfoCertNo());
        if (!ocContractDomain.getMemberBcode().equals(ocContractDomain.getEmployeeCode())) {
            createOrderInfo.put("sapcustomercode", ocContractDomain.getMemberMcode());
        }
        createOrderInfo.put("address_id", ocContractDomain.getAreaCode());
        createOrderInfo.put("customerno", umAddressReDomain.getRoadCode());
        createOrderInfo.put("sold", ocContractDomain.getEmployeeCode());
        createOrderInfo.put("areausers", ocContractDomain.getEmployeeName());
        createOrderInfo.put("province", umAddressReDomain.getProvinceCode());
        createOrderInfo.put("city", umAddressReDomain.getAreaCode());
        createOrderInfo.put("citytype", umAddressReDomain.getCityCode());
        createOrderInfo.put("project", ocContractDomain.getMemberGname());
        createOrderInfo.put("contractid", ocContractDomain.getMemberGcode());
        createOrderInfo.put("profitcenter", ocContractDomain.getCompanyShortname());
        createOrderInfo.put("salesarea", ocContractDomain.getCompanyShortname());
        createOrderInfo.put("saledisname", ctCustrelReDomain.getUserinfoDischannelname());
        createOrderInfo.put("saledis", ctCustrelReDomain.getUserinfoDischannelcode());
        createOrderInfo.put("orgname", ctCustrelReDomain.getQualityQtypeName());
        createOrderInfo.put("profitname", ocContractDomain.getMemberCcode());
        createOrderInfo.put("saleorg", ocContractDomain.getCompanyCode());
        createOrderInfo.put("productgroup", ctCustrelReDomain.getCustrelFax());
        createOrderInfo.put("productname", ctCustrelReDomain.getCustrelTaun());
        createOrderInfo.put("zterm", ctCustrelReDomain.getUserinfoSort());
        createOrderInfo.put("deliverycompany", "1700");
        createOrderInfo.put("ifvirtual", false);
        if ("1".equals(ocContractDomain.getContractProperty())) {
            createOrderInfo.put("ifvirtual", true);
        }
        createOrderInfo.put("guaranteedstock", false);
        if ("1".equals(ocContractDomain.getContractPmode())) {
            createOrderInfo.put("guaranteedstock", true);
        }
        createOrderInfo.put("dsfjc", ocContractDomain.getMschannelCode());
        createOrderInfo.put("cxjdw", null);
        createOrderInfo.put("elequality", false);
        if ("1".equals(ocContractDomain.getMschannelName())) {
            createOrderInfo.put("elequality", true);
        }
        createOrderInfo.put("randomstring", (int)(Math.random() * 9000.0 + 1000.0));
        createOrderInfo.put("timestamp", ocContractDomain.getGmtCreate().getTime());
        createOrderInfo.put("humresid", userinfoByUserinfoCode.getMemberMcode());
        createOrderInfo.put("isnewbh", "8a8ad0a03d4809f1013d4d96e5fb0a30");
        if ("029".equals(ocContractDomain.getAppmanageIcode())) {
            createOrderInfo.put("createsource", "8a8ace588ba277c2018ba3a6a1af11fa");
        }
        if ("027".equals(ocContractDomain.getAppmanageIcode())) {
            createOrderInfo.put("createsource", "8a8ace588ba277c2018ba3a6a1af11fc");
        }
        if ("024".equals(ocContractDomain.getAppmanageIcode())) {
            createOrderInfo.put("createsource", "8a8ace588ba277c2018ba3a6a1af11fb");
        }
        if ("028".equals(ocContractDomain.getAppmanageIcode())) {
            createOrderInfo.put("createsource", "8a8ace588ba277c2018ba3a6a1af11fd");
        }
        if (StringUtils.isNotBlank((String)ocContractDomain.getChannelName())) {
            String string1 = ocContractDomain.getChannelName().replace("\u300a", "<");
            createOrderInfo.put("notpromotiondesc", string1.replace("\u300b", ">"));
        } else {
            createOrderInfo.put("notpromotiondesc", ocContractDomain.getChannelName());
        }
        createOrderInfo.put("comaddmsg", ocContractDomain.getContractObillcode());
        createOrderInfo.put("isytbdd", "0");
        if (null != ocContractDomain.getContractValidate()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String formattedDate = sdf.format(ocContractDomain.getContractValidate());
            createOrderInfo.put("expecttime", formattedDate);
        } else {
            createOrderInfo.put("expecttime", null);
        }
        if ("002".equals(ocContractDomain.getContractNbillcode())) {
            createOrderInfo.put("isytbdd", "1");
        }
        orderMainData.put("orderMainData", createOrderInfo);
        ArrayList orderSubData = new ArrayList();
        ArrayList orderDescData = new ArrayList();
        HashMap<String, RsClasstreeDomain> rsClasstreeMap = new HashMap<String, RsClasstreeDomain>();
        HashMap<String, OcContractGoodsDomain> contractGoodsDomainMap = new HashMap<String, OcContractGoodsDomain>();
        ArrayList ocContractPmGoodsDomainList = new ArrayList();
        HashMap<String, Object> mapStrs = new HashMap<String, Object>();
        mapStrs.put("tenantCode", ocContractDomain.getTenantCode());
        mapStrs.put("contractBillcode", contractBillcode);
        QueryResult<OcContractPmGoods> ocContractPmGoodsQueryResult = this.queryContractPmGoodsPage(mapStrs);
        if (ListUtil.isNotEmpty((Collection)ocContractPmGoodsQueryResult.getList())) {
            ocContractPmGoodsDomainList.addAll(ocContractPmGoodsQueryResult.getList());
        }
        HashMap<String, String> wuliaoMap = new HashMap<String, String>();
        if (ListUtil.isNotEmpty(ocContractPmGoodsDomainList)) {
            for (OcContractPmGoods ocContractPmGoodsDomain : ocContractPmGoodsDomainList) {
                if (!"0007".equals(ocContractPmGoodsDomain.getGoodsType())) continue;
                wuliaoMap.put(ocContractPmGoodsDomain.getSkuNo(), ocContractPmGoodsDomain.getSkuNo());
            }
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            String[] skuCode1;
            String skuCode;
            String atn;
            String colorname;
            LinkedHashMap<String, String> mapStr;
            List strings;
            String[] split;
            if (!"1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                contractGoodsDomainMap.put(ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
            }
            this.makeOcContractGoodsDomain(ocContractGoodsDomain, rsClasstreeMap);
            LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
            map1.put("order_id", ocContractDomain.getContractBillcode());
            map1.put("xcpzl", ocContractGoodsDomain.getClasstreeShopname());
            map1.put("xcpxlei", ocContractGoodsDomain.getClasstreeCode());
            map1.put("xcpdl", ocContractGoodsDomain.getClasstreeShopcode());
            map1.put("xcpxl", null);
            map1.put("orgunit", ocContractGoodsDomain.getMschannelName());
            if (null == ocContractGoodsDomain.getPricesetNprice()) {
                ocContractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsPrice()) {
                ocContractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain.getPricesetNprice().compareTo(BigDecimal.ZERO) == 0) {
                map1.put("discountrate", "0");
            } else {
                map1.put("discountrate", ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsPrice()).divide(ocContractGoodsDomain.getPricesetNprice(), RoundingMode.HALF_UP));
            }
            map1.put("cxproductid", ocContractGoodsDomain.getSkuBarcode());
            if (null == ocContractGoodsDomain.getGoodsWeight()) {
                ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsOneweight()) {
                ocContractGoodsDomain.setGoodsOneweight(BigDecimal.ZERO);
            }
            map1.put("nwtotal", ocContractGoodsDomain.getGoodsWeight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            map1.put("bomtype", ocContractGoodsDomain.getMschannelCode());
            map1.put("gwtotal", ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            if ("8a8ad0a03a691636013a692c7aac0071".equals(ocContractGoodsDomain.getMschannelCode())) {
                map1.put("iszptw", "1");
            } else {
                map1.put("iszptw", "0");
            }
            map1.put("bomgroupid", ocContractGoodsDomain.getGinfoCode());
            map1.put("productlevel", ocContractGoodsDomain.getGoodsSpec5());
            map1.put("islow", "0");
            if ("8a8acee27f87ca4f017f969a9a9969a2".equals(ocContractGoodsDomain.getPricesetCurrency())) {
                map1.put("islow", "1");
            }
            map1.put("stockcode", ocContractGoodsDomain.getGoodsNo());
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
                ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            Map map3 = this.makeMap(ocContractGoodsDomain.getGoodsRemark());
            map1.put("discountamount", ocContractGoodsDomain.getContractGoodsInmoney().subtract(ocContractGoodsDomain.getContractGoodsMoney()).negate().toPlainString());
            if ("1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                map1.put("discountamount", "0");
            }
            map1.put("itemdescribe", ocContractGoodsDomain.getGoodsName());
            map1.put("appclass", ocContractGoodsDomain.getChannelName());
            map1.put("nw", ocContractGoodsDomain.getGoodsWeight());
            map1.put("quantity", ocContractGoodsDomain.getGoodsCamount());
            map1.put("cancelcount", ocContractGoodsDomain.getGoodsCamount());
            Object sksRespriceColorprice = null;
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuName()) && null != (split = ocContractGoodsDomain.getSkuName().split("\\+")) && split.length >= 2) {
                sksRespriceColorprice = ocContractGoodsDomain.getSkuName().substring(ocContractGoodsDomain.getSkuName().indexOf("+") + 1);
            }
            if (StringUtils.isBlank(sksRespriceColorprice)) {
                sksRespriceColorprice = this.getSksRespriceColorprice(ocContractGoodsDomain.getSkuShowno(), ocContractGoodsDomain.getTenantCode());
            }
            map1.put("colorid", ocContractGoodsDomain.getSkuShowno());
            map1.put("productclass", map3.get("GROUPNAME"));
            String skuName = ocContractGoodsDomain.getSkuName();
            String[] skuName1 = skuName.split("\\+");
            map1.put("pack", skuName1[0]);
            map1.put("price", ocContractGoodsDomain.getPricesetNprice());
            map1.put("subtotal", ocContractGoodsDomain.getContractGoodsInmoney().toPlainString());
            String[] split2 = ocContractGoodsDomain.getGoodsName().split("\\+");
            map1.put("productname", null);
            if (split2.length > 2) {
                map1.put("productname", split2[1]);
            } else if (split2.length > 1 && split2.length < 3) {
                map1.put("productname", split2[0]);
            }
            map1.put("settleaccount", ocContractGoodsDomain.getContractGoodsMoney());
            map1.put("remark", null);
            if ("1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                map1.put("remark", "\u8d60\u54c1");
                map1.put("settleaccount", ocContractGoodsDomain.getPricesetNprice().multiply(ocContractGoodsDomain.getGoodsCamount()));
            }
            if (wuliaoMap.containsKey(ocContractGoodsDomain.getSkuNo())) {
                map1.put("remark", "\u7269\u6599\u4fc3\u9500-\u7269\u6599");
            }
            map1.put("pch", ocContractGoodsDomain.getGoodsContract());
            map1.put("iszp", "0");
            if ("1".equals(ocContractGoodsDomain.getContractGoodsGtype())) {
                map1.put("iszp", "1");
            }
            map1.put("speciality", ocContractGoodsDomain.getGoodsSpec3());
            map1.put("minquantity", "0");
            map1.put("currency", "CNY");
            map1.put("brand", ocContractGoodsDomain.getBrandName());
            map1.put("gw", ocContractGoodsDomain.getGoodsOneweight().multiply(ocContractGoodsDomain.getGoodsCamount()));
            map1.put("colorname", sksRespriceColorprice);
            map1.put("productid", ocContractGoodsDomain.getSkuEocode());
            map1.put("discountprice", ocContractGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsPrice()).negate().toPlainString());
            map1.put("itemnumber", ocContractGoodsDomain.getSkuNo());
            map1.put("settleprice", ocContractGoodsDomain.getContractGoodsPrice());
            map1.put("unit", ocContractGoodsDomain.getGoodsSpec4());
            map1.put("dayusettleaccount", ocContractGoodsDomain.getPricesetNprice1());
            map1.put("unloadprice", "0.000");
            map1.put("bomdescalias", null);
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsOrigin()) && ocContractGoodsDomain.getGoodsOrigin().contains("11")) {
                map1.put("bomdescalias", ocContractGoodsDomain.getGoodsMaterial());
            }
            map1.put("exfactoryprice", ocContractGoodsDomain.getContractGoodsRemoney());
            map1.put("zbcbhd", null);
            map1.put("zjjys", null);
            map1.put("zbwhd", null);
            map1.put("zbwcz", null);
            map1.put("zmbhd", null);
            map1.put("zmbcm", null);
            map1.put("zsmxg", null);
            map1.put("bt", null);
            if ("2".equals(ocContractGoodsDomain.getContractGoodsGtype()) && ListUtil.isNotEmpty((Collection)(strings = (List)JsonUtil.buildNormalBinder().getJsonToList(ocContractGoodsDomain.getSkuOldcode(), String.class)))) {
                map1.put("tpmianprod", strings.get(0));
                map1.put("remark", (String)strings.get(0) + "\u914d\u5957\u6258\u76d8");
            }
            if ("3".equals(ocContractGoodsDomain.getGoodsPro())) {
                String skuCode2 = ocContractGoodsDomain.getSkuCode();
                String[] skuCode12 = skuCode2.split("_");
                if (null != skuCode12 && skuCode12.length == 4) {
                    map1.put("colorname", skuCode12[3]);
                }
                map1.put("itemnumber", ocContractGoodsDomain.getSkuNo().split("_")[0]);
                String mainStr = ocContractGoodsDomain.getSkuNo();
                String[] str = mainStr.split("_");
                String str1 = str[1];
                String subStr1 = "YTB";
                boolean result = ocContractGoodsDomain.getGoodsNo().contains(subStr1);
                if (result) {
                    char boardw = str1.charAt(0);
                    char panelw = str1.charAt(1);
                    char layersw = str1.charAt(4);
                    char layerdensityw = str1.charAt(8);
                    char a1 = str1.charAt(2);
                    char b = str1.charAt(3);
                    char c = str1.charAt(5);
                    char d = str1.charAt(6);
                    char f = str1.charAt(7);
                    map1.put("zbcbhd", null);
                    map1.put("zjjys", null);
                    map1.put("zbwmd", Character.valueOf(layerdensityw));
                    map1.put("zbwhd", String.valueOf(c) + String.valueOf(d) + String.valueOf(f));
                    map1.put("zbwcz", Character.valueOf(layersw));
                    map1.put("zmbhd", String.valueOf(a1) + String.valueOf(b));
                    map1.put("zmbcm", Character.valueOf(panelw));
                    map1.put("zsmxg", Character.valueOf(boardw));
                    map1.put("bt", null);
                }
                String subStr2 = "DB";
                boolean result1 = ocContractGoodsDomain.getGoodsNo().contains(subStr2);
                if (result1) {
                    char boardw = str1.charAt(0);
                    char panelw = str1.charAt(1);
                    char layersw = str1.charAt(4);
                    char a1 = str1.charAt(2);
                    char b = str1.charAt(3);
                    map1.put("zbcbhd", null);
                    map1.put("zjjys", null);
                    map1.put("zbwmd", null);
                    map1.put("zbwhd", null);
                    map1.put("zbwcz", null);
                    map1.put("zmbhd", String.valueOf(a1) + String.valueOf(b));
                    map1.put("zmbcm", Character.valueOf(panelw));
                    map1.put("zsmxg", Character.valueOf(boardw));
                    map1.put("bt", Character.valueOf(layersw));
                }
            }
            orderSubData.add(map1);
            if ("10".equals(ocContractGoodsDomain.getGoodsOrigin())) {
                mapStr = new LinkedHashMap<String, String>();
                if ("3".equals(ocContractGoodsDomain.getGoodsPro())) {
                    colorname = null;
                    atn = null;
                    skuCode = ocContractGoodsDomain.getSkuCode();
                    skuCode1 = skuCode.split("_");
                    if (null != skuCode1 && skuCode1.length == 4) {
                        colorname = skuCode1[3];
                        atn = skuCode1[2];
                    }
                    mapStr.put("promotionid", "");
                    mapStr.put("promotiontag", "\u5de5\u7a0b\u7279\u4ef7");
                    mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo().split("_")[0] + "(" + ocContractGoodsDomain.getGoodsName() + "_" + atn + "_" + colorname + ")\u4eab\u53d7\u5de5\u7a0b\u7279\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143");
                    BigDecimal sum2 = ocContractGoodsDomain.getContractGoodsPrice().subtract(ocContractGoodsDomain.getPricesetNprice()).multiply(ocContractGoodsDomain.getGoodsCamount()).setScale(2, 4);
                    mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractGoodsDomain.getGoodsCamount() + "\u4ef6\u4ea7\u54c1,\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + sum2 + "\u5143");
                    orderDescData.add(mapStr);
                } else {
                    mapStr.put("promotionid", "");
                    mapStr.put("promotiontag", "\u5de5\u7a0b\u7279\u4ef7");
                    mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo() + "(" + ocContractGoodsDomain.getGoodsName() + ")\u4eab\u53d7\u5de5\u7a0b\u7279\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143");
                    BigDecimal sum3 = ocContractGoodsDomain.getContractGoodsPrice().subtract(ocContractGoodsDomain.getPricesetNprice()).multiply(ocContractGoodsDomain.getGoodsCamount()).setScale(2, 4);
                    mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractGoodsDomain.getGoodsCamount() + "\u4ef6\u4ea7\u54c1,\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + sum3 + "\u5143");
                    orderDescData.add(mapStr);
                }
            }
            if (!StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsOrigin()) || !ocContractGoodsDomain.getGoodsOrigin().contains("11")) continue;
            mapStr = new LinkedHashMap();
            if ("3".equals(ocContractGoodsDomain.getGoodsPro())) {
                colorname = null;
                atn = null;
                skuCode = ocContractGoodsDomain.getSkuCode();
                skuCode1 = skuCode.split("_");
                if (null != skuCode1 && skuCode1.length == 4) {
                    colorname = skuCode1[3];
                    atn = skuCode1[2];
                }
                mapStr.put("promotionid", "");
                mapStr.put("promotiontag", "\u5408\u540c\u4ef7\u7279\u4ef7");
                mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo().split("_")[0] + "(" + ocContractGoodsDomain.getGoodsName() + "_" + atn + "_" + colorname + ")\u4eab\u53d7\u5927\u79b9\u5408\u540c\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143");
                String str = null;
                if (null != ocContractGoodsDomain.getPricesetInsideprice() && ocContractGoodsDomain.getPricesetInsideprice().compareTo(BigDecimal.ZERO) > 0) {
                    str = "(\u4eab\u53d7\u9879\u76ee\u7279\u4ef7" + ocContractGoodsDomain.getPricesetInsideprice() + "\u5143)";
                    mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo().split("_")[0] + "(" + ocContractGoodsDomain.getGoodsName() + "_" + atn + "_" + colorname + ")\u4eab\u53d7\u5927\u79b9\u5408\u540c\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143" + str);
                }
                BigDecimal sum4 = ocContractGoodsDomain.getContractGoodsPrice().subtract(ocContractGoodsDomain.getPricesetNprice()).multiply(ocContractGoodsDomain.getGoodsCamount()).setScale(2, 4);
                mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractGoodsDomain.getGoodsCamount() + "\u4ef6\u4ea7\u54c1,\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + sum4 + "\u5143");
                orderDescData.add(mapStr);
                continue;
            }
            mapStr.put("promotionid", "");
            mapStr.put("promotiontag", "\u5408\u540c\u4ef7\u7279\u4ef7");
            mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo() + "(" + ocContractGoodsDomain.getGoodsName() + ")\u4eab\u53d7\u5927\u79b9\u5408\u540c\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143");
            String str = null;
            if (null != ocContractGoodsDomain.getPricesetInsideprice() && ocContractGoodsDomain.getPricesetInsideprice().compareTo(BigDecimal.ZERO) > 0) {
                str = "(\u4eab\u53d7\u9879\u76ee\u7279\u4ef7" + ocContractGoodsDomain.getPricesetInsideprice() + "\u5143)";
                mapStr.put("promotionrule", "\u5de5\u7a0b\u4fc3\u9500:" + ocContractGoodsDomain.getSkuNo() + "(" + ocContractGoodsDomain.getGoodsName() + ")\u4eab\u53d7\u5927\u79b9\u5408\u540c\u4ef7" + ocContractGoodsDomain.getContractGoodsPrice() + "\u5143" + str);
            }
            sum = ocContractGoodsDomain.getContractGoodsPrice().subtract(ocContractGoodsDomain.getPricesetNprice()).multiply(ocContractGoodsDomain.getGoodsCamount()).setScale(2, 4);
            mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractGoodsDomain.getGoodsCamount() + "\u4ef6\u4ea7\u54c1,\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + sum + "\u5143");
            orderDescData.add(mapStr);
        }
        ConcurrentHashMap ddListMap = new ConcurrentHashMap();
        ConcurrentHashMap ddListMapStr = new ConcurrentHashMap();
        ArrayList<HashMap> orderPromotionData = new ArrayList<HashMap>();
        if (ListUtil.isNotEmpty(ocContractPmGoodsDomainList)) {
            for (OcContractPmGoods ocContractPmGoodsDomain : ocContractPmGoodsDomainList) {
                List<OcContractPmGoods> mlist;
                LinkedHashMap<String, String> mapStr;
                if ("0006".equals(ocContractPmGoodsDomain.getGoodsType())) {
                    mapStr = new LinkedHashMap<String, String>();
                    mapStr.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    mapStr.put("promotiontag", ocContractPmGoodsDomain.getGoodsClass());
                    mapStr.put("promotionrule", ocContractPmGoodsDomain.getContractSettlOpno() + ocContractPmGoodsDomain.getGoodsClass() + ":" + ocContractPmGoodsDomain.getContractSettlOpemo());
                    mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + ocContractPmGoodsDomain.getGoodsCamount() + "\u4ef6" + ocContractPmGoodsDomain.getSkuNo() + "(" + ocContractPmGoodsDomain.getGoodsShowname() + ")\uff0c\u4eab\u53d7\u6298\u8ba9\u603b\u91d1\u989d" + ocContractPmGoodsDomain.getContractPmgoodsPmoney() + "\u5143");
                    orderDescData.add(mapStr);
                    HashMap contractMap2 = Maps.newHashMap();
                    contractMap2.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    contractMap2.put("promotiondesc", ocContractPmGoodsDomain.getGoodsClass());
                    contractMap2.put("promotiongoods", ocContractPmGoodsDomain.getSkuNo());
                    contractMap2.put("promotiongift", "");
                    contractMap2.put("promotionnumrate", ocContractPmGoodsDomain.getContractPmgoodsRepmoney());
                    contractMap2.put("promotionprice", ocContractPmGoodsDomain.getContractPmgoodsPmoney());
                    contractMap2.put("order_id", ocContractDomain.getContractBillcode());
                    orderPromotionData.add(contractMap2);
                }
                if ("0001".equals(ocContractPmGoodsDomain.getGoodsType())) {
                    mapStr = new LinkedHashMap();
                    mapStr.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    mapStr.put("promotiontag", ocContractPmGoodsDomain.getGoodsClass());
                    mapStr.put("promotionrule", ocContractPmGoodsDomain.getContractSettlOpno() + ocContractPmGoodsDomain.getGoodsClass() + ":" + ocContractPmGoodsDomain.getContractSettlOpemo());
                    List stringList = (List)JsonUtil.buildNormalBinder().getJsonToList(ocContractPmGoodsDomain.getGoodsNo(), String.class);
                    String join = String.join((CharSequence)",", stringList);
                    String string = this.makeCreateOcOrder(contractGoodsDomainMap, stringList);
                    sum = ocContractPmGoodsDomain.getGoodsCamount() + "\u4ef6" + ocContractPmGoodsDomain.getSkuNo() + "(" + ocContractPmGoodsDomain.getGoodsShowname() + ")";
                    mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + string + "\uff0c\u8d60\u9001" + (String)sum);
                    orderDescData.add(mapStr);
                    HashMap contractMap3 = Maps.newHashMap();
                    contractMap3.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    contractMap3.put("promotiondesc", ocContractPmGoodsDomain.getGoodsClass());
                    contractMap3.put("promotiongoods", join);
                    contractMap3.put("promotiongift", ocContractPmGoodsDomain.getSkuNo());
                    contractMap3.put("promotionnumrate", ocContractPmGoodsDomain.getGoodsCamount());
                    contractMap3.put("promotionprice", "");
                    contractMap3.put("order_id", ocContractDomain.getContractBillcode());
                    orderPromotionData.add(contractMap3);
                }
                if ("0007".equals(ocContractPmGoodsDomain.getGoodsType())) {
                    mlist = (ArrayList<OcContractPmGoods>)ddListMapStr.get(ocContractPmGoodsDomain.getContractSettlOpno());
                    if (null == mlist) {
                        mlist = new ArrayList<OcContractPmGoods>();
                        ddListMapStr.put(ocContractPmGoodsDomain.getContractSettlOpno(), mlist);
                    }
                    mlist.add(ocContractPmGoodsDomain);
                    List stringList = (List)JsonUtil.buildNormalBinder().getJsonToList(ocContractPmGoodsDomain.getGoodsNo(), String.class);
                    String join = String.join((CharSequence)",", stringList);
                    contractMap = Maps.newHashMap();
                    contractMap.put("promotionid", ocContractPmGoodsDomain.getContractSettlOpno());
                    contractMap.put("promotiondesc", ocContractPmGoodsDomain.getGoodsClass());
                    contractMap.put("promotiongoods", join);
                    contractMap.put("promotiongift", ocContractPmGoodsDomain.getSkuNo());
                    contractMap.put("promotionnumrate", null);
                    contractMap.put("promotionprice", ocContractPmGoodsDomain.getContractPmgoodsPmoney());
                    contractMap.put("order_id", ocContractDomain.getContractBillcode());
                    orderPromotionData.add(contractMap);
                }
                if ("zx0002".equals(ocContractPmGoodsDomain.getGoodsType())) {
                    mlist = (List)ddListMap.get(ocContractPmGoodsDomain.getContractSettlOpno());
                    if (null == mlist) {
                        mlist = new ArrayList();
                        ddListMap.put(ocContractPmGoodsDomain.getContractSettlOpno(), mlist);
                    }
                    mlist.add(ocContractPmGoodsDomain);
                }
                if (!"gz0002".equals(ocContractPmGoodsDomain.getGoodsType())) continue;
                mlist = (List)ddListMap.get(ocContractPmGoodsDomain.getContractSettlOpno());
                if (null == mlist) {
                    mlist = new ArrayList();
                    ddListMap.put(ocContractPmGoodsDomain.getContractSettlOpno(), mlist);
                }
                mlist.add(ocContractPmGoodsDomain);
            }
        }
        if (MapUtil.isNotEmpty(ddListMap)) {
            for (String string : ddListMap.keySet()) {
                ocContractPmGoods = (List)ddListMap.get(string);
                if (!ListUtil.isNotEmpty((Collection)ocContractPmGoods)) continue;
                ocContractPmGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)ocContractPmGoods), OcContractPmGoods.class);
                ocContractPmGoods1 = (OcContractPmGoods)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(ocContractPmGoods.get(0)), OcContractPmGoods.class);
                LinkedHashMap<String, String> mapStr = new LinkedHashMap<String, String>();
                mapStr.put("promotionid", ocContractPmGoods1.getContractSettlOpno());
                mapStr.put("promotiontag", "\u817b\u5b50\u8fd0\u8d39\u653f\u7b56");
                mapStr.put("promotionrule", "\u3010" + ocContractPmGoods1.getContractSettlOpno() + "\u817b\u5b50\u8fd0\u8d39\u653f\u7b56(" + ocContractPmGoods1.getGoodsClass() + ")\u3011:\u8d2d\u4e70\u817b\u5b50\u5428\u4f4d\u6ee1\u8db3\u574e\u7ea7" + ocContractPmGoods1.getContractSettlOpemo() + "\u5428,\u4eab\u53d7\u8fd0\u8d39\u653f\u7b56");
                String str = "";
                int size = ocContractPmGoodsList.size();
                for (int a = 0; a < size; ++a) {
                    OcContractPmGoods ocContractPmGoodsDomain = (OcContractPmGoods)ocContractPmGoodsList.get(a);
                    String b = "";
                    b = a == size - 1 ? ocContractPmGoodsDomain.getContractGoodsSendnum().divide(new BigDecimal("1000"), 2, 1) + "\u5428" + ocContractPmGoodsDomain.getSkuNo() + "(" + ocContractPmGoodsDomain.getGoodsShowname() + ")\u4eab\u53d7\u653f\u7b56\u5355\u4ef7" + ocContractPmGoodsDomain.getContractGoodsSendweight() + "\u5143" : ocContractPmGoodsDomain.getContractGoodsSendnum().divide(new BigDecimal("1000"), 2, 1) + "\u5428" + ocContractPmGoodsDomain.getSkuNo() + "(" + ocContractPmGoodsDomain.getGoodsShowname() + ")\u4eab\u53d7\u653f\u7b56\u5355\u4ef7" + ocContractPmGoodsDomain.getContractGoodsSendweight() + "\u5143\u3001";
                    str = str + b;
                }
                mapStr.put("promotiondesc", "\u672c\u5355\u5df2\u4e70" + str);
                orderDescData.add(mapStr);
            }
        }
        if (MapUtil.isNotEmpty(ddListMapStr)) {
            for (String string : ddListMapStr.keySet()) {
                ocContractPmGoods = (List)ddListMapStr.get(string);
                if (!ListUtil.isNotEmpty((Collection)ocContractPmGoods)) continue;
                ocContractPmGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)ocContractPmGoods), OcContractPmGoods.class);
                ocContractPmGoods1 = (OcContractPmGoods)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(ocContractPmGoods.get(0)), OcContractPmGoods.class);
                Object contractPmgoodsPmoney = BigDecimal.ZERO;
                int size = ocContractPmGoodsList.size();
                for (int a = 0; a < size; ++a) {
                    OcContractPmGoods ocContractPmGoodsDomain = (OcContractPmGoods)ocContractPmGoodsList.get(a);
                    if (null == ocContractPmGoodsDomain.getContractPmgoodsPmoney()) continue;
                    contractPmgoodsPmoney = ((BigDecimal)contractPmgoodsPmoney).add(ocContractPmGoodsDomain.getContractPmgoodsPmoney());
                }
                LinkedHashMap<String, String> mapStr = new LinkedHashMap<String, String>();
                mapStr.put("promotionid", ocContractPmGoods1.getContractSettlOpno());
                mapStr.put("promotiontag", ocContractPmGoods1.getGoodsClass());
                mapStr.put("promotionrule", ocContractPmGoods1.getContractSettlOpno() + ocContractPmGoods1.getGoodsClass());
                mapStr.put("promotiondesc", "\u8d2d\u4e70\u4ea7\u54c1\u8fbe\u5230\u4e00\u5b9a\u91d1\u989d\u514d\u8d39\u8d60\u9001\u4ea7\u54c1" + contractPmgoodsPmoney + "\u5143");
                orderDescData.add(mapStr);
            }
        }
        BigDecimal bigDecimal = goodsAssistweight = ocContractDomain.getGoodsAssistweight() == null ? BigDecimal.ZERO : ocContractDomain.getGoodsAssistweight();
        if (goodsAssistweight.compareTo(BigDecimal.ZERO) > 0) {
            List<OcContractSettlDomain> ocContractSettlList;
            BigDecimal contractPrice;
            List skuNoList = goodsList.stream().map(OcContractGoodsDomain::getSkuNo).distinct().collect(Collectors.toList());
            String join = org.apache.commons.lang3.StringUtils.join(skuNoList, (String)",");
            BigDecimal bigDecimal2 = contractPrice = ocContractDomain.getContractPriceMarkup() == null ? BigDecimal.ZERO : ocContractDomain.getContractPriceMarkup();
            if (goodsAssistweight.compareTo(BigDecimal.ZERO) > 0) {
                contractMap = Maps.newHashMap();
                contractMap.put("promotionid", "contract");
                contractMap.put("promotiondesc", "\u5408\u540c\u52a0\u4ef7");
                contractMap.put("promotiongoods", join);
                contractMap.put("promotiongift", "");
                contractMap.put("promotionnumrate", "");
                contractMap.put("promotionprice", goodsAssistweight);
                contractMap.put("order_id", ocContractDomain.getContractBillcode());
                orderPromotionData.add(contractMap);
            }
            if (ListUtil.isNotEmpty(ocContractSettlList = ocContractDomain.getOcContractSettlList())) {
                for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
                    if ("jfc".equals(ocContractSettlDomain.getContractSettlBlance())) {
                        String join1 = String.join((CharSequence)",", skujfcNoList);
                        HashMap baseAndAuxiliaryMaterialsMap = Maps.newHashMap();
                        baseAndAuxiliaryMaterialsMap.put("promotionid", "jfc");
                        baseAndAuxiliaryMaterialsMap.put("promotiondesc", ocContractSettlDomain.getContractSettlOpemo());
                        baseAndAuxiliaryMaterialsMap.put("promotiongoods", join1);
                        baseAndAuxiliaryMaterialsMap.put("promotiongift", "");
                        baseAndAuxiliaryMaterialsMap.put("promotionnumrate", "");
                        baseAndAuxiliaryMaterialsMap.put("promotionprice", ocContractSettlDomain.getContractSettlGmoney());
                        baseAndAuxiliaryMaterialsMap.put("order_id", ocContractDomain.getContractBillcode());
                        orderPromotionData.add(baseAndAuxiliaryMaterialsMap);
                    }
                    if (!"dzp".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
                    HashMap lowValueMap = Maps.newHashMap();
                    lowValueMap.put("promotionid", "dzp");
                    lowValueMap.put("promotiondesc", "\u4f4e\u503c\u54c1\u52a0\u4ef7");
                    lowValueMap.put("promotiongoods", ocContractSettlDomain.getContractSettlOpno());
                    lowValueMap.put("promotiongift", "");
                    lowValueMap.put("promotionnumrate", "");
                    lowValueMap.put("promotionprice", ocContractSettlDomain.getContractSettlGmoney());
                    lowValueMap.put("order_id", ocContractDomain.getContractBillcode());
                    orderPromotionData.add(lowValueMap);
                }
            }
        }
        orderMainData.put("orderSubData", orderSubData);
        orderMainData.put("orderDescData", orderDescData);
        try {
            orderMainData.put("sign", SignUtil.getSign(createOrderInfo));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".createBusOrder.sign", (Object)JsonUtil.buildNormalBinder().toJson(createOrderInfo));
            return "error";
        }
        orderMainData.put("orderPromotionData", orderPromotionData);
        Long startTime = System.currentTimeMillis();
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".createBusOrder.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
            return "error";
        }
        logger.error(this.SYS_CODE + ".createBusOrder.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(map), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".createBusOrder.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("data");
        if (null != code) {
            Map returnResultsCodeMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(code), String.class, Object.class);
            if (MapUtil.isEmpty((Map)returnResultsCodeMap)) {
                return "error";
            }
            Object code1 = returnResultsCodeMap.get("code");
            if (null != code1 && code1.equals("0")) {
                return "success";
            }
            return "error";
        }
        logger.error(this.SYS_CODE + ".createBusOrder.code" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
        return "error";
    }

    public String makeCreateOcOrder(Map<String, OcContractGoodsDomain> contractGoodsDomainMap, List<String> stringList) {
        if (MapUtil.isEmpty(contractGoodsDomainMap) || ListUtil.isEmpty(stringList)) {
            logger.error(this.SYS_CODE + ".makeCreateOcOrder", (Object)(JsonUtil.buildNormalBinder().toJson(contractGoodsDomainMap) + "====" + JsonUtil.buildNormalBinder().toJson(stringList)));
            return null;
        }
        String str = "";
        int size = stringList.size();
        for (int a = 0; a < size; ++a) {
            String b;
            String string = stringList.get(a);
            OcContractGoodsDomain ocContractGoodsDomain = contractGoodsDomainMap.get(string);
            if (a == size - 1) {
                if (null == ocContractGoodsDomain) continue;
                b = ocContractGoodsDomain.getGoodsCamount() + "\u4ef6" + ocContractGoodsDomain.getSkuNo() + "(" + ocContractGoodsDomain.getGoodsName() + ")";
                str = str + b;
                continue;
            }
            if (null == ocContractGoodsDomain) continue;
            b = ocContractGoodsDomain.getGoodsCamount() + "\u4ef6" + ocContractGoodsDomain.getSkuNo() + "(" + ocContractGoodsDomain.getGoodsName() + ")\u548c";
            str = str + b;
        }
        return str;
    }

    @Override
    public String sendQueryBusOrderAccount(Map<String, Object> map2) {
        logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.map", (Object)JsonUtil.buildNormalBinder().toJson(map2));
        if (MapUtil.isEmpty(map2)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map2.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "initPay");
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("initPayInfo", map1);
        map1.put("sdfid", map2.get("sdfid"));
        map1.put("syb", map2.get("syb"));
        map1.put("contractid", map2.get("contractid"));
        map1.put("apa", map2.get("apa"));
        map1.put("order_id", map2.get("order_id"));
        String data = null;
        logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.returnResultsMap" + map, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderAccount.code" + map, (Object)data);
        return null;
    }

    @Override
    public String sendOrderPayPercent(Map<String, Object> map2) {
        logger.error(this.SYS_CODE + ".sendOrderPayPercent.map", (Object)JsonUtil.buildNormalBinder().toJson(map2));
        if (MapUtil.isEmpty(map2)) {
            logger.error(this.SYS_CODE + ".sendOrderPayPercent.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map2.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendOrderPayPercent.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendOrderPayPercent\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "getOrderPayPercent");
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("orderPayPercentInfo", map1);
        map1.put("orderNo", map2.get("orderNo"));
        String data = null;
        logger.error(this.SYS_CODE + ".sendOrderPayPercent.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendOrderPayPercent.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendOrderPayPercent.returnResultsMap" + map, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendOrderPayPercent.code" + map, (Object)data);
        return null;
    }

    @Override
    public String updateAccountNoMarkUp(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".updateAccountNoMarkUp.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".updateAccountNoMarkUp.ocContractDomain", (Object)"isnull");
            return "error";
        }
        BigDecimal scontractRefnum = BigDecimal.ZERO;
        String ddTypeCurrency = ocContractDomain.getDdTypeCurrency();
        if (!"true".equals(ddTypeCurrency)) {
            return "success";
        }
        scontractRefnum = BigDecimal.ONE.negate();
        HashMap map = Maps.newHashMap();
        try {
            map.put("scontractCode", ocContractDomain.getMemberGname());
            map.put("tenantCode", ocContractDomain.getTenantCode());
            map.put("scontractRefnum", "-1");
            this.internalInvoke("sp.scontract.updateScontractNoMarkUp", map);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".updateAccountNoMarkUpl" + map, (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendQueryCustInfoAction(Map<String, Object> map) {
        logger.error(this.SYS_CODE + ".sendQueryCustInfoAction.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (MapUtil.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryCustInfoAction.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryCustInfoAction.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "CustInfoAction", "CustInfoAction");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryCustInfoAction\uff0curl", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        LinkedHashMap map1 = new LinkedHashMap();
        map.put("syntype", map.get("syntype"));
        map.put("userid", map.get("userid"));
        logger.error(this.SYS_CODE + ".sendQueryCustInfoAction.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(map));
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map1));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.returnResultsMap" + map, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.code" + map, (Object)data);
        return null;
    }

    @Override
    public String sendQueryBusOrderDepartmentAccount(Map<String, Object> map2) {
        logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.map", (Object)JsonUtil.buildNormalBinder().toJson(map2));
        if (MapUtil.isEmpty(map2)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map2.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "getUserAcc");
        LinkedHashMap<String, Object> map1 = new LinkedHashMap<String, Object>();
        map.put("userAccInfo", map1);
        map1.put("syb", map2.get("syb"));
        map1.put("customer", map2.get("customer"));
        map1.put("contract", map2.get("contract"));
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.isnull" + url, map, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.map1" + map, (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.returnResultsMap", (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderDepartmentAccount.code", (Object)data);
        return null;
    }

    @Override
    public String sendQueryBusOrderQianjindingLine(Map<String, Object> map2) {
        logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingLine.map", (Object)JsonUtil.buildNormalBinder().toJson(map2));
        if (MapUtil.isEmpty(map2)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingLine.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map2.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingLine.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingLine\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "qianjinding");
        LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
        mapStr.put("synType", "credit");
        mapStr.put("userCode", map2.get("userCode"));
        mapStr.put("productCode", "");
        mapStr.put("merchantBizCode", "");
        mapStr.put("qjdOrderCode", "");
        mapStr.put("orderCode", "");
        mapStr.put("totalAmount", "");
        mapStr.put("ip", "");
        map.put("qianjindingInfo", mapStr);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingLine.isnull" + url, map, (Throwable)e);
            return null;
        }
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingLine.returnResultsMap" + url + "map" + map, (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingLine.returnResultsMapStr" + url + "map" + map, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingLine.code" + url + "map" + map, (Object)data);
        return null;
    }

    @Override
    public String sendQueryBusOrderQianjindingProductCodeLine(Map<String, Object> map2) {
        logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingProductCodeLine.map", (Object)JsonUtil.buildNormalBinder().toJson(map2));
        if (MapUtil.isEmpty(map2)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingProductCodeLine.map", (Object)"isnull");
            return null;
        }
        String tenantCode = (String)map2.get("tenantCode");
        if (StringUtils.isEmpty((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingProductCodeLine.tenantCode", (Object)"isnull");
            return null;
        }
        String url = this.getUrl(tenantCode, "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingProductCodeLine\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return null;
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "qianjinding");
        LinkedHashMap<String, Object> mapStr = new LinkedHashMap<String, Object>();
        mapStr.put("synType", "product");
        mapStr.put("userCode", map2.get("userCode"));
        mapStr.put("productCode", "");
        mapStr.put("merchantBizCode", map2.get("merchantBizCode").toString().substring(0, 2) + "00");
        mapStr.put("qjdOrderCode", "");
        mapStr.put("orderCode", "");
        mapStr.put("totalAmount", "");
        mapStr.put("ip", "");
        map.put("qianjindingInfo", mapStr);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingProductCodeLine.isnull" + url, map, (Throwable)e);
            return null;
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingProductCodeLine.returnResultsMap" + url + "map" + map, (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingProductCodeLine.returnResultsMap" + url + "map" + map, (Object)data);
            return null;
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            Map dataMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(returnResultsMap.get("data")), String.class, Object.class);
            return JsonUtil.buildNormalBinder().toJson((Object)dataMap);
        }
        logger.error(this.SYS_CODE + ".sendQueryBusOrderQianjindingProductCodeLine.code" + url + "map" + map, (Object)data);
        return null;
    }

    @Override
    public String sendCreateBusOrderCancel(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderCancel.map", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "getUserAcc", "getUserAcc");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderCancel\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "orderReturn");
        LinkedHashMap<String, String> mapStr = new LinkedHashMap<String, String>();
        mapStr.put("orderNo", ocContractDomain.getContractBillcode());
        map.put("orderReturnInfo", mapStr);
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderCancel.isnull" + url, map, (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrdsendCreateBusOrderCancelerStatus.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderCancel.returnResultsMap" + url + "map" + map, (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            return "success";
        }
        logger.error(this.SYS_CODE + ".sendCreateBusOrderCancel.code" + url + "map" + map, (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendCreateSgGoodsCancel(SgSendgoodsDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendCreateSgGoodsCancel.sgSendgoodsDomain", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)sgSendgoodsDomain));
            return "error";
        }
        if (ListUtil.isEmpty(sgSendgoodsDomain.getSgSendgoodsGoodsDomainList())) {
            logger.error(this.SYS_CODE + ".sendCreateSgGoodsCancel.sgSendgoodsGoodsDomainList", (Object)JsonUtil.buildNonDefaultBinder().toJson(sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()));
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        String sksurl = this.getUrl("606480622092365916", "sksgoodscenter", "sksgoodscenter");
        String apikey = this.getUrl("606480622092365916", "sksgoodscapikey", "sksgoodscapikey");
        String url = sksurl + "/basicInfo/distributeSplitOrder?apikey=" + apikey;
        ArrayList mapList = new ArrayList();
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("bomid", sgSendgoodsGoodsDomain.getSkuNo());
            map.put("quantity", sgSendgoodsGoodsDomain.getSendgoodsGoodsCamount());
            map.put("orderNo", sgSendgoodsGoodsDomain.getContractBillcode());
            map.put("estimatedShipDate", sgSendgoodsGoodsDomain.getDataPicpath());
            map.put("shippingLeadTimeInDays", sgSendgoodsGoodsDomain.getMemberContactPhone());
            map.put("earliestShipDate", sgSendgoodsGoodsDomain.getMemberContactQq());
            map.put("sendgoodsGoodsCode", sgSendgoodsGoodsDomain.getSendgoodsGoodsCode());
            mapList.add(map);
        }
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(mapList));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateSgGoodsCancel.isnull" + url, mapList, (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendCreateSgGoodsCancel.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(mapList) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendCreateSgGoodsCancel.returnResultsMap" + url + "mapList" + mapList, (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            return "success";
        }
        logger.error(this.SYS_CODE + ".sendCreateSgGoodsCancel.code" + url + "mapList" + mapList, (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    protected String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    @Override
    public String sendSaveBusOrderStatus(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderStatus.map", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "orderStatusInfo", "orderStatusInfo");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderStatus\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        UmUserinfoReDomain userinfoByUserinfoCode = this.getUserinfoByUserinfoCode(ocContractDomain.getMemberBcode(), ocContractDomain.getTenantCode());
        if (null == userinfoByUserinfoCode) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderStatus.userinfoByUserinfoCode", (Object)"isnull");
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "orderStatus");
        LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
        map.put("orderStatusInfo", map1);
        map1.put("submitterId", userinfoByUserinfoCode.getMemberMcode());
        map1.put("orderNo", ocContractDomain.getContractBillcode());
        map1.put("status", "1");
        map1.put("remark", "\u65b0\u62a5\u8d27\u7cfb\u7edf\u5df2\u4ed8\u6b3e");
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderStatus.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderStatus.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderStatus.returnResultsMap" + url + "map" + map, (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            return "success";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderStatus.code" + url + "map" + map, (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendSaveBusOrderReturn(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderReturn.map", (Object)"isnull");
            return "error";
        }
        String url = this.getUrl(ocContractDomain.getTenantCode(), "orderStatusInfo", "orderStatusInfo");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderReturn\uff0curk", (Object)"\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        Long startTime = System.currentTimeMillis();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("action", "orderReturn");
        LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
        map.put("orderReturnInfo", map1);
        map1.put("orderNo", ocContractDomain.getContractBillcode());
        map1.put("returnact", "2");
        if ("returnact".equals(ocContractDomain.getOaflag())) {
            map1.put("returnact", "1");
        }
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderReturn.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(map), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderReturn.data" + data + "url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(map) + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderReturn.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            if ("returnact".equals(ocContractDomain.getOaflag())) {
                map1.put("returnact", "1");
                ArrayList<OcContractReDomain> messageList = new ArrayList<OcContractReDomain>();
                messageList.add(ocContractDomain);
                this.sendMessageTypeWechat(messageList);
            }
            return "success";
        }
        logger.error(this.SYS_CODE + ".sendSaveBusOrderReturn.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(map), (Object)returnResultsMap.toString());
        return "error";
    }

    public String sendMessageTypeWechat(List<OcContractReDomain> messageList) {
        if (CollectionUtils.isEmpty(messageList)) {
            logger.error(this.SYS_CODE + ".sendMessageTypeWechat.messageList", (Object)"isnull");
            return "error";
        }
        ArrayList<WorkPushMessage> messages = new ArrayList<WorkPushMessage>();
        for (OcContractReDomain ocContractReDomain : messageList) {
            WorkPushMessage workPushMessage = new WorkPushMessage();
            CtCustrelReDomain ctCustrelReDomain = null;
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            newMap.put("tenantCode", ocContractReDomain.getTenantCode());
            newMap.put("userinfoOpcode", ocContractReDomain.getMemberBcode());
            newMap.put("userinfoOpcode2", ocContractReDomain.getDepartCode());
            newMap.put("custrelFeestatus", "1");
            QueryResult<CtCustrelReDomain> ctCustrelReDomainQueryResult = this.queryCustrelPage(newMap);
            if (ListUtil.isNotEmpty((Collection)ctCustrelReDomainQueryResult.getList())) {
                ctCustrelReDomain = (CtCustrelReDomain)ctCustrelReDomainQueryResult.getList().get(0);
                workPushMessage.setContent("**\u8ba2\u5355\u652f\u4ed8\u8d85\u65f6\u5173\u95ed\u901a\u77e5**\n\n" + ocContractReDomain.getContractBbillcode() + "-" + ocContractReDomain.getMemberBname() + "-" + ctCustrelReDomain.getDepartName() + "\uff0c\u60a8\u6240\u670d\u52a1\u7684\u5ba2\u6237\u8ba2\u5355\u5df2\u8d8515\u5929\u672a\u4ed8\u6b3e\u8fdb\u884c\u5173\u95ed\u3002\u5982\u6709\u9700\u8981\u8bf7\u91cd\u65b0\u521b\u5efa\u65b0\u8ba2\u5355\u3002\u611f\u8c22\u60a8\u7684\u7406\u89e3\u548c\u652f\u6301\uff01");
                workPushMessage.setOrderno(ocContractReDomain.getContractBbillcode());
                workPushMessage.setPushTo(ocContractReDomain.getEmployeeName());
                workPushMessage.setMessageType("2");
                messages.add(workPushMessage);
            }
            String string = ocContractReDomain.getTenantCode();
        }
        String tenantCode = messageList.get(0).getTenantCode();
        String url = this.getUrl(tenantCode, "wechatmessage", "wechatmessage");
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(messages));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendMessageTypeWechat.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(messages), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendMessageTypeWechat.data" + data + "url" + url, (Object)JsonUtil.buildNormalBinder().toJson(messages));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendMessageTypeWechat.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(messages), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            return "success";
        }
        logger.error(this.SYS_CODE + ".sendMessageTypeWechat.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(messages), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String sendMessageWechat(List<OcContractReDomain> messageList, String day) {
        if (CollectionUtils.isEmpty(messageList)) {
            logger.error(this.SYS_CODE + ".sendMessageToWechat.messageList", (Object)"isnull");
            return "error";
        }
        ArrayList<WorkPushMessage> messages = new ArrayList<WorkPushMessage>();
        for (OcContractReDomain ocContractReDomain : messageList) {
            WorkPushMessage workPushMessage = new WorkPushMessage();
            CtCustrelReDomain ctCustrelReDomain = null;
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            newMap.put("tenantCode", ocContractReDomain.getTenantCode());
            newMap.put("userinfoOpcode", ocContractReDomain.getMemberBcode());
            newMap.put("userinfoOpcode2", ocContractReDomain.getDepartCode());
            newMap.put("custrelFeestatus", "1");
            QueryResult<CtCustrelReDomain> ctCustrelReDomainQueryResult = this.queryCustrelPage(newMap);
            if (ListUtil.isNotEmpty((Collection)ctCustrelReDomainQueryResult.getList())) {
                ctCustrelReDomain = (CtCustrelReDomain)ctCustrelReDomainQueryResult.getList().get(0);
                workPushMessage.setContent("**\u8ba2\u5355\u652f\u4ed8\u5012\u8ba1\u65f615\u5929\u9884\u8b66\u901a\u77e5**\n\n" + ocContractReDomain.getContractBbillcode() + "-" + ocContractReDomain.getMemberBname() + "-" + ctCustrelReDomain.getDepartName() + "\uff0c\u60a8\u6240\u670d\u52a1\u7684\u5ba2\u6237\u8ba2\u5355\u672a\u4ed8\u6b3e\u5012\u8ba1\u65f6\u6700\u540e" + day + "\u5929\u5373\u5c06\u5173\u95ed\uff0c\u8bf7\u52a1\u5fc5\u548c\u5ba2\u6237\u8054\u7cfb\u786e\u4fdd\u5b8c\u6210\u8ba2\u5355\u4ed8\u6b3e\uff0c\u907f\u514d\u5f71\u54cd\u8ba2\u5355\u8fdb\u5ea6\u3002\u611f\u8c22\u60a8\u7684\u7406\u89e3\u548c\u652f\u6301\uff01");
                workPushMessage.setOrderno(ocContractReDomain.getContractBbillcode());
                workPushMessage.setPushTo(ocContractReDomain.getEmployeeName());
                workPushMessage.setMessageType("1");
                messages.add(workPushMessage);
            }
            String string = ocContractReDomain.getTenantCode();
        }
        String tenantCode = messageList.get(0).getTenantCode();
        String url = this.getUrl(tenantCode, "wechatmessage", "wechatmessage");
        String data = null;
        try {
            data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(messages));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendMessageToWechat.isnull" + url, (Object)JsonUtil.buildNormalBinder().toJson(messages), (Throwable)e);
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendMessageToWechat.data" + data + "url" + url, (Object)JsonUtil.buildNormalBinder().toJson(messages));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendMessageToWechat.returnResultsMap" + url + "map" + JsonUtil.buildNormalBinder().toJson(messages), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("code");
        if (null != code && code.equals("200")) {
            return "success";
        }
        logger.error(this.SYS_CODE + ".sendMessageToWechat.code" + url + "map" + JsonUtil.buildNormalBinder().toJson(messages), (Object)returnResultsMap.toString());
        return "error";
    }

    @Override
    public String updateSgGoods(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".updateSgGoods.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream) || StringUtils.isBlank((String)tenantCode)) {
            return this.makeErrorReturn(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        String warehouseCode = JsonUtil.buildNormalBinder().toJson(resStream.get("warehouseCode"));
        String sendgoodsGoodsCode = JsonUtil.buildNormalBinder().toJson(resStream.get("sendgoodsGoodsCode"));
        String warehouseName = JsonUtil.buildNormalBinder().toJson(resStream.get("warehouseName"));
        HashMap map = Maps.newHashMap();
        map.put("tenantCode", tenantCode);
        map.put("sendgoodsGoodsCode", sendgoodsGoodsCode);
        String sgsendGoods = null;
        try {
            sgsendGoods = this.internalInvoke("sg.sendgoods.getSendgoodsGoodsByCode", map);
            if (null != sgsendGoods) {
                SgSendgoodsGoodsDomain sendgoodsGoodsDomain = (SgSendgoodsGoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(sgsendGoods, SgSendgoodsGoodsDomain.class);
                HashMap hashMap = Maps.newHashMap();
                sendgoodsGoodsDomain.setWarehouseCode(warehouseCode);
                sendgoodsGoodsDomain.setWarehouseName(warehouseName);
                hashMap.put("sgSendgoodsGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sendgoodsGoodsDomain));
                this.internalInvoke("sg.sendgoods.updateSendgoodsGoods", hashMap);
                return this.makeSuccessReturn(sendgoodsGoodsDomain.getSendgoodsGoodsCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.makeErrorReturn(sendgoodsGoodsCode, "\u66f4\u65b0\u5931\u8d25");
    }

    public QueryResult<CtCustrelReDomain> queryCustrelPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "ct.custrel.queryCustrelPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, CtCustrelReDomain.class);
    }

    public UmUserinfoReDomain getUserinfoByUserinfoCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        return (UmUserinfoReDomain)this.getForObject(apiCode, UmUserinfoReDomain.class, paramMap);
    }

    public QueryResult<UmAddressReDomain> queryAddressPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.address.queryAddressPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmAddressReDomain.class);
    }

    public QueryResult<UmUser> queryUserPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "um.user.queryUserPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, UmUser.class);
    }

    public QueryResult<OcContractPmGoods> queryContractPmGoodsPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String apiCode = "oc.ContractPmGoods.queryContractPmGoodsPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractPmGoods.class);
    }

    public void makeOcContractGoodsDomain(OcContractGoodsDomain ocContractGoodsDomain, Map<String, RsClasstreeDomain> rsClasstreeMap) {
        RsClasstreeDomain rsClasstreeByCode;
        if (null == ocContractGoodsDomain) {
            logger.error(this.SYS_CODE + ".makeOcContractGoodsDomain.null");
            return;
        }
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getClasstreeShopcode())) {
            if (null != rsClasstreeMap.get(ocContractGoodsDomain.getClasstreeShopcode())) {
                rsClasstreeByCode = rsClasstreeMap.get(ocContractGoodsDomain.getClasstreeShopcode());
                ocContractGoodsDomain.setClasstreeShopcode(rsClasstreeByCode.getClasstreeEocode());
            } else {
                rsClasstreeByCode = this.getRsClasstreeByCode(ocContractGoodsDomain.getClasstreeShopcode(), ocContractGoodsDomain.getTenantCode());
                if (null != rsClasstreeByCode) {
                    rsClasstreeMap.put(ocContractGoodsDomain.getClasstreeShopcode(), rsClasstreeByCode);
                    ocContractGoodsDomain.setClasstreeShopcode(rsClasstreeByCode.getClasstreeEocode());
                }
            }
        }
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getClasstreeShopname())) {
            if (null != rsClasstreeMap.get(ocContractGoodsDomain.getClasstreeShopname())) {
                rsClasstreeByCode = rsClasstreeMap.get(ocContractGoodsDomain.getClasstreeShopname());
                ocContractGoodsDomain.setClasstreeShopname(rsClasstreeByCode.getClasstreeEocode());
            } else {
                rsClasstreeByCode = this.getRsClasstreeByCode(ocContractGoodsDomain.getClasstreeShopname(), ocContractGoodsDomain.getTenantCode());
                if (null != rsClasstreeByCode) {
                    rsClasstreeMap.put(ocContractGoodsDomain.getClasstreeShopname(), rsClasstreeByCode);
                    ocContractGoodsDomain.setClasstreeShopname(rsClasstreeByCode.getClasstreeEocode());
                }
            }
        }
        if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getClasstreeCode())) {
            if (null != rsClasstreeMap.get(ocContractGoodsDomain.getClasstreeCode())) {
                rsClasstreeByCode = rsClasstreeMap.get(ocContractGoodsDomain.getClasstreeCode());
                ocContractGoodsDomain.setClasstreeCode(rsClasstreeByCode.getClasstreeEocode());
            } else {
                rsClasstreeByCode = this.getRsClasstreeByCode(ocContractGoodsDomain.getClasstreeCode(), ocContractGoodsDomain.getTenantCode());
                if (null != rsClasstreeByCode) {
                    rsClasstreeMap.put(ocContractGoodsDomain.getClasstreeCode(), rsClasstreeByCode);
                    ocContractGoodsDomain.setClasstreeCode(rsClasstreeByCode.getClasstreeEocode());
                }
            }
        }
    }

    public Map makeMap(String goodsRemark) {
        HashMap map = new HashMap();
        if (StringUtils.isEmpty((String)goodsRemark)) {
            logger.error(this.SYS_CODE + ".makeMap.null");
            return map;
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(goodsRemark, String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            logger.error(this.SYS_CODE + ".makeMap.jsonToMap");
            return jsonToMap;
        }
        return jsonToMap;
    }

    public static String getMessage(String code) {
        switch (code) {
            case "002": {
                return "\u5ba2\u6237\u59d4\u6258\u81ea\u63d0\uff0c\u8fd0\u8d39\u81ea\u4ed8";
            }
            case "009": {
                return "\u9001\u8d27\u4e0a\u95e8";
            }
            case "026": {
                return "\u5927\u79b9\uff1a\u8fd0\u8d39\u5404\u4ed8\u4e00\u534a";
            }
            case "027": {
                return "\u5927\u79b9\uff1a\u4ee3\u5ba2\u6237\u57ab\u4ed8\u8fd0\u8d39";
            }
        }
        return "";
    }

    public RsClasstreeDomain getRsClasstreeByCode(String classtreeCode, String tenantCode) {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getRsClasstreeByCode.null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("classtreeCode", classtreeCode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        return (RsClasstreeDomain)this.getForObject("rs.rsClasstree.getClasstreeByCode", RsClasstreeDomain.class, paramMap);
    }

    public UmUserinfoDomainBean getUserinfoOcodeUmUserinfoDomainBean(String tenantCode, String userinfoOcode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoOcode", userinfoOcode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl("um.user.queryUserinfoPage", invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            logger.error(this.SYS_CODE + ".getUserinfoOcodeUmUserinfoDomainBean", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }

    public String getSksRespriceColorprice(String colorno, String tenantCode) {
        if (StringUtils.isBlank((String)colorno) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getSksRespriceColorprice.null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestid", colorno);
        map.put("tenantCode", tenantCode);
        QueryResult<SksRespriceColorprice> sksRespriceColorpriceQueryResult = this.sksRespriceColorpriceService.queryrespricecolorpricePage(map);
        if (ListUtil.isNotEmpty((Collection)sksRespriceColorpriceQueryResult.getList())) {
            return ((SksRespriceColorprice)sksRespriceColorpriceQueryResult.getList().get(0)).getColorname();
        }
        logger.error(this.SYS_CODE + ".getSksRespriceColorprice.map", map);
        return null;
    }

    public static void main222(String[] args) {
    }
}

