/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksComboConfigMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksComboConfigDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksComboConfigReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksComboConfig;
import com.yqbsoft.laser.service.ext.skshu.service.SksComboConfigService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SksComboConfigServiceImpl
extends BaseServiceImpl
implements SksComboConfigService {
    private static final String SYS_CODE = "SKS.SksComboConfigServiceImpl";
    private SksComboConfigMapper sksComboConfigMapper;

    public void setSksComboConfigMapper(SksComboConfigMapper sksComboConfigMapper) {
        this.sksComboConfigMapper = sksComboConfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksComboConfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksComboConfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkcomboConfig(SksComboConfigDomain sksComboConfigDomain) {
        if (null == sksComboConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksComboConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setcomboConfigDefault(SksComboConfig sksComboConfig) {
        if (null == sksComboConfig) {
            return;
        }
        if (null == sksComboConfig.getDataState()) {
            sksComboConfig.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksComboConfig.getGmtCreate()) {
            sksComboConfig.setGmtCreate(date);
        }
        sksComboConfig.setGmtModified(date);
        if (StringUtils.isBlank((String)sksComboConfig.getRequestid())) {
            sksComboConfig.setRequestid(this.getNo(null, "SksComboConfig", "sksComboConfig", sksComboConfig.getTenantCode()));
        }
    }

    private int getcomboConfigMaxCode() {
        int code = 0;
        try {
            return this.sksComboConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksComboConfigServiceImpl.getcomboConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setcomboConfigUpdataDefault(SksComboConfig sksComboConfig) {
        if (null == sksComboConfig) {
            return;
        }
        sksComboConfig.setGmtModified(this.getSysDate());
    }

    private void savecomboConfigModel(SksComboConfig sksComboConfig) throws ApiException {
        if (null == sksComboConfig) {
            return;
        }
        try {
            this.sksComboConfigMapper.insert(sksComboConfig);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.savecomboConfigModel.ex", (Throwable)e);
        }
    }

    private void savecomboConfigBatchModel(List<SksComboConfig> sksComboConfigList) throws ApiException {
        if (null == sksComboConfigList || sksComboConfigList.isEmpty()) {
            return;
        }
        try {
            this.sksComboConfigMapper.insertBatch(sksComboConfigList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.savecomboConfigBatchModel.ex", (Throwable)e);
        }
    }

    private SksComboConfig getcomboConfigModelById(String id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksComboConfigMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksComboConfigServiceImpl.getcomboConfigModelById", (Throwable)e);
            return null;
        }
    }

    private SksComboConfig getcomboConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksComboConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksComboConfigServiceImpl.getcomboConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delcomboConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksComboConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.delcomboConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.delcomboConfigModelByCode.num");
        }
    }

    private void deletecomboConfigModel(String id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksComboConfigMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.deletecomboConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.deletecomboConfigModel.num");
        }
    }

    private void updatecomboConfigModel(SksComboConfig sksComboConfig) throws ApiException {
        if (null == sksComboConfig) {
            return;
        }
        int i = 0;
        try {
            i = this.sksComboConfigMapper.updateByPrimaryKey(sksComboConfig);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.updatecomboConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.updatecomboConfigModel.num");
        }
    }

    private void updateStatecomboConfigModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksComboConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.updateStatecomboConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.updateStatecomboConfigModel.null");
        }
    }

    private void updateStatecomboConfigModelByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksComboConfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.updateStatecomboConfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.updateStatecomboConfigModelByCode.null");
        }
    }

    private SksComboConfig makecomboConfig(SksComboConfigDomain sksComboConfigDomain, SksComboConfig sksComboConfig) {
        if (null == sksComboConfigDomain) {
            return null;
        }
        if (null == sksComboConfig) {
            sksComboConfig = new SksComboConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksComboConfig, (Object)sksComboConfigDomain);
            return sksComboConfig;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksComboConfigServiceImpl.makecomboConfig", (Throwable)e);
            return null;
        }
    }

    private SksComboConfigReDomain makeSksComboConfigReDomain(SksComboConfig sksComboConfig) {
        if (null == sksComboConfig) {
            return null;
        }
        SksComboConfigReDomain sksComboConfigReDomain = new SksComboConfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksComboConfigReDomain, (Object)sksComboConfig);
            return sksComboConfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksComboConfigServiceImpl.makeSksComboConfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksComboConfig> querycomboConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.sksComboConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksComboConfigServiceImpl.querycomboConfigModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<SksComboConfig> queryRelevantComboConfigList(Map<String, Object> parammap) {
        try {
            return this.sksComboConfigMapper.queryRelevantComboConfigList(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksComboConfigServiceImpl.querycomboConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countcomboConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksComboConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksComboConfigServiceImpl.countcomboConfig", (Throwable)e);
        }
        return i;
    }

    private SksComboConfig createSksComboConfig(SksComboConfigDomain sksComboConfigDomain) {
        String msg = this.checkcomboConfig(sksComboConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.savecomboConfig.checkcomboConfig", msg);
        }
        SksComboConfig sksComboConfig = this.makecomboConfig(sksComboConfigDomain, null);
        this.setcomboConfigDefault(sksComboConfig);
        return sksComboConfig;
    }

    @Override
    public String savecomboConfig(SksComboConfigDomain sksComboConfigDomain) throws ApiException {
        SksComboConfig sksComboConfig = this.createSksComboConfig(sksComboConfigDomain);
        this.savecomboConfigModel(sksComboConfig);
        return sksComboConfig.getRequestid();
    }

    @Override
    public String savecomboConfigBatch(List<SksComboConfigDomain> sksComboConfigDomainList) throws ApiException {
        if (null == sksComboConfigDomainList || sksComboConfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksComboConfig> sksComboConfigList = new ArrayList<SksComboConfig>();
        String code = "";
        for (SksComboConfigDomain sksComboConfigDomain : sksComboConfigDomainList) {
            SksComboConfig sksComboConfig = this.createSksComboConfig(sksComboConfigDomain);
            code = sksComboConfig.getRequestid();
            sksComboConfigList.add(sksComboConfig);
        }
        this.savecomboConfigBatchModel(sksComboConfigList);
        return code;
    }

    @Override
    public void updatecomboConfigState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStatecomboConfigModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updatecomboConfigStateByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatecomboConfigModelByCode(tenantCode, requestid, dataState, oldDataState, map);
    }

    @Override
    public void updatecomboConfig(SksComboConfigDomain sksComboConfigDomain) throws ApiException {
        String msg = this.checkcomboConfig(sksComboConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.updatecomboConfig.checkcomboConfig", msg);
        }
        SksComboConfig oldSksComboConfig = this.getcomboConfigModelById(sksComboConfigDomain.getId());
        if (null == oldSksComboConfig) {
            throw new ApiException("SKS.SksComboConfigServiceImpl.updatecomboConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksComboConfig sksComboConfig = this.makecomboConfig(sksComboConfigDomain, oldSksComboConfig);
        this.setcomboConfigUpdataDefault(sksComboConfig);
        this.updatecomboConfigModel(sksComboConfig);
    }

    @Override
    public SksComboConfig getcomboConfig(String id) {
        if (null == id) {
            return null;
        }
        return this.getcomboConfigModelById(id);
    }

    @Override
    public void deletecomboConfig(String id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deletecomboConfigModel(id);
    }

    @Override
    public QueryResult<SksComboConfig> querycomboConfigPage(Map<String, Object> map) {
        List<SksComboConfig> sksComboConfigList = this.querycomboConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countcomboConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksComboConfigList);
        return queryResult;
    }

    @Override
    public SksComboConfig getcomboConfigByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getcomboConfigModelByCode(map);
    }

    @Override
    public void deletecomboConfigByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delcomboConfigModelByCode(map);
    }
}

