/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.skshu.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.skshu.dao.SksDistributionMapper;
import com.yqbsoft.laser.service.ext.skshu.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksDistributionDomain;
import com.yqbsoft.laser.service.ext.skshu.domain.sks.SksDistributionReDomain;
import com.yqbsoft.laser.service.ext.skshu.model.SksDistribution;
import com.yqbsoft.laser.service.ext.skshu.service.SksDistributionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SksDistributionServiceImpl
extends BaseServiceImpl
implements SksDistributionService {
    private static final String SYS_CODE = "SKS.SksDistributionServiceImpl";
    private SksDistributionMapper sksDistributionMapper;
    @Autowired
    private SksDistributionService sksDistributionService;

    public void setSksDistributionMapper(SksDistributionMapper sksDistributionMapper) {
        this.sksDistributionMapper = sksDistributionMapper;
    }

    private Date getSysDate() {
        try {
            return this.sksDistributionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksDistributionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDistribution(SksDistributionDomain sksDistributionDomain) {
        if (null == sksDistributionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sksDistributionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDistributionDefault(SksDistribution sksDistribution) {
        if (null == sksDistribution) {
            return;
        }
        if (null == sksDistribution.getDataState()) {
            sksDistribution.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == sksDistribution.getGmtCreate()) {
            sksDistribution.setGmtCreate(date);
        }
        sksDistribution.setGmtModified(date);
        if (StringUtils.isBlank((String)sksDistribution.getRequestid())) {
            sksDistribution.setRequestid(this.getNo(null, "SksDistribution", "sksDistribution", sksDistribution.getTenantCode()));
        }
    }

    private int getDistributionMaxCode() {
        int code = 0;
        try {
            return this.sksDistributionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("SKS.SksDistributionServiceImpl.getDistributionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDistributionUpdataDefault(SksDistribution sksDistribution) {
        if (null == sksDistribution) {
            return;
        }
        sksDistribution.setGmtModified(this.getSysDate());
    }

    private void saveDistributionModel(SksDistribution sksDistribution) throws ApiException {
        if (null == sksDistribution) {
            return;
        }
        try {
            this.sksDistributionMapper.insert(sksDistribution);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksDistributionServiceImpl.saveDistributionModel.ex", (Throwable)e);
        }
    }

    private void saveDistributionBatchModel(List<SksDistribution> sksDistributionList) throws ApiException {
        if (null == sksDistributionList || sksDistributionList.isEmpty()) {
            return;
        }
        try {
            this.sksDistributionMapper.insertBatch(sksDistributionList);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksDistributionServiceImpl.saveDistributionBatchModel.ex", (Throwable)e);
        }
    }

    private SksDistribution getDistributionModelById(Integer id) {
        if (null == id) {
            return null;
        }
        try {
            return this.sksDistributionMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksDistributionServiceImpl.getDistributionModelById", (Throwable)e);
            return null;
        }
    }

    private SksDistribution getDistributionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.sksDistributionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksDistributionServiceImpl.getDistributionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDistributionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.sksDistributionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksDistributionServiceImpl.delDistributionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksDistributionServiceImpl.delDistributionModelByCode.num");
        }
    }

    private void deleteDistributionModel(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.sksDistributionMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksDistributionServiceImpl.deleteDistributionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksDistributionServiceImpl.deleteDistributionModel.num");
        }
    }

    private void updateDistributionModel(SksDistribution sksDistribution) throws ApiException {
        if (null == sksDistribution) {
            return;
        }
        int i = 0;
        try {
            i = this.sksDistributionMapper.updateByPrimaryKey(sksDistribution);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksDistributionServiceImpl.updateDistributionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("SKS.SksDistributionServiceImpl.updateDistributionModel.num");
        }
    }

    private void updateStateDistributionModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksDistributionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksDistributionServiceImpl.updateStateDistributionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksDistributionServiceImpl.updateStateDistributionModel.null");
        }
    }

    private void updateStateDistributionModelByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.sksDistributionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("SKS.SksDistributionServiceImpl.updateStateDistributionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("SKS.SksDistributionServiceImpl.updateStateDistributionModelByCode.null");
        }
    }

    private SksDistribution makeDistribution(SksDistributionDomain sksDistributionDomain, SksDistribution sksDistribution) {
        if (null == sksDistributionDomain) {
            return null;
        }
        if (null == sksDistribution) {
            sksDistribution = new SksDistribution();
        }
        try {
            BeanUtils.copyAllPropertys((Object)sksDistribution, (Object)sksDistributionDomain);
            return sksDistribution;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksDistributionServiceImpl.makeDistribution", (Throwable)e);
            return null;
        }
    }

    private SksDistributionReDomain makeSksDistributionReDomain(SksDistribution sksDistribution) {
        if (null == sksDistribution) {
            return null;
        }
        SksDistributionReDomain sksDistributionReDomain = new SksDistributionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)sksDistributionReDomain, (Object)sksDistribution);
            return sksDistributionReDomain;
        }
        catch (Exception e) {
            this.logger.error("SKS.SksDistributionServiceImpl.makeSksDistributionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<SksDistribution> queryDistributionModelPage(Map<String, Object> parammap) {
        try {
            return this.sksDistributionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksDistributionServiceImpl.queryDistributionModel", (Throwable)e);
            return null;
        }
    }

    private int countDistribution(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.sksDistributionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("SKS.SksDistributionServiceImpl.countDistribution", (Throwable)e);
        }
        return i;
    }

    private SksDistribution createSksDistribution(SksDistributionDomain sksDistributionDomain) {
        String msg = this.checkDistribution(sksDistributionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksDistributionServiceImpl.saveDistribution.checkDistribution", msg);
        }
        SksDistribution sksDistribution = this.makeDistribution(sksDistributionDomain, null);
        this.setDistributionDefault(sksDistribution);
        return sksDistribution;
    }

    @Override
    public String saveDistribution(SksDistributionDomain sksDistributionDomain) throws ApiException {
        SksDistribution sksDistribution = this.createSksDistribution(sksDistributionDomain);
        this.saveDistributionModel(sksDistribution);
        return sksDistribution.getRequestid();
    }

    @Override
    public String saveDistributionBatch(List<SksDistributionDomain> sksDistributionDomainList) throws ApiException {
        if (null == sksDistributionDomainList || sksDistributionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<SksDistribution> sksDistributionList = new ArrayList<SksDistribution>();
        String code = "";
        for (SksDistributionDomain sksDistributionDomain : sksDistributionDomainList) {
            SksDistribution sksDistribution = this.createSksDistribution(sksDistributionDomain);
            code = sksDistribution.getRequestid();
            sksDistributionList.add(sksDistribution);
        }
        this.saveDistributionBatchModel(sksDistributionList);
        return code;
    }

    @Override
    public void updateDistributionState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateDistributionModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateDistributionStateByCode(String tenantCode, String requestid, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDistributionModelByCode(tenantCode, requestid, dataState, oldDataState, map);
    }

    @Override
    public void updateDistribution(SksDistributionDomain sksDistributionDomain) throws ApiException {
        String msg = this.checkDistribution(sksDistributionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("SKS.SksDistributionServiceImpl.updateDistribution.checkDistribution", msg);
        }
        SksDistribution oldSksDistribution = this.getDistributionModelById(sksDistributionDomain.getId());
        if (null == oldSksDistribution) {
            throw new ApiException("SKS.SksDistributionServiceImpl.updateDistribution.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        SksDistribution sksDistribution = this.makeDistribution(sksDistributionDomain, oldSksDistribution);
        this.setDistributionUpdataDefault(sksDistribution);
        this.updateDistributionModel(sksDistribution);
    }

    @Override
    public SksDistribution getDistribution(Integer id) {
        if (null == id) {
            return null;
        }
        return this.getDistributionModelById(id);
    }

    @Override
    public void deleteDistribution(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteDistributionModel(id);
    }

    @Override
    public QueryResult<SksDistribution> queryDistributionPage(Map<String, Object> map) {
        List<SksDistribution> sksDistributionList = this.queryDistributionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDistribution(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(sksDistributionList);
        return queryResult;
    }

    @Override
    public SksDistribution getDistributionByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        return this.getDistributionModelByCode(map);
    }

    @Override
    public void deleteDistributionByCode(String tenantCode, String requestid) throws ApiException {
        if (StringUtils.isBlank((String)requestid) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestid", requestid);
        this.delDistributionModelByCode(map);
    }

    protected RsClasstreeDomain getRsClasstreeByCode(String classtreeEocode, String tenantCode) {
        if (StringUtils.isBlank((String)classtreeEocode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("SKS.SksDistributionServiceImpl.getRsClasstreeByCode.null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("classtreeEocode", classtreeEocode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        return (RsClasstreeDomain)this.getForObject("rs.rsClasstree.getClasstreeByCode", RsClasstreeDomain.class, paramMap);
    }

    protected String makeErrorReturn(String errorCode, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", "-1");
        map.put("success", false);
        map.put("dataObj", errorCode);
        map.put("msg", msg);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    protected String makeSuccessReturn(Object dataObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", "200");
        map.put("success", true);
        map.put("dataObj", dataObj);
        map.put("msg", "\u6210\u529f");
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    public static void main(String[] args) {
        SksDistributionDomain sksDistributionDomain = new SksDistributionDomain();
        sksDistributionDomain.setDzxl("{\"classtreeShopcode\":\"826967206309171269\"}");
        sksDistributionDomain.setTenantCode("606480622092365916");
        System.out.println(JsonUtil.buildNormalBinder().toJson((Object)sksDistributionDomain));
    }
}

