/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdp.service.impl;

import com.yqbsoft.laser.service.cdp.dao.CdpUserinfoTxtendMapper;
import com.yqbsoft.laser.service.cdp.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.cdp.domain.OcContractReDomain;
import com.yqbsoft.laser.service.cdp.domain.UmUserinfoChannelReDomain;
import com.yqbsoft.laser.service.cdp.model.CdpUserInfoTxtend;
import com.yqbsoft.laser.service.cdp.service.CdpUserInfoTxtendService;
import com.yqbsoft.laser.service.cdp.util.BirthUtils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class CdpUserInfoTxtendServiceImpl
extends BaseServiceImpl
implements CdpUserInfoTxtendService {
    private CdpUserinfoTxtendMapper cdpUserinfoTxtendMapper;

    public void setCdpUserinfoTxtendMapper(CdpUserinfoTxtendMapper cdpUserinfoTxtendMapper) {
        this.cdpUserinfoTxtendMapper = cdpUserinfoTxtendMapper;
    }

    @Override
    public void save(CdpUserInfoTxtend cdpUserInfoTxtend) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userInfoCode", cdpUserInfoTxtend.getUserInfoCode());
        List<CdpUserInfoTxtend> umBrandList = this.queryBrandModelPage(map);
        if (umBrandList.size() == 0) {
            this.saveModel(cdpUserInfoTxtend);
        }
    }

    @Override
    public QueryResult<CdpUserInfoTxtend> queryPage(Map<String, Object> map) {
        List<CdpUserInfoTxtend> umBrandList = this.queryBrandModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBrand(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umBrandList);
        return queryResult;
    }

    @Override
    public QueryResult<UmUserinfoChannelReDomain> userInfoQueryPage(Map<String, Object> map) {
        if (map.containsKey("page")) {
            map.put("page", (Integer.parseInt(map.get("page").toString()) - 1) * Integer.parseInt(map.get("rows").toString()));
        }
        List<UmUserinfoChannelReDomain> umUserinfoChannelReDomains = this.cdpUserinfoTxtendMapper.userInfoAllQuery(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.cdpUserinfoTxtendMapper.userInfoAllCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserinfoChannelReDomains);
        return queryResult;
    }

    @Override
    public void edit(CdpUserInfoTxtend cdpUserInfoTxtend) throws ApiException {
        this.logger.info(JsonUtil.buildNonDefaultBinder().toJson((Object)cdpUserInfoTxtend));
        this.cdpUserinfoTxtendMapper.edit(cdpUserInfoTxtend);
    }

    @Override
    public void calculation(Map<String, Object> map) throws ApiException {
        List<CdpUserInfoTxtend> cdpUserInfoTxtends = this.cdpUserinfoTxtendMapper.query(map);
        cdpUserInfoTxtends.forEach(cdpUserInfoTxtend -> {
            String csrq = cdpUserInfoTxtend.getCsrq();
            if (csrq != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    cdpUserInfoTxtend.setXz(BirthUtils.getConstellation(simpleDateFormat.parse(csrq)));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            HashMap<String, Object> oMap = new HashMap<String, Object>();
            oMap.put("startRow", 1);
            oMap.put("endRow", 500);
            oMap.put("memberBcode", cdpUserInfoTxtend.getUserInfoCode());
            oMap.put("childFlag", true);
            oMap.put("order", true);
            HashMap<String, String> pMap = new HashMap<String, String>();
            pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(oMap));
            QueryResult ocContractReDomainSupQueryResult = this.getQueryResutl("oc.contract.queryContractPageReDomain", pMap, OcContractReDomain.class);
            List list = ocContractReDomainSupQueryResult.getList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                Double cashback = 0.0;
                Double totalMoney = 0.0;
                Integer purchase_times_total = 1;
                Integer purchase_goods_count_total = 1;
                Integer goods_count_first = 0;
                Double discount_first = 0.0;
                Double maxamout_single_order = 0.0;
                Double amout_lastest_order = 0.0;
                Double amout_last_year = 0.0;
                Double amout_last_year1 = 0.0;
                Date gm_date = null;
                Date zd_date = null;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                Calendar c = Calendar.getInstance();
                c.setTime(new Date());
                c.add(1, -1);
                Date y = c.getTime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.set(5, calendar.getActualMaximum(5));
                int year = calendar.get(1);
                try {
                    Date diyi = format.parse(year + "-01-01");
                    Date diyiEnd = format.parse(year + "-03-01");
                    Date dier = format.parse(year + "-04-01");
                    Date dierEnd = format.parse(year + "-07-01");
                    Date disan = format.parse(year + "-07-01");
                    Date disanEnd = format.parse(year + "-10-01");
                    Date disi = format.parse(year + "-10-01");
                    Date disiEnd = format.parse(year + "-12-31");
                    Double amout_1_quarter = 0.0;
                    Double amout_2_quarter = 0.0;
                    Double amout_3_quarter = 0.0;
                    Double amout_4_quarter = 0.0;
                    Double amout_1_quarter1 = 0.0;
                    Double amout_2_quarter1 = 0.0;
                    Double amout_3_quarter1 = 0.0;
                    Double amout_4_quarter1 = 0.0;
                    Integer orders_1_quarter = 1;
                    Integer orders_2_quarter = 1;
                    Integer orders_3_quarter = 1;
                    Integer orders_4_quarter = 1;
                    Integer times_1_quarter = 1;
                    Integer times_2_quarter = 1;
                    Integer times_3_quarter = 1;
                    Integer times_4_quarter = 1;
                    for (OcContractReDomain ocContractReDomain : list) {
                        cashback = cashback + ocContractReDomain.getCashback().doubleValue();
                        totalMoney = totalMoney + ocContractReDomain.getGoodsPmoney().doubleValue();
                        purchase_times_total = purchase_times_total + 1;
                        Integer goodsValue = 0;
                        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                            if (!ocContractGoodsDomain.getContractGoodsGtype().equals("1")) continue;
                            purchase_goods_count_total = purchase_goods_count_total + ocContractGoodsDomain.getContractGoodsSendnum().intValue();
                            goodsValue = ocContractGoodsDomain.getContractGoodsSendnum().intValue();
                        }
                        if (purchase_times_total == 1) {
                            gm_date = ocContractReDomain.getGmtCreate();
                        }
                        if (purchase_times_total.intValue() == list.size()) {
                            goods_count_first = goodsValue;
                            discount_first = ocContractReDomain.getCashback().doubleValue() / ocContractReDomain.getGoodsPmoney().doubleValue() * 100.0;
                            amout_lastest_order = ocContractReDomain.getCashback().doubleValue();
                        }
                        maxamout_single_order = ocContractReDomain.getCashback().doubleValue();
                        if (ocContractReDomain.getCashback().doubleValue() > maxamout_single_order) {
                            maxamout_single_order = ocContractReDomain.getCashback().doubleValue();
                            zd_date = ocContractReDomain.getGmtCreate();
                        }
                        if (ocContractReDomain.getGmtCreate().getTime() > y.getTime()) {
                            amout_last_year = amout_last_year + ocContractReDomain.getCashback().doubleValue();
                            amout_last_year1 = amout_last_year1 + ocContractReDomain.getGoodsPmoney().doubleValue();
                        }
                        if (ocContractReDomain.getGmtCreate().getTime() >= diyi.getTime() && ocContractReDomain.getGmtCreate().getTime() < diyiEnd.getTime()) {
                            amout_1_quarter = amout_1_quarter + ocContractReDomain.getCashback().doubleValue();
                            amout_1_quarter1 = amout_1_quarter1 + ocContractReDomain.getGoodsPmoney().doubleValue();
                            times_1_quarter = times_1_quarter + 1;
                        }
                        if (ocContractReDomain.getGmtCreate().getTime() >= dier.getTime() && ocContractReDomain.getGmtCreate().getTime() < dierEnd.getTime()) {
                            amout_2_quarter = amout_2_quarter + ocContractReDomain.getCashback().doubleValue();
                            amout_2_quarter1 = amout_2_quarter1 + ocContractReDomain.getGoodsPmoney().doubleValue();
                            times_2_quarter = times_2_quarter + 1;
                        }
                        if (ocContractReDomain.getGmtCreate().getTime() >= disan.getTime() && ocContractReDomain.getGmtCreate().getTime() < disanEnd.getTime()) {
                            amout_3_quarter = amout_3_quarter + ocContractReDomain.getCashback().doubleValue();
                            amout_3_quarter1 = amout_3_quarter1 + ocContractReDomain.getGoodsPmoney().doubleValue();
                            times_3_quarter = times_3_quarter + 1;
                        }
                        if (ocContractReDomain.getGmtCreate().getTime() < disi.getTime() || ocContractReDomain.getGmtCreate().getTime() >= disiEnd.getTime()) continue;
                        amout_4_quarter = amout_4_quarter + ocContractReDomain.getCashback().doubleValue();
                        amout_4_quarter1 = amout_4_quarter1 + ocContractReDomain.getTotalMoney().doubleValue();
                        times_4_quarter = times_4_quarter + 1;
                    }
                    Double amount_per_members = totalMoney / (double)purchase_times_total.intValue();
                    Double amount_per_orders = totalMoney / (double)purchase_times_total.intValue();
                    Double amount_per_goods = totalMoney / (double)purchase_goods_count_total.intValue();
                    Double discount_average = cashback / totalMoney * 100.0;
                    Double discount_average_last_year = amout_last_year / amout_last_year * 100.0;
                    Double discount_1_quarter = amout_1_quarter / amout_1_quarter1 * 100.0;
                    Double discount_2_quarter = amout_2_quarter / amout_2_quarter1 * 100.0;
                    Double discount_3_quarter = amout_3_quarter / amout_3_quarter1 * 100.0;
                    Double discount_4_quarter = amout_4_quarter / amout_4_quarter1 * 100.0;
                    cdpUserInfoTxtend.setZyJe(cashback + "");
                    cdpUserInfoTxtend.setZyCs(purchase_times_total + "");
                    cdpUserInfoTxtend.setGmDate(format.format(gm_date));
                    cdpUserInfoTxtend.setZdJe(maxamout_single_order + "");
                    cdpUserInfoTxtend.setZdDate(format.format(zd_date));
                    cdpUserInfoTxtend.setKjd(amount_per_members + "");
                    cdpUserInfoTxtend.setZje(cashback + "");
                    cdpUserInfoTxtend.setZcs(purchase_times_total + "");
                    cdpUserInfoTxtend.setYjdJe(amout_1_quarter + "");
                    cdpUserInfoTxtend.setEjdJe(amout_2_quarter + "");
                    cdpUserInfoTxtend.setSanJe(amout_3_quarter + "");
                    cdpUserInfoTxtend.setSiJdJe(amout_4_quarter + "");
                    cdpUserInfoTxtend.setYjdCs(times_1_quarter + "");
                    cdpUserInfoTxtend.setEjdCs(times_2_quarter + "");
                    cdpUserInfoTxtend.setSanCs(times_3_quarter + "");
                    cdpUserInfoTxtend.setSijsCs(times_4_quarter + "");
                    this.logger.info(JsonUtil.buildNonDefaultBinder().toJson(cdpUserInfoTxtend));
                    this.cdpUserinfoTxtendMapper.edit((CdpUserInfoTxtend)cdpUserInfoTxtend);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private List<CdpUserInfoTxtend> queryBrandModelPage(Map<String, Object> parammap) {
        try {
            return this.cdpUserinfoTxtendMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(".queryBrandModelPage", (Throwable)e);
            return null;
        }
    }

    private int countBrand(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cdpUserinfoTxtendMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(".countBrand", (Throwable)e);
        }
        return i;
    }

    private void saveModel(CdpUserInfoTxtend cdpUserInfoTxtend) throws ApiException {
        this.logger.info(JsonUtil.buildNonDefaultBinder().toJson((Object)cdpUserInfoTxtend));
        if (null == cdpUserInfoTxtend) {
            return;
        }
        try {
            this.cdpUserinfoTxtendMapper.insert(cdpUserInfoTxtend);
        }
        catch (Exception e) {
            throw new ApiException(".saveModel.ex", (Throwable)e);
        }
    }
}

