/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdp.service.impl;

import com.yqbsoft.laser.service.cdp.dao.CdpGoodsMapper;
import com.yqbsoft.laser.service.cdp.enmu.BrandCoverEnum;
import com.yqbsoft.laser.service.cdp.enmu.ImsBrandCoverEnum;
import com.yqbsoft.laser.service.cdp.model.CdpGoods;
import com.yqbsoft.laser.service.cdp.service.CdpGoodsService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class CdpGoodsServiceImpl
extends BaseServiceImpl
implements CdpGoodsService {
    @Autowired
    private CdpGoodsMapper cdpGoodsMapper;

    @Override
    public SupQueryResult<CdpGoods> queryCdpGoodsPage(Map<String, Object> param) {
        if (param.containsKey("channelCode")) {
            BrandCoverEnum brandCoverEnum = BrandCoverEnum.getByCode((String)param.get("channelCode"));
            if (brandCoverEnum == null) {
                return new SupQueryResult();
            }
            param.put("channelCode", brandCoverEnum.getName());
        }
        this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(param));
        SupQueryResult cdpGoodsSupQueryResult = new SupQueryResult();
        List<CdpGoods> query = this.cdpGoodsMapper.query(param);
        if (!CollectionUtils.isEmpty(query)) {
            for (CdpGoods goods : query) {
                String brand = goods.getBrand();
                ImsBrandCoverEnum byCode = ImsBrandCoverEnum.getByValue(brand);
                if (byCode != null) {
                    goods.setBrand(byCode.getCode());
                }
                if (StringUtils.isNotBlank((String)goods.getField3())) {
                    goods.setField3(this.cdpGoodsMapper.getClassifyName(goods.getField3(), 1));
                }
                if (StringUtils.isNotBlank((String)goods.getField4())) {
                    goods.setField4(this.cdpGoodsMapper.getClassifyName(goods.getField4(), 3));
                }
                if (!StringUtils.isNotBlank((String)goods.getField5())) continue;
                goods.setField5(this.cdpGoodsMapper.getClassifyName(goods.getField5(), 2));
            }
        }
        this.logger.info("\u6253\u5370\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
        Long count = this.cdpGoodsMapper.count(param);
        cdpGoodsSupQueryResult.setTotal(count.longValue());
        cdpGoodsSupQueryResult.setList(query);
        return cdpGoodsSupQueryResult;
    }
}

