/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdp.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.cdp.dao.UmBrandMapper;
import com.yqbsoft.laser.service.cdp.domain.OrgDepartDomain;
import com.yqbsoft.laser.service.cdp.model.UmBrand;
import com.yqbsoft.laser.service.cdp.service.UmBrandService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmBrandServiceImpl
extends BaseServiceImpl
implements UmBrandService {
    private UmBrandMapper umBrandMapper;

    public void setUmBrandMapper(UmBrandMapper umBrandMapper) {
        this.umBrandMapper = umBrandMapper;
    }

    @Override
    public void saveBrand(UmBrand umBrand) throws ApiException {
        this.saveBrandModel(umBrand);
    }

    @Override
    public QueryResult<UmBrand> queryBrandPage(Map<String, Object> map) {
        List<UmBrand> umBrandList = this.queryBrandModelPage(map);
        List<UmBrand> umList = this.umBrandMapper.query(new HashMap<String, Object>());
        HashMap<String, String> umMap = new HashMap<String, String>();
        for (UmBrand umBrand : umList) {
            umMap.put(umBrand.getBrandPCode(), umBrand.getBrandCode());
        }
        if (umBrandList != null) {
            for (UmBrand umBrand : umBrandList) {
                Boolean isLeft = false;
                if (umBrand.getBrandType().equals("\u95e8\u5e97")) {
                    isLeft = true;
                }
                if (!umMap.containsKey(umBrand.getBrandCode())) {
                    isLeft = true;
                }
                umBrand.setLeaf(isLeft);
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBrand(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umBrandList);
        return queryResult;
    }

    @Override
    public void delBrand(Map<String, Object> map) throws ApiException {
        this.umBrandMapper.del(map);
    }

    @Override
    public void editBrand(UmBrand umBrand) throws ApiException {
        this.umBrandMapper.edit(umBrand);
    }

    private List<UmBrand> queryBrandModelPage(Map<String, Object> parammap) {
        try {
            return this.umBrandMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(".queryBrandModelPage", (Throwable)e);
            return null;
        }
    }

    private int countBrand(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umBrandMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(".countBrand", (Throwable)e);
        }
        return i;
    }

    private void saveBrandModel(UmBrand umBrand) throws ApiException {
        this.logger.info(JsonUtil.buildNonDefaultBinder().toJson((Object)umBrand));
        if (null == umBrand) {
            return;
        }
        try {
            if (umBrand.getStoreJson() != null) {
                List orgDepartDomains = (List)JsonUtil.buildNormalBinder().getJsonToList(umBrand.getStoreJson(), OrgDepartDomain.class);
                for (OrgDepartDomain orgDepartDomain : orgDepartDomains) {
                    UmBrand ub = new UmBrand();
                    ub.setBrandName(orgDepartDomain.getDepartName());
                    ub.setBrandCode(orgDepartDomain.getDepartOcode());
                    ub.setStoreName(umBrand.getStoreName() + orgDepartDomain.getDepartOcode());
                    ub.setBrandPCode(umBrand.getBrandPCode());
                    ub.setBrandType(umBrand.getBrandType());
                    ub.setStoreJson(JSON.toJSONString((Object)orgDepartDomain));
                    this.umBrandMapper.insert(umBrand);
                    List<OrgDepartDomain> mdList = this.umBrandMapper.orgDepartPList(orgDepartDomain.getDepartCode());
                    for (OrgDepartDomain md : mdList) {
                        UmBrand u = new UmBrand();
                        u.setBrandPCode(umBrand.getBrandCode());
                        u.setBrandType("\u95e8\u5e97");
                        u.setBrandName(md.getDepartName());
                        u.setBrandCode(md.getDepartOcode());
                        u.setStoreName(umBrand.getStoreName() + md.getDepartOcode());
                        u.setStoreJson(JSON.toJSONString((Object)md));
                        this.umBrandMapper.insert(u);
                    }
                }
            } else {
                if (!umBrand.getBrandType().equals("\u54c1\u724c")) {
                    umBrand.setStoreName(umBrand.getStoreName() + umBrand.getBrandCode());
                }
                this.umBrandMapper.insert(umBrand);
            }
        }
        catch (Exception e) {
            throw new ApiException(".saveBrandModel.ex", (Throwable)e);
        }
    }
}

