/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdp.service.impl;

import com.yqbsoft.laser.service.cdp.dao.CdpGoodsMapper;
import com.yqbsoft.laser.service.cdp.enmu.ImsBrandCoverEnum;
import com.yqbsoft.laser.service.cdp.model.CdpGoods;
import com.yqbsoft.laser.service.cdp.model.GoodsEvaluateDomian;
import com.yqbsoft.laser.service.cdp.service.CdpGoodsService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class CdpGoodsServiceImpl
extends BaseServiceImpl
implements CdpGoodsService {
    @Autowired
    private CdpGoodsMapper cdpGoodsMapper;

    @Override
    public SupQueryResult<CdpGoods> queryCdpGoodsPage(Map<String, Object> param) {
        this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(param));
        SupQueryResult cdpGoodsSupQueryResult = new SupQueryResult();
        List<CdpGoods> query = this.cdpGoodsMapper.query(param);
        if (!CollectionUtils.isEmpty(query)) {
            for (CdpGoods goods : query) {
                String brand = goods.getBrand();
                ImsBrandCoverEnum byCode = ImsBrandCoverEnum.getByValue(brand);
                if (byCode != null) {
                    goods.setBrand(byCode.getCode());
                }
                if (StringUtils.isNotBlank((String)goods.getField3())) {
                    goods.setField3(this.cdpGoodsMapper.getClassifyName(goods.getField3(), 1));
                }
                if (StringUtils.isNotBlank((String)goods.getField4())) {
                    goods.setField4(this.cdpGoodsMapper.getClassifyName(goods.getField4(), 3));
                }
                if (!StringUtils.isNotBlank((String)goods.getField5())) continue;
                goods.setField5(this.cdpGoodsMapper.getClassifyName(goods.getField5(), 2));
            }
        }
        this.logger.info("\u6253\u5370\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
        Long count = this.cdpGoodsMapper.count(param);
        cdpGoodsSupQueryResult.setTotal(count.longValue());
        cdpGoodsSupQueryResult.setList(query);
        return cdpGoodsSupQueryResult;
    }

    @Override
    public void saveGoodsEvaluateComment(Map<String, Object> map) {
        this.logger.info("map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        map.put("date", DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        map.put("status", "1");
        this.cdpGoodsMapper.saveGoodsEvaluateComment(map);
    }

    @Override
    public void saveUserEvaluateLike(Map<String, Object> map) {
        map.put("dateTime", DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        String user = this.cdpGoodsMapper.queryUserEvaluateLike(map);
        if (StringUtils.isBlank((String)user)) {
            String umUser = this.cdpGoodsMapper.queryUserTwoEvaluateLike(map);
            if (StringUtils.isBlank((String)umUser)) {
                this.cdpGoodsMapper.saveUserEvaluateLike(map);
            }
            this.cdpGoodsMapper.updateUserEvaluateLike(map);
        }
        this.cdpGoodsMapper.updateTwoUserEvaluateLike(map);
    }

    @Override
    public GoodsEvaluateDomian queryGoodsEvaluateComment(Map<String, Object> map) {
        int likeNum = this.cdpGoodsMapper.qureyUserEvaluateLike(map);
        int commentNum = this.cdpGoodsMapper.qureyUserEvaluateComment(map);
        int num = 0;
        List<String> comment = this.cdpGoodsMapper.qureyUserEvaluateId(map);
        if (!CollectionUtils.isEmpty(comment)) {
            for (String id : comment) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("channelCode", map.get("channelCode").toString());
                hashMap.put("evaluateGoodsId", id);
                int commentThreeNum = this.cdpGoodsMapper.qureyThreeEvaluateLike(hashMap);
                num += commentThreeNum;
            }
        }
        GoodsEvaluateDomian goodsEvaluateDomian = new GoodsEvaluateDomian();
        goodsEvaluateDomian.setLikeNum(String.valueOf(likeNum));
        goodsEvaluateDomian.setCommentNum(String.valueOf(commentNum + num));
        return null;
    }
}

