/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import cn.hutool.json.JSONUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cMapEnum;
import com.yqbsoft.laser.service.ims.domain.DisChannelDomain;
import com.yqbsoft.laser.service.ims.domain.RsBrandDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SizeEntity;
import com.yqbsoft.laser.service.ims.service.DataSynchronousService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSynchronousServiceImpl
extends BaseServiceImpl
implements DataSynchronousService {
    private static final Logger log = LoggerFactory.getLogger(DataSynchronousServiceImpl.class);

    @Override
    public Boolean goodsDataSynchronous() {
        JsonEntity jsonEntity = new JsonEntity();
        this.synchronousSpecInfo(jsonEntity);
        return Boolean.TRUE;
    }

    public String queryChannelPage(String memBerCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memBerCode", memBerCode);
        map.put("tenantCode", tenantCode);
        QueryResult rs = this.getQueryResutl("dis.channel.queryChannelPage", map, DisChannelDomain.class);
        return (String)rs.getList().stream().filter(Objects::nonNull).map(DisChannelDomain::getChannelCode).collect(Collectors.toList()).get(0);
    }

    public Boolean saveBrand(Map<String, Object> map) {
        Object inInvoke = this.getInternalRouter().inInvoke("rs.resource.sendSaveBrand", map);
        log.info("\u54c1\u724c\u65b0\u6dfb\u6570\u636e\u4e3a\uff1a\uff1a{}", (Object)JSONUtil.toJsonStr((Object)inInvoke));
        return Boolean.TRUE;
    }

    public SupQueryResult<RsBrandDomain> queryBrandPage(Map<String, Object> map) {
        return this.getQueryResutl("rs.brand.queryBrandPage", map, RsBrandDomain.class);
    }

    public String querySpecGroup(String memBerCode, String tenantCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memBerCode", memBerCode);
        map.put("tenantCode", tenantCode);
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecGroupPage", map, RsSpecGroupDomain.class);
        List specGroup = rs.getList().stream().filter(Objects::nonNull).filter(ele -> "\u901a\u7528\u89c4\u683c\u7ec4".equals(ele.getSpecGroupName())).collect(Collectors.toList());
        if (specGroup.size() > 1) {
            throw new Exception("\u83b7\u53d6\u5230\u591a\u4e2a\u901a\u7528\u89c4\u683c\u7ec4,\u8bf7\u786e\u8ba4\u6570\u636e\u51c6\u786e\u6027");
        }
        if (specGroup.size() != 0) {
            return ((RsSpecGroupDomain)specGroup.get(0)).getSpecGroupCode();
        }
        return null;
    }

    public String saveSpecGroup(String channelCode, String memBerCode, String tenantCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupName", "\u901a\u7528\u89c4\u683c\u7ec4");
        map.put("channelCode", channelCode);
        map.put("memberCode", memBerCode);
        map.put("tenantCode", tenantCode);
        String specGroupCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", map);
        log.info("specGroupCode:::{}", (Object)specGroupCode);
        return specGroupCode;
    }

    public SupQueryResult<RsSpecDomain> querySpecPage(String specGroupCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupCode", specGroupCode);
        return this.getQueryResutl("rs.spec.querySpecPage", map, RsSpecDomain.class);
    }

    public String saveSpec(String specGroupCode, String specName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupCode", specGroupCode);
        map.put("specName", specName);
        String specCode = (String)this.getInternalRouter().inInvoke("rs.spec.saveSpec", map);
        log.info("specCode:::{}", (Object)specCode);
        return specCode;
    }

    public Boolean saveSpecOption(List<RsSpecOptionDomain> rsSpecOptionDomains) {
        rsSpecOptionDomains.forEach(rsSpecOptionDomain -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("specGroupCode", rsSpecOptionDomain.getSpecGroupCode());
            map.put("specCode", rsSpecOptionDomain.getSpecCode());
            map.put("specOptionName", rsSpecOptionDomain.getSpecOptionName());
            map.put("specOptionNum", rsSpecOptionDomain.getSpecOptionNum());
            map.put("tenantCode", rsSpecOptionDomain.getTenantCode());
            this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", map);
        });
        return Boolean.TRUE;
    }

    public Boolean synchronousSpecInfo(JsonEntity jsonEntity) {
        RsSpecOptionDomain rsSpecOptionDomain;
        String specGroupCode = this.querySpecGroup(LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001");
        if (specGroupCode == null) {
            specGroupCode = this.saveSpecGroup(this.queryChannelPage(LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001"), LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001");
        }
        log.info("\u89c4\u683c\u7ec4specGroupCode::::{}", (Object)specGroupCode);
        List spec = Objects.requireNonNull(this.querySpecPage(specGroupCode)).getList();
        String specCodeSize = null;
        String specCodeColor = null;
        for (RsSpecDomain rsSpecDomain : spec) {
            if ("\u5c3a\u5bf8".equals(rsSpecDomain.getSpecName())) {
                specCodeSize = rsSpecDomain.getSpecCode();
                continue;
            }
            if ("\u989c\u8272".equals(rsSpecDomain.getSpecName())) continue;
            specCodeColor = rsSpecDomain.getSpecCode();
        }
        if (specCodeSize == null) {
            specCodeSize = this.saveSpec(specGroupCode, "\u5c3a\u5bf8");
        }
        if (specCodeColor == null) {
            specCodeColor = this.saveSpec(specGroupCode, "\u989c\u8272");
        }
        log.info("specCodeSize:::{}", (Object)specCodeSize);
        log.info("specCodeColor:::{}", (Object)specCodeColor);
        ArrayList<RsSpecOptionDomain> saveSpecOptionSize = new ArrayList<RsSpecOptionDomain>();
        ArrayList<RsSpecOptionDomain> saveSpecOptionColor = new ArrayList<RsSpecOptionDomain>();
        for (SizeEntity sizeEntity : jsonEntity.getSIZE()) {
            rsSpecOptionDomain = new RsSpecOptionDomain();
            rsSpecOptionDomain.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomain.setSpecCode(specCodeSize);
            rsSpecOptionDomain.setSpecOptionName(sizeEntity.getSIZET());
            rsSpecOptionDomain.setSpecOptionNum(sizeEntity.getJSIZE());
            saveSpecOptionSize.add(rsSpecOptionDomain);
        }
        for (ColorEntity colorEntity : jsonEntity.getCOLOR()) {
            rsSpecOptionDomain = new RsSpecOptionDomain();
            rsSpecOptionDomain.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomain.setSpecCode(specCodeColor);
            rsSpecOptionDomain.setSpecOptionName(colorEntity.getTEXT());
            rsSpecOptionDomain.setSpecOptionNum(colorEntity.getJ_3ACOL());
            saveSpecOptionColor.add(rsSpecOptionDomain);
        }
        log.info("saveSpecOptionSize::{}", saveSpecOptionSize);
        log.info("saveSpecOptionColor::{}", saveSpecOptionColor);
        this.saveSpecOption(saveSpecOptionSize);
        this.saveSpecOption(saveSpecOptionColor);
        return Boolean.TRUE;
    }
}

