/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import cn.hutool.json.JSONUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cMapEnum;
import com.yqbsoft.laser.service.ims.domain.DisChannelDomain;
import com.yqbsoft.laser.service.ims.domain.RsBrandDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.Mvgr1Entity;
import com.yqbsoft.laser.service.ims.sap.entity.SizeEntity;
import com.yqbsoft.laser.service.ims.service.DataSynchronousService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSynchronousServiceImpl
extends BaseServiceImpl
implements DataSynchronousService {
    private static final Logger log = LoggerFactory.getLogger(DataSynchronousServiceImpl.class);
    private static Map<String, Integer> brandMap = new HashMap<String, Integer>();
    private static Map<String, Integer> specGroupMap = new HashMap<String, Integer>();
    private static Map<Integer, Integer> pntreeIdsMap = new HashMap<Integer, Integer>();
    private static final String type = "%s\u5546\u54c1\u7c7b\u578b";

    @Override
    public Boolean goodsDataSynchronous() {
        JsonEntity jsonEntity = new JsonEntity();
        String specInfo = this.synchronousSpecInfo(jsonEntity);
        log.info("specInfo::{}", (Object)specInfo);
        return Boolean.TRUE;
    }

    public String queryChannelPage(String memBerCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memBerCode", memBerCode);
        map.put("tenantCode", tenantCode);
        QueryResult rs = this.getQueryResutl("dis.channel.queryChannelPage", map, DisChannelDomain.class);
        return (String)rs.getList().stream().filter(Objects::nonNull).map(DisChannelDomain::getChannelCode).collect(Collectors.toList()).get(0);
    }

    public String saveBrand(String memberCode, Mvgr1Entity mvgr1Entity) {
        RsBrandDomain brandDomain = new RsBrandDomain();
        brandDomain.setMemberCode(memberCode);
        brandDomain.setBrandName(mvgr1Entity.getBEZEI());
        brandDomain.setMemo(mvgr1Entity.getMVGR1());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)brandDomain));
        Object inInvoke = this.getInternalRouter().inInvoke("rs.resource.sendSaveBrand", map);
        log.info("\u54c1\u724c\u65b0\u6dfb\u6570\u636e\u4e3a\uff1a\uff1a{}", (Object)JSONUtil.toJsonStr((Object)inInvoke));
        return inInvoke.toString();
    }

    public List<RsBrandDomain> queryBrandPage(String memberCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", memberCode);
        return this.getQueryResutl("rs.brand.queryBrandPage", map, RsBrandDomain.class).getList();
    }

    public List<RsPntreeReDomain> queryPntreePage(String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        List rsPntreeReDomains = this.getQueryResutl("rs.pntree.queryPntreePage", pmap, RsPntreeReDomain.class).getList();
        log.info("rsPntreeReDomains::{}", (Object)rsPntreeReDomains);
        return rsPntreeReDomains;
    }

    public String savePntree(String pntreeName, Integer brandCode, String specGroupCode, String tenantCode) {
        RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
        rsPntreeDomain.setPntreeName(pntreeName);
        rsPntreeDomain.setBrandCodeStr(String.valueOf(brandCode));
        rsPntreeDomain.setSpecGroupCodeStr(specGroupCode);
        rsPntreeDomain.setTenantCode(tenantCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsPntreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsPntreeDomain));
        Object invoke = this.getInternalRouter().inInvoke("rs.pntree.savePntree", map);
        log.info("invoke\u7c7b\u578b::{}", (Object)JsonUtil.buildNormalBinder().toJson(invoke));
        return invoke.toString();
    }

    public String querySpecGroup(String memberCode, String tenantCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memBerCode", memberCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecGroupPage", pmap, RsSpecGroupDomain.class);
        List specGroup = rs.getList().stream().filter(Objects::nonNull).filter(ele -> "\u901a\u7528\u89c4\u683c\u7ec4".equals(ele.getSpecGroupName())).collect(Collectors.toList());
        log.info("SpecGroup02::{}", specGroup);
        if (specGroup.size() > 1) {
            throw new Exception("\u83b7\u53d6\u5230\u591a\u4e2a\u901a\u7528\u89c4\u683c\u7ec4,\u8bf7\u786e\u8ba4\u6570\u636e\u51c6\u786e\u6027");
        }
        if (specGroup.size() != 0) {
            log.info("\u8fdb\u51651");
            log.info("\u83b7\u53d6\u4e0b\u68070::{}", (Object)((RsSpecGroupDomain)specGroup.get(0)).getSpecGroupCode());
            String specGroupCode = ((RsSpecGroupDomain)specGroup.get(0)).getSpecGroupCode();
            specGroupMap.put("specGroupid", ((RsSpecGroupDomain)specGroup.get(0)).getSpecGroupId());
            return specGroupCode;
        }
        return null;
    }

    public String saveSpecGroup(String channelCode, String memBerCode, String tenantCode) {
        RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
        rsSpecGroupDomain.setSpecGroupName("\u901a\u7528\u89c4\u683c\u7ec4");
        rsSpecGroupDomain.setChannelCode(channelCode);
        rsSpecGroupDomain.setMemberCode(memBerCode);
        rsSpecGroupDomain.setTenantCode(tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecGroupDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain));
        log.info("pmap::{}", pmap);
        Object inInvoke = this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", pmap);
        log.info("saveinInvoke::{}", inInvoke);
        String specGroupCode = (String)inInvoke;
        log.info("specGroupCodeSave:::{}", (Object)specGroupCode);
        System.out.println("specGroupCodeSave:" + specGroupCode);
        return specGroupCode;
    }

    public SupQueryResult<RsSpecDomain> querySpecPage(String specGroupCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupCode", specGroupCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecPage", pmap, RsSpecDomain.class);
        log.info("rs::{}", (Object)rs);
        return rs;
    }

    public String saveSpec(String specGroupCode, String specName, String tenantCode) {
        RsSpecDomain rsSpecDomain = new RsSpecDomain();
        rsSpecDomain.setSpecGroupCode(specGroupCode);
        rsSpecDomain.setSpecName(specName);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsSpecDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain));
        Object inInvoke = this.getInternalRouter().inInvoke("rs.spec.saveSpec", map);
        log.info("inInvokeJson\u5b50\u96c6::{}", (Object)JsonUtil.buildNormalBinder().toJson(inInvoke));
        log.info("specCodeStr:::{}", (Object)inInvoke.toString());
        log.info("inInvoke::{}", inInvoke);
        return inInvoke.toString();
    }

    public Boolean saveSpecOption(List<RsSpecOptionDomain> rsSpecOptionDomains) {
        for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecOptionDomains) {
            log.info("rsSpecOptionDomai\u6dfb\u52a0\u4e09\u7ea7::{}", (Object)rsSpecOptionDomain);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("rsSpecOptionDomain", JsonUtil.getNotDefJsonUtil().toJson((Object)Objects.requireNonNull(rsSpecOptionDomain, "rsSpecOptionDomain\u4e3a\u7a7a")));
            this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", map);
        }
        return Boolean.TRUE;
    }

    public String synchronousSpecInfo(JsonEntity jsonEntity) {
        RsSpecOptionDomain rsSpecOptionDomain;
        String specGroupCode = this.querySpecGroup(LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001");
        log.info("specGroupCode:::{}", (Object)specGroupCode);
        if (specGroupCode == null) {
            specGroupCode = this.saveSpecGroup(this.queryChannelPage(LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001"), LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001");
        }
        log.info("\u89c4\u683c\u7ec4specGroupCode::::{}", (Object)specGroupCode);
        List spec = Objects.requireNonNull(this.querySpecPage(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"))).getList();
        String specCodeSize = null;
        String specCodeColor = null;
        for (RsSpecDomain rsSpecDomain : Objects.requireNonNull(spec, "spec\u4e3a\u7a7a")) {
            if ("\u5c3a\u5bf8".equals(rsSpecDomain.getSpecName())) {
                specCodeSize = rsSpecDomain.getSpecCode();
                continue;
            }
            if ("\u989c\u8272".equals(rsSpecDomain.getSpecName())) continue;
            specCodeColor = rsSpecDomain.getSpecCode();
        }
        if (specCodeSize == null) {
            specCodeSize = this.saveSpec(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"), "\u5c3a\u5bf8", "2022012800000001");
        }
        if (specCodeColor == null) {
            specCodeColor = this.saveSpec(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"), "\u989c\u8272", "2022012800000001");
        }
        log.info("specCodeSize:::{}", specCodeSize);
        log.info("specCodeColor:::{}", specCodeColor);
        ArrayList<RsSpecOptionDomain> saveSpecOptionSize = new ArrayList<RsSpecOptionDomain>();
        ArrayList<RsSpecOptionDomain> saveSpecOptionColor = new ArrayList<RsSpecOptionDomain>();
        for (SizeEntity sizeEntity : jsonEntity.getSIZE()) {
            rsSpecOptionDomain = new RsSpecOptionDomain();
            rsSpecOptionDomain.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomain.setSpecCode(Objects.requireNonNull(specCodeSize, "specCodeSize\u4e3a\u7a7a"));
            rsSpecOptionDomain.setSpecOptionName(sizeEntity.getSIZET());
            rsSpecOptionDomain.setSpecOptionNum(sizeEntity.getJSIZE());
            saveSpecOptionSize.add(rsSpecOptionDomain);
        }
        for (ColorEntity colorEntity : jsonEntity.getCOLOR()) {
            rsSpecOptionDomain = new RsSpecOptionDomain();
            rsSpecOptionDomain.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomain.setSpecCode(Objects.requireNonNull(specCodeColor, "specCodeColor\u4e3a\u7a7a"));
            rsSpecOptionDomain.setSpecOptionName(colorEntity.getTEXT());
            rsSpecOptionDomain.setSpecOptionNum(colorEntity.getJ_3ACOL());
            saveSpecOptionColor.add(rsSpecOptionDomain);
        }
        log.info("saveSpecOptionSize::{}", saveSpecOptionSize);
        log.info("saveSpecOptionColor::{}", saveSpecOptionColor);
        this.saveSpecOption(Objects.requireNonNull(saveSpecOptionSize, "saveSpecOptionSize\u4e3a\u7a7a"));
        this.saveSpecOption(Objects.requireNonNull(saveSpecOptionColor, "saveSpecOptionColor\u4e3a\u7a7a"));
        return specGroupCode;
    }
}

