/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cMapEnum;
import com.yqbsoft.laser.service.ims.domain.DisChannelDomain;
import com.yqbsoft.laser.service.ims.domain.RsBrandDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ims.entity.ImsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.Mvgr1Entity;
import com.yqbsoft.laser.service.ims.sap.entity.SizeEntity;
import com.yqbsoft.laser.service.ims.service.DataSynchronousService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSynchronousServiceImpl
extends BaseServiceImpl
implements DataSynchronousService {
    private static final Logger log = LoggerFactory.getLogger(DataSynchronousServiceImpl.class);
    private static Map<String, Integer> brandMap = new HashMap<String, Integer>();
    private static Map<String, String> specGroupCodeMap = new HashMap<String, String>();
    private static Map<Integer, Integer> pntreeIdsMap = new HashMap<Integer, Integer>();
    private static final String type = "%s\u5546\u54c1\u7c7b\u578b";

    @Override
    public Boolean goodsDataSynchronous() {
        JsonEntity jsonEntity = new JsonEntity();
        String specInfo = this.synchronousSpecInfo(jsonEntity);
        log.info("specInfo::{}", (Object)specInfo);
        ImsEntity imsEntity = new ImsEntity();
        List<ImsEntity> imsEntityInfo = imsEntity.getImsEntityInfo();
        List<RsBrandDomain> rsBrandDomains = this.queryBrandPage(LancyWithB2cMapEnum.LANCY_CODE.getCode());
        for (ImsEntity ims : imsEntityInfo) {
            for (RsBrandDomain rsBrandDomain : rsBrandDomains) {
                if (ims.getSubBrand().equals(rsBrandDomain.getMemo())) {
                    brandMap.put(rsBrandDomain.getMemo(), rsBrandDomain.getBrandId());
                    continue;
                }
                Mvgr1Entity mvgr1Entity = (Mvgr1Entity)jsonEntity.getMVGR1().stream().filter(Objects::nonNull).filter(ele -> ele.getMVGR1().equals(ims.getSubBrand())).collect(Collectors.toList()).get(0);
                log.info("\u65b0\u6dfb\u7684\u54c1\u724c\u4fe1\u606fmvgr1Entity::{}", (Object)mvgr1Entity);
                String saveBrand = this.saveBrand(LancyWithB2cMapEnum.LANCY_CODE.getCode(), mvgr1Entity);
                log.info("saveBrand::{}", (Object)saveBrand);
                brandMap.put(mvgr1Entity.getMVGR1(), Integer.valueOf(saveBrand));
            }
            log.info("brandMap::{}", brandMap);
            log.info("specGroupCodeMap::{}", specGroupCodeMap);
        }
        return Boolean.TRUE;
    }

    public String queryChannelPage(String memBerCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memBerCode", memBerCode);
        map.put("tenantCode", tenantCode);
        QueryResult rs = this.getQueryResutl("dis.channel.queryChannelPage", map, DisChannelDomain.class);
        return (String)rs.getList().stream().filter(Objects::nonNull).map(DisChannelDomain::getChannelCode).collect(Collectors.toList()).get(0);
    }

    public String saveBrand(String memberCode, Mvgr1Entity mvgr1Entity) {
        RsBrandDomain brandDomain = new RsBrandDomain();
        brandDomain.setMemberCode(memberCode);
        brandDomain.setBrandName(mvgr1Entity.getBEZEI());
        brandDomain.setMemo(mvgr1Entity.getMVGR1());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)brandDomain));
        String brand = this.getInternalRouter().inInvoke("rs.resource.sendSaveBrand", map).toString();
        log.info("\u54c1\u724c\u65b0\u6dfb\u6570\u636e\u4e3a\uff1a\uff1a{}", (Object)brand);
        return brand;
    }

    public List<RsBrandDomain> queryBrandPage(String memberCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", memberCode);
        return this.getQueryResutl("rs.brand.queryBrandPage", map, RsBrandDomain.class).getList();
    }

    public List<RsPntreeReDomain> queryPntreePage(String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        List rsPntreeReDomains = this.getQueryResutl("rs.pntree.queryPntreePage", pmap, RsPntreeReDomain.class).getList();
        log.info("rsPntreeReDomains::{}", (Object)rsPntreeReDomains);
        return rsPntreeReDomains;
    }

    public String savePntree(String pntreeName, Integer brandCode, String specGroupCode, String tenantCode) {
        RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
        rsPntreeDomain.setPntreeName(pntreeName);
        rsPntreeDomain.setBrandCodeStr(String.valueOf(brandCode));
        rsPntreeDomain.setSpecGroupCodeStr(specGroupCode);
        rsPntreeDomain.setTenantCode(tenantCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rsPntreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsPntreeDomain));
        String pntreeCode = this.getInternalRouter().inInvoke("rs.pntree.savePntree", map).toString();
        log.info("invoke\u7c7b\u578b::{}", (Object)pntreeCode);
        return pntreeCode;
    }

    public List<RsSpecGroupDomain> querySpecGroup(String memberCode, String tenantCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memBerCode", memberCode);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecGroupPage", pmap, RsSpecGroupDomain.class);
        List<RsSpecGroupDomain> specGroup = rs.getList().stream().filter(Objects::nonNull).filter(ele -> "\u901a\u7528\u89c4\u683c\u7ec4".equals(ele.getSpecGroupName())).collect(Collectors.toList());
        if (specGroup.size() > 1) {
            throw new Exception("\u83b7\u53d6\u5230\u591a\u4e2a\u901a\u7528\u89c4\u683c\u7ec4,\u8bf7\u786e\u8ba4\u6570\u636e\u51c6\u786e\u6027");
        }
        if (specGroup.size() != 0) {
            return specGroup;
        }
        return null;
    }

    public String saveSpecGroup(String channelCode, String memBerCode, String tenantCode) {
        RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
        rsSpecGroupDomain.setSpecGroupName("\u901a\u7528\u89c4\u683c\u7ec4");
        rsSpecGroupDomain.setChannelCode(channelCode);
        rsSpecGroupDomain.setMemberCode(memBerCode);
        rsSpecGroupDomain.setTenantCode(tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecGroupDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain));
        String specGroupCode = this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", pmap).toString();
        specGroupCodeMap.put("specGroupCode", specGroupCode);
        return specGroupCode;
    }

    public SupQueryResult<RsSpecDomain> querySpecPage(String specGroupCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupCode", specGroupCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecPage", pmap, RsSpecDomain.class);
        return rs;
    }

    public String saveSpec(String specGroupCode, String specName, String tenantCode) {
        RsSpecDomain rsSpecDomain = new RsSpecDomain();
        rsSpecDomain.setSpecGroupCode(specGroupCode);
        rsSpecDomain.setSpecName(specName);
        rsSpecDomain.setTenantCode(tenantCode);
        rsSpecDomain.setSpecDefault("1");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain));
        return this.getInternalRouter().inInvoke("rs.spec.saveSpec", pmap).toString();
    }

    public Boolean saveSpecOption(List<RsSpecOptionDomain> rsSpecOptionDomains) {
        for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecOptionDomains) {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("rsSpecOptionDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain));
            this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", pmap);
        }
        return Boolean.TRUE;
    }

    public List<RsSpecOptionDomain> querySpecOptionPage(String specCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specCode", specCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.spec.querySpecOptionPage", pmap, RsSpecOptionDomain.class).getList();
    }

    public String synchronousSpecInfo(JsonEntity jsonEntity) {
        String specGroupCode = (String)this.querySpecGroup(LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001").stream().map(RsSpecGroupDomain::getSpecGroupCode).collect(Collectors.toList()).get(0);
        if (specGroupCode == null) {
            specGroupCode = this.saveSpecGroup(this.queryChannelPage(LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001"), LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001");
        } else {
            specGroupCodeMap.put("specGroupCode", specGroupCode);
        }
        List spec = Objects.requireNonNull(this.querySpecPage(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"))).getList();
        String specCodeSize = null;
        String specCodeColor = null;
        for (RsSpecDomain rsSpecDomain : Objects.requireNonNull(spec, "spec\u4e3a\u7a7a")) {
            if ("\u5c3a\u5bf8".equals(rsSpecDomain.getSpecName())) {
                specCodeSize = rsSpecDomain.getSpecCode();
                continue;
            }
            if (!"\u989c\u8272".equals(rsSpecDomain.getSpecName())) continue;
            specCodeColor = rsSpecDomain.getSpecCode();
        }
        if (specCodeSize == null) {
            specCodeSize = this.saveSpec(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"), "\u5c3a\u5bf8", "2022012800000001");
        }
        if (specCodeColor == null) {
            specCodeColor = this.saveSpec(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"), "\u989c\u8272", "2022012800000001");
        }
        ArrayList<RsSpecOptionDomain> saveSpecOptionSize = new ArrayList<RsSpecOptionDomain>();
        ArrayList<RsSpecOptionDomain> saveSpecOptionColor = new ArrayList<RsSpecOptionDomain>();
        List<RsSpecOptionDomain> rsSpecOptionDomain = this.querySpecOptionPage(specCodeSize);
        for (SizeEntity sizeEntity : jsonEntity.getSIZE().stream().filter(ele -> !rsSpecOptionDomain.contains(ele.getJSIZE())).collect(Collectors.toList())) {
            RsSpecOptionDomain rsSpecOptionDomainSize = new RsSpecOptionDomain();
            rsSpecOptionDomainSize.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainSize.setSpecCode(specCodeSize);
            rsSpecOptionDomainSize.setSpecOptionName(sizeEntity.getSIZET());
            rsSpecOptionDomainSize.setSpecOptionNum(sizeEntity.getJSIZE());
            rsSpecOptionDomainSize.setTenantCode("2022012800000001");
            rsSpecOptionDomainSize.setMemberCode(LancyWithB2cMapEnum.LANCY_CODE.getCode());
            saveSpecOptionSize.add(rsSpecOptionDomainSize);
        }
        for (ColorEntity colorEntity : jsonEntity.getCOLOR().stream().filter(ele -> !rsSpecOptionDomain.contains(ele.getJ_3ACOL())).collect(Collectors.toList())) {
            RsSpecOptionDomain rsSpecOptionDomainContro = new RsSpecOptionDomain();
            rsSpecOptionDomainContro.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainContro.setSpecCode(specCodeColor);
            rsSpecOptionDomainContro.setSpecOptionName(colorEntity.getTEXT());
            rsSpecOptionDomainContro.setSpecOptionNum(colorEntity.getJ_3ACOL());
            rsSpecOptionDomainContro.setTenantCode("2022012800000001");
            rsSpecOptionDomainContro.setMemberCode(LancyWithB2cMapEnum.LANCY_CODE.getCode());
            saveSpecOptionColor.add(rsSpecOptionDomainContro);
        }
        this.saveSpecOption(saveSpecOptionSize);
        this.saveSpecOption(saveSpecOptionColor);
        return specGroupCode;
    }
}

