/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cAppCodeMapEnum;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cMapEnum;
import com.yqbsoft.laser.service.ims.domain.DisChannelDomain;
import com.yqbsoft.laser.service.ims.domain.RsBrandDomain;
import com.yqbsoft.laser.service.ims.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.ims.domain.RsClasstreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ims.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ims.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.ims.entity.ImsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.LclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.MclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.Mvgr1Entity;
import com.yqbsoft.laser.service.ims.sap.entity.SclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SizeEntity;
import com.yqbsoft.laser.service.ims.sap.entity.UnitEntity;
import com.yqbsoft.laser.service.ims.service.DataSynchronousService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DataSynchronousServiceImpl
extends BaseServiceImpl
implements DataSynchronousService {
    private static Logger log = LoggerFactory.getLogger(DataSynchronousServiceImpl.class);
    private static List<String> brandList = new ArrayList<String>();
    private static Map<String, Map<String, String>> specGroupCodeMap = new Hashtable<String, Map<String, String>>();
    private static Map<String, String> specGroupData = new HashMap<String, String>();
    private static Map<String, Map<String, String>> brandCodeMap = new Hashtable<String, Map<String, String>>();
    private static Map<String, String> brandNameMap = new Hashtable<String, String>();
    private static Map<String, String> pntreeNameAndCodeMap = new Hashtable<String, String>();
    private static Map<String, String> classtreeNameAndMemoMap = new Hashtable<String, String>();
    private static Map<String, String> classtreeMap = new Hashtable<String, String>();
    private static final String LAST_SYNCHRONOUS_TIME = "last_time";
    private static List<ImsEntity> imsEntityList = new ArrayList<ImsEntity>();
    private static JsonEntity jsonEntity = null;

    public void init() throws SQLException {
        ImsEntity build = ImsEntity.builder().articleName("\u68ad\u7ec7\u5957\u5934\u886b\u767d\u8272").brand("D03").skc("LAMK02WPR124W12").subBrand("Z02").spu("LAMK02WPR124").sizeGroup("GRID_CLOTH").imgPath("https://pic.lancygroup.com/showPic?Pic=group1/M00/0B/51/wKgFaF_N_bmAI_d4AAEISk_5Fao869.jpg").color("W1").field3("F-W").field4("FERT-01-04").field5("FERT-N016").listPrice("1000").unit("PCS").build();
        imsEntityList.add(build);
        log.info("\u521d\u59cb\u5316\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(imsEntityList));
        jsonEntity = new JsonEntity();
        jsonEntity.setMVGR1(new ArrayList<Mvgr1Entity>());
        jsonEntity.setSIZE(new ArrayList<SizeEntity>());
        jsonEntity.setCOLOR(new ArrayList<ColorEntity>());
        jsonEntity.setUNIT(new ArrayList<UnitEntity>());
        jsonEntity.setLCLS(new ArrayList<LclsEntity>());
        jsonEntity.setMCLS(new ArrayList<MclsEntity>());
        jsonEntity.setSCLS(new ArrayList<SclsEntity>());
        ColorEntity colorEntity = new ColorEntity();
        colorEntity.setJ_3ACOL("W1");
        colorEntity.setTEXT("\u767d\u8272");
        jsonEntity.getCOLOR().add(colorEntity);
        Mvgr1Entity mvgr1Entity = new Mvgr1Entity();
        mvgr1Entity.setBEZEI("\u6717\u59ffLIAA");
        mvgr1Entity.setMVGR1("Z02");
        jsonEntity.getMVGR1().add(mvgr1Entity);
        SizeEntity sizeEntity = new SizeEntity();
        sizeEntity.setJSIZE("FF");
        sizeEntity.setSIZET("FF");
        sizeEntity.setZPGNR("GRID_CLOTH");
        SizeEntity sizeEntity2 = new SizeEntity();
        sizeEntity2.setJSIZE("40");
        sizeEntity2.setSIZET("40");
        sizeEntity2.setZPGNR("GRID_CLOTH");
        SizeEntity sizeEntity3 = new SizeEntity();
        sizeEntity3.setJSIZE("34");
        sizeEntity3.setSIZET("34");
        sizeEntity3.setZPGNR("GRID_CLOTH");
        jsonEntity.getSIZE().add(sizeEntity);
        jsonEntity.getSIZE().add(sizeEntity2);
        jsonEntity.getSIZE().add(sizeEntity3);
        UnitEntity unit = new UnitEntity();
        unit.setMSEHI("PCS");
        unit.setMSEHT("\u4ef6");
        jsonEntity.getUNIT().add(unit);
        LclsEntity lclsEntity = new LclsEntity();
        lclsEntity.setLABOR("F-W");
        lclsEntity.setLBTXT("\u68ad\u7ec7");
        jsonEntity.getLCLS().add(lclsEntity);
        MclsEntity mclsEntity = new MclsEntity();
        mclsEntity.setMATKL("FERT-N016");
        mclsEntity.setWGBEZ60("PR-\u9488\u7ec7\u5957\u5934\u886b");
        jsonEntity.getMCLS().add(mclsEntity);
        SclsEntity sclsEntity = new SclsEntity();
        sclsEntity.setEWBEZ("\u6210\u54c1-\u4e0a\u8863-\u957f\u8896");
        sclsEntity.setEXTWG("FERT-01-04");
        jsonEntity.getSCLS().add(sclsEntity);
        log.info("\u521d\u59cb\u5316\u7684\u6570\u636e\u4e3ajsonEntity \uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)jsonEntity));
    }

    public static void main(String[] args) {
        new DataSynchronousServiceImpl().goodsDataSynchronous();
    }

    @Override
    public Boolean goodsDataSynchronous() {
        this.init();
        if (CollectionUtils.isEmpty(imsEntityList) || Objects.isNull(jsonEntity)) {
            log.info("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
            return false;
        }
        Map<String, List<ImsEntity>> imsMap = this.handleImsGoods();
        for (Map.Entry<String, List<ImsEntity>> next : imsMap.entrySet()) {
            String key = LancyWithB2cMapEnum.getByValue(next.getKey()).getCode();
            List<ImsEntity> imsList = next.getValue();
            Boolean aBoolean = this.synchronousBasisInfo(imsList, jsonEntity, key);
            log.info("\u540c\u6b65\u57fa\u7840\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)aBoolean));
            log.info("\u54c1\u724c\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(brandCodeMap));
            log.info("\u5546\u54c1\u7c7b\u578b\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(pntreeNameAndCodeMap));
            this.synchronousClasstree(imsList, jsonEntity, key);
            this.assemblyGoods(key, imsList);
        }
        log.info("\u65b9\u6cd5\u7ed3\u675f");
        return Boolean.TRUE;
    }

    private Map<String, List<ImsEntity>> handleImsGoods() {
        List<ImsEntity> list = imsEntityList.stream().filter(imsEntity -> LancyWithB2cMapEnum.getByValue(imsEntity.getBrand()) != null).collect(Collectors.toList());
        return this.imsGoodsFlite(list);
    }

    private Map<String, List<ImsEntity>> imsGoodsFlite(List<ImsEntity> list) {
        HashMap<String, List<ImsEntity>> goodsMap = new HashMap<String, List<ImsEntity>>();
        for (ImsEntity imsEntity : list) {
            String brand = imsEntity.getBrand();
            if (goodsMap.containsKey(brand)) {
                ((List)goodsMap.get(brand)).add(imsEntity);
                continue;
            }
            ArrayList<ImsEntity> arr = new ArrayList<ImsEntity>();
            arr.add(imsEntity);
            goodsMap.put(brand, arr);
        }
        return goodsMap;
    }

    public DisChannelDomain queryChannelPage(String memBerCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", memBerCode);
        map.put("tenantCode", tenantCode);
        QueryResult rs = this.getQueryResutl("dis.channel.queryChannelPage", map, DisChannelDomain.class);
        return (DisChannelDomain)rs.getList().stream().filter(Objects::nonNull).filter(ele -> ele.getChannelCode() != null && ele.getChannelName() != null).collect(Collectors.toList()).get(0);
    }

    public List<RsBrandDomain> queryBrandPage(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        log.info("queryBrandPage::{}", pmap);
        QueryResult brandRs = this.getQueryResutl("rs.brand.queryBrandPage", pmap, RsBrandDomain.class);
        log.info("\u83b7\u53d6\u5168\u90e8\u54c1\u724cbrandRs::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)brandRs));
        if (null == brandRs) {
            return null;
        }
        return brandRs.getList();
    }

    public void saveBrand(String memberCode, Mvgr1Entity mvgr1Entity) {
        RsBrandDomain brandDomain = new RsBrandDomain();
        brandDomain.setMemberCode(memberCode);
        brandDomain.setBrandName(mvgr1Entity.getBEZEI());
        brandDomain.setMemo(mvgr1Entity.getMVGR1());
        brandDomain.setTenantCode("2022012800000001");
        brandDomain.setBrandEocode(mvgr1Entity.getMVGR1());
        brandDomain.setBrandNo(mvgr1Entity.getMVGR1());
        brandDomain.setBrandLogo("\u540c\u6b65\u6570\u636e\u6682\u65e0\u54c1\u724c\u56fe\u7247");
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, "2022012800000001");
        brandDomain.setChannelCode(disChannelDomain.getChannelCode());
        brandDomain.setChannelName(disChannelDomain.getChannelName());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)brandDomain));
        log.info("rsBrandDomain::{}", pmap);
        String brandCode = null;
        try {
            Object brand = this.getInternalRouter().inInvoke("rs.resource.sendSaveBrand", pmap);
            log.info("brand::{}", brand);
            brandCode = brand.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6dfb\u52a0\u54c1\u724c\u8fd4\u56de\u7684id::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(brandCode));
        if (!StringUtils.isBlank(brandCode)) {
            String code = mvgr1Entity.getMVGR1();
            String name = mvgr1Entity.getBEZEI();
            if (brandCodeMap.containsKey(memberCode)) {
                brandCodeMap.get(memberCode).put(code, brandCode);
            } else {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(code, brandCode);
                brandCodeMap.put(memberCode, hashMap);
            }
            if (!brandNameMap.containsKey(code)) {
                brandNameMap.put(code, name);
            }
        }
    }

    public void synchronousBrand(List<String> imsList, JsonEntity jsonEntity, String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", "2022012800000001");
        List<RsBrandDomain> brandList = this.queryBrandPage(map);
        for (String ims : imsList) {
            List mvgr1EntityList = jsonEntity.getMVGR1().stream().filter(entity -> ims.equals(entity.getMVGR1())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(mvgr1EntityList)) {
                log.info("\u8be5\u54c1\u724ccode\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ims));
                continue;
            }
            Mvgr1Entity mvgr1Entity = (Mvgr1Entity)mvgr1EntityList.get(0);
            if (!CollectionUtils.isEmpty(brandList)) {
                List brandDomains = brandList.stream().filter(brand -> ims.equals(brand.getBrandEocode())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(brandDomains)) continue;
                this.saveBrand(memberCode, mvgr1Entity);
                continue;
            }
            this.saveBrand(memberCode, mvgr1Entity);
        }
    }

    public List<RsSpecGroupDomain> querySpecGroup(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        map.put("order", true);
        map.put("fuzzy", true);
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        log.info("pmap::{}", pmap);
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecGroupPage", pmap, RsSpecGroupDomain.class);
        log.info("\u83b7\u53d6\u901a\u7528\u89c4\u683c\u7ec4::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)rs));
        return rs.getList();
    }

    public SupQueryResult<RsSpecDomain> querySpecPage(String specGroupCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupCode", specGroupCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecPage", pmap, RsSpecDomain.class);
        return rs;
    }

    public List<RsSpecOptionDomain> querySpecOptionPage(String specCode, String specOptionNum) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specCode", specCode);
        map.put("specOptionNum", specOptionNum);
        map.put("fuzzy", true);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.spec.querySpecOptionPage", pmap, RsSpecOptionDomain.class).getList();
    }

    public List<RsSpecOptionDomain> querySpecOptionPage1(String specCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specCode", specCode);
        map.put("fuzzy", true);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.spec.querySpecOptionPage", pmap, RsSpecOptionDomain.class).getList();
    }

    public String saveSpecGroup(String channelCode, String memberCode, String tenantCode, String specGroupNam) {
        RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
        rsSpecGroupDomain.setSpecGroupName(specGroupNam);
        rsSpecGroupDomain.setChannelCode(channelCode);
        rsSpecGroupDomain.setMemberCode(memberCode);
        rsSpecGroupDomain.setMemo(specGroupNam);
        rsSpecGroupDomain.setTenantCode(tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecGroupDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain));
        log.info("pmap\u4fdd\u5b58\u89c4\u683c\u7ec4::{}", pmap);
        String specGroupCode = this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", pmap).toString();
        specGroupData.put(specGroupNam, specGroupCode);
        return specGroupCode;
    }

    public String saveSpec(String specGroupCode, String specName, String tenantCode) {
        RsSpecDomain rsSpecDomain = new RsSpecDomain();
        rsSpecDomain.setSpecGroupCode(specGroupCode);
        rsSpecDomain.setSpecName(specName);
        rsSpecDomain.setTenantCode(tenantCode);
        rsSpecDomain.setSpecDefault("1");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain));
        return this.getInternalRouter().inInvoke("rs.spec.saveSpec", pmap).toString();
    }

    public Boolean saveSpecOption(List<RsSpecOptionDomain> rsSpecOptionDomains) {
        for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecOptionDomains) {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("rsSpecOptionDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain));
            this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", pmap);
        }
        return Boolean.TRUE;
    }

    public void synchronousSpecInfo(String memberCode, List<ImsEntity> imsList, JsonEntity jsonEntity) {
        Map<String, Set<String>> specGroupMap = this.specGroupHandle(imsList);
        log.info("\u89c4\u683c\u7ec4\u7684\u989c\u8272\u548c\u548c\u5c3a\u5bf8:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(specGroupMap));
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, "2022012800000001");
        log.info("disChannelDomain::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)disChannelDomain));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", "2022012800000001");
        map.put("channelCode", disChannelDomain.getChannelCode());
        List<RsSpecGroupDomain> rsSpecGroupDomain = this.querySpecGroup(map);
        log.info("\u83b7\u53d6\u89c4\u683c\u7ec4\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(rsSpecGroupDomain));
        Iterator<String> iterator = specGroupMap.keySet().iterator();
        while (iterator.hasNext()) {
            log.info("\u5f00\u59cb\u5faa\u73af\u65b0\u589e\u89c4\u683c\u7ec4");
            String groupSize = iterator.next();
            Set<String> colors = specGroupMap.get(groupSize);
            List collect = rsSpecGroupDomain.stream().filter(specGroupDomain -> groupSize.equals(specGroupDomain.getMemo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                String specGroupCode = this.saveSpecGroup(disChannelDomain.getChannelCode(), memberCode, "2022012800000001", groupSize);
                log.info("\u521b\u5efa\u89c4\u683c\u7ec4 \u751f\u6210\u7684specGroupCode\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)specGroupCode));
                String specCodeSize = this.saveSpec(specGroupCode, "\u5c3a\u5bf8", "2022012800000001");
                String specCodeColor = this.saveSpec(specGroupCode, "\u989c\u8272", "2022012800000001");
                this.saveSpecGroupAttached(memberCode, jsonEntity, specGroupCode, groupSize, colors, specCodeColor, specCodeSize);
                continue;
            }
            RsSpecGroupDomain rsSpecGroupDomain1 = (RsSpecGroupDomain)collect.get(0);
            String specGroupCode = rsSpecGroupDomain1.getSpecGroupCode();
            SupQueryResult<RsSpecDomain> rsSpecDomainSupQueryResult = this.querySpecPage(specGroupCode);
            List list = rsSpecDomainSupQueryResult.getList();
            RsSpecDomain specCodeSize = (RsSpecDomain)list.stream().filter(specColor -> specColor.getSpecName().equals("\u5c3a\u5bf8")).collect(Collectors.toList()).get(0);
            RsSpecDomain specCodeColor = (RsSpecDomain)list.stream().filter(specColor -> specColor.getSpecName().equals("\u989c\u8272")).collect(Collectors.toList()).get(0);
            this.saveSpecGroupAttached(memberCode, jsonEntity, specGroupCode, groupSize, colors, specCodeColor.getSpecCode(), specCodeSize.getSpecCode());
        }
        log.info("ims\u7684\u89c4\u683c\u7ec4\u548c\u65b0\u589e\u6570\u636ecode\u5173\u8054:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(specGroupData));
        specGroupCodeMap.put(memberCode, specGroupData);
    }

    private void saveSpecGroupAttached(String memberCode, JsonEntity jsonEntity, String specGroupCode, String groupSize, Set<String> colors, String specCodeColor, String specCodeSize) {
        log.info("------\u5f00\u59cb\u65b0\u589e\u89c4\u683c\u7ec4\u7b2c\u4e09\u7ea7------");
        ArrayList<RsSpecOptionDomain> saveSpecOptionSize = new ArrayList<RsSpecOptionDomain>();
        ArrayList<RsSpecOptionDomain> saveSpecOptionColor = new ArrayList<RsSpecOptionDomain>();
        List<SizeEntity> sizeEntities = jsonEntity.getSIZE();
        List groupSizeList = sizeEntities.stream().filter(sizeEntity -> sizeEntity.getZPGNR().equals(groupSize)).collect(Collectors.toList());
        for (SizeEntity sizeEntity2 : groupSizeList) {
            int size = this.querySpecOptionPage(specCodeSize, sizeEntity2.getJSIZE()).size();
            if (size != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainSize = new RsSpecOptionDomain();
            rsSpecOptionDomainSize.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainSize.setSpecCode(specCodeSize);
            rsSpecOptionDomainSize.setSpecOptionName(sizeEntity2.getSIZET());
            rsSpecOptionDomainSize.setSpecOptionNum(sizeEntity2.getJSIZE());
            rsSpecOptionDomainSize.setTenantCode("2022012800000001");
            rsSpecOptionDomainSize.setMemberCode(memberCode);
            saveSpecOptionSize.add(rsSpecOptionDomainSize);
        }
        List<ColorEntity> colorEntityList = jsonEntity.getCOLOR();
        for (String color : colors) {
            List collect = colorEntityList.stream().filter(colorEntity -> colorEntity.getJ_3ACOL().equals(color)).collect(Collectors.toList());
            ColorEntity colorEntity2 = (ColorEntity)collect.get(0);
            if (this.querySpecOptionPage(specCodeColor, colorEntity2.getJ_3ACOL()).size() != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainContro = new RsSpecOptionDomain();
            rsSpecOptionDomainContro.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainContro.setSpecCode(specCodeColor);
            rsSpecOptionDomainContro.setSpecOptionName(colorEntity2.getTEXT());
            rsSpecOptionDomainContro.setSpecOptionNum(colorEntity2.getJ_3ACOL());
            rsSpecOptionDomainContro.setTenantCode("2022012800000001");
            rsSpecOptionDomainContro.setMemberCode(memberCode);
            saveSpecOptionColor.add(rsSpecOptionDomainContro);
        }
        log.info("\u5904\u7406\u5b8c\u540e\u7684\u989c\u8272::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(saveSpecOptionColor));
        log.info("\u5904\u7406\u5b8c\u540e\u7684\u5c3a\u5bf8::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(saveSpecOptionSize));
        if (saveSpecOptionSize.size() != 0) {
            this.saveSpecOption(saveSpecOptionSize);
        }
        if (saveSpecOptionColor.size() != 0) {
            this.saveSpecOption(saveSpecOptionColor);
        }
    }

    private Map<String, Set<String>> specGroupHandle(List<ImsEntity> imsList) {
        log.info("\u5f00\u59cb\u8fc7\u6ee4\u89c4\u683c\u7ec4\u6570\u636e");
        if (CollectionUtils.isEmpty(imsList)) {
            log.info("\u5f00\u59cb\u8fc7\u6ee4\u89c4\u683c\u7ec4\u6570\u636e--\u65e0\u6570\u636e");
            return null;
        }
        HashSet<String> groupSize = new HashSet<String>();
        for (ImsEntity imsEntity : imsList) {
            if (!StringUtils.isNotBlank((String)imsEntity.getSizeGroup())) continue;
            groupSize.add(imsEntity.getSizeGroup());
        }
        log.info("\u8fc7\u6ee4\u540e\u7684\u89c4\u683c\u7ec4--\u5c3a\u5bf8::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(groupSize));
        Hashtable<String, Set<String>> specGroupMap = new Hashtable<String, Set<String>>();
        for (String imsEntity : groupSize) {
            HashSet<String> arr = new HashSet<String>();
            for (int i = 0; i < imsList.size(); ++i) {
                if (!StringUtils.isNotBlank((String)imsList.get(i).getSizeGroup()) || !imsList.get(i).getSizeGroup().equals(imsEntity)) continue;
                arr.add(imsList.get(i).getColor());
            }
            specGroupMap.put(imsEntity, arr);
        }
        return specGroupMap;
    }

    public List<RsPntreeReDomain> queryPntreePage(String tenantCode, String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberCode", memberCode);
        map.put("fuzzy", true);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rsPntreeReDomains = this.getQueryResutl("rs.pntree.queryPntreePage", pmap, RsPntreeReDomain.class);
        log.info("rsPntreeReDomains::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)rsPntreeReDomains));
        if (null == rsPntreeReDomains) {
            return null;
        }
        return rsPntreeReDomains.getList();
    }

    public String savePntree(String specGroupCode, String tenantCode, String brandCodeStr, String pntreeName, String memberCode) {
        RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
        rsPntreeDomain.setPntreeName(pntreeName);
        rsPntreeDomain.setSpecGroupCodeStr(specGroupCode);
        rsPntreeDomain.setTenantCode(tenantCode);
        rsPntreeDomain.setBrandCodeStr(brandCodeStr);
        rsPntreeDomain.setPntreeShow(0);
        rsPntreeDomain.setPntreeEocode(pntreeName);
        rsPntreeDomain.setAppmanageIcode(LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsPntreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsPntreeDomain));
        log.info("pmap::{}", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
        Object pntreeObj = this.getInternalRouter().inInvoke("rs.pntree.savePntree", pmap);
        log.info("pntreeObj::{}", (Object)pntreeObj.toString());
        return pntreeObj.toString();
    }

    public Boolean synchronousPntree(List<ImsEntity> imsList, String memberCode) {
        List<RsPntreeReDomain> pntreeRs = this.queryPntreePage("2022012800000001", memberCode);
        log.info("pntreeRs::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(pntreeRs));
        if (ListUtil.isNotEmpty(pntreeRs)) {
            for (String next : specGroupCodeMap.get(memberCode).keySet()) {
                String specGroupCode = specGroupCodeMap.get(memberCode).get(next);
                List collect = pntreeRs.stream().filter(rs -> next.equals(rs.getPntreeEocode())).collect(Collectors.toList());
                boolean empty = CollectionUtils.isEmpty(collect);
                log.info("\u89c4\u683c\u7ec4\u662f\u5426\u5df2\u7ecf\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)empty));
                String pntreeCode = null;
                if (empty) {
                    String brandCodeStr = null;
                    if (!CollectionUtils.isEmpty(brandCodeMap)) {
                        brandCodeStr = this.getSpecGroupBrand(next, imsList, brandCodeMap.get(memberCode));
                    }
                    pntreeCode = this.savePntree(specGroupCode, "2022012800000001", brandCodeStr, next, memberCode);
                    log.info("pntreeCode2::{}", (Object)pntreeCode);
                } else {
                    RsPntreeReDomain rsPntreeReDomain = (RsPntreeReDomain)collect.get(0);
                    pntreeCode = rsPntreeReDomain.getPntreeCode();
                }
                pntreeNameAndCodeMap.put(next, pntreeCode);
            }
        } else {
            for (String next : specGroupCodeMap.get(memberCode).keySet()) {
                String specGroupCode = specGroupCodeMap.get(memberCode).get(next);
                String brandCodeStr = null;
                if (!CollectionUtils.isEmpty(brandCodeMap)) {
                    brandCodeStr = this.getSpecGroupBrand(next, imsList, brandCodeMap.get(memberCode));
                }
                String pntreeCode = this.savePntree(specGroupCode, "2022012800000001", brandCodeStr, next, memberCode);
                log.info("pntreeCode2::{}", (Object)pntreeCode);
                pntreeNameAndCodeMap.put(next, pntreeCode);
            }
        }
        return Boolean.TRUE;
    }

    private String getSpecGroupBrand(String sizeGroup, List<ImsEntity> imsList, Map<String, String> brandCodeMap) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u6240\u5c5e\u7684\u54c1\u724c");
        String brandStr = null;
        for (int i = 0; i < imsList.size(); ++i) {
            String s;
            ImsEntity imsEntity = imsList.get(i);
            if (!sizeGroup.equals(imsEntity.getSizeGroup()) || !StringUtils.isBlank(brandStr) && brandStr.contains(imsEntity.getSubBrand())) continue;
            if (StringUtils.isBlank(brandStr)) {
                s = brandCodeMap.get(imsEntity.getSubBrand());
                if (!StringUtils.isNotBlank((String)s)) continue;
                brandStr = s;
                continue;
            }
            s = brandCodeMap.get(imsEntity.getSubBrand());
            if (!StringUtils.isNotBlank((String)s)) continue;
            brandStr = brandStr + "," + s;
        }
        log.info("\u7ed3\u675f\u5f00\u59cb\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u6240\u5c5e\u7684\u54c1\u724c,\u53c2\u6570:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(brandStr));
        return brandStr;
    }

    public Boolean synchronousBasisInfo(List<ImsEntity> imsList, JsonEntity jsonEntity, String memberCode) {
        brandList = this.brandHandle(imsList);
        if (!ListUtil.isEmpty(brandList)) {
            this.synchronousBrand(brandList, jsonEntity, memberCode);
        }
        this.synchronousSpecInfo(memberCode, imsList, jsonEntity);
        log.info("==============specGroupCodeMap==============:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(specGroupCodeMap));
        if (!CollectionUtils.isEmpty(specGroupCodeMap)) {
            this.synchronousPntree(imsList, memberCode);
        }
        return Boolean.TRUE;
    }

    private List<String> brandHandle(List<ImsEntity> imsList) {
        ArrayList<String> list = new ArrayList<String>();
        for (ImsEntity imsEntity : imsList) {
            String subBrand = imsEntity.getSubBrand();
            if (!StringUtils.isNotBlank((String)subBrand) || list.contains(subBrand)) continue;
            list.add(subBrand);
        }
        log.info("\u8fc7\u6ee4\u540e\u7684\u54c1\u724c\u4e3a::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(list));
        return list;
    }

    public List<RsClasstreeReDomain> queryClasstreePage(String tenantCode, String memberCode, String channelCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("memberCode", memberCode);
        param.put("classtreeType", "0");
        param.put("fuzzy", true);
        param.put("channelCode", channelCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        QueryResult reDomainSupQueryResult = this.getQueryResutl("rs.rsClasstree.queryClasstreePage", pmap, RsClasstreeReDomain.class);
        ArrayList<RsClasstreeReDomain> reDomainList = new ArrayList<RsClasstreeReDomain>();
        if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return reDomainList;
        }
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsClasstreeReDomain> rootClass = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!"-1".equals(rsClasstreeReDomain.getClasstreeParentcode())) continue;
            rootClass.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : rootClass) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        return rootClass;
    }

    public List<RsClasstreeReDomain> getChild(String id, List<RsClasstreeReDomain> all) {
        ArrayList<RsClasstreeReDomain> childList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getClasstreeParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    public String saveClasstree(RsClasstreeDomain rsClasstreeDomain, List<String> list) {
        Objects.requireNonNull(list, "list\u4e3a\u83b7\u53d6\u7684\u5206\u7c7b\u7c7b\u578b");
        rsClasstreeDomain.setTenantCode("2022012800000001");
        rsClasstreeDomain.setMemo(list.get(0));
        rsClasstreeDomain.setClasstreeName(list.get(1));
        rsClasstreeDomain.setClasstreeType("0");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
        log.info("pmapclass::{}", pmap);
        String classtreeCode = this.getInternalRouter().inInvoke("rs.resource.sendSaveClasstree", pmap).toString();
        log.info("classtreeCode::{}", (Object)classtreeCode);
        if (null == classtreeCode) {
            throw new Exception("\u4fdd\u5b58\u5546\u54c1\u5206\u7c7b\u5f02\u5e38");
        }
        classtreeNameAndMemoMap.put(rsClasstreeDomain.getMemo(), classtreeCode);
        return classtreeCode;
    }

    public List<String> getClasstreeInfo(JsonEntity jsonEntity, Integer source, String code) {
        if (jsonEntity.getLCLS() != null && source == 1) {
            LclsEntity lclsEntity = jsonEntity.getLCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getLABOR() != null && ele.getLBTXT() != null).filter(ele -> ele.getLABOR().equals(code)).findFirst().get();
            return Arrays.asList(lclsEntity.getLABOR(), lclsEntity.getLBTXT());
        }
        if (jsonEntity.getMCLS() != null && source == 2) {
            MclsEntity mclsEntity = jsonEntity.getMCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getMATKL() != null && ele.getWGBEZ60() != null).filter(ele -> ele.getMATKL().equals(code)).findFirst().get();
            return Arrays.asList(mclsEntity.getMATKL(), mclsEntity.getWGBEZ60());
        }
        if (jsonEntity.getSCLS() != null && source == 3) {
            SclsEntity sclsEntity = jsonEntity.getSCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getEXTWG() != null && ele.getEWBEZ() != null).filter(ele -> ele.getEXTWG().equals(code)).findFirst().get();
            return Arrays.asList(sclsEntity.getEXTWG(), sclsEntity.getEWBEZ());
        }
        return null;
    }

    public String structureClasstreeInfo(Integer source, ImsEntity ims, JsonEntity jsonEntity, String classtreeParentcode) {
        String memberCode = LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode();
        RsClasstreeDomain classtreeDomain = new RsClasstreeDomain();
        classtreeDomain.setChannelCode(this.queryChannelPage(memberCode, "2022012800000001").getChannelCode());
        classtreeDomain.setMemberCode(memberCode);
        classtreeDomain.setClasstreeLast("1");
        if (source == 1) {
            classtreeDomain.setClasstreeParentcode("-1");
            return this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField3()));
        }
        if (source == 2) {
            classtreeDomain.setClasstreeParentcode(classtreeParentcode);
            return this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField5()));
        }
        if (source == 3) {
            classtreeDomain.setClasstreeParentcode(classtreeParentcode);
            classtreeDomain.setPntreeCode(pntreeNameAndCodeMap.get(ims.getSizeGroup()));
            classtreeDomain.setClasstreeLast("0");
            return this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField4()));
        }
        return null;
    }

    public void synchronousClasstree(List<ImsEntity> imsList, JsonEntity jsonEntity, String memberCode) {
        log.info("\u5f00\u59cb\u540c\u6b65\u540e\u53f0\u5206\u7c7b");
        for (ImsEntity ims : imsList) {
            this.saveClasstree(jsonEntity, ims, memberCode);
        }
    }

    private void saveClasstree(JsonEntity jsonEntity, ImsEntity ims, String memberCode) {
        List<RsClasstreeReDomain> rsClasstreeReDomains = this.queryClasstreePage("2022012800000001", memberCode, this.queryChannelPage(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "2022012800000001").getChannelCode());
        log.info("\u83b7\u53d6\u7684\u4e00\u7ea7\u5206\u7c7b\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(rsClasstreeReDomains));
        if (rsClasstreeReDomains != null) {
            log.info("\u5b58\u5728\u5927\u7c7b");
            Optional<RsClasstreeReDomain> lclsIsPresent = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeCode() != null && ele.getMemo() != null).filter(ele -> ele.getMemo().equals(ims.getField3()) && LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode().equals(ele.getMemberCode())).findFirst();
            if (lclsIsPresent.isPresent()) {
                log.info("\u5b58\u5728\u76f8\u540c\u5927\u7c7b");
                if (ListUtil.isEmpty(lclsIsPresent.get().getChildList())) {
                    log.info("\u4e0d\u5b58\u5728\u4e2d\u7c7b");
                    String classtreeCode = lclsIsPresent.get().getClasstreeCode();
                    log.info("classtreeCode::\u4e8c\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                    String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, classtreeCode);
                    String string = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                } else {
                    log.info("\u5b58\u5728\u4e2d\u7c7b");
                    Optional<RsClasstreeReDomain> mclsIsPrsent = lclsIsPresent.get().getChildList().stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeCode() != null && ele.getMemo() != null).filter(ele -> ele.getMemo().equals(ims.getField5()) && LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode().equals(ele.getMemberCode())).findFirst();
                    if (!mclsIsPrsent.isPresent()) {
                        log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u4e2d\u7c7b");
                        String classtreeCode = lclsIsPresent.get().getClasstreeCode();
                        log.info("classtreeCode::\u4e8c\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                        String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, classtreeCode);
                        log.info("mclsSaveCode::{}", (Object)mclsSaveCode);
                        String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                        log.info("sclsSaveCode::{}", (Object)sclsSaveCode);
                    } else {
                        Object sclsIsPrsent;
                        log.info("\u5b58\u5728\u76f8\u540c\u4e2d\u7c7b");
                        if (ListUtil.isEmpty(mclsIsPrsent.get().getChildList())) {
                            log.info("\u4e0d\u5b58\u5728\u5c0f\u7c7b");
                            String classtreeParentcode = mclsIsPrsent.get().getClasstreeCode();
                            log.info("classtreeCode::\u4e09\u7ea7\u7ea7\u8d4b\u503c::{}", (Object)classtreeParentcode);
                            this.structureClasstreeInfo(3, ims, jsonEntity, classtreeParentcode);
                        } else {
                            log.info("\u5b58\u5728\u5c0f\u7c7b");
                            sclsIsPrsent = mclsIsPrsent.get().getChildList().stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeCode() != null && ele.getMemo() != null && ele.getMemberCode() != null && ele.getPntreeCode() != null).filter(ele -> ele.getMemo().equals(ims.getField4()) && ele.getMemberCode().equals(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode())).findFirst();
                            log.info("sclsIsPrsent.isPresent::{}", (Object)((Optional)sclsIsPrsent).isPresent());
                            log.info("sclsIsPrsent::{}", (Object)JsonUtil.buildNormalBinder().toJson(((Optional)sclsIsPrsent).get()));
                            if (!((Optional)sclsIsPrsent).isPresent()) {
                                log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u5c0f\u7c7b");
                                String classtreeCode = mclsIsPrsent.get().getClasstreeCode();
                                log.info("classtreeCode::\u4e09\u7ea7\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                                this.structureClasstreeInfo(3, ims, jsonEntity, classtreeCode);
                            } else {
                                RsClasstreeReDomain classtreeCode = (RsClasstreeReDomain)((Optional)sclsIsPrsent).get();
                            }
                        }
                        sclsIsPrsent = mclsIsPrsent.get();
                    }
                }
                RsClasstreeReDomain lcls = lclsIsPresent.get();
                log.info("lcls::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)lcls));
                classtreeMap.put(ims.getField3(), lcls.getClasstreeCode());
            } else {
                log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u5927\u7c7b");
                String lclsSaveCode = this.structureClasstreeInfo(1, ims, jsonEntity, null);
                String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, lclsSaveCode);
                String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                classtreeMap.put(ims.getField3(), lclsSaveCode);
            }
        } else {
            log.info("\u4e0d\u5b58\u5728\u5927\u7c7b");
            String lclsSaveCode = this.structureClasstreeInfo(1, ims, jsonEntity, null);
            String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, lclsSaveCode);
            String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
            classtreeMap.put(ims.getField3(), lclsSaveCode);
        }
    }

    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage(String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("validFlag", true);
        map.put("goodsOrigin", "0");
        map.put("goodsType", "00");
        map.put("fuzzy", "true");
        map.put("memberCode", memberCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pmap, RsResourceGoodsReDomain.class);
    }

    public void assemblyGoods(String memberCode, List<ImsEntity> imsList) {
        SupQueryResult<RsResourceGoodsReDomain> goods = this.queryResourceGoodsPage(memberCode);
        List list = goods.getList();
        this.logger.info("\u83b7\u53d6\u7684\u5168\u90e8\u5546\u54c1\u4e3a\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)list));
        List<UnitEntity> unit = jsonEntity.getUNIT();
        List<Mvgr1Entity> mvgr1 = jsonEntity.getMVGR1();
        List<ColorEntity> color = jsonEntity.getCOLOR();
        List<SizeEntity> size = jsonEntity.getSIZE();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", "2022012800000001");
        map.put("fuzzy", true);
        List<RsSpecGroupDomain> rsSpecGroupDomain = this.querySpecGroup(map);
        log.info("\u83b7\u53d6\u89c4\u683c\u7ec4\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(rsSpecGroupDomain));
        if (CollectionUtils.isEmpty((Collection)list)) {
            for (ImsEntity imsEntity : imsList) {
                RsResourceGoodsReDomain resourceGoodsParam = this.getResourceGoodsParam(mvgr1, unit, color, size, imsEntity, memberCode, rsSpecGroupDomain);
                log.info("\u4fdd\u5b58\u7684\u5546\u54c1\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)resourceGoodsParam));
                this.sendSaveResourceGoods(resourceGoodsParam);
            }
        }
    }

    private RsResourceGoodsReDomain getResourceGoodsParam(List<Mvgr1Entity> mvgr1, List<UnitEntity> unit, List<ColorEntity> colors, List<SizeEntity> sizeGroup, ImsEntity imsEntity, String memberCode, List<RsSpecGroupDomain> rsSpecGroupDomains) {
        List mvgr1Entities = mvgr1.stream().filter(m -> m.getMVGR1().equals(imsEntity.getSubBrand())).collect(Collectors.toList());
        log.info("\u54c1\u724c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(mvgr1Entities));
        List unitEntityList = unit.stream().filter(u -> u.getMSEHI().equals(imsEntity.getUnit())).collect(Collectors.toList());
        log.info("\u83b7\u53d6\u7684\u5546\u54c1\u5355\u4f4d\u4e3a\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(unitEntityList));
        List colorEntitieList = colors.stream().filter(u -> u.getJ_3ACOL().equals(imsEntity.getColor())).collect(Collectors.toList());
        log.info("\u83b7\u53d6\u7684\u5546\u54c1\u989c\u8272\u4e3a\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(colorEntitieList));
        List sizeGroupList = sizeGroup.stream().filter(u -> u.getZPGNR().equals(imsEntity.getSizeGroup())).collect(Collectors.toList());
        log.info("\u89c4\u683c\u7ec4\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(sizeGroupList));
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        rsResourceGoodsReDomain.setTenantCode("2022012800000001");
        rsResourceGoodsReDomain.setMemberCode(memberCode);
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, "2022012800000001");
        rsResourceGoodsReDomain.setChannelCode(disChannelDomain.getChannelCode());
        rsResourceGoodsReDomain.setGoodsType("00");
        rsResourceGoodsReDomain.setGoodsOrigin("0");
        rsResourceGoodsReDomain.setGoodsName(imsEntity.getArticleName());
        rsResourceGoodsReDomain.setPartsnameWeightunit(CollectionUtils.isEmpty(unitEntityList) ? "" : ((UnitEntity)unitEntityList.get(0)).getMSEHT());
        rsResourceGoodsReDomain.setGoodsNo(imsEntity.getSpu());
        rsResourceGoodsReDomain.setPntreeCode(pntreeNameAndCodeMap.get(imsEntity.getSizeGroup()));
        rsResourceGoodsReDomain.setPntreeName(imsEntity.getSizeGroup());
        rsResourceGoodsReDomain.setPricesetNprice(new BigDecimal("0"));
        rsResourceGoodsReDomain.setClasstreeCode(classtreeMap.get(imsEntity.getField3()));
        rsResourceGoodsReDomain.setDataOpbillstate(0);
        rsResourceGoodsReDomain.setGoodsProperty(imsEntity.getArticleName());
        rsResourceGoodsReDomain.setGoodsNum(new BigDecimal(0));
        rsResourceGoodsReDomain.setGoodsEocode(imsEntity.getSpu());
        Map<String, String> map = brandCodeMap.get(memberCode);
        log.info("---------------------brandMap:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(map));
        rsResourceGoodsReDomain.setRsGoodsFileDomainList(new ArrayList<RsGoodsFileDomain>());
        if (!CollectionUtils.isEmpty(sizeGroupList)) {
            ArrayList<RsSkuDomain> skuList = new ArrayList<RsSkuDomain>();
            for (SizeEntity sizeEntity : sizeGroupList) {
                RsSkuDomain rsSkuDomain = new RsSkuDomain();
                rsSkuDomain.setSkuName(sizeEntity.getSIZET() + "/" + ((ColorEntity)colorEntitieList.get(0)).getTEXT());
                rsSkuDomain.setSkuNo(imsEntity.getSkc() + imsEntity.getSizeGroup());
                rsSkuDomain.setPricesetNprice(new BigDecimal("0"));
                rsSkuDomain.setSkuEocode(imsEntity.getSkc() + imsEntity.getSizeGroup());
                skuList.add(rsSkuDomain);
            }
            rsResourceGoodsReDomain.setRsSkuDomainList(skuList);
        }
        List sizeGrop = rsSpecGroupDomains.stream().filter(rs -> imsEntity.getSizeGroup().equals(rs.getMemo())).collect(Collectors.toList());
        log.info("sizeGrop:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(sizeGrop));
        if (!CollectionUtils.isEmpty(sizeGrop)) {
            List<RsSpecOptionDomain> rsSpecOptionDomains = this.querySpecOptionPage1(((RsSpecGroupDomain)sizeGrop.get(0)).getSpecGroupCode());
            log.info("rsSpecOptionDomains:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(rsSpecOptionDomains));
            ArrayList<RsSpecValueDomain> specList = new ArrayList<RsSpecValueDomain>();
            for (RsSpecOptionDomain specOptionDomain : rsSpecOptionDomains) {
                RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
                rsSpecValueDomain.setSpecCode(specOptionDomain.getSpecCode());
                rsSpecValueDomain.setSpecGroupCode(specOptionDomain.getSpecGroupCode());
                rsSpecValueDomain.setSpecValueValue(specOptionDomain.getSpecOptionName());
                specList.add(rsSpecValueDomain);
            }
            rsResourceGoodsReDomain.setRsSpecValueList(specList);
        }
        return rsResourceGoodsReDomain;
    }

    private Map<String, List<ImsEntity>> getGoodsMap(List<ImsEntity> imsList) {
        HashMap<String, List<ImsEntity>> goodsMap = new HashMap<String, List<ImsEntity>>();
        for (ImsEntity imsEntity : imsList) {
            String brand = imsEntity.getBrand();
            if (goodsMap.containsKey(brand)) {
                List imsEntities = (List)goodsMap.get(brand);
                imsEntities.add(imsEntity);
                continue;
            }
            ArrayList<ImsEntity> arr = new ArrayList<ImsEntity>();
            arr.add(imsEntity);
            goodsMap.put(brand, arr);
        }
        return goodsMap;
    }

    public Boolean sendSaveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain));
        this.getInternalRouter().inInvoke("rs.resource.sendSaveResourceGoods", pmap);
        return Boolean.TRUE;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

