/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.google.common.collect.ImmutableMap;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cAppCodeMapEnum;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cMapEnum;
import com.yqbsoft.laser.service.ims.domain.DisChannelDomain;
import com.yqbsoft.laser.service.ims.domain.OrgCompanyDomain;
import com.yqbsoft.laser.service.ims.domain.OrgDepartDomain;
import com.yqbsoft.laser.service.ims.domain.OrgDepartReDomain;
import com.yqbsoft.laser.service.ims.domain.RsBrandDomain;
import com.yqbsoft.laser.service.ims.domain.RsClasstreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ims.domain.RsGoodsClassReDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsPropertiesDomain;
import com.yqbsoft.laser.service.ims.domain.RsPropertiesReDomain;
import com.yqbsoft.laser.service.ims.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.ims.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ims.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ims.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.ims.domain.ShShsettlUserDomain;
import com.yqbsoft.laser.service.ims.domain.UlLevelUpointsDomain;
import com.yqbsoft.laser.service.ims.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.ims.domain.UmUserinfoChannelDomain;
import com.yqbsoft.laser.service.ims.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ims.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.ims.entity.AreaDomainEntity;
import com.yqbsoft.laser.service.ims.entity.AreaEntity;
import com.yqbsoft.laser.service.ims.entity.CityEntity;
import com.yqbsoft.laser.service.ims.entity.ImsEntity;
import com.yqbsoft.laser.service.ims.entity.SalesmanEntity;
import com.yqbsoft.laser.service.ims.entity.StoreEntity;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.LclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.MclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.Mvgr1Entity;
import com.yqbsoft.laser.service.ims.sap.entity.PldzEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SizeEntity;
import com.yqbsoft.laser.service.ims.sap.entity.UnitEntity;
import com.yqbsoft.laser.service.ims.sap.executes.CALL;
import com.yqbsoft.laser.service.ims.service.DataSynchronousService;
import com.yqbsoft.laser.service.ims.utils.ExcelReadUtil;
import com.yqbsoft.laser.service.ims.utils.GenerateMemberCodeUtil;
import com.yqbsoft.laser.service.ims.utils.InitEntity;
import com.yqbsoft.laser.service.ims.utils.MySqlJDBCUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DataSynchronousServiceImpl
extends BaseServiceImpl
implements DataSynchronousService {
    private static Logger log = LoggerFactory.getLogger(DataSynchronousServiceImpl.class);
    private static List<String> brandList = new ArrayList<String>();
    private static List<AreaEntity> areaList = AreaEntity.getAreaEntityList();
    private static Map<String, String> specGroupData = new HashMap<String, String>();
    private static Map<String, Map<String, String>> brandCodeMap = new Hashtable<String, Map<String, String>>();
    private static final String LAST_SYNCHRONOUS_TIME = "last_time";
    private static List<ImsEntity> imsEntityList = new ArrayList<ImsEntity>();
    private static JsonEntity jsonEntity = null;
    private static Map<String, String> brandContainer = new Hashtable<String, String>();
    private static Map<String, String> specGroupContainer = new Hashtable<String, String>();
    private static Map<String, String> goodsTypeContainer = new Hashtable<String, String>();
    private static Map<String, String> classTreeContainer = new Hashtable<String, String>();
    private static Map<String, String> class3TreeContainer = new Hashtable<String, String>();
    private static Map<String, String> companyCode = new HashMap<String, String>();
    private static Map<String, String> areaCode = new HashMap<String, String>();
    public static final String zooc = "ZOOC";
    public static final String lancy = "LANCY";
    public static final String areaDomain = "areaDomain.xlsx";
    public static final String city = "city.xlsx";
    public static final String userData = "demo01.xlsx";

    public void init() throws SQLException, ParseException {
        imsEntityList = InitEntity.init();
        jsonEntity = CALL.callRfcExample();
    }

    public static void main(String[] args) {
        new DataSynchronousServiceImpl().goodsDataSynchronous();
    }

    @Override
    public Boolean goodsDataSynchronous() {
        this.init();
        if (CollectionUtils.isEmpty(imsEntityList) || Objects.isNull(jsonEntity)) {
            log.info("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
            return false;
        }
        Map<String, List<ImsEntity>> imsMap = this.handleImsGoods();
        Iterator<Map.Entry<String, List<ImsEntity>>> iterator = imsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            brandContainer = new Hashtable<String, String>();
            specGroupContainer = new Hashtable<String, String>();
            goodsTypeContainer = new Hashtable<String, String>();
            classTreeContainer = new Hashtable<String, String>();
            Map.Entry<String, List<ImsEntity>> next = iterator.next();
            String key = LancyWithB2cMapEnum.getByValue(next.getKey()).getCode();
            List<ImsEntity> imsList = next.getValue();
            this.synchronousBasisInfo(imsList, jsonEntity, key);
            log.info("\u54c1\u724c\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(brandContainer));
            log.info("\u5546\u54c1\u89c4\u683c\u7ec4\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(specGroupContainer));
            log.info("\u5546\u54c1\u7c7b\u578b\u7ec4\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsTypeContainer));
            this.synchronousClasstree(imsList, jsonEntity, key);
            log.info("\u4fdd\u5b58\u540e\u53f0\u5206\u7c7b\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(classTreeContainer));
            this.synchronousSaveGoodsParam(imsList, jsonEntity, key);
            this.assemblyGoods(key, imsList);
        }
        log.info("\u65b9\u6cd5\u7ed3\u675f");
        return Boolean.TRUE;
    }

    private void synchronousSaveGoodsParam(List<ImsEntity> imsList, JsonEntity jsonEntity, String memberCode) {
        if (CollectionUtils.isEmpty(goodsTypeContainer)) {
            return;
        }
        for (Map.Entry<String, String> next : goodsTypeContainer.entrySet()) {
            String ptreeName = next.getKey();
            String ptreeCode = next.getValue();
            List<RsPropertiesReDomain> rsPropertiesReDomains = this.queryPropertiesPage(ptreeCode);
            if (CollectionUtils.isEmpty(rsPropertiesReDomains)) {
                this.saveProperties(ptreeCode, memberCode);
                continue;
            }
            List collect = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> ptreeCode.equals(rsPropertiesReDomain.getPntreeCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) continue;
            this.saveProperties(ptreeCode, memberCode);
        }
    }

    private void saveProperties(String ptreeCode, String memberCode) {
        this.saveProperties(ptreeCode, "\u662f\u5426\u6709\u9970\u54c1", memberCode);
        this.saveProperties(ptreeCode, "\u4ea7\u54c1\u7ebf", memberCode);
        this.saveProperties(ptreeCode, "\u5e74\u4efd", memberCode);
        this.saveProperties(ptreeCode, "\u4ea7\u54c1\u5b63", memberCode);
        this.saveProperties(ptreeCode, "\u6ce2\u6bb5", memberCode);
        this.saveProperties(ptreeCode, "\u7cfb\u5217", memberCode);
        this.saveProperties(ptreeCode, "\u98ce\u683c", memberCode);
        this.saveProperties(ptreeCode, "\u4e3b\u9898", memberCode);
        this.saveProperties(ptreeCode, "\u53ef\u62c6\u5378\u914d\u4ef6\u6570\u91cf", memberCode);
        this.saveProperties(ptreeCode, "\u662f\u5426\u8ffd\u5355\u6b3e", memberCode);
        this.saveProperties(ptreeCode, "\u4e3b\u6210\u5206\u6bd4", memberCode);
        this.saveProperties(ptreeCode, "\u514b\u91cd", memberCode);
        this.saveProperties(ptreeCode, "\u59c6\u7c73\u6570", memberCode);
    }

    private String saveProperties(String ptreeCode, String name, String memberCode) {
        String code = LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode();
        this.logger.info("APPcode:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)code));
        RsPropertiesDomain rsPropertiesDomain = new RsPropertiesDomain();
        rsPropertiesDomain.setPntreeCode(ptreeCode);
        rsPropertiesDomain.setPropertiesName(name);
        rsPropertiesDomain.setPropertiesType("1");
        rsPropertiesDomain.setAppmanageIcode(code);
        rsPropertiesDomain.setTenantCode("2022012800000001");
        log.info("\u4fdd\u5b58\u5c5e\u6027\u503c\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)rsPropertiesDomain));
        return this.saveProperties(rsPropertiesDomain);
    }

    private String saveProperties(RsPropertiesDomain ptreeCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsPropertiesDomain", JsonUtil.buildNormalBinder().toJson((Object)ptreeCode));
        Object o = this.getInternalRouter().inInvoke("rs.properties.saveProperties", pmap);
        log.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
        return (String)o;
    }

    private String saveClassGoods(RsGoodsClassDomain rsGoodsClassDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsGoodsClassDomain", JsonUtil.buildNormalBinder().toJson((Object)rsGoodsClassDomain));
        Object o = this.getInternalRouter().inInvoke("rs.resource.saveGoodsClass", pmap);
        log.info("\u4fdd\u5b58\u524d\u53f0\u5206\u7c7b\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", rsGoodsClassDomain.getTenantCode());
        param.put("memberCode", rsGoodsClassDomain.getMemberCode());
        param.put("fuzzy", true);
        param.put("channelCode", rsGoodsClassDomain.getChannelCode());
        param.put("goodsClassEocode", rsGoodsClassDomain.getGoodsClassEocode());
        HashMap<String, String> pmap1 = new HashMap<String, String>();
        pmap1.put("map", JsonUtil.buildNormalBinder().toJson(param));
        QueryResult reDomainSupQueryResult = this.getQueryResutl("rs.goodsClass.queryGoodsClassPage", pmap1, RsGoodsClassReDomain.class);
        return ((RsGoodsClassReDomain)reDomainSupQueryResult.getList().get(0)).getGoodsClassCode();
    }

    private List<RsPropertiesReDomain> queryPropertiesPage(String ptreeCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pntreeCode", ptreeCode);
        map.put("fuzzy", true);
        map.put("tenantCode", "2022012800000001");
        log.info("\u8bf7\u6c42\u6240\u6709\u5c5e\u6027\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonNullBinder().toJson(map));
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.properties.queryPropertiesPage", pmap, RsPropertiesReDomain.class);
        this.logger.info("\u83b7\u53d6\u6240\u6709\u5c5e\u6027\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rs));
        return rs.getList();
    }

    @Override
    public Boolean shoppersOrStoresSynchronous() {
        List<AreaDomainEntity> areaDomainEntities = ExcelReadUtil.loadScoreInfo(areaDomain, new AreaDomainEntity()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (this.areaDataSynchronous(areaDomainEntities = areaDomainEntities.stream().filter(ele -> ele.getDivision() != null).filter(ele -> lancy.equals(ele.getDivision()) || "LIME".equals(ele.getDivision())).collect(Collectors.toList())).booleanValue()) {
            log.info("\u540c\u6b65\u533a\u57df\u5b8c\u6210");
            String sql = "SELECT * from ZDPSX WHERE VALID = 'X' and GJAHR = YEAR(NOW()) and (BUNIT = 'LANCY' or BUNIT = 'LIME')";
            List<StoreEntity> list = MySqlJDBCUtil.executeQuery(sql, new StoreEntity());
            log.info("\u67e5\u8be2\u51fa\u7684\u6761\u6570::{}", (Object)list.size());
            if (this.storesDataSynchronous(list).booleanValue()) {
                log.info("\u540c\u6b65\u95e8\u5e97\u5b8c\u6210");
                log.info("\u540c\u6b65\u533a\u57df\u5b8c\u6210");
            }
        }
        return Boolean.TRUE;
    }

    private Map<String, List<ImsEntity>> handleImsGoods() {
        List<ImsEntity> list = imsEntityList.stream().filter(imsEntity -> StringUtils.isNotBlank((String)imsEntity.getSizeGroup())).filter(imsEntity -> LancyWithB2cMapEnum.getByValue(imsEntity.getBrand()) != null).collect(Collectors.toList());
        return this.imsGoodsFlite(list);
    }

    private Map<String, List<ImsEntity>> imsGoodsFlite(List<ImsEntity> list) {
        HashMap<String, List<ImsEntity>> goodsMap = new HashMap<String, List<ImsEntity>>();
        for (ImsEntity imsEntity : list) {
            String brand = imsEntity.getBrand();
            if (goodsMap.containsKey(brand)) {
                ((List)goodsMap.get(brand)).add(imsEntity);
                continue;
            }
            ArrayList<ImsEntity> arr = new ArrayList<ImsEntity>();
            arr.add(imsEntity);
            goodsMap.put(brand, arr);
        }
        return goodsMap;
    }

    public DisChannelDomain queryChannelPage(String memBerCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memBerCode);
        map.put("tenantCode", tenantCode);
        map.put("fuzzy", true);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("dis.channel.queryChannelPage", pmap, DisChannelDomain.class);
        this.logger.info("\u83b7\u53d6\u7684\u6e20\u9053\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rs));
        return (DisChannelDomain)rs.getList().stream().filter(Objects::nonNull).filter(ele -> ele.getChannelCode() != null && ele.getChannelName() != null).collect(Collectors.toList()).get(0);
    }

    public List<RsBrandDomain> queryBrandPage(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        log.info("queryBrandPage::{}", pmap);
        QueryResult brandRs = this.getQueryResutl("rs.brand.queryBrandPage", pmap, RsBrandDomain.class);
        log.info("\u83b7\u53d6\u5168\u90e8\u54c1\u724cbrandRs::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)brandRs));
        if (null == brandRs) {
            return null;
        }
        return brandRs.getList();
    }

    public String saveBrand(String memberCode, Mvgr1Entity mvgr1Entity) {
        RsBrandDomain brandDomain = new RsBrandDomain();
        brandDomain.setMemberCode(memberCode);
        brandDomain.setBrandName(mvgr1Entity.getBEZEI());
        brandDomain.setMemo(mvgr1Entity.getMVGR1());
        brandDomain.setTenantCode("2022012800000001");
        brandDomain.setBrandEocode(mvgr1Entity.getMVGR1());
        brandDomain.setBrandLogo("\u540c\u6b65\u6570\u636e\u6682\u65e0\u54c1\u724c\u56fe\u7247");
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, "2022012800000001");
        brandDomain.setChannelCode(disChannelDomain.getChannelCode());
        brandDomain.setChannelName(disChannelDomain.getChannelName());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)brandDomain));
        log.info("rsBrandDomain::{}", pmap);
        String brandCode = null;
        try {
            Object brand = this.getInternalRouter().inInvoke("rs.resource.sendSaveBrand", pmap);
            log.info("brand::{}", brand);
            brandCode = brand.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6dfb\u52a0\u54c1\u724c\u8fd4\u56de\u7684id::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(brandCode));
        return brandCode;
    }

    public void synchronousBrand(List<String> brandList, JsonEntity jsonEntity, String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", "2022012800000001");
        map.put("page", 1);
        map.put("rows", 100000);
        List<RsBrandDomain> queryBrand = this.queryBrandPage(map);
        for (String brand : brandList) {
            List collect;
            if (!CollectionUtils.isEmpty(queryBrand) && !CollectionUtils.isEmpty(collect = queryBrand.stream().filter(b -> brand.equals(b.getBrandEocode())).collect(Collectors.toList()))) {
                brandContainer.put(brand, ((RsBrandDomain)collect.get(0)).getBrandCode());
                continue;
            }
            List mvgr1EntityList = jsonEntity.getMVGR1().stream().filter(entity -> brand.equals(entity.getMVGR1())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(mvgr1EntityList)) {
                log.info("\u8be5\u54c1\u724ccode\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)brand));
                continue;
            }
            Mvgr1Entity mvgr1Entity = (Mvgr1Entity)mvgr1EntityList.get(0);
            String code = this.saveBrand(memberCode, mvgr1Entity);
            brandContainer.put(brand, code);
        }
    }

    public List<RsSpecGroupDomain> querySpecGroup(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        map.put("order", true);
        map.put("fuzzy", true);
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        log.info("pmap::{}", pmap);
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecGroupPage", pmap, RsSpecGroupDomain.class);
        log.info("\u83b7\u53d6\u901a\u7528\u89c4\u683c\u7ec4::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)rs));
        return rs.getList();
    }

    public SupQueryResult<RsSpecDomain> querySpecPage(String specGroupCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupCode", specGroupCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecPage", pmap, RsSpecDomain.class);
        return rs;
    }

    public List<RsSpecOptionDomain> querySpecOptionPage(String specCode, String specOptionNum) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specCode", specCode);
        map.put("specOptionNum", specOptionNum);
        map.put("fuzzy", true);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.spec.querySpecOptionPage", pmap, RsSpecOptionDomain.class).getList();
    }

    public List<RsSpecOptionDomain> querySpecOptionPage1(String specCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specGroupCode", specCode);
        map.put("tenantCode", "2022012800000001");
        map.put("fuzzy", true);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.spec.querySpecOptionPage", pmap, RsSpecOptionDomain.class).getList();
    }

    public String saveSpecGroup(String channelCode, String memberCode, String tenantCode, String specGroupNam) {
        RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
        rsSpecGroupDomain.setSpecGroupName(specGroupNam);
        rsSpecGroupDomain.setChannelCode(channelCode);
        rsSpecGroupDomain.setMemberCode(memberCode);
        rsSpecGroupDomain.setMemo(specGroupNam);
        rsSpecGroupDomain.setTenantCode(tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecGroupDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain));
        log.info("pmap\u4fdd\u5b58\u89c4\u683c\u7ec4::{}", pmap);
        String specGroupCode = this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", pmap).toString();
        specGroupData.put(specGroupNam, specGroupCode);
        return specGroupCode;
    }

    public String saveSpec(String specGroupCode, String specName, String tenantCode) {
        RsSpecDomain rsSpecDomain = new RsSpecDomain();
        rsSpecDomain.setSpecGroupCode(specGroupCode);
        rsSpecDomain.setSpecName(specName);
        rsSpecDomain.setTenantCode(tenantCode);
        rsSpecDomain.setSpecDefault("1");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain));
        return this.getInternalRouter().inInvoke("rs.spec.saveSpec", pmap).toString();
    }

    public Boolean saveSpecOption(List<RsSpecOptionDomain> rsSpecOptionDomains) {
        for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecOptionDomains) {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("rsSpecOptionDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain));
            this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", pmap);
        }
        return Boolean.TRUE;
    }

    public void synchronousSpecInfo(String memberCode, List<ImsEntity> imsList, JsonEntity jsonEntity) {
        Map<String, Set<String>> specGroupMap = this.specGroupHandle(imsList);
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, "2022012800000001");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", "2022012800000001");
        map.put("channelCode", disChannelDomain.getChannelCode());
        map.put("page", 1);
        map.put("rows", 1000000);
        List<RsSpecGroupDomain> rsSpecGroupDomain = this.querySpecGroup(map);
        Iterator<String> iterator = specGroupMap.keySet().iterator();
        while (iterator.hasNext()) {
            log.info("\u5f00\u59cb\u5faa\u73af\u65b0\u589e\u89c4\u683c\u7ec4");
            String sizeGroup = iterator.next();
            Set<String> colors = specGroupMap.get(sizeGroup);
            List collect = rsSpecGroupDomain.stream().filter(specGroupDomain -> sizeGroup.equals(specGroupDomain.getMemo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                String specGroupCode = this.saveSpecGroup(disChannelDomain.getChannelCode(), memberCode, "2022012800000001", sizeGroup);
                log.info("\u521b\u5efa\u89c4\u683c\u7ec4 \u751f\u6210\u7684specGroupCode\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)specGroupCode));
                String specCodeColor = this.saveSpec(specGroupCode, "\u989c\u8272", "2022012800000001");
                String specCodeSize = this.saveSpec(specGroupCode, "\u5c3a\u7801", "2022012800000001");
                this.saveSpecGroupAttached(memberCode, jsonEntity, specGroupCode, sizeGroup, colors, specCodeColor, specCodeSize);
                specGroupContainer.put(sizeGroup, specGroupCode);
                continue;
            }
            RsSpecGroupDomain rsSpecGroupDomain1 = (RsSpecGroupDomain)collect.get(0);
            SupQueryResult<RsSpecDomain> rsSpecDomainSupQueryResult = this.querySpecPage(rsSpecGroupDomain1.getSpecGroupCode());
            this.logger.info("rsSpecDomainSupQueryResult:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(rsSpecDomainSupQueryResult));
            List list = rsSpecDomainSupQueryResult.getList();
            String specCodeColor = ((RsSpecDomain)list.stream().filter(rsSpecDomain -> rsSpecDomain.getSpecName().equals("\u989c\u8272")).collect(Collectors.toList()).get(0)).getSpecCode();
            String specCodeSize = ((RsSpecDomain)list.stream().filter(rsSpecDomain -> rsSpecDomain.getSpecName().equals("\u5c3a\u7801")).collect(Collectors.toList()).get(0)).getSpecCode();
            this.saveSpecGroupAttached(memberCode, jsonEntity, rsSpecGroupDomain1.getSpecGroupCode(), sizeGroup, colors, specCodeColor, specCodeSize);
            specGroupContainer.put(sizeGroup, rsSpecGroupDomain1.getSpecGroupCode());
        }
    }

    private void saveSpecGroupAttached(String memberCode, JsonEntity jsonEntity, String specGroupCode, String groupSize, Set<String> colors, String specCodeColor, String specCodeSize) {
        log.info("------\u5f00\u59cb\u65b0\u589e\u89c4\u683c\u7ec4\u7b2c\u4e09\u7ea7------");
        ArrayList<RsSpecOptionDomain> saveSpecOptionSize = new ArrayList<RsSpecOptionDomain>();
        ArrayList<RsSpecOptionDomain> saveSpecOptionColor = new ArrayList<RsSpecOptionDomain>();
        List<SizeEntity> sizeEntities = jsonEntity.getSIZE();
        List groupSizeList = sizeEntities.stream().filter(sizeEntity -> sizeEntity.getZPGNR().equals(groupSize)).collect(Collectors.toList());
        for (SizeEntity sizeEntity2 : groupSizeList) {
            int size = this.querySpecOptionPage(specCodeSize, sizeEntity2.getJSIZE()).size();
            if (size != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainSize = new RsSpecOptionDomain();
            rsSpecOptionDomainSize.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainSize.setSpecCode(specCodeSize);
            rsSpecOptionDomainSize.setSpecOptionName(sizeEntity2.getSIZET());
            rsSpecOptionDomainSize.setSpecOptionNum(sizeEntity2.getJSIZE());
            rsSpecOptionDomainSize.setTenantCode("2022012800000001");
            rsSpecOptionDomainSize.setMemberCode(memberCode);
            saveSpecOptionSize.add(rsSpecOptionDomainSize);
        }
        List<ColorEntity> colorEntityList = jsonEntity.getCOLOR();
        for (String color : colors) {
            List collect = colorEntityList.stream().filter(colorEntity -> colorEntity.getJ_3ACOL().equals(color)).collect(Collectors.toList());
            ColorEntity colorEntity2 = (ColorEntity)collect.get(0);
            if (this.querySpecOptionPage(specCodeColor, colorEntity2.getJ_3ACOL()).size() != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainContro = new RsSpecOptionDomain();
            rsSpecOptionDomainContro.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainContro.setSpecCode(specCodeColor);
            rsSpecOptionDomainContro.setSpecOptionName(colorEntity2.getTEXT());
            rsSpecOptionDomainContro.setSpecOptionNum(colorEntity2.getJ_3ACOL());
            rsSpecOptionDomainContro.setTenantCode("2022012800000001");
            rsSpecOptionDomainContro.setMemberCode(memberCode);
            saveSpecOptionColor.add(rsSpecOptionDomainContro);
        }
        log.info("\u5904\u7406\u5b8c\u540e\u7684\u989c\u8272::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(saveSpecOptionColor));
        log.info("\u5904\u7406\u5b8c\u540e\u7684\u5c3a\u5bf8::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(saveSpecOptionSize));
        if (saveSpecOptionSize.size() != 0) {
            this.saveSpecOption(saveSpecOptionSize);
        }
        if (saveSpecOptionColor.size() != 0) {
            this.saveSpecOption(saveSpecOptionColor);
        }
    }

    private Map<String, Set<String>> specGroupHandle(List<ImsEntity> imsList) {
        log.info("\u5f00\u59cb\u8fc7\u6ee4\u89c4\u683c\u7ec4\u6570\u636e");
        if (CollectionUtils.isEmpty(imsList)) {
            log.info("\u5f00\u59cb\u8fc7\u6ee4\u89c4\u683c\u7ec4\u6570\u636e--\u65e0\u6570\u636e");
            return null;
        }
        HashSet<String> groupSize = new HashSet<String>();
        for (ImsEntity imsEntity : imsList) {
            if (!StringUtils.isNotBlank((String)imsEntity.getSizeGroup())) continue;
            groupSize.add(imsEntity.getSizeGroup());
        }
        log.info("\u8fc7\u6ee4\u540e\u7684\u89c4\u683c\u7ec4--\u5c3a\u5bf8::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(groupSize));
        Hashtable<String, Set<String>> specGroupMap = new Hashtable<String, Set<String>>();
        for (String imsEntity : groupSize) {
            HashSet<String> arr = new HashSet<String>();
            for (int i = 0; i < imsList.size(); ++i) {
                if (!StringUtils.isNotBlank((String)imsList.get(i).getSizeGroup()) || !imsList.get(i).getSizeGroup().equals(imsEntity)) continue;
                arr.add(imsList.get(i).getColor());
            }
            specGroupMap.put(imsEntity, arr);
        }
        return specGroupMap;
    }

    public List<RsPntreeReDomain> queryPntreePage(String tenantCode, String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberCode", memberCode);
        map.put("fuzzy", true);
        map.put("page", 1);
        map.put("rows", 1000000);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rsPntreeReDomains = this.getQueryResutl("rs.pntree.queryPntreePage", pmap, RsPntreeReDomain.class);
        log.info("rsPntreeReDomains::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)rsPntreeReDomains));
        if (null == rsPntreeReDomains) {
            return null;
        }
        return rsPntreeReDomains.getList();
    }

    public String savePntree(String specGroupCode, String tenantCode, String brandCodeStr, String pntreeName, String memberCode) {
        RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
        rsPntreeDomain.setPntreeName(pntreeName);
        rsPntreeDomain.setSpecGroupCodeStr(specGroupCode);
        rsPntreeDomain.setTenantCode(tenantCode);
        rsPntreeDomain.setBrandCodeStr(brandCodeStr);
        rsPntreeDomain.setPntreeShow(0);
        rsPntreeDomain.setPntreeEocode(pntreeName);
        rsPntreeDomain.setAppmanageIcode(LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsPntreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsPntreeDomain));
        log.info("pmap::{}", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
        Object pntreeObj = this.getInternalRouter().inInvoke("rs.pntree.savePntree", pmap);
        log.info("pntreeObj::{}", (Object)pntreeObj.toString());
        return pntreeObj.toString();
    }

    public Boolean synchronousPntree(List<ImsEntity> imsList, String memberCode) {
        List<RsPntreeReDomain> pntreeRs = this.queryPntreePage("2022012800000001", memberCode);
        if (ListUtil.isNotEmpty(pntreeRs)) {
            for (RsPntreeReDomain rsPntreeReDomain : pntreeRs) {
                if (!StringUtils.isNotBlank((String)rsPntreeReDomain.getPntreeEocode())) continue;
                goodsTypeContainer.put(rsPntreeReDomain.getPntreeEocode(), rsPntreeReDomain.getPntreeCode());
            }
        }
        if (ListUtil.isNotEmpty(pntreeRs)) {
            for (Map.Entry<String, String> next : specGroupContainer.entrySet()) {
                String key = next.getKey();
                String value = next.getValue();
                List collect = pntreeRs.stream().filter(rs -> key.equals(rs.getPntreeEocode())).collect(Collectors.toList());
                boolean empty = CollectionUtils.isEmpty(collect);
                log.info("\u89c4\u683c\u7ec4\u662f\u5426\u5df2\u7ecf\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)empty));
                String pntreeCode = null;
                if (empty) {
                    String brandCodeStr = null;
                    if (!CollectionUtils.isEmpty(brandContainer)) {
                        brandCodeStr = this.getSpecGroupBrand(key, imsList, brandContainer);
                    }
                    pntreeCode = this.savePntree(value, "2022012800000001", brandCodeStr, key, memberCode);
                    log.info("pntreeCode2::{}", (Object)pntreeCode);
                } else {
                    RsPntreeReDomain rsPntreeReDomain = (RsPntreeReDomain)collect.get(0);
                    pntreeCode = rsPntreeReDomain.getPntreeCode();
                }
                goodsTypeContainer.put(key, pntreeCode);
            }
        } else {
            for (Map.Entry<String, String> next : specGroupContainer.entrySet()) {
                String key = next.getKey();
                String value = next.getValue();
                String brandCodeStr = null;
                if (!CollectionUtils.isEmpty(brandCodeMap)) {
                    brandCodeStr = this.getSpecGroupBrand(key, imsList, brandCodeMap.get(memberCode));
                }
                String pntreeCode = this.savePntree(value, "2022012800000001", brandCodeStr, key, memberCode);
                log.info("pntreeCode2::{}", (Object)pntreeCode);
                goodsTypeContainer.put(key, pntreeCode);
            }
        }
        return Boolean.TRUE;
    }

    private String getSpecGroupBrand(String sizeGroup, List<ImsEntity> imsList, Map<String, String> brandCodeMap) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u6240\u5c5e\u7684\u54c1\u724c");
        String brandStr = null;
        for (int i = 0; i < imsList.size(); ++i) {
            String s;
            ImsEntity imsEntity = imsList.get(i);
            if (!sizeGroup.equals(imsEntity.getSizeGroup()) || !StringUtils.isBlank(brandStr) && brandStr.contains(imsEntity.getSubBrand())) continue;
            if (StringUtils.isBlank(brandStr)) {
                s = brandCodeMap.get(imsEntity.getSubBrand());
                if (!StringUtils.isNotBlank((String)s)) continue;
                brandStr = s;
                continue;
            }
            s = brandCodeMap.get(imsEntity.getSubBrand());
            if (!StringUtils.isNotBlank((String)s)) continue;
            brandStr = brandStr + "," + s;
        }
        log.info("\u7ed3\u675f\u5f00\u59cb\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u6240\u5c5e\u7684\u54c1\u724c,\u53c2\u6570:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(brandStr));
        return brandStr;
    }

    public Boolean synchronousBasisInfo(List<ImsEntity> imsList, JsonEntity jsonEntity, String memberCode) {
        brandList = this.brandHandle(imsList);
        if (!ListUtil.isEmpty(brandList)) {
            this.synchronousBrand(brandList, jsonEntity, memberCode);
        }
        this.synchronousSpecInfo(memberCode, imsList, jsonEntity);
        if (!CollectionUtils.isEmpty(specGroupContainer)) {
            this.synchronousPntree(imsList, memberCode);
        }
        return Boolean.TRUE;
    }

    private List<String> brandHandle(List<ImsEntity> imsList) {
        ArrayList<String> list = new ArrayList<String>();
        for (ImsEntity imsEntity : imsList) {
            String subBrand = imsEntity.getSubBrand();
            if (!StringUtils.isNotBlank((String)subBrand) || list.contains(subBrand)) continue;
            list.add(subBrand);
        }
        log.info("\u8fc7\u6ee4\u540e\u7684\u54c1\u724c\u4e3a::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(list));
        return list;
    }

    public List<RsClasstreeReDomain> queryClasstreePage(String tenantCode, String memberCode, String channelCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("memberCode", memberCode);
        param.put("classtreeType", "0");
        param.put("fuzzy", true);
        param.put("channelCode", channelCode);
        param.put("page", 1);
        param.put("rows", 1000000);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        QueryResult reDomainSupQueryResult = this.getQueryResutl("rs.rsClasstree.queryClasstreePage", pmap, RsClasstreeReDomain.class);
        ArrayList<RsClasstreeReDomain> reDomainList = new ArrayList<RsClasstreeReDomain>();
        if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return reDomainList;
        }
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsClasstreeReDomain> rootClass = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!"-1".equals(rsClasstreeReDomain.getClasstreeParentcode())) continue;
            rootClass.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : rootClass) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        return rootClass;
    }

    public List<RsClasstreeReDomain> getChild(String id, List<RsClasstreeReDomain> all) {
        ArrayList<RsClasstreeReDomain> childList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!StringUtils.isNotBlank((String)rsClasstreeReDomain.getClasstreeParentcode()) || !rsClasstreeReDomain.getClasstreeParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    public String saveClasstree(RsClasstreeReDomain rsClasstreeDomain, List<String> list) {
        Objects.requireNonNull(list, "list\u4e3a\u83b7\u53d6\u7684\u5206\u7c7b\u7c7b\u578b");
        rsClasstreeDomain.setTenantCode("2022012800000001");
        rsClasstreeDomain.setMemo(list.get(0));
        rsClasstreeDomain.setClasstreeName(list.get(1));
        rsClasstreeDomain.setClasstreeType("0");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
        log.info("pmapclass::{}", pmap);
        Object classtreeCode = this.getInternalRouter().inInvoke("rs.resource.sendSaveClasstree", pmap);
        log.info("classtreeCode::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(classtreeCode));
        return (String)classtreeCode;
    }

    public List<String> getClasstreeInfo(JsonEntity jsonEntity, Integer source, String code) {
        if (jsonEntity.getLCLS() != null && source == 1) {
            LclsEntity lclsEntity = jsonEntity.getLCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getLABOR() != null && ele.getLBTXT() != null).filter(ele -> ele.getLABOR().equals(code)).findFirst().get();
            return Arrays.asList(lclsEntity.getLABOR(), lclsEntity.getLBTXT());
        }
        if (jsonEntity.getMCLS() != null && source == 2) {
            MclsEntity mclsEntity = jsonEntity.getMCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getMATKL() != null && ele.getWGBEZ() != null).filter(ele -> ele.getMATKL().equals(code)).findFirst().get();
            return Arrays.asList(mclsEntity.getMATKL(), mclsEntity.getWGBEZ());
        }
        if (jsonEntity.getSCLS() != null && source == 3) {
            SclsEntity sclsEntity = jsonEntity.getSCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getEXTWG() != null && ele.getEWBEZ() != null).filter(ele -> ele.getEXTWG().equals(code)).findFirst().get();
            return Arrays.asList(sclsEntity.getEXTWG(), sclsEntity.getEWBEZ());
        }
        return null;
    }

    public String structureGoodsClasstreeInfo(Integer source, ImsEntity ims, JsonEntity jsonEntity, String classtreeParentcode) {
        String memberCode = LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode();
        RsGoodsClassDomain classtreeDomain = new RsGoodsClassDomain();
        classtreeDomain.setChannelCode(this.queryChannelPage(memberCode, "2022012800000001").getChannelCode());
        classtreeDomain.setMemberCode(memberCode);
        classtreeDomain.setGoodsClassHide("0");
        classtreeDomain.setTenantCode("2022012800000001");
        classtreeDomain.setAppmanageIcode(LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode());
        if (source == 1) {
            classtreeDomain.setGoodsClassLast("1");
            classtreeDomain.setGoodsClassParentcode("-1");
            classtreeDomain.setGoodsClassEocode(ims.getField3());
            classtreeDomain.setGoodsClassLogo("/paas/shop/2022012800000001/2022-04-17/9525f3825d984d0d9d3d26e7de72aa45.jpeg");
            List<String> classtreeInfo = this.getClasstreeInfo(jsonEntity, source, ims.getField3());
            classtreeDomain.setGoodsClassName(classtreeInfo.get(1));
            return this.saveClassGoods(classtreeDomain);
        }
        if (source == 2) {
            classtreeDomain.setGoodsClassLast("1");
            classtreeDomain.setGoodsClassParentcode(classtreeParentcode);
            classtreeDomain.setGoodsClassEocode(ims.getField5());
            List<String> classtreeInfo = this.getClasstreeInfo(jsonEntity, source, ims.getField5());
            classtreeDomain.setGoodsClassName(classtreeInfo.get(1));
            return this.saveClassGoods(classtreeDomain);
        }
        if (source == 3) {
            classtreeDomain.setGoodsClassLast("0");
            classtreeDomain.setGoodsClassParentcode(classtreeParentcode);
            classtreeDomain.setGoodsClassEocode(ims.getField4());
            classtreeDomain.setGoodsClassLogo("/paas/shop/2022012800000001/2022-04-17/9525f3825d984d0d9d3d26e7de72aa45.jpeg");
            if (StringUtils.isNotBlank((String)ims.getField4())) {
                classtreeDomain.setClasstreeCode(class3TreeContainer.get(ims.getField4()));
            }
            List<String> classtreeInfo = this.getClasstreeInfo(jsonEntity, source, ims.getField4());
            classtreeDomain.setGoodsClassName(classtreeInfo.get(1));
            return this.saveClassGoods(classtreeDomain);
        }
        return null;
    }

    public String structureClasstreeInfo(Integer source, ImsEntity ims, JsonEntity jsonEntity, String classtreeParentcode) {
        String memberCode = LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode();
        RsClasstreeReDomain classtreeDomain = new RsClasstreeReDomain();
        classtreeDomain.setChannelCode(this.queryChannelPage(memberCode, "2022012800000001").getChannelCode());
        classtreeDomain.setMemberCode(memberCode);
        classtreeDomain.setClasstreeLast("1");
        classtreeDomain.setAppmanageIcode(LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode());
        if (source == 1) {
            classtreeDomain.setClasstreeParentcode("-1");
            classtreeDomain.setClasstreeEocode(ims.getField3());
            return this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField3()));
        }
        if (source == 2) {
            classtreeDomain.setClasstreeParentcode(classtreeParentcode);
            classtreeDomain.setClasstreeEocode(ims.getField5());
            return this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField5()));
        }
        if (source == 3) {
            classtreeDomain.setClasstreeParentcode(classtreeParentcode);
            classtreeDomain.setClasstreeEocode(ims.getField4());
            if (StringUtils.isNotBlank((String)ims.getSizeGroup())) {
                classtreeDomain.setPntreeCode(goodsTypeContainer.get(ims.getSizeGroup()));
            }
            classtreeDomain.setClasstreeLast("0");
            return this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField4()));
        }
        return null;
    }

    public void synchronousClasstree(List<ImsEntity> imsList, JsonEntity jsonEntity, String memberCode) {
        log.info("\u5f00\u59cb\u540c\u6b65\u540e\u53f0\u5206\u7c7b");
        for (ImsEntity ims : imsList) {
            this.saveClasstree(jsonEntity, ims, memberCode);
            this.saveGoodsClassTree(jsonEntity, ims, memberCode);
        }
    }

    private void saveGoodsClassTree(JsonEntity jsonEntity, ImsEntity ims, String memberCode) {
        List<RsGoodsClassReDomain> rsClasstreeReDomains = this.queryClassGoodsTreePage("2022012800000001", memberCode, this.queryChannelPage(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "2022012800000001").getChannelCode());
        log.info("\u83b7\u53d6\u7684\u524d\u7aef\u4e00\u7ea7\u5206\u7c7b\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(rsClasstreeReDomains));
        if (rsClasstreeReDomains != null) {
            log.info("\u5b58\u5728\u7684\u524d\u7aef\u4e00\u7ea7\u5206\u7c7b");
            List collect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> ele.getGoodsClassCode() != null && ele.getGoodsClassEocode() != null).filter(ele -> ele.getGoodsClassEocode().equals(ims.getField3()) && memberCode.equals(ele.getMemberCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                log.info("\u5b58\u5728\u7684\u524d\u7aef\u76f8\u540c\u7684\u4e00\u7ea7\u5206\u7c7b");
                RsGoodsClassReDomain reDomain = (RsGoodsClassReDomain)collect.get(0);
                List<RsGoodsClassReDomain> childList1 = reDomain.getChildList();
                if (CollectionUtils.isEmpty(childList1)) {
                    log.info("\u4e0d\u5b58\u5728\u524d\u7aef\u4e2d\u7c7b");
                    String classtreeCode = reDomain.getGoodsClassCode();
                    log.info("\u524d\u7aef\u5206\u7c7bgoodsClasstreeCode::\u4e8c\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                    String mclsSaveCode = this.structureGoodsClasstreeInfo(2, ims, jsonEntity, classtreeCode);
                    String string = this.structureGoodsClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                } else {
                    log.info("\u5b58\u5728\u524d\u7aef\u5206\u7c7b\u4e2d\u7c7b");
                    List collectMiddle = childList1.stream().filter(Objects::nonNull).filter(ele -> ele.getGoodsClassEocode() != null).filter(ele -> ele.getGoodsClassEocode().equals(ims.getField5()) && memberCode.equals(ele.getMemberCode())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(collectMiddle)) {
                        log.info("\u4e0d\u5b58\u5728\u524d\u7aef\u4e2d\u7c7b");
                        String classtreeCode = reDomain.getGoodsClassCode();
                        log.info("\u524d\u7aef\u5206\u7c7bclasstreeCode::\u4e8c\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                        String mclsSaveCode = this.structureGoodsClasstreeInfo(2, ims, jsonEntity, classtreeCode);
                        log.info("\u524d\u7aef\u5206\u7c7bmclsSaveCode::{}", (Object)mclsSaveCode);
                        String sclsSaveCode = this.structureGoodsClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                        log.info("\u524d\u7aef\u5206\u7c7bsclsSaveCode::{}", (Object)sclsSaveCode);
                    } else {
                        log.info("\u5b58\u5728\u524d\u7aef\u4e2d\u7c7b");
                        RsGoodsClassReDomain reDomain1 = (RsGoodsClassReDomain)collectMiddle.get(0);
                        List<RsGoodsClassReDomain> childList = reDomain1.getChildList();
                        if (CollectionUtils.isEmpty(childList)) {
                            log.info("\u4e0d\u5b58\u5728\u524d\u7aef\u5c0f\u7c7b");
                            String classtreeParentcode = reDomain1.getGoodsClassCode();
                            log.info("\u524d\u7aef\u5206\u7c7bclasstreeCode::\u4e09\u7ea7\u7ea7\u8d4b\u503c::{}", (Object)classtreeParentcode);
                            this.structureGoodsClasstreeInfo(3, ims, jsonEntity, classtreeParentcode);
                        } else {
                            log.info("\u5b58\u5728\u524d\u7aef\u5c0f\u7c7b");
                            List collectMin = childList.stream().filter(Objects::nonNull).filter(ele -> ele.getGoodsClassEocode().equals(ims.getField4()) && memberCode.equals(ele.getMemberCode())).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(collectMin)) {
                                log.info("\u4e0d\u5b58\u5728\u524d\u7aef\u5c0f\u7c7b");
                                String classtreeCode = reDomain1.getGoodsClassCode();
                                log.info("\u524d\u7aef\u5206\u7c7bclasstreeCode::\u4e09\u7ea7\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                                this.structureGoodsClasstreeInfo(3, ims, jsonEntity, classtreeCode);
                            } else {
                                log.info("\u5b58\u5728\u76f8\u540c\u5c0f\u7c7b");
                            }
                        }
                    }
                }
                log.info("lcls::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)reDomain));
            } else {
                log.info("\u4e0d\u5b58\u524d\u7aef\u5c0f\u7c7b");
                String lclsSaveCode = this.structureGoodsClasstreeInfo(1, ims, jsonEntity, null);
                String mclsSaveCode = this.structureGoodsClasstreeInfo(2, ims, jsonEntity, lclsSaveCode);
                String string = this.structureGoodsClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
            }
        } else {
            log.info("\u4e0d\u5b58\u5728\u5927\u7c7b");
            String lclsSaveCode = this.structureGoodsClasstreeInfo(1, ims, jsonEntity, null);
            String mclsSaveCode = this.structureGoodsClasstreeInfo(2, ims, jsonEntity, lclsSaveCode);
            String string = this.structureGoodsClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
        }
    }

    private List<RsGoodsClassReDomain> queryClassGoodsTreePage(String tenantCode, String memberCode, String channelCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("memberCode", memberCode);
        param.put("fuzzy", true);
        param.put("channelCode", channelCode);
        param.put("page", 1);
        param.put("rows", 1000000);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        QueryResult reDomainSupQueryResult = this.getQueryResutl("rs.goodsClass.queryGoodsClassPage", pmap, RsGoodsClassReDomain.class);
        ArrayList<RsGoodsClassReDomain> reDomainList = new ArrayList<RsGoodsClassReDomain>();
        if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return reDomainList;
        }
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsGoodsClassReDomain> rootClass = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClassReDomain rsClasstreeReDomain : all) {
            if (!"-1".equals(rsClasstreeReDomain.getGoodsClassParentcode())) continue;
            rootClass.add(rsClasstreeReDomain);
        }
        for (RsGoodsClassReDomain rsClasstreeReDomain : rootClass) {
            rsClasstreeReDomain.setChildList(this.getGoodsChild(rsClasstreeReDomain.getGoodsClassCode(), all));
        }
        return rootClass;
    }

    public List<RsGoodsClassReDomain> getGoodsChild(String id, List<RsGoodsClassReDomain> all) {
        ArrayList<RsGoodsClassReDomain> childList = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClassReDomain rsClasstreeReDomain : all) {
            if (!StringUtils.isNotBlank((String)rsClasstreeReDomain.getGoodsClassParentcode()) || !rsClasstreeReDomain.getGoodsClassParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsGoodsClassReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getGoodsChild(rsClasstreeReDomain.getGoodsClassCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    private void saveClasstree(JsonEntity jsonEntity, ImsEntity ims, String memberCode) {
        List<RsClasstreeReDomain> rsClasstreeReDomains = this.queryClasstreePage("2022012800000001", memberCode, this.queryChannelPage(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "2022012800000001").getChannelCode());
        log.info("\u83b7\u53d6\u7684\u4e00\u7ea7\u5206\u7c7b\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(rsClasstreeReDomains));
        if (rsClasstreeReDomains != null) {
            log.info("\u5b58\u5728\u5927\u7c7b");
            List collect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeCode() != null && ele.getClasstreeEocode() != null).filter(ele -> ele.getClasstreeEocode().equals(ims.getField3()) && memberCode.equals(ele.getMemberCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                List<RsClasstreeReDomain> childList2;
                List collectMiddle;
                log.info("\u5b58\u5728\u76f8\u540c\u5927\u7c7b");
                RsClasstreeReDomain reDomain = (RsClasstreeReDomain)collect.get(0);
                List<RsClasstreeReDomain> childList1 = reDomain.getChildList();
                if (CollectionUtils.isEmpty(childList1)) {
                    log.info("\u4e0d\u5b58\u5728\u4e2d\u7c7b");
                    String classtreeCode = reDomain.getClasstreeCode();
                    log.info("classtreeCode::\u4e8c\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                    String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, classtreeCode);
                    String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                    class3TreeContainer.put(ims.getField4(), sclsSaveCode);
                } else {
                    log.info("\u5b58\u5728\u4e2d\u7c7b");
                    collectMiddle = childList1.stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeCode() != null && ele.getMemo() != null).filter(ele -> ele.getClasstreeEocode().equals(ims.getField5()) && memberCode.equals(ele.getMemberCode())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(collectMiddle)) {
                        log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u4e2d\u7c7b");
                        String classtreeCode = reDomain.getClasstreeCode();
                        log.info("classtreeCode::\u4e8c\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                        String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, classtreeCode);
                        log.info("mclsSaveCode::{}", (Object)mclsSaveCode);
                        String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                        log.info("sclsSaveCode::{}", (Object)sclsSaveCode);
                        class3TreeContainer.put(ims.getField4(), sclsSaveCode);
                    } else {
                        log.info("\u5b58\u5728\u76f8\u540c\u4e2d\u7c7b");
                        RsClasstreeReDomain reDomain1 = (RsClasstreeReDomain)collectMiddle.get(0);
                        List<RsClasstreeReDomain> childList = reDomain1.getChildList();
                        if (CollectionUtils.isEmpty(childList)) {
                            log.info("\u4e0d\u5b58\u5728\u5c0f\u7c7b");
                            String classtreeParentcode = reDomain1.getClasstreeCode();
                            log.info("classtreeCode::\u4e09\u7ea7\u7ea7\u8d4b\u503c::{}", (Object)classtreeParentcode);
                            String s = this.structureClasstreeInfo(3, ims, jsonEntity, classtreeParentcode);
                            class3TreeContainer.put(ims.getField4(), s);
                        } else {
                            log.info("\u5b58\u5728\u5c0f\u7c7b");
                            List collectMin = childList.stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeEocode().equals(ims.getField4()) && memberCode.equals(ele.getMemberCode())).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(collectMin)) {
                                log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u5c0f\u7c7b");
                                String classtreeCode = reDomain1.getClasstreeCode();
                                log.info("classtreeCode::\u4e09\u7ea7\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                                String s = this.structureClasstreeInfo(3, ims, jsonEntity, classtreeCode);
                                class3TreeContainer.put(ims.getField4(), s);
                            } else {
                                class3TreeContainer.put(ims.getField4(), ((RsClasstreeReDomain)collectMin.get(0)).getClasstreeCode());
                                log.info("\u5b58\u5728\u76f8\u540c\u5c0f\u7c7b");
                            }
                        }
                    }
                }
                log.info("lcls::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)reDomain));
                classTreeContainer.put(ims.getField3(), reDomain.getClasstreeCode());
                if (!(CollectionUtils.isEmpty(childList1) || CollectionUtils.isEmpty(collectMiddle = childList1.stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeCode() != null && ele.getMemo() != null).filter(ele -> ele.getClasstreeEocode().equals(ims.getField5()) && memberCode.equals(ele.getMemberCode())).collect(Collectors.toList())) || CollectionUtils.isEmpty(childList2 = ((RsClasstreeReDomain)collectMiddle.get(0)).getChildList()))) {
                    class3TreeContainer.put(ims.getField4(), childList2.get(0).getClasstreeCode());
                }
            } else {
                log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u5927\u7c7b");
                String lclsSaveCode = this.structureClasstreeInfo(1, ims, jsonEntity, null);
                String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, lclsSaveCode);
                String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                classTreeContainer.put(ims.getField3(), lclsSaveCode);
                class3TreeContainer.put(ims.getField4(), sclsSaveCode);
            }
        } else {
            log.info("\u4e0d\u5b58\u5728\u5927\u7c7b");
            String lclsSaveCode = this.structureClasstreeInfo(1, ims, jsonEntity, null);
            String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, lclsSaveCode);
            String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
            classTreeContainer.put(ims.getField3(), lclsSaveCode);
            class3TreeContainer.put(ims.getField4(), sclsSaveCode);
        }
    }

    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage(String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("validFlag", true);
        map.put("goodsOrigin", "0");
        map.put("goodsType", "00");
        map.put("fuzzy", "true");
        map.put("memberCode", memberCode);
        map.put("page", 1);
        map.put("rows", 1000000000);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pmap, RsResourceGoodsReDomain.class);
    }

    public SupQueryResult<RsResourceGoodsReDomain> getResourceGoodsTime() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("validFlag", true);
        map.put("goodsOrigin", "0");
        map.put("goodsType", "00");
        map.put("fuzzy", "true");
        map.put("page", 1);
        map.put("rows", 1);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pmap, RsResourceGoodsReDomain.class);
    }

    public void assemblyGoods(String memberCode, List<ImsEntity> imsList) {
        SupQueryResult<RsResourceGoodsReDomain> goods = this.queryResourceGoodsPage(memberCode);
        List list = goods.getList();
        List<UnitEntity> unit = jsonEntity.getUNIT();
        List<Mvgr1Entity> mvgr1 = jsonEntity.getMVGR1();
        List<ColorEntity> color = jsonEntity.getCOLOR();
        List<SizeEntity> size = jsonEntity.getSIZE();
        List<PldzEntity> pldz = jsonEntity.getPLDZ();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", "2022012800000001");
        map.put("fuzzy", true);
        List<RsSpecGroupDomain> rsSpecGroupDomain = this.querySpecGroup(map);
        log.info("\u83b7\u53d6\u89c4\u683c\u7ec4\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(rsSpecGroupDomain));
        List<RsClasstreeReDomain> rsClasstreeReDomains = this.queryClasstreePage("2022012800000001", memberCode, this.queryChannelPage(memberCode, "2022012800000001").getChannelCode());
        for (ImsEntity imsEntity : imsList) {
            List collect;
            if (!CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty(collect = list.stream().filter(Objects::nonNull).filter(l -> l.getGoodsEocode() != null).filter(l -> l.getGoodsEocode().equals(imsEntity.getSpu())).collect(Collectors.toList()))) continue;
            RsResourceGoodsReDomain resourceGoodsParam = this.getResourceGoodsParam(mvgr1, unit, color, size, imsEntity, memberCode, rsSpecGroupDomain, rsClasstreeReDomains, pldz);
            log.info("\u4fdd\u5b58\u7684\u5546\u54c1\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)resourceGoodsParam));
            try {
                if (Objects.isNull(resourceGoodsParam)) continue;
                Thread.sleep(4L);
                this.sendSaveResourceGoods(resourceGoodsParam);
                list.add(resourceGoodsParam);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private RsResourceGoodsReDomain getResourceGoodsParam(List<Mvgr1Entity> mvgr1, List<UnitEntity> unit, List<ColorEntity> colors, List<SizeEntity> sizeGroup, ImsEntity imsEntity, String memberCode, List<RsSpecGroupDomain> rsSpecGroupDomains, List<RsClasstreeReDomain> classtreeReDomains, List<PldzEntity> pldz) {
        List mvgr1Entities = mvgr1.stream().filter(m -> m.getMVGR1().equals(imsEntity.getSubBrand())).collect(Collectors.toList());
        log.info("\u54c1\u724c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(mvgr1Entities));
        List unitEntityList = unit.stream().filter(u -> u.getMSEHI().equals(imsEntity.getUnit())).collect(Collectors.toList());
        log.info("\u83b7\u53d6\u7684\u5546\u54c1\u5355\u4f4d\u4e3a\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(unitEntityList));
        List colorEntitieList = colors.stream().filter(u -> u.getJ_3ACOL().equals(imsEntity.getColor())).collect(Collectors.toList());
        log.info("\u83b7\u53d6\u7684\u5546\u54c1\u989c\u8272\u4e3a\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(colorEntitieList));
        List sizeGroupList = sizeGroup.stream().filter(u -> u.getZPGNR().equals(imsEntity.getSizeGroup())).collect(Collectors.toList());
        log.info("\u89c4\u683c\u7ec4\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(sizeGroupList));
        List pldzList = pldz.stream().filter(u -> u.getMATCL().equals(imsEntity.getField32())).collect(Collectors.toList());
        log.info("\u5206\u7c7b\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(pldzList));
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        rsResourceGoodsReDomain.setTenantCode("2022012800000001");
        rsResourceGoodsReDomain.setMemberCode(memberCode);
        rsResourceGoodsReDomain.setMemberCcode(memberCode);
        rsResourceGoodsReDomain.setGoodsType("00");
        rsResourceGoodsReDomain.setGoodsOrigin("0");
        rsResourceGoodsReDomain.setGoodsClass("B2C");
        rsResourceGoodsReDomain.setMemberMcode(memberCode);
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, "2022012800000001");
        rsResourceGoodsReDomain.setChannelCode(disChannelDomain.getChannelCode());
        rsResourceGoodsReDomain.setGoodsPro("0");
        rsResourceGoodsReDomain.setGoodsProperty1(CollectionUtils.isEmpty(pldzList) ? "" : ((PldzEntity)pldzList.get(0)).getLTEXT());
        rsResourceGoodsReDomain.setGoodsProperty2(CollectionUtils.isEmpty(pldzList) ? "" : ((PldzEntity)pldzList.get(0)).getMATCL());
        rsResourceGoodsReDomain.setGoodsSpec(imsEntity.getImgPath());
        rsResourceGoodsReDomain.setGoodsSpec1(imsEntity.getSkc());
        rsResourceGoodsReDomain.setGoodsName(imsEntity.getArticleName());
        rsResourceGoodsReDomain.setPartsnameWeightunit(CollectionUtils.isEmpty(unitEntityList) ? "" : ((UnitEntity)unitEntityList.get(0)).getMSEHT());
        rsResourceGoodsReDomain.setGoodsNo(imsEntity.getSpu());
        if (StringUtils.isNotBlank((String)imsEntity.getSizeGroup())) {
            rsResourceGoodsReDomain.setPntreeCode(goodsTypeContainer.get(imsEntity.getSizeGroup()));
            rsResourceGoodsReDomain.setPntreeName(imsEntity.getSizeGroup());
        }
        rsResourceGoodsReDomain.setPricesetNprice(new BigDecimal("0"));
        rsResourceGoodsReDomain.setPricesetMakeprice(StringUtils.isNotBlank((String)imsEntity.getListPrice()) ? new BigDecimal(imsEntity.getListPrice()) : new BigDecimal("0"));
        rsResourceGoodsReDomain.setPricesetNprice(StringUtils.isNotBlank((String)imsEntity.getListPrice()) ? new BigDecimal(imsEntity.getListPrice()) : new BigDecimal("0"));
        List collect = classtreeReDomains.stream().filter(classtree -> classTreeContainer.get(imsEntity.getField3()).equals(classtree.getClasstreeCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            List<RsClasstreeReDomain> childList = ((RsClasstreeReDomain)collect.get(0)).getChildList();
            for (RsClasstreeReDomain reDomain : childList) {
                List<RsClasstreeReDomain> childList1 = reDomain.getChildList();
                if (CollectionUtils.isEmpty(childList1)) continue;
                for (RsClasstreeReDomain classtree2 : childList1) {
                    if (!classtree2.getClasstreeEocode().equals(imsEntity.getField4())) continue;
                    rsResourceGoodsReDomain.setClasstreeCode(classtree2.getClasstreeCode());
                    rsResourceGoodsReDomain.setClasstreeName(reDomain.getClasstreeName());
                }
            }
        }
        if (StringUtils.isBlank((String)rsResourceGoodsReDomain.getClasstreeCode())) {
            return null;
        }
        rsResourceGoodsReDomain.setGoodsProperty3(imsEntity.getVolume());
        rsResourceGoodsReDomain.setGoodsProperty4(imsEntity.getGrossWeight());
        rsResourceGoodsReDomain.setGoodsProperty5(imsEntity.getNetWeight());
        rsResourceGoodsReDomain.setDataOpbillstate(0);
        rsResourceGoodsReDomain.setGoodsProperty(imsEntity.getArticleName());
        rsResourceGoodsReDomain.setGoodsNum(new BigDecimal(0));
        rsResourceGoodsReDomain.setGoodsEocode(imsEntity.getSpu());
        rsResourceGoodsReDomain.setBrandCode(brandContainer.get(imsEntity.getSubBrand()));
        rsResourceGoodsReDomain.setBrandName(CollectionUtils.isEmpty(mvgr1Entities) ? "" : ((Mvgr1Entity)mvgr1Entities.get(0)).getBEZEI());
        List<RsSpecOptionDomain> rsSpecOptionDomains = null;
        List sizeGrop = rsSpecGroupDomains.stream().filter(rs -> imsEntity.getSizeGroup().equals(rs.getMemo())).collect(Collectors.toList());
        log.info("sizeGrop:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(sizeGrop));
        if (!CollectionUtils.isEmpty(sizeGrop)) {
            rsSpecOptionDomains = this.querySpecOptionPage1(((RsSpecGroupDomain)sizeGrop.get(0)).getSpecGroupCode());
        }
        if (!CollectionUtils.isEmpty(sizeGroupList)) {
            ArrayList<RsSkuDomain> skuList = new ArrayList<RsSkuDomain>();
            ArrayList<RsSpecValueDomain> specList = new ArrayList<RsSpecValueDomain>();
            for (SizeEntity sizeEntity : sizeGroupList) {
                RsSkuDomain rsSkuDomain = new RsSkuDomain();
                rsSkuDomain.setSkuName(((ColorEntity)colorEntitieList.get(0)).getTEXT() + "/" + sizeEntity.getSIZET());
                rsSkuDomain.setSkuNo(imsEntity.getSkc() + sizeEntity.getSIZET());
                rsSkuDomain.setPricesetNprice(new BigDecimal("0"));
                rsSkuDomain.setGoodsNum(new BigDecimal("0"));
                rsSkuDomain.setSkuEocode(imsEntity.getSkc() + sizeEntity.getSIZET());
                rsSkuDomain.setPricesetMakeprice(StringUtils.isNotBlank((String)imsEntity.getListPrice()) ? new BigDecimal(imsEntity.getListPrice()) : new BigDecimal("0"));
                rsSkuDomain.setPricesetNprice(StringUtils.isNotBlank((String)imsEntity.getListPrice()) ? new BigDecimal(imsEntity.getListPrice()) : new BigDecimal("0"));
                skuList.add(rsSkuDomain);
                if (CollectionUtils.isEmpty(rsSpecOptionDomains)) continue;
                List collect1 = rsSpecOptionDomains.stream().filter(rsSpecOption -> sizeEntity.getSIZET().equals(rsSpecOption.getSpecOptionNum())).collect(Collectors.toList());
                this.logger.info("\u5c3a\u7801\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(collect1));
                if (CollectionUtils.isEmpty(collect1)) continue;
                RsSpecOptionDomain specOptionDomain = (RsSpecOptionDomain)collect1.get(0);
                RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
                rsSpecValueDomain.setSpecCode(specOptionDomain.getSpecCode());
                rsSpecValueDomain.setSpecGroupCode(specOptionDomain.getSpecGroupCode());
                rsSpecValueDomain.setSpecValueType("0");
                rsSpecValueDomain.setSpecValueFlag("1");
                rsSpecValueDomain.setSpecValueValue(specOptionDomain.getSpecOptionName());
                specList.add(rsSpecValueDomain);
            }
            if (!CollectionUtils.isEmpty(rsSpecOptionDomains)) {
                List collect1 = rsSpecOptionDomains.stream().filter(rsSpecOption -> ((ColorEntity)colorEntitieList.get(0)).getJ_3ACOL().equals(rsSpecOption.getSpecOptionNum())).collect(Collectors.toList());
                this.logger.info("\u989c\u8272\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(collect1));
                if (!CollectionUtils.isEmpty(collect1)) {
                    RsSpecOptionDomain specOptionDomain = (RsSpecOptionDomain)collect1.get(0);
                    RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
                    rsSpecValueDomain.setSpecCode(specOptionDomain.getSpecCode());
                    rsSpecValueDomain.setSpecGroupCode(specOptionDomain.getSpecGroupCode());
                    rsSpecValueDomain.setSpecValueType("0");
                    rsSpecValueDomain.setSpecValueFlag("1");
                    rsSpecValueDomain.setSpecOptionNum(specOptionDomain.getSpecOptionNum());
                    rsSpecValueDomain.setSpecValueValue(specOptionDomain.getSpecOptionName());
                    specList.add(rsSpecValueDomain);
                }
            }
            rsResourceGoodsReDomain.setRsSkuDomainList(skuList);
            rsResourceGoodsReDomain.setRsSpecValueDomainList(specList);
            rsResourceGoodsReDomain.setRsPropertiesValueDomainList(this.addPropertiesValue(imsEntity, memberCode));
        }
        return rsResourceGoodsReDomain;
    }

    private List<RsPropertiesValueDomain> addPropertiesValue(ImsEntity imsEntity, String memberCode) {
        String code;
        String ptreeCode = goodsTypeContainer.get(imsEntity.getSizeGroup());
        List<RsPropertiesReDomain> rsPropertiesReDomains = this.queryPropertiesPage(ptreeCode);
        ArrayList<RsPropertiesValueDomain> list = new ArrayList<RsPropertiesValueDomain>();
        if (StringUtils.isNotBlank((String)imsEntity.getProductLine())) {
            List productList = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u4ea7\u54c1\u7ebf")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(productList)) {
                code = this.saveProperties(ptreeCode, "\u4ea7\u54c1\u7ebf", memberCode);
                this.addPropertiesValue(imsEntity.getProductLine(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getProductLine(), list, ((RsPropertiesReDomain)productList.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getYear())) {
            List yearList = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u5e74\u4efd")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(yearList)) {
                code = this.saveProperties(ptreeCode, "\u5e74\u4efd", memberCode);
                this.addPropertiesValue(imsEntity.getYear(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getYear(), list, ((RsPropertiesReDomain)yearList.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getProductSeason())) {
            List productSeason = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u4ea7\u54c1\u5b63")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(productSeason)) {
                code = this.saveProperties(ptreeCode, "\u4ea7\u54c1\u5b63", memberCode);
                this.addPropertiesValue(imsEntity.getProductSeason(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getProductSeason(), list, ((RsPropertiesReDomain)productSeason.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getWave())) {
            List wave = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u6ce2\u6bb5")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(wave)) {
                code = this.saveProperties(ptreeCode, "\u6ce2\u6bb5", memberCode);
                this.addPropertiesValue(imsEntity.getWave(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getWave(), list, ((RsPropertiesReDomain)wave.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getSerial())) {
            List serial = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u7cfb\u5217")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(serial)) {
                code = this.saveProperties(ptreeCode, "\u7cfb\u5217", memberCode);
                this.addPropertiesValue(imsEntity.getSerial(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getSerial(), list, ((RsPropertiesReDomain)serial.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getSerial())) {
            List style = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u98ce\u683c")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(style)) {
                code = this.saveProperties(ptreeCode, "\u98ce\u683c", memberCode);
                this.addPropertiesValue(imsEntity.getSerial(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getSerial(), list, ((RsPropertiesReDomain)style.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getTheme())) {
            List theme = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u4e3b\u9898")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(theme)) {
                code = this.saveProperties(ptreeCode, "\u4e3b\u9898", memberCode);
                this.addPropertiesValue(imsEntity.getTheme(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getTheme(), list, ((RsPropertiesReDomain)theme.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField11())) {
            List field11 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u662f\u5426\u6709\u9970\u54c1")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field11)) {
                code = this.saveProperties(ptreeCode, "\u662f\u5426\u6709\u9970\u54c1", memberCode);
                this.addPropertiesValue(imsEntity.getField11(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField11(), list, ((RsPropertiesReDomain)field11.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField12())) {
            List field12 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u53ef\u62c6\u5378\u914d\u4ef6\u6570\u91cf")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field12)) {
                code = this.saveProperties(ptreeCode, "\u53ef\u62c6\u5378\u914d\u4ef6\u6570\u91cf", memberCode);
                this.addPropertiesValue(imsEntity.getField12(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField12(), list, ((RsPropertiesReDomain)field12.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField14())) {
            List field14 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u662f\u5426\u8ffd\u5355\u6b3e")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field14)) {
                code = this.saveProperties(ptreeCode, "\u662f\u5426\u8ffd\u5355\u6b3e", memberCode);
                this.addPropertiesValue(imsEntity.getField14(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField14(), list, ((RsPropertiesReDomain)field14.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField19())) {
            List field19 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u4e3b\u6210\u5206\u6bd4")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field19)) {
                code = this.saveProperties(ptreeCode, "\u4e3b\u6210\u5206\u6bd4", memberCode);
                this.addPropertiesValue(imsEntity.getField19(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField19(), list, ((RsPropertiesReDomain)field19.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField20())) {
            List field20 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u514b\u91cd")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field20)) {
                code = this.saveProperties(ptreeCode, "\u514b\u91cd", memberCode);
                this.addPropertiesValue(imsEntity.getField20(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField20(), list, ((RsPropertiesReDomain)field20.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField21())) {
            List field21 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u59c6\u7c73\u6570")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field21)) {
                code = this.saveProperties(ptreeCode, "\u59c6\u7c73\u6570", memberCode);
                this.addPropertiesValue(imsEntity.getField21(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField21(), list, ((RsPropertiesReDomain)field21.get(0)).getPropertiesCode());
            }
        }
        return list;
    }

    private void addPropertiesValue(String value, List<RsPropertiesValueDomain> list, String code) {
        RsPropertiesValueDomain rsPropertiesValueDomain = new RsPropertiesValueDomain();
        rsPropertiesValueDomain.setPropertiesCode(code);
        rsPropertiesValueDomain.setPropertiesValueType("1");
        rsPropertiesValueDomain.setPropertiesValueValue(value);
        list.add(rsPropertiesValueDomain);
    }

    private Map<String, List<ImsEntity>> getGoodsMap(List<ImsEntity> imsList) {
        HashMap<String, List<ImsEntity>> goodsMap = new HashMap<String, List<ImsEntity>>();
        for (ImsEntity imsEntity : imsList) {
            String brand = imsEntity.getBrand();
            if (goodsMap.containsKey(brand)) {
                List imsEntities = (List)goodsMap.get(brand);
                imsEntities.add(imsEntity);
                continue;
            }
            ArrayList<ImsEntity> arr = new ArrayList<ImsEntity>();
            arr.add(imsEntity);
            goodsMap.put(brand, arr);
        }
        return goodsMap;
    }

    public Boolean sendSaveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain));
        this.getInternalRouter().inInvoke("rs.resource.sendSaveResourceGoods", pmap);
        return Boolean.TRUE;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public void queryCompanyPage(String memberType) {
        OrgCompanyDomain orgCompanyDomain;
        HashMap<String, String> map = new HashMap<String, String>();
        if (memberType.equals(zooc)) {
            map.put("userinfoCode", LancyWithB2cMapEnum.LANE_CODE.getCode());
        } else if (memberType.equals(lancy)) {
            map.put("userinfoCode", LancyWithB2cMapEnum.LANCY_CODE.getCode());
        } else {
            return;
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("org.company.queryCompanyPage", pmap, OrgCompanyDomain.class);
        if (null != rs) {
            orgCompanyDomain = rs.getList().stream().filter(ele -> ele.getCompanyCode() != null).findFirst().get();
            if (null == orgCompanyDomain) {
                throw new Exception("\u67e5\u8be2\u516c\u53f8\u53c2\u6570\u4e0d\u6b63\u786e");
            }
        } else {
            throw new Exception("\u672a\u83b7\u53d6\u5230\u516c\u53f8\u4fe1\u606f");
        }
        companyCode.put(memberType, orgCompanyDomain.getCompanyCode());
    }

    private Boolean areaDataSynchronous(List<AreaDomainEntity> loadScoreInfo) {
        Optional<OrgDepartReDomain> orgDepartDomain;
        List<OrgDepartDomain> orgDepartDomains = this.queryDepartPage("-1");
        for (AreaDomainEntity excelDataInfoEntity : loadScoreInfo) {
            Optional<OrgDepartDomain> orgDepartDomainIsPresent;
            if (null == companyCode && CollectionUtils.isEmpty(companyCode) || null == companyCode.get(excelDataInfoEntity.getDivision())) {
                this.queryCompanyPage(excelDataInfoEntity.getDivision());
            }
            if (!(orgDepartDomainIsPresent = orgDepartDomains.stream().filter(Objects::nonNull).filter(ele -> null != ele.getDepartOcode()).filter(ele -> ele.getDepartOcode().equals(excelDataInfoEntity.getRegionalSalesId())).findFirst()).isPresent()) {
                orgDepartDomain = new OrgDepartDomain();
                ((OrgDepartDomain)((Object)orgDepartDomain)).setDepartName(excelDataInfoEntity.getRegionalSalesName());
                ((OrgDepartDomain)((Object)orgDepartDomain)).setDepartOcode(excelDataInfoEntity.getRegionalSalesId());
                ((OrgDepartDomain)((Object)orgDepartDomain)).setCompanyCode(companyCode.get(excelDataInfoEntity.getDivision()));
                ((OrgDepartDomain)((Object)orgDepartDomain)).setDepartOrgin("0");
                ((OrgDepartDomain)((Object)orgDepartDomain)).setAppmanageIcode(excelDataInfoEntity.getDivision().equals(zooc) ? "02101" : "021");
                areaCode.put(((OrgDepartDomain)((Object)orgDepartDomain)).getDepartOcode(), this.saveDepart((OrgDepartDomain)((Object)orgDepartDomain)));
                continue;
            }
            orgDepartDomain = orgDepartDomainIsPresent.get();
            areaCode.put(((OrgDepartDomain)((Object)orgDepartDomain)).getDepartOcode(), ((OrgDepartDomain)((Object)orgDepartDomain)).getDepartCode());
        }
        loadScoreInfo = loadScoreInfo.stream().filter(ele -> ele.getStates() != null).filter(ele -> "\u65e0\u6548".equals(ele.getStates())).collect(Collectors.toList());
        List<OrgDepartReDomain> newOrgDepart = this.queryDepartPage1("-1");
        log.info("\u65e0\u6548\u533a\u57df\u6761\u6570::{}", (Object)loadScoreInfo.size());
        for (AreaDomainEntity areaDomainEntity : loadScoreInfo) {
            log.info("\u8fdb\u5165\u5faa\u73af");
            orgDepartDomain = newOrgDepart.stream().filter(ele -> ele.getDepartOcode() != null).filter(ele -> ele.getDepartOcode().equals(areaDomainEntity.getRegionalSalesId())).findFirst();
            if (!orgDepartDomain.isPresent()) continue;
            OrgDepartReDomain departDomain = (OrgDepartReDomain)orgDepartDomain.get();
            log.info("\u65e0\u6548\u4e14\u4fdd\u5b58\u6210\u529f\u7684\u533a\u57df\u4fe1\u606f\uff1a\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)departDomain));
            if (departDomain.getDataState() == -1) continue;
            this.updateDepartState(departDomain.getDepartId());
        }
        return Boolean.TRUE;
    }

    private List<OrgDepartDomain> queryDepartPage(String departPcode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", "2022012800000001");
        map.put("page", "1");
        map.put("rows", "10000");
        if (null != departPcode) {
            map.put("departPcode", departPcode);
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("org.depart.queryDepartPage", pmap, OrgDepartDomain.class);
        if (null != rs) {
            return rs.getList();
        }
        return null;
    }

    private List<OrgDepartReDomain> queryDepartPage1(String departPcode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", "2022012800000001");
        map.put("page", "1");
        map.put("rows", "10000");
        if (null != departPcode) {
            map.put("departPcode", departPcode);
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("org.depart.queryDepartPage", pmap, OrgDepartReDomain.class);
        if (null != rs) {
            return rs.getList();
        }
        return null;
    }

    private String saveDepart(OrgDepartDomain orgDepartDomain) {
        orgDepartDomain.setTenantCode("2022012800000001");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("orgDepartDomain", JsonUtil.buildNormalBinder().toJson((Object)orgDepartDomain));
        Object departCode = this.getInternalRouter().inInvoke("org.ChannelsendBase.sendSaveDepart", pmap);
        if (null == departCode) {
            throw new Exception("\u4fdd\u5b58\u533a\u57df\u4fe1\u606f\u5f02\u5e38");
        }
        return departCode.toString();
    }

    public void updateDepartState(Integer departId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("departId", departId);
        map.put("dataState", -1);
        map.put("oldDataState", 0);
        log.info("pmap\u4fee\u6539\u533a\u57df\u65e0\u6548\u4f20\u53c2\u4fe1\u606f::{}", map);
        this.getInternalRouter().inInvoke("org.ChannelsendBase.sendUpdateDepartState", map);
    }

    private Boolean storesDataSynchronous(List<StoreEntity> storeEntities) {
        Optional<OrgDepartDomain> orgDepartDomain;
        if (CollectionUtils.isEmpty(storeEntities)) {
            throw new Exception("\u672a\u83b7\u53d6\u5230\u8981\u66f4\u65b0\u7684\u6570\u636e");
        }
        List<OrgDepartDomain> orgDepartDomains = this.queryDepartPage();
        List<CityEntity> list = ExcelReadUtil.loadScoreInfo(city, new CityEntity()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<OrgDepartDomain> saveOrgDepartDomain = new ArrayList<OrgDepartDomain>();
        for (StoreEntity storeEntity : storeEntities) {
            String departPcode = areaCode.get(storeEntity.getSLAID());
            if (null == departPcode) {
                log.info("\u6ca1\u6709\u533a\u57df\u7684\u95e8\u5e97\u6570\u636e::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)storeEntity));
                continue;
            }
            if (!CollectionUtils.isEmpty(orgDepartDomains)) {
                Optional<OrgDepartDomain> orgDeparIsPresent = orgDepartDomains.stream().filter(Objects::nonNull).filter(ele -> ele.getDepartOcode() != null).filter(ele -> ele.getDepartOcode().equals(storeEntity.getZCODE())).findFirst();
                if (orgDeparIsPresent.isPresent()) continue;
                log.info("\u4e0d\u5b58\u5728\u76f8\u540c");
                orgDepartDomain = this.structureCompany(storeEntity, list, departPcode);
                log.info("\u6784\u9020\u5b8c\u6210\u7684\u95e8\u5e97\u4fe1\u606f::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orgDepartDomain));
                saveOrgDepartDomain.add((OrgDepartDomain)((Object)orgDepartDomain));
                continue;
            }
            log.info("\u95e8\u5e97\u4e3a\u7a7a");
            OrgDepartDomain orgDepartDomain2 = this.structureCompany(storeEntity, list, departPcode);
            log.info("orgDepartDomain::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)orgDepartDomain2));
            saveOrgDepartDomain.add(orgDepartDomain2);
        }
        if (!CollectionUtils.isEmpty(saveOrgDepartDomain)) {
            this.saveDepartBatch(saveOrgDepartDomain);
        }
        List newOrgDepart = ((Stream)this.queryDepartPage().stream().parallel()).filter(ele -> ele.getUserinfoDataStatu() != null).filter(ele -> ele.getUserinfoDataStatu() != -1).collect(Collectors.toList());
        for (StoreEntity storeEntity : storeEntities) {
            OrgDepartDomain orgDepartDomain1;
            Boolean dataStatu = storeEntity.thanTime();
            if (!dataStatu.booleanValue()) continue;
            log.info("\u95ed\u9986\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\u7684\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)storeEntity));
            orgDepartDomain = ((Stream)newOrgDepart.stream().parallel()).filter(Objects::nonNull).filter(ele -> ele.getUserinfoCode() != null).filter(ele -> ele.getDepartOcode() != null).filter(ele -> storeEntity.getZCODE().equals(ele.getDepartOcode())).findFirst();
            if (!orgDepartDomain.isPresent() || (orgDepartDomain1 = (OrgDepartDomain)orgDepartDomain.get()).getUserinfoDataStatu() == -1) continue;
            log.info("\u4fee\u6539\u65e0\u6548\u7684\u95e8\u5e97::{}", (Object)orgDepartDomain1.getUserinfoId());
            this.updateUserinfoState(orgDepartDomain1.getUserinfoId());
        }
        return Boolean.TRUE;
    }

    private List<OrgDepartDomain> queryDepartPage() {
        ArrayList<OrgDepartDomain> list = new ArrayList<OrgDepartDomain>();
        List<UmUserinfoReDomainBean> umUserinfoReDomainBeanQueryResult = this.queryUserinfoPage("depart");
        List<OrgDepartDomain> orgDepartDomains = this.queryDepartPage(null);
        if (null != umUserinfoReDomainBeanQueryResult) {
            List umUserinfoReDomainBeans = umUserinfoReDomainBeanQueryResult.stream().filter(Objects::nonNull).filter(ele -> ele.getDepartCode() != null).collect(Collectors.toList());
            for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoReDomainBeans) {
                Optional<OrgDepartDomain> orgDepartDomain = orgDepartDomains.stream().filter(Objects::nonNull).filter(ele -> ele.getDepartPcode() != null).filter(ele -> ele.getDepartCode().equals(umUserinfoReDomainBean.getDepartCode())).findFirst();
                if (!orgDepartDomain.isPresent()) continue;
                OrgDepartDomain orgDepartDomain1 = orgDepartDomain.get();
                orgDepartDomain1.setUserinfoCode(umUserinfoReDomainBean.getUserinfoCode());
                orgDepartDomain1.setUserinfoId(umUserinfoReDomainBean.getUserinfoId());
                orgDepartDomain1.setUserinfoDataStatu(umUserinfoReDomainBean.getDataState());
                list.add(orgDepartDomain1);
            }
        }
        return list;
    }

    public UmUserinfoReDomainBean getUserInfoByUserinfoCode(String userinfoCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson((Object)ImmutableMap.of((Object)"userinfoCode", (Object)userinfoCode, (Object)"tenantCode", (Object)"2022012800000001")));
        log.info("\u6839\u636euserinfo\u67e5\u8be2\u4fe1\u606f::{}", pmap);
        QueryResult umUserinfoReDomainBeanQueryResult = this.getQueryResutl("um.user.getUserinfoByUserCode", pmap, UmUserinfoReDomainBean.class);
        if (umUserinfoReDomainBeanQueryResult == null) {
            throw new Exception(String.format("\u672a\u83b7\u53d6\u5230\u95e8\u5e97\u4fe1\u606fuserinfoCode:%s", userinfoCode));
        }
        log.info("\u6839\u636euserinfo\u67e5\u8be2\u7684\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoReDomainBeanQueryResult.getList()));
        return umUserinfoReDomainBeanQueryResult.getList().stream().findFirst().orElse(null);
    }

    public OrgDepartDomain structureCompany(StoreEntity storeEntity, List<CityEntity> list, String departPcode) {
        log.info("storeEntity::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)storeEntity));
        OrgDepartDomain orgDepartDomain = new OrgDepartDomain();
        orgDepartDomain.setDepartPcode(departPcode);
        orgDepartDomain.setDepartName(storeEntity.getZNAME());
        log.info("companyCode.get(storeEntity.getBunit())::{}", (Object)companyCode.get(storeEntity.getBUNIT()));
        if (null != storeEntity.getBUNIT()) {
            orgDepartDomain.setCompanyCode(companyCode.get(storeEntity.getBUNIT()));
        }
        if (null != storeEntity.getZPROV()) {
            list.stream().filter(ele -> ele.getProvinceId().equals(storeEntity.getZPROV())).findFirst().ifPresent(cityEntity -> orgDepartDomain.setProvinceName(cityEntity.getProvinceName()));
        }
        if (null != storeEntity.getZCITY()) {
            list.stream().filter(ele -> ele.getCityId().equals(storeEntity.getZCITY())).findFirst().ifPresent(ele -> orgDepartDomain.setCityName(ele.getCityName()));
        }
        if (null != storeEntity.getZREGN()) {
            areaList.stream().filter(ele -> ele.getRegionId().equals(storeEntity.getZREGN())).findFirst().ifPresent(ele -> orgDepartDomain.setAreaName(ele.getRegionName()));
        }
        orgDepartDomain.setDepartAddress(storeEntity.getGr_address());
        orgDepartDomain.setDepartOrgin("1");
        orgDepartDomain.setDepartOcode(storeEntity.getZCODE());
        orgDepartDomain.setTenantCode("2022012800000001");
        if (null != storeEntity.getLongitude() && null != storeEntity.getLatitude()) {
            orgDepartDomain.setStoreMapLocation(storeEntity.getLongitude() + "," + storeEntity.getLatitude());
        }
        orgDepartDomain.setUserinfoSort(JsonUtil.buildNonDefaultBinder().toJson((Object)orgDepartDomain));
        log.info("\u6784\u9020\u7684\u95e8\u5e97\u4fe1\u606f::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orgDepartDomain));
        return orgDepartDomain;
    }

    public Boolean saveDepartBatch(List<OrgDepartDomain> orgDepartDomainList) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("orgDepartDomainList", JsonUtil.buildNormalBinder().toJson(orgDepartDomainList));
        log.info("\u4fdd\u5b58\u95e8\u5e97\u6570\u636e::{}", pmap);
        Object inInvoke = this.getInternalRouter().inInvoke("org.ChannelsendBase.sendSaveDepartBatch", pmap);
        log.info("\u95e8\u5e97\u8fd4\u56de\u6570\u636e\uff1a\uff1a{}", inInvoke);
        return Boolean.TRUE;
    }

    public Boolean salesmanDataSynchronous(List<SalesmanEntity> salesmanEntities) {
        List umUserReDomainBeans = this.queryUserPage().stream().filter(ele -> ele.getUserCacode() != null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(salesmanEntities)) {
            throw new Exception("\u672a\u83b7\u53d6\u5230\u5bfc\u8d2d\u6570\u636e");
        }
        SupQueryResult<UmUserinfoReDomainBean> umUserinfoReDomainBeanSupQueryResult = this.queryUserinfoPage();
        int i = 1;
        for (SalesmanEntity salesmanEntity : salesmanEntities) {
            DisChannelDomain disChannelDomain = this.queryChannelPage(salesmanEntity.getZZHR_SUPPT().equals("\u6717\u59ff") ? LancyWithB2cMapEnum.LANCY_CODE.getCode() : LancyWithB2cMapEnum.LANE_CODE.getCode(), "2022012800000001");
            if (null == disChannelDomain) {
                throw new Exception("\u672a\u83b7\u53d6\u5230\u7528\u6237\u6e20\u9053");
            }
            log.info("\u6784\u9020\u7528\u6237\u6e20\u9053\u4fe1\u606fdisChannelDomain::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)disChannelDomain));
            if (CollectionUtils.isEmpty(umUserReDomainBeans)) {
                log.info("\u4e3a\u7a7a\u76f4\u63a5\u6dfb\u52a0");
                UmUserDomainBean umUserDomainBean = this.structureUserData(salesmanEntity, disChannelDomain, umUserinfoReDomainBeanSupQueryResult);
                log.info("\u7a7a::\u6784\u9020\u5b8c\u6210\u7684\u6570\u636e\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
                String userinfoCode = this.saveUser(umUserDomainBean);
                log.info("userinfoCode::{}", (Object)userinfoCode);
                if (userinfoCode == null) {
                    throw new Exception("\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                }
                UmUserinfoChannelDomain umUserinfoChannelDomain = this.structureUserChannel(salesmanEntity, userinfoCode, disChannelDomain);
                if (null == umUserinfoChannelDomain) {
                    throw new Exception("\u6784\u9020\u7528\u6237\u6e20\u9053\u4fe1\u606f\u5f02\u5e38");
                }
                log.info("\u6784\u9020\u5b8c\u6210\u7684\u7528\u6237\u6e20\u9053\u4fe1\u606f:::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannelDomain));
                if (this.saveUserinfoChannel(umUserinfoChannelDomain).booleanValue() && this.saveUlLevelUpoints(salesmanEntity, userinfoCode, disChannelDomain).booleanValue()) {
                    ShShsettlUserDomain shShsettlUserDomain = this.structureUserShsettl(salesmanEntity, userinfoCode);
                    if (null == shShsettlUserDomain) {
                        throw new Exception("\u6784\u9020\u5206\u9500\u4fe1\u606f\u5f02\u5e38");
                    }
                    Assert.isTrue((boolean)this.saveShsettlUser(shShsettlUserDomain), (String)"\u4fdd\u5b58\u7528\u6237\u5206\u9500\u4fe1\u606f\u5f02\u5e38");
                }
            } else {
                log.info("\u4e0d\u4e3a\u7a7a\u8fc7\u6ee4\u91cd\u590d");
                Optional<UmUserDomainBean> userIsPresent = umUserReDomainBeans.stream().filter(Objects::nonNull).filter(ele -> ele.getUserCacode().equals(salesmanEntity.getUserid()) && ele.getUserPhone().equals(salesmanEntity.getMobile())).findFirst();
                if (!userIsPresent.isPresent()) {
                    UmUserDomainBean umUserDomainBean = this.structureUserData(salesmanEntity, disChannelDomain, umUserinfoReDomainBeanSupQueryResult);
                    log.info("\u4e0d\u91cd\u590d::\u6784\u9020\u5b8c\u6210\u7684\u6570\u636e\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
                    String userinfoCode = this.saveUser(umUserDomainBean);
                    log.info("userinfoCode::{}", (Object)userinfoCode);
                    if (userinfoCode == null) {
                        throw new Exception("\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                    }
                    UmUserinfoChannelDomain umUserinfoChannelDomain = this.structureUserChannel(salesmanEntity, userinfoCode, disChannelDomain);
                    if (null == umUserinfoChannelDomain) {
                        throw new Exception("\u6784\u9020\u7528\u6237\u6e20\u9053\u4fe1\u606f\u5f02\u5e38");
                    }
                    log.info("\u6784\u9020\u5b8c\u6210\u7684\u7528\u6237\u6e20\u9053\u4fe1\u606f:::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannelDomain));
                    if (this.saveUserinfoChannel(umUserinfoChannelDomain).booleanValue() && this.saveUlLevelUpoints(salesmanEntity, userinfoCode, disChannelDomain).booleanValue()) {
                        ShShsettlUserDomain shShsettlUserDomain = this.structureUserShsettl(salesmanEntity, userinfoCode);
                        if (null == shShsettlUserDomain) {
                            throw new Exception("\u6784\u9020\u5206\u9500\u4fe1\u606f\u5f02\u5e38");
                        }
                        Assert.isTrue((boolean)this.saveShsettlUser(shShsettlUserDomain), (String)"\u4fdd\u5b58\u7528\u6237\u5206\u9500\u4fe1\u606f\u5f02\u5e38");
                    }
                }
            }
            log.info("\u4fdd\u5b58\u5bfc\u8d2d\u6210\u529f::[" + ++i + "]\u6b21");
        }
        return Boolean.TRUE;
    }

    public List<UmUserinfoReDomainBean> queryUserinfoPage(String userinfoQuality) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2022012800000001");
        map.put("fuzzy", true);
        map.put("page", "1");
        map.put("rows", "1000");
        map.put("childFlag", false);
        if (null != userinfoQuality) {
            map.put("userinfoQuality", userinfoQuality);
        }
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        log.info("\u83b7\u53d6\u63a8\u9001userinfo\u4fe1\u606f\u53c2\u6570::{}", pmap);
        QueryResult umUserinfoReDomainBeanQueryResult = this.getQueryResutl("um.user.queryUserinfoPage", pmap, UmUserinfoReDomainBean.class);
        if (null == umUserinfoReDomainBeanQueryResult) {
            throw new Exception("\u672a\u83b7\u53d6\u7684umUserinfoReDomainBeanQueryResult\u4fe1\u606f");
        }
        return umUserinfoReDomainBeanQueryResult.getList();
    }

    public UmUserDomainBean structureUserData(SalesmanEntity salesmanEntity, DisChannelDomain disChannelDomain, SupQueryResult<UmUserinfoReDomainBean> beanSupQueryResult) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserCacode(salesmanEntity.getUserid());
        umUserDomainBean.setUserRelname(salesmanEntity.getName());
        umUserDomainBean.setUserName(salesmanEntity.getMobile());
        umUserDomainBean.setUserPhone(salesmanEntity.getMobile());
        umUserDomainBean.setUserSex(salesmanEntity.getGender());
        umUserDomainBean.setUserEmial(salesmanEntity.getEmail());
        umUserDomainBean.setUserinfoQuality("buy,dis");
        umUserDomainBean.setUserinfoChannelcode(disChannelDomain.getChannelCode());
        umUserDomainBean.setUserinfoChannelname(disChannelDomain.getChannelName());
        umUserDomainBean.setTenantCode("2022012800000001");
        umUserDomainBean.setUmUserinfoQuaDomainList(this.structureUserInfoQua(salesmanEntity));
        String memberCode = GenerateMemberCodeUtil.generateMemberCode(beanSupQueryResult);
        log.info("\u4f1a\u5458\u5361\u53f7memberCode::{}", (Object)memberCode);
        umUserDomainBean.setUserinfoOcode(memberCode);
        umUserDomainBean.setCompanyAddress(salesmanEntity.getAddress());
        umUserDomainBean.setUserBirthday(salesmanEntity.getGbDat());
        return umUserDomainBean;
    }

    public UmUserDomainBean structureUserData1(SalesmanEntity salesmanEntity, DisChannelDomain disChannelDomain) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserCacode(salesmanEntity.getUserid());
        umUserDomainBean.setUserRelname(salesmanEntity.getName());
        umUserDomainBean.setUserName(salesmanEntity.getMobile());
        umUserDomainBean.setUserPhone(salesmanEntity.getMobile());
        umUserDomainBean.setUserSex(salesmanEntity.getGender());
        umUserDomainBean.setUserEmial(salesmanEntity.getEmail());
        umUserDomainBean.setUserinfoQuality("buy,dis");
        umUserDomainBean.setUserinfoChannelcode(disChannelDomain.getChannelCode());
        umUserDomainBean.setUserinfoChannelname(disChannelDomain.getChannelName());
        umUserDomainBean.setTenantCode("2022012800000001");
        umUserDomainBean.setUmUserinfoQuaDomainList(this.structureUserInfoQua(salesmanEntity));
        String memberCode = GenerateMemberCodeUtil.generateMemberCode(this.queryUserinfoPage());
        log.info("\u4f1a\u5458\u5361\u53f7memberCode::{}", (Object)memberCode);
        umUserDomainBean.setUserinfoOcode(memberCode);
        umUserDomainBean.setCompanyAddress(salesmanEntity.getAddress());
        umUserDomainBean.setUserBirthday(salesmanEntity.getGbDat());
        return umUserDomainBean;
    }

    public List<UmUserinfoQuaDomain> structureUserInfoQua(SalesmanEntity salesmanEntity) {
        String appIcode = salesmanEntity.getZZHR_SUPPT().equals("\u6717\u59ff") ? "021" : "02101";
        UmUserinfoQuaDomain umUserinfoQuaDomain1 = new UmUserinfoQuaDomain();
        umUserinfoQuaDomain1.setUserinfoQuaKey("emplyee");
        umUserinfoQuaDomain1.setUserinfoQuaVaule(salesmanEntity.getJoin_time());
        umUserinfoQuaDomain1.setUserinfoQuaVaule1(salesmanEntity.getStat2());
        umUserinfoQuaDomain1.setUserinfoQuaVaule2(salesmanEntity.getStext());
        umUserinfoQuaDomain1.setUserinfoQuaUrl(salesmanEntity.getZZHR_SUPPT());
        umUserinfoQuaDomain1.setUserinfoQuaUrl1(salesmanEntity.getZZHR_PSBH());
        umUserinfoQuaDomain1.setAppmanageIcode(appIcode);
        UmUserinfoQuaDomain umUserinfoQuaDomain2 = new UmUserinfoQuaDomain();
        umUserinfoQuaDomain2.setUserinfoQuaKey("basic");
        int i = LocalDate.now().getYear() - LocalDate.parse(salesmanEntity.getGbDat()).getYear();
        umUserinfoQuaDomain2.setUserinfoQuaVaule(String.valueOf(i));
        umUserinfoQuaDomain2.setUserinfoQuaUrl2(salesmanEntity.getStext());
        return Arrays.asList(umUserinfoQuaDomain1, umUserinfoQuaDomain2);
    }

    public UmUserinfoChannelDomain structureUserChannel(SalesmanEntity salesmanEntity, String userinfoCode, DisChannelDomain disChannelDomain) {
        String appIcode = salesmanEntity.getZZHR_SUPPT().equals("\u6717\u59ff") ? "021" : "02101";
        UmUserinfoChannelDomain umUserinfoChannelDomain = new UmUserinfoChannelDomain();
        umUserinfoChannelDomain.setChannelCode(disChannelDomain.getChannelCode());
        umUserinfoChannelDomain.setUserinfoCode(userinfoCode);
        umUserinfoChannelDomain.setQualityCode("buy,dis");
        umUserinfoChannelDomain.setTenantCode("2022012800000001");
        umUserinfoChannelDomain.setAppmanageIcode(appIcode);
        return umUserinfoChannelDomain;
    }

    public ShShsettlUserDomain structureUserShsettl(SalesmanEntity salesmanEntity, String userinfoCode) {
        ShShsettlUserDomain shShsettlUserDomain = new ShShsettlUserDomain();
        shShsettlUserDomain.setTenantCode("2022012800000001");
        shShsettlUserDomain.setMemberCode("\u6717\u59ff".equals(salesmanEntity.getZZHR_SUPPT()) ? LancyWithB2cMapEnum.LANCY_CODE.getCode() : LancyWithB2cMapEnum.LANE_CODE.getCode());
        shShsettlUserDomain.setShsettlType("2");
        shShsettlUserDomain.setShsettlCode("1425fa81b2de44a491ec2d2769657186");
        shShsettlUserDomain.setMemberBcode(userinfoCode);
        String appIcode = salesmanEntity.getZZHR_SUPPT().equals("\u6717\u59ff") ? "021" : "02101";
        shShsettlUserDomain.setAppmanageIcode(appIcode);
        shShsettlUserDomain.setShsettlUserInvite(salesmanEntity.getUserid());
        return shShsettlUserDomain;
    }

    public String saveUser(UmUserDomainBean umUserDomainBean) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
        log.info("\u4fdd\u5b58\u5bfc\u8d2d\u5458\u4f1a\u5458\u4fe1\u606f\uff1a\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
        Object inInvoke = this.getInternalRouter().inInvoke("um.user.sendOpenUserinfo", pmap);
        log.info("\u4fdd\u5b58\u7684\u5bfc\u8d2d\u4f1a\u5458\u4fe1\u606f::{}", inInvoke);
        if (inInvoke == null) {
            throw new Exception("\u4fdd\u5b58user\u6570\u636e\u5931\u8d25");
        }
        return inInvoke.toString();
    }

    public String saveUserBatch(List<UmUserDomainBean> umUserDomainBeanList) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("umUserDomainBeanList", JsonUtil.buildNormalBinder().toJson(umUserDomainBeanList));
        Object inInvoke = this.getInternalRouter().inInvoke("um.user.sendSaveOrUpdateUserinfoBatch", pmap);
        log.info("\u6279\u91cf\u5bfc\u5165 \u5bfc\u8d2dinInvoke::{}", (Object)JsonUtil.buildNormalBinder().toJson(inInvoke));
        if (null == inInvoke) {
            throw new Exception("\u4fdd\u5b58user\u6570\u636e\u5931\u8d25");
        }
        return inInvoke.toString();
    }

    public Boolean saveUserinfoChannel(UmUserinfoChannelDomain umUserinfoChannelDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("umUserinfoChannelDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannelDomain));
        log.info("\u4fdd\u5b58\u7528\u6237\u6e20\u9053\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
        return this.getInternalRouter().inInvoke("um.umUserinfoChannel.saveUserinfoChannel", pmap) != null;
    }

    public Boolean saveUlLevelUpoints(SalesmanEntity salesmanEntity, String userinfoCode, DisChannelDomain disChannelDomain) {
        UlLevelUpointsDomain ulLevelUpointsDomain = new UlLevelUpointsDomain();
        ulLevelUpointsDomain.setTenantCode("2022012800000001");
        ulLevelUpointsDomain.setMemberCode(userinfoCode);
        ulLevelUpointsDomain.setMemberName(salesmanEntity.getZZHR_SUPPT().equals("\u6717\u59ff") ? "\u6717\u59ff" : "\u83b1\u8335");
        ulLevelUpointsDomain.setLevelUserqua("buy");
        ulLevelUpointsDomain.setChannelCode(disChannelDomain.getChannelCode());
        ulLevelUpointsDomain.setChannelName(disChannelDomain.getChannelName());
        ulLevelUpointsDomain.setMemberMcode(salesmanEntity.getZZHR_SUPPT().equals("\u6717\u59ff") ? LancyWithB2cMapEnum.LANCY_CODE.getCode() : LancyWithB2cMapEnum.LANE_CODE.getCode());
        ulLevelUpointsDomain.setMemberMname(salesmanEntity.getName());
        ulLevelUpointsDomain.setLevelListLevel(0);
        ulLevelUpointsDomain.setLevelListName(null);
        ulLevelUpointsDomain.setLevelDatatype("levelListCode");
        ulLevelUpointsDomain.setLevelDatavalue(null);
        ulLevelUpointsDomain.setLevelLnum(new BigDecimal(0));
        ulLevelUpointsDomain.setLevelNum(new BigDecimal(0));
        ulLevelUpointsDomain.setLevelOnum(new BigDecimal(0));
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("ulLevelUpointsDomain", JsonUtil.buildNormalBinder().toJson((Object)ulLevelUpointsDomain));
        log.info("\u4fdd\u5b58\u4f1a\u5458\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
        return this.getInternalRouter().inInvoke("ul.ulLevelUllist.saveUlLevelUpoints", pmap) != null;
    }

    public Boolean saveShsettlUser(ShShsettlUserDomain shShsettlUserDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("shShsettlUserDomain", JsonUtil.buildNormalBinder().toJson((Object)shShsettlUserDomain));
        log.info("\u4fdd\u5b58\u5206\u9500\u4fe1\u606f::{}", pmap);
        Object inInvoke = this.getInternalRouter().inInvoke("sh.shsettlUser.saveShsettlUser", pmap);
        log.info("\u5206\u9500\u4fdd\u5b58\u8fd4\u56de\u4fe1\u606f2::{}", (Object)inInvoke.toString());
        if (null == inInvoke) {
            throw new Exception("\u4fdd\u5b58\u5206\u9500\u4fe1\u606f\u5931\u8d25");
        }
        return Boolean.TRUE;
    }

    public List<UmUserDomainBean> queryUserPage() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", 1);
        map.put("fuzzy", true);
        map.put("rows", 10000);
        map.put("tenantCode", "2022012800000001");
        map.put("userinfoQuality", "dis");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        log.info("\u67e5\u8be2user\u5b50\u8868\u53c2\u6570::{}", pmap);
        QueryResult rs = this.getQueryResutl("um.user.queryUserPage", pmap, UmUserDomainBean.class);
        return rs.getList().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void updateUserinfoState(Integer userinfoId) {
        HashMap<String, Integer> pmap = new HashMap<String, Integer>();
        pmap.put("userinfoId", userinfoId);
        pmap.put("dataState", -1);
        pmap.put("oldDataState", 0);
        log.info("\u505c\u7528\u95e8\u5e97\u4f20\u53c2\uff1a\uff1a{}", pmap);
        this.getInternalRouter().inInvoke("um.user.sendUpdateUserinfoState", pmap);
    }

    public SupQueryResult<UmUserinfoReDomainBean> queryUserinfoPage() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2022012800000001");
        map.put("userinfoCertNoLike", "8");
        map.put("childFlag", false);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("um.user.queryUserinfoPage", pmap, UmUserinfoReDomainBean.class);
    }
}

