/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.ImmutableMap;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ims.common.enums.BrandEnumFour;
import com.yqbsoft.laser.service.ims.common.enums.BrandEnumOne;
import com.yqbsoft.laser.service.ims.common.enums.BrandEnumThree;
import com.yqbsoft.laser.service.ims.common.enums.BrandEnumTwo;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cAppCodeMapEnum;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cMapEnum;
import com.yqbsoft.laser.service.ims.domain.DisChannelDomain;
import com.yqbsoft.laser.service.ims.domain.OrgCompanyDomain;
import com.yqbsoft.laser.service.ims.domain.OrgDepartDomain;
import com.yqbsoft.laser.service.ims.domain.OrgDepartReDomain;
import com.yqbsoft.laser.service.ims.domain.RsBrandDomain;
import com.yqbsoft.laser.service.ims.domain.RsClasstreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ims.domain.RsGoodsClassReDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsPropertiesDomain;
import com.yqbsoft.laser.service.ims.domain.RsPropertiesReDomain;
import com.yqbsoft.laser.service.ims.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.ims.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ims.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ims.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.ims.domain.ShShsettlUserDomain;
import com.yqbsoft.laser.service.ims.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.ims.domain.UmUserinfoChannel;
import com.yqbsoft.laser.service.ims.domain.UmUserinfoChannelDomain;
import com.yqbsoft.laser.service.ims.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.ims.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ims.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.ims.entity.AreaDomainEntity;
import com.yqbsoft.laser.service.ims.entity.AreaEntity;
import com.yqbsoft.laser.service.ims.entity.CityEntity;
import com.yqbsoft.laser.service.ims.entity.ImsEntity;
import com.yqbsoft.laser.service.ims.entity.SalesmanEntity;
import com.yqbsoft.laser.service.ims.entity.StoreEntity;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.LclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.MclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.Mvgr1Entity;
import com.yqbsoft.laser.service.ims.sap.entity.PldzEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SizeEntity;
import com.yqbsoft.laser.service.ims.sap.entity.UnitEntity;
import com.yqbsoft.laser.service.ims.sap.executes.CALL;
import com.yqbsoft.laser.service.ims.service.DataSynchronousService;
import com.yqbsoft.laser.service.ims.utils.ExcelReadUtil;
import com.yqbsoft.laser.service.ims.utils.InitEntity;
import com.yqbsoft.laser.service.ims.utils.MySqlJDBCUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DataSynchronousServiceImpl
extends BaseServiceImpl
implements DataSynchronousService {
    private static Logger log = LoggerFactory.getLogger(DataSynchronousServiceImpl.class);
    private static final String key = "member_code";
    private static final String code = "0000000";
    private static List<String> brandList = new ArrayList<String>();
    private static List<AreaEntity> areaList = AreaEntity.getAreaEntityList();
    private static Map<String, String> specGroupData = new HashMap<String, String>();
    private static Map<String, Map<String, String>> brandCodeMap = new Hashtable<String, Map<String, String>>();
    private static final String LAST_SYNCHRONOUS_TIME = "last_time";
    private static List<ImsEntity> imsEntityList = new ArrayList<ImsEntity>();
    private static JsonEntity jsonEntity = null;
    private static Map<String, String> brandContainer = new Hashtable<String, String>();
    private static Map<String, String> specGroupContainer = new Hashtable<String, String>();
    private static Map<String, String> goodsTypeContainer = new Hashtable<String, String>();
    private static Map<String, String> classTreeContainer = new Hashtable<String, String>();
    private static Map<String, String> class3TreeContainer = new Hashtable<String, String>();
    private static Map<String, String> companyCode = new HashMap<String, String>();
    private static Map<String, String> areaCode = new HashMap<String, String>();
    ArrayList<RsResourceGoodsReDomain> arr = new ArrayList();
    public static final String like = "LIME";
    public static final String lancy = "LANCY";
    public static final String season = "5SEASON";
    public static final String areaDomain = "areaDomain.xlsx";
    public static final String city = "city.xlsx";
    public static final String userData = "demo01.xlsx";
    List<UmUserinfoReDomainBean> userinfoList = new ArrayList<UmUserinfoReDomainBean>();
    List<UmUserinfoChannel> userinfoChannelList = new ArrayList<UmUserinfoChannel>();
    List<UmUserinfoQuaDomain> userinfoQuaList = new ArrayList<UmUserinfoQuaDomain>();
    private static String SAP_REDIS = "sap";
    private static String GOODS_REDIS = "synchronous_goods";
    private static int expires = 2592000;

    public void initGoods() throws SQLException, ParseException {
        imsEntityList = new ArrayList<ImsEntity>();
        imsEntityList = InitEntity.init();
        log.info("\u521d\u59cb\u5316\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(imsEntityList));
    }

    public void getGoodsBySpu(String spu) throws SQLException, ParseException {
        imsEntityList = new ArrayList<ImsEntity>();
        imsEntityList = InitEntity.init(spu);
        log.info("\u521d\u59cb\u5316\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(imsEntityList));
    }

    public void initSap() throws SQLException, ParseException {
        jsonEntity = null;
        String sapRedis = SupDisUtil.getDisCache().getRemot(SAP_REDIS);
        if (StringUtils.isBlank((String)sapRedis)) {
            jsonEntity = CALL.callRfcExample();
            log.info("\u521d\u59cb\u5316\u7684\u6570\u636e\u4e3ajsonEntity \uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)jsonEntity));
            SupDisUtil.getDisCache().set(SAP_REDIS, JsonUtil.buildNonDefaultBinder().toJson((Object)jsonEntity), expires);
        } else {
            jsonEntity = (JsonEntity)JsonUtil.buildNormalBinder().getJsonToObject(sapRedis, JsonEntity.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goodsDataSynchronous(String spu, String memberCode) {
        Class<DataSynchronousServiceImpl> clazz = DataSynchronousServiceImpl.class;
        synchronized (DataSynchronousServiceImpl.class) {
            if (StringUtils.isNotBlank((String)spu) && StringUtils.isNotBlank((String)memberCode)) {
                this.interfaceSynchronizationData(spu, memberCode);
            } else {
                this.synchronizationData();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
        }
        {
            return;
        }
    }

    private Boolean interfaceSynchronizationData(String spu, String memberCode) {
        try {
            if (StringUtils.isBlank((String)spu) || StringUtils.isBlank((String)memberCode)) {
                log.info("spu\u4e0d\u5b58\u5728\uff1a{}", (Object)(JsonUtil.buildNonDefaultBinder().toJson((Object)spu) + "--" + JsonUtil.buildNonDefaultBinder().toJson((Object)memberCode)));
                return false;
            }
            this.initSap();
            this.getGoodsBySpu(spu);
            if (CollectionUtils.isEmpty(imsEntityList) || Objects.isNull(jsonEntity)) {
                log.info("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
                return false;
            }
            brandContainer = new Hashtable<String, String>();
            specGroupContainer = new Hashtable<String, String>();
            goodsTypeContainer = new Hashtable<String, String>();
            classTreeContainer = new Hashtable<String, String>();
            this.arr = new ArrayList();
            String key = memberCode;
            this.synchronousBasisInfo(imsEntityList, jsonEntity, key);
            log.info("\u54c1\u724c\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(brandContainer));
            log.info("\u5546\u54c1\u89c4\u683c\u7ec4\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(specGroupContainer));
            log.info("\u5546\u54c1\u7c7b\u578b\u7ec4\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsTypeContainer));
            this.synchronousClasstree(imsEntityList, jsonEntity, key);
            log.info("\u4fdd\u5b58\u540e\u53f0\u5206\u7c7b\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(classTreeContainer));
            this.synchronousSaveGoodsParam(imsEntityList, jsonEntity, key);
            this.assemblyGoods(key, imsEntityList);
            log.info("\u65b9\u6cd5\u7ed3\u675f");
            return Boolean.TRUE;
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return Boolean.FALSE;
    }

    private Boolean synchronizationData() throws SQLException, ParseException, InterruptedException {
        imsEntityList = new ArrayList<ImsEntity>();
        imsEntityList = new ArrayList<ImsEntity>();
        this.initGoods();
        this.initSap();
        if (CollectionUtils.isEmpty(imsEntityList) || Objects.isNull(jsonEntity)) {
            log.info("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
            return false;
        }
        Map<String, List<ImsEntity>> imsMap = this.handleImsGoods();
        Iterator<Map.Entry<String, List<ImsEntity>>> iterator = imsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            brandContainer = new Hashtable<String, String>();
            specGroupContainer = new Hashtable<String, String>();
            goodsTypeContainer = new Hashtable<String, String>();
            classTreeContainer = new Hashtable<String, String>();
            this.arr = new ArrayList();
            Map.Entry<String, List<ImsEntity>> next = iterator.next();
            String key = LancyWithB2cMapEnum.getByValue(next.getKey()).getCode();
            List<ImsEntity> imsList = next.getValue();
            this.synchronousBasisInfo(imsList, jsonEntity, key);
            log.info("\u54c1\u724c\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(brandContainer));
            log.info("\u5546\u54c1\u89c4\u683c\u7ec4\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(specGroupContainer));
            log.info("\u5546\u54c1\u7c7b\u578b\u7ec4\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsTypeContainer));
            this.synchronousClasstree(imsList, jsonEntity, key);
            log.info("\u4fdd\u5b58\u540e\u53f0\u5206\u7c7b\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(classTreeContainer));
            this.synchronousSaveGoodsParam(imsList, jsonEntity, key);
            this.assemblyGoods(key, imsList);
        }
        log.info("\u65b9\u6cd5\u7ed3\u675f");
        return Boolean.TRUE;
    }

    private void synchronousSaveGoodsParam(List<ImsEntity> imsList, JsonEntity jsonEntity, String memberCode) {
        if (CollectionUtils.isEmpty(goodsTypeContainer)) {
            return;
        }
        for (Map.Entry<String, String> next : goodsTypeContainer.entrySet()) {
            String ptreeName = next.getKey();
            String ptreeCode = next.getValue();
            List<RsPropertiesReDomain> rsPropertiesReDomains = this.queryPropertiesPage(ptreeCode);
            if (CollectionUtils.isEmpty(rsPropertiesReDomains)) {
                this.saveProperties(ptreeCode, memberCode);
                continue;
            }
            List collect = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> ptreeCode.equals(rsPropertiesReDomain.getPntreeCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) continue;
            this.saveProperties(ptreeCode, memberCode);
        }
    }

    private void saveProperties(String ptreeCode, String memberCode) {
        this.saveProperties(ptreeCode, "\u662f\u5426\u6709\u9970\u54c1", memberCode);
        this.saveProperties(ptreeCode, "\u4ea7\u54c1\u7ebf", memberCode);
        this.saveProperties(ptreeCode, "\u5e74\u4efd", memberCode);
        this.saveProperties(ptreeCode, "\u4ea7\u54c1\u5b63", memberCode);
        this.saveProperties(ptreeCode, "\u6ce2\u6bb5", memberCode);
        this.saveProperties(ptreeCode, "\u7cfb\u5217", memberCode);
        this.saveProperties(ptreeCode, "\u98ce\u683c", memberCode);
        this.saveProperties(ptreeCode, "\u4e3b\u9898", memberCode);
        this.saveProperties(ptreeCode, "\u53ef\u62c6\u5378\u914d\u4ef6\u6570\u91cf", memberCode);
        this.saveProperties(ptreeCode, "\u662f\u5426\u8ffd\u5355\u6b3e", memberCode);
        this.saveProperties(ptreeCode, "\u4e3b\u6210\u5206\u6bd4", memberCode);
        this.saveProperties(ptreeCode, "\u514b\u91cd", memberCode);
        this.saveProperties(ptreeCode, "\u59c6\u7c73\u6570", memberCode);
    }

    private String saveProperties(String ptreeCode, String name, String memberCode) {
        String code = LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode();
        this.logger.info("APPcode:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)code));
        RsPropertiesDomain rsPropertiesDomain = new RsPropertiesDomain();
        rsPropertiesDomain.setPntreeCode(ptreeCode);
        rsPropertiesDomain.setPropertiesName(name);
        rsPropertiesDomain.setPropertiesType("1");
        rsPropertiesDomain.setAppmanageIcode(code);
        rsPropertiesDomain.setTenantCode("2022012800000001");
        log.info("\u4fdd\u5b58\u5c5e\u6027\u503c\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)rsPropertiesDomain));
        return this.saveProperties(rsPropertiesDomain);
    }

    private String saveProperties(RsPropertiesDomain ptreeCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsPropertiesDomain", JsonUtil.buildNormalBinder().toJson((Object)ptreeCode));
        Object o = this.getInternalRouter().inInvoke("rs.properties.saveProperties", pmap);
        log.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
        return (String)o;
    }

    private String saveClassGoods(RsGoodsClassDomain rsGoodsClassDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsGoodsClassDomain", JsonUtil.buildNormalBinder().toJson((Object)rsGoodsClassDomain));
        Object o = this.getInternalRouter().inInvoke("rs.resource.saveGoodsClass", pmap);
        log.info("\u4fdd\u5b58\u524d\u53f0\u5206\u7c7b\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", rsGoodsClassDomain.getTenantCode());
        param.put("memberCode", rsGoodsClassDomain.getMemberCode());
        param.put("fuzzy", true);
        param.put("channelCode", rsGoodsClassDomain.getChannelCode());
        param.put("goodsClassEocode", rsGoodsClassDomain.getGoodsClassEocode());
        HashMap<String, String> pmap1 = new HashMap<String, String>();
        pmap1.put("map", JsonUtil.buildNormalBinder().toJson(param));
        QueryResult reDomainSupQueryResult = this.getQueryResutl("rs.goodsClass.queryGoodsClassPage", pmap1, RsGoodsClassReDomain.class);
        return ((RsGoodsClassReDomain)reDomainSupQueryResult.getList().get(0)).getGoodsClassCode();
    }

    private List<RsPropertiesReDomain> queryPropertiesPage(String ptreeCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pntreeCode", ptreeCode);
        map.put("fuzzy", true);
        map.put("tenantCode", "2022012800000001");
        log.info("\u8bf7\u6c42\u6240\u6709\u5c5e\u6027\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonNullBinder().toJson(map));
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.properties.queryPropertiesPage", pmap, RsPropertiesReDomain.class);
        this.logger.info("\u83b7\u53d6\u6240\u6709\u5c5e\u6027\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rs));
        return rs.getList();
    }

    @Override
    public Boolean shoppersOrStoresSynchronous() {
        List<AreaDomainEntity> areaDomainEntities = ExcelReadUtil.loadScoreInfo(areaDomain, new AreaDomainEntity()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (this.areaDataSynchronous(areaDomainEntities = areaDomainEntities.stream().filter(ele -> ele.getDivision() != null).filter(ele -> lancy.equals(ele.getDivision()) || like.equals(ele.getDivision()) || season.equals(ele.getDivision())).collect(Collectors.toList())).booleanValue()) {
            log.info("\u540c\u6b65\u533a\u57df\u5b8c\u6210");
            String sql = "SELECT * from V_ZDPSX WHERE VALID = 'X' and GJAHR = YEAR(NOW()) and (BUNIT = 'LANCY' or BUNIT = 'LIME' or BUNIT = '5SEASON')";
            List<StoreEntity> list = MySqlJDBCUtil.executeQuery(sql, new StoreEntity());
            log.info("\u67e5\u8be2\u51fa\u7684\u6761\u6570::{}", (Object)list.size());
            if (this.storesDataSynchronous(list).booleanValue()) {
                log.info("\u540c\u6b65\u95e8\u5e97\u5b8c\u6210");
                List newOrgDepart = ((Stream)this.queryDepartPage().stream().parallel()).filter(ele -> ele.getUserinfoDataStatu() != null).filter(ele -> ele.getUserinfoDataStatu() != -1).collect(Collectors.toList());
                for (StoreEntity storeEntity : list) {
                    OrgDepartDomain orgDepartDomain1;
                    Boolean dataStatu = storeEntity.thanTime();
                    if (!dataStatu.booleanValue()) continue;
                    log.info("\u95ed\u9986\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\u7684\u4fe1\u606f::{}", (Object)storeEntity.getZCODE());
                    Optional<OrgDepartDomain> orgDepartDomain = newOrgDepart.stream().filter(Objects::nonNull).filter(ele -> ele.getUserinfoCode() != null).filter(ele -> ele.getDepartOcode() != null).filter(ele -> ele.getDepartOcode().equals(storeEntity.getZCODE())).findFirst();
                    log.info("orgDepartDomain\u4fdd\u5b58\u7684\u65e0\u6548\u6570\u636e\u4e3a::{}", (Object)JsonUtil.buildNormalBinder().toJson(orgDepartDomain));
                    if (!orgDepartDomain.isPresent() || (orgDepartDomain1 = orgDepartDomain.get()).getUserinfoDataStatu() == -1) continue;
                    log.info("\u4fee\u6539\u65e0\u6548\u7684\u95e8\u5e97::{}", (Object)orgDepartDomain1.getUserinfoId());
                    this.updateUserinfoState(orgDepartDomain1.getUserinfoId());
                }
                log.info("\u4fee\u6539\u95e8\u5e97\u72b6\u6001\u5b8c\u6210");
                String sql1 = "SELECT * FROM V_qy_user qu INNER JOIN V_ZDPSX zd on qu.ZZHR_PSBH = zd.ZCODE and zd.VALID = 'X' and zd.GJAHR = YEAR(NOW()) WHERE qu.mobile is NOT null and qu.mobile != '' and qu.ZZHR_SUPPT is not null and (qu.ZZHR_SUPPT = '\u6717\u59ff' or qu.ZZHR_SUPPT = '\u83b1\u8335' or qu.ZZHR_SUPPT = '\u7b2c\u4e94\u5b63')";
                List<SalesmanEntity> salesmanEntities = MySqlJDBCUtil.executeQuery(sql1, new SalesmanEntity());
                this.salesmanDataSynchronous(salesmanEntities);
                log.info("\u540c\u6b65\u5bfc\u8d2d\u5b8c\u6210");
            }
        }
        return Boolean.TRUE;
    }

    private Map<String, List<ImsEntity>> handleImsGoods() {
        List<ImsEntity> list = imsEntityList.stream().filter(imsEntity -> StringUtils.isNotBlank((String)imsEntity.getSizeGroup())).filter(imsEntity -> LancyWithB2cMapEnum.getByValue(imsEntity.getBrand()) != null).collect(Collectors.toList());
        return this.imsGoodsFlite(list);
    }

    private Map<String, List<ImsEntity>> imsGoodsFlite(List<ImsEntity> list) {
        HashMap<String, List<ImsEntity>> goodsMap = new HashMap<String, List<ImsEntity>>();
        for (ImsEntity imsEntity : list) {
            String brand = imsEntity.getBrand();
            if (goodsMap.containsKey(brand)) {
                ((List)goodsMap.get(brand)).add(imsEntity);
                continue;
            }
            ArrayList<ImsEntity> arr = new ArrayList<ImsEntity>();
            arr.add(imsEntity);
            goodsMap.put(brand, arr);
        }
        return goodsMap;
    }

    public DisChannelDomain queryChannelPage(String memBerCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memBerCode);
        map.put("tenantCode", tenantCode);
        map.put("fuzzy", true);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("dis.channel.queryChannelPage", pmap, DisChannelDomain.class);
        this.logger.info("\u83b7\u53d6\u7684\u6e20\u9053\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rs));
        return (DisChannelDomain)rs.getList().stream().filter(Objects::nonNull).filter(ele -> ele.getChannelCode() != null && ele.getChannelName() != null).collect(Collectors.toList()).get(0);
    }

    public List<DisChannelDomain> queryChannelPage(String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("fuzzy", true);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("dis.channel.queryChannelPage", pmap, DisChannelDomain.class);
        return rs.getList().stream().filter(ele -> ele.getChannelCode() != null && ele.getChannelName() != null).collect(Collectors.toList());
    }

    public List<RsBrandDomain> queryBrandPage(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        log.info("queryBrandPage::{}", pmap);
        QueryResult brandRs = this.getQueryResutl("rs.brand.queryBrandPage", pmap, RsBrandDomain.class);
        log.info("\u83b7\u53d6\u5168\u90e8\u54c1\u724cbrandRs::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)brandRs));
        if (null == brandRs) {
            return null;
        }
        return brandRs.getList();
    }

    public String saveBrand(String memberCode, Mvgr1Entity mvgr1Entity) {
        RsBrandDomain brandDomain = new RsBrandDomain();
        brandDomain.setMemberCode(memberCode);
        brandDomain.setBrandName(mvgr1Entity.getBEZEI());
        brandDomain.setMemo(mvgr1Entity.getMVGR1());
        brandDomain.setTenantCode("2022012800000001");
        brandDomain.setBrandEocode(mvgr1Entity.getMVGR1());
        brandDomain.setBrandLogo("\u540c\u6b65\u6570\u636e\u6682\u65e0\u54c1\u724c\u56fe\u7247");
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, "2022012800000001");
        brandDomain.setChannelCode(disChannelDomain.getChannelCode());
        brandDomain.setChannelName(disChannelDomain.getChannelName());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)brandDomain));
        log.info("rsBrandDomain::{}", pmap);
        String brandCode = null;
        try {
            Object brand = this.getInternalRouter().inInvoke("rs.resource.sendSaveBrand", pmap);
            log.info("brand::{}", brand);
            brandCode = brand.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u6dfb\u52a0\u54c1\u724c\u8fd4\u56de\u7684id::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(brandCode));
        return brandCode;
    }

    public void synchronousBrand(List<String> brandList, JsonEntity jsonEntity, String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", "2022012800000001");
        map.put("page", 1);
        map.put("rows", 100000);
        List<RsBrandDomain> queryBrand = this.queryBrandPage(map);
        for (String brand : brandList) {
            List collect;
            if (!CollectionUtils.isEmpty(queryBrand) && !CollectionUtils.isEmpty(collect = queryBrand.stream().filter(b -> brand.equals(b.getBrandEocode())).collect(Collectors.toList()))) {
                brandContainer.put(brand, ((RsBrandDomain)collect.get(0)).getBrandCode());
                continue;
            }
            List mvgr1EntityList = jsonEntity.getMVGR1().stream().filter(entity -> brand.equals(entity.getMVGR1())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(mvgr1EntityList)) {
                log.info("\u8be5\u54c1\u724ccode\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)brand));
                continue;
            }
            Mvgr1Entity mvgr1Entity = (Mvgr1Entity)mvgr1EntityList.get(0);
            String code = this.saveBrand(memberCode, mvgr1Entity);
            brandContainer.put(brand, code);
        }
    }

    public List<RsSpecGroupDomain> querySpecGroup(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        map.put("order", true);
        map.put("fuzzy", true);
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        log.info("pmap::{}", pmap);
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecGroupPage", pmap, RsSpecGroupDomain.class);
        log.info("\u83b7\u53d6\u901a\u7528\u89c4\u683c\u7ec4::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)rs));
        return rs.getList();
    }

    public SupQueryResult<RsSpecDomain> querySpecPage(String specGroupCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupCode", specGroupCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecPage", pmap, RsSpecDomain.class);
        return rs;
    }

    public List<RsSpecOptionDomain> querySpecOptionPage(String specCode, String specOptionNum) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specCode", specCode);
        map.put("specOptionNum", specOptionNum);
        map.put("fuzzy", false);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.spec.querySpecOptionPage", pmap, RsSpecOptionDomain.class).getList();
    }

    public List<RsSpecOptionDomain> querySpecOptionPage1(String specCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specGroupCode", specCode);
        map.put("tenantCode", "2022012800000001");
        map.put("fuzzy", false);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.spec.querySpecOptionPage", pmap, RsSpecOptionDomain.class).getList();
    }

    public String saveSpecGroup(String channelCode, String memberCode, String tenantCode, String specGroupNam) {
        RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
        rsSpecGroupDomain.setSpecGroupName(specGroupNam);
        rsSpecGroupDomain.setChannelCode(channelCode);
        rsSpecGroupDomain.setMemberCode(memberCode);
        rsSpecGroupDomain.setMemo(specGroupNam);
        rsSpecGroupDomain.setTenantCode(tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecGroupDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain));
        log.info("pmap\u4fdd\u5b58\u89c4\u683c\u7ec4::{}", pmap);
        String specGroupCode = this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", pmap).toString();
        specGroupData.put(specGroupNam, specGroupCode);
        return specGroupCode;
    }

    public String saveSpec(String specGroupCode, String specName, String tenantCode) {
        RsSpecDomain rsSpecDomain = new RsSpecDomain();
        rsSpecDomain.setSpecGroupCode(specGroupCode);
        rsSpecDomain.setSpecName(specName);
        rsSpecDomain.setTenantCode(tenantCode);
        rsSpecDomain.setSpecDefault("1");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain));
        return this.getInternalRouter().inInvoke("rs.spec.saveSpec", pmap).toString();
    }

    public Boolean saveSpecOption(List<RsSpecOptionDomain> rsSpecOptionDomains) {
        for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecOptionDomains) {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("rsSpecOptionDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain));
            this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", pmap);
        }
        return Boolean.TRUE;
    }

    public void synchronousSpecInfo(String memberCode, List<ImsEntity> imsList, JsonEntity jsonEntity) {
        Map<String, Set<String>> specGroupMap = this.specGroupHandle(imsList);
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, "2022012800000001");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", "2022012800000001");
        map.put("channelCode", disChannelDomain.getChannelCode());
        map.put("page", 1);
        map.put("rows", 1000000);
        List<RsSpecGroupDomain> rsSpecGroupDomain = this.querySpecGroup(map);
        Iterator<String> iterator = specGroupMap.keySet().iterator();
        while (iterator.hasNext()) {
            log.info("\u5f00\u59cb\u5faa\u73af\u65b0\u589e\u89c4\u683c\u7ec4");
            String sizeGroup = iterator.next();
            Set<String> colors = specGroupMap.get(sizeGroup);
            List collect = rsSpecGroupDomain.stream().filter(specGroupDomain -> sizeGroup.equals(specGroupDomain.getMemo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                String specGroupCode = this.saveSpecGroup(disChannelDomain.getChannelCode(), memberCode, "2022012800000001", sizeGroup);
                log.info("\u521b\u5efa\u89c4\u683c\u7ec4 \u751f\u6210\u7684specGroupCode\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)specGroupCode));
                String specCodeColor = this.saveSpec(specGroupCode, "\u989c\u8272", "2022012800000001");
                String specCodeSize = this.saveSpec(specGroupCode, "\u5c3a\u7801", "2022012800000001");
                this.saveSpecGroupAttached(memberCode, jsonEntity, specGroupCode, sizeGroup, colors, specCodeColor, specCodeSize);
                specGroupContainer.put(sizeGroup, specGroupCode);
                continue;
            }
            RsSpecGroupDomain rsSpecGroupDomain1 = (RsSpecGroupDomain)collect.get(0);
            SupQueryResult<RsSpecDomain> rsSpecDomainSupQueryResult = this.querySpecPage(rsSpecGroupDomain1.getSpecGroupCode());
            this.logger.info("rsSpecDomainSupQueryResult:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(rsSpecDomainSupQueryResult));
            List list = rsSpecDomainSupQueryResult.getList();
            String specCodeColor = ((RsSpecDomain)list.stream().filter(rsSpecDomain -> rsSpecDomain.getSpecName().equals("\u989c\u8272")).collect(Collectors.toList()).get(0)).getSpecCode();
            String specCodeSize = ((RsSpecDomain)list.stream().filter(rsSpecDomain -> rsSpecDomain.getSpecName().equals("\u5c3a\u7801")).collect(Collectors.toList()).get(0)).getSpecCode();
            this.saveSpecGroupAttached(memberCode, jsonEntity, rsSpecGroupDomain1.getSpecGroupCode(), sizeGroup, colors, specCodeColor, specCodeSize);
            specGroupContainer.put(sizeGroup, rsSpecGroupDomain1.getSpecGroupCode());
        }
    }

    private void saveSpecGroupAttached(String memberCode, JsonEntity jsonEntity, String specGroupCode, String groupSize, Set<String> colors, String specCodeColor, String specCodeSize) {
        log.info("------\u5f00\u59cb\u65b0\u589e\u89c4\u683c\u7ec4\u7b2c\u4e09\u7ea7------");
        ArrayList<RsSpecOptionDomain> saveSpecOptionSize = new ArrayList<RsSpecOptionDomain>();
        ArrayList<RsSpecOptionDomain> saveSpecOptionColor = new ArrayList<RsSpecOptionDomain>();
        List<SizeEntity> sizeEntities = jsonEntity.getSIZE();
        List groupSizeList = sizeEntities.stream().filter(sizeEntity -> sizeEntity.getZPGNR().equals(groupSize)).collect(Collectors.toList());
        for (SizeEntity sizeEntity2 : groupSizeList) {
            int size = this.querySpecOptionPage(specCodeSize, sizeEntity2.getJSIZE()).size();
            if (size != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainSize = new RsSpecOptionDomain();
            rsSpecOptionDomainSize.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainSize.setSpecCode(specCodeSize);
            rsSpecOptionDomainSize.setSpecOptionName(sizeEntity2.getSIZET());
            rsSpecOptionDomainSize.setSpecOptionNum(sizeEntity2.getJSIZE());
            rsSpecOptionDomainSize.setTenantCode("2022012800000001");
            rsSpecOptionDomainSize.setMemberCode(memberCode);
            saveSpecOptionSize.add(rsSpecOptionDomainSize);
        }
        List<ColorEntity> colorEntityList = jsonEntity.getCOLOR();
        for (String color : colors) {
            List collect = colorEntityList.stream().filter(colorEntity -> colorEntity.getJ_3ACOL().equals(color)).collect(Collectors.toList());
            ColorEntity colorEntity2 = (ColorEntity)collect.get(0);
            if (this.querySpecOptionPage(specCodeColor, colorEntity2.getJ_3ACOL()).size() != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainContro = new RsSpecOptionDomain();
            rsSpecOptionDomainContro.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainContro.setSpecCode(specCodeColor);
            rsSpecOptionDomainContro.setSpecOptionName(colorEntity2.getTEXT());
            rsSpecOptionDomainContro.setSpecOptionNum(colorEntity2.getJ_3ACOL());
            rsSpecOptionDomainContro.setTenantCode("2022012800000001");
            rsSpecOptionDomainContro.setMemberCode(memberCode);
            saveSpecOptionColor.add(rsSpecOptionDomainContro);
        }
        log.info("\u5904\u7406\u5b8c\u540e\u7684\u989c\u8272::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(saveSpecOptionColor));
        log.info("\u5904\u7406\u5b8c\u540e\u7684\u5c3a\u5bf8::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(saveSpecOptionSize));
        if (saveSpecOptionSize.size() != 0) {
            this.saveSpecOption(saveSpecOptionSize);
        }
        if (saveSpecOptionColor.size() != 0) {
            this.saveSpecOption(saveSpecOptionColor);
        }
    }

    private Map<String, Set<String>> specGroupHandle(List<ImsEntity> imsList) {
        log.info("\u5f00\u59cb\u8fc7\u6ee4\u89c4\u683c\u7ec4\u6570\u636e");
        if (CollectionUtils.isEmpty(imsList)) {
            log.info("\u5f00\u59cb\u8fc7\u6ee4\u89c4\u683c\u7ec4\u6570\u636e--\u65e0\u6570\u636e");
            return null;
        }
        HashSet<String> groupSize = new HashSet<String>();
        for (ImsEntity imsEntity : imsList) {
            if (!StringUtils.isNotBlank((String)imsEntity.getSizeGroup())) continue;
            groupSize.add(imsEntity.getSizeGroup());
        }
        log.info("\u8fc7\u6ee4\u540e\u7684\u89c4\u683c\u7ec4--\u5c3a\u5bf8::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(groupSize));
        Hashtable<String, Set<String>> specGroupMap = new Hashtable<String, Set<String>>();
        for (String imsEntity : groupSize) {
            HashSet<String> arr = new HashSet<String>();
            for (int i = 0; i < imsList.size(); ++i) {
                if (!StringUtils.isNotBlank((String)imsList.get(i).getSizeGroup()) || !imsList.get(i).getSizeGroup().equals(imsEntity)) continue;
                arr.add(imsList.get(i).getColor());
            }
            specGroupMap.put(imsEntity, arr);
        }
        return specGroupMap;
    }

    public List<RsPntreeReDomain> queryPntreePage(String tenantCode, String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("appmanageIcode", LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode());
        map.put("fuzzy", false);
        map.put("page", 1);
        map.put("rows", 1000000);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rsPntreeReDomains = this.getQueryResutl("rs.pntree.queryPntreePage", pmap, RsPntreeReDomain.class);
        log.info("rsPntreeReDomains::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)rsPntreeReDomains));
        if (null == rsPntreeReDomains) {
            return null;
        }
        return rsPntreeReDomains.getList();
    }

    public String savePntree(String specGroupCode, String tenantCode, String brandCodeStr, String pntreeName, String memberCode) {
        RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
        rsPntreeDomain.setPntreeName(pntreeName);
        rsPntreeDomain.setSpecGroupCodeStr(specGroupCode);
        rsPntreeDomain.setTenantCode(tenantCode);
        rsPntreeDomain.setBrandCodeStr(brandCodeStr);
        rsPntreeDomain.setPntreeShow(0);
        rsPntreeDomain.setPntreeEocode(pntreeName);
        rsPntreeDomain.setAppmanageIcode(LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsPntreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsPntreeDomain));
        log.info("pmap::{}", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
        Object pntreeObj = this.getInternalRouter().inInvoke("rs.pntree.savePntree", pmap);
        log.info("pntreeObj::{}", (Object)pntreeObj.toString());
        return pntreeObj.toString();
    }

    public Boolean synchronousPntree(List<ImsEntity> imsList, String memberCode) {
        List<RsPntreeReDomain> pntreeRs = this.queryPntreePage("2022012800000001", memberCode);
        if (ListUtil.isNotEmpty(pntreeRs)) {
            for (RsPntreeReDomain rsPntreeReDomain : pntreeRs) {
                if (!StringUtils.isNotBlank((String)rsPntreeReDomain.getPntreeEocode())) continue;
                goodsTypeContainer.put(rsPntreeReDomain.getPntreeEocode(), rsPntreeReDomain.getPntreeCode());
            }
        }
        if (ListUtil.isNotEmpty(pntreeRs)) {
            for (Map.Entry<String, String> next : specGroupContainer.entrySet()) {
                String key = next.getKey();
                String value = next.getValue();
                List collect = pntreeRs.stream().filter(rs -> key.equals(rs.getPntreeEocode())).collect(Collectors.toList());
                boolean empty = CollectionUtils.isEmpty(collect);
                log.info("\u89c4\u683c\u7ec4\u662f\u5426\u5df2\u7ecf\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)empty));
                String pntreeCode = null;
                if (empty) {
                    String brandCodeStr = null;
                    if (!CollectionUtils.isEmpty(brandContainer)) {
                        brandCodeStr = this.getSpecGroupBrand(key, imsList, brandContainer);
                    }
                    pntreeCode = this.savePntree(value, "2022012800000001", brandCodeStr, key, memberCode);
                    log.info("pntreeCode2::{}", (Object)pntreeCode);
                } else {
                    RsPntreeReDomain rsPntreeReDomain = (RsPntreeReDomain)collect.get(0);
                    pntreeCode = rsPntreeReDomain.getPntreeCode();
                }
                goodsTypeContainer.put(key, pntreeCode);
            }
        } else {
            for (Map.Entry<String, String> next : specGroupContainer.entrySet()) {
                String key = next.getKey();
                String value = next.getValue();
                String brandCodeStr = null;
                if (!CollectionUtils.isEmpty(brandCodeMap)) {
                    brandCodeStr = this.getSpecGroupBrand(key, imsList, brandCodeMap.get(memberCode));
                }
                String pntreeCode = this.savePntree(value, "2022012800000001", brandCodeStr, key, memberCode);
                log.info("pntreeCode2::{}", (Object)pntreeCode);
                goodsTypeContainer.put(key, pntreeCode);
            }
        }
        return Boolean.TRUE;
    }

    private String getSpecGroupBrand(String sizeGroup, List<ImsEntity> imsList, Map<String, String> brandCodeMap) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u6240\u5c5e\u7684\u54c1\u724c");
        String brandStr = null;
        for (int i = 0; i < imsList.size(); ++i) {
            String s;
            ImsEntity imsEntity = imsList.get(i);
            if (!sizeGroup.equals(imsEntity.getSizeGroup()) || !StringUtils.isBlank(brandStr) && brandStr.contains(imsEntity.getSubBrand())) continue;
            if (StringUtils.isBlank(brandStr)) {
                s = brandCodeMap.get(imsEntity.getSubBrand());
                if (!StringUtils.isNotBlank((String)s)) continue;
                brandStr = s;
                continue;
            }
            s = brandCodeMap.get(imsEntity.getSubBrand());
            if (!StringUtils.isNotBlank((String)s)) continue;
            brandStr = brandStr + "," + s;
        }
        log.info("\u7ed3\u675f\u5f00\u59cb\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u6240\u5c5e\u7684\u54c1\u724c,\u53c2\u6570:{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(brandStr));
        return brandStr;
    }

    public Boolean synchronousBasisInfo(List<ImsEntity> imsList, JsonEntity jsonEntity, String memberCode) {
        brandList = this.brandHandle(imsList);
        if (!ListUtil.isEmpty(brandList)) {
            this.synchronousBrand(brandList, jsonEntity, memberCode);
        }
        this.synchronousSpecInfo(memberCode, imsList, jsonEntity);
        if (!CollectionUtils.isEmpty(specGroupContainer)) {
            this.synchronousPntree(imsList, memberCode);
        }
        return Boolean.TRUE;
    }

    private List<String> brandHandle(List<ImsEntity> imsList) {
        ArrayList<String> list = new ArrayList<String>();
        for (ImsEntity imsEntity : imsList) {
            String subBrand = imsEntity.getSubBrand();
            if (!StringUtils.isNotBlank((String)subBrand) || list.contains(subBrand)) continue;
            list.add(subBrand);
        }
        log.info("\u8fc7\u6ee4\u540e\u7684\u54c1\u724c\u4e3a::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(list));
        return list;
    }

    public List<RsClasstreeReDomain> queryClasstreePage(String tenantCode, String memberCode, String channelCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("memberCode", memberCode);
        param.put("classtreeType", "0");
        param.put("fuzzy", false);
        param.put("page", 1);
        param.put("rows", 1000000);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        QueryResult reDomainSupQueryResult = this.getQueryResutl("rs.rsClasstree.queryClasstreePage", pmap, RsClasstreeReDomain.class);
        ArrayList<RsClasstreeReDomain> reDomainList = new ArrayList<RsClasstreeReDomain>();
        if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return reDomainList;
        }
        return reDomainSupQueryResult.getList();
    }

    public List<RsClasstreeReDomain> getChild(String id, List<RsClasstreeReDomain> all) {
        ArrayList<RsClasstreeReDomain> childList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!StringUtils.isNotBlank((String)rsClasstreeReDomain.getClasstreeParentcode()) || !rsClasstreeReDomain.getClasstreeParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    public String saveClasstree(RsClasstreeReDomain rsClasstreeDomain, List<String> list) {
        Objects.requireNonNull(list, "list\u4e3a\u83b7\u53d6\u7684\u5206\u7c7b\u7c7b\u578b");
        rsClasstreeDomain.setTenantCode("2022012800000001");
        rsClasstreeDomain.setMemo(list.get(0));
        rsClasstreeDomain.setClasstreeName(list.get(1));
        rsClasstreeDomain.setClasstreeType("0");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
        log.info("pmapclass::{}", pmap);
        Object classtreeCode = this.getInternalRouter().inInvoke("rs.resource.sendSaveClasstree", pmap);
        log.info("classtreeCode::{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(classtreeCode));
        return (String)classtreeCode;
    }

    public List<String> getClasstreeInfo(JsonEntity jsonEntity, Integer source, String code) {
        if (jsonEntity.getLCLS() != null && source == 1) {
            LclsEntity lclsEntity = jsonEntity.getLCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getLABOR() != null && ele.getLBTXT() != null).filter(ele -> ele.getLABOR().equals(code)).findFirst().get();
            return Arrays.asList(lclsEntity.getLABOR(), lclsEntity.getLBTXT());
        }
        if (jsonEntity.getMCLS() != null && source == 2) {
            MclsEntity mclsEntity = jsonEntity.getMCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getMATKL() != null && ele.getWGBEZ() != null).filter(ele -> ele.getMATKL().equals(code)).findFirst().get();
            return Arrays.asList(mclsEntity.getMATKL(), mclsEntity.getWGBEZ());
        }
        if (jsonEntity.getSCLS() != null && source == 3) {
            SclsEntity sclsEntity = jsonEntity.getSCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getEXTWG() != null && ele.getEWBEZ() != null).filter(ele -> ele.getEXTWG().equals(code)).findFirst().get();
            return Arrays.asList(sclsEntity.getEXTWG(), sclsEntity.getEWBEZ());
        }
        return null;
    }

    public String structureGoodsClasstreeInfo(Integer source, ImsEntity ims, JsonEntity jsonEntity, String classtreeParentcode, String memberCode) {
        RsGoodsClassDomain classtreeDomain = new RsGoodsClassDomain();
        classtreeDomain.setChannelCode(this.queryChannelPage(memberCode, "2022012800000001").getChannelCode());
        classtreeDomain.setMemberCode(memberCode);
        classtreeDomain.setGoodsClassHide("0");
        classtreeDomain.setTenantCode("2022012800000001");
        classtreeDomain.setAppmanageIcode(LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode());
        if (source == 1) {
            classtreeDomain.setGoodsClassLast("1");
            classtreeDomain.setGoodsClassParentcode("-1");
            classtreeDomain.setGoodsClassEocode(ims.getField3());
            classtreeDomain.setGoodsClassLogo("/paas/shop/2022012800000001/2022-04-17/9525f3825d984d0d9d3d26e7de72aa45.jpeg");
            List<String> classtreeInfo = this.getClasstreeInfo(jsonEntity, source, ims.getField3());
            classtreeDomain.setGoodsClassName(classtreeInfo.get(1));
            return this.saveClassGoods(classtreeDomain);
        }
        if (source == 2) {
            classtreeDomain.setGoodsClassLast("1");
            classtreeDomain.setGoodsClassParentcode(classtreeParentcode);
            classtreeDomain.setGoodsClassEocode(ims.getField5());
            List<String> classtreeInfo = this.getClasstreeInfo(jsonEntity, source, ims.getField5());
            classtreeDomain.setGoodsClassName(classtreeInfo.get(1));
            return this.saveClassGoods(classtreeDomain);
        }
        if (source == 3) {
            List<RsGoodsClassReDomain> rsClasstreeReDomains = this.queryClassGoodsTreePage("2022012800000001", memberCode);
            List collect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> StringUtils.isNotBlank((String)ele.getGoodsClassEocode()) && "-1".equals(ele.getGoodsClassParentcode()) && ele.getGoodsClassEocode().equals(ims.getField3())).collect(Collectors.toList());
            String goodsClassCode = ((RsGoodsClassReDomain)collect.get(0)).getGoodsClassCode();
            List middleCollect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> StringUtils.isNotBlank((String)ele.getGoodsClassEocode()) && goodsClassCode.equals(ele.getGoodsClassParentcode()) && ele.getGoodsClassEocode().equals(ims.getField5())).collect(Collectors.toList());
            String goodsClassCode1 = ((RsGoodsClassReDomain)middleCollect.get(0)).getGoodsClassCode();
            classtreeDomain.setGoodsClassLast("0");
            classtreeDomain.setGoodsClassParentcode(goodsClassCode1);
            classtreeDomain.setGoodsClassEocode(ims.getField4());
            classtreeDomain.setGoodsClassLogo("/paas/shop/2022012800000001/2022-04-17/9525f3825d984d0d9d3d26e7de72aa45.jpeg");
            if (StringUtils.isNotBlank((String)ims.getField4())) {
                classtreeDomain.setClasstreeCode(class3TreeContainer.get(ims.getField4()));
            }
            List<String> classtreeInfo = this.getClasstreeInfo(jsonEntity, source, ims.getField4());
            classtreeDomain.setGoodsClassName(ims.getField3() + "/" + ims.getField5() + "/" + classtreeInfo.get(1));
            this.logger.info("classtreeDomain:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)classtreeDomain));
            return this.saveClassGoods(classtreeDomain);
        }
        return null;
    }

    public String structureClasstreeInfo(Integer source, ImsEntity ims, JsonEntity jsonEntity, String classtreeParentcode, String memberCode) {
        RsClasstreeReDomain classtreeDomain = new RsClasstreeReDomain();
        classtreeDomain.setChannelCode(this.queryChannelPage(memberCode, "2022012800000001").getChannelCode());
        classtreeDomain.setMemberCode(memberCode);
        classtreeDomain.setClasstreeLast("1");
        classtreeDomain.setAppmanageIcode(LancyWithB2cAppCodeMapEnum.getByValue(memberCode).getCode());
        if (source == 1) {
            classtreeDomain.setClasstreeParentcode("-1");
            classtreeDomain.setClasstreeEocode(ims.getField3());
            return this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField3()));
        }
        if (source == 2) {
            classtreeDomain.setClasstreeParentcode(classtreeParentcode);
            classtreeDomain.setClasstreeEocode(ims.getField5());
            return this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField5()));
        }
        if (source == 3) {
            classtreeDomain.setClasstreeParentcode(classtreeParentcode);
            classtreeDomain.setClasstreeEocode(ims.getField4());
            if (StringUtils.isNotBlank((String)ims.getSizeGroup())) {
                classtreeDomain.setPntreeCode(goodsTypeContainer.get(ims.getSizeGroup()));
            }
            classtreeDomain.setClasstreeLast("0");
            ArrayList<String> objects = new ArrayList<String>();
            List<String> classtreeInfo = this.getClasstreeInfo(jsonEntity, source, ims.getField4());
            objects.add(classtreeInfo.get(0));
            objects.add(ims.getField3() + "/" + ims.getField5() + "/" + classtreeInfo.get(1));
            return this.saveClasstree(classtreeDomain, objects);
        }
        return null;
    }

    public void synchronousClasstree(List<ImsEntity> imsList, JsonEntity jsonEntity, String memberCode) throws InterruptedException {
        log.info("\u5f00\u59cb\u540c\u6b65\u540e\u53f0\u5206\u7c7b");
        for (ImsEntity ims : imsList) {
            this.saveClasstree(jsonEntity, ims, memberCode);
        }
        for (ImsEntity ims : imsList) {
            this.saveGoodsClassTree(jsonEntity, ims, memberCode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveGoodsClassTree(JsonEntity jsonEntity, ImsEntity ims, String memberCode) {
        List<RsGoodsClassReDomain> rsClasstreeReDomains = this.queryClassGoodsTreePage("2022012800000001", memberCode);
        if (!CollectionUtils.isEmpty(rsClasstreeReDomains)) {
            log.info("\u5b58\u5728\u7684\u524d\u7aef\u4e00\u7ea7\u5206\u7c7b");
            this.logger.info("ims.getField3():{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ims.getField3()));
            this.logger.info("ims.getField5():{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ims.getField5()));
            this.logger.info("ims.getField4():{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ims.getField4()));
            List collect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> StringUtils.isNotBlank((String)ele.getGoodsClassEocode()) && "-1".equals(ele.getGoodsClassParentcode()) && ele.getGoodsClassEocode().equals(ims.getField3())).collect(Collectors.toList());
            this.logger.info("\u524d\u7aef\u4e00\u7ea7\u5206\u7c7bcollect:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(collect));
            if (!CollectionUtils.isEmpty(collect)) {
                RsGoodsClassReDomain reDomain = (RsGoodsClassReDomain)collect.get(0);
                String goodsClassCode = reDomain.getGoodsClassCode();
                List middleCollect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> StringUtils.isNotBlank((String)ele.getGoodsClassEocode()) && goodsClassCode.equals(ele.getGoodsClassParentcode()) && ele.getGoodsClassEocode().equals(ims.getField5())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(middleCollect)) {
                    String mclsSaveCode = this.structureGoodsClasstreeInfo(2, ims, jsonEntity, goodsClassCode, memberCode);
                    String sclsSaveCode = this.structureGoodsClasstreeInfo(3, ims, jsonEntity, mclsSaveCode, memberCode);
                    return;
                }
                RsGoodsClassReDomain reDomain2 = (RsGoodsClassReDomain)middleCollect.get(0);
                String goodsClassCode2 = reDomain2.getGoodsClassCode();
                List minCollect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> StringUtils.isNotBlank((String)ele.getGoodsClassEocode()) && goodsClassCode2.equals(ele.getGoodsClassParentcode()) && ele.getGoodsClassEocode().equals(ims.getField4())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(minCollect)) return;
                String sclsSaveCode = this.structureGoodsClasstreeInfo(3, ims, jsonEntity, goodsClassCode2, memberCode);
                return;
            }
            String lclsSaveCode = this.structureGoodsClasstreeInfo(1, ims, jsonEntity, null, memberCode);
            String mclsSaveCode = this.structureGoodsClasstreeInfo(2, ims, jsonEntity, lclsSaveCode, memberCode);
            String sclsSaveCode = this.structureGoodsClasstreeInfo(3, ims, jsonEntity, mclsSaveCode, memberCode);
            return;
        }
        String lclsSaveCode = this.structureGoodsClasstreeInfo(1, ims, jsonEntity, null, memberCode);
        String mclsSaveCode = this.structureGoodsClasstreeInfo(2, ims, jsonEntity, lclsSaveCode, memberCode);
        String sclsSaveCode = this.structureGoodsClasstreeInfo(3, ims, jsonEntity, mclsSaveCode, memberCode);
    }

    private List<RsGoodsClassReDomain> queryClassGoodsTreePage(String tenantCode, String memberCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("memberCode", memberCode);
        param.put("fuzzy", true);
        param.put("page", 1);
        param.put("rows", 1000000);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        QueryResult reDomainSupQueryResult = this.getQueryResutl("rs.goodsClass.queryGoodsClassPage", pmap, RsGoodsClassReDomain.class);
        ArrayList<RsGoodsClassReDomain> reDomainList = new ArrayList<RsGoodsClassReDomain>();
        if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return reDomainList;
        }
        return reDomainSupQueryResult.getList();
    }

    public List<RsGoodsClassReDomain> getGoodsChild(String id, List<RsGoodsClassReDomain> all) {
        ArrayList<RsGoodsClassReDomain> childList = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClassReDomain rsClasstreeReDomain : all) {
            if (!StringUtils.isNotBlank((String)rsClasstreeReDomain.getGoodsClassParentcode()) || !rsClasstreeReDomain.getGoodsClassParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsGoodsClassReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getGoodsChild(rsClasstreeReDomain.getGoodsClassCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    private void saveClasstree(JsonEntity jsonEntity, ImsEntity ims, String memberCode) throws InterruptedException {
        Thread.sleep(5L);
        List<RsClasstreeReDomain> rsClasstreeReDomains = this.queryClasstreePage("2022012800000001", memberCode, this.queryChannelPage(memberCode, "2022012800000001").getChannelCode());
        if (!CollectionUtils.isEmpty(rsClasstreeReDomains)) {
            List collect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeEocode() != null && "-1".equals(ele.getClasstreeParentcode()) && ele.getClasstreeEocode().equals(ims.getField3())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                RsClasstreeReDomain reDomain = (RsClasstreeReDomain)collect.get(0);
                String classtreeCode = reDomain.getClasstreeCode();
                List middleCollect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeEocode() != null && classtreeCode.equals(ele.getClasstreeParentcode()) && ele.getClasstreeEocode().equals(ims.getField5())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(middleCollect)) {
                    String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, classtreeCode, memberCode);
                    String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode, memberCode);
                    class3TreeContainer.put(ims.getField4(), sclsSaveCode);
                } else {
                    RsClasstreeReDomain reDomain2 = (RsClasstreeReDomain)middleCollect.get(0);
                    String classtreeCode2 = reDomain2.getClasstreeCode();
                    List minCollect = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeEocode() != null && classtreeCode2.equals(ele.getClasstreeParentcode()) && ele.getClasstreeEocode().equals(ims.getField4())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(minCollect)) {
                        String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, classtreeCode2, memberCode);
                        class3TreeContainer.put(ims.getField4(), sclsSaveCode);
                    } else {
                        class3TreeContainer.put(ims.getField4(), ((RsClasstreeReDomain)minCollect.get(0)).getClasstreeCode());
                    }
                }
                classTreeContainer.put(ims.getField3(), reDomain.getClasstreeCode());
            } else {
                String lclsSaveCode = this.structureClasstreeInfo(1, ims, jsonEntity, null, memberCode);
                String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, lclsSaveCode, memberCode);
                String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode, memberCode);
                classTreeContainer.put(ims.getField3(), lclsSaveCode);
                class3TreeContainer.put(ims.getField4(), sclsSaveCode);
            }
        } else {
            String lclsSaveCode = this.structureClasstreeInfo(1, ims, jsonEntity, null, memberCode);
            String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, lclsSaveCode, memberCode);
            String sclsSaveCode = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode, memberCode);
            classTreeContainer.put(ims.getField3(), lclsSaveCode);
            class3TreeContainer.put(ims.getField4(), sclsSaveCode);
        }
    }

    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage(String memberCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("validFlag", true);
        map.put("goodsOrigin", "0");
        map.put("goodsType", "00");
        map.put("fuzzy", "true");
        map.put("memberCode", memberCode);
        map.put("page", 1);
        map.put("rows", 1000000000);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pmap, RsResourceGoodsReDomain.class);
    }

    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage(String memberCode, String goodsEcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("validFlag", true);
        map.put("goodsOrigin", "0");
        map.put("goodsType", "00");
        map.put("fuzzy", "true");
        map.put("memberCode", memberCode);
        map.put("goodsNo", goodsEcode);
        map.put("page", 1);
        map.put("rows", 1000000000);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pmap, RsResourceGoodsReDomain.class);
    }

    public SupQueryResult<RsResourceGoodsReDomain> getResourceGoodsTime() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("validFlag", true);
        map.put("goodsOrigin", "0");
        map.put("goodsType", "00");
        map.put("fuzzy", "true");
        map.put("page", 1);
        map.put("rows", 1);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pmap, RsResourceGoodsReDomain.class);
    }

    public void assemblyGoods(String memberCode, List<ImsEntity> imsList) throws InterruptedException {
        List list = null;
        String goodsRedis = SupDisUtil.getDisCache().getRemot(GOODS_REDIS);
        if (StringUtils.isBlank((String)goodsRedis)) {
            SupQueryResult<RsResourceGoodsReDomain> goods = this.queryResourceGoodsPage(memberCode);
            list = goods.getList();
            SupDisUtil.getDisCache().set(GOODS_REDIS, JsonUtil.buildNonDefaultBinder().toJson((Object)list));
        } else {
            list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsRedis, RsResourceGoodsReDomain.class);
        }
        List<UnitEntity> unit = jsonEntity.getUNIT();
        List<Mvgr1Entity> mvgr1 = jsonEntity.getMVGR1();
        List<ColorEntity> color = jsonEntity.getCOLOR();
        List<SizeEntity> size = jsonEntity.getSIZE();
        List<PldzEntity> pldz = jsonEntity.getPLDZ();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", "2022012800000001");
        map.put("fuzzy", true);
        List<RsSpecGroupDomain> rsSpecGroupDomain = this.querySpecGroup(map);
        log.info("\u83b7\u53d6\u89c4\u683c\u7ec4\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(rsSpecGroupDomain));
        List<RsClasstreeReDomain> rsClasstreeReDomains = this.queryClasstreePage("2022012800000001", memberCode, this.queryChannelPage(memberCode, "2022012800000001").getChannelCode());
        for (ImsEntity imsEntity : imsList) {
            boolean updateFlag = true;
            List collect = null;
            if (!CollectionUtils.isEmpty((Collection)list)) {
                collect = list.stream().filter(Objects::nonNull).filter(l -> l.getGoodsEocode() != null).filter(l -> imsEntity.getSpu().equals(l.getGoodsEocode())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    for (RsResourceGoodsReDomain rsResourceGoodsReDomain : collect) {
                        if (rsResourceGoodsReDomain.getDataState() != 2) continue;
                        this.logger.info("\u8be5\u5546\u54c1\u5df2\u4e0a\u67b6\uff0c\u65e0\u6cd5\u4fee\u6539 spu\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)rsResourceGoodsReDomain.getGoodsEocode()));
                        updateFlag = false;
                        break;
                    }
                }
                if (!updateFlag) continue;
            }
            Thread.sleep(5L);
            RsResourceGoodsReDomain resourceGoodsParam = this.getResourceGoodsParam(mvgr1, unit, color, size, imsEntity, memberCode, rsSpecGroupDomain, rsClasstreeReDomains, pldz);
            if (Objects.isNull(resourceGoodsParam)) continue;
            this.arr.add(resourceGoodsParam);
        }
        if (!CollectionUtils.isEmpty(this.arr)) {
            for (RsResourceGoodsReDomain resourceGoodsReDomain : this.arr) {
                Thread.sleep(20L);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    this.sendSaveResourceGoods(resourceGoodsReDomain);
                    list.add(resourceGoodsReDomain);
                    SupDisUtil.getDisCache().set(GOODS_REDIS, JsonUtil.buildNonDefaultBinder().toJson((Object)list));
                    continue;
                }
                List collect = list.stream().filter(Objects::nonNull).filter(l -> l.getGoodsEocode() != null).filter(l -> resourceGoodsReDomain.getGoodsEocode().equals(l.getGoodsEocode())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    SupQueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainSupQueryResult = this.queryResourceGoodsPage(memberCode, ((RsResourceGoodsReDomain)collect.get(0)).getGoodsEocode());
                    List selectGoods = rsResourceGoodsReDomainSupQueryResult.getList();
                    if (!CollectionUtils.isEmpty((Collection)selectGoods)) {
                        for (RsResourceGoodsReDomain newResourceGoodsReDomain : selectGoods) {
                            RsResourceGoodsReDomain goodsData = this.getGoodsData(resourceGoodsReDomain, newResourceGoodsReDomain);
                            this.logger.info("\u4fee\u6539\u7684\u5546\u54c1\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goodsData));
                            this.updateGoods(goodsData);
                        }
                        continue;
                    }
                    this.sendSaveResourceGoods(resourceGoodsReDomain);
                    list.add(resourceGoodsReDomain);
                    SupDisUtil.getDisCache().set(GOODS_REDIS, JsonUtil.buildNonDefaultBinder().toJson((Object)list));
                    continue;
                }
                this.sendSaveResourceGoods(resourceGoodsReDomain);
                list.add(resourceGoodsReDomain);
                SupDisUtil.getDisCache().set(GOODS_REDIS, JsonUtil.buildNonDefaultBinder().toJson((Object)list));
            }
        }
        this.arr.clear();
    }

    private RsResourceGoodsReDomain getGoodsData(RsResourceGoodsReDomain resourceGoodsParam, RsResourceGoodsReDomain newGoods) {
        List<RsPropertiesValueDomain> rsPropertiesValueDomainList;
        List<RsSpecValueDomain> rsSpecValueDomainList;
        List<RsSkuDomain> rsSkuDomainList = resourceGoodsParam.getRsSkuDomainList();
        if (!CollectionUtils.isEmpty(rsSkuDomainList)) {
            newGoods.setRsSkuDomainList(rsSkuDomainList);
        }
        if (!CollectionUtils.isEmpty(rsSpecValueDomainList = resourceGoodsParam.getRsSpecValueDomainList())) {
            newGoods.setRsSpecValueDomainList(rsSpecValueDomainList);
        }
        if (!CollectionUtils.isEmpty(rsPropertiesValueDomainList = resourceGoodsParam.getRsPropertiesValueDomainList())) {
            newGoods.setRsPropertiesValueDomainList(rsPropertiesValueDomainList);
        }
        newGoods.setGoodsProperty3(resourceGoodsParam.getGoodsProperty3());
        newGoods.setGoodsProperty4(resourceGoodsParam.getGoodsProperty4());
        newGoods.setGoodsProperty5(resourceGoodsParam.getGoodsProperty5());
        newGoods.setGoodsProperty(resourceGoodsParam.getGoodsProperty());
        newGoods.setBrandCode(resourceGoodsParam.getBrandCode());
        newGoods.setBrandName(resourceGoodsParam.getBrandName());
        newGoods.setGoodsProperty1(resourceGoodsParam.getGoodsProperty1());
        newGoods.setGoodsProperty2(resourceGoodsParam.getGoodsProperty2());
        newGoods.setGoodsSpec(resourceGoodsParam.getGoodsSpec());
        newGoods.setGoodsName(resourceGoodsParam.getGoodsName());
        newGoods.setPartsnameWeightunit(resourceGoodsParam.getPartsnameWeightunit());
        newGoods.setPntreeCode(resourceGoodsParam.getPntreeCode());
        newGoods.setPntreeName(resourceGoodsParam.getPntreeName());
        newGoods.setPricesetMakeprice(resourceGoodsParam.getPricesetMakeprice());
        newGoods.setPricesetNprice(resourceGoodsParam.getPricesetNprice());
        newGoods.setClasstreeCode(resourceGoodsParam.getClasstreeCode());
        newGoods.setClasstreeName(resourceGoodsParam.getClasstreeName());
        return newGoods;
    }

    private void updateGoods(RsResourceGoodsReDomain newGoods) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)newGoods));
        Object o = this.getInternalRouter().inInvoke("rs.resource.sendUpdateResourceGoods", pmap);
        this.logger.info(JsonUtil.buildNonDefaultBinder().toJson(o));
    }

    private RsResourceGoodsReDomain getResourceGoodsParam(List<Mvgr1Entity> mvgr1, List<UnitEntity> unit, List<ColorEntity> colors, List<SizeEntity> sizeGroup, ImsEntity imsEntity, String memberCode, List<RsSpecGroupDomain> rsSpecGroupDomains, List<RsClasstreeReDomain> classtreeReDomains, List<PldzEntity> pldz) {
        List mvgr1Entities = mvgr1.stream().filter(m -> m.getMVGR1().equals(imsEntity.getSubBrand())).collect(Collectors.toList());
        List unitEntityList = unit.stream().filter(u -> u.getMSEHI().equals(imsEntity.getUnit())).collect(Collectors.toList());
        List colorEntitieList = colors.stream().filter(u -> u.getJ_3ACOL().equals(imsEntity.getColor())).collect(Collectors.toList());
        List sizeGroupList = sizeGroup.stream().filter(u -> u.getZPGNR().equals(imsEntity.getSizeGroup())).collect(Collectors.toList());
        List pldzList = pldz.stream().filter(u -> u.getMATCL().equals(imsEntity.getField32())).collect(Collectors.toList());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        rsResourceGoodsReDomain.setTenantCode("2022012800000001");
        rsResourceGoodsReDomain.setMemberCode(memberCode);
        rsResourceGoodsReDomain.setMemberCcode(memberCode);
        rsResourceGoodsReDomain.setGoodsType("00");
        rsResourceGoodsReDomain.setGoodsOrigin("0");
        rsResourceGoodsReDomain.setGoodsClass("B2C");
        rsResourceGoodsReDomain.setMemberMcode(memberCode);
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, "2022012800000001");
        rsResourceGoodsReDomain.setChannelCode(disChannelDomain.getChannelCode());
        rsResourceGoodsReDomain.setGoodsPro("0");
        rsResourceGoodsReDomain.setGoodsProperty1(CollectionUtils.isEmpty(pldzList) ? "" : ((PldzEntity)pldzList.get(0)).getLTEXT());
        rsResourceGoodsReDomain.setGoodsProperty2(CollectionUtils.isEmpty(pldzList) ? "" : ((PldzEntity)pldzList.get(0)).getMATCL());
        rsResourceGoodsReDomain.setGoodsSpec(imsEntity.getImgPath());
        rsResourceGoodsReDomain.setGoodsSpec1(imsEntity.getSkc());
        rsResourceGoodsReDomain.setGoodsName(imsEntity.getArticleName());
        rsResourceGoodsReDomain.setPartsnameWeightunit(CollectionUtils.isEmpty(unitEntityList) ? "" : ((UnitEntity)unitEntityList.get(0)).getMSEHT());
        rsResourceGoodsReDomain.setGoodsNo(imsEntity.getSpu());
        if (StringUtils.isNotBlank((String)imsEntity.getSizeGroup())) {
            rsResourceGoodsReDomain.setPntreeCode(goodsTypeContainer.get(imsEntity.getSizeGroup()));
            rsResourceGoodsReDomain.setPntreeName(imsEntity.getSizeGroup());
        }
        rsResourceGoodsReDomain.setPricesetNprice(new BigDecimal("0"));
        rsResourceGoodsReDomain.setPricesetMakeprice(StringUtils.isNotBlank((String)imsEntity.getListPrice()) ? new BigDecimal(imsEntity.getListPrice()) : new BigDecimal("0"));
        rsResourceGoodsReDomain.setPricesetNprice(StringUtils.isNotBlank((String)imsEntity.getListPrice()) ? new BigDecimal(imsEntity.getListPrice()) : new BigDecimal("0"));
        List collect = classtreeReDomains.stream().filter(classtree -> classTreeContainer.get(imsEntity.getField3()).equals(classtree.getClasstreeCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            RsClasstreeReDomain reDomain1 = (RsClasstreeReDomain)collect.get(0);
            List middleCollect = classtreeReDomains.stream().filter(classtree -> reDomain1.getClasstreeCode().equals(classtree.getClasstreeParentcode()) && classtree.getClasstreeEocode().equals(imsEntity.getField5())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(middleCollect)) {
                for (RsClasstreeReDomain reDomain : middleCollect) {
                    List minCollect = classtreeReDomains.stream().filter(classtree -> reDomain.getClasstreeCode().equals(classtree.getClasstreeParentcode())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(minCollect)) continue;
                    for (RsClasstreeReDomain classtree2 : minCollect) {
                        if (!classtree2.getClasstreeEocode().equals(imsEntity.getField4())) continue;
                        rsResourceGoodsReDomain.setClasstreeCode(classtree2.getClasstreeCode());
                        rsResourceGoodsReDomain.setClasstreeName(reDomain.getClasstreeName());
                    }
                }
            }
        }
        if (StringUtils.isBlank((String)rsResourceGoodsReDomain.getClasstreeCode())) {
            return null;
        }
        rsResourceGoodsReDomain.setGoodsProperty3(imsEntity.getVolume());
        rsResourceGoodsReDomain.setGoodsProperty4(imsEntity.getGrossWeight());
        rsResourceGoodsReDomain.setGoodsProperty5(imsEntity.getNetWeight());
        rsResourceGoodsReDomain.setDataOpbillstate(0);
        rsResourceGoodsReDomain.setGoodsProperty(imsEntity.getArticleName());
        rsResourceGoodsReDomain.setGoodsNum(new BigDecimal(0));
        rsResourceGoodsReDomain.setGoodsEocode(imsEntity.getSpu());
        rsResourceGoodsReDomain.setBrandCode(brandContainer.get(imsEntity.getSubBrand()));
        rsResourceGoodsReDomain.setBrandName(CollectionUtils.isEmpty(mvgr1Entities) ? "" : ((Mvgr1Entity)mvgr1Entities.get(0)).getBEZEI());
        List<RsSpecOptionDomain> rsSpecOptionDomains = null;
        List sizeGrop = rsSpecGroupDomains.stream().filter(rs -> imsEntity.getSizeGroup().equals(rs.getMemo()) && memberCode.equals(rs.getMemberCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(sizeGrop)) {
            rsSpecOptionDomains = this.querySpecOptionPage1(((RsSpecGroupDomain)sizeGrop.get(0)).getSpecGroupCode());
        }
        RsSpecValueDomain specColor = new RsSpecValueDomain();
        if (!CollectionUtils.isEmpty(sizeGroupList)) {
            List collect1;
            ArrayList<RsSkuDomain> skuList = new ArrayList<RsSkuDomain>();
            ArrayList<RsSpecValueDomain> specList = new ArrayList<RsSpecValueDomain>();
            for (SizeEntity sizeEntity : sizeGroupList) {
                List collect12;
                RsSkuDomain rsSkuDomain = new RsSkuDomain();
                rsSkuDomain.setSkuName(((ColorEntity)colorEntitieList.get(0)).getTEXT() + "/" + sizeEntity.getSIZET());
                rsSkuDomain.setSkuNo(imsEntity.getSkc() + sizeEntity.getJSIZE());
                rsSkuDomain.setPricesetNprice(new BigDecimal("0"));
                rsSkuDomain.setDataOpbillstate(0);
                rsSkuDomain.setGoodsNum(new BigDecimal("0"));
                rsSkuDomain.setSkuEocode(imsEntity.getSkc() + sizeEntity.getJSIZE());
                rsSkuDomain.setPricesetMakeprice(StringUtils.isNotBlank((String)imsEntity.getListPrice()) ? new BigDecimal(imsEntity.getListPrice()) : new BigDecimal("0"));
                rsSkuDomain.setPricesetNprice(StringUtils.isNotBlank((String)imsEntity.getListPrice()) ? new BigDecimal(imsEntity.getListPrice()) : new BigDecimal("0"));
                skuList.add(rsSkuDomain);
                if (CollectionUtils.isEmpty(rsSpecOptionDomains) || CollectionUtils.isEmpty(collect12 = rsSpecOptionDomains.stream().filter(rsSpecOption -> sizeEntity.getJSIZE().equals(rsSpecOption.getSpecOptionNum())).collect(Collectors.toList()))) continue;
                RsSpecOptionDomain specOptionDomain = (RsSpecOptionDomain)collect12.get(0);
                RsSpecValueDomain rsSpecValueDomain = new RsSpecValueDomain();
                rsSpecValueDomain.setSpecCode(specOptionDomain.getSpecCode());
                rsSpecValueDomain.setSpecGroupCode(specOptionDomain.getSpecGroupCode());
                rsSpecValueDomain.setSpecOptionNum(specOptionDomain.getSpecOptionNum());
                rsSpecValueDomain.setSpecValueType("0");
                rsSpecValueDomain.setSpecValueFlag("1");
                rsSpecValueDomain.setSpecValueValue(specOptionDomain.getSpecOptionName());
                specList.add(rsSpecValueDomain);
            }
            if (!CollectionUtils.isEmpty(rsSpecOptionDomains) && !CollectionUtils.isEmpty(collect1 = rsSpecOptionDomains.stream().filter(rsSpecOption -> ((ColorEntity)colorEntitieList.get(0)).getJ_3ACOL().equals(rsSpecOption.getSpecOptionNum())).collect(Collectors.toList()))) {
                RsSpecOptionDomain specOptionDomain = (RsSpecOptionDomain)collect1.get(0);
                specColor.setSpecCode(specOptionDomain.getSpecCode());
                specColor.setSpecGroupCode(specOptionDomain.getSpecGroupCode());
                specColor.setSpecValueType("0");
                specColor.setSpecValueFlag("1");
                specColor.setSpecOptionNum(specOptionDomain.getSpecOptionNum());
                specColor.setSpecValueValue(specOptionDomain.getSpecOptionName());
                specList.add(specColor);
            }
            rsResourceGoodsReDomain.setRsSkuDomainList(skuList);
            rsResourceGoodsReDomain.setRsSpecValueDomainList(specList);
            rsResourceGoodsReDomain.setRsPropertiesValueDomainList(this.addPropertiesValue(imsEntity, memberCode));
        }
        if (!CollectionUtils.isEmpty(this.arr)) {
            for (RsResourceGoodsReDomain newGoods : this.arr) {
                if (!newGoods.getGoodsEocode().equals(rsResourceGoodsReDomain.getGoodsEocode())) continue;
                List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
                if (!CollectionUtils.isEmpty(rsSkuDomainList)) {
                    List<RsSkuDomain> reSku = newGoods.getRsSkuDomainList();
                    reSku.addAll(rsSkuDomainList);
                }
                if (!Objects.isNull(specColor)) {
                    newGoods.getRsSpecValueDomainList().add(specColor);
                }
                return null;
            }
        }
        return rsResourceGoodsReDomain;
    }

    private List<RsPropertiesValueDomain> addPropertiesValue(ImsEntity imsEntity, String memberCode) {
        String code;
        String ptreeCode = goodsTypeContainer.get(imsEntity.getSizeGroup());
        List<RsPropertiesReDomain> rsPropertiesReDomains = this.queryPropertiesPage(ptreeCode);
        ArrayList<RsPropertiesValueDomain> list = new ArrayList<RsPropertiesValueDomain>();
        if (StringUtils.isNotBlank((String)imsEntity.getProductLine())) {
            List productList = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u4ea7\u54c1\u7ebf")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(productList)) {
                code = this.saveProperties(ptreeCode, "\u4ea7\u54c1\u7ebf", memberCode);
                this.addPropertiesValue(imsEntity.getProductLine(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getProductLine(), list, ((RsPropertiesReDomain)productList.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getYear())) {
            List yearList = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u5e74\u4efd")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(yearList)) {
                code = this.saveProperties(ptreeCode, "\u5e74\u4efd", memberCode);
                this.addPropertiesValue(imsEntity.getYear(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getYear(), list, ((RsPropertiesReDomain)yearList.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getProductSeason())) {
            List productSeason = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u4ea7\u54c1\u5b63")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(productSeason)) {
                code = this.saveProperties(ptreeCode, "\u4ea7\u54c1\u5b63", memberCode);
                this.addPropertiesValue(imsEntity.getProductSeason(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getProductSeason(), list, ((RsPropertiesReDomain)productSeason.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getWave())) {
            List wave = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u6ce2\u6bb5")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(wave)) {
                code = this.saveProperties(ptreeCode, "\u6ce2\u6bb5", memberCode);
                this.addPropertiesValue(imsEntity.getWave(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getWave(), list, ((RsPropertiesReDomain)wave.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getSerial())) {
            List serial = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u7cfb\u5217")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(serial)) {
                code = this.saveProperties(ptreeCode, "\u7cfb\u5217", memberCode);
                this.addPropertiesValue(imsEntity.getSerial(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getSerial(), list, ((RsPropertiesReDomain)serial.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getSerial())) {
            List style = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u98ce\u683c")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(style)) {
                code = this.saveProperties(ptreeCode, "\u98ce\u683c", memberCode);
                this.addPropertiesValue(imsEntity.getSerial(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getSerial(), list, ((RsPropertiesReDomain)style.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getTheme())) {
            List theme = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u4e3b\u9898")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(theme)) {
                code = this.saveProperties(ptreeCode, "\u4e3b\u9898", memberCode);
                this.addPropertiesValue(imsEntity.getTheme(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getTheme(), list, ((RsPropertiesReDomain)theme.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField11())) {
            List field11 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u662f\u5426\u6709\u9970\u54c1")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field11)) {
                code = this.saveProperties(ptreeCode, "\u662f\u5426\u6709\u9970\u54c1", memberCode);
                this.addPropertiesValue(imsEntity.getField11(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField11(), list, ((RsPropertiesReDomain)field11.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField12())) {
            List field12 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u53ef\u62c6\u5378\u914d\u4ef6\u6570\u91cf")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field12)) {
                code = this.saveProperties(ptreeCode, "\u53ef\u62c6\u5378\u914d\u4ef6\u6570\u91cf", memberCode);
                this.addPropertiesValue(imsEntity.getField12(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField12(), list, ((RsPropertiesReDomain)field12.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField14())) {
            List field14 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u662f\u5426\u8ffd\u5355\u6b3e")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field14)) {
                code = this.saveProperties(ptreeCode, "\u662f\u5426\u8ffd\u5355\u6b3e", memberCode);
                this.addPropertiesValue(imsEntity.getField14(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField14(), list, ((RsPropertiesReDomain)field14.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField19())) {
            List field19 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u4e3b\u6210\u5206\u6bd4")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field19)) {
                code = this.saveProperties(ptreeCode, "\u4e3b\u6210\u5206\u6bd4", memberCode);
                this.addPropertiesValue(imsEntity.getField19(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField19(), list, ((RsPropertiesReDomain)field19.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField20())) {
            List field20 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u514b\u91cd")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field20)) {
                code = this.saveProperties(ptreeCode, "\u514b\u91cd", memberCode);
                this.addPropertiesValue(imsEntity.getField20(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField20(), list, ((RsPropertiesReDomain)field20.get(0)).getPropertiesCode());
            }
        }
        if (StringUtils.isNotBlank((String)imsEntity.getField21())) {
            List field21 = rsPropertiesReDomains.stream().filter(rsPropertiesReDomain -> rsPropertiesReDomain.getPropertiesName().equals("\u59c6\u7c73\u6570")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(field21)) {
                code = this.saveProperties(ptreeCode, "\u59c6\u7c73\u6570", memberCode);
                this.addPropertiesValue(imsEntity.getField21(), list, code);
            } else {
                this.addPropertiesValue(imsEntity.getField21(), list, ((RsPropertiesReDomain)field21.get(0)).getPropertiesCode());
            }
        }
        return list;
    }

    private void addPropertiesValue(String value, List<RsPropertiesValueDomain> list, String code) {
        RsPropertiesValueDomain rsPropertiesValueDomain = new RsPropertiesValueDomain();
        rsPropertiesValueDomain.setPropertiesCode(code);
        rsPropertiesValueDomain.setPropertiesValueType("1");
        rsPropertiesValueDomain.setPropertiesValueValue(value);
        list.add(rsPropertiesValueDomain);
    }

    private Map<String, List<ImsEntity>> getGoodsMap(List<ImsEntity> imsList) {
        HashMap<String, List<ImsEntity>> goodsMap = new HashMap<String, List<ImsEntity>>();
        for (ImsEntity imsEntity : imsList) {
            String brand = imsEntity.getBrand();
            if (goodsMap.containsKey(brand)) {
                List imsEntities = (List)goodsMap.get(brand);
                imsEntities.add(imsEntity);
                continue;
            }
            ArrayList<ImsEntity> arr = new ArrayList<ImsEntity>();
            arr.add(imsEntity);
            goodsMap.put(brand, arr);
        }
        return goodsMap;
    }

    public Boolean sendSaveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsDomain));
        this.getInternalRouter().inInvoke("rs.resource.sendSaveResourceGoods", pmap);
        return Boolean.TRUE;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public void queryCompanyPage(String memberType) {
        OrgCompanyDomain orgCompanyDomain;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", BrandEnumThree.getByValue(memberType).getCode());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("org.company.queryCompanyPage", pmap, OrgCompanyDomain.class);
        if (null != rs) {
            orgCompanyDomain = rs.getList().stream().filter(ele -> ele.getCompanyCode() != null).findFirst().get();
            if (null == orgCompanyDomain) {
                throw new Exception("\u67e5\u8be2\u516c\u53f8\u53c2\u6570\u4e0d\u6b63\u786e");
            }
        } else {
            throw new Exception("\u672a\u83b7\u53d6\u5230\u516c\u53f8\u4fe1\u606f");
        }
        companyCode.put(memberType, orgCompanyDomain.getCompanyCode());
    }

    private Boolean areaDataSynchronous(List<AreaDomainEntity> loadScoreInfo) {
        Optional<OrgDepartReDomain> orgDepartDomain;
        List<OrgDepartDomain> orgDepartDomains = this.queryDepartPage("-1");
        for (AreaDomainEntity excelDataInfoEntity : loadScoreInfo) {
            Optional<OrgDepartDomain> orgDepartDomainIsPresent;
            if (null == companyCode && CollectionUtils.isEmpty(companyCode) || null == companyCode.get(excelDataInfoEntity.getDivision())) {
                this.queryCompanyPage(excelDataInfoEntity.getDivision());
            }
            if (!(orgDepartDomainIsPresent = orgDepartDomains.stream().filter(Objects::nonNull).filter(ele -> null != ele.getDepartOcode()).filter(ele -> ele.getDepartOcode().equals(excelDataInfoEntity.getRegionalSalesId())).findFirst()).isPresent()) {
                orgDepartDomain = new OrgDepartDomain();
                ((OrgDepartDomain)((Object)orgDepartDomain)).setDepartName(excelDataInfoEntity.getRegionalSalesName());
                ((OrgDepartDomain)((Object)orgDepartDomain)).setDepartOcode(excelDataInfoEntity.getRegionalSalesId());
                ((OrgDepartDomain)((Object)orgDepartDomain)).setCompanyCode(companyCode.get(excelDataInfoEntity.getDivision()));
                ((OrgDepartDomain)((Object)orgDepartDomain)).setDepartOrgin("0");
                ((OrgDepartDomain)((Object)orgDepartDomain)).setAppmanageIcode(BrandEnumOne.getByValue(excelDataInfoEntity.getDivision()).getCode());
                areaCode.put(((OrgDepartDomain)((Object)orgDepartDomain)).getDepartOcode(), this.saveDepart((OrgDepartDomain)((Object)orgDepartDomain)));
                continue;
            }
            orgDepartDomain = orgDepartDomainIsPresent.get();
            areaCode.put(((OrgDepartDomain)((Object)orgDepartDomain)).getDepartOcode(), ((OrgDepartDomain)((Object)orgDepartDomain)).getDepartCode());
        }
        loadScoreInfo = loadScoreInfo.stream().filter(ele -> ele.getStates() != null).filter(ele -> "\u65e0\u6548".equals(ele.getStates())).collect(Collectors.toList());
        List<OrgDepartReDomain> newOrgDepart = this.queryDepartPage1("-1");
        log.info("\u65e0\u6548\u533a\u57df\u6761\u6570::{}", (Object)loadScoreInfo.size());
        for (AreaDomainEntity areaDomainEntity : loadScoreInfo) {
            log.info("\u8fdb\u5165\u5faa\u73af");
            orgDepartDomain = newOrgDepart.stream().filter(ele -> ele.getDepartOcode() != null).filter(ele -> ele.getDepartOcode().equals(areaDomainEntity.getRegionalSalesId())).findFirst();
            if (!orgDepartDomain.isPresent()) continue;
            OrgDepartReDomain departDomain = (OrgDepartReDomain)orgDepartDomain.get();
            log.info("\u65e0\u6548\u4e14\u4fdd\u5b58\u6210\u529f\u7684\u533a\u57df\u4fe1\u606f\uff1a\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)departDomain));
            if (departDomain.getDataState() == -1) continue;
            this.updateDepartState(departDomain.getDepartId());
        }
        return Boolean.TRUE;
    }

    private List<OrgDepartDomain> queryDepartPage(String departPcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2022012800000001");
        map.put("fuzzy", false);
        map.put("page", 1);
        map.put("rows", 100000);
        if (null != departPcode) {
            map.put("departPcode", departPcode);
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("org.depart.queryDepartPage", pmap, OrgDepartDomain.class);
        if (null != rs) {
            return rs.getList();
        }
        return null;
    }

    private List<OrgDepartReDomain> queryDepartPage1(String departPcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2022012800000001");
        map.put("page", 1);
        map.put("rows", 100000);
        if (null != departPcode) {
            map.put("departPcode", departPcode);
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("org.depart.queryDepartPage", pmap, OrgDepartReDomain.class);
        if (null != rs) {
            return rs.getList();
        }
        return null;
    }

    private String saveDepart(OrgDepartDomain orgDepartDomain) {
        orgDepartDomain.setTenantCode("2022012800000001");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("orgDepartDomain", JsonUtil.buildNormalBinder().toJson((Object)orgDepartDomain));
        Object departCode = this.getInternalRouter().inInvoke("org.ChannelsendBase.sendSaveDepart", pmap);
        if (null == departCode) {
            throw new Exception("\u4fdd\u5b58\u533a\u57df\u4fe1\u606f\u5f02\u5e38");
        }
        return departCode.toString();
    }

    public void updateDepartState(Integer departId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("departId", departId);
        map.put("dataState", -1);
        map.put("oldDataState", 0);
        log.info("pmap\u4fee\u6539\u533a\u57df\u65e0\u6548\u4f20\u53c2\u4fe1\u606f::{}", map);
        this.getInternalRouter().inInvoke("org.ChannelsendBase.sendUpdateDepartState", map);
    }

    private Boolean storesDataSynchronous(List<StoreEntity> storeEntities) {
        if (CollectionUtils.isEmpty(storeEntities)) {
            throw new Exception("\u672a\u83b7\u53d6\u5230\u8981\u66f4\u65b0\u7684\u6570\u636e");
        }
        List orgDepartDomains = ((Stream)this.queryDepartPage(null).stream().parallel()).filter(ele -> ele.getDepartOcode() != null && ele.getDepartPcode() != null).filter(ele -> !"-1".equals(ele.getDepartPcode())).collect(Collectors.toList());
        List<CityEntity> list = ExcelReadUtil.loadScoreInfo(city, new CityEntity()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<OrgDepartDomain> saveOrgDepartDomain = new ArrayList<OrgDepartDomain>();
        for (StoreEntity storeEntity : storeEntities) {
            String departPcode = areaCode.get(storeEntity.getSLAID());
            if (null == departPcode) {
                log.info("\u6ca1\u6709\u533a\u57df\u7684\u95e8\u5e97\u6570\u636e::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)storeEntity));
                continue;
            }
            if (!CollectionUtils.isEmpty(orgDepartDomains)) {
                log.info("\u5916\u90e8\u7cfb\u7edf\u7f16\u7801\u4e3a::{}", (Object)storeEntity.getZCODE());
                Optional<OrgDepartDomain> orgDeparIsPresent = ((Stream)orgDepartDomains.stream().parallel()).filter(ele -> ele.getDepartOcode() != null && ele.getDepartName() != null).filter(ele -> ele.getDepartOcode().equals(storeEntity.getZCODE()) && ele.getDepartName().equals(storeEntity.getZNAME())).findAny();
                if (orgDeparIsPresent.isPresent()) {
                    log.info("\u8fdb\u5165\u91cd\u590d\u6570\u636e\u4e3a::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)orgDeparIsPresent.get()));
                }
                if (orgDeparIsPresent.isPresent()) continue;
                log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u6570\u636e\u4e3a::{}", (Object)JsonUtil.buildNormalBinder().toJson(orgDeparIsPresent));
                OrgDepartDomain orgDepartDomain = this.structureCompany(storeEntity, list, departPcode);
                log.info("\u6784\u9020\u5b8c\u6210\u7684\u95e8\u5e97\u4fe1\u606f::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orgDepartDomain));
                saveOrgDepartDomain.add(orgDepartDomain);
                continue;
            }
            log.info("\u95e8\u5e97\u4e3a\u7a7a");
            OrgDepartDomain orgDepartDomain = this.structureCompany(storeEntity, list, departPcode);
            log.info("orgDepartDomain::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)orgDepartDomain));
            saveOrgDepartDomain.add(orgDepartDomain);
        }
        log.info("\u4fdd\u5b58\u7684\u6761\u6570::{}", (Object)saveOrgDepartDomain.size());
        if (!CollectionUtils.isEmpty(saveOrgDepartDomain)) {
            this.saveDepartBatch(saveOrgDepartDomain);
        }
        return Boolean.TRUE;
    }

    public void updateUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        log.info("\u4fee\u6539\u95e8\u5e97\u4f20\u53c2\uff1a\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        this.getInternalRouter().inInvoke("um.user.sendUpdateUserinfo", pmap);
    }

    private List<OrgDepartDomain> queryDepartPage() {
        ArrayList<OrgDepartDomain> list = new ArrayList<OrgDepartDomain>();
        List<UmUserinfoReDomainBean> umUserinfoReDomainBeanQueryResult = this.queryUserinfoPage("depart");
        List<OrgDepartDomain> orgDepartDomains = this.queryDepartPage(null);
        if (null != umUserinfoReDomainBeanQueryResult) {
            List umUserinfoReDomainBeans = umUserinfoReDomainBeanQueryResult.stream().filter(ele -> ele.getDepartCode() != null).collect(Collectors.toList());
            for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoReDomainBeans) {
                Optional<OrgDepartDomain> orgDepartDomain = orgDepartDomains.stream().filter(ele -> ele.getDepartPcode() != null).filter(ele -> ele.getDepartCode().equals(umUserinfoReDomainBean.getDepartCode())).findFirst();
                if (!orgDepartDomain.isPresent()) continue;
                OrgDepartDomain orgDepartDomain1 = orgDepartDomain.get();
                orgDepartDomain1.setUserinfoCode(umUserinfoReDomainBean.getUserinfoCode());
                orgDepartDomain1.setUserinfoId(umUserinfoReDomainBean.getUserinfoId());
                orgDepartDomain1.setUserinfoDataStatu(umUserinfoReDomainBean.getDataState());
                list.add(orgDepartDomain1);
            }
        }
        return list;
    }

    public UmUserinfoReDomainBean getUserInfoByUserinfoCode(String userinfoCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson((Object)ImmutableMap.of((Object)"userinfoCode", (Object)userinfoCode, (Object)"tenantCode", (Object)"2022012800000001")));
        log.info("\u6839\u636euserinfo\u67e5\u8be2\u4fe1\u606f::{}", pmap);
        QueryResult umUserinfoReDomainBeanQueryResult = this.getQueryResutl("um.user.getUserinfoByUserCode", pmap, UmUserinfoReDomainBean.class);
        if (umUserinfoReDomainBeanQueryResult == null) {
            throw new Exception(String.format("\u672a\u83b7\u53d6\u5230\u95e8\u5e97\u4fe1\u606fuserinfoCode:%s", userinfoCode));
        }
        log.info("\u6839\u636euserinfo\u67e5\u8be2\u7684\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoReDomainBeanQueryResult.getList()));
        return umUserinfoReDomainBeanQueryResult.getList().stream().findFirst().orElse(null);
    }

    public OrgDepartDomain structureCompany(StoreEntity storeEntity, List<CityEntity> list, String departPcode) {
        log.info("storeEntity::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)storeEntity));
        OrgDepartDomain orgDepartDomain = new OrgDepartDomain();
        orgDepartDomain.setDepartPcode(departPcode);
        orgDepartDomain.setDepartName(storeEntity.getZNAME());
        log.info("companyCode.get(storeEntity.getBunit())::{}", (Object)companyCode.get(storeEntity.getBUNIT()));
        if (null != storeEntity.getBUNIT()) {
            orgDepartDomain.setCompanyCode(companyCode.get(storeEntity.getBUNIT()));
        }
        if (null != storeEntity.getZPROV()) {
            list.stream().filter(ele -> ele.getProvinceId().equals(storeEntity.getZPROV())).findFirst().ifPresent(cityEntity -> orgDepartDomain.setProvinceName(cityEntity.getProvinceName()));
        }
        if (null != storeEntity.getZCITY()) {
            list.stream().filter(ele -> ele.getCityId().equals(storeEntity.getZCITY())).findFirst().ifPresent(ele -> orgDepartDomain.setCityName(ele.getCityName()));
        }
        if (null != storeEntity.getZREGN()) {
            areaList.stream().filter(ele -> ele.getRegionId().equals(storeEntity.getZREGN())).findFirst().ifPresent(ele -> orgDepartDomain.setAreaName(ele.getRegionName()));
        }
        orgDepartDomain.setDepartAddress(storeEntity.getGr_address());
        orgDepartDomain.setDepartOrgin("1");
        orgDepartDomain.setDepartOcode(storeEntity.getZCODE());
        orgDepartDomain.setTenantCode("2022012800000001");
        if (null != storeEntity.getLongitude() && null != storeEntity.getLatitude()) {
            orgDepartDomain.setStoreMapLocation(storeEntity.getLongitude() + "," + storeEntity.getLatitude());
        }
        orgDepartDomain.setUserinfoSort(JsonUtil.buildNonDefaultBinder().toJson((Object)orgDepartDomain));
        log.info("\u6784\u9020\u7684\u95e8\u5e97\u4fe1\u606f::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orgDepartDomain));
        return orgDepartDomain;
    }

    public Boolean saveDepartBatch(List<OrgDepartDomain> orgDepartDomainList) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("orgDepartDomainList", JsonUtil.buildNormalBinder().toJson(orgDepartDomainList));
        Object inInvoke = this.getInternalRouter().inInvoke("org.ChannelsendBase.sendSaveDepartBatch", pmap);
        log.info("\u95e8\u5e97\u8fd4\u56de\u6570\u636e\uff1a\uff1a{}", inInvoke);
        return Boolean.TRUE;
    }

    public Boolean salesmanDataSynchronous(List<SalesmanEntity> salesmanEntities) {
        if (CollectionUtils.isEmpty(salesmanEntities)) {
            throw new Exception("\u672a\u83b7\u53d6\u5230\u5bfc\u8d2d\u6570\u636e");
        }
        int i = 1;
        List<DisChannelDomain> disChannelDomains = this.queryChannelPage("2022012800000001");
        this.userinfoList = this.queryUserinfoPage("buy");
        log.info("userinfoList\u67e5\u8be2\u51fa\u7684\u7528\u6237\u4fe1\u606f::{}", (Object)this.userinfoList.size());
        this.userinfoChannelList = this.queryUserinfoChannelList();
        this.userinfoQuaList = this.queryUserinfoQuaRe();
        for (SalesmanEntity salesmanEntity : salesmanEntities) {
            DisChannelDomain disChannelDomain = ((Stream)disChannelDomains.stream().parallel()).filter(ele -> ele.getMemberCode().equals(BrandEnumFour.getByValue(salesmanEntity.getZZHR_SUPPT()).getCode())).findAny().orElse(null);
            if (null == disChannelDomain) {
                throw new Exception("\u672a\u83b7\u53d6\u5230\u7528\u6237\u6e20\u9053");
            }
            if (CollectionUtils.isEmpty(this.userinfoList)) {
                log.info("\u4e3a\u7a7a\u76f4\u63a5\u6dfb\u52a0");
                this.shoppersSave(salesmanEntity, disChannelDomain);
            } else {
                log.info("\u4e0d\u4e3a\u7a7a\u8fc7\u6ee4\u91cd\u590d");
                log.info("\u624b\u673a\u53f7\u6570\u636e::{}", (Object)JsonUtil.buildNormalBinder().toJson(this.userinfoList.stream().map(UmUserinfoDomainBean::getUserinfoPhone).collect(Collectors.toList())));
                Optional<UmUserinfoReDomainBean> userInfoPresent = ((Stream)this.userinfoList.stream().parallel()).filter(ele -> ele.getUserinfoPhone() != null).filter(ele -> ele.getUserinfoPhone().equals(salesmanEntity.getMobile())).findAny();
                if (!userInfoPresent.isPresent()) {
                    log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u624b\u673a\u53f7");
                    this.shoppersSave(salesmanEntity, disChannelDomain);
                } else {
                    log.info("\u5b58\u5728\u76f8\u540c\u624b\u673a\u53f7\uff1a\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)userInfoPresent.get()));
                    UmUserinfoReDomainBean umUserinfoReDomainBean = userInfoPresent.get();
                    Optional<UmUserinfoChannel> userinfoChannelPresent = ((Stream)this.userinfoChannelList.stream().parallel()).filter(ele -> ele.getUserinfoChannelVaule() != null).filter(ele -> ele.getUserinfoCode().equals(umUserinfoReDomainBean.getUserinfoCode()) && ele.getUserinfoChannelVaule().equals(salesmanEntity.getUserid())).findAny();
                    if (!userinfoChannelPresent.isPresent()) {
                        List<UmUserinfoQuaDomain> umUserinfoQuaDomains;
                        log.info("\u4e0d\u5b58\u5728\u5bfc\u8d2d\u5de5\u53f7");
                        UmUserinfoChannelDomain umUserinfoChannelDomain = this.structureUserChannel(salesmanEntity, umUserinfoReDomainBean.getUserinfoCode(), disChannelDomain);
                        if (null == umUserinfoChannelDomain) {
                            throw new Exception("\u6784\u9020\u7528\u6237\u6e20\u9053\u4fe1\u606f\u5f02\u5e38");
                        }
                        log.info("\u6784\u9020\u5b8c\u6210\u7684\u7528\u6237\u6e20\u9053\u4fe1\u606f:::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannelDomain));
                        String userinfoChannelCode = this.saveUserinfoChannel(umUserinfoChannelDomain);
                        log.info("\u7528\u6237\u6e20\u9053code::{}", (Object)userinfoChannelCode);
                        if (null == userinfoChannelCode) {
                            throw new Exception("\u4fdd\u5b58\u7528\u6237\u6e20\u9053\u4fe1\u606f\u5931\u8d25");
                        }
                        umUserinfoChannelDomain.setUserinfoChannelCode(userinfoChannelCode);
                        this.entityAssignment(this.userinfoChannelList, umUserinfoChannelDomain);
                        if ("\u79bb\u804c".equals(salesmanEntity.getStat2())) {
                            this.updateUserinfoChannelStateByCode(userinfoChannelCode);
                        }
                        if (null == (umUserinfoQuaDomains = this.structureUserInfoQua(salesmanEntity, userinfoChannelCode))) {
                            throw new Exception("\u6784\u9020\u6269\u5c55\u4fe1\u606f\u5f02\u5e38");
                        }
                        String userinfoQuaCode = this.saveUserinfoQuaBatch(umUserinfoQuaDomains);
                        if (null == userinfoQuaCode) {
                            throw new Exception("\u4fdd\u5b58\u7528\u6237\u6269\u5c55\u4fe1\u606f\u5f02\u5e38");
                        }
                        this.userinfoQuaList.addAll(umUserinfoQuaDomains);
                        ShShsettlUserDomain shShsettlUserDomain = this.structureUserShsettl(salesmanEntity, umUserinfoReDomainBean.getUserinfoCode());
                        if (null == shShsettlUserDomain) {
                            throw new Exception("\u6784\u9020\u5206\u9500\u4fe1\u606f\u5f02\u5e38");
                        }
                        String shsettlUserCode = this.saveShsettlUser(shShsettlUserDomain);
                        if (null == shsettlUserCode) {
                            throw new Exception("\u4fdd\u5b58\u5206\u9500\u4fe1\u606f\u5f02\u5e38");
                        }
                    } else {
                        log.info("\u5b58\u5728\u5bfc\u8d2d\u5de5\u53f7::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)userinfoChannelPresent.get()));
                        UmUserinfoChannel umUserinfoChannel = userinfoChannelPresent.get();
                        Integer dataStatu = salesmanEntity.getStat2().equals("\u5728\u804c") ? 0 : -1;
                        log.info("dataStatu::{}", (Object)dataStatu);
                        if (!umUserinfoChannel.getDataState().equals(dataStatu)) {
                            log.info("\u5728\u804c\u72b6\u6001\u6539\u53d8");
                            this.updateUserinfoChannelStateByCode(umUserinfoChannel.getUserinfoChannelCode());
                        }
                        List userinfoQuas = ((Stream)this.userinfoQuaList.stream().parallel()).filter(ele -> ele.getUserinfoCode().equals(umUserinfoChannel.getUserinfoChannelCode())).collect(Collectors.toList());
                        UmUserinfoQuaDomain umUserinfoQuaDomain1 = new UmUserinfoQuaDomain();
                        umUserinfoQuaDomain1 = ((Stream)userinfoQuas.stream().parallel()).filter(ele -> ele.getUserinfoQuaKey() != null).filter(ele -> "emplyee".equals(ele.getUserinfoQuaKey())).findAny().orElse(umUserinfoQuaDomain1);
                        log.info("umUserinfoQuaDomain1::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoQuaDomain1));
                        boolean temp = false;
                        if (null != umUserinfoQuaDomain1) {
                            log.info("qua\u6570\u636e\u4e0d\u4e3a\u7a7a");
                            if (null == umUserinfoQuaDomain1.getUserinfoQuaCode()) {
                                log.info("\u65b0\u6dfb\u52a0qua\u6570\u636e\u4e0d\u5b58\u5728quacode");
                                this.userinfoQuaList = this.queryUserinfoQuaRe();
                                userinfoQuas = ((Stream)this.userinfoQuaList.stream().parallel()).filter(ele -> ele.getUserinfoCode().equals(umUserinfoChannel.getUserinfoChannelCode())).collect(Collectors.toList());
                                umUserinfoQuaDomain1 = ((Stream)userinfoQuas.stream().parallel()).filter(ele -> ele.getUserinfoQuaKey() != null).filter(ele -> "emplyee".equals(ele.getUserinfoQuaKey())).findAny().orElse(umUserinfoQuaDomain1);
                            }
                            if (!salesmanEntity.getZZHR_SUPPT().equals(umUserinfoQuaDomain1.getUserinfoQuaUrl())) {
                                log.info("\u54c1\u724c\u4e0d\u4e00\u81f4");
                                umUserinfoQuaDomain1.setUserinfoQuaUrl(salesmanEntity.getZZHR_SUPP());
                                temp = true;
                            }
                            if (!salesmanEntity.getZZHR_PSBH().equals(umUserinfoQuaDomain1.getUserinfoQuaUrl1())) {
                                log.info("\u5e97\u94fa\u53f7\u4e0d\u4e00\u81f4");
                                umUserinfoQuaDomain1.setUserinfoQuaUrl1(salesmanEntity.getZZHR_PSBH());
                                temp = true;
                            }
                            if (!salesmanEntity.getStext().equals(umUserinfoQuaDomain1.getUserinfoQuaVaule2())) {
                                log.info("\u5c97\u4f4d\u540d\u79f0\u4e0d\u4e00\u81f4");
                                umUserinfoQuaDomain1.setUserinfoQuaVaule2(salesmanEntity.getStext());
                                temp = true;
                            }
                        }
                        if (temp) {
                            log.info("\u5b58\u5728qua\u4fee\u6539\u6570\u636e");
                            this.updateUserinfoQua(umUserinfoQuaDomain1);
                        }
                    }
                }
            }
            log.info("\u4fdd\u5b58\u5bfc\u8d2d\u6210\u529f::[" + ++i + "]\u6b21");
            log.info("userinfoList::{}", (Object)this.userinfoList.size());
        }
        return Boolean.TRUE;
    }

    public void shoppersSave(SalesmanEntity salesmanEntity, DisChannelDomain disChannelDomain) {
        List<UmUserinfoQuaDomain> umUserinfoQuaDomains;
        UmUserDomainBean umUserDomainBean = this.structureUserData(salesmanEntity, disChannelDomain);
        log.info("\u7a7a::\u6784\u9020\u5b8c\u6210\u7684\u6570\u636e\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
        String userinfoCode = this.saveUser(umUserDomainBean);
        log.info("userinfoCode::{}", (Object)userinfoCode);
        if (userinfoCode == null) {
            throw new Exception("\u4fdd\u5b58\u7528\u6237\u57fa\u7840\u4fe1\u606f\u5931\u8d25");
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = new UmUserinfoReDomainBean();
        umUserinfoReDomainBean.setUserinfoCode(userinfoCode);
        umUserinfoReDomainBean.setUserinfoPhone(umUserDomainBean.getUserPhone());
        this.userinfoList.add(umUserinfoReDomainBean);
        UmUserinfoChannelDomain umUserinfoChannelDomain = this.structureUserChannel(salesmanEntity, userinfoCode, disChannelDomain);
        if (null == umUserinfoChannelDomain) {
            throw new Exception("\u6784\u9020\u7528\u6237\u6e20\u9053\u4fe1\u606f\u5f02\u5e38");
        }
        log.info("\u6784\u9020\u5b8c\u6210\u7684\u7528\u6237\u6e20\u9053\u4fe1\u606f:::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannelDomain));
        String userinfoChannelCode = this.saveUserinfoChannel(umUserinfoChannelDomain);
        log.info("\u7528\u6237\u6e20\u9053code::{}", (Object)userinfoChannelCode);
        if (null == userinfoChannelCode) {
            throw new Exception("\u4fdd\u5b58\u7528\u6237\u6e20\u9053\u4fe1\u606f\u5931\u8d25");
        }
        umUserinfoChannelDomain.setUserinfoChannelCode(userinfoChannelCode);
        this.entityAssignment(this.userinfoChannelList, umUserinfoChannelDomain);
        if ("\u79bb\u804c".equals(salesmanEntity.getStat2())) {
            this.updateUserinfoChannelStateByCode(userinfoChannelCode);
        }
        if (null == (umUserinfoQuaDomains = this.structureUserInfoQua(salesmanEntity, userinfoChannelCode))) {
            throw new Exception("\u6784\u9020\u6269\u5c55\u4fe1\u606f\u5f02\u5e38");
        }
        String userinfoQuaCode = this.saveUserinfoQuaBatch(umUserinfoQuaDomains);
        if (null == userinfoQuaCode) {
            throw new Exception("\u4fdd\u5b58\u7528\u6237\u6269\u5c55\u4fe1\u606f\u5f02\u5e38");
        }
        this.userinfoQuaList.addAll(umUserinfoQuaDomains);
        ShShsettlUserDomain shShsettlUserDomain = this.structureUserShsettl(salesmanEntity, userinfoCode);
        if (null == shShsettlUserDomain) {
            throw new Exception("\u6784\u9020\u5206\u9500\u4fe1\u606f\u5f02\u5e38");
        }
        String shsettlUserCode = this.saveShsettlUser(shShsettlUserDomain);
        if (null == shsettlUserCode) {
            throw new Exception("\u4fdd\u5b58\u5206\u9500\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public List<UmUserinfoReDomainBean> queryUserinfoPage(String userinfoQuality) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2022012800000001");
        map.put("page", 1);
        map.put("rows", 100000);
        map.put("childFlag", false);
        map.put("userinfoQuality", userinfoQuality);
        map.put("fuzzy", true);
        Integer rows = Integer.valueOf(String.valueOf(map.get("rows")));
        Integer page = Integer.valueOf(String.valueOf(map.get("page")));
        map.put("startRow", 0);
        map.put("endRow", Long.valueOf(Long.valueOf(rows.intValue()).intValue() * Long.valueOf(page.intValue()).intValue()).intValue());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult umUserinfoReDomainBeanQueryResult = this.getQueryResutl("um.user.queryUserinfoPage", pmap, UmUserinfoReDomainBean.class);
        return umUserinfoReDomainBeanQueryResult.getList() == null ? new ArrayList() : umUserinfoReDomainBeanQueryResult.getList();
    }

    public List<UmUserinfoChannel> queryUserinfoChannelList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fuzzy", false);
        map.put("tenantCode", "2022012800000001");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult channelRs = this.getQueryResutl("um.umUserinfoChannel.queryUserinfoChannelPage", pmap, UmUserinfoChannel.class);
        if (null == channelRs) {
            throw new Exception("\u4e3a\u83b7\u53d6\u5230\u7528\u6237\u6e20\u9053");
        }
        log.info("\u7528\u6237\u6e20\u9053\u4fe1\u606f::{}", (Object)channelRs.getList().size());
        return channelRs.getList();
    }

    List<UmUserinfoQuaDomain> queryUserinfoQuaRe() {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson((Object)ImmutableMap.of((Object)"tenantCode", (Object)"2022012800000001", (Object)"fuzzy", (Object)false)));
        QueryResult quaRs = this.getQueryResutl("um.userinfoQua.queryUserinfoQuaPage", pmap, UmUserinfoQuaDomain.class);
        if (null == quaRs) {
            throw new Exception("\u7528\u6237\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a");
        }
        log.info("quaRs::{}", (Object)quaRs.getList().size());
        return quaRs.getList();
    }

    public UmUserDomainBean structureUserData(SalesmanEntity salesmanEntity, DisChannelDomain disChannelDomain) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setUserRelname(salesmanEntity.getName());
        umUserDomainBean.setUserName(salesmanEntity.getName());
        umUserDomainBean.setUserNickname(salesmanEntity.getName());
        umUserDomainBean.setUserPhone(salesmanEntity.getMobile());
        umUserDomainBean.setUserSex(salesmanEntity.getGender());
        umUserDomainBean.setUserEmial(salesmanEntity.getEmail());
        umUserDomainBean.setUserinfoQuality("buy");
        umUserDomainBean.setUserinfoChannelcode(disChannelDomain.getChannelCode());
        umUserDomainBean.setUserinfoChannelname(disChannelDomain.getChannelName());
        umUserDomainBean.setTenantCode("2022012800000001");
        umUserDomainBean.setCompanyAddress(salesmanEntity.getAddress());
        umUserDomainBean.setUserBirthday(salesmanEntity.getGbDat());
        return umUserDomainBean;
    }

    public List<UmUserinfoQuaDomain> structureUserInfoQua(SalesmanEntity salesmanEntity, String userinfoChannelCode) {
        String appIcode = BrandEnumTwo.getByValue(salesmanEntity.getZZHR_SUPPT()).getCode();
        UmUserinfoQuaDomain umUserinfoQuaDomain1 = new UmUserinfoQuaDomain();
        umUserinfoQuaDomain1.setTenantCode("2022012800000001");
        umUserinfoQuaDomain1.setUserinfoCode(userinfoChannelCode);
        umUserinfoQuaDomain1.setUserinfoQuaKey("emplyee");
        umUserinfoQuaDomain1.setUserinfoQuaVaule(salesmanEntity.getJoin_time());
        umUserinfoQuaDomain1.setUserinfoQuaVaule1(salesmanEntity.getStat2());
        umUserinfoQuaDomain1.setUserinfoQuaVaule2(salesmanEntity.getStext());
        umUserinfoQuaDomain1.setUserinfoQuaUrl(salesmanEntity.getZZHR_SUPPT());
        umUserinfoQuaDomain1.setUserinfoQuaUrl1(salesmanEntity.getZZHR_PSBH());
        umUserinfoQuaDomain1.setAppmanageIcode(appIcode);
        UmUserinfoQuaDomain umUserinfoQuaDomain2 = new UmUserinfoQuaDomain();
        umUserinfoQuaDomain2.setUserinfoQuaKey("basic");
        int i = LocalDate.now().getYear() - LocalDate.parse(salesmanEntity.getGbDat()).getYear();
        umUserinfoQuaDomain2.setUserinfoQuaVaule(String.valueOf(i));
        umUserinfoQuaDomain2.setUserinfoQuaUrl2(salesmanEntity.getStext());
        umUserinfoQuaDomain2.setUserinfoCode(userinfoChannelCode);
        umUserinfoQuaDomain2.setTenantCode("2022012800000001");
        return Arrays.asList(umUserinfoQuaDomain1, umUserinfoQuaDomain2);
    }

    public UmUserinfoChannelDomain structureUserChannel(SalesmanEntity salesmanEntity, String userinfoCode, DisChannelDomain disChannelDomain) {
        String appIcode = BrandEnumTwo.getByValue(salesmanEntity.getZZHR_SUPPT()).getCode();
        UmUserinfoChannelDomain umUserinfoChannelDomain = new UmUserinfoChannelDomain();
        umUserinfoChannelDomain.setChannelCode(disChannelDomain.getChannelCode());
        umUserinfoChannelDomain.setChannelName(disChannelDomain.getChannelName());
        umUserinfoChannelDomain.setUserinfoCode(userinfoCode);
        umUserinfoChannelDomain.setUserinfoCompname(salesmanEntity.getName());
        umUserinfoChannelDomain.setQualityCode("dis");
        umUserinfoChannelDomain.setUserinfoChannelVaule(salesmanEntity.getUserid());
        umUserinfoChannelDomain.setTenantCode("2022012800000001");
        umUserinfoChannelDomain.setAppmanageIcode(appIcode);
        return umUserinfoChannelDomain;
    }

    public ShShsettlUserDomain structureUserShsettl(SalesmanEntity salesmanEntity, String userinfoCode) {
        ShShsettlUserDomain shShsettlUserDomain = new ShShsettlUserDomain();
        shShsettlUserDomain.setTenantCode("2022012800000001");
        shShsettlUserDomain.setMemberCode(BrandEnumFour.getByValue(salesmanEntity.getZZHR_SUPPT()).getCode());
        shShsettlUserDomain.setShsettlType("2");
        shShsettlUserDomain.setShsettlCode("1425fa81b2de44a491ec2d2769657186");
        shShsettlUserDomain.setMemberBcode(userinfoCode);
        String appIcode = BrandEnumTwo.getByValue(salesmanEntity.getZZHR_SUPPT()).getCode();
        shShsettlUserDomain.setAppmanageIcode(appIcode);
        shShsettlUserDomain.setShsettlUserInvite(salesmanEntity.getUserid());
        return shShsettlUserDomain;
    }

    public String saveUser(UmUserDomainBean umUserDomainBean) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
        log.info("\u4fdd\u5b58\u5bfc\u8d2d\u5458\u4f1a\u5458\u4fe1\u606f\uff1a\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
        Object inInvoke = this.getInternalRouter().inInvoke("um.user.sendOpenUserinfo", pmap);
        log.info("\u4fdd\u5b58\u7684\u5bfc\u8d2d\u4f1a\u5458\u4fe1\u606f::{}", inInvoke);
        if (inInvoke == null) {
            throw new Exception("\u4fdd\u5b58user\u6570\u636e\u5931\u8d25");
        }
        return inInvoke.toString();
    }

    public String saveUserinfoChannel(UmUserinfoChannelDomain umUserinfoChannelDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("umUserinfoChannelDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannelDomain));
        log.info("\u4fdd\u5b58\u7528\u6237\u6e20\u9053\u4fe1\u606f::{}", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
        return this.getInternalRouter().inInvoke("um.umUserinfoChannel.saveUserinfoChannel", pmap).toString();
    }

    public void updateUserinfoChannelStateByCode(String userinfoChannelCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2022012800000001");
        map.put("userinfoChannelCode", userinfoChannelCode);
        map.put("dataState", -1);
        map.put("oldDataState", 0);
        log.info("pmap\u4fee\u6539\u6e20\u9053\u72b6\u6001\u4f20\u53c2::{}", map);
        this.getInternalRouter().inInvoke("um.umUserinfoChannel.updateUserinfoChannelState", map);
    }

    public String saveUserinfoQuaBatch(List<UmUserinfoQuaDomain> umUserinfoQuaDomainList) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("umUserinfoQuaDomainList", JsonUtil.buildNormalBinder().toJson(umUserinfoQuaDomainList));
        log.info("\u4fdd\u5b58\u7528\u6237\u6269\u5c55\u4fe1\u606f\u6570\u636e::{}", pmap);
        Object saveUserinfoQuaBatch = this.getInternalRouter().inInvoke("um.userinfoQua.saveUserinfoQuaBatch", pmap);
        return saveUserinfoQuaBatch == null ? null : saveUserinfoQuaBatch.toString();
    }

    public void updateUserinfoQua(UmUserinfoQuaDomain umUserinfoQuaDomain) {
        log.info("\u8981\u4fee\u6539\u7684pua\u6570\u636e\u4e3a:{::}", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoQuaDomain));
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("umUserinfoQuaDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoQuaDomain));
        this.getInternalRouter().inInvoke("um.userinfoQua.updateUserinfoQua", pmap);
    }

    public String saveShsettlUser(ShShsettlUserDomain shShsettlUserDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("shShsettlUserDomain", JsonUtil.buildNormalBinder().toJson((Object)shShsettlUserDomain));
        log.info("\u4fdd\u5b58\u5206\u9500\u4fe1\u606f::{}", pmap);
        Object inInvoke = this.getInternalRouter().inInvoke("sh.shsettlUser.saveShsettlUser", pmap);
        log.info("\u5206\u9500\u4fdd\u5b58\u8fd4\u56de\u4fe1\u606f2::{}", (Object)inInvoke.toString());
        return inInvoke == null ? null : inInvoke.toString();
    }

    public List<UmUserDomainBean> queryUserPage() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", 1);
        map.put("fuzzy", true);
        map.put("rows", 100000);
        map.put("tenantCode", "2022012800000001");
        map.put("userinfoQuality", "cuser");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("um.user.queryUserPage", pmap, UmUserDomainBean.class);
        return rs.getList().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void updateUserinfoState(Integer userinfoId) {
        HashMap<String, Integer> pmap = new HashMap<String, Integer>();
        pmap.put("userinfoId", userinfoId);
        pmap.put("dataState", -1);
        pmap.put("oldDataState", 0);
        log.info("\u505c\u7528\u95e8\u5e97\u4f20\u53c2\uff1a\uff1a{}", pmap);
        this.getInternalRouter().inInvoke("um.user.sendUpdateUserinfoState", pmap);
    }

    public void updateUserinfoState1(Integer userinfoId) {
        HashMap<String, Integer> pmap = new HashMap<String, Integer>();
        pmap.put("userinfoId", userinfoId);
        pmap.put("dataState", 0);
        pmap.put("oldDataState", -1);
        log.info("\u542f\u7528\u95e8\u5e97\u4f20\u53c2\uff1a\uff1a{}", pmap);
        this.getInternalRouter().inInvoke("um.user.sendUpdateUserinfoState", pmap);
    }

    public SupQueryResult<UmUserinfoReDomainBean> queryUserinfoPage() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2022012800000001");
        map.put("userinfoCertNoLike", "8");
        map.put("childFlag", false);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("um.user.queryUserinfoPage", pmap, UmUserinfoReDomainBean.class);
    }

    public SupQueryResult<UmUserinfoReDomainBean> queryUserinfoPage(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("um.user.queryUserinfoPage", pmap, UmUserinfoReDomainBean.class);
    }

    public void entityAssignment(List<UmUserinfoReDomainBean> list, UmUserDomainBean umUserDomainBean) {
        UmUserinfoReDomainBean umUserinfoReDomainBean = new UmUserinfoReDomainBean();
        umUserinfoReDomainBean.setUserinfoCode(umUserDomainBean.getUserinfoCode());
        umUserDomainBean.setUserinfoPhone(umUserDomainBean.getUserPhone());
        umUserDomainBean.setUserName(umUserDomainBean.getUserName());
        list.add(umUserinfoReDomainBean);
    }

    public void entityAssignment(List<UmUserinfoChannel> list, UmUserinfoChannelDomain umUserinfoChannelDomain) {
        UmUserinfoChannel umUserinfoChannel = new UmUserinfoChannel();
        BeanUtil.copyProperties((Object)umUserinfoChannelDomain, (Object)umUserinfoChannel);
        list.add(umUserinfoChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateMemberCode() {
        Class<DataSynchronousServiceImpl> clazz = DataSynchronousServiceImpl.class;
        synchronized (DataSynchronousServiceImpl.class) {
            String code = DisUtil.getDisCache().getRemot(key);
            if (StringUtils.isNotBlank((String)code)) {
                this.logger.info("code:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)code));
                Long number = Long.parseLong(code) + 1L;
                String str = number.toString();
                this.logger.info("str:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)str));
                DisUtil.getDisCache().set(key, str);
                String format = DataSynchronousServiceImpl.format(str.length(), str);
                this.logger.info("format:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)format));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return format;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("tenantCode", "2022012800000001");
            hashMap.put("userinfoCertNoLike", "8");
            hashMap.put("userinfoQuality", "buy");
            hashMap.put("page", 1);
            hashMap.put("rows", 1);
            SupQueryResult<UmUserinfoReDomainBean> beanSupQueryResult = this.queryUserinfoPage(hashMap);
            List list = beanSupQueryResult.getList();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                UmUserinfoReDomainBean umUserinfoChannelReDomain = (UmUserinfoReDomainBean)list.get(0);
                String userCode = umUserinfoChannelReDomain.getUserinfoCertNo();
                if (StringUtils.isNotBlank((String)userCode)) {
                    Long l;
                    String substring = userCode.substring(1);
                    Long l2 = l = Long.valueOf(Long.parseLong(substring));
                    Long l3 = l = Long.valueOf(l + 1L);
                    String newCode = l.toString();
                    DisUtil.getDisCache().set(key, newCode);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return DataSynchronousServiceImpl.format(newCode.length(), newCode);
                }
                Long number = 1L;
                DisUtil.getDisCache().set(key, number.toString());
                String format = DataSynchronousServiceImpl.format(1, number.toString());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return format;
            }
            Long number = 1L;
            DisUtil.getDisCache().set(key, number.toString());
            String format = DataSynchronousServiceImpl.format(1, number.toString());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return format;
        }
    }

    public static String format(int length, String num) {
        String prefix = "8";
        return prefix + code.substring(0, code.length() - length) + num;
    }
}

