/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.utils.connect;

import com.yqbsoft.laser.service.ims.model.order.PosContractPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGoods;
import com.yqbsoft.laser.service.ims.model.order.PosGoodsPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGuide;
import com.yqbsoft.laser.service.ims.model.order.PosOrder;
import com.yqbsoft.laser.service.ims.utils.PosJdbcUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class PosConnetUtils {
    public static List<PosOrder> init() throws SQLException {
        String findSql = "SELECT  vcmr.ID AS orderId,  vcmr.DOCNO AS contractBillcode,  vcmr.ORGNO AS refundCode,  vcmr.CARDNO AS userinfoOcode,  vcmr.C_VIP_ID AS vipId,  vcmr.STATUSRET AS contractType,  vcmr.TOT_QTY AS goodsNum,  vcmr.TOT_AMT_LIST AS goodsMoney,  'pos' AS goodsClass,  vcmr.CREATIONDATE AS gmtCreate,  vcmr.MODIFIEDDATE AS gmtModified,  '5' AS dataState,  vcmr.TOT_QTY AS contractSendnum,  vccs.CODE AS storeCode,  SUM(  ( CASE  vcmrp.C_PAYWAY_ID   WHEN 27 THEN  vcmrp.PAYAMOUNT   WHEN 64 THEN  vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 )   WHEN 65 THEN  vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 ) ELSE vcmrp.PAYAMOUNT  END   )   ) AS dataBmoney  FROM  NEANDS3.V_CRM_M_RETAIL vcmr  LEFT JOIN NEANDS3.V_CRM_C_STORE vccs ON vccs.ID = vcmr.C_STORE_ID  LEFT JOIN NEANDS3.V_CRM_M_RETAILITEMPAY vcmrp ON vcmrp.M_RETAIL_ID = vcmr.ID  LEFT JOIN NEANDS3.V_CRM_C_CARD vccc ON vccc.ID = vcmrp.C_CARD_ID  WHERE  vcmr.STATUSRET = 1  AND vcmr.ID='8113462' GROUP BY  vccs.CODE,  vcmr.TOT_QTY,  '5',  vcmr.MODIFIEDDATE,  vcmr.CREATIONDATE,  'pos',  vcmr.TOT_AMT_LIST,  vcmr.TOT_QTY,  vcmr.STATUSRET,  vcmr.C_VIP_ID,  vcmr.CARDNO,  vcmr.ORGNO,  vcmr.DOCNO,  vcmr.ID";
        System.out.println(findSql);
        List<PosOrder> list = PosConnetUtils.find(findSql);
        return list;
    }

    public static List<PosOrder> initRefund() throws SQLException {
        String findSql = "SELECT   vcmr.ID AS orderId,   vcmr.DOCNO AS contractBillcode,   vcmr.ORGNO AS refundCode,   vcmr.CARDNO AS userinfoOcode,   vcmr.C_VIP_ID AS vipId,   vcmr.STATUSRET AS contractType,   vcmr.TOT_QTY AS goodsNum,   vcmr.TOT_AMT_LIST AS goodsMoney,   'pos' AS goodsClass,   vcmr.CREATIONDATE AS gmtCreate,   vcmr.MODIFIEDDATE AS gmtModified,   vcmr.STATUSRET AS dataState,   vcmr.TOT_QTY AS contractSendnum,   vccs.CODE AS storeCode,   SUM(   ( CASE   vcmrp.C_PAYWAY_ID    WHEN 27 THEN   vcmrp.PAYAMOUNT    WHEN 64 THEN   vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 )    WHEN 65 THEN   vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 ) ELSE vcmrp.PAYAMOUNT  END    )    ) AS dataBmoney  FROM   NEANDS3.V_CRM_M_RETAIL vcmr   LEFT JOIN NEANDS3.V_CRM_C_STORE vccs ON vccs.ID = vcmr.C_STORE_ID   LEFT JOIN NEANDS3.V_CRM_M_RETAILITEMPAY vcmrp ON vcmrp.M_RETAIL_ID = vcmr.ID   LEFT JOIN NEANDS3.V_CRM_C_CARD vccc ON vccc.ID = vcmrp.C_CARD_ID  WHERE   ( vcmr.STATUSRET = 2 OR vcmr.STATUSRET = 8 )    AND vcmr.BILLDATE = '20220920'  GROUP BY   vccs.CODE,   vcmr.TOT_QTY,   vcmr.STATUSRET,   vcmr.MODIFIEDDATE,   vcmr.CREATIONDATE,   'pos',   vcmr.TOT_AMT_ACTUAL,   vcmr.TOT_AMT_LIST,   vcmr.TOT_QTY,   vcmr.STATUSRET,   vcmr.C_VIP_ID,   vcmr.CARDNO,   vcmr.ORGNO,   vcmr.DOCNO,   vcmr.ID";
        System.out.println(findSql);
        List<PosOrder> list = PosConnetUtils.find(findSql);
        return list;
    }

    public static List<PosOrder> initExchange() throws SQLException {
        String findSql = "SELECT  vcmr.ID AS orderId,  vcmr.DOCNO AS contractBillcode,  vcmr.ORGNO AS refundCode,  vcmr.CARDNO AS userinfoOcode,  vcmr.C_VIP_ID AS vipId,  vcmr.STATUSRET AS contractType,  vcmr.TOT_QTY AS goodsNum,  vcmr.TOT_AMT_LIST AS goodsMoney,  'pos' AS goodsClass,  vcmr.CREATIONDATE AS gmtCreate,  vcmr.MODIFIEDDATE AS gmtModified,  '5' AS dataState,  vcmr.TOT_QTY AS contractSendnum,  vccs.CODE AS storeCode,  SUM(  ( CASE  vcmrp.C_PAYWAY_ID   WHEN 27 THEN  vcmrp.PAYAMOUNT   WHEN 64 THEN  vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 )   WHEN 65 THEN  vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 ) ELSE vcmrp.PAYAMOUNT  END   )   ) AS dataBmoney  FROM  NEANDS3.V_CRM_M_RETAIL vcmr  LEFT JOIN NEANDS3.V_CRM_C_STORE vccs ON vccs.ID = vcmr.C_STORE_ID  LEFT JOIN NEANDS3.V_CRM_M_RETAILITEMPAY vcmrp ON vcmrp.M_RETAIL_ID = vcmr.ID  LEFT JOIN NEANDS3.V_CRM_C_CARD vccc ON vccc.ID = vcmrp.C_CARD_ID  WHERE  vcmr.STATUSRET = 4   AND vcmr.BILLDATE = '20220920' GROUP BY  vccs.CODE,  vcmr.TOT_QTY,  '5',  vcmr.MODIFIEDDATE,  vcmr.CREATIONDATE,  'pos',  vcmr.TOT_AMT_LIST,  vcmr.TOT_QTY,  vcmr.STATUSRET,  vcmr.C_VIP_ID,  vcmr.CARDNO,  vcmr.ORGNO,  vcmr.DOCNO,  vcmr.ID";
        System.out.println(findSql);
        List<PosOrder> list = PosConnetUtils.find(findSql);
        return list;
    }

    public static List<PosGuide> initGuide(String orderId) throws SQLException {
        String findSql = "SELECT  vcce.NO as guideCode, vcmr.DISCOUNT as disMoney FROM  NEANDS3.V_CRM_M_RETAILEMP vcmr  INNER JOIN NEANDS3.V_CRM_C_EMPLOYEE vcce ON vcce.ID = vcmr.EMPID  WHERE  vcmr.M_RETAIL_ID = " + orderId;
        System.out.println(findSql);
        return PosConnetUtils.findGuide(findSql);
    }

    public static List<PosGoodsPayDetails> initGoodsPayDetail(String orderId) throws SQLException {
        String findSql = "SELECT pay.MODIFIEDDATE AS gmtModified, pay.CREATIONDATE AS gmtCreate, pay.C_PAYWAY_ID AS paywayId, vccc.DISCOUNT AS discountRate, ( CASE pay.C_PAYWAY_ID  WHEN 27 THEN pay.PAYAMOUNT  WHEN 64 THEN pay.PAYAMOUNT * ( vccc.DISCOUNT / 100 )  WHEN 65 THEN pay.PAYAMOUNT * ( vccc.DISCOUNT / 100 ) ELSE pay.PAYAMOUNT  END  ) payMoney, vcmrg.SKU AS goodSku  FROM NEANDS3.V_CRM_M_RETAILITEMPAY pay LEFT JOIN NEANDS3.V_CRM_C_CARD vccc ON vccc.ID = pay.C_CARD_ID LEFT JOIN NEANDS3.V_CRM_M_RETAILITEM vcmrg ON vcmrg.ID = pay.M_RETAILITEM_ID  WHERE pay.M_RETAIL_ID =" + orderId;
        System.out.println(findSql);
        return PosConnetUtils.findGoodsPayDetail(findSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PosGoodsPayDetails> findGoodsPayDetail(String findSql) {
        Connection conn = null;
        ResultSet result = null;
        Statement stat = null;
        ArrayList<PosGoodsPayDetails> list = new ArrayList<PosGoodsPayDetails>();
        try {
            conn = PosJdbcUtils.getConnection();
            conn.setAutoCommit(false);
            stat = conn.createStatement();
            result = stat.executeQuery(findSql);
            while (result.next()) {
                PosGoodsPayDetails pos = new PosGoodsPayDetails();
                pos.setGmtCreate(result.getString("gmtCreate"));
                pos.setGmtModified(result.getString("gmtModified"));
                pos.setPayMoney(result.getBigDecimal("payMoney"));
                pos.setPaywayId(result.getInt("paywayId"));
                pos.setDiscountRate(result.getBigDecimal("discountRate"));
                pos.setGoodsSku(result.getString("goodSku"));
                list.add(pos);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    PosJdbcUtils.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static List<PosContractPayDetails> initContractPayDetail(String orderId) throws SQLException {
        String findSql = "SELECT     pay.MODIFIEDDATE AS gmtModified,    NULLIF( pay.MODIFIEDDATE, pay.CREATIONDATE ) AS gmtCreate,    pay.C_PAYWAY_ID AS paywayId,    vccc.DISCOUNT AS discountRate,    pay.C_CARD_ID AS userCardId,    pay.CARDTYPE AS type,    (   CASE    pay.C_PAYWAY_ID     WHEN 27 THEN    pay.PAYAMOUNT     WHEN 64 THEN    pay.PAYAMOUNT * ( vccc.DISCOUNT / 100 )     WHEN 65 THEN    pay.PAYAMOUNT * ( vccc.DISCOUNT / 100 ) ELSE pay.PAYAMOUNT    END     ) payMoney    FROM    NEANDS3.V_CRM_M_RETAILPAYITEM pay    LEFT JOIN NEANDS3.V_CRM_C_CARD vccc ON vccc.ID = pay.C_CARD_ID    WHERE    pay.M_RETAIL_ID =  " + orderId;
        System.out.println(findSql);
        return PosConnetUtils.findContractPayDetail(findSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PosContractPayDetails> findContractPayDetail(String findSql) {
        Connection conn = null;
        ResultSet result = null;
        Statement stat = null;
        ArrayList<PosContractPayDetails> list = new ArrayList<PosContractPayDetails>();
        try {
            conn = PosJdbcUtils.getConnection();
            conn.setAutoCommit(false);
            stat = conn.createStatement();
            result = stat.executeQuery(findSql);
            while (result.next()) {
                PosContractPayDetails pos = new PosContractPayDetails();
                pos.setGmtCreate(result.getString("gmtCreate"));
                pos.setGmtModified(result.getString("gmtModified"));
                pos.setPayMoney(result.getBigDecimal("payMoney"));
                pos.setUserCardId(result.getString("userCardId"));
                pos.setPaywayId(result.getInt("paywayId"));
                pos.setDiscountRate(result.getBigDecimal("discountRate"));
                pos.setType(result.getInt("type"));
                list.add(pos);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    PosJdbcUtils.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static PosGoods initGoodsPrice(String orderId, String goodsId) throws SQLException {
        String findSql = "SELECT   SUM(   ( CASE   vcmrp.C_PAYWAY_ID    WHEN 27 THEN   vcmrp.PAYAMOUNT    WHEN 64 THEN   vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 )    WHEN 65 THEN   vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 ) ELSE vcmrp.PAYAMOUNT  END    )    ) AS goodsNprice,   SUM(   ( CASE   vcmrp.C_PAYWAY_ID    WHEN 27 THEN   vcmrp.PAYAMOUNT    WHEN 64 THEN   vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 )    WHEN 65 THEN   vcmrp.PAYAMOUNT * ( vccc.DISCOUNT / 100 ) ELSE vcmrp.PAYAMOUNT  END    )    ) AS contractNPrice  FROM   NEANDS3.v_crm_m_retailitem vcmr   LEFT JOIN NEANDS3.V_CRM_M_RETAILITEMPAY vcmrp ON vcmrp.M_RETAILITEM_ID = vcmr.ID   LEFT JOIN NEANDS3.V_CRM_C_CARD vccc ON vccc.ID = vcmrp.C_CARD_ID  WHERE   vcmr.m_retail_id =" + orderId + "  AND vcmr.ID = " + goodsId;
        System.out.println(findSql);
        List<PosGoods> goods = PosConnetUtils.findGoodsPrice(findSql);
        return goods.get(0);
    }

    public static List<PosGoods> initGoods(String orderId) throws SQLException {
        String findSql = "SELECT  vcmr.ID AS goodsId, vcmr.SKC AS goodsSkc, vcmr.SKU AS goodsSku, vcmr.QTY AS goodsNum, vcmr.TOT_AMT_LIST AS goodsMakePrice, vcmr.STATUS AS goodsStatus, vcmr.TYPE AS goodType, vcmr.PRICELIST AS contractPrice   FROM  NEANDS3.v_crm_m_retailitem vcmr  WHERE  vcmr.m_retail_id = '" + orderId + "'";
        System.out.println(findSql);
        List<PosGoods> goods = PosConnetUtils.findGoods(findSql);
        if (!CollectionUtils.isEmpty(goods)) {
            for (PosGoods pod : goods) {
                PosGoods posGoods = PosConnetUtils.initGoodsPrice(orderId, pod.getGoodsId());
                pod.setGoodsNprice(posGoods.getGoodsNprice());
                pod.setContractNPrice(posGoods.getContractNPrice());
            }
        }
        return goods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PosGoods> findGoods(String findSql) {
        Connection conn = null;
        ResultSet result = null;
        Statement stat = null;
        ArrayList<PosGoods> list = new ArrayList<PosGoods>();
        try {
            conn = PosJdbcUtils.getConnection();
            conn.setAutoCommit(false);
            stat = conn.createStatement();
            result = stat.executeQuery(findSql);
            while (result.next()) {
                PosGoods posGoods = new PosGoods();
                posGoods.setGoodsSkc(result.getString("goodsSkc"));
                posGoods.setGoodsSku(result.getString("goodsSku"));
                posGoods.setDisCountRatio(result.getString("disCountRatio"));
                posGoods.setGoodsNum(result.getString("goodsNum"));
                posGoods.setGoodsMakePrice(result.getString("goodsMakePrice"));
                posGoods.setGoodsStatus(result.getString("goodsStatus"));
                posGoods.setGoodType(result.getString("goodType"));
                posGoods.setContractPrice(result.getString("contractPrice"));
                posGoods.setGoodsId(result.getString("goodsId"));
                list.add(posGoods);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    PosJdbcUtils.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PosGoods> findGoodsPrice(String findSql) {
        Connection conn = null;
        ResultSet result = null;
        Statement stat = null;
        ArrayList<PosGoods> list = new ArrayList<PosGoods>();
        try {
            conn = PosJdbcUtils.getConnection();
            conn.setAutoCommit(false);
            stat = conn.createStatement();
            result = stat.executeQuery(findSql);
            while (result.next()) {
                PosGoods posGoods = new PosGoods();
                posGoods.setGoodsNprice(result.getString("goodsNprice"));
                posGoods.setContractNPrice(result.getString("contractNPrice"));
                list.add(posGoods);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    PosJdbcUtils.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PosGuide> findGuide(String sql) {
        Connection conn = null;
        ResultSet result = null;
        Statement stat = null;
        ArrayList<PosGuide> list = new ArrayList<PosGuide>();
        try {
            conn = PosJdbcUtils.getConnection();
            conn.setAutoCommit(false);
            stat = conn.createStatement();
            result = stat.executeQuery(sql);
            while (result.next()) {
                PosGuide posGuide = new PosGuide();
                posGuide.setGuideCode(result.getString("guideCode"));
                posGuide.setDiscount(result.getString("disMoney"));
                list.add(posGuide);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    PosJdbcUtils.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PosOrder> find(String sql) {
        Connection conn = null;
        ResultSet result = null;
        Statement stat = null;
        ArrayList<PosOrder> list = new ArrayList<PosOrder>();
        try {
            conn = PosJdbcUtils.getConnection();
            conn.setAutoCommit(false);
            stat = conn.createStatement();
            result = stat.executeQuery(sql);
            while (result.next()) {
                PosOrder posOrderDomain = new PosOrder();
                posOrderDomain.setContractBillcode(result.getString("contractBillcode"));
                posOrderDomain.setOrderId(result.getString("orderId"));
                posOrderDomain.setRefundCode(result.getString("refundCode"));
                posOrderDomain.setUserinfoOcode(result.getString("userinfoOcode"));
                posOrderDomain.setStoreCode(result.getString("storeCode"));
                posOrderDomain.setGoodsNum(result.getString("goodsNum"));
                posOrderDomain.setGoodsMoney(result.getString("goodsMoney"));
                posOrderDomain.setDataBmoney(result.getString("dataBmoney"));
                posOrderDomain.setGoodsClass(result.getString("goodsClass"));
                posOrderDomain.setGmtCreate(result.getString("gmtCreate"));
                posOrderDomain.setGmtModified(result.getString("gmtModified"));
                posOrderDomain.setDataState(result.getString("dataState"));
                posOrderDomain.setContractSendnum(result.getString("contractSendnum"));
                posOrderDomain.setContractType(result.getString("contractType"));
                list.add(posOrderDomain);
            }
        }
        catch (SQLException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (stat != null) {
                    stat.close();
                }
                if (conn != null) {
                    PosJdbcUtils.releaseConnection(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static void main(String[] args) throws SQLException {
        PosConnetUtils.init();
    }
}

