/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.sap.executes;

import com.yqbsoft.laser.service.ims.sap.executes.IMultiStepJob;
import com.yqbsoft.laser.service.ims.sap.executes.RfcSessionReference;
import java.util.Hashtable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class JcoMutiThread
extends Thread {
    public static Hashtable<IMultiStepJob, RfcSessionReference> sessions = new Hashtable();
    public static ThreadLocal<RfcSessionReference> localSessionReference = new ThreadLocal();
    private BlockingQueue<IMultiStepJob> queue;
    private CountDownLatch doneSignal;
    private boolean isSapBusy = false;

    public JcoMutiThread(CountDownLatch doneSignal, BlockingQueue<IMultiStepJob> queue) {
        this.doneSignal = doneSignal;
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            IMultiStepJob job;
            while ((job = this.queue.poll(10L, TimeUnit.SECONDS)) != null) {
                RfcSessionReference sesRef;
                if (this.isSapBusy) {
                    Thread.sleep(5000L);
                }
                if ((sesRef = sessions.get(job)) == null) {
                    sesRef = new RfcSessionReference();
                    sessions.put(job, sesRef);
                }
                localSessionReference.set(sesRef);
                try {
                    this.isSapBusy = job.runNextStep();
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
                if (this.isSapBusy) {
                    this.queue.add(job);
                } else {
                    sessions.remove(job);
                    job.cleanUp();
                }
                localSessionReference.set(null);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.doneSignal.countDown();
        }
    }
}

