/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.google.common.collect.ImmutableMap;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ims.dao.CdpGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.CdpOpenApiUrlMapper;
import com.yqbsoft.laser.service.ims.dao.DisChannelMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractGuideMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractPayDetailMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractPayGoodsDetailMapper;
import com.yqbsoft.laser.service.ims.dao.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.OcRefundMapper;
import com.yqbsoft.laser.service.ims.dao.OcRepairPosContractMapper;
import com.yqbsoft.laser.service.ims.dao.OcRepairPosRefundContractMapper;
import com.yqbsoft.laser.service.ims.dao.OrgDepartMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoChannelMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoMapper;
import com.yqbsoft.laser.service.ims.dao.UpmUpointsMapper;
import com.yqbsoft.laser.service.ims.domain.OcContractGoods;
import com.yqbsoft.laser.service.ims.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.ims.domain.OcPackage;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousAttributeDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousCardDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousEmpDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousEmpsDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousItemDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousItempayDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousOrderDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousPayitemDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousProductAliasDomain;
import com.yqbsoft.laser.service.ims.model.DisChannel;
import com.yqbsoft.laser.service.ims.model.GoodsCategoryVO;
import com.yqbsoft.laser.service.ims.model.OcContract;
import com.yqbsoft.laser.service.ims.model.OcContractPayDetail;
import com.yqbsoft.laser.service.ims.model.OcContractPayGoodsDetail;
import com.yqbsoft.laser.service.ims.model.OcRefund;
import com.yqbsoft.laser.service.ims.model.OcRefundGoods;
import com.yqbsoft.laser.service.ims.model.OrgDepart;
import com.yqbsoft.laser.service.ims.model.UlLevelUpoints;
import com.yqbsoft.laser.service.ims.model.UmUserinfoChannel;
import com.yqbsoft.laser.service.ims.model.UmUserinfoModel;
import com.yqbsoft.laser.service.ims.model.UmUserinfoQua;
import com.yqbsoft.laser.service.ims.model.UpmUpointsClear;
import com.yqbsoft.laser.service.ims.model.order.CdpGoods;
import com.yqbsoft.laser.service.ims.model.order.PosContractPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGoods;
import com.yqbsoft.laser.service.ims.model.order.PosGoodsPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGuide;
import com.yqbsoft.laser.service.ims.model.order.PosOrder;
import com.yqbsoft.laser.service.ims.service.PosStoreService;
import com.yqbsoft.laser.service.ims.utils.HttpClientUtil;
import com.yqbsoft.laser.service.ims.utils.connect.PosConnetUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class PosStoreServiceImpl
extends BaseServiceImpl
implements PosStoreService {
    @Autowired
    private UpmUpointsMapper upmUpointsMapper;
    @Autowired
    private UmUserinfoMapper umUserinfoMapper;
    @Autowired
    private OrgDepartMapper orgDepartMapper;
    @Autowired
    private DisChannelMapper disChannelMapper;
    @Autowired
    private UmUserinfoChannelMapper umUserinfoChannelMapper;
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGuideMapper ocContractGuideMapper;
    @Autowired
    private CdpGoodsMapper cdpGoodsMapper;
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;
    @Autowired
    private OcContractPayDetailMapper ocContractPayDetailMapper;
    @Autowired
    private OcContractPayGoodsDetailMapper ocContractPayGoodsDetailMapper;
    @Autowired
    private OcRefundMapper ocRefundMapper;
    @Autowired
    private OcRefundGoodsMapper ocRefundGoodsMapper;
    @Autowired
    private CdpOpenApiUrlMapper cdpOpenApiUrlMapper;
    @Autowired
    private OcRepairPosContractMapper ocRepairPosContractMapper;
    @Autowired
    private OcRepairPosRefundContractMapper ocRepairPosRefundContractMapper;
    private static final String cdp_order_code = "cdp_order";

    @Override
    public void timingPosOrder(String satrtDadate, String endDadate) {
        URI uri = null;
        try {
            String byCode = this.cdpOpenApiUrlMapper.getByCode(cdp_order_code);
            Date date = new Date();
            Date date1 = DateUtils.addSeconds((Date)date, (int)-600);
            this.logger.info(DateUtils.parseDateToString((Date)date1, (String)"yyyy-MM-dd HH:mm:ss"));
            String endDate = DateUtils.parseDateToString((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            String bigDate = DateUtils.parseDateToString((Date)date1, (String)"yyyy-MM-dd HH:mm:ss");
            String start = bigDate.replace(" ", "%20");
            String end = endDate.replace(" ", "%20");
            String str = null;
            str = StringUtils.isNotBlank((String)satrtDadate) && StringUtils.isNotBlank((String)endDadate) ? byCode + "?dateb=" + satrtDadate.replace(" ", "%20") + "&datee=" + endDadate.replace(" ", "%20") + "&page=1&rows=5000" : byCode + "?dateb=" + start + "&datee=" + end + "&page=1&rows=5000";
            this.logger.info("str\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)str));
            uri = new URI(str);
            String result = HttpClientUtil.sendPostForJson(uri);
            if (StringUtils.isBlank((String)result)) {
                this.logger.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff1a{}", (Object)str);
                return;
            }
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, SupQueryResult.class);
            this.logger.info("supQueryResult\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)supQueryResult));
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), TimingSynchronousOrderDomain.class);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                this.timingSynchronousOrder(list);
            }
            this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)list));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public void timingSynchronousOrder(List<TimingSynchronousOrderDomain> list) {
        list.stream().forEach(order -> {
            String origvalue = order.getOrigvalue();
            Integer statusret = order.getStatusret();
            List<UmUserinfoModel> query = null;
            if (!Objects.isNull(order.getVip())) {
                Integer cardno = order.getVip().getCardno();
                this.logger.info("cardNo:", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)cardno));
                HashMap<String, Object> userInfoMap = new HashMap<String, Object>();
                userInfoMap.put("userinfoOcode", cardno + "");
                userInfoMap.put("userinfoQuality", "buy");
                userInfoMap.put("fuzzy", false);
                query = this.umUserinfoMapper.query(userInfoMap);
            }
            HashMap<String, Object> orgMap = new HashMap<String, Object>();
            orgMap.put("departOcode", order.getStore().getCode());
            List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
            if (CollectionUtils.isEmpty(orgDepartList)) {
                this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(orgMap));
            } else {
                OrgDepart orgDepart = orgDepartList.get(0);
                UmUserinfoModel umUserinfoModel = null;
                if (!CollectionUtils.isEmpty(query)) {
                    umUserinfoModel = (UmUserinfoModel)query.get(0);
                    HashMap<String, Object> infochannelMap = new HashMap<String, Object>();
                    infochannelMap.put("userinfoCode", umUserinfoModel.getUserinfoCode());
                    infochannelMap.put("channelCode", orgDepart.getCompanyCode());
                    List<UmUserinfoChannel> umUserinfoChannelList = this.umUserinfoChannelMapper.query(infochannelMap);
                    this.logger.info("\u662f\u5426\u6709\u8fd9\u4e2a\u6e20\u9053\u7528\u6237\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)umUserinfoChannelList.size()));
                    if (CollectionUtils.isEmpty(umUserinfoChannelList)) {
                        this.createBrandUser(umUserinfoModel, orgDepart);
                    }
                }
                if (statusret != 4) {
                    if (statusret != 2 && statusret != 8) {
                        Iterator<TimingSynchronousItemDomain> iterator = order.getItem().iterator();
                        while (iterator.hasNext()) {
                            TimingSynchronousItemDomain next = iterator.next();
                            if (next.getType() != 32 && next.getType() != 4) continue;
                            if (StringUtils.isNotBlank((String)next.getTot_amt_list())) {
                                order.setTot_amt_list(new BigDecimal(order.getTot_amt_list()).subtract(new BigDecimal(next.getTot_amt_list())).toString());
                            }
                            iterator.remove();
                        }
                        if (CollectionUtils.isEmpty(order.getItem())) {
                            this.logger.info("\u8be5\u5546\u54c1\u90fd\u662f32\u548c4");
                        } else {
                            OcContract ocContract = this.saveTimingSynchronousOrder((TimingSynchronousOrderDomain)order, umUserinfoModel, orgDepart);
                            if (!Objects.isNull(ocContract)) {
                                this.checkPoint(ocContract);
                                ocContract.setGoodsPbillno(origvalue);
                                String s = this.saveTimingSynchronousGoods(ocContract, (TimingSynchronousOrderDomain)order);
                                if (!StringUtils.isBlank((String)s)) {
                                    List<TimingSynchronousEmpsDomain> emps = order.getEmps();
                                    if (!CollectionUtils.isEmpty(emps)) {
                                        for (TimingSynchronousEmpsDomain tse : emps) {
                                            this.timingSynchronousSaveGuide(tse, ocContract.getContractBillcode());
                                        }
                                    }
                                    List<TimingSynchronousPayitemDomain> list = order.getPayitem();
                                    this.contractGoodsPayInfo((TimingSynchronousOrderDomain)order, ocContract, list);
                                    List<TimingSynchronousItempayDomain> itempay = order.getItempay();
                                    if (!CollectionUtils.isEmpty(itempay)) {
                                        for (TimingSynchronousItempayDomain payDomain : itempay) {
                                            this.timingSynchronousItemPayDetails(payDomain, order.getDocno(), null);
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        this.logger.info("\u6ca1\u6709\u9000\u6b3e\u5355\u53f7\uff0c\u65e0\u6cd5\u4fdd\u5b58");
                        OcRefund ocRefund = this.saveTimingSynchronousRefundOrder((TimingSynchronousOrderDomain)order, umUserinfoModel, orgDepart);
                        if (!Objects.isNull(ocRefund)) {
                            this.checkPoint(ocRefund);
                            ocRefund.setDdTypeCurrency(origvalue);
                            String s = this.saveTimingSynchronousRefundGoods(ocRefund, (TimingSynchronousOrderDomain)order);
                            if (StringUtils.isNotBlank((String)s)) {
                                List<TimingSynchronousItempayDomain> list;
                                List<TimingSynchronousPayitemDomain> payitem;
                                List<TimingSynchronousEmpsDomain> emps = order.getEmps();
                                if (!CollectionUtils.isEmpty(emps)) {
                                    for (TimingSynchronousEmpsDomain timingSynchronousEmpsDomain : emps) {
                                        this.timingSynchronousSaveGuide(timingSynchronousEmpsDomain, ocRefund.getRefundCode());
                                    }
                                }
                                if (!CollectionUtils.isEmpty(payitem = order.getPayitem())) {
                                    for (TimingSynchronousPayitemDomain payDomain : payitem) {
                                        this.timingSynchronousPayDetails(payDomain, null, ocRefund.getRefundCode());
                                    }
                                }
                                if (!CollectionUtils.isEmpty(list = order.getItempay())) {
                                    for (TimingSynchronousItempayDomain payDomain : list) {
                                        this.timingSynchronousItemPayDetails(payDomain, null, ocRefund.getRefundCode());
                                    }
                                }
                            }
                        }
                    }
                } else {
                    this.logger.info("\u8fd9\u4e2a\u662f\u6362\u8272\u6362\u7801\u5355\u5b50");
                }
            }
        });
    }

    private void contractGoodsPayInfo(TimingSynchronousOrderDomain order, OcContract ocContract, List<TimingSynchronousPayitemDomain> payitem) {
        if (!CollectionUtils.isEmpty(payitem)) {
            for (TimingSynchronousPayitemDomain payDomain : payitem) {
                TimingSynchronousCardDomain cardDomain;
                Integer c_payway_id = payDomain.getC_payway_id();
                this.logger.info("c_payway_id\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)c_payway_id));
                if (c_payway_id == 64 || c_payway_id == 65) {
                    cardDomain = payDomain.getCard();
                    if (cardDomain != null) {
                        String discount = cardDomain.getDiscount();
                        BigDecimal beginMoney = this.getBigDecimal(payDomain.getPayamount());
                        this.logger.info("\u6253\u5370\u91d1\u989d\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)beginMoney));
                        BigDecimal discountRatio = this.getBigDecimal(discount).divide(new BigDecimal(100)).setScale(4, 4);
                        this.logger.info("\u6253\u5370\u7a0e\u7387\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)discountRatio));
                        BigDecimal money = beginMoney.multiply(discountRatio);
                        payDomain.setPayamount(money.toString());
                        this.logger.info("\u6253\u5370\u8ba1\u7b97\u540e\u7684\u91d1\u989d22\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)money));
                    } else {
                        this.logger.info("\u5361\u53f7\u4e3a\u7a7a");
                    }
                } else if (c_payway_id == 68) {
                    String cardno;
                    this.logger.info("\u8fdb\u5165\u589e\u52a0\u8ba2\u5355\u548c\u4f18\u60e0\u5238\u7ba1\u8fde");
                    cardDomain = payDomain.getCard();
                    this.logger.info("\u8fdb\u5165\u589e\u52a0\u8ba2\u5355\u548c\u4f18\u60e0\u5238\u7ba1\u8fde\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)cardDomain));
                    if (!Objects.isNull(cardDomain) && StringUtils.isNotBlank((String)(cardno = cardDomain.getCardno()))) {
                        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
                        ocContractSettlDomain.setContractBillcode(ocContract.getContractBillcode());
                        ocContractSettlDomain.setContractSettlBlance("COP");
                        ocContractSettlDomain.setMemberBcode(ocContract.getMemberBcode());
                        ocContractSettlDomain.setMemberBname(ocContract.getMemberBname());
                        ocContractSettlDomain.setMemberCode(ocContract.getMemberCode());
                        ocContractSettlDomain.setMemberName(ocContract.getMemberName());
                        ocContractSettlDomain.setMemberCcode(ocContract.getMemberCcode());
                        ocContractSettlDomain.setMemberCname(ocContract.getMemberCname());
                        ocContractSettlDomain.setContractSettlType("3");
                        ocContractSettlDomain.setContractPmode("0");
                        ocContractSettlDomain.setContractSettlGmoney(new BigDecimal("0"));
                        ocContractSettlDomain.setContractSettlPmoney(new BigDecimal(order.getTot_amt_cash()));
                        ocContractSettlDomain.setTenantCode(ocContract.getTenantCode());
                        OcContractSettlDomain userCoupon = this.ocContractMapper.getUserCoupon(cardno);
                        this.logger.info("\u67e5\u8be2\u51fa\u7684\u5238\u7801\u662f\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)userCoupon));
                        if (!Objects.isNull(userCoupon)) {
                            ocContractSettlDomain.setContractSettlOpno(userCoupon.getContractSettlOpno());
                            ocContractSettlDomain.setContractSettlOpemo(userCoupon.getContractSettlOpemo());
                            ocContractSettlDomain.setContractSettlBillcode(System.currentTimeMillis() + "");
                            try {
                                ocContractSettlDomain.setGmtCreate(new Date());
                                ocContractSettlDomain.setGmtModified(new Date());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            this.ocContractMapper.saveOcContractSettl(ocContractSettlDomain);
                        }
                    }
                }
                this.timingSynchronousPayDetails(payDomain, order.getDocno(), null);
            }
        }
    }

    private void createBrandUser(UmUserinfoModel umUserinfoModel, OrgDepart orgDepart) {
        String userinfoChannelCode = this.createChannelUser(umUserinfoModel.getUserinfoCompname(), umUserinfoModel.getUserinfoCode(), orgDepart.getCompanyCode());
        if (StringUtils.isNotBlank((String)userinfoChannelCode)) {
            this.createUserLevel(umUserinfoModel.getUserinfoCode(), orgDepart.getCompanyCode());
            this.createUserQua(userinfoChannelCode, orgDepart);
            this.pushCdpUserData(umUserinfoModel.getUserinfoCode());
        }
    }

    private void createUserQua(String userinfoChannelCode, OrgDepart orgDepart) {
        UmUserinfoQua umUserinfoQua = new UmUserinfoQua();
        umUserinfoQua.setUserinfoCode(userinfoChannelCode);
        umUserinfoQua.setTenantCode("2022012800000001");
        umUserinfoQua.setUserinfoQuaKey("store");
        List<UmUserinfoModel> query = this.umUserinfoMapper.query((Map<String, Object>)ImmutableMap.of((Object)"departCode", (Object)orgDepart.getDepartCode(), (Object)"userinfoQuality", (Object)"depart"));
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("" + userinfoChannelCode + "\u95e8\u5e97" + JsonUtil.buildNonDefaultBinder().toJson((Object)orgDepart));
            return;
        }
        UmUserinfoModel umUserinfoModel = query.get(0);
        umUserinfoQua.setUserinfoQuaVaule1(umUserinfoModel.getUserinfoCode());
        umUserinfoQua.setUserinfoQuaVaule(umUserinfoModel.getUserinfoCompname());
        this.inserUserinfoQua(umUserinfoQua);
    }

    private void inserUserinfoQua(UmUserinfoQua umUserinfoQua) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("umUserinfoQuaDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoQua));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)umUserinfoQua));
            Object o = this.getInternalRouter().inInvoke("um.userinfoQua.saveUserinfoQua", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createUserLevel(String userinfoCode, String companyCode) {
        UlLevelUpoints ulLevelUpoints = new UlLevelUpoints();
        ulLevelUpoints.setChannelCode(companyCode);
        ulLevelUpoints.setMemberCode(userinfoCode);
        ulLevelUpoints.setLevelUserqua("buy");
        ulLevelUpoints.setLevelDatatype("levelListCode");
        ulLevelUpoints.setLevelDatavalue("0");
        ulLevelUpoints.setLevelListLevel(0);
        ulLevelUpoints.setLevelListName("\u4f1a\u5458\u5361");
        ulLevelUpoints.setLevelLnum(this.getBigDecimal(0));
        ulLevelUpoints.setLevelNum(this.getBigDecimal(0));
        ulLevelUpoints.setLevelOnum(this.getBigDecimal(0));
        ulLevelUpoints.setTenantCode("2022012800000001");
        ulLevelUpoints.setUpointsType(0);
        DisChannel byCode = this.disChannelMapper.getByCode((Map<String, Object>)ImmutableMap.of((Object)"channelCode", (Object)companyCode));
        if (byCode != null) {
            ulLevelUpoints.setMemberMcode(byCode.getMemberCode());
            this.insertUlLevelUpoints(ulLevelUpoints);
        }
    }

    private void insertUlLevelUpoints(UlLevelUpoints ulLevelUpoints) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("ulLevelUpointsDomain", JsonUtil.buildNormalBinder().toJson((Object)ulLevelUpoints));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)ulLevelUpoints));
            Object o = this.getInternalRouter().inInvoke("ul.ulLevelUllist.saveUlLevelUpoints", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String createChannelUser(String name, String userinfoCode, String companyCode) {
        UmUserinfoChannel umUserinfoChannel = new UmUserinfoChannel();
        umUserinfoChannel.setDataState(0);
        umUserinfoChannel.setUserinfoCompname(name);
        umUserinfoChannel.setChannelCode(companyCode);
        umUserinfoChannel.setUserinfoCode(userinfoCode);
        umUserinfoChannel.setGmtCreate(new Date());
        umUserinfoChannel.setGmtModified(new Date());
        umUserinfoChannel.setQualityCode("buy");
        umUserinfoChannel.setTenantCode("2022012800000001");
        umUserinfoChannel.setUserinfoChannelVaule1("01");
        return this.inserUmUserinfoChannel(umUserinfoChannel);
    }

    private String inserUmUserinfoChannel(UmUserinfoChannel umUserinfoChannel) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("umUserinfoChannelDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannel));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)umUserinfoChannel));
            Object o = this.getInternalRouter().inInvoke("um.umUserinfoChannel.saveUserinfoChannel", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
            return (String)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String saveTimingSynchronousRefundGoods(OcRefund oc, TimingSynchronousOrderDomain order) {
        if (Objects.isNull(oc)) {
            return null;
        }
        BigDecimal goodsMoney = new BigDecimal("0");
        BigDecimal goodsInMoney = new BigDecimal("0");
        BigDecimal totalNum = new BigDecimal("0");
        this.logger.info("\u6253\u5370item\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(order.getItem()));
        List<TimingSynchronousItemDomain> item = order.getItem();
        ArrayList<OcRefundGoods> list = new ArrayList<OcRefundGoods>();
        if (!CollectionUtils.isEmpty(item)) {
            int i = 0;
            for (TimingSynchronousItemDomain goods : item) {
                ++i;
                goods.setTot_amt_actual("0");
                List<TimingSynchronousItempayDomain> itempay = order.getItempay();
                if (!CollectionUtils.isEmpty(itempay)) {
                    this.logger.info("\u6253\u5370\u65e5\u5fd7itempay\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(itempay));
                    List collect = itempay.stream().filter(pay -> pay != null && pay.getM_retailitem_id().toString().equals(goods.getId().toString())).collect(Collectors.toList());
                    this.logger.info("\u6253\u5370\u65e5\u5fd7collect\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(collect));
                    if (!CollectionUtils.isEmpty(collect)) {
                        for (TimingSynchronousItempayDomain itempayDomain : collect) {
                            Integer c_payway_id = itempayDomain.getC_payway_id();
                            if (c_payway_id == 64 || c_payway_id == 65) {
                                TimingSynchronousCardDomain cardDomain = itempayDomain.getCard();
                                if (cardDomain != null) {
                                    String discount = cardDomain.getDiscount();
                                    BigDecimal beginMoney = this.getBigDecimal(itempayDomain.getPayamount());
                                    this.logger.info("\u6253\u5370\u91d1\u989d\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)beginMoney));
                                    BigDecimal discountRatio = this.getBigDecimal(discount).divide(new BigDecimal(100)).setScale(4, 4);
                                    this.logger.info("\u6253\u5370\u7a0e\u7387\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)discountRatio));
                                    BigDecimal money = beginMoney.multiply(discountRatio);
                                    goods.setTot_amt_actual(money.add(this.getBigDecimal(goods.getTot_amt_actual())).toString());
                                    goodsMoney = goodsMoney.add(money);
                                    itempayDomain.setPayamount(money.toString());
                                    this.logger.info("\u6253\u5370\u8ba1\u7b97\u540e\u7684\u91d1\u989d22\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goodsMoney));
                                } else {
                                    this.logger.info("\u5361\u53f7\u4e3a\u7a7a");
                                }
                            }
                            if (c_payway_id != 27) continue;
                            goods.setTot_amt_actual(this.getBigDecimal(itempayDomain.getPayamount()).add(this.getBigDecimal(goods.getTot_amt_actual())).toString());
                            goodsMoney = goodsMoney.add(this.getBigDecimal(itempayDomain.getPayamount()));
                            this.logger.info("\u6253\u5370\u8ba1\u7b97\u540e\u7684\u91d1\u989d\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goodsMoney));
                        }
                    }
                }
                String skc = goods.getProduct().getName();
                String spu = goods.getProductAlias().getNo().substring(0, goods.getProductAlias().getNo().indexOf(goods.getProductAlias().getAttribute().getValue1()));
                String contractGoods = "";
                OcContractGoods contractGoodsDomian = this.ocContractGoodsMapper.getContractGoodsByContractBillcodeAndSkuCode(oc.getContractBillcode(), goods.getProductAlias().getNo());
                if (Objects.isNull(contractGoodsDomian)) {
                    this.logger.info("\u540c\u6b65\u5386\u53f2\u8ba2\u5355-\u8ba2\u5355\u672a\u751f\u6210");
                    contractGoods = System.currentTimeMillis() + "";
                } else {
                    contractGoods = contractGoodsDomian.getContractGoodsCode();
                }
                OcRefundGoods ocContractGoods = new OcRefundGoods();
                ocContractGoods.setRefundCode(oc.getRefundCode());
                ocContractGoods.setContractGoodsCode(contractGoods);
                ocContractGoods.setContractBillcode(oc.getContractBillcode());
                ocContractGoods.setRefundGoodsCode(oc.getRefundCode() + "" + i);
                ocContractGoods.setSkuCode(skc);
                ocContractGoods.setSpuCode(spu);
                ocContractGoods.setSkuName(goods.getProduct().getValue());
                ocContractGoods.setGoodsName(goods.getProduct().getValue());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(spu);
                ocContractGoods.setGoodsCode(spu);
                ocContractGoods.setGoodsNo(spu);
                ocContractGoods.setSkuShowno(skc);
                ocContractGoods.setSkuNo(skc);
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setGoodsCamount(this.getBigDecimal(goods.getQty()));
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getType() + "");
                ocContractGoods.setRefundGoodsType(0);
                ocContractGoods.setGoodsNum(this.getBigDecimal(goods.getQty()));
                ocContractGoods.setContractGoodsInmoney(this.getBigDecimal(goods.getTot_amt_list()));
                ocContractGoods.setContractGoodsPefinmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(this.getBigDecimal("0"));
                ocContractGoods.setPricesetNprice(this.getBigDecimal(goods.getTot_amt_list()));
                ocContractGoods.setPricesetMakeprice(this.getBigDecimal(goods.getTot_amt_list()));
                ocContractGoods.setPricesetBaseprice(this.getBigDecimal(goods.getTot_amt_list()));
                ocContractGoods.setPricesetAsprice(this.getBigDecimal(goods.getTot_amt_actual()));
                ocContractGoods.setRefundGoodsNum(this.getBigDecimal(goods.getQty()));
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setRefundGoodsType(0);
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                goodsInMoney = goodsInMoney.add(this.getBigDecimal(goods.getTot_amt_list()));
                if (goods.getType() != 16 && goods.getType() != 64) {
                    ocContractGoods.setGoodsNum(this.getBigDecimal(goods.getQty()));
                    ocContractGoods.setRefundGoodsNum(this.getBigDecimal(goods.getQty()));
                } else {
                    ocContractGoods.setGoodsNum(this.getBigDecimal(1));
                    ocContractGoods.setRefundGoodsNum(this.getBigDecimal(1));
                }
                if (ocContractGoods.getGoodsNum().compareTo(BigDecimal.ZERO) == 0) {
                    ocContractGoods.setGoodsNum(this.getBigDecimal(1));
                    ocContractGoods.setRefundGoodsNum(this.getBigDecimal(1));
                }
                ocContractGoods.setContractGoodsPrice(this.getBigDecimal(goods.getTot_amt_actual()).divide(ocContractGoods.getGoodsNum()).setScale(2, 5));
                ocContractGoods.setContractGoodsMoney(this.getBigDecimal(goods.getTot_amt_actual()).divide(ocContractGoods.getGoodsNum()).setScale(2, 5));
                ocContractGoods.setRefundGoodsAmt(this.getBigDecimal(goods.getTot_amt_actual()).divide(ocContractGoods.getGoodsNum()).setScale(2, 5));
                ocContractGoods.setRefundGoodsPrice(this.getBigDecimal(goods.getTot_amt_actual()).divide(ocContractGoods.getGoodsNum()).setScale(2, 5));
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                list.add(ocContractGoods);
                totalNum = totalNum.add(ocContractGoods.getRefundGoodsNum());
            }
            oc.setContractMoney(goodsInMoney);
            oc.setContractPaymoney(goodsInMoney);
            oc.setRefundMoney(goodsMoney);
            oc.setGoodsNum(totalNum);
            oc.setRefundPmmoney(goodsInMoney.subtract(goodsMoney));
            oc.setOcRefundGoodsDomainList(list);
            oc.setDdTypeCurrency("1");
            return this.insertOcRefund(oc);
        }
        return null;
    }

    private String insertOcRefund(OcRefund oc) {
        this.logger.info("\u6dfb\u52a0\u9000\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
        return this.sendSaveRefund(oc);
    }

    public String sendSaveRefund(OcRefund ocRefundDomain) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)ocRefundDomain));
            Object o = this.getInternalRouter().inInvoke("oc.refundEngine.sendSaveRefund", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
            return (String)o;
        }
        catch (Exception e) {
            this.logger.info("\u4fdd\u5b58\u9000\u5355\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundDomain));
            e.printStackTrace();
            return null;
        }
    }

    private OcRefund saveTimingSynchronousRefundOrder(TimingSynchronousOrderDomain order, UmUserinfoModel umUserinfoModel, OrgDepart orgDepart) {
        OcRefund oc = new OcRefund();
        oc.setRefundCode(order.getDocno());
        oc.setContractBillcode(order.getOrgno());
        oc.setContractBbillcode(order.getOrgno());
        oc.setGoodsClass("pos");
        oc.setGoodsNum(this.getBigDecimal(0));
        oc.setDdTypeCurrency("1");
        if (!Objects.isNull(umUserinfoModel)) {
            oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
            oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
        }
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(storeMap));
            return null;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setDataOpnextbillstate(0);
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(disMap));
            return null;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType("00");
        oc.setContractTypepro(order.getStatusret() + "");
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(this.getBigDecimal("0"));
        oc.setContractPaymoney(this.getBigDecimal(0));
        oc.setContractMoney(this.getBigDecimal(order.getTot_amt_list()));
        oc.setRefundMoney(this.getBigDecimal(order.getTot_amt_actual()));
        oc.setRefundPmmoney(this.getBigDecimal(order.getTot_amt_list()).subtract(this.getBigDecimal(order.getTot_amt_actual())));
        oc.setRefundType("B01");
        oc.setGoodsLogmoney(this.getBigDecimal(0));
        Date date = this.yyyyMMddtoDate(order.getBilldate());
        if (date == null) {
            oc.setRefundDate(date);
        } else {
            oc.setRefundDate(order.getStatustime());
        }
        oc.setDataState(8);
        return oc;
    }

    private void checkPoint(OcContract ocContract) {
        Integer isSuccess;
        if (StringUtils.isNotBlank((String)ocContract.getMemberBcode()) && ((isSuccess = this.upmUpointsMapper.queryMemberPoints(ocContract.getMemberBcode(), "0", ocContract.getMemberCcode())) == null || isSuccess == 0)) {
            this.upmUpointsMapper.saveUpmUpoints(System.currentTimeMillis() + "", ocContract.getMemberBcode(), "0", ocContract.getMemberCcode());
        }
    }

    private void checkPoint(OcRefund ocContract) {
        Integer isSuccess;
        if (StringUtils.isNotBlank((String)ocContract.getMemberBcode()) && ((isSuccess = this.upmUpointsMapper.queryMemberPoints(ocContract.getMemberBcode(), "0", ocContract.getMemberCcode())) == null || isSuccess == 0)) {
            this.upmUpointsMapper.saveUpmUpoints(System.currentTimeMillis() + "", ocContract.getMemberBcode(), "0", ocContract.getMemberCcode());
        }
    }

    public Object insertUpmUpointsClear(UpmUpointsClear clear) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsClearDomain", JsonUtil.buildNormalBinder().toJson((Object)clear));
        Object departCode = this.getInternalRouter().inInvoke("upm.upointsClearBase.sendUpointsClear", pmap);
        return departCode;
    }

    private void timingSynchronousItemPayDetails(TimingSynchronousItempayDomain payitemDomain, String docno, String refundNo) {
        String value2_code;
        TimingSynchronousAttributeDomain attribute;
        String no;
        OcContractPayGoodsDetail ocContractPayDetail = new OcContractPayGoodsDetail();
        if (StringUtils.isBlank((String)refundNo)) {
            ocContractPayDetail.setContractBillcode(docno);
        } else {
            ocContractPayDetail.setRefundCode(refundNo);
        }
        ocContractPayDetail.setPayMoney(this.getBigDecimal(StringUtils.isNotBlank((String)payitemDomain.getPayamount()) ? payitemDomain.getPayamount() : "0"));
        ocContractPayDetail.setPaywayId(payitemDomain.getC_payway_id());
        ocContractPayDetail.setGmtCreate(DateUtils.parseDate((Date)new Date()));
        ocContractPayDetail.setGmtModified(DateUtils.parseDate((Date)new Date()));
        TimingSynchronousProductAliasDomain productAlias = payitemDomain.getProductAlias();
        if (!Objects.isNull(productAlias) && StringUtils.isNotBlank((String)(no = productAlias.getNo())) && !Objects.isNull(attribute = productAlias.getAttribute()) && StringUtils.isNotBlank((String)(value2_code = attribute.getValue2_code()))) {
            String sub = no + value2_code;
            ocContractPayDetail.setGoodsSku(sub);
        }
        int insert = this.ocContractPayGoodsDetailMapper.insert(ocContractPayDetail);
        this.logger.info("\u5546\u54c1\u652f\u4ed8\u662f\u5426\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)insert));
    }

    private void timingSynchronousPayDetails(TimingSynchronousPayitemDomain payitemDomain, String no, String refundNo) {
        OcContractPayDetail ocContractPayDetail = new OcContractPayDetail();
        if (StringUtils.isBlank((String)refundNo)) {
            ocContractPayDetail.setContractBillcode(no);
        } else {
            ocContractPayDetail.setRefundCode(refundNo);
        }
        ocContractPayDetail.setPayMoney(this.getBigDecimal(StringUtils.isNotBlank((String)payitemDomain.getPayamount()) ? payitemDomain.getPayamount() : "0"));
        ocContractPayDetail.setPaywayId(payitemDomain.getC_payway_id());
        if (!Objects.isNull(payitemDomain.getCard())) {
            ocContractPayDetail.setCardId(payitemDomain.getCard().getId() + "");
            ocContractPayDetail.setDiscountRate(this.getBigDecimal(payitemDomain.getCard().getDiscount()));
        }
        ocContractPayDetail.setGmtCreate(DateUtils.parseDate((Date)new Date()));
        ocContractPayDetail.setGmtModified(DateUtils.parseDate((Date)new Date()));
        this.ocContractPayDetailMapper.insert(ocContractPayDetail);
    }

    private void timingSynchronousSaveGuide(TimingSynchronousEmpsDomain tse, String contractBillcode) {
        TimingSynchronousEmpDomain emp = tse.getEmp();
        if (Objects.isNull(emp)) {
            this.logger.info("\u5bfc\u8d2d\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)tse));
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("userinfoChannelVaule", emp.getNo());
        hashMap.put("qualityCode", "dis");
        List<UmUserinfoChannel> query = this.umUserinfoChannelMapper.query(hashMap);
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("\u672a\u67e5\u8be2\u5bfc\u8d2d\uff1a{}" + emp.getNo());
            return;
        }
        UmUserinfoChannel umUserinfoChannel = query.get(0);
        umUserinfoChannel.setUserinfoChannelVaule2(tse.getDiscount());
        this.ocContractGuideMapper.insertContractGuide(umUserinfoChannel, contractBillcode);
    }

    private String saveTimingSynchronousGoods(OcContract oc, TimingSynchronousOrderDomain order) {
        if (Objects.isNull(oc)) {
            return null;
        }
        BigDecimal goodsMoney = new BigDecimal("0");
        BigDecimal goodsPrice = new BigDecimal("0");
        BigDecimal goodsInMoney = new BigDecimal("0");
        BigDecimal totalNum = new BigDecimal("0");
        ArrayList<OcContractGoods> goods = new ArrayList<OcContractGoods>();
        int i = 0;
        for (TimingSynchronousItemDomain item : order.getItem()) {
            ++i;
            item.setTot_amt_actual("0");
            List<TimingSynchronousItempayDomain> itempay = order.getItempay();
            if (!CollectionUtils.isEmpty(itempay)) {
                this.logger.info("\u6253\u5370\u65e5\u5fd7itempay\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(itempay));
                List collect = itempay.stream().filter(pay -> pay != null && pay.getM_retailitem_id().toString().equals(item.getId().toString())).collect(Collectors.toList());
                this.logger.info("\u6253\u5370\u65e5\u5fd7collect\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(collect));
                if (!CollectionUtils.isEmpty(collect)) {
                    for (TimingSynchronousItempayDomain itempayDomain : collect) {
                        Integer c_payway_id = itempayDomain.getC_payway_id();
                        if (c_payway_id == 64 || c_payway_id == 65) {
                            TimingSynchronousCardDomain cardDomain = itempayDomain.getCard();
                            if (cardDomain != null) {
                                String discount = cardDomain.getDiscount();
                                BigDecimal beginMoney = this.getBigDecimal(itempayDomain.getPayamount());
                                this.logger.info("\u6253\u5370\u91d1\u989d\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)beginMoney));
                                BigDecimal discountRatio = this.getBigDecimal(discount).divide(new BigDecimal(100)).setScale(4, 4);
                                this.logger.info("\u6253\u5370\u7a0e\u7387\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)discountRatio));
                                BigDecimal money = beginMoney.multiply(discountRatio);
                                item.setTot_amt_actual(money.add(this.getBigDecimal(item.getTot_amt_actual())).toString());
                                goodsMoney = goodsMoney.add(money);
                                itempayDomain.setPayamount(money.toString());
                                this.logger.info("\u6253\u5370\u8ba1\u7b97\u540e\u7684\u91d1\u989d22\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goodsMoney));
                            } else {
                                this.logger.info("\u5361\u53f7\u4e3a\u7a7a");
                            }
                        }
                        if (c_payway_id != 27) continue;
                        item.setTot_amt_actual(this.getBigDecimal(itempayDomain.getPayamount()).add(this.getBigDecimal(item.getTot_amt_actual())).toString());
                        goodsMoney = goodsMoney.add(this.getBigDecimal(itempayDomain.getPayamount()));
                        this.logger.info("\u6253\u5370\u8ba1\u7b97\u540e\u7684\u91d1\u989d\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goodsMoney));
                    }
                }
            }
            String skc = item.getProduct().getName();
            String spu = item.getProductAlias().getNo().substring(0, item.getProductAlias().getNo().indexOf(item.getProductAlias().getAttribute().getValue1()));
            String goodsName = item.getProduct().getValue();
            OcContractGoods ocContractGoods = new OcContractGoods();
            ocContractGoods.setContractBillcode(oc.getContractBillcode());
            ocContractGoods.setContractGoodsCode(oc.getContractBillcode() + "" + i);
            ocContractGoods.setSkuCode(skc);
            ocContractGoods.setSpuCode(spu);
            ocContractGoods.setSkuName(goodsName);
            ocContractGoods.setGoodsName(goodsName);
            ocContractGoods.setMemberBcode(oc.getMemberBcode());
            ocContractGoods.setMemberBname(oc.getMemberBname());
            ocContractGoods.setMemberMcode(oc.getMemberMcode());
            ocContractGoods.setMemberMname(oc.getMemberMname());
            ocContractGoods.setMemberCode(oc.getMemberCode());
            ocContractGoods.setMemberName(oc.getMemberName());
            ocContractGoods.setMemberCcode(oc.getMemberCcode());
            ocContractGoods.setMemberCname(oc.getMemberCname());
            ocContractGoods.setGoodsShowno(spu);
            ocContractGoods.setGoodsNo(spu);
            ocContractGoods.setGoodsCode(spu);
            ocContractGoods.setSkuShowno(skc);
            ocContractGoods.setSkuNo(skc);
            ocContractGoods.setContractGoodsType(0);
            ocContractGoods.setChannelCode(oc.getChannelCode());
            ocContractGoods.setChannelName(oc.getChannelName());
            ocContractGoods.setGoodsCamount(this.getBigDecimal(item.getQty()));
            ocContractGoods.setGoodsClass("pos");
            ocContractGoods.setGoodsPro("0");
            ocContractGoods.setGoodsType(item.getType() + "");
            ocContractGoods.setContractGoodsInmoney(this.getBigDecimal(item.getTot_amt_list()));
            goodsInMoney = goodsInMoney.add(this.getBigDecimal(item.getTot_amt_list()));
            ocContractGoods.setContractGoodsPefinmoney(this.getBigDecimal("0"));
            ocContractGoods.setContractGoodsPefmoney(this.getBigDecimal("0"));
            ocContractGoods.setContractGoodsPefprice(this.getBigDecimal("0"));
            ocContractGoods.setPricesetNprice(this.getBigDecimal(item.getTot_amt_list()));
            ocContractGoods.setPricesetMakeprice(this.getBigDecimal(item.getTot_amt_list()));
            ocContractGoods.setPricesetBaseprice(this.getBigDecimal(item.getTot_amt_list()));
            ocContractGoods.setContractGoodsSendnum(this.getBigDecimal(item.getQty()));
            ocContractGoods.setGmtCreate(new Date());
            ocContractGoods.setGmtModified(new Date());
            ocContractGoods.setDataOpbillstate(0);
            ocContractGoods.setDataState(0);
            ocContractGoods.setContractGoodsGtype("0");
            ocContractGoods.setTenantCode(oc.getTenantCode());
            ocContractGoods.setGoodsClass(oc.getGoodsClass());
            ocContractGoods.setRefundFlag(0);
            if (item.getType() != 16) {
                ocContractGoods.setGoodsNum(this.getBigDecimal(item.getQty()));
            } else {
                ocContractGoods.setGoodsNum(this.getBigDecimal(1));
            }
            ocContractGoods.setContractGoodsPrice(this.getBigDecimal(item.getTot_amt_actual()).divide(ocContractGoods.getGoodsNum(), 2, 4).setScale(2, 5));
            ocContractGoods.setContractGoodsMoney(this.getBigDecimal(item.getTot_amt_actual()).divide(ocContractGoods.getGoodsNum(), 2, 4).setScale(2, 5));
            if (ocContractGoods.getContractGoodsPrice().compareTo(this.getBigDecimal("0")) == 0) {
                ocContractGoods.setContractGoodsRefnum(this.getBigDecimal(item.getQty()));
                ocContractGoods.setRefundFlag(1);
            }
            goodsPrice = goodsPrice.add(ocContractGoods.getContractGoodsMoney());
            this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
            goods.add(ocContractGoods);
            totalNum = totalNum.add(ocContractGoods.getGoodsNum());
        }
        this.logger.info("goodsMoney=" + goodsMoney + "  goodsInMoney=" + goodsInMoney + " goodsPrice=" + goodsPrice);
        oc.setContractMoney(goodsMoney);
        oc.setGoodsMoney(goodsPrice);
        oc.setDataBmoney(goodsMoney);
        oc.setGoodsNum(totalNum);
        oc.setDataBnum(totalNum);
        oc.setGoodsPmoney(oc.getContractInmoney().subtract(goodsMoney));
        OcPackage ocPackageDomain = this.savePackage(oc, goodsPrice, goodsInMoney);
        this.checkMoney(oc, goods, ocPackageDomain);
        ocPackageDomain.setContractGoodsList(goods);
        oc.setGoodsList(goods);
        oc.setContractGoodsList(goods);
        oc.setPackageList(Arrays.asList(ocPackageDomain));
        return this.insertContract(oc);
    }

    private void checkMoney(OcContract oc, List<OcContractGoods> goods, OcPackage ocPackageDomain) {
        if (ocPackageDomain.getGoodsMoney().compareTo(BigDecimal.ZERO) == 0 && oc.getContractInmoney().compareTo(BigDecimal.ZERO) != 0) {
            oc.setContractInmoney(BigDecimal.ZERO);
        }
    }

    private OcPackage savePackage(OcContract ocContract, BigDecimal goodsMoney, BigDecimal goodsInMoney) {
        OcPackage ocPackageDomain = new OcPackage();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)ocContract);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BigDecimal goodsPmoney = ocPackageDomain.getGoodsPmoney();
        String goodsPmbillno = ocPackageDomain.getGoodsPmbillno();
        BigDecimal goodsWeight = ocPackageDomain.getGoodsWeight();
        BigDecimal goodsNum = ocPackageDomain.getGoodsNum();
        String areaCode = ocPackageDomain.getAreaCode();
        String areaName = ocPackageDomain.getAreaName();
        String warehouseName = ocPackageDomain.getWarehouseName();
        String warehouseCode = ocPackageDomain.getWarehouseCode();
        String contractPumode = ocPackageDomain.getContractPumode();
        if (StringUtils.isNotBlank((String)contractPumode)) {
            ocPackageDomain.setContractPumode(contractPumode);
        }
        ocPackageDomain.setContractBillcode(ocContract.getContractBillcode());
        ocPackageDomain.setTenantCode(ocContract.getTenantCode());
        ocPackageDomain.setGoodsMoney(goodsInMoney);
        ocPackageDomain.setGoodsInmoney(goodsMoney);
        ocPackageDomain.setGoodsPmoney(goodsPmoney);
        ocPackageDomain.setGoodsPmbillno(goodsPmbillno);
        ocPackageDomain.setGoodsWeight(goodsWeight);
        ocPackageDomain.setGoodsNum(goodsNum);
        ocPackageDomain.setAreaCode(areaCode);
        ocPackageDomain.setAreaName(areaName);
        ocPackageDomain.setWarehouseCode(warehouseCode);
        ocPackageDomain.setWarehouseName(warehouseName);
        ocPackageDomain.setMemberBcode(ocContract.getMemberBcode());
        ocPackageDomain.setMemberBname(ocContract.getMemberBname());
        ocPackageDomain.setMemberCode(ocContract.getMemberCode());
        ocPackageDomain.setMemberName(ocContract.getMemberName());
        return ocPackageDomain;
    }

    private String insertContract(OcContract oc) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)oc));
            this.logger.info("\u6253\u5370\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)oc));
            Object o = this.getInternalRouter().inInvoke("oc.contract.sendsaveContract", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
            return (String)o;
        }
        catch (Exception e) {
            this.logger.info("\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
            e.printStackTrace();
            return null;
        }
    }

    private OcContract saveTimingSynchronousOrder(TimingSynchronousOrderDomain order, UmUserinfoModel umUserinfoModel, OrgDepart orgDepart) {
        OcContract ocContract = new OcContract();
        ocContract.setDataState(5);
        ocContract.setContractBillcode(order.getDocno());
        ocContract.setContractBbillcode(order.getDocno());
        if (!Objects.isNull(umUserinfoModel)) {
            ocContract.setMemberBcode(umUserinfoModel.getUserinfoCode());
            ocContract.setMemberBname(umUserinfoModel.getUserinfoCompname());
        }
        ocContract.setGoodsClass("pos");
        ocContract.setGoodsNum(this.getBigDecimal(0));
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(storeMap));
            return null;
        }
        UmUserinfoModel store = storeList.get(0);
        ocContract.setMemberCode(store.getUserinfoCode());
        ocContract.setMemberName(store.getUserinfoCompname());
        ocContract.setMschannelCode(store.getUserinfoCode());
        ocContract.setMschannelName(store.getUserinfoCompname());
        ocContract.setChannelCode(store.getUserinfoCode());
        ocContract.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(disMap));
            return null;
        }
        DisChannel disChannel = disChannelList.get(0);
        ocContract.setMemberCcode(disChannel.getMemberCode());
        ocContract.setMemberMcode(disChannel.getMemberCode());
        ocContract.setMemberMname(disChannel.getMemberName());
        ocContract.setMemberCname(disChannel.getMemberName());
        ocContract.setTenantCode(disChannel.getTenantCode());
        ocContract.setContractType("00");
        ocContract.setContractTypepro(order.getStatusret() + "");
        ocContract.setContractBlance("0");
        ocContract.setContractPmode("1");
        ocContract.setContractPumode("0");
        ocContract.setContractPumode("0");
        ocContract.setGoodsWeight(this.getBigDecimal("0"));
        ocContract.setPricesetRefrice(this.getBigDecimal(0));
        ocContract.setContractPaymoney(this.getBigDecimal(order.getTot_amt_list()));
        ocContract.setContractInmoney(this.getBigDecimal(order.getTot_amt_list()));
        ocContract.setContractMoney(this.getBigDecimal(order.getTot_amt_actual()));
        ocContract.setGoodsMoney(this.getBigDecimal(order.getTot_amt_actual()));
        ocContract.setDataBmoney(this.getBigDecimal(order.getTot_amt_actual()));
        ocContract.setDataBweight(this.getBigDecimal(0));
        ocContract.setContractShow(0);
        ocContract.setContractEcflag(0);
        ocContract.setContractInvstate(0);
        ocContract.setGoodsLogmoney(this.getBigDecimal(0));
        Date date = this.yyyyMMddtoDate(order.getBilldate());
        if (date != null) {
            ocContract.setContractPaydate(date);
        } else {
            ocContract.setContractPaydate(order.getStatustime());
        }
        ocContract.setRefundFlag(0);
        ocContract.setGoodsPmoney(ocContract.getContractInmoney().subtract(ocContract.getDataBmoney()));
        return ocContract;
    }

    public Date yyyyMMddtoDate(String args) {
        try {
            Date date = DateUtils.parseDate((String)args, (String)"yyyyMMdd");
            Date date1 = DateUtils.parseDate((String)(DateUtils.parseDate((Date)date) + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            return date1;
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return null;
        }
    }

    @Override
    public void synchronousOrder(String startDate, String endDate) {
        try {
            Date begin = DateUtils.parseDate((String)startDate, (String)"yyyyMMdd");
            String beginStr = DateUtils.parseDateToString((Date)begin, (String)"yyyy-MM-dd HH:mm:ss");
            Date out = DateUtils.parseDate((String)endDate, (String)"yyyyMMdd");
            String outStr = DateUtils.parseDateToString((Date)out, (String)"yyyy-MM-dd 23:59:59");
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)(startDate + "---" + endDate)));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)(beginStr + "---" + outStr)));
            List<PosOrder> init = PosConnetUtils.init(startDate, endDate);
            List<PosGoods> initGoods = PosConnetUtils.initGoods(startDate, endDate);
            List<PosGoodsPayDetails> initGoodsPayDetail = PosConnetUtils.initGoodsPayDetail(beginStr, outStr);
            List<PosGuide> initGuide = PosConnetUtils.initGuide(beginStr, outStr);
            List<PosContractPayDetails> initContractPayDetail = PosConnetUtils.initContractPayDetail(beginStr, outStr);
            this.logger.info("\u6253\u5370\u6570\u636e\u6570\u91cf\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)init.size()));
            this.logger.info("\u6253\u5370\u5546\u54c1\u6570\u636e\u6570\u91cf\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)initGoods.size()));
            this.logger.info("\u6253\u5370\u652f\u4ed8\u8be6\u60c5\u6570\u636e\u6570\u91cf\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)initGoodsPayDetail.size()));
            this.logger.info("\u6253\u5370\u5bfc\u8d2d\u6570\u636e\u6570\u91cf\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)initGuide.size()));
            if (!CollectionUtils.isEmpty(init)) {
                init.stream().forEach(pos -> {
                    try {
                        if (this.addOcContract((PosOrder)pos, initGoods)) {
                            this.addGuide((PosOrder)pos, initGuide);
                            this.addOcContractDetail((PosOrder)pos, initContractPayDetail);
                            this.addGoodsPayDetail((PosOrder)pos, initGoodsPayDetail);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (SQLException | ParseException throwables) {
            throwables.printStackTrace();
        }
    }

    private boolean addOcRefundContract(PosOrder pos, List<PosGoods> initGoods) throws ParseException {
        OcRefund oc = new OcRefund();
        oc.setRefundCode(pos.getRefundCode());
        oc.setContractBillcode(pos.getContractBillcode());
        oc.setContractBbillcode(pos.getContractBillcode());
        oc.setGoodsNum(this.getBigDecimal(pos.getGoodsNum()));
        oc.setGoodsClass(pos.getGoodsClass());
        oc.setDdTypeCurrency("0");
        oc.setTenantCode("2022012800000001");
        if (StringUtils.isNotBlank((String)pos.getUserinfoOcode())) {
            HashMap<String, Object> umInfoMap = new HashMap<String, Object>();
            umInfoMap.put("userinfoOcode", pos.getUserinfoOcode());
            umInfoMap.put("userinfoQuality", "buy");
            List<UmUserinfoModel> query = this.umUserinfoMapper.query(umInfoMap);
            if (!CollectionUtils.isEmpty(query)) {
                UmUserinfoModel umUserinfoModel = query.get(0);
                oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
                oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
            }
        }
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put("departOcode", pos.getStoreCode());
        List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
        if (CollectionUtils.isEmpty(orgDepartList)) {
            this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        OrgDepart orgDepart = orgDepartList.get(0);
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setDataOpnextbillstate(0);
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType(pos.getContractType());
        oc.setContractTypepro(pos.getContractType());
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(this.getBigDecimal("0"));
        oc.setContractPaymoney(this.getBigDecimal(0));
        oc.setContractMoney(this.getBigDecimal(pos.getGoodsMoney()));
        oc.setRefundMoney(this.getBigDecimal(pos.getDataBmoney()));
        oc.setRefundPmmoney(this.getBigDecimal(pos.getGoodsMoney()).subtract(this.getBigDecimal(pos.getDataBmoney())));
        oc.setDataStatestr(pos.getDataState());
        oc.setRefundType("B01");
        oc.setGoodsLogmoney(this.getBigDecimal(0));
        oc.setGmtCreate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setGmtModified(DateUtils.parseDate((String)pos.getGmtModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setRefundDate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setDataState(8);
        return this.addRefundGoods(pos, oc, initGoods);
    }

    private boolean addRefundGoods(PosOrder pos, OcRefund oc, List<PosGoods> posGoodsList) {
        if (Objects.isNull(oc)) {
            return false;
        }
        List posGoods = null;
        try {
            posGoods = posGoodsList.stream().filter(po -> po.getOrderId().equals(pos.getOrderId())).collect(Collectors.toList());
        }
        catch (Exception throwables) {
            throwables.printStackTrace();
        }
        this.logger.info("\u6253\u5370goodsList\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(posGoods));
        ArrayList<OcRefundGoods> list = new ArrayList<OcRefundGoods>();
        if (!CollectionUtils.isEmpty(posGoods)) {
            for (PosGoods goods : posGoods) {
                String goodsSkc = goods.getGoodsSkc();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("skc", goodsSkc);
                hashMap.put("page", 0);
                hashMap.put("rows", 1);
                List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) {
                    this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                }
                CdpGoods cdpGoods = query.get(0);
                String contractGoods = "";
                OcContractGoods contractGoodsDomian = this.ocContractGoodsMapper.getContractGoodsByContractBillcodeAndSkuCode(oc.getContractBillcode(), goods.getGoodsSku());
                if (Objects.isNull(contractGoodsDomian)) {
                    this.logger.info("\u5b9a\u65f6\u540c\u6b65-\u8ba2\u5355\u672a\u751f\u6210");
                    contractGoods = System.currentTimeMillis() + "";
                } else {
                    contractGoods = contractGoodsDomian.getContractGoodsCode();
                }
                BigDecimal goodsNum = this.getBigDecimal(goods.getGoodsNum()).compareTo(new BigDecimal(0)) == 0 ? new BigDecimal(1) : this.getBigDecimal(goods.getGoodsNum());
                OcRefundGoods ocContractGoods = new OcRefundGoods();
                ocContractGoods.setContractGoodsCode(contractGoods);
                ocContractGoods.setContractBillcode(pos.getContractBillcode());
                ocContractGoods.setSkuCode(goods.getGoodsSku());
                ocContractGoods.setSpuCode(goods.getGoodsSkc());
                ocContractGoods.setSkuName(cdpGoods.getArticleName());
                ocContractGoods.setGoodsName(cdpGoods.getArticleName());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(goods.getGoodsSkc());
                ocContractGoods.setGoodsNo(goods.getGoodsSkc());
                ocContractGoods.setGoodsCode(goods.getGoodsSkc());
                ocContractGoods.setSkuShowno(goods.getGoodsSku());
                ocContractGoods.setSkuNo(goods.getGoodsSku());
                ocContractGoods.setTenantCode("2022012800000001");
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setGoodsCamount(goodsNum);
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getGoodType());
                ocContractGoods.setGoodsNum(goodsNum);
                ocContractGoods.setRefundGoodsAmt(this.getBigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setContractGoodsPrice(this.getBigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setContractGoodsMoney(this.getBigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setContractGoodsInmoney(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setContractGoodsPefinmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(this.getBigDecimal("0"));
                ocContractGoods.setPricesetNprice(this.getBigDecimal(goods.getGoodsMakePrice()));
                ocContractGoods.setPricesetMakeprice(this.getBigDecimal(goods.getGoodsMakePrice()));
                ocContractGoods.setPricesetBaseprice(this.getBigDecimal(goods.getGoodsMakePrice()));
                ocContractGoods.setPricesetAsprice(this.getBigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setRefundGoodsNum(goodsNum);
                ocContractGoods.setDataPic(cdpGoods.getImgPath());
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setRefundGoodsType(Integer.parseInt(goods.getGoodType()));
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setRefundGoodsCode(System.currentTimeMillis() + "");
                ocContractGoods.setRefundCode(pos.getRefundCode());
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                list.add(ocContractGoods);
            }
            oc.setGoodsNum(this.getBigDecimal(posGoods.size()));
            oc.setOcRefundGoodsDomainList(list);
            String s = this.insertOcRefund(oc);
            return StringUtils.isNotBlank((String)s);
        }
        return false;
    }

    private void addRefundGoodsPayDetail(PosOrder pos) {
        List<PosGoodsPayDetails> list = null;
        try {
            list = PosConnetUtils.initGoodsPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getGoodsPayDetails(list);
        for (OcContractPayDetail posGoodsPayDetails : arr) {
            posGoodsPayDetails.setRefundCode(pos.getRefundCode());
            posGoodsPayDetails.setPayMoney(posGoodsPayDetails.getPayMoney());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayGoodsDetailMapper.insertBatch(arr);
    }

    private int addOcRefund(OcRefund oc) {
        this.logger.info("\u6253\u5370\u9000\u5355\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
        return this.ocRefundMapper.insert(oc);
    }

    private void sendRefundGoods(OcRefundGoods ocContractGoods) {
        this.ocRefundGoodsMapper.insert(ocContractGoods);
    }

    @Override
    public void synchronousCdpImsGoods() throws SQLException, ParseException {
        this.deletePosGoods();
        this.logger.info("\u6253\u5370\u957f\u5ea6\uff1a{}");
    }

    private void deletePosGoods() {
        this.cdpGoodsMapper.delete();
    }

    private List<CdpGoods> getCdpGoods() {
        int rows = 2000;
        long total = 0L;
        int index = 0;
        ArrayList<CdpGoods> arr = new ArrayList<CdpGoods>();
        int page = index * rows;
        while ((long)page <= total) {
            this.logger.info("\u6253\u5370page\uff1a" + page + " total:" + total);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("page", page);
            map.put("rows", rows);
            List<CdpGoods> list = this.cdpGoodsMapper.query(map);
            if (null == list) break;
            if (page == 0) {
                total = this.cdpGoodsMapper.count(map);
            }
            page = (index + 1) * rows;
            ++index;
            arr.addAll(list);
        }
        return arr;
    }

    private boolean addGoods(PosOrder pos, OcContract oc, List<PosGoods> posGoodList) {
        if (Objects.isNull(oc)) {
            return false;
        }
        List posGoods = posGoodList.stream().filter(good -> good.getOrderId().equals(pos.getOrderId())).collect(Collectors.toList());
        this.logger.info("\u83b7\u53d6\u7684\u8ba2\u5355\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(posGoods));
        BigDecimal goodsMoney = new BigDecimal("0");
        BigDecimal goodsInMoney = new BigDecimal("0");
        if (!CollectionUtils.isEmpty(posGoods)) {
            ArrayList<OcContractGoods> list = new ArrayList<OcContractGoods>();
            for (PosGoods goods : posGoods) {
                String goodsSkc = goods.getGoodsSkc();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("skc", goodsSkc);
                hashMap.put("page", 0);
                hashMap.put("rows", 1);
                List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) {
                    this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                }
                CdpGoods cdpGoods = query.get(0);
                OcContractGoods ocContractGoods = new OcContractGoods();
                ocContractGoods.setContractBillcode(pos.getContractBillcode());
                ocContractGoods.setSkuCode(goods.getGoodsSku());
                ocContractGoods.setSpuCode(goods.getGoodsSkc());
                ocContractGoods.setSkuName(cdpGoods.getArticleName());
                ocContractGoods.setGoodsName(cdpGoods.getArticleName());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(goods.getGoodsSkc());
                ocContractGoods.setGoodsNo(goods.getGoodsSkc());
                ocContractGoods.setSkuNo(goods.getGoodsSku());
                ocContractGoods.setGoodsCode(goods.getGoodsSkc());
                ocContractGoods.setSkuShowno(goods.getGoodsSku());
                ocContractGoods.setSkuNo(goods.getGoodsSku());
                ocContractGoods.setTenantCode("2022012800000001");
                ocContractGoods.setContractGoodsType(0);
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setChannelCode(oc.getChannelCode());
                ocContractGoods.setChannelName(oc.getChannelName());
                ocContractGoods.setGoodsCamount(this.getBigDecimal(goods.getGoodsNum()));
                ocContractGoods.setGoodsClass("pos");
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getGoodType());
                goodsMoney = goodsMoney.add(this.getBigDecimal(goods.getContractNPrice()));
                goodsInMoney = goodsInMoney.add(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setContractGoodsPrice(this.getBigDecimal(goods.getContractNPrice()));
                ocContractGoods.setContractGoodsMoney(this.getBigDecimal(goods.getContractNPrice()));
                ocContractGoods.setContractGoodsInmoney(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setContractGoodsPefinmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(this.getBigDecimal("0"));
                ocContractGoods.setPricesetNprice(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setPricesetMakeprice(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setPricesetBaseprice(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setPricesetAsprice(this.getBigDecimal(goods.getContractNPrice()));
                ocContractGoods.setContractGoodsSendnum(this.getBigDecimal(goods.getGoodsNum()));
                ocContractGoods.setDataPic(cdpGoods.getImgPath());
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setRefundFlag(0);
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setContractGoodsCode(System.currentTimeMillis() + "");
                ocContractGoods.setPackageCode(System.currentTimeMillis() + "");
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                if (!ocContractGoods.getGoodsType().equals("16")) {
                    ocContractGoods.setGoodsNum(this.getBigDecimal(goods.getGoodsNum()));
                    oc.setGoodsNum(oc.getGoodsNum().add(this.getBigDecimal(goods.getGoodsNum())));
                } else {
                    oc.setGoodsNum(oc.getGoodsNum().add(this.getBigDecimal(1)));
                    ocContractGoods.setGoodsNum(this.getBigDecimal(1));
                }
                if (ocContractGoods.getContractGoodsPrice().compareTo(this.getBigDecimal("0")) == 0) {
                    ocContractGoods.setContractGoodsRefnum(this.getBigDecimal(goods.getGoodsNum()));
                    ocContractGoods.setRefundFlag(1);
                }
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                list.add(ocContractGoods);
            }
            oc.setGoodsList(list);
            oc.setContractGoodsList(list);
            oc.setContractMoney(goodsMoney);
            oc.setGoodsMoney(goodsMoney);
            oc.setDataBmoney(goodsMoney);
            oc.setPackageList(Arrays.asList(this.savePackage(oc, goodsMoney, goodsInMoney)));
            return this.saveOcContract(oc);
        }
        return false;
    }

    private void addGoodsPayDetail(PosOrder pos, List<PosGoodsPayDetails> payDetailsList) {
        List<PosGoodsPayDetails> list = payDetailsList.stream().filter(payDetails -> payDetails.getOrderId().equals(pos.getOrderId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getGoodsPayDetails(list);
        for (OcContractPayDetail posGoodsPayDetails : arr) {
            posGoodsPayDetails.setContractBillcode(pos.getContractBillcode());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayGoodsDetailMapper.insertBatch(arr);
    }

    private List<OcContractPayDetail> getGoodsPayDetails(List<PosGoodsPayDetails> list) {
        ArrayList<OcContractPayDetail> arr = new ArrayList<OcContractPayDetail>();
        for (PosGoodsPayDetails contractPayDetails : list) {
            OcContractPayDetail oc = new OcContractPayDetail();
            try {
                BeanUtils.copyAllPropertys((Object)oc, (Object)contractPayDetails);
                arr.add(oc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    private void addOcRefundDetail(PosOrder pos, List<PosContractPayDetails> initContractPayDetail) {
        List<PosContractPayDetails> list = initContractPayDetail.stream().filter(init -> init.getOrderId().equals(pos.getOrderId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getOcContractPayDetails(list);
        for (OcContractPayDetail posContractPayDetails : arr) {
            posContractPayDetails.setRefundCode(pos.getRefundCode());
            posContractPayDetails.setPayMoney(posContractPayDetails.getPayMoney());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u8ba2\u5355\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayDetailMapper.insertBatch(arr);
    }

    private void addOcContractDetail(PosOrder pos, List<PosContractPayDetails> payDetailsList) {
        List<PosContractPayDetails> list = payDetailsList.stream().filter(payDetails -> payDetails.getOrderId().equals(pos.getOrderId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getOcContractPayDetails(list);
        for (OcContractPayDetail ocContractPayDetail : arr) {
            ocContractPayDetail.setContractBillcode(pos.getContractBillcode());
            ocContractPayDetail.setRefundCode(pos.getRefundCode());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u8ba2\u5355\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayDetailMapper.insertBatch(arr);
    }

    private List<OcContractPayDetail> getOcContractPayDetails(List<PosContractPayDetails> list) {
        ArrayList<OcContractPayDetail> arr = new ArrayList<OcContractPayDetail>();
        for (PosContractPayDetails contractPayDetails : list) {
            OcContractPayDetail oc = new OcContractPayDetail();
            try {
                BeanUtils.copyAllPropertys((Object)oc, (Object)contractPayDetails);
                arr.add(oc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    private boolean saveOcContract(OcContract oc) {
        oc.setGoodsPmoney(oc.getContractInmoney().subtract(oc.getDataBmoney()));
        String s = this.insertContract(oc);
        return !StringUtils.isBlank((String)s);
    }

    public void sendSaveResourceGoods(OcContractGoods ocContractGoodsDomain) {
        this.ocContractGoodsMapper.insert(ocContractGoodsDomain);
    }

    private void addGuide(PosOrder pos, List<PosGuide> guideList) {
        List list = guideList.stream().filter(posGuide -> posGuide.getOrderId().equals(pos.getOrderId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<UmUserinfoChannel> arr = new ArrayList<UmUserinfoChannel>();
            for (PosGuide str : list) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("userinfoChannelVaule", str.getGuideCode());
                hashMap.put("qualityCode", "dis");
                List<UmUserinfoChannel> query = this.umUserinfoChannelMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) continue;
                UmUserinfoChannel umUserinfoChannel = query.get(0);
                umUserinfoChannel.setUserinfoChannelVaule2(str.getDiscount());
                arr.add(umUserinfoChannel);
            }
            this.logger.info("\u6dfb\u52a0\u5bfc\u8d2d");
            if (!CollectionUtils.isEmpty(arr)) {
                for (UmUserinfoChannel umUserinfoChannel : arr) {
                    this.ocContractGuideMapper.insertContractGuide(umUserinfoChannel, pos.getContractBillcode());
                }
            }
        }
    }

    private boolean addOcContract(PosOrder pos, List<PosGoods> posGoods) throws ParseException {
        OcContract oc = new OcContract();
        oc.setContractBillcode(pos.getContractBillcode());
        oc.setContractBbillcode(pos.getContractBillcode());
        oc.setGoodsNum(this.getBigDecimal(pos.getGoodsNum()));
        oc.setGoodsClass(pos.getGoodsClass());
        oc.setTenantCode("2022012800000001");
        oc.setGoodsPbillno("0");
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put("departOcode", pos.getStoreCode());
        List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
        if (CollectionUtils.isEmpty(orgDepartList)) {
            this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return false;
        }
        OrgDepart orgDepart = orgDepartList.get(0);
        if (StringUtils.isNotBlank((String)pos.getUserinfoOcode())) {
            HashMap<String, Object> umInfoMap = new HashMap<String, Object>();
            umInfoMap.put("userinfoOcode", pos.getUserinfoOcode());
            umInfoMap.put("userinfoQuality", "buy");
            List<UmUserinfoModel> query = this.umUserinfoMapper.query(umInfoMap);
            if (!CollectionUtils.isEmpty(query)) {
                UmUserinfoModel umUserinfoModel = query.get(0);
                oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
                oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
                HashMap<String, Object> infochannelMap = new HashMap<String, Object>();
                infochannelMap.put("userinfoCode", umUserinfoModel.getUserinfoCode());
                infochannelMap.put("channelCode", orgDepart.getCompanyCode());
                List<UmUserinfoChannel> umUserinfoChannelList = this.umUserinfoChannelMapper.query(infochannelMap);
                if (CollectionUtils.isEmpty(umUserinfoChannelList)) {
                    this.createBrandUser(umUserinfoModel, orgDepart);
                }
            }
        }
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return false;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setMschannelCode(store.getUserinfoCode());
        oc.setMschannelName(store.getUserinfoCompname());
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return false;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType("00");
        oc.setContractTypepro(pos.getContractType());
        oc.setContractBlance("0");
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(this.getBigDecimal("0"));
        oc.setPricesetRefrice(this.getBigDecimal(0));
        oc.setDataBnum(this.getBigDecimal(pos.getGoodsNum()));
        oc.setGoodsNum(this.getBigDecimal(pos.getGoodsNum()));
        oc.setDataBweight(this.getBigDecimal(0));
        oc.setContractPaymoney(this.getBigDecimal(pos.getGoodsMoney()));
        oc.setContractInmoney(this.getBigDecimal(pos.getGoodsMoney()));
        oc.setContractMoney(this.getBigDecimal(pos.getDataBmoney()));
        oc.setGoodsMoney(this.getBigDecimal(pos.getDataBmoney()));
        oc.setDataBmoney(this.getBigDecimal(pos.getDataBmoney()));
        oc.setContractShow(0);
        oc.setContractEcflag(0);
        oc.setContractInvstate(0);
        oc.setGoodsLogmoney(this.getBigDecimal(0));
        oc.setGmtCreate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setGmtModified(DateUtils.parseDate((String)pos.getGmtModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setContractPaydate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setDataState(5);
        oc.setRefundFlag(0);
        return this.addGoods(pos, oc, posGoods);
    }

    public GoodsCategoryVO queryGoodCategory(Map map) {
        List<GoodsCategoryVO> goodsCategoryVOList = this.cdpGoodsMapper.queryGoodCategories(map);
        if (goodsCategoryVOList != null && goodsCategoryVOList.size() > 0) {
            return goodsCategoryVOList.get(0);
        }
        return null;
    }

    @Override
    public String queryImage(Map<String, Object> map) {
        String goodsImage = this.cdpGoodsMapper.queryGoodsImage(map);
        if (goodsImage != null && StringUtils.isNotBlank((String)goodsImage)) {
            return goodsImage;
        }
        return "";
    }

    @Override
    public void saveImage(Map<String, Object> map) {
        this.cdpGoodsMapper.saveGoodsImage(map);
    }

    private BigDecimal getBigDecimal(String money) {
        if (StringUtils.isNotBlank((String)money)) {
            return new BigDecimal(money).abs();
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getBigDecimal(Integer money) {
        if (money != null) {
            return new BigDecimal(money).abs();
        }
        return BigDecimal.ZERO;
    }

    private void pushCdpUserData(String userinfoCode) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("map", JsonUtil.buildNormalBinder().toJson((Object)ImmutableMap.of((Object)"userInfoCode", (Object)userinfoCode, (Object)"qd", (Object)"POS")));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)userinfoCode));
            Object o = this.getInternalRouter().inInvoke("zyCdp.txtend.infoCalculation", pmap);
            this.logger.info("\u63a8\u9001\u6570\u636e\u5230cdp\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
        }
        catch (Exception e) {
            this.logger.info("\u63a8\u9001\u6570\u636e\u5230cdp\u62a5\u9519");
            e.printStackTrace();
        }
    }

    @Override
    public void timingPosRefundOrder(Map<String, Object> map) {
        URI uri = null;
        try {
            String byCode = this.cdpOpenApiUrlMapper.getByCode(cdp_order_code);
            List<String> refundList = this.cdpOpenApiUrlMapper.getRefundCode();
            this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(refundList));
            for (String docno : refundList) {
                String str = byCode + "?docno=" + docno + "&dateb=2022-01-01 00:35:22&datee=2022-12-22 15:35:24&page=1&rows=200";
                str = str.replace(" ", "%20");
                this.logger.info("str\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)str));
                uri = new URI(str);
                String result = HttpClientUtil.sendPostForJson(uri);
                if (StringUtils.isBlank((String)result)) {
                    this.logger.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff1a{}", (Object)str);
                    return;
                }
                SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, SupQueryResult.class);
                this.logger.info("supQueryResult\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)supQueryResult));
                List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), TimingSynchronousOrderDomain.class);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                this.timingSynchronousOrder(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void synchronousRefundContract(String startDate, String endDate) {
        try {
            Date begin = DateUtils.parseDate((String)startDate, (String)"yyyyMMdd");
            String beginStr = DateUtils.parseDateToString((Date)begin, (String)"yyyy-MM-dd HH:mm:ss");
            Date out = DateUtils.parseDate((String)endDate, (String)"yyyyMMdd");
            String outStr = DateUtils.parseDateToString((Date)out, (String)"yyyy-MM-dd 23:59:59");
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)(startDate + "---" + endDate)));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)(beginStr + "---" + outStr)));
            List<PosOrder> init = PosConnetUtils.initRefund(startDate, endDate);
            List<PosGoods> initGoods = PosConnetUtils.initGoods(startDate, endDate);
            List<PosContractPayDetails> initContractPayDetail = PosConnetUtils.initContractPayDetail(beginStr, outStr);
            this.logger.info("\u6253\u5370\u6570\u636e\u6570\u91cf\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)init.size()));
            this.logger.info("\u6253\u5370\u5546\u54c1\u6570\u636e\u6570\u91cf\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)initGoods.size()));
            if (!CollectionUtils.isEmpty(init)) {
                init.stream().forEach(pos -> {
                    try {
                        if (this.addOcRefundContract((PosOrder)pos, initGoods)) {
                            this.addOcRefundDetail((PosOrder)pos, initContractPayDetail);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception throwables) {
            throwables.printStackTrace();
        }
    }

    @Override
    public void repairPosRefundOrder() {
        URI uri = null;
        try {
            String byCode = this.cdpOpenApiUrlMapper.getByCode(cdp_order_code);
            String endDate = "2020-01-01 00:00:00";
            String bigDate = "2050-01-01 00:00:00";
            String start = bigDate.replace(" ", "%20");
            String end = endDate.replace(" ", "%20");
            List<String> ocRepairList = this.ocRepairPosRefundContractMapper.query();
            this.logger.info("\u6253\u5370ocRepairList\u65e5\u5fd7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocRepairList));
            if (!CollectionUtils.isEmpty(ocRepairList)) {
                for (String code : ocRepairList) {
                    String str = byCode + "?docno=" + code + "&dateb=" + start + "&datee=" + end + "&page=1&rows=10";
                    this.logger.info("str\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)str));
                    uri = new URI(str);
                    String result = HttpClientUtil.sendPostForJson(uri);
                    if (StringUtils.isBlank((String)result)) {
                        this.logger.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff1a{}", (Object)str);
                        return;
                    }
                    SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, SupQueryResult.class);
                    this.logger.info("supQueryResult\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)supQueryResult));
                    List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), TimingSynchronousOrderDomain.class);
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        this.timingSynchronousOrder(list);
                        this.ocRepairPosRefundContractMapper.delete(code);
                    }
                    this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)list));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void repairPosOrder() {
        URI uri = null;
        try {
            String byCode = this.cdpOpenApiUrlMapper.getByCode(cdp_order_code);
            String endDate = "2020-01-01 00:00:00";
            String bigDate = "2050-01-01 00:00:00";
            String start = bigDate.replace(" ", "%20");
            String end = endDate.replace(" ", "%20");
            List<String> ocRepairList = this.ocRepairPosContractMapper.query();
            this.logger.info("\u6253\u5370ocRepairList\u65e5\u5fd7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocRepairList));
            if (!CollectionUtils.isEmpty(ocRepairList)) {
                for (String code : ocRepairList) {
                    String str = byCode + "?docno=" + code + "&dateb=" + start + "&datee=" + end + "&page=1&rows=10";
                    this.logger.info("str\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)str));
                    uri = new URI(str);
                    String result = HttpClientUtil.sendPostForJson(uri);
                    if (StringUtils.isBlank((String)result)) {
                        this.logger.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff1a{}", (Object)str);
                        return;
                    }
                    SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, SupQueryResult.class);
                    this.logger.info("supQueryResult\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)supQueryResult));
                    List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), TimingSynchronousOrderDomain.class);
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        this.ocRepairPosContractMapper.deleteOcContract(code);
                        this.timingSynchronousOrder(list);
                        this.ocRepairPosContractMapper.delete(code);
                    }
                    this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)list));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

