/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.openapi.service.impl;

import com.google.common.collect.ImmutableMap;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.openapi.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.service.openapi.core.convert.MemberConvert;
import com.yqbsoft.laser.service.openapi.core.enums.BrandEnum;
import com.yqbsoft.laser.service.openapi.core.enums.PlatCodeEnum;
import com.yqbsoft.laser.service.openapi.dao.oc.OcContractGoodsMapper;
import com.yqbsoft.laser.service.openapi.dao.oc.OcContractMapper;
import com.yqbsoft.laser.service.openapi.dao.oc.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.openapi.dao.oc.OcRefundMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionDisMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionDiscountMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionInMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmUserCouponMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmUserUsecouponMapper;
import com.yqbsoft.laser.service.openapi.dao.point.UpmUpointsMapper;
import com.yqbsoft.laser.service.openapi.dao.um.UmUserinfoMapper;
import com.yqbsoft.laser.service.openapi.domain.points.UpmUpointsOpDomain;
import com.yqbsoft.laser.service.openapi.dto.coupon.ConsumeMemberCouponDto;
import com.yqbsoft.laser.service.openapi.dto.coupon.GetMemberCouponsDto;
import com.yqbsoft.laser.service.openapi.dto.coupon.GrantMemberCouponDto;
import com.yqbsoft.laser.service.openapi.dto.coupon.MemberCouponDto;
import com.yqbsoft.laser.service.openapi.dto.coupon.PointsExchangeCouponDto;
import com.yqbsoft.laser.service.openapi.dto.order.MemberOrdersDto;
import com.yqbsoft.laser.service.openapi.dto.points.MemberPointsDto;
import com.yqbsoft.laser.service.openapi.dto.points.ModifyMemberPointsDto;
import com.yqbsoft.laser.service.openapi.model.OcContractGoods;
import com.yqbsoft.laser.service.openapi.model.OcRefund;
import com.yqbsoft.laser.service.openapi.model.OcRefundGoods;
import com.yqbsoft.laser.service.openapi.model.PmCheckBean;
import com.yqbsoft.laser.service.openapi.model.PmPromotion;
import com.yqbsoft.laser.service.openapi.model.PmPromotionDis;
import com.yqbsoft.laser.service.openapi.model.PmPromotionDiscount;
import com.yqbsoft.laser.service.openapi.model.PmPromotionIn;
import com.yqbsoft.laser.service.openapi.model.PmUserBean;
import com.yqbsoft.laser.service.openapi.model.PmUserCoupon;
import com.yqbsoft.laser.service.openapi.model.PmUserUsecoupon;
import com.yqbsoft.laser.service.openapi.model.UmUserinfo;
import com.yqbsoft.laser.service.openapi.model.UpmUpointsClear;
import com.yqbsoft.laser.service.openapi.model.UserBean;
import com.yqbsoft.laser.service.openapi.service.MemberService;
import com.yqbsoft.laser.service.openapi.vo.CouponInfoVo;
import com.yqbsoft.laser.service.openapi.vo.GoodsVo;
import com.yqbsoft.laser.service.openapi.vo.MemberCouponsVo;
import com.yqbsoft.laser.service.openapi.vo.MemberPointsVo;
import com.yqbsoft.laser.service.openapi.vo.MembrOcContractVo;
import com.yqbsoft.laser.service.openapi.vo.PointsExchangeCouponVo;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class MemberServiceImpl
extends BaseServiceImpl
implements MemberService {
    private UpmUpointsMapper upmUpointsMapper;
    private UmUserinfoMapper umUserinfoMapper;
    private PmPromotionMapper pmPromotionMapper;
    private PmUserCouponMapper pmUserCouponMapper;
    private PmPromotionDiscountMapper pmPromotionDiscountMapper;
    private PmPromotionInMapper pmPromotionInMapper;
    private PmUserUsecouponMapper pmUserUsecouponMapper;
    private PmPromotionDisMapper pmPromotionDisMapper;
    private OcContractMapper ocContractMapper;
    private OcContractGoodsMapper ocContractGoodsMapper;
    private OcRefundGoodsMapper ocRefundGoodsMapper;
    private OcRefundMapper ocRefundMapper;

    @Override
    public HtmlJsonReBean getMemberPoints(MemberPointsDto memberPointsDto) {
        this.logger.info("\u6253\u5370\u53c2\u6570\u65e5\u5fd7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)memberPointsDto));
        if (Objects.isNull(memberPointsDto) || StringUtils.isBlank((String)memberPointsDto.getMobile()) && StringUtils.isBlank((String)memberPointsDto.getMember_code())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        List<UmUserinfo> query = this.getUmUserinfos(memberPointsDto.getMobile(), memberPointsDto.getMember_code());
        if (CollectionUtils.isEmpty(query)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6ca1\u6709\u8be5\u4f1a\u5458");
        }
        UmUserinfo umUserinfo = query.get(0);
        MemberPointsVo vo = this.upmUpointsMapper.getMemberPoints(umUserinfo.getUserinfoCode());
        vo.setName(umUserinfo.getUserinfoCompname());
        vo.setMobile(umUserinfo.getUserinfoPhone());
        vo.setMember_code(umUserinfo.getUserinfoOcode());
        return new HtmlJsonReBean(vo);
    }

    @Override
    public HtmlJsonReBean cdpModifyMemberPoints(ModifyMemberPointsDto dto) {
        String bunit;
        this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dto));
        if (StringUtils.isBlank((String)dto.getMobile()) && StringUtils.isBlank((String)dto.getMemberCode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        boolean checkData = dto.checkData();
        if (!checkData) {
            this.logger.info("checkData\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dto));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMemberCode());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6ca1\u6709\u8be5\u4f1a\u5458");
        }
        BrandEnum brandEnum = null;
        if ((dto.getPointSource() == 5 || dto.getPointSource() == 6) && (brandEnum = BrandEnum.getByValue(bunit = dto.getBunit())) == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u54c1\u724c\u4e0d\u5b58\u5728");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        UpmUpointsClear upmUpointsClear = new UpmUpointsClear();
        upmUpointsClear.setUpointsType(dto.getPointType() + "");
        upmUpointsClear.setUpointsOpType(dto.getPointSource() + "");
        upmUpointsClear.setMemberCode(umUserinfo.getUserinfoCode());
        upmUpointsClear.setMemberName(umUserinfo.getUserinfoCompname());
        upmUpointsClear.setLevelUserqua("buy");
        upmUpointsClear.setUpointsListExcode(brandEnum != null ? brandEnum.getCode() : "20000210397487");
        upmUpointsClear.setUpointsClearOpcode(dto.getOrderCode());
        upmUpointsClear.setUpointsClearDirection(dto.getPointValue().compareTo(new BigDecimal(0)) > 0 ? "0" : "5");
        upmUpointsClear.setUpointsClearNum(dto.getPointValue());
        upmUpointsClear.setGmtCreate(new Date());
        upmUpointsClear.setGmtModified(new Date());
        upmUpointsClear.setDataState(1);
        upmUpointsClear.setTenantCode("2022012800000001");
        upmUpointsClear.setMemberMcode(brandEnum != null ? brandEnum.getCode() : "20000210397487");
        Object clearCode = this.insertUpmUpointsClear(upmUpointsClear);
        if (clearCode == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
        }
        return new HtmlJsonReBean(clearCode);
    }

    public Object insertUpmUpointsClear(UpmUpointsClear clear) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsClearDomain", JsonUtil.buildNormalBinder().toJson((Object)clear));
        Object departCode = this.getInternalRouter().inInvoke("upm.upointsClearBase.sendUpointsClear", pmap);
        return departCode;
    }

    @Override
    public HtmlJsonReBean cdpGetCouponInfo(MemberCouponDto dto) {
        this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dto));
        if (StringUtils.isBlank((String)dto.getCoupon_code()) || StringUtils.isBlank((String)dto.getCoupon_batch_code())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        if (!StringUtils.isBlank((String)dto.getCoupon_batch_code())) {
            return new HtmlJsonReBean(this.getPmPromotion(dto.getCoupon_batch_code()));
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u67e5\u8be2\u5230\u6570\u636e");
    }

    @Override
    public HtmlJsonReBean cdpGetMemberCoupons(GetMemberCouponsDto dto) {
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        HashMap<String, Object> pmUserCouponMap = new HashMap<String, Object>();
        pmUserCouponMap.put("memberBcode", umUserinfo.getUserinfoCode());
        pmUserCouponMap.put("dataState", dto.getCoupon_status());
        List<PmUserCoupon> userCouponList = this.pmUserCouponMapper.query(pmUserCouponMap);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(userCouponList));
        if (CollectionUtils.isEmpty(userCouponList)) {
            return new HtmlJsonReBean(new ArrayList());
        }
        List<MemberCouponsVo> list = MemberConvert.memberCouponsConvert(userCouponList);
        for (MemberCouponsVo vo : list) {
            PmPromotionDiscount promotionCode = this.pmPromotionDiscountMapper.getByCode((Map<String, Object>)ImmutableMap.of((Object)"promotionCode", (Object)vo.getPromotion_code()));
            vo.setRemark(promotionCode.getDiscName());
        }
        return new HtmlJsonReBean(list);
    }

    @Override
    public HtmlJsonReBean cdpGrantMemberCoupon(GrantMemberCouponDto dto) {
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getPlat_code()) || StringUtils.isBlank((String)dto.getCoupon_batch_code())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        PlatCodeEnum platCodeEnum = PlatCodeEnum.getByName(dto.getPlat_code());
        if (Objects.isNull((Object)platCodeEnum)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u652f\u6301\u8be5\u5e73\u53f0\uff0c\u8bf7\u8f93\u5165\u652f\u6301\u7684\u5e73\u53f0!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        HashMap<String, Object> pmPromotionMap = new HashMap<String, Object>();
        pmPromotionMap.put("couponBatch", StringUtils.isBlank((String)dto.getCoupon_batch_code()));
        List<PmPromotionIn> pmPromotionIns = this.pmPromotionInMapper.query(pmPromotionMap);
        this.logger.info(".cdpGrantMemberCoupon.pmPromotionIns:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(pmPromotionIns));
        if (CollectionUtils.isEmpty(pmPromotionIns)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f18\u60e0\u5238\u4e0d\u5b58\u5728!");
        }
        PmPromotionIn pmPromotionInDomain = pmPromotionIns.get(0);
        String promotionActurl = pmPromotionInDomain.getPromotionActurl();
        this.logger.info("PromotionActurl\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)promotionActurl));
        if (!promotionActurl.equals("2")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u4f18\u60e0\u5238\u4e0d\u662f\u63a5\u53e3\u53d1\u5238");
        }
        if (null != pmPromotionInDomain && pmPromotionInDomain.getCouponOnceNums() < pmPromotionInDomain.getCouponOnceNumd()) {
            this.logger.error(".saveUsercoupon.couponOnceNumd", (Object)"\u5df2\u9886\u5b8c");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f18\u60e0\u5238\u5df2\u9886\u5b8c!");
        }
        PmUserBean pmUserBean = new PmUserBean();
        pmUserBean.setAmonut(null);
        pmUserBean.setNum(1);
        pmUserBean.setGoodsClass(pmPromotionInDomain.getGoodsClass());
        pmUserBean.setUsercouponOrgin(dto.getPlat_code());
        pmUserBean.setPromotionCode(pmPromotionInDomain.getPromotionCode());
        pmUserBean.setTenantCode(pmPromotionInDomain.getTenantCode());
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setProappCode("001");
        pmCheckBean.setTenantCode(pmPromotionInDomain.getTenantCode());
        UserBean userBean = new UserBean();
        pmCheckBean.setUserBean(userBean);
        userBean.setMemberCode(umUserinfo.getUserinfoCode());
        userBean.setMemberName(umUserinfo.getUserinfoCompname());
        userBean.setProappCode(pmCheckBean.getChannelCode());
        userBean.setTenantCode(pmCheckBean.getTenantCode());
        pmUserBean.setPmCheckBean(pmCheckBean);
        this.logger.info("\u53d1\u9001\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pmUserBean));
        return new HtmlJsonReBean(this.insertUserCoupon(pmUserBean));
    }

    @Override
    public HtmlJsonReBean cdpConsumeMemberCoupon(ConsumeMemberCouponDto dto) {
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        if (StringUtils.isBlank((String)dto.getPlat_code())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5e73\u53f0\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getCoupon_code())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f18\u60e0\u5238\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getShop_code())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a!");
        }
        PlatCodeEnum platCodeEnum = PlatCodeEnum.getByName(dto.getPlat_code());
        if (Objects.isNull((Object)platCodeEnum)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u652f\u6301\u8be5\u5e73\u53f0\uff0c\u8bf7\u8f93\u5165\u652f\u6301\u7684\u5e73\u53f0!");
        }
        List<PmUserCoupon> couponNo = this.pmUserCouponMapper.query((Map<String, Object>)ImmutableMap.of((Object)"couponNo", (Object)dto.getCoupon_code()));
        if (CollectionUtils.isEmpty(couponNo)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u7528\u6237\u65e0\u8be5\u4f18\u60e0\u5238!");
        }
        PmUserCoupon usercoupon = couponNo.get(0);
        String storeCode = this.getStoreCode(dto.getShop_code());
        if (StringUtils.isBlank((String)storeCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u95e8\u5e97\u4e0d\u5b58\u5728!");
        }
        Integer promotionDis = usercoupon.getPromotionDis();
        if (promotionDis == 0) {
            this.updateUserCouponDataState(usercoupon);
            this.addUserUseCoupon(usercoupon, dto, storeCode);
        } else if (promotionDis == 1) {
            List collect;
            HashMap<String, Object> pmPromotionMap = new HashMap<String, Object>();
            pmPromotionMap.put("promotionCode", usercoupon.getPromotionCode());
            List<PmPromotionDis> list = this.pmPromotionDisMapper.query(pmPromotionMap);
            if (!CollectionUtils.isEmpty(list) && CollectionUtils.isEmpty(collect = list.stream().filter(l -> !StringUtils.isBlank((String)l.getChannelCode()) && l.getChannelCode().equals(storeCode)).collect(Collectors.toList()))) {
                this.logger.info("PmPromotionDis:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u95e8\u5e97\u4e0d\u80fd\u4f7f\u7528\u8be5\u4f18\u60e0\u5238!");
            }
            this.updateUserCouponDataState(usercoupon);
            this.addUserUseCoupon(usercoupon, dto, storeCode);
        }
        return new HtmlJsonReBean("success");
    }

    @Override
    public HtmlJsonReBean cdpPointsExchangeCoupon(PointsExchangeCouponDto dto) {
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        this.logger.info("umUserinfo:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)umUserinfo));
        if (StringUtils.isBlank((String)dto.getPlat_code())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5e73\u53f0\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getPoints_value())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u79ef\u5206\u4e3a\u7a7a!");
        }
        List<PmPromotionIn> couponBatch = this.pmPromotionInMapper.query((Map<String, Object>)ImmutableMap.of((Object)"couponBatch", (Object)dto.getCoupon_batch_code()));
        this.logger.info("PmPromotionIn:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(couponBatch));
        if (CollectionUtils.isEmpty(couponBatch)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u8be5\u4f18\u60e0\u5238!");
        }
        PmPromotionIn pmPromotionIn = couponBatch.get(0);
        if (pmPromotionIn.getDataState() != 1) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f18\u60e0\u5238\u4e0d\u5728\u8fdb\u884c\u4e2d\uff0c\u65e0\u6cd5\u5151\u6362!");
        }
        MemberPointsVo memberPoints = this.upmUpointsMapper.getMemberPoints(umUserinfo.getUserinfoCode());
        this.logger.info("memberPoints:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)memberPoints));
        if (Objects.isNull(memberPoints)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u7528\u6237\u8fd8\u672a\u62e5\u6709\u79ef\u5206!");
        }
        BigDecimal point = memberPoints.getConsume_availd_points();
        if (point.compareTo(new BigDecimal(dto.getPoints_value())) < 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u79ef\u5206\u4e0d\u8db3!");
        }
        GrantMemberCouponDto couponDto = new GrantMemberCouponDto();
        couponDto.setCoupon_batch_code(dto.getCoupon_batch_code());
        couponDto.setMember_code(dto.getMember_code());
        couponDto.setMobile(dto.getMobile());
        couponDto.setPlat_code(dto.getPlat_code());
        couponDto.setPlat_code(dto.getPlat_code());
        HtmlJsonReBean htmlJsonReBean = this.pointsExchangeCoupon(couponDto);
        if (!htmlJsonReBean.isSuccess()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5151\u6362\u4f18\u60e0\u5238\u5931\u8d25!");
        }
        String couponCode = (String)htmlJsonReBean.getDataObj();
        Object point1 = this.subMemberPoint(umUserinfo, pmPromotionIn, dto.getPoints_value(), couponCode);
        if (Objects.isNull(point1)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6263\u51cf\u79ef\u5206\u5931\u8d25!");
        }
        PointsExchangeCouponVo vo = new PointsExchangeCouponVo();
        vo.setCoupon_code(couponCode);
        MemberPointsVo memberPoints1 = this.upmUpointsMapper.getMemberPoints(umUserinfo.getUserinfoCode());
        this.logger.info("\u53ef\u7528\u79ef\u5206memberPoints1\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)memberPoints1));
        BigDecimal consume_availd_points = memberPoints1.getConsume_availd_points();
        String totalPoint = consume_availd_points.setScale(2).toString();
        vo.setConsume_availd_points(totalPoint);
        return new HtmlJsonReBean(vo);
    }

    @Override
    public HtmlJsonReBean cdpGetMemberOrders(MemberOrdersDto dto) {
        List<MembrOcContractVo> list1;
        this.logger.info("cdpGetMemberOrders\u8bf7\u6c42\u53c2\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dto));
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getEnd_date()) || StringUtils.isBlank((String)dto.getStart_date())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        ArrayList<MembrOcContractVo> list = new ArrayList<MembrOcContractVo>();
        if (dto.getOrder_type() == null || dto.getOrder_type() == 1) {
            list1 = this.ocContractMapper.cdpGetMemberOrders(dto, umUserinfo.getUserinfoCode());
            this.logger.info("ocContract:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list1));
            list.addAll(list1);
        } else if (dto.getOrder_type() == null || dto.getOrder_type() == 2) {
            list1 = this.ocContractMapper.cdpGetMemberRefundOrders(dto, umUserinfo.getUserinfoCode());
            this.logger.info("ocRefund2:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list1));
            list.addAll(list1);
        } else if (dto.getOrder_type() == null || dto.getOrder_type() == 3) {
            list1 = this.ocContractMapper.cdpGetMemberRefundOrders2(dto, umUserinfo.getUserinfoCode());
            this.logger.info("ocRefund3:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list1));
            list.addAll(list1);
        } else if (dto.getOrder_type() == null || dto.getOrder_type() == 4) {
            list1 = this.ocContractMapper.cdpGetMemberRefundOrders3(dto, umUserinfo.getUserinfoCode());
            this.logger.info("ocRefund4:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list1));
            list.addAll(list1);
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (MembrOcContractVo membrOcContractVo : list) {
                if (membrOcContractVo.getOrder_type().equals("1")) {
                    this.getOrderGoods(membrOcContractVo);
                    continue;
                }
                this.getRefundGoods(membrOcContractVo);
            }
        }
        this.logger.info("\u67e5\u8be2\u5230\u7684\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list));
        return new HtmlJsonReBean(list);
    }

    private void getRefundGoods(MembrOcContractVo membrOcContractVo) {
        this.logger.info("\u83b7\u53d6\u8ba2\u5355\u5546\u54c1\u5f00\u59cb:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)membrOcContractVo));
        HashMap<String, Object> goodsMap = new HashMap<String, Object>();
        goodsMap.put("contractBillcode", membrOcContractVo.getContact_bill());
        List<OcContractGoods> query = this.ocContractGoodsMapper.query(goodsMap);
        ArrayList<GoodsVo> vos = new ArrayList<GoodsVo>();
        for (OcContractGoods ocContractGoods : query) {
            GoodsVo goodsVo = new GoodsVo();
            goodsVo.setGoods_name(ocContractGoods.getGoodsName());
            goodsVo.setGoods_sku(ocContractGoods.getSkuNo());
            goodsVo.setGoods_sku_name(ocContractGoods.getSkuName());
            goodsVo.setGoods_spu(ocContractGoods.getGoodsNo());
            goodsVo.setGoods_number(ocContractGoods.getGoodsNum());
            goodsVo.setGoods_pay_price(ocContractGoods.getContractGoodsPrice() != null ? ocContractGoods.getContractGoodsPrice().setScale(2).toString() : "0");
            goodsVo.setGoods_market_price(ocContractGoods.getPricesetNprice() != null ? ocContractGoods.getPricesetNprice().setScale(2).toString() : "0");
            goodsVo.setGoods_price(ocContractGoods.getPricesetMakeprice() != null ? ocContractGoods.getPricesetMakeprice().setScale(2).toString() : "0");
            goodsVo.setGoods_type(ocContractGoods.getGoodsType());
            vos.add(goodsVo);
        }
        membrOcContractVo.setGoodsList(vos);
        this.logger.info("\u83b7\u53d6\u8ba2\u5355\u5546\u54c1\u7ed3\u675f:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)membrOcContractVo));
    }

    private void getOrderGoods(MembrOcContractVo membrOcContractVo) {
        this.logger.info("\u83b7\u53d6\u9000\u6b3e\u5546\u54c1\u5f00\u59cb:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)membrOcContractVo));
        HashMap<String, Object> goodsMap = new HashMap<String, Object>();
        goodsMap.put("refundCode", membrOcContractVo.getContact_aftermarket_code());
        List<OcRefundGoods> query = this.ocRefundGoodsMapper.query(goodsMap);
        List<OcRefund> ocrefund = this.ocRefundMapper.query(goodsMap);
        OcRefund ocRefund = ocrefund.get(0);
        ArrayList<GoodsVo> vos = new ArrayList<GoodsVo>();
        for (OcRefundGoods ocRefundGoods : query) {
            GoodsVo goodsVo = new GoodsVo();
            goodsVo.setGoods_name(ocRefundGoods.getGoodsName());
            goodsVo.setGoods_sku(ocRefundGoods.getSkuNo());
            goodsVo.setGoods_sku_name(ocRefundGoods.getSkuName());
            goodsVo.setGoods_spu(ocRefundGoods.getGoodsNo());
            goodsVo.setGoods_number(ocRefundGoods.getGoodsNum());
            goodsVo.setGoods_pay_price(ocRefundGoods.getContractGoodsPrice() != null ? ocRefundGoods.getContractGoodsPrice().setScale(2).toString() : "0");
            goodsVo.setGoods_market_price(ocRefundGoods.getPricesetNprice() != null ? ocRefundGoods.getPricesetNprice().setScale(2).toString() : "0");
            goodsVo.setGoods_price(ocRefundGoods.getPricesetMakeprice() != null ? ocRefundGoods.getPricesetMakeprice().setScale(2).toString() : "0");
            goodsVo.setGoods_type(ocRefundGoods.getGoodsType());
            goodsVo.setGoods_return_number(ocRefund.getGoodsNum() + "");
            goodsVo.setAmt_refund(ocRefund.getRefundMoney() + "");
            vos.add(goodsVo);
        }
        membrOcContractVo.setGoodsList(vos);
        this.logger.info("\u83b7\u53d6\u9000\u6b3e\u5546\u54c1\u7ed3\u679c:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)membrOcContractVo));
    }

    private Object subMemberPoint(UmUserinfo umUserinfo, PmPromotionIn pmPromotionIn, String points_value, String couponCode) {
        UpmUpointsOpDomain upmUpointsOpDomain = new UpmUpointsOpDomain();
        upmUpointsOpDomain.setMemberName(umUserinfo.getUserinfoCompname());
        upmUpointsOpDomain.setMemberCode(umUserinfo.getUserinfoCode());
        upmUpointsOpDomain.setLevelUserqua("buy");
        upmUpointsOpDomain.setMemberMcode(pmPromotionIn.getMemberCode());
        upmUpointsOpDomain.setUserCode(pmPromotionIn.getMemberCode());
        upmUpointsOpDomain.setTenantCode(umUserinfo.getTenantCode());
        upmUpointsOpDomain.setUpointsType("0");
        upmUpointsOpDomain.setUpointsOpType("0");
        upmUpointsOpDomain.setUpointsOpNum(new BigDecimal(points_value));
        upmUpointsOpDomain.setUpointsOpRemark(couponCode);
        if (StringUtils.isBlank((String)upmUpointsOpDomain.getGoodsClass())) {
            upmUpointsOpDomain.setGoodsClass("4");
        }
        return this.saveUpointsOp(upmUpointsOpDomain);
    }

    private void addUserUseCoupon(PmUserCoupon usercoupon, ConsumeMemberCouponDto dto, String storeCode) {
        PmUserUsecoupon pmUserUsecoupon = new PmUserUsecoupon();
        pmUserUsecoupon.setPbCode(usercoupon.getPbCode());
        pmUserUsecoupon.setPbName(usercoupon.getPbName());
        pmUserUsecoupon.setPromotionCode(usercoupon.getPromotionCode());
        pmUserUsecoupon.setPromotionName(usercoupon.getPromotionName());
        pmUserUsecoupon.setCouponBatch(usercoupon.getCouponBatch());
        pmUserUsecoupon.setCouponNo(usercoupon.getCouponNo());
        pmUserUsecoupon.setCouponUseamount(1);
        pmUserUsecoupon.setCouponStart(usercoupon.getCouponStart());
        pmUserUsecoupon.setCouponEnd(usercoupon.getCouponEnd());
        pmUserUsecoupon.setDataState(1);
        pmUserUsecoupon.setMemberCode(usercoupon.getMemberCode());
        pmUserUsecoupon.setMemberBcode(usercoupon.getMemberBcode());
        pmUserUsecoupon.setUserCode(storeCode);
        pmUserUsecoupon.setTenantCode(usercoupon.getTenantCode());
        this.saveUserUseCoupon(pmUserUsecoupon);
    }

    public Object saveUserUseCoupon(PmUserUsecoupon pmUserUsecoupon) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("pmUserUsecouponDomain", JsonUtil.buildNormalBinder().toJson((Object)pmUserUsecoupon));
        Object result = this.getInternalRouter().inInvoke("pm.PmUserUsecoupon.saveUserUsecoupon", pmap);
        return result;
    }

    public String getStoreCode(String storeOcode) {
        String userinfoCode = this.umUserinfoMapper.getStoreCodeByOcode(storeOcode);
        return userinfoCode;
    }

    private void updateUserCouponDataState(PmUserCoupon usercoupon) {
        this.pmUserCouponMapper.updateStateByCode((Map<String, Object>)ImmutableMap.of((Object)"usercouponCode", (Object)usercoupon.getUsercouponCode(), (Object)"dataState", (Object)1));
    }

    private Object saveUpointsOp(UpmUpointsOpDomain upmUpointsOpDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsOpDomain", JsonUtil.buildNormalBinder().toJson((Object)upmUpointsOpDomain));
        Object result = this.getInternalRouter().inInvoke("upm.upointsOp.saveUpointsOp", pmap);
        return result;
    }

    public Object insertUserCoupon(PmUserBean bean) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("pmUserBean", JsonUtil.buildNormalBinder().toJson((Object)bean));
        Object result = this.getInternalRouter().inInvoke("zyCdp.pmPromotion.savePromotionUser", pmap);
        return result;
    }

    private CouponInfoVo getPmPromotion(String coupon_batch_code) {
        HashMap<String, Object> pm = new HashMap<String, Object>();
        pm.put("promotionCode", coupon_batch_code);
        PmPromotion pmPromotion = this.pmPromotionMapper.getByCode(pm);
        CouponInfoVo couponInfoVo = new CouponInfoVo();
        couponInfoVo.setCoupon_batch_name(pmPromotion.getCouponBatchCode());
        couponInfoVo.setCoupon_batch_code(pmPromotion.getPromotionName());
        couponInfoVo.setCoupon_bnatch_status(pmPromotion.getDataState());
        couponInfoVo.setBatch_end_time(DateUtils.parseDate((Date)pmPromotion.getPromotionEndtime()));
        couponInfoVo.setBatch_start_time(DateUtils.parseDate((Date)pmPromotion.getPromotionBegintime()));
        couponInfoVo.setAllow_give(pmPromotion.getSendtype() == 5 ? 1 : 0);
        couponInfoVo.setAllow_overlying(pmPromotion.getSharetype());
        couponInfoVo.setIssue_number(pmPromotion.getCouponOnceNums());
        couponInfoVo.setDraw_number(pmPromotion.getPromotionFrequency());
        couponInfoVo.setUse_number(1);
        couponInfoVo.setCoupon_type(pmPromotion.getPbCode().equals("0005") ? 3 : (pmPromotion.getPbCode().equals("0003") ? 1 : (pmPromotion.getPbCode().equals("0004") ? Integer.valueOf(2) : null)));
        return couponInfoVo;
    }

    private List<UmUserinfo> getUmUserinfos(String memberPhone, String userinfoOcode) {
        HashMap<String, Object> umUserinfoMap = new HashMap<String, Object>();
        umUserinfoMap.put("fuzzy", false);
        if (!StringUtils.isBlank((String)memberPhone)) {
            umUserinfoMap.put("userinfoPhone", memberPhone);
        }
        if (!StringUtils.isBlank((String)userinfoOcode)) {
            umUserinfoMap.put("userinfoOcode", userinfoOcode);
        }
        return this.umUserinfoMapper.query(umUserinfoMap);
    }

    public HtmlJsonReBean pointsExchangeCoupon(GrantMemberCouponDto dto) {
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getPlat_code()) || StringUtils.isBlank((String)dto.getCoupon_batch_code())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        PlatCodeEnum platCodeEnum = PlatCodeEnum.getByName(dto.getPlat_code());
        if (Objects.isNull((Object)platCodeEnum)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u652f\u6301\u8be5\u5e73\u53f0\uff0c\u8bf7\u8f93\u5165\u652f\u6301\u7684\u5e73\u53f0!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        HashMap<String, Object> pmPromotionMap = new HashMap<String, Object>();
        pmPromotionMap.put("couponBatch", StringUtils.isBlank((String)dto.getCoupon_batch_code()));
        List<PmPromotionIn> pmPromotionIns = this.pmPromotionInMapper.query(pmPromotionMap);
        this.logger.info(".cdpGrantMemberCoupon.pmPromotionIns:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(pmPromotionIns));
        if (CollectionUtils.isEmpty(pmPromotionIns)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f18\u60e0\u5238\u4e0d\u5b58\u5728!");
        }
        PmPromotionIn pmPromotionInDomain = pmPromotionIns.get(0);
        String promotionActurl = pmPromotionInDomain.getPromotionActurl();
        this.logger.info("PromotionActurl\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)promotionActurl));
        if (null != pmPromotionInDomain && pmPromotionInDomain.getCouponOnceNums() < pmPromotionInDomain.getCouponOnceNumd()) {
            this.logger.error(".saveUsercoupon.couponOnceNumd", (Object)"\u5df2\u9886\u5b8c");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f18\u60e0\u5238\u5df2\u9886\u5b8c!");
        }
        PmUserBean pmUserBean = new PmUserBean();
        pmUserBean.setAmonut(null);
        pmUserBean.setNum(1);
        pmUserBean.setGoodsClass(pmPromotionInDomain.getGoodsClass());
        pmUserBean.setUsercouponOrgin(dto.getPlat_code());
        pmUserBean.setPromotionCode(pmPromotionInDomain.getPromotionCode());
        pmUserBean.setTenantCode(pmPromotionInDomain.getTenantCode());
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setProappCode("001");
        pmCheckBean.setTenantCode(pmPromotionInDomain.getTenantCode());
        UserBean userBean = new UserBean();
        pmCheckBean.setUserBean(userBean);
        userBean.setMemberCode(umUserinfo.getUserinfoCode());
        userBean.setMemberName(umUserinfo.getUserinfoCompname());
        userBean.setProappCode(pmCheckBean.getChannelCode());
        userBean.setTenantCode(pmCheckBean.getTenantCode());
        pmUserBean.setPmCheckBean(pmCheckBean);
        this.logger.info("\u53d1\u9001\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pmUserBean));
        return new HtmlJsonReBean(this.insertUserCoupon(pmUserBean));
    }
}

