/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.openapi.service.impl;

import com.google.common.collect.ImmutableMap;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.openapi.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.service.openapi.core.convert.MemberConvert;
import com.yqbsoft.laser.service.openapi.core.enums.BrandEnum;
import com.yqbsoft.laser.service.openapi.core.enums.PlatCodeEnum;
import com.yqbsoft.laser.service.openapi.dao.oc.OcContractGoodsMapper;
import com.yqbsoft.laser.service.openapi.dao.oc.OcContractMapper;
import com.yqbsoft.laser.service.openapi.dao.oc.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.openapi.dao.oc.OcRefundMapper;
import com.yqbsoft.laser.service.openapi.dao.org.OrgDepartMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.CdpPmPromotionMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionConditionMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionDisMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionDiscountMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionDiscountlistMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionInMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionMemMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionRangelistMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionSavgMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionSupMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionTargetlistMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmPromotionTerminalMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmUserCouponMapper;
import com.yqbsoft.laser.service.openapi.dao.pm.PmUserUsecouponMapper;
import com.yqbsoft.laser.service.openapi.dao.point.UpmUpointsMapper;
import com.yqbsoft.laser.service.openapi.dao.um.UmUserinfoMapper;
import com.yqbsoft.laser.service.openapi.domain.pm.PmCdpPromotion;
import com.yqbsoft.laser.service.openapi.domain.pm.PmCheckBean;
import com.yqbsoft.laser.service.openapi.domain.pm.PmPromotionBaseDomain;
import com.yqbsoft.laser.service.openapi.domain.pm.PmPromotionInDomain;
import com.yqbsoft.laser.service.openapi.domain.pm.PmUserBean;
import com.yqbsoft.laser.service.openapi.domain.pm.PmUserCouponDomain;
import com.yqbsoft.laser.service.openapi.domain.pm.UserBean;
import com.yqbsoft.laser.service.openapi.domain.points.UpmUpointsOpDomain;
import com.yqbsoft.laser.service.openapi.dto.coupon.ConsumeMemberCouponDto;
import com.yqbsoft.laser.service.openapi.dto.coupon.GetMemberCouponsDto;
import com.yqbsoft.laser.service.openapi.dto.coupon.GrantMemberCouponDto;
import com.yqbsoft.laser.service.openapi.dto.coupon.MemberCouponDto;
import com.yqbsoft.laser.service.openapi.dto.coupon.PointsExchangeCouponDto;
import com.yqbsoft.laser.service.openapi.dto.order.MemberOrdersDto;
import com.yqbsoft.laser.service.openapi.dto.points.MemberPointsDto;
import com.yqbsoft.laser.service.openapi.dto.points.ModifyMemberPointsDto;
import com.yqbsoft.laser.service.openapi.model.OcContractGoods;
import com.yqbsoft.laser.service.openapi.model.OcRefund;
import com.yqbsoft.laser.service.openapi.model.OcRefundGoods;
import com.yqbsoft.laser.service.openapi.model.OrgDepart;
import com.yqbsoft.laser.service.openapi.model.PmCdpPromotionDisTemp;
import com.yqbsoft.laser.service.openapi.model.PmPromotion;
import com.yqbsoft.laser.service.openapi.model.PmPromotionCondition;
import com.yqbsoft.laser.service.openapi.model.PmPromotionDis;
import com.yqbsoft.laser.service.openapi.model.PmPromotionDiscount;
import com.yqbsoft.laser.service.openapi.model.PmPromotionDiscountlist;
import com.yqbsoft.laser.service.openapi.model.PmPromotionIn;
import com.yqbsoft.laser.service.openapi.model.PmPromotionMem;
import com.yqbsoft.laser.service.openapi.model.PmPromotionRangelist;
import com.yqbsoft.laser.service.openapi.model.PmPromotionSavg;
import com.yqbsoft.laser.service.openapi.model.PmPromotionSup;
import com.yqbsoft.laser.service.openapi.model.PmPromotionTargetlist;
import com.yqbsoft.laser.service.openapi.model.PmPromotionTerminal;
import com.yqbsoft.laser.service.openapi.model.PmUserCoupon;
import com.yqbsoft.laser.service.openapi.model.PmUserUsecoupon;
import com.yqbsoft.laser.service.openapi.model.UmUserinfo;
import com.yqbsoft.laser.service.openapi.model.UpmUpointsClear;
import com.yqbsoft.laser.service.openapi.service.MemberService;
import com.yqbsoft.laser.service.openapi.vo.CouponInfoVo;
import com.yqbsoft.laser.service.openapi.vo.GoodsVo;
import com.yqbsoft.laser.service.openapi.vo.MemberCouponsVo;
import com.yqbsoft.laser.service.openapi.vo.MemberPointsVo;
import com.yqbsoft.laser.service.openapi.vo.MembrOcContractVo;
import com.yqbsoft.laser.service.openapi.vo.PointsExchangeCouponVo;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class MemberServiceImpl
extends BaseServiceImpl
implements MemberService {
    @Autowired
    private UpmUpointsMapper upmUpointsMapper;
    @Autowired
    private UmUserinfoMapper umUserinfoMapper;
    @Autowired
    private PmPromotionMapper pmPromotionMapper;
    @Autowired
    private PmUserCouponMapper pmUserCouponMapper;
    @Autowired
    private PmPromotionDiscountMapper pmPromotionDiscountMapper;
    @Autowired
    private PmPromotionInMapper pmPromotionInMapper;
    @Autowired
    private PmUserUsecouponMapper pmUserUsecouponMapper;
    @Autowired
    private PmPromotionDisMapper pmPromotionDisMapper;
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;
    @Autowired
    private OcRefundGoodsMapper ocRefundGoodsMapper;
    @Autowired
    private OcRefundMapper ocRefundMapper;
    @Autowired
    private OrgDepartMapper orgDepartMapper;
    @Autowired
    private CdpPmPromotionMapper cdpPmPromotionMapper;
    @Autowired
    private PmPromotionTargetlistMapper pmPromotionTargetlistMapper;
    @Autowired
    private PmPromotionRangelistMapper pmPromotionRangelistMapper;
    @Autowired
    private PmPromotionSavgMapper pmPromotionSavgMapper;
    @Autowired
    private PmPromotionTerminalMapper pmPromotionTerminalMapper;
    @Autowired
    private PmPromotionConditionMapper pmPromotionConditionMapper;
    @Autowired
    private PmPromotionDiscountlistMapper pmPromotionDiscountlistMapper;
    @Autowired
    private PmPromotionMemMapper pmPromotionMemMapper;
    @Autowired
    private PmPromotionSupMapper pmPromotionSupMapper;

    @Override
    public MemberPointsVo getMemberPoints(String resStream) {
        MemberPointsDto memberPointsDto = new MemberPointsDto();
        memberPointsDto = this.strToDto(memberPointsDto, resStream);
        this.logger.info("\u6253\u5370\u53c2\u6570\u65e5\u5fd7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)memberPointsDto));
        if (Objects.isNull(memberPointsDto) || StringUtils.isBlank((String)memberPointsDto.getMobile()) && StringUtils.isBlank((String)memberPointsDto.getMember_code())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        List<UmUserinfo> query = this.getUmUserinfos(memberPointsDto.getMobile(), memberPointsDto.getMember_code());
        if (CollectionUtils.isEmpty(query)) {
            throw new ApiException("\u6ca1\u6709\u8be5\u4f1a\u5458");
        }
        UmUserinfo umUserinfo = query.get(0);
        MemberPointsVo vo = this.upmUpointsMapper.getMemberPoints(umUserinfo.getUserinfoCode());
        MemberPointsVo vo1 = this.upmUpointsMapper.getMemberUsedPoints(umUserinfo.getUserinfoCode());
        vo.setName(umUserinfo.getUserinfoCompname());
        vo.setConsume_used_points(vo1.getConsume_used_points());
        vo.setMobile(umUserinfo.getUserinfoPhone());
        vo.setMember_code(umUserinfo.getUserinfoOcode());
        return vo;
    }

    @Override
    public String cdpModifyMemberPoints(String resStream) {
        String bunit;
        ModifyMemberPointsDto dto = new ModifyMemberPointsDto();
        dto = this.strToDto(dto, resStream);
        this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dto));
        if (Objects.isNull(dto) || StringUtils.isBlank((String)dto.getMobile()) && StringUtils.isBlank((String)dto.getMember_code())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        boolean checkData = dto.checkData();
        if (!checkData) {
            this.logger.info("checkData\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dto));
            throw new ApiException("\u6821\u9a8c\u6570\u636e\u4e0d\u5408\u6cd5");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            throw new ApiException("\u6ca1\u6709\u8be5\u4f1a\u5458");
        }
        BrandEnum brandEnum = null;
        if ((dto.getPoint_source() == 5 || dto.getPoint_source() == 6) && (brandEnum = BrandEnum.getByValue(bunit = dto.getBunit())) == null) {
            throw new ApiException("\u54c1\u724c\u4e0d\u5b58\u5728");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        MemberPointsVo memberPoints = this.upmUpointsMapper.getMemberPoints(umUserinfo.getUserinfoCode());
        UpmUpointsClear upmUpointsClear = new UpmUpointsClear();
        upmUpointsClear.setUpointsType(dto.getPoint_type() + "");
        upmUpointsClear.setPointsRuleApi("upm.upointsClearBase.saveUpointsClear");
        upmUpointsClear.setUpointsOpType(dto.getPoint_source() + "");
        upmUpointsClear.setMemberCode(umUserinfo.getUserinfoCode());
        upmUpointsClear.setMemberName(umUserinfo.getUserinfoCompname());
        upmUpointsClear.setLevelUserqua("buy");
        upmUpointsClear.setUpointsClearRemark(dto.getRemark());
        upmUpointsClear.setUpointsListExcode(brandEnum != null ? brandEnum.getCode() : "20000210397487");
        upmUpointsClear.setUpointsClearOpcode(dto.getOrder_code());
        if (StringUtils.isBlank((String)dto.getOrder_code())) {
            upmUpointsClear.setUpointsClearOpcode(System.currentTimeMillis() + "");
        }
        upmUpointsClear.setUpointsClearDirection(dto.getPoint_value().compareTo(new BigDecimal(0)) > 0 ? "0" : "10");
        upmUpointsClear.setUpointsClearOpmark(memberPoints.getConsume_availd_points().toString());
        upmUpointsClear.setUpointsClearNum(dto.getPoint_value().compareTo(new BigDecimal(0)) > 0 ? dto.getPoint_value() : dto.getPoint_value().abs());
        upmUpointsClear.setGmtCreate(new Date());
        upmUpointsClear.setGmtModified(new Date());
        upmUpointsClear.setDataState(1);
        upmUpointsClear.setTenantCode("2022012800000001");
        upmUpointsClear.setMemberMcode(brandEnum != null ? brandEnum.getCode() : "20000210397487");
        this.logger.info("\u6253\u5370\u8fd4\u56de\u53c2\u6570");
        Object clearCode = this.insertUpmUpointsClear(upmUpointsClear);
        this.logger.info("\u6253\u5370\u8fd4\u56de\u53c2\u6570");
        if (clearCode == null) {
            throw new ApiException("\u64cd\u4f5c\u5931\u8d25");
        }
        return (String)clearCode;
    }

    public Object insertUpmUpointsClear(UpmUpointsClear clear) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsClearDomain", JsonUtil.buildNormalBinder().toJson((Object)clear));
        Object departCode = this.getInternalRouter().inInvoke("upm.upointsClearBase.sendUpointsClear", pmap);
        return departCode;
    }

    @Override
    public CouponInfoVo cdpGetCouponInfo(String resStream) {
        MemberCouponDto dto = new MemberCouponDto();
        dto = this.strToDto(dto, resStream);
        this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dto));
        if (StringUtils.isBlank((String)dto.getCoupon_code()) && StringUtils.isBlank((String)dto.getCoupon_batch_code())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)dto.getCoupon_code())) {
            return this.getPmPromotion(dto.getCoupon_batch_code());
        }
        return this.getUserCoupon(dto.getCoupon_code());
    }

    private CouponInfoVo getUserCoupon(String coupon_code) {
        List<PmUserCoupon> couponNo = this.pmUserCouponMapper.query((Map<String, Object>)ImmutableMap.of((Object)"couponNo", (Object)coupon_code));
        if (CollectionUtils.isEmpty(couponNo)) {
            throw new ApiException("\u65e0\u7528\u6237\u4f18\u60e0\u5238");
        }
        PmUserCoupon pmUserCoupon = couponNo.get(0);
        this.logger.info("\u6253\u5370\u4f18\u60e0\u5238\u72b6\u6001\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pmUserCoupon));
        String memberBcode = pmUserCoupon.getMemberBcode();
        if (StringUtils.isBlank((String)memberBcode)) {
            throw new ApiException("\u4f18\u60e0\u5238\u672a\u7ed1\u5b9a\u7528\u6237");
        }
        List<UmUserinfo> userinfoCode = this.umUserinfoMapper.query((Map<String, Object>)ImmutableMap.of((Object)"userinfoCode", (Object)memberBcode));
        if (CollectionUtils.isEmpty(userinfoCode)) {
            throw new ApiException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        UmUserinfo umUserinfo = userinfoCode.get(0);
        CouponInfoVo pmPromotion = this.getPmPromotion(pmUserCoupon.getCouponBatch());
        pmPromotion.setMember_code(umUserinfo.getUserinfoOcode());
        pmPromotion.setMobile(umUserinfo.getUserinfoPhone());
        pmPromotion.setStart_time(DateUtils.parseDate((Date)pmUserCoupon.getCouponStart()));
        pmPromotion.setEnd_time(DateUtils.parseDate((Date)pmUserCoupon.getCouponEnd()));
        pmPromotion.setCoupon_status(pmUserCoupon.getDataState());
        return pmPromotion;
    }

    public <T> T strToDto(T t, String resStream) {
        if (StringUtils.isBlank((String)resStream)) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        t = JsonUtil.buildNonDefaultBinder().getJsonToObject(resStream, t.getClass());
        if (Objects.isNull(t)) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        return t;
    }

    @Override
    public List<MemberCouponsVo> cdpGetMemberCoupons(String resStream) {
        GetMemberCouponsDto dto = new GetMemberCouponsDto();
        dto = this.strToDto(dto, resStream);
        this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dto));
        if (Objects.isNull(dto) || StringUtils.isBlank((String)dto.getMobile()) && StringUtils.isBlank((String)dto.getMember_code())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            throw new ApiException("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        HashMap<String, Object> pmUserCouponMap = new HashMap<String, Object>();
        pmUserCouponMap.put("memberBcode", umUserinfo.getUserinfoCode());
        pmUserCouponMap.put("dataState", dto.getCoupon_status());
        List<PmUserCoupon> userCouponList = this.pmUserCouponMapper.query(pmUserCouponMap);
        this.logger.info("\u6253\u5370\u67e5\u8be2\u7684\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(userCouponList));
        if (CollectionUtils.isEmpty(userCouponList)) {
            return new ArrayList<MemberCouponsVo>();
        }
        List<MemberCouponsVo> list = MemberConvert.memberCouponsConvert(userCouponList);
        for (MemberCouponsVo vo : list) {
            PmPromotionDiscount promotionCode = this.pmPromotionDiscountMapper.getByCode((Map<String, Object>)ImmutableMap.of((Object)"promotionCode", (Object)vo.getPromotion_code()));
            vo.setRemark(promotionCode.getDiscName());
        }
        return list;
    }

    @Override
    public String cdpGrantMemberCoupon(String resStream) {
        this.logger.info("\u6253\u5370\u8bf7\u6c42\u53c2\u6570\u65e5\u5fd7\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)resStream));
        GrantMemberCouponDto dto = new GrantMemberCouponDto();
        dto = this.strToDto(dto, resStream);
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getPlat_code()) || StringUtils.isBlank((String)dto.getCoupon_batch_code())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        PlatCodeEnum platCodeEnum = PlatCodeEnum.getByName(dto.getPlat_code());
        if (Objects.isNull((Object)platCodeEnum)) {
            throw new ApiException("\u4e0d\u652f\u6301\u8be5\u5e73\u53f0\uff0c\u8bf7\u8f93\u5165\u652f\u6301\u7684\u5e73\u53f0!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            throw new ApiException("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        HashMap<String, Object> pmPromotionMap = new HashMap<String, Object>();
        pmPromotionMap.put("couponBatch", dto.getCoupon_batch_code());
        List<PmPromotionIn> pmPromotionIns = this.pmPromotionInMapper.query(pmPromotionMap);
        this.logger.info(".cdpGrantMemberCoupon.pmPromotionIns:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(pmPromotionIns));
        if (CollectionUtils.isEmpty(pmPromotionIns)) {
            throw new ApiException("\u4f18\u60e0\u5238\u4e0d\u5b58\u5728!");
        }
        PmPromotionIn pmPromotionInDomain = pmPromotionIns.get(0);
        String promotionActurl = pmPromotionInDomain.getPromotionActurl();
        this.logger.info("PromotionActurl\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)promotionActurl));
        if (!promotionActurl.equals("2")) {
            throw new ApiException("\u8be5\u4f18\u60e0\u5238\u4e0d\u662f\u63a5\u53e3\u53d1\u5238");
        }
        if (pmPromotionInDomain.getGoodsClass().equals("2")) {
            throw new ApiException("\u8be5\u4f18\u60e0\u5238\u4e0d\u80fd\u5728\u7ebf\u4e0b\u4f7f\u7528!");
        }
        if (null != pmPromotionInDomain && pmPromotionInDomain.getCouponOnceNums() < pmPromotionInDomain.getCouponOnceNumd()) {
            this.logger.error(".saveUsercoupon.couponOnceNumd", (Object)"\u5df2\u9886\u5b8c");
            throw new ApiException("\u4f18\u60e0\u5238\u5df2\u9886\u5b8c!");
        }
        PmUserBean pmUserBean = new PmUserBean();
        pmUserBean.setAmonut(null);
        pmUserBean.setNum(1);
        pmUserBean.setGoodsClass(pmPromotionInDomain.getGoodsClass());
        pmUserBean.setUsercouponOrgin(dto.getPlat_code());
        pmUserBean.setPromotionCode(pmPromotionInDomain.getPromotionCode());
        pmUserBean.setTenantCode(pmPromotionInDomain.getTenantCode());
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setProappCode("001");
        pmCheckBean.setTenantCode(pmPromotionInDomain.getTenantCode());
        pmCheckBean.setMemberCode("20000210397487");
        UserBean userBean = new UserBean();
        pmCheckBean.setUserBean(userBean);
        userBean.setMemberCode(umUserinfo.getUserinfoCode());
        userBean.setMemberName(umUserinfo.getUserinfoCompname());
        userBean.setProappCode(pmCheckBean.getChannelCode());
        userBean.setTenantCode(pmCheckBean.getTenantCode());
        pmUserBean.setPmCheckBean(pmCheckBean);
        this.logger.info("\u53d1\u9001\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pmUserBean));
        return this.savePromotionUser(pmUserBean);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String cdpConsumeMemberCoupon(String resStream) {
        String coupon_code;
        ConsumeMemberCouponDto dto = new ConsumeMemberCouponDto();
        if (StringUtils.isBlank((String)(dto = this.strToDto(dto, resStream)).getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            throw new ApiException("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        if (StringUtils.isBlank((String)dto.getPlat_code())) {
            throw new ApiException("\u5e73\u53f0\u4e3a\u7a7a!");
        }
        String temp = coupon_code = dto.getCoupon_code();
        this.logger.info("\u6253\u5370\u65e5\u5fd7\uff1a{}" + coupon_code);
        if (StringUtils.isBlank((String)coupon_code)) {
            throw new ApiException("\u4f18\u60e0\u5238\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (coupon_code.contains("#")) {
            String isSuccess = DisUtil.get((String)coupon_code);
            if (StringUtils.isBlank((String)isSuccess)) {
                throw new ApiException("\u4f18\u60e0\u5238\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210");
            }
            coupon_code = coupon_code.substring(0, coupon_code.indexOf("#"));
        }
        if (StringUtils.isBlank((String)dto.getShop_code())) {
            throw new ApiException("\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a!");
        }
        PlatCodeEnum platCodeEnum = PlatCodeEnum.getByName(dto.getPlat_code());
        if (Objects.isNull((Object)platCodeEnum)) {
            throw new ApiException("\u4e0d\u652f\u6301\u8be5\u5e73\u53f0\uff0c\u8bf7\u8f93\u5165\u652f\u6301\u7684\u5e73\u53f0!");
        }
        List<PmUserCoupon> couponNo = this.pmUserCouponMapper.query((Map<String, Object>)ImmutableMap.of((Object)"couponNo", (Object)dto.getCoupon_code()));
        if (CollectionUtils.isEmpty(couponNo)) {
            throw new ApiException("\u8be5\u7528\u6237\u65e0\u8be5\u4f18\u60e0\u5238!");
        }
        PmUserCoupon usercoupon = couponNo.get(0);
        HashMap<String, Object> pmPromotionMap2 = new HashMap<String, Object>();
        pmPromotionMap2.put("couponBatch", usercoupon.getCouponBatch());
        List<PmPromotionIn> pmPromotionIns = this.pmPromotionInMapper.query(pmPromotionMap2);
        if (CollectionUtils.isEmpty(pmPromotionIns)) {
            throw new ApiException("\u8be5\u7528\u6237\u65e0\u8be5\u4f18\u60e0\u5238!");
        }
        PmPromotionIn pmPromotionIn = pmPromotionIns.get(0);
        Integer targetType = pmPromotionIn.getTargetType();
        if (targetType == 1) {
            if (!temp.contains("#")) {
                throw new ApiException("\u8be5\u4f18\u60e0\u5238\u4e0d\u5408\u6cd5!");
            }
            String memberBcode = usercoupon.getMemberBcode();
            if (!StringUtils.isNotBlank((String)memberBcode)) throw new ApiException("\u8be5\u4f18\u60e0\u5238\u6682\u65e0\u7ed1\u5b9a\u7528\u6237\uff0c\u65e0\u6cd5\u4f7f\u7528!");
            if (!umUserinfo.getUserinfoCode().equals(memberBcode)) {
                throw new ApiException("\u8be5\u4f18\u60e0\u5238\u4e0d\u5c5e\u4e8e\u8be5\u7528\u6237\uff0c\u65e0\u6cd5\u4f7f\u7528!");
            }
        } else {
            usercoupon.setMemberBcode(umUserinfo.getUserinfoCode());
        }
        if (usercoupon.getGoodsClass().equals("2")) {
            throw new ApiException("\u8be5\u4f18\u60e0\u5238\u4e0d\u80fd\u5728\u7ebf\u4e0b\u4f7f\u7528!");
        }
        if (usercoupon.getDataState() != 0) {
            throw new ApiException("\u8be5\u4f18\u60e0\u5238\u65e0\u6cd5\u4f7f\u7528!");
        }
        String storeCode = this.getStoreCode(dto.getShop_code());
        if (StringUtils.isBlank((String)storeCode)) {
            throw new ApiException("\u95e8\u5e97\u4e0d\u5b58\u5728!");
        }
        String companyCode = this.getCompanyCode(dto.getShop_code());
        if (StringUtils.isBlank((String)companyCode)) {
            throw new ApiException("\u95e8\u5e97\u6240\u5c5e\u54c1\u724c\u4e0d\u5b58\u5728!");
        }
        String channelUserinfoCode = this.umUserinfoMapper.getChannelUserInfoByUserinfoCodeAndChannelCode(umUserinfo.getUserinfoCode(), companyCode);
        if (StringUtils.isBlank((String)channelUserinfoCode)) {
            throw new ApiException("\u7528\u6237\u672a\u6ce8\u518c\uff0c\u8bf7\u95e8\u5e97\u6240\u5c5e\u54c1\u724c\u6ce8\u518c!");
        }
        Integer promotionDis = usercoupon.getPromotionDis();
        if (promotionDis == 0) {
            this.updateUserCouponDataState(usercoupon);
            this.addUserUseCoupon(usercoupon, dto, storeCode);
            return "success";
        } else {
            List collect;
            if (promotionDis != 1) return "success";
            HashMap<String, Object> pmPromotionMap = new HashMap<String, Object>();
            pmPromotionMap.put("promotionCode", usercoupon.getPromotionCode());
            List<PmPromotionDis> list = this.pmPromotionDisMapper.query(pmPromotionMap);
            if (!CollectionUtils.isEmpty(list) && CollectionUtils.isEmpty(collect = list.stream().filter(l -> !StringUtils.isBlank((String)l.getChannelCode()) && l.getChannelCode().equals(storeCode)).collect(Collectors.toList()))) {
                this.logger.info("PmPromotionDis:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list));
                throw new ApiException("\u8be5\u95e8\u5e97\u4e0d\u80fd\u4f7f\u7528\u8be5\u4f18\u60e0\u5238!");
            }
            this.updateUserCouponDataState(usercoupon);
            this.addUserUseCoupon(usercoupon, dto, storeCode);
        }
        return "success";
    }

    @Override
    public PointsExchangeCouponVo cdpPointsExchangeCoupon(String resStream) {
        PointsExchangeCouponDto dto = new PointsExchangeCouponDto();
        if (StringUtils.isBlank((String)(dto = this.strToDto(dto, resStream)).getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            throw new ApiException("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        this.logger.info("umUserinfo:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)umUserinfo));
        if (StringUtils.isBlank((String)dto.getPlat_code())) {
            throw new ApiException("\u5e73\u53f0\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getPoints_value())) {
            throw new ApiException("\u79ef\u5206\u4e3a\u7a7a!");
        }
        if (dto.getPoints_value().contains("-")) {
            throw new ApiException("\u79ef\u5206\u4e0d\u5408\u6cd5!");
        }
        List<PmPromotionIn> couponBatch = this.pmPromotionInMapper.query((Map<String, Object>)ImmutableMap.of((Object)"couponBatch", (Object)dto.getCoupon_batch_code()));
        this.logger.info("PmPromotionIn:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(couponBatch));
        if (CollectionUtils.isEmpty(couponBatch)) {
            throw new ApiException("\u65e0\u8be5\u4f18\u60e0\u5238!");
        }
        PmPromotionIn pmPromotionIn = couponBatch.get(0);
        if (pmPromotionIn.getDataState() != 1) {
            throw new ApiException("\u4f18\u60e0\u5238\u4e0d\u5728\u8fdb\u884c\u4e2d\uff0c\u65e0\u6cd5\u5151\u6362!");
        }
        if (!pmPromotionIn.getPromotionActurl().equals("2")) {
            throw new ApiException("\u8be5\u4f18\u60e0\u5238\u4e0d\u662f\u63a5\u53e3\u53d1\u5238");
        }
        if (pmPromotionIn.getGoodsClass().equals("2")) {
            throw new ApiException("\u8be5\u4f18\u60e0\u5238\u4e0d\u80fd\u5728\u7ebf\u4e0b\u4f7f\u7528!");
        }
        MemberPointsVo memberPoints = this.upmUpointsMapper.getMemberPoints(umUserinfo.getUserinfoCode());
        this.logger.info("memberPoints:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)memberPoints));
        if (Objects.isNull(memberPoints)) {
            throw new ApiException("\u8be5\u7528\u6237\u8fd8\u672a\u62e5\u6709\u79ef\u5206!");
        }
        String point = memberPoints.getConsume_availd_points();
        if (new BigDecimal(point).compareTo(new BigDecimal(dto.getPoints_value())) < 0) {
            throw new ApiException("\u7528\u6237\u79ef\u5206\u4e0d\u8db3!");
        }
        GrantMemberCouponDto couponDto = new GrantMemberCouponDto();
        couponDto.setCoupon_batch_code(dto.getCoupon_batch_code());
        couponDto.setMember_code(dto.getMember_code());
        couponDto.setMobile(dto.getMobile());
        couponDto.setPlat_code(dto.getPlat_code());
        HtmlJsonReBean htmlJsonReBean = this.pointsExchangeCoupon(couponDto);
        if (!htmlJsonReBean.isSuccess()) {
            throw new ApiException("\u5151\u6362\u4f18\u60e0\u5238\u5931\u8d25!");
        }
        String couponCode = (String)htmlJsonReBean.getDataObj();
        ModifyMemberPointsDto memberPointsDto = new ModifyMemberPointsDto();
        memberPointsDto.setPoint_value(new BigDecimal("-" + dto.getPoints_value()));
        memberPointsDto.setMobile(dto.getMobile());
        memberPointsDto.setMember_code(dto.getMember_code());
        memberPointsDto.setPoint_source(3);
        memberPointsDto.setPoint_type(1);
        memberPointsDto.setRemark(dto.getRemark());
        this.cdpModifyMemberPoints(JsonUtil.buildNonDefaultBinder().toJson((Object)memberPointsDto));
        PointsExchangeCouponVo vo = new PointsExchangeCouponVo();
        PmUserCoupon usercoupon_code = this.pmUserCouponMapper.getByCode((Map<String, Object>)ImmutableMap.of((Object)"usercouponCode", (Object)couponCode));
        if (Objects.isNull(usercoupon_code)) {
            throw new ApiException("\u6839\u636e\u5238\u7801\u672a\u67e5\u8be2\u5230\u4f18\u60e0\u5238!");
        }
        vo.setCoupon_code(usercoupon_code.getCouponNo());
        MemberPointsVo memberPoints1 = this.upmUpointsMapper.getMemberPoints(umUserinfo.getUserinfoCode());
        this.logger.info("\u53ef\u7528\u79ef\u5206memberPoints1\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)memberPoints1));
        vo.setConsume_availd_points(memberPoints1.getConsume_availd_points());
        return vo;
    }

    @Override
    public List<MembrOcContractVo> cdpGetMemberOrders(String resStream) {
        List<MembrOcContractVo> list1;
        MemberOrdersDto dto = new MemberOrdersDto();
        dto = this.strToDto(dto, resStream);
        this.logger.info("cdpGetMemberOrders\u8bf7\u6c42\u53c2\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)dto));
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getEnd_date()) || StringUtils.isBlank((String)dto.getStart_date())) {
            throw new ApiException("\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            throw new ApiException("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        ArrayList<MembrOcContractVo> list = new ArrayList<MembrOcContractVo>();
        if (dto.getOrder_type() == null || dto.getOrder_type() == 1) {
            list1 = this.ocContractMapper.cdpGetMemberOrders(dto, umUserinfo.getUserinfoCode());
            this.logger.info("ocContract:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list1));
            list.addAll(list1);
        } else if (dto.getOrder_type() == null || dto.getOrder_type() == 2) {
            list1 = this.ocContractMapper.cdpGetMemberRefundOrders(dto, umUserinfo.getUserinfoCode());
            this.logger.info("ocRefund2:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list1));
            list.addAll(list1);
        } else if (dto.getOrder_type() == null || dto.getOrder_type() == 3) {
            list1 = this.ocContractMapper.cdpGetMemberRefundOrders2(dto, umUserinfo.getUserinfoCode());
            this.logger.info("ocRefund3:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list1));
            list.addAll(list1);
        } else if (dto.getOrder_type() == null || dto.getOrder_type() == 4) {
            list1 = this.ocContractMapper.cdpGetMemberRefundOrders3(dto, umUserinfo.getUserinfoCode());
            this.logger.info("ocRefund4:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list1));
            list.addAll(list1);
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (MembrOcContractVo membrOcContractVo : list) {
                if (membrOcContractVo.getOrder_type().equals("1")) {
                    this.getOrderGoods(membrOcContractVo);
                    continue;
                }
                this.getRefundGoods(membrOcContractVo);
            }
        }
        this.logger.info("\u67e5\u8be2\u5230\u7684\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(list));
        return list;
    }

    private void getRefundGoods(MembrOcContractVo membrOcContractVo) {
        this.logger.info("\u83b7\u53d6\u8ba2\u5355\u5546\u54c1\u5f00\u59cb:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)membrOcContractVo));
        HashMap<String, Object> goodsMap = new HashMap<String, Object>();
        goodsMap.put("contractBillcode", membrOcContractVo.getContact_bill());
        List<OcContractGoods> query = this.ocContractGoodsMapper.query(goodsMap);
        ArrayList<GoodsVo> vos = new ArrayList<GoodsVo>();
        for (OcContractGoods ocContractGoods : query) {
            GoodsVo goodsVo = new GoodsVo();
            goodsVo.setGoods_name(ocContractGoods.getGoodsName());
            goodsVo.setGoods_sku(ocContractGoods.getSkuNo());
            goodsVo.setGoods_sku_name(ocContractGoods.getSkuName());
            goodsVo.setGoods_spu(ocContractGoods.getGoodsNo());
            goodsVo.setGoods_number(ocContractGoods.getGoodsNum());
            goodsVo.setGoods_pay_price(ocContractGoods.getContractGoodsPrice() != null ? ocContractGoods.getContractGoodsPrice().setScale(2).toString() : "0");
            goodsVo.setGoods_market_price(ocContractGoods.getPricesetNprice() != null ? ocContractGoods.getPricesetNprice().setScale(2).toString() : "0");
            goodsVo.setGoods_price(ocContractGoods.getPricesetMakeprice() != null ? ocContractGoods.getPricesetMakeprice().setScale(2).toString() : "0");
            goodsVo.setGoods_type(ocContractGoods.getGoodsType());
            vos.add(goodsVo);
        }
        membrOcContractVo.setGoodsList(vos);
        this.logger.info("\u83b7\u53d6\u8ba2\u5355\u5546\u54c1\u7ed3\u675f:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)membrOcContractVo));
    }

    private void getOrderGoods(MembrOcContractVo membrOcContractVo) {
        this.logger.info("\u83b7\u53d6\u9000\u6b3e\u5546\u54c1\u5f00\u59cb:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)membrOcContractVo));
        HashMap<String, Object> goodsMap = new HashMap<String, Object>();
        goodsMap.put("refundCode", membrOcContractVo.getContact_aftermarket_code());
        List<OcRefundGoods> query = this.ocRefundGoodsMapper.query(goodsMap);
        List<OcRefund> ocrefund = this.ocRefundMapper.query(goodsMap);
        OcRefund ocRefund = ocrefund.get(0);
        ArrayList<GoodsVo> vos = new ArrayList<GoodsVo>();
        for (OcRefundGoods ocRefundGoods : query) {
            GoodsVo goodsVo = new GoodsVo();
            goodsVo.setGoods_name(ocRefundGoods.getGoodsName());
            goodsVo.setGoods_sku(ocRefundGoods.getSkuNo());
            goodsVo.setGoods_sku_name(ocRefundGoods.getSkuName());
            goodsVo.setGoods_spu(ocRefundGoods.getGoodsNo());
            goodsVo.setGoods_number(ocRefundGoods.getGoodsNum());
            goodsVo.setGoods_pay_price(ocRefundGoods.getContractGoodsPrice() != null ? ocRefundGoods.getContractGoodsPrice().setScale(2).toString() : "0");
            goodsVo.setGoods_market_price(ocRefundGoods.getPricesetNprice() != null ? ocRefundGoods.getPricesetNprice().setScale(2).toString() : "0");
            goodsVo.setGoods_price(ocRefundGoods.getPricesetMakeprice() != null ? ocRefundGoods.getPricesetMakeprice().setScale(2).toString() : "0");
            goodsVo.setGoods_type(ocRefundGoods.getGoodsType());
            goodsVo.setGoods_return_number(ocRefund.getGoodsNum() + "");
            goodsVo.setAmt_refund(ocRefund.getRefundMoney() + "");
            vos.add(goodsVo);
        }
        membrOcContractVo.setGoodsList(vos);
        this.logger.info("\u83b7\u53d6\u9000\u6b3e\u5546\u54c1\u7ed3\u679c:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)membrOcContractVo));
    }

    private Object subMemberPoint(UmUserinfo umUserinfo, PmPromotionIn pmPromotionIn, String points_value, String couponCode) {
        UpmUpointsOpDomain upmUpointsOpDomain = new UpmUpointsOpDomain();
        upmUpointsOpDomain.setMemberName(umUserinfo.getUserinfoCompname());
        upmUpointsOpDomain.setMemberCode(umUserinfo.getUserinfoCode());
        upmUpointsOpDomain.setLevelUserqua("buy");
        upmUpointsOpDomain.setMemberMcode(pmPromotionIn.getMemberCode());
        upmUpointsOpDomain.setUserCode(pmPromotionIn.getMemberCode());
        upmUpointsOpDomain.setTenantCode(umUserinfo.getTenantCode());
        upmUpointsOpDomain.setUpointsType("0");
        upmUpointsOpDomain.setUpointsOpType("0");
        upmUpointsOpDomain.setUpointsOpNum(new BigDecimal(points_value));
        upmUpointsOpDomain.setUpointsOpRemark(couponCode);
        if (StringUtils.isBlank((String)upmUpointsOpDomain.getGoodsClass())) {
            upmUpointsOpDomain.setGoodsClass("4");
        }
        return this.saveUpointsOp(upmUpointsOpDomain);
    }

    private void addUserUseCoupon(PmUserCoupon usercoupon, ConsumeMemberCouponDto dto, String storeCode) {
        PmUserUsecoupon pmUserUsecoupon = new PmUserUsecoupon();
        pmUserUsecoupon.setPbCode(usercoupon.getPbCode());
        pmUserUsecoupon.setPbName(usercoupon.getPbName());
        pmUserUsecoupon.setPromotionCode(usercoupon.getPromotionCode());
        pmUserUsecoupon.setPromotionName(usercoupon.getPromotionName());
        pmUserUsecoupon.setCouponBatch(usercoupon.getCouponBatch());
        pmUserUsecoupon.setCouponNo(usercoupon.getCouponNo());
        pmUserUsecoupon.setCouponUseamount(1);
        pmUserUsecoupon.setCouponStart(usercoupon.getCouponStart());
        pmUserUsecoupon.setCouponEnd(usercoupon.getCouponEnd());
        pmUserUsecoupon.setDataState(1);
        pmUserUsecoupon.setMemberCode(usercoupon.getMemberCode());
        pmUserUsecoupon.setMemberBcode(usercoupon.getMemberBcode());
        pmUserUsecoupon.setUserCode(storeCode);
        pmUserUsecoupon.setTenantCode(usercoupon.getTenantCode());
        this.saveUserUseCoupon(pmUserUsecoupon);
    }

    public Object saveUserUseCoupon(PmUserUsecoupon pmUserUsecoupon) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("pmUserUsecouponDomain", JsonUtil.buildNormalBinder().toJson((Object)pmUserUsecoupon));
        Object result = this.getInternalRouter().inInvoke("pm.PmUserUsecoupon.saveUserUsecoupon", pmap);
        return result;
    }

    public String getStoreCode(String storeOcode) {
        String userinfoCode = this.umUserinfoMapper.getStoreCodeByOcode(storeOcode);
        return userinfoCode;
    }

    public String getCompanyCode(String departOcode) {
        String companyCode = this.umUserinfoMapper.getCompanyCodeByOcode(departOcode);
        return companyCode;
    }

    private void updateUserCouponDataState(PmUserCoupon usercoupon) {
        this.pmUserCouponMapper.updateStateByCode((Map<String, Object>)ImmutableMap.of((Object)"usercouponCode", (Object)usercoupon.getUsercouponCode(), (Object)"dataState", (Object)1, (Object)"memberBcode", (Object)usercoupon.getMemberBcode()));
    }

    private Object saveUpointsOp(UpmUpointsOpDomain upmUpointsOpDomain) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsOpDomain", JsonUtil.buildNormalBinder().toJson((Object)upmUpointsOpDomain));
        Object result = this.getInternalRouter().inInvoke("upm.upointsOp.saveUpointsOp", pmap);
        return result;
    }

    public Object insertUserCoupon(PmUserBean bean) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("pmUserBean", JsonUtil.buildNormalBinder().toJson((Object)bean));
        Object result = this.getInternalRouter().inInvoke("zyCdp.pmPromotion.savePromotionUser", pmap);
        return result;
    }

    private CouponInfoVo getPmPromotion(String coupon_batch_code) {
        List<PmPromotionTargetlist> pmPromotionTargetList;
        HashMap<String, Object> pm = new HashMap<String, Object>();
        pm.put("couponBatch", coupon_batch_code);
        List<PmPromotion> query = this.pmPromotionMapper.query(pm);
        if (CollectionUtils.isEmpty(query)) {
            throw new ApiException("\u4f18\u60e0\u5238\u4e0d\u5b58\u5728");
        }
        PmPromotion pmPromotion = query.get(0);
        CouponInfoVo couponInfoVo = new CouponInfoVo();
        couponInfoVo.setCoupon_batch_name(pmPromotion.getPromotionName());
        couponInfoVo.setCoupon_batch_code(pmPromotion.getCouponBatch());
        couponInfoVo.setCoupon_bnatch_status(pmPromotion.getDataState() == 1 ? 1 : 0);
        couponInfoVo.setBatch_end_time(DateUtils.parseDate((Date)pmPromotion.getPromotionEndtime()));
        couponInfoVo.setBatch_start_time(DateUtils.parseDate((Date)pmPromotion.getPromotionBegintime()));
        couponInfoVo.setAllow_give(pmPromotion.getSendtype() == 5 ? 1 : 0);
        couponInfoVo.setAllow_overlying(pmPromotion.getSharetype());
        couponInfoVo.setIssue_number(pmPromotion.getCouponOnceNums());
        couponInfoVo.setDraw_number(pmPromotion.getPromotionFrequency());
        couponInfoVo.setUse_number(1);
        couponInfoVo.setCoupon_type(pmPromotion.getPbCode().equals("0005") ? 3 : (pmPromotion.getPbCode().equals("0003") ? 1 : (pmPromotion.getPbCode().equals("0004") ? Integer.valueOf(2) : null)));
        couponInfoVo.setCondition_type(pmPromotion.getPromotionFsort() + "");
        this.getPromotionReRelatedData(pmPromotion);
        couponInfoVo.setIssue_channel(pmPromotion.getGoodsClass());
        List<PmPromotionRangelist> pmPromotionRangeList = pmPromotion.getPmPromotionRangeList();
        if (!CollectionUtils.isEmpty(pmPromotionRangeList)) {
            List collect = pmPromotionRangeList.stream().map(pm1 -> pm1.getRangeCode()).collect(Collectors.toList());
            couponInfoVo.setIssue_goods(String.join((CharSequence)",", collect));
        }
        if (!CollectionUtils.isEmpty(pmPromotionTargetList = pmPromotion.getPmPromotionTargetList())) {
            List list = pmPromotionTargetList.stream().map(pm1 -> pm1.getTargetCode()).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(pmPromotion.getPmPromotionDiscountList())) {
            PmPromotionDiscount pmPromotionDiscount = pmPromotion.getPmPromotionDiscountList().get(0);
            couponInfoVo.setCoupon_value(pmPromotionDiscount.getDiscAmount().setScale(2).toString());
            couponInfoVo.setCondition_value(pmPromotionDiscount.getDiscEnd().compareTo(new BigDecimal("-1")) == 0 ? pmPromotionDiscount.getDiscStart().setScale(2).toString() : pmPromotionDiscount.getDiscEnd().setScale(2).toString());
        }
        couponInfoVo.setIssue_rule(pmPromotion.getGoodsClass());
        List<PmCdpPromotionDisTemp> list = this.pmPromotionMapper.qeuryCdpPromotionTemp(pmPromotion.getPromotionCode());
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<String> issueRanges = new ArrayList<String>();
            for (PmCdpPromotionDisTemp pmCdpPromotionDisTemp : list) {
                if (pmCdpPromotionDisTemp.getChannelType() == 1) {
                    List<String> topDepart = this.getTopDepart(pmCdpPromotionDisTemp.getChannelCode());
                    issueRanges.addAll(topDepart);
                }
                if (pmCdpPromotionDisTemp.getChannelType() == 2) {
                    List<String> midDepart = this.getMidDepart(pmCdpPromotionDisTemp.getChannelCode());
                    issueRanges.addAll(midDepart);
                }
                if (pmCdpPromotionDisTemp.getChannelType() == 3) {
                    // empty if block
                }
                if (pmCdpPromotionDisTemp.getChannelType() != 4) continue;
                issueRanges.add(pmCdpPromotionDisTemp.getChannelCode());
            }
            if (!CollectionUtils.isEmpty(issueRanges)) {
                couponInfoVo.setIssue_ranges(String.join((CharSequence)",", issueRanges));
            }
        }
        return couponInfoVo;
    }

    private List<String> getMidDepart(String channelCode) {
        List collect;
        List<OrgDepart> query = this.orgDepartMapper.query((Map<String, Object>)ImmutableMap.of((Object)"departOcode", (Object)channelCode));
        if (!CollectionUtils.isEmpty(query) && !CollectionUtils.isEmpty(collect = ((Stream)query.stream().parallel()).filter(q -> !q.getDepartPcode().equals("-1")).collect(Collectors.toList()))) {
            return collect.stream().map(c -> c.getDepartOcode()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> getTopDepart(String channelCode) {
        List collect;
        List<OrgDepart> query = this.orgDepartMapper.query((Map<String, Object>)ImmutableMap.of((Object)"companyCode", (Object)channelCode));
        if (!CollectionUtils.isEmpty(query) && !CollectionUtils.isEmpty(collect = ((Stream)query.stream().parallel()).filter(q -> !q.getDepartPcode().equals("-1")).collect(Collectors.toList()))) {
            return collect.stream().map(c -> c.getDepartOcode()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<UmUserinfo> getUmUserinfos(String memberPhone, String userinfoOcode) {
        HashMap<String, Object> umUserinfoMap = new HashMap<String, Object>();
        umUserinfoMap.put("fuzzy", false);
        if (!StringUtils.isBlank((String)memberPhone)) {
            umUserinfoMap.put("userinfoPhone", memberPhone);
        }
        if (!StringUtils.isBlank((String)userinfoOcode)) {
            umUserinfoMap.put("userinfoOcode", userinfoOcode);
        }
        this.logger.info("\u6253\u5370\u5165\u53c2\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(umUserinfoMap));
        return this.umUserinfoMapper.query(umUserinfoMap);
    }

    public HtmlJsonReBean pointsExchangeCoupon(GrantMemberCouponDto dto) {
        if (StringUtils.isBlank((String)dto.getMember_code()) && StringUtils.isBlank((String)dto.getMobile())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)dto.getPlat_code()) || StringUtils.isBlank((String)dto.getCoupon_batch_code())) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a!");
        }
        PlatCodeEnum platCodeEnum = PlatCodeEnum.getByName(dto.getPlat_code());
        if (Objects.isNull((Object)platCodeEnum)) {
            throw new ApiException("\u4e0d\u652f\u6301\u8be5\u5e73\u53f0\uff0c\u8bf7\u8f93\u5165\u652f\u6301\u7684\u5e73\u53f0!");
        }
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(dto.getMobile(), dto.getMember_code());
        if (CollectionUtils.isEmpty(umUserinfos)) {
            throw new ApiException("\u8be5\u4f1a\u5458\u4e0d\u5b58\u5728!");
        }
        UmUserinfo umUserinfo = umUserinfos.get(0);
        HashMap<String, Object> pmPromotionMap = new HashMap<String, Object>();
        pmPromotionMap.put("couponBatch", dto.getCoupon_batch_code());
        List<PmPromotionIn> pmPromotionIns = this.pmPromotionInMapper.query(pmPromotionMap);
        this.logger.info(".cdpGrantMemberCoupon.pmPromotionIns:{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(pmPromotionIns));
        if (CollectionUtils.isEmpty(pmPromotionIns)) {
            throw new ApiException("\u4f18\u60e0\u5238\u5ba1\u6838\u672a\u901a\u8fc7!");
        }
        PmPromotionIn pmPromotionInDomain = pmPromotionIns.get(0);
        String promotionActurl = pmPromotionInDomain.getPromotionActurl();
        this.logger.info("PromotionActurl\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)promotionActurl));
        if (null != pmPromotionInDomain && pmPromotionInDomain.getCouponOnceNums() < pmPromotionInDomain.getCouponOnceNumd()) {
            this.logger.error(".saveUsercoupon.couponOnceNumd", (Object)"\u5df2\u9886\u5b8c");
            throw new ApiException("\u4f18\u60e0\u5238\u5df2\u9886\u5b8c!");
        }
        PmUserBean pmUserBean = new PmUserBean();
        pmUserBean.setAmonut(null);
        pmUserBean.setNum(1);
        pmUserBean.setGoodsClass(pmPromotionInDomain.getGoodsClass());
        pmUserBean.setUsercouponOrgin(dto.getPlat_code());
        pmUserBean.setPromotionCode(pmPromotionInDomain.getPromotionCode());
        pmUserBean.setTenantCode(pmPromotionInDomain.getTenantCode());
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setProappCode("001");
        pmCheckBean.setTenantCode(pmPromotionInDomain.getTenantCode());
        UserBean userBean = new UserBean();
        pmCheckBean.setUserBean(userBean);
        userBean.setMemberCode(umUserinfo.getUserinfoCode());
        userBean.setMemberName(umUserinfo.getUserinfoCompname());
        userBean.setProappCode(pmCheckBean.getChannelCode());
        userBean.setTenantCode(pmCheckBean.getTenantCode());
        pmUserBean.setPmCheckBean(pmCheckBean);
        this.logger.info("\u53d1\u9001\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pmUserBean));
        return new HtmlJsonReBean(this.savePromotionUser(pmUserBean));
    }

    public String savePromotionUser(PmUserBean pmUserBean) {
        String num;
        PmCheckBean pmCheckBean;
        PmUserCouponDomain pmUserCouponDomain;
        PmCdpPromotion pmCdpPromotion;
        Integer promotionValidType;
        this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pmUserBean));
        if (null == pmUserBean || null == pmUserBean.getPmCheckBean() || null == pmUserBean.getPmCheckBean().getUserBean()) {
            return null;
        }
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getMapJson((String)"pm-promotion", (String)(pmUserBean.getPromotionCode() + "-" + pmUserBean.getTenantCode()), PmPromotionInDomain.class);
        if (null == pmPromotionInDomain) {
            PmPromotionIn promotionInByCode = this.pmPromotionInMapper.getByCode((Map<String, Object>)ImmutableMap.of((Object)"tenantCode", (Object)pmUserBean.getTenantCode(), (Object)"promotionInCode", (Object)pmUserBean.getPromotionInCode()));
            if (null == promotionInByCode || 1 != promotionInByCode.getDataState()) {
                this.logger.error(".savePromotionUser.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pmUserBean));
                throw new ApiException(".savePromotionUser.pmPromotion", "\u5df2\u7ed3\u675f");
            }
            try {
                BeanUtils.copyAllPropertys((Object)pmPromotionInDomain, (Object)promotionInByCode);
            }
            catch (Exception e) {
                this.logger.error(".savePromotionUser.copy", (Throwable)e);
            }
        }
        String promotionOcode = pmPromotionInDomain.getPromotionOcode();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("promotionId", promotionOcode);
        List<PmCdpPromotion> pmCdpPromotions = this.cdpPmPromotionMapper.queryCdpPromotionTemplate(hashMap);
        if (CollectionUtils.isEmpty(pmCdpPromotions)) {
            this.logger.info("\u6a21\u677f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(pmCdpPromotions));
        }
        if ((promotionValidType = (pmCdpPromotion = pmCdpPromotions.get(0)).getPromotionValidType()) == 0) {
            long nowTime = System.currentTimeMillis();
            if (null != pmPromotionInDomain.getReceiveStart() && nowTime < pmPromotionInDomain.getReceiveStart().getTime()) {
                throw new ApiException(".savePromotionUser.ReceiveStart", "\u9886\u53d6\u4f18\u60e0\u5238\u672a\u5f00\u59cb");
            }
            if (null != pmPromotionInDomain.getReceiveEnd() && nowTime > pmPromotionInDomain.getReceiveEnd().getTime()) {
                throw new ApiException(".savePromotionUser.ReceiveEnd", "\u9886\u53d6\u4f18\u60e0\u5238\u5df2\u7ecf\u7ed3\u675f");
            }
        }
        if (null == (pmUserCouponDomain = this.makeUserCoupon(pmUserBean, pmPromotionInDomain, pmCheckBean = pmUserBean.getPmCheckBean(), pmCdpPromotion))) {
            throw new ApiException(".savePromotionUser.pmUserCouponDomain");
        }
        Integer promotionFrequency = pmPromotionInDomain.getPromotionFrequency();
        if (null != promotionFrequency && 0 != promotionFrequency && StringUtils.isNotBlank((String)(num = DisUtil.getRemotMap((String)(pmPromotionInDomain.getPromotionCode() + "-" + pmPromotionInDomain.getTenantCode()), (String)pmUserCouponDomain.getMemberBcode()))) && Integer.valueOf(num) >= promotionFrequency) {
            throw new ApiException(".savePromotionUser.pmPromotionCoupon", "\u5df2\u5230\u9886\u53d6\u4e0a\u9650");
        }
        int num2 = pmUserBean.getNum();
        this.pmPromotionMapper.updateSendNum((Map<String, Object>)ImmutableMap.of((Object)"tenantCode", (Object)pmUserBean.getTenantCode(), (Object)"promotionCode", (Object)pmUserBean.getPromotionCode(), (Object)"couponOnceNumd", (Object)num2));
        ArrayList<PmUserCouponDomain> pmUserCouponDomainList = new ArrayList<PmUserCouponDomain>();
        for (int i = 0; i < num2; ++i) {
            PmUserCouponDomain batchPmUserCouponDomain = new PmUserCouponDomain();
            try {
                BeanUtils.copyAllPropertys((Object)batchPmUserCouponDomain, (Object)pmUserCouponDomain);
            }
            catch (Exception e) {
                this.logger.error(".savePromotionUser.e", (Throwable)e);
            }
            pmUserCouponDomainList.add(batchPmUserCouponDomain);
        }
        return this.saveUserCouponBatch(pmUserCouponDomainList);
    }

    public String saveUserCouponBatch(List<PmUserCouponDomain> pmUserCouponDomainList) throws ApiException {
        if (null == pmUserCouponDomainList || pmUserCouponDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (PmUserCouponDomain pmUserCouponDomain : pmUserCouponDomainList) {
            code = this.saveUserCoupon(pmUserCouponDomain);
        }
        return code;
    }

    public String saveUserCoupon(PmUserCouponDomain pmUserCouponDomain) throws ApiException {
        if (null == pmUserCouponDomain) {
            return null;
        }
        PmUserCoupon pmUserCoupon = this.createPmUserCoupon(pmUserCouponDomain);
        if (null == pmUserCoupon) {
            throw new ApiException(".saveUserCoupon.pmUserCoupon");
        }
        this.saveUserCouponModel(pmUserCoupon);
        String num = DisUtil.getRemotMap((String)(pmUserCouponDomain.getPromotionCode() + "-" + pmUserCouponDomain.getTenantCode()), (String)pmUserCouponDomain.getMemberBcode());
        if (StringUtils.isBlank((String)num)) {
            num = "0";
        }
        num = String.valueOf(Integer.valueOf(num) + 1);
        DisUtil.setMap((String)(pmUserCouponDomain.getPromotionCode() + "-" + pmUserCouponDomain.getTenantCode()), (String)pmUserCouponDomain.getMemberBcode(), (String)num);
        return pmUserCoupon.getUsercouponCode();
    }

    private void saveUserCouponModel(PmUserCoupon pmUserCoupon) throws ApiException {
        if (null == pmUserCoupon) {
            return;
        }
        try {
            this.pmUserCouponMapper.insert(pmUserCoupon);
        }
        catch (Exception e) {
            throw new ApiException(".saveUserCouponModel.ex", (Throwable)e);
        }
    }

    private String checkUserCoupon(PmUserCouponDomain pmUserCouponDomain) {
        if (null == pmUserCouponDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmUserCouponDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private PmUserCoupon createPmUserCoupon(PmUserCouponDomain pmUserCouponDomain) {
        String msg = this.checkUserCoupon(pmUserCouponDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(".saveUserCoupon.checkUserCoupon", msg);
        }
        PmUserCoupon pmUserCoupon = this.makeUserCoupon(pmUserCouponDomain, null);
        this.setUserCouponDefault(pmUserCoupon);
        return pmUserCoupon;
    }

    private PmUserCoupon makeUserCoupon(PmUserCouponDomain pmUserCouponDomain, PmUserCoupon pmUserCoupon) {
        if (null == pmUserCouponDomain) {
            return null;
        }
        if (null == pmUserCoupon) {
            pmUserCoupon = new PmUserCoupon();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCoupon, (Object)pmUserCouponDomain);
            return pmUserCoupon;
        }
        catch (Exception e) {
            this.logger.error(".makeUserCoupon", (Throwable)e);
            return null;
        }
    }

    private void setUserCouponDefault(PmUserCoupon pmUserCoupon) {
        if (null == pmUserCoupon) {
            return;
        }
        if (null == pmUserCoupon.getDataState()) {
            pmUserCoupon.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmUserCoupon.getGmtCreate()) {
            pmUserCoupon.setGmtCreate(date);
        }
        pmUserCoupon.setGmtModified(date);
        if (StringUtils.isBlank((String)pmUserCoupon.getUsercouponCode())) {
            pmUserCoupon.setUsercouponCode(this.getNo(null, "PmUserCoupon", "usercouponCode", pmUserCoupon.getTenantCode()));
        }
        if (StringUtils.isBlank((String)pmUserCoupon.getCouponNo())) {
            pmUserCoupon.setCouponNo(this.getNo(null, "PmUserCoupon", "couponNo", pmUserCoupon.getTenantCode()));
        }
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error(".getSysDate", (Throwable)e);
            return null;
        }
    }

    private PmUserCouponDomain makeUserCoupon(PmUserBean pmUserBean, PmPromotionInDomain pmPromotionInDomain, PmCheckBean pmCheckBean, PmCdpPromotion pmCdpPromotion) {
        if (null == pmUserBean || null == pmPromotionInDomain || null == pmCheckBean) {
            return null;
        }
        PmPromotionBaseDomain pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotionInDomain.getPbCode() + "-" + pmUserBean.getTenantCode()), PmPromotionBaseDomain.class);
        if (null == pmPromotionBaseDomain) {
            pmPromotionBaseDomain = (PmPromotionBaseDomain)DisUtil.getMapJson((String)"pm-promotion-base", (String)(pmPromotionInDomain.getPbCode() + "-" + "00000000"), PmPromotionBaseDomain.class);
        }
        if (null == pmPromotionBaseDomain) {
            return null;
        }
        Integer sendtype = pmPromotionInDomain.getSendtype();
        if (null == sendtype) {
            sendtype = 0;
        }
        PmUserCouponDomain pmUserCouponDomain = new PmUserCouponDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCouponDomain, (Object)pmPromotionInDomain);
        }
        catch (Exception e) {
            this.logger.error(".makeUserCoupon.copy", (Throwable)e);
        }
        pmUserCouponDomain.setDiscType(pmPromotionInDomain.getDiscType());
        pmUserCouponDomain.setPbLogo(pmPromotionBaseDomain.getPbLogo());
        pmUserCouponDomain.setPbName(pmPromotionBaseDomain.getPbName());
        if (sendtype != 0) {
            pmUserCouponDomain.setCouponAmount(pmUserBean.getAmonut());
        } else {
            pmUserCouponDomain.setCouponAmount(pmPromotionInDomain.getDiscAmount());
        }
        if (null == pmUserBean.getPmCheckBean()) {
            pmUserCouponDomain.setChannelCode(pmUserBean.getPmCheckBean().getChannelCode());
            pmUserCouponDomain.setChannelName(pmUserBean.getPmCheckBean().getChannelName());
        }
        pmUserCouponDomain.setPromotionDis(pmPromotionInDomain.getPromotionDis());
        pmUserCouponDomain.setPromotionDisstr(pmPromotionInDomain.getChannelCode());
        pmUserCouponDomain.setPbCode(pmPromotionInDomain.getPbCode());
        pmUserCouponDomain.setPromotionCode(pmPromotionInDomain.getPromotionCode());
        pmUserCouponDomain.setPromotionName(pmPromotionInDomain.getPromotionName());
        pmUserCouponDomain.setCouponBatch(pmPromotionInDomain.getCouponBatch());
        pmUserCouponDomain.setMemberCode(pmPromotionInDomain.getMemberCode());
        pmUserCouponDomain.setMemberName(pmPromotionInDomain.getMemberName());
        Integer promotionValidType = pmCdpPromotion.getPromotionValidType();
        String receiveTakeStart = pmCdpPromotion.getReceiveTakeStart();
        String receiveTakeEnd = pmCdpPromotion.getReceiveTakeEnd();
        Date date = new Date();
        if (promotionValidType == 0) {
            pmUserCouponDomain.setCouponStart(pmPromotionInDomain.getPromotionBegintime());
            pmUserCouponDomain.setCouponType(0);
            pmUserCouponDomain.setCouponStart(date);
            if (0 < pmPromotionInDomain.getCouponOnceOdate()) {
                pmUserCouponDomain.setCouponEnd(DateUtils.addMinutes((Date)date, (int)pmPromotionInDomain.getCouponOnceOdate()));
                pmUserCouponDomain.setCouponType(1);
            } else {
                pmUserCouponDomain.setCouponEnd(pmPromotionInDomain.getPromotionEndtime());
            }
        } else {
            pmUserCouponDomain.setCouponType(1);
            pmUserCouponDomain.setCouponEnd(DateUtils.addDays((Date)date, (int)Integer.valueOf(receiveTakeEnd)));
            pmUserCouponDomain.setCouponStart(DateUtils.addMinutes((Date)date, (int)Integer.valueOf(receiveTakeStart)));
        }
        pmUserCouponDomain.setDiscAmount(pmPromotionInDomain.getDiscAmount());
        pmUserCouponDomain.setGoodsClass(pmPromotionInDomain.getGoodsClass());
        PmPromotion promotionByCode1 = this.pmPromotionMapper.getByCode((Map<String, Object>)ImmutableMap.of((Object)"tenantCode", (Object)pmPromotionInDomain.getTenantCode(), (Object)"promotionCode", (Object)pmPromotionInDomain.getPromotionCode()));
        if (null == promotionByCode1) {
            this.logger.error(".makeUserCoupon.promotionByCode1", (Object)pmPromotionInDomain.getPromotionCode());
            return null;
        }
        pmUserCouponDomain.setPromotionRemark(promotionByCode1.getPromotionRemark());
        if ("0003".equals(pmPromotionInDomain.getPbCode())) {
            PmPromotion promotionByCode = this.pmPromotionMapper.getByCode((Map<String, Object>)ImmutableMap.of((Object)"tenantCode", (Object)pmPromotionInDomain.getTenantCode(), (Object)"promotionCode", (Object)pmPromotionInDomain.getPromotionCode()));
            if (null == promotionByCode) {
                return null;
            }
            this.getPromotionReRelatedData(promotionByCode);
            PmPromotionDiscount pmPromotionDiscount = promotionByCode.getPmPromotionDiscountList().get(0);
            Integer discSort = pmPromotionDiscount.getDiscSort();
            if (null == discSort || 0 == discSort) {
                pmUserCouponDomain.setDiscAmount(pmPromotionInDomain.getDiscAmount());
            } else if (1 == discSort) {
                int min = pmPromotionDiscount.getDiscSnium().intValue();
                int max = pmPromotionDiscount.getDiscEnum().intValue();
                int a = 0;
                for (int i = 0; i < 10; ++i) {
                    a = (int)Math.round(Math.random() * (double)(max - min) + (double)min);
                }
                pmUserCouponDomain.setCouponAmount(new BigDecimal(a));
            } else if (2 == discSort) {
                BigDecimal discAmount = pmPromotionDiscount.getDiscSnium().divide(new BigDecimal(100));
                pmUserCouponDomain.setCouponAmount(discAmount.multiply(pmCheckBean.getContractMoney()));
            }
        }
        pmUserCouponDomain.setRangeType(pmPromotionInDomain.getRangeType());
        pmUserCouponDomain.setPromotionOrgin(pmPromotionInDomain.getPromotionOrgin());
        pmUserCouponDomain.setDiscName(pmPromotionInDomain.getDiscName());
        pmUserCouponDomain.setDiscStart(pmPromotionInDomain.getDiscStart());
        pmUserCouponDomain.setChannelCode(pmPromotionInDomain.getChannelCode());
        pmUserCouponDomain.setChannelName(pmPromotionInDomain.getChannelName());
        pmUserCouponDomain.setDiscEnd(pmPromotionInDomain.getDiscEnd());
        pmUserCouponDomain.setChannelCode(pmCheckBean.getChannelCode());
        pmUserCouponDomain.setChannelName(pmCheckBean.getChannelName());
        pmUserCouponDomain.setGoodsClass(pmUserBean.getGoodsClass());
        pmUserCouponDomain.setUsercouponOrgin(pmUserBean.getUsercouponOrgin());
        pmUserCouponDomain.setMemberBcode(pmCheckBean.getUserBean().getMemberCode());
        pmUserCouponDomain.setMemberBname(pmCheckBean.getUserBean().getMemberName());
        pmUserCouponDomain.setMemberName(pmCheckBean.getMemberName());
        pmUserCouponDomain.setMemberCode(pmCheckBean.getMemberCode());
        pmUserCouponDomain.setUserCode(pmCheckBean.getUserBean().getUserCode());
        pmUserCouponDomain.setUserName(pmCheckBean.getUserBean().getUserName());
        pmUserCouponDomain.setProappCode(pmCheckBean.getProappCode());
        pmUserCouponDomain.setTenantCode(pmCheckBean.getTenantCode());
        return pmUserCouponDomain;
    }

    private void getPromotionReRelatedData(PmPromotion pmPromotion) {
        List<PmPromotionSup> supQueryResult;
        List<PmPromotionDis> disQueryResult;
        List<PmPromotionMem> pmPromotionMemList;
        List<PmPromotionCondition> promotionConditionList;
        List<PmPromotionTerminal> promotionTerminalList;
        List<PmPromotionRangelist> pmPromotionRangelists;
        if (null == pmPromotion) {
            return;
        }
        String tenantCode = pmPromotion.getTenantCode();
        String promotionCode = pmPromotion.getPromotionCode();
        Map paramMap = this.getQueryParamMap("promotionCode,tenantCode", new Object[]{promotionCode, tenantCode});
        List<PmPromotionTargetlist> query = this.pmPromotionTargetlistMapper.query(paramMap);
        if (null != query) {
            pmPromotion.setPmPromotionTargetList(query);
        }
        if (null != (pmPromotionRangelists = this.pmPromotionRangelistMapper.query(paramMap))) {
            for (PmPromotionRangelist pmPromotionRangelist : pmPromotionRangelists) {
                paramMap.put("pprlCode", pmPromotionRangelist.getPprlCode());
                List<PmPromotionSavg> pmpromotionSavgList = this.pmPromotionSavgMapper.query(paramMap);
                if (!ListUtil.isNotEmpty(pmpromotionSavgList)) continue;
                pmPromotionRangelist.setPmPromotionSavgList(pmpromotionSavgList);
            }
            pmPromotion.setPmPromotionRangeList(pmPromotionRangelists);
        }
        if (null != (promotionTerminalList = this.pmPromotionTerminalMapper.query(paramMap))) {
            pmPromotion.setPmPromotionTerminalList(promotionTerminalList);
        }
        if (null != (promotionConditionList = this.pmPromotionConditionMapper.query(paramMap))) {
            pmPromotion.setPmPromotionConditionList(promotionConditionList);
        }
        List<PmPromotionDiscount> pmPromotionDiscountList = this.pmPromotionDiscountMapper.query(paramMap);
        this.logger.error(".promotionDiscountResult" + pmPromotionDiscountList);
        if (null != pmPromotionDiscountList) {
            pmPromotion.setPmPromotionDiscountList(pmPromotionDiscountList);
            List<PmPromotionDiscountlist> qdiscountlist = null;
            for (PmPromotionDiscount pmPromotionDiscount : pmPromotionDiscountList) {
                paramMap.put("ppdCode", pmPromotionDiscount.getPpdCode());
                qdiscountlist = this.pmPromotionDiscountlistMapper.query(paramMap);
                this.logger.error(".qdiscountlist== " + qdiscountlist);
                if (null == qdiscountlist) continue;
                pmPromotionDiscount.setPmPromotionDiscountlistList(qdiscountlist);
            }
        }
        if (null != (pmPromotionMemList = this.pmPromotionMemMapper.query(paramMap))) {
            pmPromotion.setPmPromotionMemList(pmPromotionMemList);
        }
        if (null != (disQueryResult = this.pmPromotionDisMapper.query(paramMap))) {
            pmPromotion.setPmPromotionDisList(disQueryResult);
        }
        if (null != (supQueryResult = this.pmPromotionSupMapper.query(paramMap))) {
            pmPromotion.setPmPromotionSupList(supQueryResult);
        }
    }
}

