/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.openapi.service.impl;

import com.google.common.collect.ImmutableMap;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.openapi.dao.oc.OcContractGoodsMapper;
import com.yqbsoft.laser.service.openapi.dao.oc.OcContractMapper;
import com.yqbsoft.laser.service.openapi.dao.oc.OcRefundMapper;
import com.yqbsoft.laser.service.openapi.dao.org.OrgDepartMapper;
import com.yqbsoft.laser.service.openapi.dao.um.UmUserinfoMapper;
import com.yqbsoft.laser.service.openapi.domain.oc.OcContractDetailDomain;
import com.yqbsoft.laser.service.openapi.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.openapi.domain.oc.OcContractGuidesDomain;
import com.yqbsoft.laser.service.openapi.domain.oc.OcContractPayInfoDomain;
import com.yqbsoft.laser.service.openapi.domain.oc.OcRefundInfoDomain;
import com.yqbsoft.laser.service.openapi.domain.oc.OrderDetailInfoDomain;
import com.yqbsoft.laser.service.openapi.model.OcContract;
import com.yqbsoft.laser.service.openapi.model.OcContractGoods;
import com.yqbsoft.laser.service.openapi.model.OcRefund;
import com.yqbsoft.laser.service.openapi.model.OrgDepart;
import com.yqbsoft.laser.service.openapi.model.UmUserinfo;
import com.yqbsoft.laser.service.openapi.service.ContractService;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ContractServiceIpml
extends BaseServiceImpl
implements ContractService {
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private UmUserinfoMapper umUserinfoMapper;
    @Autowired
    private OrgDepartMapper orgDepartMapper;
    @Autowired
    private OcRefundMapper ocRefundMapper;

    @Override
    public OcContractDetailDomain cdpGetOrderDetailInfo(String resStream) {
        List<OrgDepart> query;
        List<UmUserinfo> umUserinfos;
        if (resStream == null) {
            new ApiException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderDetailInfoDomain orderCode = new OrderDetailInfoDomain();
        if (Objects.isNull(orderCode = this.strToDto(orderCode, resStream))) {
            new ApiException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.logger.info("\u6253\u5370\u8ba2\u5355\u53f7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)orderCode));
        OcContract ocContract = this.ocContractMapper.getOcContractByContract(orderCode.getOrder_code());
        this.logger.info("\u6253\u5370\u8ba2\u5355\u65e5\u5fd7\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContract));
        if (ocContract == null || Objects.isNull(ocContract)) {
            new ApiException("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        UmUserinfo umUserinfo = null;
        if (!StringUtils.isBlank((String)ocContract.getMemberBcode()) && (umUserinfos = this.getUmUserinfos(ocContract.getMemberBcode())) != null) {
            umUserinfo = umUserinfos.get(0);
        }
        OrgDepart depart = null;
        if (!StringUtils.isBlank((String)ocContract.getMemberCode())) {
            depart = this.getDepart(ocContract.getMemberCode());
        }
        OrgDepart performance = null;
        if (!StringUtils.isBlank((String)ocContract.getMschannelCode())) {
            performance = this.getDepart(ocContract.getMschannelCode());
        }
        OrgDepart areaDepart = null;
        if (performance != null && !CollectionUtils.isEmpty(query = this.orgDepartMapper.query((Map<String, Object>)ImmutableMap.of((Object)"departCode", (Object)performance.getDepartPcode())))) {
            areaDepart = query.get(0);
        }
        List<OcContractPayInfoDomain> payInfo = this.ocContractMapper.getPayInfo(ocContract.getContractBillcode());
        List<OcContractGuidesDomain> guidesList = this.getGuideInfo(ocContract);
        List<OcContractGoodsDomain> goods = this.getGoods(ocContract);
        OcRefundInfoDomain refundInfo = this.getRefundInfo(ocContract);
        return OcContractDetailDomain.builder().orderBillCode(ocContract.getContractBillcode()).orderNBillCode(ocContract.getContractBbillcode()).orderStatus(ocContract.getDataState() == 1 ? "\u5f85\u4ed8\u6b3e" : (ocContract.getDataState() == 2 ? "\u5f85\u53d1\u8d27" : (ocContract.getDataState() == 3 ? "\u5df2\u53d1\u8d27" : (ocContract.getDataState() == 4 ? "\u5df2\u6536\u8d27" : (ocContract.getDataState() == 5 ? "\u4ea4\u6613\u6210\u529f" : (ocContract.getDataState() == -1 && ocContract.getRefundMoney() != null ? "\u5df2\u9000\u6b3e" : (ocContract.getDataState() == -1 ? "\u5df2\u53d6\u6d88" : ""))))))).orderTime(DateUtils.parsTime((Date)ocContract.getGmtCreate())).receiptPerson(ocContract.getGoodsReceiptMem()).receiptTel(ocContract.getGoodsReceiptPhone()).receiptAddress(ocContract.getGoodsReceiptArrdess()).orderPayMode(StringUtils.isNotBlank((String)ocContract.getGoodsClass()) && ocContract.getGoodsClass().equals("pos") ? "\u7ebf\u4e0b" : "\u7ebf\u4e0a").orderChanel(StringUtils.isNotBlank((String)ocContract.getGoodsClass()) && ocContract.getGoodsClass().equals("pos") ? "POS\u95e8\u5e97" : "\u7ebf\u4e0a\u95e8\u5e97").orderTotalAmount(ocContract.getContractInmoney().doubleValue()).orderRealAmount(ocContract.getDataBmoney().doubleValue()).orderDiscountAmount(ocContract.getContractInmoney().subtract(ocContract.getDataBmoney()).doubleValue()).customerName(umUserinfo != null ? umUserinfo.getUserinfoCompname() : "").customerCard(umUserinfo != null ? umUserinfo.getUserinfoOcode() : "").customerTel(umUserinfo != null ? umUserinfo.getUserinfoTel() : "").orderShopName(depart != null ? depart.getDepartName() : "").orderShopCode(depart != null ? depart.getDepartOcode() : "").performanceShopName(performance != null ? performance.getDepartName() : "").performanceShopCode(performance != null ? performance.getDepartOcode() : "").performanceAreaName(areaDepart != null ? areaDepart.getDepartName() : "").payTime(ocContract.getDataState() == 1 || ocContract.getDataState() == -1 && ocContract.getRefundMoney() == null ? "" : DateUtils.parseDate((Date)ocContract.getContractPaydate())).payInfos(payInfo).guides(guidesList).goods(goods).refundInfo(refundInfo).build();
    }

    private OcRefundInfoDomain getRefundInfo(OcContract ocContract) {
        List<OcRefund> ocRefunds = this.ocRefundMapper.query((Map<String, Object>)ImmutableMap.of((Object)"contractBillcode", (Object)ocContract.getContractBillcode()));
        if (!CollectionUtils.isEmpty(ocRefunds)) {
            OcRefundInfoDomain oc;
            OcRefund refund = ocRefunds.get(0);
            OcRefundInfoDomain build = OcRefundInfoDomain.builder().refundType(refund.getRefundType().equals("BO1") ? "\u4ec5\u9000\u6b3e" : (refund.getRefundType().equals("BO2") ? "\u9000\u8d27\u9000\u6b3e" : (refund.getRefundType().equals("BO7") ? "\u6362\u8d27" : ""))).refundBillCode(refund.getRefundCode()).refundStatus(this.getStateName(refund.getDataState())).refundApplyTime(DateUtils.parseDate((Date)refund.getGmtCreate())).refundReason(refund.getRefundEx()).refundMoney(refund.getRefundMoney().toString()).refundAddress(refund.getRefundReceiptArrdess()).refundContactTel(refund.getRefundReceiptPhone()).refundContact(refund.getRefundReceiptMem()).refundLogistics(refund.getPackageName()).refundTrackNumber(refund.getPackageBillno()).build();
            if (refund.getDataState() == 8 && (oc = this.ocRefundMapper.getPayInfo(refund.getRefundCode())) != null) {
                build.setMerchantCode(oc.getMerchantCode());
                build.setWxRefundCode(oc.getWxRefundCode());
                build.setRefundTime(oc.getRefundTime());
            }
            return build;
        }
        return null;
    }

    private String getStateName(Integer dataState) {
        if (dataState == 8) {
            return "\u5b8c\u6210";
        }
        if (dataState == -1) {
            return "\u64a4\u9500\u7533\u8bf7";
        }
        if (dataState == 9) {
            return "\u9000\u6b3e\u5f02\u5e38";
        }
        if (dataState == 0) {
            return "\u5f85\u5ba1\u6838";
        }
        if (dataState == 1) {
            return "\u5ba1\u6838\u901a\u8fc7";
        }
        if (dataState == 4) {
            return "\u7cfb\u7edf\u5904\u7406\u4e2d";
        }
        if (dataState == 6) {
            return "\u5546\u5bb6\u62d2\u7edd\u6536\u8d27";
        }
        if (dataState == 10) {
            return "\u7269\u6d41\u62e6\u622a\u4e2d";
        }
        if (dataState == 2) {
            return "\u5f85\u6536\u8d27";
        }
        if (dataState == 3) {
            return "\u5f85\u9000\u6b3e";
        }
        if (dataState == -2) {
            return "\u62d2\u7edd\u7533\u8bf7";
        }
        if (dataState == 14) {
            return "\u7cfb\u7edf\u5904\u7406\u4e2d";
        }
        if (dataState == 15) {
            return "\u6362\u8d27\u4e2d";
        }
        return "";
    }

    private List<OcContractGoodsDomain> getGoods(OcContract ocContract) {
        ArrayList<OcContractGoodsDomain> list = new ArrayList<OcContractGoodsDomain>();
        this.logger.info("\u6253\u5370\u67e5\u8be2\u5546\u54c1\u65e5\u5fd7\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContract.getContractBillcode()));
        List<OcContractGoods> goodsList = this.ocContractGoodsMapper.query((Map<String, Object>)ImmutableMap.of((Object)"contractBillcode", (Object)ocContract.getContractBillcode()));
        this.logger.info("\u6253\u5370goodsList\u65e5\u5fd7\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsList));
        if (!CollectionUtils.isEmpty(goodsList)) {
            for (OcContractGoods goods : goodsList) {
                OcContractGoodsDomain build = OcContractGoodsDomain.builder().goodsCode(goods.getGoodsNo()).goodsName(goods.getGoodsName()).goodsType(this.getGoodsType(ocContract, goods)).goosPayPrice(goods.getContractGoodsPrice().doubleValue()).goodsPrice(goods.getContractGoodsInmoney().doubleValue()).goodsCount(goods.getGoodsNum().intValue()).build();
                list.add(build);
            }
        }
        return list;
    }

    private String getGoodsType(OcContract ocContract, OcContractGoods goods) {
        if (StringUtils.isNotBlank((String)ocContract.getGoodsClass()) && ocContract.getGoodsClass().equals("pos")) {
            String goodsType = goods.getGoodsType();
            if (StringUtils.isBlank((String)goodsType)) {
                return "\u9500\u552e";
            }
            if (goodsType.equals("1")) {
                return "\u9500\u552e";
            }
            if (goodsType.equals("2")) {
                return "\u5168\u4ef7";
            }
            if (goodsType.equals("4")) {
                return "\u8d60\u54c1";
            }
            if (goodsType.equals("16")) {
                return "\u7a7a\u5356";
            }
            if (goodsType.equals("32")) {
                return "\u53d6\u8863";
            }
        }
        return "\u9500\u552e";
    }

    private List<OcContractGuidesDomain> getGuideInfo(OcContract ocContract) {
        List<OcContractGuidesDomain> list = new ArrayList<OcContractGuidesDomain>();
        if (StringUtils.isNotBlank((String)ocContract.getGoodsClass()) && ocContract.getGoodsClass().equals("pos")) {
            list = this.ocContractMapper.queryOcContractGuide(ocContract.getContractBillcode());
        } else {
            if (StringUtils.isBlank((String)ocContract.getMemberGcode())) {
                return list;
            }
            list = this.umUserinfoMapper.getGuideInfoByUserinfoCode(ocContract.getMemberGcode());
        }
        return list;
    }

    private List<UmUserinfo> getUmUserinfos(String userinfoCode) {
        HashMap<String, Object> umUserinfoMap = new HashMap<String, Object>();
        umUserinfoMap.put("fuzzy", false);
        umUserinfoMap.put("userinfoCode", userinfoCode);
        this.logger.info("\u6253\u5370\u5165\u53c2\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(umUserinfoMap));
        return this.umUserinfoMapper.query(umUserinfoMap);
    }

    private OrgDepart getDepart(String userinfoCode) {
        List<UmUserinfo> umUserinfos = this.getUmUserinfos(userinfoCode);
        if (CollectionUtils.isEmpty(umUserinfos)) {
            return null;
        }
        List<OrgDepart> query = this.orgDepartMapper.query((Map<String, Object>)ImmutableMap.of((Object)"departCode", (Object)umUserinfos.get(0).getDepartCode()));
        if (CollectionUtils.isEmpty(query)) {
            return null;
        }
        return query.get(0);
    }

    public <T> T strToDto(T t, String resStream) {
        if (StringUtils.isBlank((String)resStream)) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        t = JsonUtil.buildNonDefaultBinder().getJsonToObject(resStream, t.getClass());
        if (Objects.isNull(t)) {
            throw new ApiException("\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        return t;
    }
}

