/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.assistant.service.impl;

import com.yqbsoft.laser.service.assistant.dao.ClSigninMapper;
import com.yqbsoft.laser.service.assistant.domain.ClSigninDomain;
import com.yqbsoft.laser.service.assistant.domain.ClSigninReDomain;
import com.yqbsoft.laser.service.assistant.model.ClSignin;
import com.yqbsoft.laser.service.assistant.service.ClSigninService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClSigninServiceImpl
extends BaseServiceImpl
implements ClSigninService {
    private static final String SYS_CODE = "cl.ASSISTANT.ClSigninServiceImpl";
    private ClSigninMapper clSigninMapper;

    public void setClSigninMapper(ClSigninMapper clSigninMapper) {
        this.clSigninMapper = clSigninMapper;
    }

    private Date getSysDate() {
        try {
            return this.clSigninMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cl.ASSISTANT.ClSigninServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkClSignin(ClSigninDomain clSigninDomain) {
        if (null == clSigninDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)clSigninDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setClSigninDefault(ClSignin clSignin) {
        if (null == clSignin) {
            return;
        }
        if (null == clSignin.getDataState()) {
            clSignin.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == clSignin.getGmtCreate()) {
            clSignin.setGmtCreate(date);
        }
        clSignin.setGmtModified(date);
        if (StringUtils.isBlank((String)clSignin.getSigninCode())) {
            clSignin.setSigninCode(this.getNo(null, "ClSignin", "clSignin", clSignin.getTenantCode()));
        }
    }

    private int getClSigninMaxCode() {
        int code = 0;
        try {
            return this.clSigninMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cl.ASSISTANT.ClSigninServiceImpl.getClSigninMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setClSigninUpdataDefault(ClSignin clSignin) {
        if (null == clSignin) {
            return;
        }
        clSignin.setGmtModified(this.getSysDate());
    }

    private void saveClSigninModel(ClSignin clSignin) throws ApiException {
        if (null == clSignin) {
            return;
        }
        try {
            this.clSigninMapper.insert(clSignin);
        }
        catch (Exception e) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.saveClSigninModel.ex", (Throwable)e);
        }
    }

    private void saveClSigninBatchModel(List<ClSignin> clSigninList) throws ApiException {
        if (null == clSigninList || clSigninList.isEmpty()) {
            return;
        }
        try {
            this.clSigninMapper.insertBatch(clSigninList);
        }
        catch (Exception e) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.saveClSigninBatchModel.ex", (Throwable)e);
        }
    }

    private ClSignin getClSigninModelById(Integer signinId) {
        if (null == signinId) {
            return null;
        }
        try {
            return this.clSigninMapper.selectByPrimaryKey(signinId);
        }
        catch (Exception e) {
            this.logger.error("cl.ASSISTANT.ClSigninServiceImpl.getClSigninModelById", (Throwable)e);
            return null;
        }
    }

    private ClSignin getClSigninModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.clSigninMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cl.ASSISTANT.ClSigninServiceImpl.getClSigninModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delClSigninModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.clSigninMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.delClSigninModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.delClSigninModelByCode.num");
        }
    }

    private void deleteClSigninModel(Integer signinId) throws ApiException {
        if (null == signinId) {
            return;
        }
        int i = 0;
        try {
            i = this.clSigninMapper.deleteByPrimaryKey(signinId);
        }
        catch (Exception e) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.deleteClSigninModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.deleteClSigninModel.num");
        }
    }

    private void updateClSigninModel(ClSignin clSignin) throws ApiException {
        if (null == clSignin) {
            return;
        }
        int i = 0;
        try {
            i = this.clSigninMapper.updateByPrimaryKey(clSignin);
        }
        catch (Exception e) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.updateClSigninModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.updateClSigninModel.num");
        }
    }

    private void updateStateClSigninModel(Integer signinId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == signinId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("signinId", signinId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.clSigninMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.updateStateClSigninModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.updateStateClSigninModel.null");
        }
    }

    private void updateStateClSigninModelByCode(String tenantCode, String signinCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)signinCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("signinCode", signinCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.clSigninMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.updateStateClSigninModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.updateStateClSigninModelByCode.null");
        }
    }

    private ClSignin makeClSignin(ClSigninDomain clSigninDomain, ClSignin clSignin) {
        if (null == clSigninDomain) {
            return null;
        }
        if (null == clSignin) {
            clSignin = new ClSignin();
        }
        try {
            BeanUtils.copyAllPropertys((Object)clSignin, (Object)clSigninDomain);
            return clSignin;
        }
        catch (Exception e) {
            this.logger.error("cl.ASSISTANT.ClSigninServiceImpl.makeClSignin", (Throwable)e);
            return null;
        }
    }

    private ClSigninReDomain makeClSigninReDomain(ClSignin clSignin) {
        if (null == clSignin) {
            return null;
        }
        ClSigninReDomain clSigninReDomain = new ClSigninReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)clSigninReDomain, (Object)clSignin);
            return clSigninReDomain;
        }
        catch (Exception e) {
            this.logger.error("cl.ASSISTANT.ClSigninServiceImpl.makeClSigninReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ClSignin> queryClSigninModelPage(Map<String, Object> parammap) {
        try {
            return this.clSigninMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cl.ASSISTANT.ClSigninServiceImpl.queryClSigninModel", (Throwable)e);
            return null;
        }
    }

    private int countClSignin(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.clSigninMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cl.ASSISTANT.ClSigninServiceImpl.countClSignin", (Throwable)e);
        }
        return i;
    }

    private ClSignin createClSignin(ClSigninDomain clSigninDomain) {
        String msg = this.checkClSignin(clSigninDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.saveClSignin.checkClSignin", msg);
        }
        ClSignin clSignin = this.makeClSignin(clSigninDomain, null);
        this.setClSigninDefault(clSignin);
        return clSignin;
    }

    @Override
    public String saveClSignin(ClSigninDomain clSigninDomain) throws ApiException {
        ClSignin clSignin = this.createClSignin(clSigninDomain);
        this.saveClSigninModel(clSignin);
        return clSignin.getSigninCode();
    }

    @Override
    public String saveClSigninBatch(List<ClSigninDomain> clSigninDomainList) throws ApiException {
        if (null == clSigninDomainList || clSigninDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ClSignin> clSigninList = new ArrayList<ClSignin>();
        String code = "";
        for (ClSigninDomain clSigninDomain : clSigninDomainList) {
            ClSignin clSignin = this.createClSignin(clSigninDomain);
            code = clSignin.getSigninCode();
            clSigninList.add(clSignin);
        }
        this.saveClSigninBatchModel(clSigninList);
        return code;
    }

    @Override
    public void updateClSigninState(Integer signinId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == signinId) {
            return;
        }
        this.updateStateClSigninModel(signinId, dataState, oldDataState, map);
    }

    @Override
    public void updateClSigninStateByCode(String tenantCode, String signinCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)signinCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateClSigninModelByCode(tenantCode, signinCode, dataState, oldDataState, map);
    }

    @Override
    public void updateClSignin(ClSigninDomain clSigninDomain) throws ApiException {
        String msg = this.checkClSignin(clSigninDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.updateClSignin.checkClSignin", msg);
        }
        ClSignin oldClSignin = this.getClSigninModelById(clSigninDomain.getSigninId());
        if (null == oldClSignin) {
            throw new ApiException("cl.ASSISTANT.ClSigninServiceImpl.updateClSignin.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ClSignin clSignin = this.makeClSignin(clSigninDomain, oldClSignin);
        this.setClSigninUpdataDefault(clSignin);
        this.updateClSigninModel(clSignin);
    }

    @Override
    public ClSignin getClSignin(Integer signinId) {
        if (null == signinId) {
            return null;
        }
        return this.getClSigninModelById(signinId);
    }

    @Override
    public void deleteClSignin(Integer signinId) throws ApiException {
        if (null == signinId) {
            return;
        }
        this.deleteClSigninModel(signinId);
    }

    @Override
    public QueryResult<ClSignin> queryClSigninPage(Map<String, Object> map) {
        List<ClSignin> clSigninList = this.queryClSigninModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countClSignin(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(clSigninList);
        return queryResult;
    }

    @Override
    public ClSignin getClSigninByCode(String tenantCode, String signinCode) throws ApiException {
        if (StringUtils.isBlank((String)signinCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("signinCode", signinCode);
        return this.getClSigninModelByCode(map);
    }

    @Override
    public void deleteClSigninByCode(String tenantCode, String signinCode) throws ApiException {
        if (StringUtils.isBlank((String)signinCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("signinCode", signinCode);
        this.delClSigninModelByCode(map);
    }
}

