/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cd.service.impl;

import com.yqbsoft.laser.service.cd.AESUtil;
import com.yqbsoft.laser.service.cd.dao.CdCardpUserMapper;
import com.yqbsoft.laser.service.cd.domain.CdCardpUserBean;
import com.yqbsoft.laser.service.cd.domain.CdCardpUserDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardpUserReDomain;
import com.yqbsoft.laser.service.cd.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.cd.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.cd.model.CdCardp;
import com.yqbsoft.laser.service.cd.model.CdCardpUser;
import com.yqbsoft.laser.service.cd.model.CdCardplist;
import com.yqbsoft.laser.service.cd.service.CdCardpCardService;
import com.yqbsoft.laser.service.cd.service.CdCardpUserService;
import com.yqbsoft.laser.service.cd.service.CdCardplistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CdCardpUserServiceImpl
extends BaseServiceImpl
implements CdCardpUserService {
    private static final String SYS_CODE = "cd.CARDP.CdCardpUserServiceImpl";
    private CdCardpUserMapper cdCardpUserMapper;
    private CdCardplistService cdCardplistService;
    private CdCardpCardService cdCardpCardService;

    public void setCdCardpCardService(CdCardpCardService cdCardpCardService) {
        this.cdCardpCardService = cdCardpCardService;
    }

    public void setCdCardplistService(CdCardplistService cdCardplistService) {
        this.cdCardplistService = cdCardplistService;
    }

    public void setCdCardpUserMapper(CdCardpUserMapper cdCardpUserMapper) {
        this.cdCardpUserMapper = cdCardpUserMapper;
    }

    private Date getSysDate() {
        try {
            return this.cdCardpUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCardpUser(CdCardpUserDomain cdCardpUserDomain) {
        if (null == cdCardpUserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cdCardpUserDomain.getCardpCode())) {
            msg = msg + "CardpCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cdCardpUserDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cdCardpUserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String checkCardpUserBean(CdCardpUserBean cdCardpUserBean) {
        if (null == cdCardpUserBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cdCardpUserBean.getCardpCode())) {
            msg = msg + "CardpCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cdCardpUserBean.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cdCardpUserBean.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCardpUserDefault(CdCardpUser cdCardpUser) {
        if (null == cdCardpUser) {
            return;
        }
        if (null == cdCardpUser.getDataState()) {
            cdCardpUser.setDataState(0);
        }
        if (null == cdCardpUser.getGmtCreate()) {
            cdCardpUser.setGmtCreate(this.getSysDate());
        }
        cdCardpUser.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cdCardpUser.getCardpUserCode())) {
            cdCardpUser.setCardpUserCode(this.createUUIDString());
        }
    }

    private int getCardpUserMaxCode() {
        int code = 0;
        try {
            return this.cdCardpUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.getCardpUserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCardpUserUpdataDefault(CdCardpUser cdCardpUser) {
        if (null == cdCardpUser) {
            return;
        }
        cdCardpUser.setGmtModified(this.getSysDate());
    }

    private void saveCardpUserModel(CdCardpUser cdCardpUser) throws ApiException {
        if (null == cdCardpUser) {
            return;
        }
        try {
            this.cdCardpUserMapper.insert(cdCardpUser);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.saveCardpUserModel.ex", (Throwable)e);
        }
    }

    private void saveCardpUserBatchModel(List<CdCardpUser> cdCardpUserList) throws ApiException {
        if (null == cdCardpUserList || cdCardpUserList.isEmpty()) {
            return;
        }
        try {
            this.cdCardpUserMapper.insertBatch(cdCardpUserList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.saveCardpUserBatchModel.ex", (Throwable)e);
        }
    }

    private CdCardpUser getCardpUserModelById(Integer cardpUserId) {
        if (null == cardpUserId) {
            return null;
        }
        try {
            return this.cdCardpUserMapper.selectByPrimaryKey(cardpUserId);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.getCardpUserModelById", (Throwable)e);
            return null;
        }
    }

    private CdCardpUser getCardpUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cdCardpUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.getCardpUserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCardpUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpUserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.delCardpUserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.delCardpUserModelByCode.num");
        }
    }

    private void deleteCardpUserModel(Integer cardpUserId) throws ApiException {
        if (null == cardpUserId) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpUserMapper.deleteByPrimaryKey(cardpUserId);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.deleteCardpUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.deleteCardpUserModel.num");
        }
    }

    private void updateCardpUserModel(CdCardpUser cdCardpUser) throws ApiException {
        if (null == cdCardpUser) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpUserMapper.updateByPrimaryKeySelective(cdCardpUser);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateCardpUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateCardpUserModel.num");
        }
    }

    private void updateStateCardpUserModel(Integer cardpUserId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cardpUserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardpUserId", cardpUserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cdCardpUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateStateCardpUserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateStateCardpUserModel.null");
        }
    }

    private void updateStateCardpUserModelByCode(String tenantCode, String cardpUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)cardpUserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpUserCode", cardpUserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cdCardpUserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateStateCardpUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateStateCardpUserModelByCode.null");
        }
    }

    private CdCardpUser makeCardpUser(CdCardpUserDomain cdCardpUserDomain, CdCardpUser cdCardpUser) {
        if (null == cdCardpUserDomain) {
            return null;
        }
        if (null == cdCardpUser) {
            cdCardpUser = new CdCardpUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cdCardpUser, (Object)cdCardpUserDomain);
            return cdCardpUser;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.makeCardpUser", (Throwable)e);
            return null;
        }
    }

    private CdCardpUserReDomain makeCdCardpUserReDomain(CdCardpUser cdCardpUser) {
        if (null == cdCardpUser) {
            return null;
        }
        CdCardpUserReDomain cdCardpUserReDomain = new CdCardpUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cdCardpUserReDomain, (Object)cdCardpUser);
            return cdCardpUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.makeCdCardpUserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CdCardpUser> queryCardpUserModelPage(Map<String, Object> parammap) {
        try {
            return this.cdCardpUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.queryCardpUserModel", (Throwable)e);
            return null;
        }
    }

    private int countCardpUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cdCardpUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.countCardpUser", (Throwable)e);
        }
        return i;
    }

    private CdCardpUser createCdCardpUser(CdCardpUserDomain cdCardpUserDomain) {
        String msg = this.checkCardpUser(cdCardpUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.saveCardpUser.checkCardpUser", msg);
        }
        CdCardpUser cdCardpUser = this.makeCardpUser(cdCardpUserDomain, null);
        this.setCardpUserDefault(cdCardpUser);
        return cdCardpUser;
    }

    @Override
    public String saveCardpUser(CdCardpUserDomain cdCardpUserDomain) throws ApiException {
        CdCardpUser cdCardpUser = this.createCdCardpUser(cdCardpUserDomain);
        this.saveCardpUserModel(cdCardpUser);
        this.sendCaedpUserMsg(cdCardpUser.getCardpUserCode(), cdCardpUser.getTenantCode());
        CdCardp cardpByCode = this.cdCardpCardService.getCardpByCode(cdCardpUser.getTenantCode(), cdCardpUser.getCardpCode());
        if ("3".equals(cardpByCode.getCardpOptype())) {
            this.cdCardplistService.updateCardplistStateByCode(cdCardpUser.getTenantCode(), cdCardpUser.getCardplistCode(), 2, 0);
        }
        return cdCardpUser.getCardpUserCode();
    }

    @Override
    public String saveCardpUserBatch(List<CdCardpUserDomain> cdCardpUserDomainList) throws ApiException {
        if (null == cdCardpUserDomainList || cdCardpUserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CdCardpUser> cdCardpUserList = new ArrayList<CdCardpUser>();
        String code = "";
        for (CdCardpUserDomain cdCardpUserDomain : cdCardpUserDomainList) {
            CdCardpUser cdCardpUser = this.createCdCardpUser(cdCardpUserDomain);
            code = cdCardpUser.getCardpUserCode();
            cdCardpUserList.add(cdCardpUser);
        }
        this.saveCardpUserBatchModel(cdCardpUserList);
        for (CdCardpUser cdCardpUser1 : cdCardpUserList) {
            this.sendMns(cdCardpUser1);
            CdCardp cardpByCode = this.cdCardpCardService.getCardpByCode(cdCardpUser1.getTenantCode(), cdCardpUser1.getCardpCode());
            if (!"3".equals(cardpByCode.getCardpOptype())) continue;
            this.cdCardplistService.updateCardplistStateByCode(cdCardpUser1.getTenantCode(), cdCardpUser1.getCardplistCode(), 2, 1);
        }
        return code;
    }

    @Override
    public void updateCardpUserState(Integer cardpUserId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCardpUserModel(cardpUserId, dataState, oldDataState);
    }

    @Override
    public void updateCardpUserStateByCode(String tenantCode, String cardpUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCardpUserModelByCode(tenantCode, cardpUserCode, dataState, oldDataState);
    }

    @Override
    public void updateCardpUser(CdCardpUserDomain cdCardpUserDomain) throws ApiException {
        String msg = this.checkCardpUser(cdCardpUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateCardpUser.checkCardpUser", msg);
        }
        CdCardpUser oldCdCardpUser = this.getCardpUserModelById(cdCardpUserDomain.getCardpUserId());
        if (null == oldCdCardpUser) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.updateCardpUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CdCardpUser cdCardpUser = this.makeCardpUser(cdCardpUserDomain, oldCdCardpUser);
        this.setCardpUserUpdataDefault(cdCardpUser);
        this.updateCardpUserModel(cdCardpUser);
    }

    @Override
    public CdCardpUser getCardpUser(Integer cardpUserId) {
        return this.getCardpUserModelById(cardpUserId);
    }

    @Override
    public void deleteCardpUser(Integer cardpUserId) throws ApiException {
        this.deleteCardpUserModel(cardpUserId);
    }

    @Override
    public QueryResult<CdCardpUser> queryCardpUserPage(Map<String, Object> map) {
        List<CdCardpUser> cdCardpUserList = this.queryCardpUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCardpUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cdCardpUserList);
        return queryResult;
    }

    @Override
    public CdCardpUser getCardpUserByCode(String tenantCode, String cardpUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpUserCode", cardpUserCode);
        return this.getCardpUserModelByCode(map);
    }

    @Override
    public void deleteCardpUserByCode(String tenantCode, String cardpUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpUserCode", cardpUserCode);
        this.delCardpUserModelByCode(map);
    }

    @Override
    public String saveCardpUserListByCode(List<CdCardpUserBean> cdCardpUserBeanList) throws ApiException {
        if (ListUtil.isEmpty(cdCardpUserBeanList)) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.saveCardpUserListByCode.cdCardpUserBeanList");
            return "error";
        }
        String res = "";
        for (CdCardpUserBean cdCardpUserBean : cdCardpUserBeanList) {
            res = this.saveCardpUserByCode(cdCardpUserBean);
            if (!"error".equals(res)) continue;
            return res;
        }
        return res;
    }

    @Override
    public String saveCardpUserByCode(CdCardpUserBean cdCardpUserBean) throws ApiException {
        String msg = this.checkCardpUserBean(cdCardpUserBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpUserServiceImpl.saveCardpUserByCode.checkCardpUserBean", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardpCode", cdCardpUserBean.getCardpCode());
        map.put("tenantCode", cdCardpUserBean.getTenantCode());
        map.put("stateType", 0);
        map.put("dataState", 0);
        map.put("order", true);
        map.put("orderStr", "CARDP_END");
        QueryResult<CdCardplist> qlist = this.cdCardplistService.queryCardplistPage(map);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImpl.saveCardpUserByCode.qlist");
            return "error";
        }
        BigDecimal num = cdCardpUserBean.getNum();
        if (null == num) {
            num = new BigDecimal("1");
        }
        int cnum = num.intValue();
        for (int i = 0; i < cnum; ++i) {
            CdCardplist cdCardplist = (CdCardplist)qlist.getList().get(i);
            CdCardpUserDomain cdCardpUserDomain = new CdCardpUserDomain();
            try {
                BeanUtils.copyAllPropertys((Object)cdCardpUserDomain, (Object)cdCardplist);
                BeanUtils.copyAllPropertys((Object)cdCardpUserDomain, (Object)cdCardpUserBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.saveCardpUser(cdCardpUserDomain);
        }
        if (qlist.getList().size() <= cnum) {
            this.updateCardpStock(cdCardpUserBean);
        }
        return "success";
    }

    @Override
    public void sendCaedpUserMsg(String cardpUserCode, String tenantCode) {
        if (StringUtils.isBlank((String)cardpUserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        CdCardpUser cdCardpUser = this.getCardpUserByCode(tenantCode, cardpUserCode);
        if (null == cdCardpUser) {
            return;
        }
        this.sendMns(cdCardpUser);
    }

    public void sendMns(CdCardpUser cdCardpUser) {
        if (null == cdCardpUser) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", cdCardpUser.getMemberCode());
        paramMap.put("tenantCode", cdCardpUser.getTenantCode());
        UmUserinfoDomain umUserinfo = (UmUserinfoDomain)this.readObj("um.user.getUserinfoByUserCode", paramMap, "object", new Object[]{UmUserinfoDomain.class});
        String phone = "";
        if (null == umUserinfo) {
            return;
        }
        phone = umUserinfo.getUserinfoPhone();
        if (StringUtils.isBlank((String)phone)) {
            return;
        }
        if (StringUtils.isNotBlank((String)cdCardpUser.getCardpPhone())) {
            phone = cdCardpUser.getCardpPhone();
        }
        ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
        mnsMap.put("mnslistSubject", "");
        mnsMap.put("mnslistSource", "0");
        mnsMap.put("mnslistBusType", "cd");
        ArrayList<Map<String, String>> receiverList = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("telphone", phone);
        map.put("name", umUserinfo.getUserinfoCompname());
        receiverList.add(map);
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        contentMap.put("memberName", cdCardpUser.getMemberName());
        contentMap.put("cardpName", cdCardpUser.getCardpName());
        contentMap.put("name", umUserinfo.getUserinfoCompname());
        CdCardplist cardplistByCode = this.cdCardplistService.getCardplistByCode(cdCardpUser.getTenantCode(), cdCardpUser.getCardplistCode());
        if (null == cardplistByCode) {
            return;
        }
        contentMap.put("cardpNumber", cardplistByCode.getCardpNumber());
        String pass = AESUtil.decrypt(cardplistByCode.getCardpPass(), cardplistByCode.getCardpRtype());
        contentMap.put("cardpPass", pass);
        contentMap.put("cardpStart", cardplistByCode.getCardpStart());
        contentMap.put("cardpEnd", cardplistByCode.getCardpEnd());
        mnsMap.put("mnslistExp", this.getMnslistExp(contentMap, receiverList));
        mnsMap.put("tenantCode", cdCardpUser.getTenantCode());
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(mnsMap));
        this.inAsyncInvoke("mns.mns.sendMnslist", paramMap1);
    }

    private String getMnslistExp(Map<String, Object> contentMap, List<Map<String, String>> receiverList) {
        HashMap<String, String> expMap = new HashMap<String, String>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(contentMap);
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        expMap.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        expMap.put("theme", "");
        expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(expMap);
    }

    private void updateCardpStock(CdCardpUserBean cdCardpUserBean) {
        String RsResourceGoodsStr = null;
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("goodsOrigin", "14");
        map1.put("goodsNo", cdCardpUserBean.getCardpCode());
        map1.put("tenantCode", cdCardpUserBean.getTenantCode());
        map.put("map", JsonUtil.buildNormalBinder().toJson(map1));
        RsResourceGoodsStr = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.queryResourceGoodsPage", map);
        if (StringUtils.isBlank((String)RsResourceGoodsStr)) {
            this.logger.error("cd.CARDP.CdCardpUserServiceImplsaveCardpUserByCode.RsResourceGoodsStr1", (Object)RsResourceGoodsStr);
            return;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(RsResourceGoodsStr, SupQueryResult.class);
        List rsResourceGoodsReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsResourceGoodsReDomain.class);
        HashMap<String, String> params = new HashMap<String, String>();
        if (null != rsResourceGoodsReDomainList && rsResourceGoodsReDomainList.size() != 0) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)rsResourceGoodsReDomainList.get(0);
            params.put("goodsOrigin", "14");
            params.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            params.put("tenantCode", rsResourceGoodsReDomain.getTenantCode());
            map.put("map", JsonUtil.buildNormalBinder().toJson(params));
            this.getInternalRouter().inInvoke("rs.resourceGoods.delResourceGoodsByCode", map);
        }
        this.cdCardpCardService.updateCardpStateByCode(cdCardpUserBean.getTenantCode(), cdCardpUserBean.getCardpCode(), 0, 1);
    }
}

