/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.chargeProvided.bankcard.service.impl;

import com.yqbsoft.laser.service.chargeProvided.bankcard.dao.CpBankCardMapper;
import com.yqbsoft.laser.service.chargeProvided.bankcard.domain.CpBankCardDomain;
import com.yqbsoft.laser.service.chargeProvided.bankcard.model.CpBankCard;
import com.yqbsoft.laser.service.chargeProvided.bankcard.service.CpBankCardService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CpBankCardServiceImpl
extends BaseServiceImpl
implements CpBankCardService {
    public static final String SYS_CODE = "cp.CpBankCardServiceImpl";
    private CpBankCardMapper cpBankCardMapper;

    public void setCpBankCardMapper(CpBankCardMapper cpBankCardMapper) {
        this.cpBankCardMapper = cpBankCardMapper;
    }

    private Date getSysDate() {
        try {
            return this.cpBankCardMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cp.CpBankCardServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkbankCard(CpBankCardDomain cpBankCardDomain) {
        if (null == cpBankCardDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setbankCardDefault(CpBankCard cpBankCard) {
        if (null == cpBankCard) {
            return;
        }
        if (null == cpBankCard.getDataState()) {
            cpBankCard.setDataState(0);
        }
        if (null == cpBankCard.getGmtCreate()) {
            cpBankCard.setGmtCreate(this.getSysDate());
        }
        cpBankCard.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cpBankCard.getBankcardCode())) {
            cpBankCard.setBankcardCode(this.createUUIDString());
        }
    }

    private int getbankCardMaxCode() {
        int code = 0;
        try {
            return this.cpBankCardMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cp.CpBankCardServiceImpl.getbankCardMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setbankCardUpdataDefault(CpBankCard cpBankCard) {
        if (null == cpBankCard) {
            return;
        }
        cpBankCard.setGmtModified(this.getSysDate());
    }

    private void savebankCardModel(CpBankCard cpBankCard) throws ApiException {
        if (null == cpBankCard) {
            return;
        }
        try {
            this.cpBankCardMapper.insert(cpBankCard);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpBankCardServiceImpl.savebankCardModel.ex", (Throwable)e);
        }
    }

    private CpBankCard getbankCardModelById(Integer bankcardId) {
        if (null == bankcardId) {
            return null;
        }
        try {
            return this.cpBankCardMapper.selectByPrimaryKey(bankcardId);
        }
        catch (Exception e) {
            this.logger.error("cp.CpBankCardServiceImpl.getbankCardModelById", (Throwable)e);
            return null;
        }
    }

    public CpBankCard getbankCardModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cpBankCardMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpBankCardServiceImpl.getbankCardModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delbankCardModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cpBankCardMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpBankCardServiceImpl.delbankCardModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpBankCardServiceImpl.delbankCardModelByCode.num");
        }
    }

    private void deletebankCardModel(Integer bankcardId) throws ApiException {
        if (null == bankcardId) {
            return;
        }
        int i = 0;
        try {
            i = this.cpBankCardMapper.deleteByPrimaryKey(bankcardId);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpBankCardServiceImpl.deletebankCardModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpBankCardServiceImpl.deletebankCardModel.num");
        }
    }

    private void updatebankCardModel(CpBankCard cpBankCard) throws ApiException {
        if (null == cpBankCard) {
            return;
        }
        try {
            this.cpBankCardMapper.updateByPrimaryKeySelective(cpBankCard);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpBankCardServiceImpl.updatebankCardModel.ex", (Throwable)e);
        }
    }

    private void updateStatebankCardModel(Integer bankcardId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == bankcardId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bankcardId", bankcardId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cpBankCardMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpBankCardServiceImpl.updateStatebankCardModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cp.CpBankCardServiceImpl.updateStatebankCardModel.null");
        }
    }

    private CpBankCard makebankCard(CpBankCardDomain cpBankCardDomain, CpBankCard cpBankCard) {
        if (null == cpBankCardDomain) {
            return null;
        }
        if (null == cpBankCard) {
            cpBankCard = new CpBankCard();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cpBankCard, (Object)cpBankCardDomain);
            return cpBankCard;
        }
        catch (Exception e) {
            this.logger.error("cp.CpBankCardServiceImpl.makebankCard", (Throwable)e);
            return null;
        }
    }

    private List<CpBankCard> querybankCardModelPage(Map<String, Object> parammap) {
        try {
            return this.cpBankCardMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cp.CpBankCardServiceImpl.querybankCardModel", (Throwable)e);
            return null;
        }
    }

    private int countbankCard(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cpBankCardMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpBankCardServiceImpl.countbankCard", (Throwable)e);
        }
        return i;
    }

    @Override
    public String savebankCard(CpBankCardDomain cpBankCardDomain) throws ApiException {
        String msg = this.checkbankCard(cpBankCardDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpBankCardServiceImpl.savebankCard.checkbankCard", msg);
        }
        CpBankCard cpBankCard = this.makebankCard(cpBankCardDomain, null);
        this.setbankCardDefault(cpBankCard);
        this.savebankCardModel(cpBankCard);
        return cpBankCard.getBankcardCode();
    }

    @Override
    public void updatebankCardState(Integer bankcardId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatebankCardModel(bankcardId, dataState, oldDataState);
    }

    @Override
    public void updatebankCard(CpBankCardDomain cpBankCardDomain) throws ApiException {
        String msg = this.checkbankCard(cpBankCardDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpBankCardServiceImpl.updatebankCard.checkbankCard", msg);
        }
        CpBankCard oldCpBankCard = this.getbankCardModelById(cpBankCardDomain.getBankcardId());
        if (null == oldCpBankCard) {
            throw new ApiException("cp.CpBankCardServiceImpl.updatebankCard.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CpBankCard cpBankCard = this.makebankCard(cpBankCardDomain, oldCpBankCard);
        this.setbankCardUpdataDefault(cpBankCard);
        this.updatebankCardModel(cpBankCard);
    }

    @Override
    public CpBankCard getbankCard(Integer bankcardId) {
        return this.getbankCardModelById(bankcardId);
    }

    @Override
    public void deletebankCard(Integer bankcardId) throws ApiException {
        this.deletebankCardModel(bankcardId);
    }

    @Override
    public QueryResult<CpBankCard> querybankCardPage(Map<String, Object> map) {
        List<CpBankCard> cpBankCardList = this.querybankCardModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countbankCard(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cpBankCardList);
        return queryResult;
    }

    @Override
    public CpBankCard getbankCardByCode(Map<String, Object> map) {
        return this.getbankCardModelByCode(map);
    }

    @Override
    public void delbankCardByCode(Map<String, Object> map) throws ApiException {
        this.delbankCardModelByCode(map);
    }

    @Override
    public CpBankCard getbankCardByNo(String cardNo, Integer cardLength) {
        try {
            return this.cpBankCardMapper.getByNo(cardNo, cardLength);
        }
        catch (Exception e) {
            this.logger.error("cp.CpBankCardServiceImpl.getbankCardByNo", (Throwable)e);
            return null;
        }
    }
}

