/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.ContractConstants;
import com.yqbsoft.laser.service.contract.dao.OcSettlListMapper;
import com.yqbsoft.laser.service.contract.dao.OcSettlMapper;
import com.yqbsoft.laser.service.contract.domain.OcSettlDomain;
import com.yqbsoft.laser.service.contract.domain.OcSettlListDomain;
import com.yqbsoft.laser.service.contract.model.OcSettl;
import com.yqbsoft.laser.service.contract.model.OcSettlList;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcSettlService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcSettlServiceImpl
extends BaseServiceImpl
implements OcSettlService {
    public static final String SYS_CODE = "oc.CONTRACT.OcSettlServiceImpl";
    private OcSettlMapper ocSettlMapper;
    private OcSettlListMapper ocSettlListMapper;
    private OcContractService ocContractService;

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    public void setOcSettlMapper(OcSettlMapper ocSettlMapper) {
        this.ocSettlMapper = ocSettlMapper;
    }

    public void setOcSettlListMapper(OcSettlListMapper ocSettlListMapper) {
        this.ocSettlListMapper = ocSettlListMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocSettlMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSettl(OcSettlDomain ocSettlDomain) {
        if (null == ocSettlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setSettlDefault(OcSettl ocSettl) {
        if (null == ocSettl) {
            return;
        }
        if (null == ocSettl.getDataState()) {
            ocSettl.setDataState(0);
        }
        if (null == ocSettl.getGmtCreate()) {
            ocSettl.setGmtCreate(this.getSysDate());
        }
        ocSettl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocSettl.getSettlCode())) {
            ocSettl.setSettlCode(this.createUUIDString());
        }
    }

    private int getSettlMaxCode() {
        int code = 0;
        try {
            return this.ocSettlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.getSettlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSettlUpdataDefault(OcSettl ocSettl) {
        if (null == ocSettl) {
            return;
        }
        ocSettl.setGmtModified(this.getSysDate());
    }

    private void saveSettlModel(OcSettl ocSettl) throws ApiException {
        if (null == ocSettl) {
            return;
        }
        try {
            this.ocSettlMapper.insert(ocSettl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.saveSettlModel.ex", (Throwable)e);
        }
    }

    private OcSettl getSettlModelById(Integer settlId) {
        if (null == settlId) {
            return null;
        }
        try {
            return this.ocSettlMapper.selectByPrimaryKey(settlId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.getSettlModelById", (Throwable)e);
            return null;
        }
    }

    public OcSettl getSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocSettlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.getSettlModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocSettlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.delSettlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.delSettlModelByCode.num");
        }
    }

    private void deleteSettlModel(Integer settlId) throws ApiException {
        if (null == settlId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocSettlMapper.deleteByPrimaryKey(settlId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.deleteSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.deleteSettlModel.num");
        }
    }

    private void updateSettlModel(OcSettl ocSettl) throws ApiException {
        if (null == ocSettl) {
            return;
        }
        try {
            this.ocSettlMapper.updateByPrimaryKeySelective(ocSettl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateSettlModel.ex", (Throwable)e);
        }
    }

    private void updateStateSettlModel(Integer settlId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == settlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("settlId", settlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocSettlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateStateSettlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateStateSettlModel.null");
        }
    }

    private OcSettl makeSettl(OcSettlDomain ocSettlDomain, OcSettl ocSettl) {
        if (null == ocSettlDomain) {
            return null;
        }
        if (null == ocSettl) {
            ocSettl = new OcSettl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocSettl, (Object)ocSettlDomain);
            return ocSettl;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.makeSettl", (Throwable)e);
            return null;
        }
    }

    private List<OcSettl> querySettlModelPage(Map<String, Object> parammap) {
        try {
            return this.ocSettlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.querySettlModel", (Throwable)e);
            return null;
        }
    }

    private int countSettl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocSettlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.countSettl", (Throwable)e);
        }
        return i;
    }

    private String checkSettlList(OcSettlListDomain ocSettlListDomain) {
        if (null == ocSettlListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setSettlListDefault(OcSettlList ocSettlList) {
        if (null == ocSettlList) {
            return;
        }
        if (null == ocSettlList.getDataState()) {
            ocSettlList.setDataState(0);
        }
        if (null == ocSettlList.getGmtCreate()) {
            ocSettlList.setGmtCreate(this.getSysDate());
        }
        ocSettlList.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocSettlList.getSettlListCode())) {
            ocSettlList.setSettlListCode(this.createUUIDString());
        }
    }

    private int getSettlListMaxCode() {
        int code = 0;
        try {
            return this.ocSettlListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.getSettlListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSettlListUpdataDefault(OcSettlList ocSettlList) {
        if (null == ocSettlList) {
            return;
        }
        ocSettlList.setGmtModified(this.getSysDate());
    }

    private void saveSettlListModel(OcSettlList ocSettlList) throws ApiException {
        if (null == ocSettlList) {
            return;
        }
        try {
            this.ocSettlListMapper.insert(ocSettlList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.saveSettlListModel.ex", (Throwable)e);
        }
    }

    private OcSettlList getSettlListModelById(Integer settlListId) {
        if (null == settlListId) {
            return null;
        }
        try {
            return this.ocSettlListMapper.selectByPrimaryKey(settlListId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.getSettlListModelById", (Throwable)e);
            return null;
        }
    }

    public OcSettlList getSettlListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocSettlListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.getSettlListModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSettlListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocSettlListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.delSettlListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.delSettlListModelByCode.num");
        }
    }

    private void deleteSettlListModel(Integer settlListId) throws ApiException {
        if (null == settlListId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocSettlListMapper.deleteByPrimaryKey(settlListId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.deleteSettlListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.deleteSettlListModel.num");
        }
    }

    private void updateSettlListModel(OcSettlList ocSettlList) throws ApiException {
        if (null == ocSettlList) {
            return;
        }
        try {
            this.ocSettlListMapper.updateByPrimaryKeySelective(ocSettlList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateSettlListModel.ex", (Throwable)e);
        }
    }

    private void updateStateSettlListModel(Integer settlListId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == settlListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("settlListId", settlListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocSettlListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateStateSettlListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateStateSettlListModel.null");
        }
    }

    private OcSettlList makeSettlList(OcSettlListDomain ocSettlListDomain, OcSettlList ocSettlList) {
        if (null == ocSettlListDomain) {
            return null;
        }
        if (null == ocSettlList) {
            ocSettlList = new OcSettlList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocSettlList, (Object)ocSettlListDomain);
            return ocSettlList;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.makeSettlList", (Throwable)e);
            return null;
        }
    }

    private List<OcSettlList> querySettlListModelPage(Map<String, Object> parammap) {
        try {
            return this.ocSettlListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.querySettlListModel", (Throwable)e);
            return null;
        }
    }

    private int countSettlList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocSettlListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcSettlServiceImpl.countSettlList", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveSettl(OcSettlDomain ocSettlDomain) throws ApiException {
        String msg = this.checkSettl(ocSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.saveSettl.checkSettl", msg);
        }
        OcSettl ocSettl = this.makeSettl(ocSettlDomain, null);
        this.setSettlDefault(ocSettl);
        this.saveSettlModel(ocSettl);
        if (ListUtil.isNotEmpty(ocSettlDomain.getSettlDomainList())) {
            for (OcSettlListDomain ocSettlListDomain : ocSettlDomain.getSettlDomainList()) {
                ocSettlListDomain.setSettlCode(ocSettl.getSettlCode());
                this.saveSettlList(ocSettlListDomain);
            }
        }
        return ocSettl.getSettlCode();
    }

    @Override
    public void updateSettlState(Integer settlId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSettlModel(settlId, dataState, oldDataState);
    }

    @Override
    public void updateSettl(OcSettlDomain ocSettlDomain) throws ApiException {
        String msg = this.checkSettl(ocSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateSettl.checkSettl", msg);
        }
        OcSettl oldOcSettl = this.getSettlModelById(ocSettlDomain.getSettlId());
        if (null == oldOcSettl) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateSettl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcSettl ocSettl = this.makeSettl(ocSettlDomain, oldOcSettl);
        this.setSettlUpdataDefault(ocSettl);
        this.updateSettlModel(ocSettl);
    }

    @Override
    public OcSettl getSettl(Integer settlId) {
        return this.getSettlModelById(settlId);
    }

    @Override
    public void deleteSettl(Integer settlId) throws ApiException {
        this.deleteSettlModel(settlId);
    }

    @Override
    public QueryResult<OcSettl> querySettlPage(Map<String, Object> map) {
        List<OcSettl> ocSettlList = this.querySettlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSettl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocSettlList);
        return queryResult;
    }

    @Override
    public OcSettl getSettlByCode(Map<String, Object> map) {
        return this.getSettlModelByCode(map);
    }

    @Override
    public void delSettlByCode(Map<String, Object> map) throws ApiException {
        this.delSettlModelByCode(map);
    }

    @Override
    public String saveSettlList(OcSettlListDomain ocSettlListDomain) throws ApiException {
        String msg = this.checkSettlList(ocSettlListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.saveSettlList.checkSettlList", msg);
        }
        OcSettlList ocSettlList = this.makeSettlList(ocSettlListDomain, null);
        this.setSettlListDefault(ocSettlList);
        this.saveSettlListModel(ocSettlList);
        return ocSettlList.getSettlListCode();
    }

    @Override
    public void updateSettlListState(Integer settlListId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSettlListModel(settlListId, dataState, oldDataState);
    }

    @Override
    public void updateSettlList(OcSettlListDomain ocSettlListDomain) throws ApiException {
        String msg = this.checkSettlList(ocSettlListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateSettlList.checkSettlList", msg);
        }
        OcSettlList oldOcSettlList = this.getSettlListModelById(ocSettlListDomain.getSettlListId());
        if (null == oldOcSettlList) {
            throw new ApiException("oc.CONTRACT.OcSettlServiceImpl.updateSettlList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcSettlList ocSettlList = this.makeSettlList(ocSettlListDomain, oldOcSettlList);
        this.setSettlListUpdataDefault(ocSettlList);
        this.updateSettlListModel(ocSettlList);
    }

    @Override
    public OcSettlList getSettlList(Integer settlListId) {
        return this.getSettlListModelById(settlListId);
    }

    @Override
    public void deleteSettlList(Integer settlListId) throws ApiException {
        this.deleteSettlListModel(settlListId);
    }

    @Override
    public QueryResult<OcSettlList> querySettlListPage(Map<String, Object> map) {
        List<OcSettlList> ocSettlListList = this.querySettlListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSettlList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocSettlListList);
        return queryResult;
    }

    @Override
    public OcSettlList getSettlListByCode(Map<String, Object> map) {
        return this.getSettlListModelByCode(map);
    }

    @Override
    public void delSettlListByCode(Map<String, Object> map) throws ApiException {
        this.delSettlListModelByCode(map);
    }

    @Override
    public void updateCashSettlAll(String tenantCode, String settlCode) {
        if (StringUtils.isBlank((String)tenantCode) && StringUtils.isBlank((String)settlCode)) {
            return;
        }
        Map getMap = this.getQueryParamMap("tenantCode,settlCode", new Object[]{tenantCode, settlCode});
        OcSettl ocSettl = this.getSettlByCode(getMap);
        if (ocSettl == null) {
            return;
        }
        List<OcSettlList> settlList = this.querySettlListModelPage(getMap);
        if (ListUtil.isEmpty(settlList)) {
            return;
        }
        for (OcSettlList sl : settlList) {
            try {
                this.ocContractService.updateCashSettl(tenantCode, sl.getContractBillcode());
                this.updateSettlListState(sl.getSettlListId(), ContractConstants.CASH_SETTL_Y, ContractConstants.CASH_SETTL_N);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcSettlServiceImpl.updateCashSettlAll", (Object)(sl.getContractBillcode() + ":\u5df2\u73b0\u91d1\u7ed3\u7b97"));
            }
        }
        this.updateSettlState(ocSettl.getSettlId(), ContractConstants.CASH_SETTL_Y, ContractConstants.CASH_SETTL_N);
    }
}

