/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.contract.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcProductPickGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcProductPickMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcProductPickDomain;
import com.yqbsoft.laser.service.contract.domain.OcProductPickGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcProductPickGoodsReDomain;
import com.yqbsoft.laser.service.contract.domain.OcProductPickReDomain;
import com.yqbsoft.laser.service.contract.domain.UpdateOcProductPickNumDomain;
import com.yqbsoft.laser.service.contract.model.OcProductPick;
import com.yqbsoft.laser.service.contract.model.OcProductPickGoods;
import com.yqbsoft.laser.service.contract.service.OcProductPickGoodsService;
import com.yqbsoft.laser.service.contract.service.OcProductPickService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class OcProductPickServiceImpl
extends BaseServiceImpl
implements OcProductPickService {
    private static final String SYS_CODE = "oc.CONTRACT.OcProductPickServiceImpl";
    private OcProductPickMapper ocProductPickMapper;
    private OcContractGoodsMapper ocContractGoodsMapper;
    private OcProductPickGoodsMapper ocProductPickGoodsMapper;
    OcProductPickGoodsService ocProductPickGoodsService;

    public void setOcContractGoodsMapper(OcContractGoodsMapper ocContractGoodsMapper) {
        this.ocContractGoodsMapper = ocContractGoodsMapper;
    }

    public void setOcProductPickMapper(OcProductPickMapper ocProductPickMapper) {
        this.ocProductPickMapper = ocProductPickMapper;
    }

    public void setOcProductPickGoodsMapper(OcProductPickGoodsMapper ocProductPickGoodsMapper) {
        this.ocProductPickGoodsMapper = ocProductPickGoodsMapper;
    }

    public void setOcProductPickGoodsService(OcProductPickGoodsService ocProductPickGoodsService) {
        this.ocProductPickGoodsService = ocProductPickGoodsService;
    }

    private Date getSysDate() {
        try {
            return this.ocProductPickMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOcProductPick(OcProductPickDomain ocProductPickDomain) {
        if (null == ocProductPickDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocProductPickDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOcProductPickDefault(OcProductPick ocProductPick) {
        if (null == ocProductPick) {
            return;
        }
        if (null == ocProductPick.getDataState()) {
            ocProductPick.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocProductPick.getGmtCreate()) {
            ocProductPick.setGmtCreate(date);
        }
        ocProductPick.setGmtModified(date);
        if (StringUtils.isBlank((String)ocProductPick.getProductPickCode())) {
            String key = "oc:productPickCode";
            Integer digit = 4;
            String code = "HDBH" + DateUtils.getDateStr((String)"yyyyMMdd") + this.getSerialNo(key, digit);
            ocProductPick.setProductPickCode(code);
        }
    }

    private int getOcProductPickMaxCode() {
        int code = 0;
        try {
            return this.ocProductPickMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.getOcProductPickMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOcProductPickUpdataDefault(OcProductPick ocProductPick) {
        if (null == ocProductPick) {
            return;
        }
        ocProductPick.setGmtModified(this.getSysDate());
    }

    private void saveOcProductPickModel(OcProductPick ocProductPick) throws ApiException {
        if (null == ocProductPick) {
            return;
        }
        try {
            this.ocProductPickMapper.insert(ocProductPick);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.saveOcProductPickModel.ex", (Throwable)e);
        }
    }

    private void saveOcProductPickBatchModel(List<OcProductPick> ocProductPickList) throws ApiException {
        if (null == ocProductPickList || ocProductPickList.isEmpty()) {
            return;
        }
        try {
            this.ocProductPickMapper.insertBatch(ocProductPickList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.saveOcProductPickBatchModel.ex", (Throwable)e);
        }
    }

    private OcProductPick getOcProductPickModelById(Integer productPickId) {
        if (null == productPickId) {
            return null;
        }
        try {
            return this.ocProductPickMapper.selectByPrimaryKey(productPickId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.getOcProductPickModelById", (Throwable)e);
            return null;
        }
    }

    private OcProductPick getOcProductPickModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocProductPickMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.getOcProductPickModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOcProductPickModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.delOcProductPickModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.delOcProductPickModelByCode.num");
        }
    }

    private void deleteOcProductPickModel(Integer productPickId) throws ApiException {
        if (null == productPickId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.deleteByPrimaryKey(productPickId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.deleteOcProductPickModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.deleteOcProductPickModel.num");
        }
    }

    private void updateOcProductPickModel(OcProductPick ocProductPick) throws ApiException {
        if (null == ocProductPick) {
            return;
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.updateByPrimaryKey(ocProductPick);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPickModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPickModel.num");
        }
    }

    private void updateStateOcProductPickModel(Integer productPickId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == productPickId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("productPickId", productPickId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateStateOcProductPickModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateStateOcProductPickModel.null");
        }
    }

    private void updateStateOcProductPickModelByCode(String tenantCode, String productPickCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)productPickCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("productPickCode", productPickCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateStateOcProductPickModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateStateOcProductPickModelByCode.null");
        }
    }

    private OcProductPick makeOcProductPick(OcProductPickDomain ocProductPickDomain, OcProductPick ocProductPick) {
        if (null == ocProductPickDomain) {
            return null;
        }
        if (null == ocProductPick) {
            ocProductPick = new OcProductPick();
        }
        try {
            com.yqbsoft.laser.service.tool.util.BeanUtils.copyAllPropertys((Object)ocProductPick, (Object)ocProductPickDomain);
            return ocProductPick;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.makeOcProductPick", (Throwable)e);
            return null;
        }
    }

    private OcProductPickReDomain makeOcProductPickReDomain(OcProductPick ocProductPick) {
        if (null == ocProductPick) {
            return null;
        }
        OcProductPickReDomain ocProductPickReDomain = new OcProductPickReDomain();
        try {
            com.yqbsoft.laser.service.tool.util.BeanUtils.copyAllPropertys((Object)ocProductPickReDomain, (Object)ocProductPick);
            return ocProductPickReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.makeOcProductPickReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcProductPick> queryOcProductPickModelPage(Map<String, Object> parammap) {
        try {
            return this.ocProductPickMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.queryOcProductPickModel", (Throwable)e);
            return null;
        }
    }

    private int countOcProductPick(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocProductPickMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.countOcProductPick", (Throwable)e);
        }
        return i;
    }

    private OcProductPick createOcProductPick(OcProductPickDomain ocProductPickDomain) {
        String msg = this.checkOcProductPick(ocProductPickDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.saveOcProductPick.checkOcProductPick", msg);
        }
        OcProductPick ocProductPick = this.makeOcProductPick(ocProductPickDomain, null);
        this.setOcProductPickDefault(ocProductPick);
        return ocProductPick;
    }

    @Override
    public String saveOcProductPick(OcProductPickDomain ocProductPickDomain) throws ApiException {
        OcProductPick ocProductPick = this.createOcProductPick(ocProductPickDomain);
        this.saveOcProductPickModel(ocProductPick);
        return ocProductPick.getProductPickCode();
    }

    @Override
    public String saveOcProductPickBatch(List<OcProductPickDomain> ocProductPickDomainList) throws ApiException {
        if (null == ocProductPickDomainList || ocProductPickDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcProductPick> ocProductPickList = new ArrayList<OcProductPick>();
        String code = "";
        for (OcProductPickDomain ocProductPickDomain : ocProductPickDomainList) {
            OcProductPick ocProductPick = this.createOcProductPick(ocProductPickDomain);
            code = ocProductPick.getProductPickCode();
            ocProductPickList.add(ocProductPick);
        }
        this.saveOcProductPickBatchModel(ocProductPickList);
        return code;
    }

    @Override
    public void updateOcProductPickState(Integer productPickId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == productPickId) {
            return;
        }
        this.updateStateOcProductPickModel(productPickId, dataState, oldDataState, map);
    }

    @Override
    public void updateOcProductPickStateByCode(String tenantCode, String productPickCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)productPickCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOcProductPickModelByCode(tenantCode, productPickCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOcProductPick(OcProductPickDomain ocProductPickDomain) throws ApiException {
        String msg = this.checkOcProductPick(ocProductPickDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPick.checkOcProductPick", msg);
        }
        OcProductPick oldOcProductPick = this.getOcProductPickModelById(ocProductPickDomain.getProductPickId());
        if (null == oldOcProductPick) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPick.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcProductPick ocProductPick = this.makeOcProductPick(ocProductPickDomain, oldOcProductPick);
        this.setOcProductPickUpdataDefault(ocProductPick);
        this.updateOcProductPickModel(ocProductPick);
    }

    @Override
    public OcProductPick getOcProductPick(Integer productPickId) {
        if (null == productPickId) {
            return null;
        }
        return this.getOcProductPickModelById(productPickId);
    }

    @Override
    public void deleteOcProductPick(Integer productPickId) throws ApiException {
        if (null == productPickId) {
            return;
        }
        this.deleteOcProductPickModel(productPickId);
    }

    @Override
    public QueryResult<OcProductPick> queryOcProductPickPage(Map<String, Object> map) {
        int total = this.countOcProductPick(map);
        List<Object> ocProductPickList = new ArrayList();
        if (total > 0) {
            ocProductPickList = this.queryOcProductPickModelPage(map);
            if (map.get("goodsList") != null && ListUtil.isNotEmpty(ocProductPickList)) {
                String codes = ocProductPickList.stream().map(OcProductPick::getProductPickCode).collect(Collectors.joining(","));
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                tempMap.put("productPickCode", codes);
                tempMap.put("goodsName", map.get("goodsName"));
                List<OcProductPickGoods> ocProductPickGoods = this.ocProductPickGoodsMapper.query(tempMap);
                if (ListUtil.isNotEmpty(ocProductPickGoods)) {
                    Map<String, List<OcProductPickGoods>> listMap = ocProductPickGoods.stream().collect(Collectors.groupingBy(OcProductPickGoods::getProductPickCode));
                    ocProductPickList.forEach(o -> {
                        if (listMap.containsKey(o.getProductPickCode())) {
                            o.setProductPickGoodsDomains((List)listMap.get(o.getProductPickCode()));
                        }
                    });
                }
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(total);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocProductPickList);
        return queryResult;
    }

    @Override
    public OcProductPick getOcProductPickByCode(String tenantCode, String productPickCode) throws ApiException {
        if (StringUtils.isBlank((String)productPickCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("productPickCode", productPickCode);
        return this.getOcProductPickModelByCode(map);
    }

    @Override
    public void deleteOcProductPickByCode(String tenantCode, String productPickCode) throws ApiException {
        if (StringUtils.isBlank((String)productPickCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("productPickCode", productPickCode);
        this.delOcProductPickModelByCode(map);
    }

    @Override
    public OcProductPick saveOcProductPickAndGoods(OcProductPickReDomain ocProductPickReDomain) throws ApiException {
        String msg = this.checkOcProductPick(ocProductPickReDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.saveOcProductPickAndGoods.checkOcProductPick", msg);
        }
        if (EmptyUtil.isEmpty((Object)ocProductPickReDomain.getProductPickId())) {
            OcProductPick ocProductPick = this.makeOcProductPick(ocProductPickReDomain, null);
            this.setOcProductPickDefault(ocProductPick);
            this.saveOcProductPickModel(ocProductPick);
            this.saveProdcutPickGoods(ocProductPickReDomain, ocProductPick);
            return ocProductPick;
        }
        OcProductPick ocProductPick = this.getOcProductPick(ocProductPickReDomain.getProductPickId());
        if (EmptyUtil.isEmpty((Object)ocProductPick)) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.saveOcProductPickAndGoods", "\u5907\u8d27\u5355\u4e0d\u5b58\u5728");
        }
        OcProductPick ocProductPickUpdate = this.makeOcProductPick(ocProductPickReDomain, null);
        ocProductPickUpdate.setProductPickId(ocProductPick.getProductPickId());
        ocProductPickUpdate.setProductPickCode(ocProductPick.getProductPickCode());
        ocProductPickUpdate.setTenantCode(ocProductPick.getTenantCode());
        ocProductPickUpdate.setDesignUserCode(ocProductPick.getDesignUserCode());
        ocProductPickUpdate.setDesignUserName(ocProductPick.getDesignUserName());
        ocProductPickUpdate.setGmtCreate(ocProductPick.getGmtCreate());
        ocProductPickUpdate.setGmtModified(this.getSysDate());
        this.updateOcProductPickModel(ocProductPickUpdate);
        HashMap<String, Object> productPickGoodsMap = new HashMap<String, Object>(4);
        productPickGoodsMap.put("tenantCode", ocProductPick.getTenantCode());
        productPickGoodsMap.put("productPickCode", ocProductPick.getProductPickCode());
        List<OcProductPickGoods> remainContractGoods = this.ocProductPickGoodsService.queryOcProductPickGoods(productPickGoodsMap);
        if (!EmptyUtil.isEmpty(remainContractGoods)) {
            this.ocProductPickGoodsService.deleteOcProductPickGoodsByProductPickCode(ocProductPick.getTenantCode(), ocProductPick.getProductPickCode());
        }
        this.saveProdcutPickGoods(ocProductPickReDomain, ocProductPick);
        return ocProductPick;
    }

    @Override
    public void updateOcProductPickById(OcProductPickReDomain ocProductPickReDomain) throws ApiException {
        if (null == ocProductPickReDomain) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPickById.checkOcProductPick", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (EmptyUtil.isEmpty((Object)ocProductPickReDomain.getProductPickId())) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPickById.checkOcProductPick", "\u4e3b\u952e\u4e3a\u7a7a");
        }
        OcProductPick ocProductPick = new OcProductPick();
        BeanUtils.copyProperties((Object)ocProductPickReDomain, (Object)ocProductPick);
        int i = 0;
        try {
            i = this.ocProductPickMapper.updateByPrimaryKeySelective(ocProductPick);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPickById.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPickById.null");
        }
    }

    @Override
    public String updateOcProductPickGoodsCanSendRatioBatch(Map<String, Object> map) throws ApiException {
        String paramStr = String.valueOf(map.get("paramStr"));
        if (EmptyUtil.isEmpty((Object)paramStr)) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPickGoodsBatch.paramStr is null");
        }
        String tenantCode = String.valueOf(map.get("tenantCode"));
        List ocProductPickGoodsReDomains = JsonUtil.buildNormalBinder().getJsonToList(paramStr, OcProductPickGoodsReDomain.class);
        List currProductPickGoodsIds = ocProductPickGoodsReDomains.stream().map(t -> t.getProductPickGoodsId()).collect(Collectors.toList());
        String productPickCode = ((OcProductPickGoodsReDomain)ocProductPickGoodsReDomains.get(0)).getProductPickCode();
        OcProductPick ocProductPick = this.getOcProductPickByCode(tenantCode, productPickCode);
        if (EmptyUtil.isEmpty((Object)ocProductPick)) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl\u5907\u8d27\u5355" + productPickCode + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e");
        }
        HashMap<String, Object> goodsMap = new HashMap<String, Object>(2);
        goodsMap.put("productPickCode", productPickCode);
        goodsMap.put("tenantCode", tenantCode);
        List<OcProductPickGoods> productPickGoodss = this.ocProductPickGoodsService.queryOcProductPickGoods(goodsMap);
        List difference = productPickGoodss.stream().filter(ppg -> !currProductPickGoodsIds.contains(ppg.getProductPickGoodsId())).collect(Collectors.toList());
        BigDecimal totalCanSendNum = BigDecimal.ZERO;
        for (OcProductPickGoodsReDomain ocProductPickGoodsReDomain : ocProductPickGoodsReDomains) {
            if (EmptyUtil.isEmpty((Object)ocProductPickGoodsReDomain.getProductPickGoodsId())) {
                throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl\u4e3b\u952e\u4e3a\u7a7a");
            }
            if (EmptyUtil.isEmpty((Object)ocProductPickGoodsReDomain.getCanSendRatio())) {
                throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl\u53ef\u53d1\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OcProductPickGoods productPickGoods = this.ocProductPickGoodsService.getOcProductPickGoods(ocProductPickGoodsReDomain.getProductPickGoodsId());
            if (EmptyUtil.isEmpty((Object)productPickGoods.getGoodsNum())) {
                throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl\u53d1\u8d27\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BigDecimal canSendNum = ocProductPickGoodsReDomain.getCanSendRatio().multiply(new BigDecimal(productPickGoods.getGoodsNum()));
            if (!OcProductPickServiceImpl.isPositiveInteger(canSendNum)) {
                throw new ApiException(SYS_CODE + ocProductPickGoodsReDomain.getGoodsName() + "\u53ef\u53d1\u8d27\u6570\u4e0d\u4e3a\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539\u53ef\u53d1\u8d27\u6bd4\u4f8b");
            }
            ocProductPickGoodsReDomain.setCanSendNum(canSendNum.intValue());
            ocProductPickGoodsReDomain.setUnsendNum(canSendNum.intValue());
            totalCanSendNum = totalCanSendNum.add(canSendNum);
            this.ocProductPickGoodsService.updateOcProductPickGoodsById(ocProductPickGoodsReDomain);
        }
        for (OcProductPickGoods oppg : difference) {
            totalCanSendNum = totalCanSendNum.add(new BigDecimal(oppg.getCanSendNum()));
        }
        OcProductPickReDomain ocProductPickReDomain = new OcProductPickReDomain();
        BeanUtils.copyProperties((Object)ocProductPick, (Object)ocProductPickReDomain);
        ocProductPickReDomain.setTotalCanSendNum(totalCanSendNum.intValue());
        ocProductPickReDomain.setTotalUnsendNum(totalCanSendNum.intValue());
        this.updateOcProductPickById(ocProductPickReDomain);
        productPickGoodss = this.ocProductPickGoodsService.queryOcProductPickGoods(goodsMap);
        ArrayList<OcProductPickGoodsDomain> productPickGoodsDomains = new ArrayList<OcProductPickGoodsDomain>();
        for (OcProductPickGoods productPickGoods : productPickGoodss) {
            OcProductPickGoodsDomain productPickGoodsDomain = new OcProductPickGoodsDomain();
            BeanUtils.copyProperties((Object)productPickGoods, (Object)productPickGoodsDomain);
            productPickGoodsDomains.add(productPickGoodsDomain);
        }
        ocProductPickReDomain.setProductPickGoodsDomains(productPickGoodsDomains);
        String result = JsonUtil.buildNormalBinder().toJson((Object)ocProductPickReDomain);
        return result;
    }

    @Override
    public QueryResult<Map> exportPickGoodsExcel(Map<String, Object> map) throws ApiException {
        ArrayList<Map> pickGoods = new ArrayList<Map>(24);
        List<OcProductPick> ocProductPicks = this.ocProductPickMapper.query(map);
        for (OcProductPick pick : ocProductPicks) {
            HashMap<String, Object> goodsMap = new HashMap<String, Object>(2);
            goodsMap.put("productPickCode", pick.getProductPickCode());
            goodsMap.put("tenantCode", pick.getTenantCode());
            List<OcProductPickGoods> ocProductPickGoods = this.ocProductPickGoodsMapper.query(goodsMap);
            for (OcProductPickGoods productPickGoods : ocProductPickGoods) {
                Map pickMap = MapUtil.castMap((Object)pick);
                Map pickGoodsMap = MapUtil.castMap((Object)productPickGoods);
                pickGoodsMap.remove("tenantCode");
                pickGoodsMap.remove("gmtCreate");
                pickGoodsMap.remove("gmtModified");
                pickGoodsMap.remove("memo");
                pickGoodsMap.remove("dataState");
                pickGoodsMap.remove("channelCode");
                pickGoodsMap.remove("channelName");
                pickMap.putAll(pickGoodsMap);
                pickGoods.add(pickMap);
            }
        }
        QueryResult qr = new QueryResult();
        qr.setList(pickGoods);
        return qr;
    }

    @Override
    public String updateOcProductPickSendNum(List<OcContractGoodsDomain> ocContractGoodsDomainList) {
        if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
            return "error";
        }
        HashSet<String> pickCodesToUpdate = new HashSet<String>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            String s = this.updateSendOcProductPickGoodsModel(ocContractGoodsDomain.getGoodsCode(), ocContractGoodsDomain.getChannelCode(), ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain.getTenantCode(), 1, ocContractGoodsDomain.getContractGoodsSendnum());
            if (s == null) continue;
            pickCodesToUpdate.add(s);
        }
        for (String pickCode : pickCodesToUpdate) {
            this.updateOcProductPickSummary(pickCode);
        }
        return "success";
    }

    @Override
    public String updateOcProductPickNum(List<UpdateOcProductPickNumDomain> updateOcProductPickNumDomains) {
        List<OcProductPickGoods> ocProductPickGoods;
        if (ListUtil.isEmpty(updateOcProductPickNumDomains)) {
            this.logger.error("updateOcProductPickNum: \u53d8\u52a8\u5907\u8d27\u5355\u5546\u54c1\u6570\u636e\u4e3a\u7a7a");
            return "error";
        }
        List tempList = updateOcProductPickNumDomains.stream().filter(u -> StringUtils.isBlank((String)u.getProductPickGoodsCode())).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(tempList)) {
            this.logger.error("updateOcProductPickNum: \u5907\u8d27\u5355\u5546\u54c1\u884c\u7f16\u7801\u4e3a\u7a7a");
            return "error";
        }
        this.logger.info("\u5165\u53c2updateOcProductPickNum: {}", (Object)JSON.toJSONString(updateOcProductPickNumDomains));
        String codes = updateOcProductPickNumDomains.stream().map(UpdateOcProductPickNumDomain::getProductPickGoodsCode).collect(Collectors.joining(","));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("productPickGoodsCode", codes);
        paramMap.put("tenantCode", updateOcProductPickNumDomains.get(0).getTenantCode());
        try {
            ocProductPickGoods = this.ocProductPickGoodsMapper.query(paramMap);
        }
        catch (Exception e) {
            this.logger.error("Failed to query OcProductPickGoods with codes: {}", (Object)codes, (Throwable)e);
            return "error";
        }
        if (ListUtil.isNotEmpty(ocProductPickGoods)) {
            ocProductPickGoods.forEach(this::setDefaultValues);
        }
        Map<String, BigDecimal> pickGoodsMap = updateOcProductPickNumDomains.stream().collect(Collectors.toMap(UpdateOcProductPickNumDomain::getProductPickGoodsCode, UpdateOcProductPickNumDomain::getChangeNum, (p1, p2) -> p2));
        String optType = updateOcProductPickNumDomains.get(0).getOptType();
        ArrayList<OcProductPickGoods> updateDataList = new ArrayList<OcProductPickGoods>();
        switch (optType) {
            case "create": {
                this.handleCreateOperation(ocProductPickGoods, pickGoodsMap, updateDataList);
                break;
            }
            case "passThrough": {
                this.handlePassThroughOperation(ocProductPickGoods, pickGoodsMap, updateDataList);
                break;
            }
            case "error": {
                this.handleErrorOperation(ocProductPickGoods, pickGoodsMap, updateDataList);
                break;
            }
            default: {
                this.logger.error("Unknown operation type: {}", (Object)optType);
                return "error";
            }
        }
        if (ListUtil.isNotEmpty(updateDataList)) {
            try {
                this.ocProductPickGoodsMapper.batchUpdate(updateDataList);
            }
            catch (Exception e) {
                this.logger.error("Failed to batch update OcProductPickGoods", (Throwable)e);
                return "error";
            }
        }
        ArrayList ocProductPickGoodsArrayList = ocProductPickGoods.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OcProductPickGoods>(Comparator.comparing(s -> String.valueOf(s.getProductPickCode())))), ArrayList::new));
        ocProductPickGoodsArrayList.forEach(o -> this.updateOcProductPickSummary(o.getProductPickCode()));
        return "success";
    }

    private void setDefaultValues(OcProductPickGoods o) {
        if (o.getUnsendNum() == null) {
            o.setUnsendNum(BigDecimal.ZERO.intValue());
        }
        if (o.getSendNum() == null) {
            o.setSendNum(BigDecimal.ZERO.intValue());
        }
        if (o.getCanSendNum() == null) {
            o.setCanSendNum(BigDecimal.ZERO.intValue());
        }
    }

    private void handleCreateOperation(List<OcProductPickGoods> ocProductPickGoods, Map<String, BigDecimal> pickGoodsMap, List<OcProductPickGoods> updateDataList) {
        ocProductPickGoods.forEach(o -> {
            if (pickGoodsMap.containsKey(o.getProductPickGoodsCode())) {
                OcProductPickGoods productPickGoods = new OcProductPickGoods();
                productPickGoods.setProductPickGoodsCode(o.getProductPickGoodsCode());
                productPickGoods.setCanSendNum(o.getCanSendNum() - ((BigDecimal)pickGoodsMap.get(o.getProductPickGoodsCode())).intValue());
                updateDataList.add(productPickGoods);
            }
        });
    }

    private void handlePassThroughOperation(List<OcProductPickGoods> ocProductPickGoods, Map<String, BigDecimal> pickGoodsMap, List<OcProductPickGoods> updateDataList) {
        ocProductPickGoods.forEach(o -> {
            if (pickGoodsMap.containsKey(o.getProductPickGoodsCode())) {
                OcProductPickGoods productPickGoods = new OcProductPickGoods();
                productPickGoods.setProductPickGoodsCode(o.getProductPickGoodsCode());
                productPickGoods.setSendNum(o.getSendNum() + ((BigDecimal)pickGoodsMap.get(o.getProductPickGoodsCode())).intValue());
                productPickGoods.setUnsendNum(o.getUnsendNum() - ((BigDecimal)pickGoodsMap.get(o.getProductPickGoodsCode())).intValue());
                updateDataList.add(productPickGoods);
            }
        });
    }

    private void handleErrorOperation(List<OcProductPickGoods> ocProductPickGoods, Map<String, BigDecimal> pickGoodsMap, List<OcProductPickGoods> updateDataList) {
        ocProductPickGoods.forEach(o -> {
            if (pickGoodsMap.containsKey(o.getProductPickGoodsCode())) {
                OcProductPickGoods productPickGoods = new OcProductPickGoods();
                productPickGoods.setProductPickGoodsCode(o.getProductPickGoodsCode());
                productPickGoods.setCanSendNum(o.getCanSendNum() + ((BigDecimal)pickGoodsMap.get(o.getProductPickGoodsCode())).intValue());
                updateDataList.add(productPickGoods);
            }
        });
    }

    private String updateSendOcProductPickGoodsModel(String goodsCode, String channelCode, String skuNo, String tenantCode, Integer dataState, BigDecimal contractGoodsSendnum) {
        if (StringUtils.isEmpty((String)goodsCode) || StringUtils.isEmpty((String)tenantCode) || null == dataState) {
            return null;
        }
        if (null == contractGoodsSendnum) {
            contractGoodsSendnum = BigDecimal.ZERO;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("channelCode", channelCode);
        map.put("skuNo", skuNo);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        OcProductPickGoods ocProductPickGoods = this.ocProductPickGoodsMapper.selectByGoodsCode(map);
        if (ocProductPickGoods == null) {
            return null;
        }
        Integer sendNumToUpdate = contractGoodsSendnum == null ? 0 : contractGoodsSendnum.intValue();
        Integer canSendNum = ocProductPickGoods.getCanSendNum();
        Integer sendNum = ocProductPickGoods.getSendNum();
        Integer unsendNum = ocProductPickGoods.getUnsendNum();
        Integer newSendNum = sendNumToUpdate;
        Integer newCanSendNum = canSendNum - sendNumToUpdate;
        Integer newUnsendNum = canSendNum - sendNumToUpdate;
        ocProductPickGoods.setCanSendNum(newCanSendNum);
        ocProductPickGoods.setSendNum(newSendNum);
        ocProductPickGoods.setUnsendNum(newUnsendNum);
        this.ocProductPickGoodsMapper.updateByPrimaryKey(ocProductPickGoods);
        return ocProductPickGoods.getProductPickCode();
    }

    private void updateOcProductPickSummary(String productPickCode) {
        Map<String, Object> summary = this.ocProductPickGoodsMapper.selectSummaryByPickCode(productPickCode);
        if (summary != null) {
            OcProductPick ocProductPick = new OcProductPick();
            ocProductPick.setProductPickCode(productPickCode);
            ocProductPick.setTotalCanSendNum(this.convertToInteger(summary.get("totalCanSendNum")));
            ocProductPick.setTotalSendNum(this.convertToInteger(summary.get("totalSendNum")));
            ocProductPick.setTotalUnsendNum(this.convertToInteger(summary.get("totalUnsendNum")));
            ocProductPick.setTotalGoodsNum(this.convertToInteger(summary.get("totalCanSendNum")) + this.convertToInteger(summary.get("totalSendNum")));
            this.ocProductPickMapper.updateSummaryByPickCode(ocProductPick);
        }
    }

    private Integer convertToInteger(Object value) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValue();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public static boolean isPositiveInteger(BigDecimal number) {
        if (number.compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        return number.stripTrailingZeros().scale() <= 0;
    }

    private void saveProdcutPickGoods(OcProductPickReDomain ocProductPickReDomain, OcProductPick ocProductPick) {
        if (!EmptyUtil.isEmpty(ocProductPickReDomain.getProductPickGoodsDomains())) {
            ArrayList<OcProductPickGoods> ocProductPickGoods = new ArrayList<OcProductPickGoods>(24);
            for (OcProductPickGoodsDomain ocProductPickGoodsDomain : ocProductPickReDomain.getProductPickGoodsDomains()) {
                OcProductPickGoods productPickGoods = new OcProductPickGoods();
                productPickGoods.setTenantCode(ocProductPick.getTenantCode());
                productPickGoods.setProductPickCode(ocProductPick.getProductPickCode());
                productPickGoods.setSkuEocode(ocProductPickGoodsDomain.getSkuEocode());
                productPickGoods.setGoodsCode(ocProductPickGoodsDomain.getGoodsCode());
                productPickGoods.setGoodsName(ocProductPickGoodsDomain.getGoodsName());
                productPickGoods.setGoodsNum(ocProductPickGoodsDomain.getGoodsNum());
                productPickGoods.setCanSendNum(ocProductPickGoodsDomain.getCanSendNum());
                productPickGoods.setSendNum(ocProductPickGoodsDomain.getSendNum());
                productPickGoods.setUnsendNum(ocProductPickGoodsDomain.getUnsendNum());
                productPickGoods.setSkuNo(ocProductPickGoodsDomain.getSkuNo());
                productPickGoods.setSkuName(ocProductPickGoodsDomain.getSkuName());
                productPickGoods.setChannelCode(ocProductPickReDomain.getChannelCode());
                productPickGoods.setChannelName(ocProductPickReDomain.getChannelName());
                this.setOcProductPickGoodsDefault(productPickGoods);
                ocProductPickGoods.add(productPickGoods);
            }
            this.ocProductPickGoodsMapper.insertBatch(ocProductPickGoods);
        }
    }

    private void setOcProductPickGoodsDefault(OcProductPickGoods ocProductPickGoods) {
        if (null == ocProductPickGoods) {
            return;
        }
        if (null == ocProductPickGoods.getDataState()) {
            ocProductPickGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocProductPickGoods.getGmtCreate()) {
            ocProductPickGoods.setGmtCreate(date);
        }
        ocProductPickGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)ocProductPickGoods.getProductPickGoodsCode())) {
            ocProductPickGoods.setProductPickGoodsCode(this.getNo(null, "OcProductPickGoods", "ocProductPickGoods", ocProductPickGoods.getTenantCode()));
        }
    }

    public String getSerialNo(String key, Integer digit) {
        Long delta = 1L;
        Long serialNo = DisUtil.incr((String)key, (Long)delta);
        if (serialNo == 1L) {
            Date zeroDate = DateUtils.getEndOfDay((Date)new Date());
            Date nowDate = new Date();
            Long failureTime = (zeroDate.getTime() - nowDate.getTime()) / 1000L;
            this.logger.info("\u6d41\u6c34\u53f7\u5931\u6548\u65f6\u95f4{}", (Object)failureTime);
            DisUtil.setExpire((String)key, (int)Math.toIntExact(failureTime));
            this.logger.info("\u6d41\u6c34\u53f7\u9996\u6b21\u8bbe\u7f6e\u6709\u6548\u65f6\u95f4\u5230\u6b21\u65e5\u96f6\u65f6");
        }
        this.logger.info("\u6d41\u6c34\u53f7:{}", (Object)String.format("%0" + digit + "d", serialNo));
        return String.format("%0" + digit + "d", serialNo);
    }
}

