/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class ReportCodeGenerator {
    private static final ThreadLocal<String> currentDate = ThreadLocal.withInitial(() -> "");
    private static final AtomicInteger sequence = new AtomicInteger(0);
    private static final String PREFIX_SINGLE = "HDDT";
    private static final String PREFIX_STRATEGY = "ZLBB";

    public static String generate(boolean isSingleProject) {
        String prefix = isSingleProject ? PREFIX_SINGLE : PREFIX_STRATEGY;
        String today = new SimpleDateFormat("yyyyMMdd").format(new Date());
        if (!today.equals(currentDate.get())) {
            currentDate.set(today);
            sequence.set(0);
        }
        int seq = sequence.incrementAndGet();
        return String.format("%s%s%04d", prefix, today, seq);
    }

    public static void main(String[] args) {
        System.out.println(ReportCodeGenerator.generate(true));
        System.out.println(ReportCodeGenerator.generate(false));
        System.out.println(ReportCodeGenerator.generate(true));
    }
}

