/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.biz.OrderPaymentFlowService;
import com.yqbsoft.laser.service.contract.domain.BizPaymentFlow;
import com.yqbsoft.laser.service.contract.enums.PayChannelsEnum;
import com.yqbsoft.laser.service.contract.requery.PayCallbackRequery;
import com.yqbsoft.laser.service.contract.requery.PayOrderRequery;
import com.yqbsoft.laser.service.contract.requery.PayRequest;
import com.yqbsoft.laser.service.contract.result.PaymentResult;
import com.yqbsoft.laser.service.contract.service.OrderPaymentService;
import com.yqbsoft.laser.service.contract.utils.FlowNoGenerator;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="orderPaymentService")
public class OrderPaymentServiceImpl
extends BaseServiceImpl
implements OrderPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OrderPaymentServiceImpl.class);
    private final OrderPaymentFlowService orderPaymentFlowService;
    private final InternalRouter internalRouter;
    private static final String ACTION_PAYMENT_REQ = "middle.payment.pay";

    @Override
    public String orderPayment(PayOrderRequery payOrderRequery) throws Exception {
        String orderNo = payOrderRequery.getOrderNo();
        String traceId = UUID.randomUUID().toString();
        log.info("[Payment][{}] \u5f00\u59cb\u5904\u7406\u652f\u4ed8\u8bf7\u6c42, orderNo={}", (Object)traceId, (Object)orderNo);
        BizPaymentFlow existingFlow = this.orderPaymentFlowService.getProcessingPaymentFlow(orderNo);
        if (existingFlow != null) {
            log.info("[Payment][{}] \u8ba2\u5355 {} \u5df2\u6709\u6b63\u5728\u652f\u4ed8\u6d41\u6c34\uff0c\u8fd4\u56de\u73b0\u6709\u4e8c\u7ef4\u7801", (Object)traceId, (Object)orderNo);
            return Optional.ofNullable(existingFlow.getQrCodeUrl()).orElse(existingFlow.getPayUrl());
        }
        long amountFen = payOrderRequery.getAmount().multiply(BigDecimal.valueOf(100L)).longValue();
        String flowNo = FlowNoGenerator.generate("PAY");
        PayRequest payRequest = PayRequest.builder().merchantCode(payOrderRequery.getMerchantCode()).outTradeNo(flowNo).amount(amountFen).notifyUrl(payOrderRequery.getNotifyUrl()).channel(PayChannelsEnum.CMB.getCode()).subject(payOrderRequery.getSubject()).tradeType("QR_CODE").build();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("payRequest", JSONObject.toJSONString((Object)payRequest));
        log.info("[Payment][{}] \u53d1\u8d77\u5185\u90e8\u652f\u4ed8\u8c03\u7528: {}", (Object)traceId, (Object)ACTION_PAYMENT_REQ);
        Object result = this.internalRouter.inInvoke(ACTION_PAYMENT_REQ, "1.0", "0", paramMap);
        log.info("[Payment][{}] \u652f\u4ed8\u8fd4\u56de\u7ed3\u679c \u539f\u59cb\u5185\u5bb9: {}", (Object)traceId, (Object)JSONObject.toJSONString((Object)result));
        BizPaymentFlow flow = BizPaymentFlow.builder().orderNo(orderNo).customerCode(payOrderRequery.getCustomerCode()).merchantCode(payOrderRequery.getMerchantCode()).flowType(BizPaymentFlow.FlowType.PAYMENT).status(BizPaymentFlow.FlowStatus.PROCESSING).amount(amountFen).currency("CNY").traceId(traceId).remark("\u8ba2\u5355\u652f\u4ed8").build();
        try {
            PaymentResult paymentResult = (PaymentResult)JsonUtil.buildNonDefaultBinder().getJsonToObject((String)result, PaymentResult.class);
            log.info("[Payment][{}] \u652f\u4ed8\u8fd4\u56de\u7ed3\u679c: {}", (Object)traceId, (Object)JSONObject.toJSONString((Object)paymentResult));
            flow.setPaymentOrderNo(paymentResult.getPaymentOrderNo());
            flow.setQrCodeUrl(paymentResult.getQrCodeContent());
            flow.setFlowNo(flowNo);
            if (paymentResult.isSuccess()) {
                flow.setStatus(BizPaymentFlow.FlowStatus.PROCESSING);
                flow.setRemark(paymentResult.getRawResponse());
                this.orderPaymentFlowService.createPaymentFlow(flow);
                log.info("[Payment][{}] \u751f\u6210\u652f\u4ed8\u4fe1\u606f\u6210\u529f, orderNo={}, paymentOrderNo={}, qrCodeUrl={}", new Object[]{traceId, orderNo, flow.getPaymentOrderNo(), flow.getQrCodeUrl()});
                return paymentResult.getQrCodeContent();
            }
            flow.setStatus(BizPaymentFlow.FlowStatus.FAIL);
            flow.setRemark(paymentResult.getRawResponse());
            this.orderPaymentFlowService.createPaymentFlow(flow);
            log.error("[Payment][{}] \u652f\u4ed8\u4e1a\u52a1\u5931\u8d25: respCode={}, errCode={}, msg={}", new Object[]{traceId, paymentResult.getErrorCode(), paymentResult.getErrorCode(), paymentResult.getErrorMessage()});
            throw new RuntimeException(paymentResult.getErrorMessage());
        }
        catch (Exception e) {
            log.error("[Payment][{}] \u652f\u4ed8\u8bf7\u6c42\u89e3\u6790\u6216\u5904\u7406\u5931\u8d25: {}", new Object[]{traceId, e.getMessage(), e});
            flow.setStatus(BizPaymentFlow.FlowStatus.FAIL);
            flow.setRemark(e.getMessage());
            flow.setFlowNo(flowNo);
            this.orderPaymentFlowService.createPaymentFlow(flow);
            throw new RuntimeException("\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public BizPaymentFlow payCallback(PayCallbackRequery payCallbackRequery) throws Exception {
        BizPaymentFlow flow = this.orderPaymentFlowService.getPaymentFlowByNo(payCallbackRequery.getFlowNo());
        flow.setPaymentOrderNo(payCallbackRequery.getPaymentOrderNo());
        flow.setStatus(BizPaymentFlow.FlowStatus.SUCCESS);
        flow.setUpdatedAt(LocalDateTime.now());
        this.orderPaymentFlowService.update(flow);
        return flow;
    }

    public OrderPaymentServiceImpl(OrderPaymentFlowService orderPaymentFlowService, InternalRouter internalRouter) {
        this.orderPaymentFlowService = orderPaymentFlowService;
        this.internalRouter = internalRouter;
    }
}

