/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.handler;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.contract.handler.ApprovalBizHandler;
import com.yqbsoft.laser.service.contract.model.OcApprovalInstance;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="shipment_short_payHandler")
public class ShipmentShortPayHandler
implements ApprovalBizHandler {
    private static final Logger log = LoggerFactory.getLogger(ShipmentShortPayHandler.class);
    private static final String BIZ_TYPE = "SHIPMENT";
    private static final String ACTION_GET_SEND_GOODS = "sg.sendgoods.getSgSendGoods";
    private final InternalRouter internalRouter;

    @Override
    public String getBizType() {
        return BIZ_TYPE;
    }

    @Override
    public String validateBeforeApply(String bizId) {
        SgSendgoodsReDomain sendGoods = this.findSendGoodsById(bizId);
        if (sendGoods == null) {
            throw new ApiException("\u53d1\u8d27\u5355\u4e0d\u5b58\u5728\uff01\u5355\u53f7\uff1a" + bizId);
        }
        log.info("\u53d1\u8d27\u5355\u6821\u9a8c\u901a\u8fc7\uff1a{}", (Object)bizId);
        return JSONObject.toJSONString((Object)sendGoods);
    }

    private SgSendgoodsReDomain findSendGoodsById(String bizId) {
        Object result;
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("sendgoodsCode", bizId);
        HashMap<String, HashMap<String, String>> paramMap = new HashMap<String, HashMap<String, String>>();
        paramMap.put("map", innerMap);
        try {
            result = this.internalRouter.inInvoke(ACTION_GET_SEND_GOODS, "1.0", "0", paramMap);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5185\u90e8\u670d\u52a1\u83b7\u53d6\u53d1\u8d27\u5355\u5931\u8d25\uff0c\u5355\u53f7\uff1a{}", (Object)bizId, (Object)e);
            throw new ApiException("\u7cfb\u7edf\u9519\u8bef\uff1a\u67e5\u8be2\u53d1\u8d27\u5355\u5931\u8d25\uff01");
        }
        if (result == null) {
            return null;
        }
        try {
            return (SgSendgoodsReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject((String)result, SgSendgoodsReDomain.class);
        }
        catch (Exception e) {
            log.error("\u53d1\u8d27\u5355 JSON \u89e3\u6790\u5931\u8d25\uff0c\u5355\u53f7\uff1a{}", (Object)bizId, (Object)e);
            throw new ApiException("\u6570\u636e\u5f02\u5e38\uff1a\u53d1\u8d27\u5355\u89e3\u6790\u5931\u8d25\uff01");
        }
    }

    @Override
    public void onApproved(OcApprovalInstance instance) {
        log.info("\u53d1\u8d27\u7f3a\u6b3e\u5ba1\u6279\u901a\u8fc7\uff1a{}", (Object)instance.getBizId());
    }

    @Override
    public void onRejected(OcApprovalInstance instance) {
        log.info("\u53d1\u8d27\u7f3a\u6b3e\u5ba1\u6279\u9a73\u56de\uff1a{}", (Object)instance.getBizId());
    }

    public ShipmentShortPayHandler(InternalRouter internalRouter) {
        this.internalRouter = internalRouter;
    }
}

