/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.handler.payment;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.handler.payment.PaymentHandler;
import com.yqbsoft.laser.service.contract.requery.PayOrderRequery;
import com.yqbsoft.laser.service.contract.requery.PayRequest;
import com.yqbsoft.laser.service.contract.result.PaymentResult;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import java.math.BigDecimal;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInternalRouterPaymentHandler
implements PaymentHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractInternalRouterPaymentHandler.class);
    private final InternalRouter internalRouter;
    private static final String ACTION_PAYMENT_REQ = "middle.payment.pay";

    protected AbstractInternalRouterPaymentHandler(InternalRouter internalRouter) {
        this.internalRouter = internalRouter;
    }

    protected abstract String getChannelCode();

    protected abstract String getTradeType();

    protected abstract String getLogPrefix();

    @Override
    public PaymentResult pay(PayOrderRequery req, String flowNo, String traceId) {
        long amountFen = req.getAmount().multiply(BigDecimal.valueOf(100L)).longValue();
        PayRequest payRequest = PayRequest.builder().merchantCode(req.getMerchantCode()).outTradeNo(flowNo).amount(amountFen).notifyUrl(req.getNotifyUrl()).channel(this.getChannelCode()).subject(req.getSubject()).tradeType(this.getTradeType()).build();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("payRequest", JSONObject.toJSONString((Object)payRequest));
        log.info("[{}][{}] \u53d1\u8d77\u5185\u90e8\u652f\u4ed8\u8c03\u7528: {}", new Object[]{this.getLogPrefix(), traceId, ACTION_PAYMENT_REQ});
        Object resultObj = this.internalRouter.inInvoke(ACTION_PAYMENT_REQ, "1.0", "0", paramMap);
        String resultStr = String.valueOf(resultObj);
        try {
            PaymentResult pr = (PaymentResult)JSONObject.parseObject((String)resultStr, PaymentResult.class);
            log.info("[{}][{}] \u8c03\u7528\u5b8c\u6210: {}", new Object[]{this.getLogPrefix(), traceId, JSONObject.toJSONString((Object)pr)});
            return pr;
        }
        catch (Exception e) {
            log.error("[{}][{}] \u8fd4\u56de\u89e3\u6790\u5931\u8d25: {}", new Object[]{this.getLogPrefix(), traceId, e.getMessage(), e});
            throw new RuntimeException("\u652f\u4ed8\u8fd4\u56de\u89e3\u6790\u5931\u8d25", e);
        }
    }
}

