/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.biz.OrderPaymentFlowService;
import com.yqbsoft.laser.service.contract.domain.BizPaymentFlow;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.enums.OrderStatusEnum;
import com.yqbsoft.laser.service.contract.requery.PayCallbackRequery;
import com.yqbsoft.laser.service.contract.requery.PayOrderRequery;
import com.yqbsoft.laser.service.contract.requery.PayRequest;
import com.yqbsoft.laser.service.contract.result.PaymentResult;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OrderPaymentService;
import com.yqbsoft.laser.service.contract.utils.FlowNoGenerator;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="orderPaymentService")
public class OrderPaymentServiceImpl
extends BaseServiceImpl
implements OrderPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OrderPaymentServiceImpl.class);
    private final Environment env;
    private final OrderPaymentFlowService orderPaymentFlowService;
    protected final OcContractEngineService contractEngineService;
    protected final OcContractService contractService;
    private final InternalRouter internalRouter;
    private static final String ACTION_PAYMENT_REQ = "middle.payment.pay";

    @Override
    public String orderPayment(PayOrderRequery req) throws Exception {
        String orderNo = req.getOrderNo();
        String traceId = UUID.randomUUID().toString();
        log.info("[Payment][{}] \u5f00\u59cb\u5904\u7406\u652f\u4ed8\u8bf7\u6c42, orderNo={}", (Object)traceId, (Object)orderNo);
        BizPaymentFlow exist = this.orderPaymentFlowService.getProcessingPaymentFlow(orderNo);
        if (exist != null) {
            log.info("[Payment][{}] \u5df2\u5b58\u5728\u652f\u4ed8\u6d41\u6c34\uff0c\u76f4\u63a5\u8fd4\u56de", (Object)traceId);
            return Optional.ofNullable(exist.getQrCodeUrl()).orElse(exist.getPayUrl());
        }
        String flowNo = FlowNoGenerator.generate("PAY");
        PaymentResult pr = this.pay(req, flowNo, traceId);
        BizPaymentFlow flow = BizPaymentFlow.builder().flowNo(flowNo).orderNo(orderNo).customerCode(req.getCustomerCode()).merchantCode(req.getMerchantCode()).flowType(BizPaymentFlow.FlowType.PAYMENT).channel(pr.getChannel() == null ? "CMB" : pr.getChannel()).payType(pr.getQrCodeContent() != null ? "QR_CODE" : "OFFLINE").currency("CNY").amount(req.getAmount().multiply(BigDecimal.valueOf(100L)).longValue()).traceId(traceId).paymentOrderNo(pr.getPaymentOrderNo()).qrCodeUrl(pr.getQrCodeContent()).remark(pr.getRawResponse()).status(BizPaymentFlow.FlowStatus.INIT).createdAt(LocalDateTime.now()).updatedAt(LocalDateTime.now()).build();
        if (pr.isSuccess()) {
            flow.setStatus(BizPaymentFlow.FlowStatus.PROCESSING);
            this.orderPaymentFlowService.createPaymentFlow(flow);
            log.info("[Payment][{}] flow created: {}", (Object)traceId, (Object)flowNo);
            String finalQr = this.rewriteQrUrl(pr.getQrCodeContent());
            log.info("[Payment][{}] \u652f\u4ed8\u6d41\u6c34\u521b\u5efa\u6210\u529f, QR={}", (Object)traceId, (Object)finalQr);
            if (pr.getQrCodeContent() != null) {
                return this.rewriteQrUrl(pr.getQrCodeContent());
            }
            return pr.getRawResponse();
        }
        flow.setStatus(BizPaymentFlow.FlowStatus.FAIL);
        this.orderPaymentFlowService.createPaymentFlow(flow);
        log.error("[Payment][{}] \u652f\u4ed8\u4e1a\u52a1\u5931\u8d25: {}, {}", new Object[]{traceId, pr.getErrorCode(), pr.getErrorMessage()});
        throw new RuntimeException(pr.getErrorMessage());
    }

    private PaymentResult pay(PayOrderRequery req, String flowNo, String traceId) {
        long amountFen = req.getAmount().multiply(BigDecimal.valueOf(100L)).longValue();
        String channel = req.getChannel() == null ? "CMB" : req.getChannel();
        PayRequest payRequest = PayRequest.builder().merchantCode(req.getMerchantCode()).outTradeNo(flowNo).amount(amountFen).notifyUrl(req.getNotifyUrl()).channel(channel).subject(req.getSubject()).tradeType(channel.equals("CMB") ? "QR_CODE" : "OFFLINE").build();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("payRequest", JSONObject.toJSONString((Object)payRequest));
        log.info("[{}][{}] \u53d1\u8d77\u5185\u90e8\u652f\u4ed8\u8c03\u7528: {}", new Object[]{payRequest.getTradeType(), traceId, ACTION_PAYMENT_REQ});
        Object resultObj = this.internalRouter.inInvoke(ACTION_PAYMENT_REQ, "1.0", "0", paramMap);
        String resultStr = String.valueOf(resultObj);
        try {
            PaymentResult pr = (PaymentResult)JSONObject.parseObject((String)resultStr, PaymentResult.class);
            log.info("[{}][{}] \u8c03\u7528\u5b8c\u6210: {}", new Object[]{payRequest.getTradeType(), traceId, JSONObject.toJSONString((Object)pr)});
            return pr;
        }
        catch (Exception e) {
            log.error("[{}][{}] \u8fd4\u56de\u89e3\u6790\u5931\u8d25: {}", new Object[]{payRequest.getTradeType(), traceId, e.getMessage(), e});
            throw new RuntimeException("\u652f\u4ed8\u8fd4\u56de\u89e3\u6790\u5931\u8d25", e);
        }
    }

    private String rewriteQrUrl(String original) {
        if (original == null) {
            return null;
        }
        String profile = this.env.getProperty("spring.profiles.active", "");
        if (!profile.contains("dev")) {
            return original;
        }
        String originDomain = "https://qr.95516.com";
        String targetDomain = "http://payment-uat.cs.cmburl.cn";
        if (original.startsWith(originDomain)) {
            return targetDomain + original.substring(originDomain.length());
        }
        return original;
    }

    @Override
    public BizPaymentFlow payCallback(PayCallbackRequery payCallbackRequery) throws Exception {
        log.info("=====OrderPaymentServiceImpl==payCallback======={}", (Object)payCallbackRequery);
        BizPaymentFlow flow = this.orderPaymentFlowService.getPaymentFlowByNo(payCallbackRequery.getFlowNo());
        log.info("=====OrderPaymentServiceImpl==flow======={}", (Object)flow);
        flow.setPaymentOrderNo(payCallbackRequery.getPaymentOrderNo());
        flow.setStatus(BizPaymentFlow.FlowStatus.SUCCESS);
        flow.setUpdatedAt(LocalDateTime.now());
        this.orderPaymentFlowService.update(flow);
        OcContractReDomain ocContractReDomain = this.getContractByCode(flow.getOrderNo());
        ocContractReDomain.setDataBmoney((ocContractReDomain.getDataBmoney() != null ? ocContractReDomain.getDataBmoney() : BigDecimal.ZERO).add(new BigDecimal(flow.getAmount())));
        this.contractService.updateContract(ocContractReDomain);
        if (ocContractReDomain.getDataState().intValue() == OrderStatusEnum.TO_PAY.getCode()) {
            this.contractEngineService.sendContractNext(flow.getOrderNo(), ocContractReDomain.getTenantCode(), null);
        }
        return flow;
    }

    private OcContractReDomain getContractByCode(String bizId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", bizId);
        OcContractReDomain contract = this.contractService.getContractByCode(map);
        if (contract == null) {
            throw new IllegalArgumentException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01\u8ba2\u5355\u53f7\uff1a" + bizId);
        }
        return contract;
    }

    public OrderPaymentServiceImpl(Environment env, OrderPaymentFlowService orderPaymentFlowService, OcContractEngineService contractEngineService, OcContractService contractService, InternalRouter internalRouter) {
        this.env = env;
        this.orderPaymentFlowService = orderPaymentFlowService;
        this.contractEngineService = contractEngineService;
        this.contractService = contractService;
        this.internalRouter = internalRouter;
    }
}

